package ONVIF::PTZ::Types::ProblemActionType;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.w3.org/2005/08/addressing' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %Action_of :ATTR(:get<Action>);
my %SoapAction_of :ATTR(:get<SoapAction>);

__PACKAGE__->_factory(
    [ qw(        Action
        SoapAction

    ) ],
    {
        'Action' => \%Action_of,
        'SoapAction' => \%SoapAction_of,
    },
    {
        'Action' => 'ONVIF::PTZ::Elements::Action',

        'SoapAction' => 'SOAP::WSDL::XSD::Typelib::Builtin::anyURI',
    },
    {

        'Action' => '',
        'SoapAction' => 'SoapAction',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

ONVIF::PTZ::Types::ProblemActionType

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
ProblemActionType from the namespace http://www.w3.org/2005/08/addressing.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * Action

Note: The name of this property has been altered, because it didn't match
perl's notion of variable/subroutine names. The altered name is used in
perl code only, XML output uses the original name:

 


=item * SoapAction




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::PTZ::Types::ProblemActionType
   Action =>  { value => $some_value },
   SoapAction =>  $some_value, # anyURI
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

