/* Copyright (C) 2013-2016, The Regents of The University of Michigan.
All rights reserved.
This software was developed in the APRIL Robotics Lab under the
direction of Edwin Olson, ebolson@umich.edu. This software may be
available under alternative licensing terms; contact the address above.
Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
1. Redistributions of source code must retain the above copyright notice, this
   list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
The views and conclusions contained in the software and documentation are those
of the authors and should not be interpreted as representing official policies,
either expressed or implied, of the Regents of The University of Michigan.
*/

/*
// https://github.com/opencv/opencv/blob/3e43d0cfca9753bcc4983f610b75d70c3f25f0cd/modules/objdetect/src/aruco/predefined_dictionaries.hpp
Copyright 2025 OpenCV

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

#include <stdlib.h>
#include "tagAruco5x5_1000.h"

static uint64_t codedata[1000] = {
    0x000000000152c6e3UL,
    0x0000000000158da8UL,
    0x0000000001b977e8UL,
    0x00000000010bddc5UL,
    0x0000000001bb840fUL,
    0x0000000001d4b600UL,
    0x0000000000cfc7b5UL,
    0x0000000000e99b01UL,
    0x000000000110c85eUL,
    0x000000000125f4a7UL,
    0x000000000137383aUL,
    0x0000000001aa21b1UL,
    0x0000000001f83066UL,
    0x00000000005c8d1fUL,
    0x0000000001f7a29bUL,
    0x000000000046df76UL,
    0x00000000009f4366UL,
    0x0000000000be9f2aUL,
    0x0000000000fd2594UL,
    0x000000000119a385UL,
    0x000000000132f579UL,
    0x0000000001470112UL,
    0x000000000169f088UL,
    0x0000000000ac0fe9UL,
    0x0000000001969819UL,
    0x0000000001b2e945UL,
    0x0000000001cb7ab0UL,
    0x0000000000280d30UL,
    0x00000000002fc969UL,
    0x0000000000309a62UL,
    0x000000000039cf27UL,
    0x00000000003eb940UL,
    0x0000000000420f91UL,
    0x00000000004a23aaUL,
    0x0000000000588af4UL,
    0x00000000006dabbeUL,
    0x000000000086e6a8UL,
    0x00000000008a1015UL,
    0x00000000008f364eUL,
    0x000000000099a943UL,
    0x0000000000b0f40aUL,
    0x0000000000b16ee6UL,
    0x0000000000c4bddcUL,
    0x0000000000c873c4UL,
    0x0000000000cdb07bUL,
    0x0000000000e0cb7aUL,
    0x0000000000e27ccfUL,
    0x0000000000e46c18UL,
    0x0000000000f6d405UL,
    0x0000000000ff1de7UL,
    0x00000000010ce599UL,
    0x00000000010e9379UL,
    0x00000000011c3a0bUL,
    0x00000000011f1501UL,
    0x00000000013a6b3fUL,
    0x00000000014636bcUL,
    0x000000000147c1ecUL,
    0x0000000001493fe6UL,
    0x0000000001589c29UL,
    0x00000000015fa835UL,
    0x00000000016ef1f5UL,
    0x000000000172a654UL,
    0x0000000001762cafUL,
    0x0000000001803ca8UL,
    0x00000000018557f4UL,
    0x0000000001922ab6UL,
    0x000000000193d68cUL,
    0x0000000001afb294UL,
    0x0000000001afb94fUL,
    0x0000000001e3c859UL,
    0x0000000001f9c216UL,
    0x0000000000f54a13UL,
    0x0000000001a47961UL,
    0x000000000007b538UL,
    0x00000000002a126bUL,
    0x000000000086309eUL,
    0x0000000000a10668UL,
    0x0000000001424346UL,
    0x0000000001904707UL,
    0x00000000019e8615UL,
    0x0000000001ee88bdUL,
    0x000000000000d4eaUL,
    0x000000000007e18bUL,
    0x000000000009c759UL,
    0x00000000000b9f34UL,
    0x00000000000c52a2UL,
    0x00000000000e9cb1UL,
    0x000000000010393cUL,
    0x00000000001835b7UL,
    0x00000000001a762aUL,
    0x00000000001d656dUL,
    0x000000000026b35aUL,
    0x00000000002cb827UL,
    0x0000000000311d2bUL,
    0x0000000000335a4eUL,
    0x00000000003b368dUL,
    0x00000000003bc914UL,
    0x00000000003fb5dfUL,
    0x00000000004da1a1UL,
    0x000000000053b7e0UL,
    0x00000000005530a6UL,
    0x00000000005753b3UL,
    0x00000000005a4212UL,
    0x00000000005ae3edUL,
    0x00000000005b0355UL,
    0x00000000005f0f7bUL,
    0x000000000060428eUL,
    0x00000000006096a5UL,
    0x000000000063b00bUL,
    0x00000000006f01c6UL,
    0x0000000000708980UL,
    0x000000000073ea78UL,
    0x0000000000815209UL,
    0x000000000082f7ddUL,
    0x000000000089b5abUL,
    0x00000000008b8a0dUL,
    0x000000000091976eUL,
    0x0000000000954868UL,
    0x00000000009b985eUL,
    0x00000000009ddbc8UL,
    0x0000000000a53a7eUL,
    0x0000000000a6efb3UL,
    0x0000000000a9e1f6UL,
    0x0000000000ad8dd7UL,
    0x0000000000b4c867UL,
    0x0000000000b891a4UL,
    0x0000000000ba7f81UL,
    0x0000000000bb2811UL,
    0x0000000000bc3f74UL,
    0x0000000000be72eeUL,
    0x0000000000cb3498UL,
    0x0000000000cb6f6cUL,
    0x0000000000d1a8baUL,
    0x0000000000d83a8dUL,
    0x0000000000e1fac2UL,
    0x0000000000e7103cUL,
    0x0000000000ed4975UL,
    0x0000000000f026b3UL,
    0x0000000000faf534UL,
    0x000000000101225cUL,
    0x00000000010e4832UL,
    0x00000000011179ddUL,
    0x00000000011599f4UL,
    0x000000000120b9baUL,
    0x000000000126ac68UL,
    0x000000000129332fUL,
    0x000000000130e02dUL,
    0x000000000139af1cUL,
    0x00000000013d2fb2UL,
    0x00000000013f7184UL,
    0x00000000014157c3UL,
    0x000000000143160eUL,
    0x0000000001445a16UL,
    0x00000000014d44abUL,
    0x00000000015ed0daUL,
    0x0000000001613d91UL,
    0x000000000161a061UL,
    0x000000000167d51dUL,
    0x00000000017672c8UL,
    0x000000000179c5c4UL,
    0x00000000017a9343UL,
    0x00000000017e27ecUL,
    0x00000000017fbd0aUL,
    0x000000000181819fUL,
    0x0000000001864c3dUL,
    0x000000000189103aUL,
    0x00000000018d1d98UL,
    0x000000000190144dUL,
    0x000000000190ef4aUL,
    0x0000000001977215UL,
    0x00000000019df438UL,
    0x00000000019e15b4UL,
    0x0000000001a109c4UL,
    0x0000000001a566baUL,
    0x0000000001ad5225UL,
    0x0000000001afe505UL,
    0x0000000001b050a3UL,
    0x0000000001b2ce22UL,
    0x0000000001b717cbUL,
    0x0000000001b734a0UL,
    0x0000000001bca013UL,
    0x0000000001bd68e5UL,
    0x0000000001c41d87UL,
    0x0000000001c82fcbUL,
    0x0000000001c9f151UL,
    0x0000000001ccddfbUL,
    0x0000000001cec510UL,
    0x0000000001de2263UL,
    0x0000000001deca7fUL,
    0x0000000001e40822UL,
    0x0000000001e5aca4UL,
    0x0000000001f11108UL,
    0x0000000001f19eebUL,
    0x0000000001f46bfeUL,
    0x0000000001f59172UL,
    0x0000000001f71885UL,
    0x0000000001f9b1b9UL,
    0x0000000001fbd3ddUL,
    0x0000000001fc920fUL,
    0x0000000001fdc6f0UL,
    0x0000000000c44f53UL,
    0x00000000012d3c61UL,
    0x00000000012e5703UL,
    0x0000000001c3366bUL,
    0x00000000002c17caUL,
    0x000000000056d120UL,
    0x0000000000621da8UL,
    0x00000000007ad388UL,
    0x00000000007c3cfeUL,
    0x0000000000b042d8UL,
    0x0000000000b8995bUL,
    0x0000000000d0c14fUL,
    0x0000000000f8ee30UL,
    0x0000000000fcbbddUL,
    0x00000000011f29e4UL,
    0x00000000014bce2cUL,
    0x00000000014c4df5UL,
    0x0000000001688f2fUL,
    0x000000000173d847UL,
    0x000000000182c3acUL,
    0x000000000194c673UL,
    0x0000000001a73d35UL,
    0x0000000001bc666dUL,
    0x0000000001cb3e5cUL,
    0x0000000001cfb468UL,
    0x0000000001e33634UL,
    0x00000000000017fdUL,
    0x0000000000011eb0UL,
    0x000000000001cdd4UL,
    0x00000000000246cdUL,
    0x0000000000035986UL,
    0x0000000000050e49UL,
    0x00000000000546a5UL,
    0x000000000005ecc8UL,
    0x000000000008cbecUL,
    0x00000000000a8672UL,
    0x00000000000bda00UL,
    0x00000000000be9b0UL,
    0x00000000000c8f75UL,
    0x00000000000c9c4aUL,
    0x00000000000ca068UL,
    0x00000000000e7f79UL,
    0x00000000000fa6dcUL,
    0x00000000000fc792UL,
    0x0000000000125406UL,
    0x00000000001308d4UL,
    0x000000000013497eUL,
    0x0000000000136d39UL,
    0x000000000015a41bUL,
    0x000000000015dac7UL,
    0x0000000000161bf0UL,
    0x000000000017e8b3UL,
    0x00000000001bf598UL,
    0x00000000001d4803UL,
    0x00000000001e464eUL,
    0x00000000001e8c2dUL,
    0x00000000001fedfaUL,
    0x0000000000217183UL,
    0x0000000000220be6UL,
    0x00000000002396dfUL,
    0x000000000024f768UL,
    0x00000000002501f8UL,
    0x000000000027e320UL,
    0x00000000002b543fUL,
    0x00000000002bbc05UL,
    0x00000000002c55d4UL,
    0x00000000003002c3UL,
    0x0000000000314774UL,
    0x000000000034e359UL,
    0x00000000003643e9UL,
    0x0000000000365d3dUL,
    0x000000000037a0d6UL,
    0x0000000000397e12UL,
    0x00000000003ba34cUL,
    0x00000000003ca9eaUL,
    0x00000000003d8bf0UL,
    0x00000000003de437UL,
    0x00000000003df44eUL,
    0x00000000003e0dc5UL,
    0x000000000040abc5UL,
    0x000000000041a6a2UL,
    0x0000000000449864UL,
    0x0000000000459f1aUL,
    0x000000000048678dUL,
    0x0000000000492247UL,
    0x00000000004e29fbUL,
    0x00000000004e48c0UL,
    0x000000000050413aUL,
    0x000000000050d248UL,
    0x000000000050e452UL,
    0x0000000000511299UL,
    0x000000000051c8f9UL,
    0x000000000052422dUL,
    0x0000000000541592UL,
    0x0000000000550b5eUL,
    0x0000000000593833UL,
    0x000000000059c0a0UL,
    0x00000000005a3758UL,
    0x00000000005af10eUL,
    0x00000000005d535bUL,
    0x00000000005db554UL,
    0x0000000000610a65UL,
    0x000000000061b41cUL,
    0x000000000061c840UL,
    0x0000000000631373UL,
    0x000000000064dd5bUL,
    0x0000000000653e58UL,
    0x000000000066c2f5UL,
    0x000000000066cf8cUL,
    0x000000000067f2b2UL,
    0x000000000068b324UL,
    0x000000000068d7dfUL,
    0x000000000069dc9eUL,
    0x00000000006d56e7UL,
    0x00000000006e2771UL,
    0x00000000006e5c1cUL,
    0x00000000006ee096UL,
    0x00000000006f6133UL,
    0x00000000006f7064UL,
    0x0000000000712329UL,
    0x000000000071aa87UL,
    0x000000000071f8bfUL,
    0x0000000000732dccUL,
    0x0000000000742175UL,
    0x000000000075cd66UL,
    0x0000000000786b6eUL,
    0x000000000078ac0cUL,
    0x000000000078d0d4UL,
    0x00000000007b0f2cUL,
    0x00000000007bc2d3UL,
    0x00000000007d47e8UL,
    0x00000000007f01b9UL,
    0x0000000000824af4UL,
    0x00000000008445ceUL,
    0x00000000008559c3UL,
    0x000000000085ef9fUL,
    0x0000000000875475UL,
    0x0000000000875e22UL,
    0x000000000087904fUL,
    0x000000000088bc10UL,
    0x00000000008d81edUL,
    0x00000000008f9b67UL,
    0x0000000000906ba9UL,
    0x0000000000907df2UL,
    0x0000000000922c0fUL,
    0x0000000000926f9aUL,
    0x0000000000928d7fUL,
    0x000000000095da74UL,
    0x00000000009616e8UL,
    0x00000000009704adUL,
    0x000000000098dca5UL,
    0x00000000009950ddUL,
    0x0000000000998c33UL,
    0x00000000009b19c9UL,
    0x00000000009d3dceUL,
    0x00000000009e212cUL,
    0x0000000000a053e2UL,
    0x0000000000a08d4eUL,
    0x0000000000a31ac3UL,
    0x0000000000a38296UL,
    0x0000000000a3d99dUL,
    0x0000000000a41ca5UL,
    0x0000000000a689ebUL,
    0x0000000000a78c71UL,
    0x0000000000a8b796UL,
    0x0000000000a8d7b9UL,
    0x0000000000a9ff2eUL,
    0x0000000000aa1c89UL,
    0x0000000000abc261UL,
    0x0000000000af39f0UL,
    0x0000000000afac66UL,
    0x0000000000b05d5cUL,
    0x0000000000b2a0c1UL,
    0x0000000000b332aaUL,
    0x0000000000b48168UL,
    0x0000000000b48fe4UL,
    0x0000000000b4bc32UL,
    0x0000000000b4beafUL,
    0x0000000000b5568aUL,
    0x0000000000b62515UL,
    0x0000000000b80a3bUL,
    0x0000000000b847ffUL,
    0x0000000000b91363UL,
    0x0000000000b96048UL,
    0x0000000000b9de7aUL,
    0x0000000000b9ebf9UL,
    0x0000000000ba4dd6UL,
    0x0000000000bd23c7UL,
    0x0000000000bd370cUL,
    0x0000000000bdbe99UL,
    0x0000000000be00a7UL,
    0x0000000000befbe3UL,
    0x0000000000bf2f41UL,
    0x0000000000bf387dUL,
    0x0000000000bf84f4UL,
    0x0000000000c01310UL,
    0x0000000000c1f678UL,
    0x0000000000c2b282UL,
    0x0000000000c56f90UL,
    0x0000000000c7d37dUL,
    0x0000000000cf3ac4UL,
    0x0000000000cf597eUL,
    0x0000000000cfae4bUL,
    0x0000000000d00d98UL,
    0x0000000000d3dcabUL,
    0x0000000000d3f022UL,
    0x0000000000d4f2b0UL,
    0x0000000000d53959UL,
    0x0000000000d9a41eUL,
    0x0000000000da64ccUL,
    0x0000000000db1522UL,
    0x0000000000dd12b7UL,
    0x0000000000ddb08aUL,
    0x0000000000de1b03UL,
    0x0000000000df9abcUL,
    0x0000000000e2d1c4UL,
    0x0000000000e3e0aeUL,
    0x0000000000e917f1UL,
    0x0000000000ea9c73UL,
    0x0000000000eb8484UL,
    0x0000000000eb8bf4UL,
    0x0000000000ebf5dbUL,
    0x0000000000ec424fUL,
    0x0000000000eccfbfUL,
    0x0000000000ed9c2eUL,
    0x0000000000ef2fa0UL,
    0x0000000000ef6cafUL,
    0x0000000000eff4b1UL,
    0x0000000000f08704UL,
    0x0000000000f2b04cUL,
    0x0000000000f3049bUL,
    0x0000000000f59b2dUL,
    0x0000000000f91997UL,
    0x0000000000f9dd69UL,
    0x0000000000fa25efUL,
    0x0000000000fe3009UL,
    0x0000000000fe31b6UL,
    0x0000000000ffc55cUL,
    0x0000000001005c92UL,
    0x000000000100eb53UL,
    0x00000000010180d2UL,
    0x000000000102b443UL,
    0x000000000103433bUL,
    0x000000000103bbb7UL,
    0x0000000001043ab5UL,
    0x00000000010451a7UL,
    0x0000000001048a27UL,
    0x0000000001083eafUL,
    0x0000000001094e37UL,
    0x00000000010a51b0UL,
    0x00000000010b391bUL,
    0x00000000010bc416UL,
    0x00000000010c33f3UL,
    0x00000000010eb514UL,
    0x00000000010ef64aUL,
    0x00000000010fb887UL,
    0x0000000001142344UL,
    0x000000000116c609UL,
    0x000000000117d3deUL,
    0x0000000001190865UL,
    0x0000000001190bf9UL,
    0x00000000011aa928UL,
    0x00000000011ab1d1UL,
    0x00000000011b6a59UL,
    0x00000000011c5d72UL,
    0x00000000011cc0e6UL,
    0x00000000011e07a3UL,
    0x00000000011eeab8UL,
    0x00000000011f5bbaUL,
    0x0000000001218a0bUL,
    0x0000000001224f34UL,
    0x000000000123afe4UL,
    0x000000000124ea9fUL,
    0x000000000125c386UL,
    0x000000000127116eUL,
    0x0000000001274de0UL,
    0x0000000001279f52UL,
    0x0000000001298aa6UL,
    0x000000000129edffUL,
    0x00000000012ab628UL,
    0x00000000012be0ddUL,
    0x00000000012f620aUL,
    0x00000000012f8198UL,
    0x00000000013166fdUL,
    0x000000000131d05bUL,
    0x000000000132db6bUL,
    0x0000000001340778UL,
    0x0000000001344237UL,
    0x0000000001345ee0UL,
    0x0000000001359733UL,
    0x0000000001374b28UL,
    0x0000000001386162UL,
    0x000000000139175aUL,
    0x00000000013bc06eUL,
    0x00000000013c7d27UL,
    0x00000000013ca18fUL,
    0x00000000013d94baUL,
    0x00000000013f44d7UL,
    0x00000000013fc21fUL,
    0x0000000001403cd7UL,
    0x00000000014049d9UL,
    0x000000000141cbb6UL,
    0x0000000001438f5dUL,
    0x00000000014391e3UL,
    0x0000000001469055UL,
    0x000000000146f729UL,
    0x000000000146f9cbUL,
    0x00000000014a0d21UL,
    0x00000000014b88e4UL,
    0x00000000014cc89eUL,
    0x00000000014dd263UL,
    0x00000000014dde85UL,
    0x00000000014e35caUL,
    0x00000000014fd8b9UL,
    0x000000000150266fUL,
    0x000000000152378bUL,
    0x000000000154631bUL,
    0x000000000155c131UL,
    0x000000000156e0cdUL,
    0x000000000156ed75UL,
    0x0000000001575afcUL,
    0x000000000159305aUL,
    0x00000000015a6b95UL,
    0x00000000015adc64UL,
    0x00000000015bc55bUL,
    0x00000000015c79f8UL,
    0x00000000015edb4dUL,
    0x00000000015f633dUL,
    0x00000000015fa7b4UL,
    0x000000000160a48bUL,
    0x00000000016132bbUL,
    0x00000000016244deUL,
    0x0000000001640b43UL,
    0x000000000165707fUL,
    0x0000000001657201UL,
    0x000000000166115bUL,
    0x0000000001665c81UL,
    0x000000000167d37aUL,
    0x000000000169026aUL,
    0x00000000016925f3UL,
    0x00000000016abdf0UL,
    0x00000000016b4be5UL,
    0x00000000016b5f80UL,
    0x00000000016b9587UL,
    0x00000000016bfe59UL,
    0x00000000016cd182UL,
    0x00000000016d50b0UL,
    0x00000000016e84d3UL,
    0x00000000016f6cf6UL,
    0x0000000001703828UL,
    0x00000000017364b7UL,
    0x0000000001738a33UL,
    0x000000000173b4d1UL,
    0x000000000174fdbeUL,
    0x0000000001756934UL,
    0x0000000001771452UL,
    0x0000000001780092UL,
    0x000000000178f33aUL,
    0x00000000017a02f9UL,
    0x00000000017a68acUL,
    0x00000000017ba6e6UL,
    0x00000000017eadc6UL,
    0x00000000017f53c1UL,
    0x00000000017f59b7UL,
    0x00000000017f761eUL,
    0x000000000180a3f9UL,
    0x000000000184a303UL,
    0x0000000001871bacUL,
    0x000000000188377eUL,
    0x0000000001894086UL,
    0x0000000001898fbcUL,
    0x000000000189e7e7UL,
    0x00000000018a2982UL,
    0x00000000018b2426UL,
    0x00000000018bff20UL,
    0x00000000018c7fc5UL,
    0x00000000018e4fdaUL,
    0x00000000018f3fa3UL,
    0x00000000018fa9b6UL,
    0x00000000018fda1cUL,
    0x0000000001917e3bUL,
    0x000000000191e17fUL,
    0x00000000019358efUL,
    0x0000000001940076UL,
    0x0000000001977b4bUL,
    0x00000000019a135bUL,
    0x00000000019d5cf1UL,
    0x00000000019f8f6cUL,
    0x0000000001a1f691UL,
    0x0000000001a38d32UL,
    0x0000000001a4a046UL,
    0x0000000001a69e5cUL,
    0x0000000001aaa0faUL,
    0x0000000001aace94UL,
    0x0000000001abc93fUL,
    0x0000000001abd38bUL,
    0x0000000001acb39bUL,
    0x0000000001ad6beaUL,
    0x0000000001ad8923UL,
    0x0000000001af0714UL,
    0x0000000001b1d3f1UL,
    0x0000000001b263e4UL,
    0x0000000001b345c1UL,
    0x0000000001b386b5UL,
    0x0000000001b5c32bUL,
    0x0000000001b5c64eUL,
    0x0000000001b690d4UL,
    0x0000000001b8953fUL,
    0x0000000001bb272bUL,
    0x0000000001bc18a8UL,
    0x0000000001be1e7bUL,
    0x0000000001bfe3b2UL,
    0x0000000001c31ee0UL,
    0x0000000001c36d84UL,
    0x0000000001c49b5fUL,
    0x0000000001c68beeUL,
    0x0000000001c86329UL,
    0x0000000001c8b9e8UL,
    0x0000000001cba1c5UL,
    0x0000000001cbb2eeUL,
    0x0000000001cbf5b6UL,
    0x0000000001d06ae0UL,
    0x0000000001d08443UL,
    0x0000000001d10cf5UL,
    0x0000000001d26419UL,
    0x0000000001d3081cUL,
    0x0000000001d52090UL,
    0x0000000001d64294UL,
    0x0000000001d79216UL,
    0x0000000001d89f62UL,
    0x0000000001d917adUL,
    0x0000000001dab994UL,
    0x0000000001db559fUL,
    0x0000000001dbcda7UL,
    0x0000000001dd65a8UL,
    0x0000000001dea1abUL,
    0x0000000001df2650UL,
    0x0000000001df8349UL,
    0x0000000001e15912UL,
    0x0000000001e16ef1UL,
    0x0000000001e1f36bUL,
    0x0000000001e26232UL,
    0x0000000001e3c1d2UL,
    0x0000000001e42d92UL,
    0x0000000001e74e6fUL,
    0x0000000001e77adbUL,
    0x0000000001ec5a9aUL,
    0x0000000001ed0dfeUL,
    0x0000000001eef8c4UL,
    0x0000000001f19834UL,
    0x0000000001f3ddceUL,
    0x0000000001f7fcbdUL,
    0x0000000001f8d552UL,
    0x0000000001f95ac9UL,
    0x0000000001f9fa65UL,
    0x0000000001fb4f1aUL,
    0x0000000001fc7a3fUL,
    0x0000000001fd3a9cUL,
    0x0000000001fe4990UL,
    0x0000000001fee44bUL,
    0x00000000002e5d93UL,
    0x00000000014ebe63UL,
    0x00000000000050d3UL,
    0x0000000000026995UL,
    0x00000000000607b0UL,
    0x0000000000066c16UL,
    0x000000000006ca5fUL,
    0x000000000006d740UL,
    0x00000000000800b7UL,
    0x0000000000080451UL,
    0x000000000009fd17UL,
    0x00000000000cca88UL,
    0x00000000000d7db9UL,
    0x00000000001063feUL,
    0x000000000010d723UL,
    0x0000000000116e5eUL,
    0x00000000001230bbUL,
    0x00000000001311d2UL,
    0x0000000000135bedUL,
    0x000000000015ab69UL,
    0x0000000000166ceeUL,
    0x00000000001a3f33UL,
    0x00000000001a4e75UL,
    0x00000000001bde5fUL,
    0x00000000001ea001UL,
    0x000000000020deb3UL,
    0x0000000000212942UL,
    0x0000000000231c54UL,
    0x000000000024e727UL,
    0x0000000000263031UL,
    0x000000000027255aUL,
    0x00000000002733a7UL,
    0x0000000000278608UL,
    0x0000000000282957UL,
    0x000000000028d943UL,
    0x0000000000290d9bUL,
    0x0000000000299b8aUL,
    0x00000000002b650fUL,
    0x00000000002b9059UL,
    0x00000000002e416aUL,
    0x00000000002e923eUL,
    0x0000000000301c77UL,
    0x000000000030a064UL,
    0x000000000031904cUL,
    0x000000000034bfd2UL,
    0x0000000000367fcfUL,
    0x0000000000368d9aUL,
    0x0000000000378a24UL,
    0x000000000037bc53UL,
    0x00000000003864bdUL,
    0x00000000003896e7UL,
    0x00000000003cdc15UL,
    0x00000000003d58e2UL,
    0x00000000003ecc42UL,
    0x00000000003f9cccUL,
    0x0000000000404577UL,
    0x000000000042e54cUL,
    0x0000000000446a31UL,
    0x00000000004513b8UL,
    0x000000000045b44dUL,
    0x0000000000461c2aUL,
    0x00000000004a7eecUL,
    0x00000000004adc8dUL,
    0x00000000004b31f6UL,
    0x000000000050f4e5UL,
    0x00000000005107c5UL,
    0x0000000000556348UL,
    0x0000000000557f52UL,
    0x0000000000582b5bUL,
    0x00000000005864ebUL,
    0x0000000000595e2bUL,
    0x00000000005b2226UL,
    0x00000000005b3c81UL,
    0x00000000005dd97dUL,
    0x0000000000605752UL,
    0x00000000006085d1UL,
    0x000000000062713fUL,
    0x000000000067684eUL,
    0x000000000067a717UL,
    0x0000000000680bc0UL,
    0x000000000069bce6UL,
    0x000000000069ffb0UL,
    0x00000000006c5448UL,
    0x00000000006fca5cUL,
    0x0000000000739f99UL,
    0x000000000073f76cUL,
    0x000000000075497bUL,
    0x000000000076845dUL,
    0x000000000077342bUL,
    0x00000000007736c6UL,
    0x000000000077a3efUL,
    0x0000000000784377UL,
    0x00000000007a2746UL,
    0x00000000007c012fUL,
    0x00000000007c79b1UL,
    0x00000000007e1f52UL,
    0x00000000007fd571UL,
    0x00000000008384e2UL,
    0x000000000088c603UL,
    0x000000000089e925UL,
    0x00000000008a592bUL,
    0x00000000008b4839UL,
    0x00000000008ce4a3UL,
    0x0000000000901ed3UL,
    0x0000000000957d14UL,
    0x0000000000967560UL,
    0x000000000096cd81UL,
    0x000000000098769eUL,
    0x000000000099cae2UL,
    0x00000000009a8b93UL,
    0x00000000009d1f5fUL,
    0x00000000009d72a8UL,
    0x00000000009deeecUL,
    0x00000000009ef6ccUL,
    0x0000000000a12eabUL,
    0x0000000000a1a227UL,
    0x0000000000a44caaUL,
    0x0000000000a47ff7UL,
    0x0000000000a67e2bUL,
    0x0000000000a7b0d8UL,
    0x0000000000a7d52bUL,
    0x0000000000aaa2acUL,
    0x0000000000aaa740UL,
    0x0000000000ab67b4UL,
    0x0000000000ad0f25UL,
    0x0000000000add15bUL,
    0x0000000000adff18UL,
    0x0000000000aeca37UL,
    0x0000000000af63ffUL,
    0x0000000000b0e563UL,
    0x0000000000b18e1fUL,
    0x0000000000b30530UL,
    0x0000000000b3d921UL,
    0x0000000000b552e5UL,
    0x0000000000b805f0UL,
    0x0000000000bae83aUL,
    0x0000000000be690bUL,
    0x0000000000c0e241UL,
    0x0000000000c1da94UL,
    0x0000000000c37a03UL,
    0x0000000000c627c9UL,
    0x0000000000c70242UL,
    0x0000000000c90f3fUL,
    0x0000000000c945d5UL,
    0x0000000000ca17faUL,
    0x0000000000cab8dbUL,
    0x0000000000cd5760UL,
    0x0000000000ce6248UL,
    0x0000000000cfd20aUL,
    0x0000000000d17b06UL,
    0x0000000000d23732UL,
    0x0000000000d2b694UL,
    0x0000000000d392e7UL,
    0x0000000000d5143aUL,
    0x0000000000d7084fUL,
    0x0000000000dac2a6UL,
    0x0000000000db1825UL,
    0x0000000000dc9817UL,
    0x0000000000df0553UL,
    0x0000000000e08d1bUL,
    0x0000000000e12340UL,
    0x0000000000e15a5dUL,
    0x0000000000e22e4dUL,
    0x0000000000e56f3eUL,
    0x0000000000e59620UL,
    0x0000000000e776acUL,
    0x0000000000e9721aUL,
    0x0000000000eb6b93UL,
    0x0000000000ebb465UL,
    0x0000000000ec8f90UL,
    0x0000000000ee0affUL,
    0x0000000000ef82e8UL,
    0x0000000000efad7bUL,
    0x0000000000f2206aUL,
    0x0000000000f44e87UL,
    0x0000000000f500aeUL,
    0x0000000000f7b8cbUL,
    0x0000000000f82214UL,
    0x0000000000f93f11UL,
    0x0000000000f9d2a1UL,
    0x0000000001002508UL,
    0x0000000001024751UL,
    0x000000000102e131UL,
    0x00000000010421baUL,
    0x000000000106919fUL,
    0x0000000001075004UL,
    0x0000000001091383UL,
    0x0000000001092d14UL,
    0x000000000109524fUL,
    0x00000000010d9e22UL,
    0x0000000001100b21UL,
    0x00000000011178f6UL,
    0x000000000114df7fUL,
    0x00000000011563e7UL,
    0x000000000116659cUL,
    0x00000000011801dcUL,
    0x00000000011a71a9UL,
    0x00000000011b336cUL,
    0x00000000011d8cc1UL,
    0x00000000011eb747UL,
    0x00000000011ee32eUL,
    0x00000000011f2952UL,
    0x0000000001210f7eUL,
    0x00000000012230e2UL,
    0x0000000001252f1bUL,
    0x000000000125ee66UL,
    0x0000000001269007UL,
    0x000000000129ee5aUL,
    0x00000000012a8f00UL,
    0x00000000012d403eUL,
    0x00000000012e1864UL,
    0x0000000001306731UL,
    0x00000000013233b4UL,
    0x0000000001333a75UL,
    0x000000000133a84fUL,
    0x0000000001350ae1UL,
    0x000000000136e823UL,
    0x00000000013bf256UL,
    0x00000000013cbb5eUL,
    0x00000000013e084aUL,
    0x000000000140dc63UL,
    0x00000000014125edUL,
    0x000000000141bca1UL,
    0x00000000014519c0UL,
    0x0000000001451aefUL,
    0x0000000001456ae8UL,
    0x00000000014720deUL,
    0x00000000014a2f0cUL,
    0x00000000014ae2d2UL,
    0x00000000014c6967UL,
    0x00000000014defe4UL,
    0x00000000014f35a0UL,
    0x000000000150d5a8UL,
    0x000000000152537fUL,
    0x0000000001526700UL,
    0x0000000001543bb2UL,
    0x0000000001544791UL,
    0x0000000001564e45UL,
    0x00000000015bb21dUL,
    0x00000000015c3308UL,
    0x0000000001620360UL,
    0x0000000001624d86UL,
    0x0000000001627835UL,
    0x00000000016363fcUL,
    0x00000000016453d4UL,
    0x000000000164f353UL,
    0x00000000016b3194UL,
    0x00000000016c147aUL,
    0x00000000016db57fUL,
    0x00000000016de2d7UL,
    0x0000000001719197UL,
    0x000000000173696dUL,
    0x00000000017515b4UL,
    0x0000000001783d5cUL,
    0x0000000001788dfdUL,
    0x0000000001796051UL,
    0x00000000017b34ceUL,
    0x00000000017cc39dUL,
    0x00000000017cf40aUL,
    0x00000000017f109bUL,
    0x00000000018060ecUL,
    0x0000000001813841UL,
    0x00000000018287d6UL,
    0x000000000186a81aUL,
    0x00000000018894c1UL,
    0x0000000001893435UL,
    0x00000000018981f0UL,
    0x000000000190bcdeUL,
    0x000000000190f39cUL,
    0x000000000192e850UL,
    0x0000000001982d23UL,
    0x00000000019b5296UL,
    0x00000000019baeefUL,
    0x00000000019eab74UL,
    0x00000000019f7e60UL,
    0x00000000019fe95eUL,
    0x0000000001a22fceUL,
    0x0000000001a3c2ffUL,
    0x0000000001a6c299UL,
    0x0000000001a8c63eUL,
    0x0000000001a97e23UL,
    0x0000000001aab7e3UL,
    0x0000000001ac7614UL,
    0x0000000001ac9129UL,
    0x0000000001acf952UL,
    0x0000000001ad59f9UL,
    0x0000000001af44a1UL,
    0x0000000001b00a70UL,
    0x0000000001b20229UL,
    0x0000000001b2ccc7UL,
    0x0000000001b53ab3UL,
    0x0000000001b6a4f7UL,
    0x0000000001b747a6UL,
    0x0000000001b98b76UL,
    0x0000000001ba5bfcUL,
    0x0000000001bee5e0UL,
    0x0000000001c0dd40UL,
    0x0000000001c379e1UL,
    0x0000000001c3b128UL,
    0x0000000001c4b6a3UL,
    0x0000000001c750f2UL,
    0x0000000001c76f57UL,
    0x0000000001c7ee7cUL,
    0x0000000001c8b297UL,
    0x0000000001ca75c9UL,
    0x0000000001cde475UL,
    0x0000000001d80bc4UL,
    0x0000000001d8467aUL,
    0x0000000001dac7c0UL,
    0x0000000001dc6d05UL,
    0x0000000001dd7be3UL,
    0x0000000001de0c68UL,
    0x0000000001df4c8cUL,
    0x0000000001e04111UL,
    0x0000000001e08cafUL,
    0x0000000001e0ff6cUL,
    0x0000000001e302d5UL,
    0x0000000001e31df3UL,
    0x0000000001e3457fUL,
    0x0000000001e76f48UL,
    0x0000000001e7a031UL,
    0x0000000001e7b1fbUL,
    0x0000000001e9c8f5UL,
    0x0000000001ea1e6eUL,
    0x0000000001ea5717UL,
    0x0000000001eba042UL,
    0x0000000001ec628cUL,
    0x0000000001ecf5a1UL,
    0x0000000001edbaa9UL,
    0x0000000001f07fc3UL,
    0x0000000001f0d049UL,
    0x0000000001f12aacUL,
    0x0000000001f28ea4UL,
    0x0000000001f2cc7aUL,
    0x0000000001f37cd4UL,
    0x0000000001f67122UL,
    0x0000000001f709ecUL,
    0x0000000001fb4677UL,
    0x0000000001fdc4ffUL,
    0x0000000001fe5661UL,
};
apriltag_family_t *tagAruco5x5_1000_create()
{
   apriltag_family_t *tf = calloc(1, sizeof(apriltag_family_t));
   tf->name = strdup("tagAruco5x5_1000");
   tf->h = 5;
   tf->ncodes = 1000;
   tf->codes = codedata;
   tf->nbits = 25;
   tf->bit_x = calloc(25, sizeof(uint32_t));
   tf->bit_y = calloc(25, sizeof(uint32_t));
   tf->bit_x[0] = 1;
   tf->bit_y[0] = 1;
   tf->bit_x[1] = 2;
   tf->bit_y[1] = 1;
   tf->bit_x[2] = 3;
   tf->bit_y[2] = 1;
   tf->bit_x[3] = 4;
   tf->bit_y[3] = 1;
   tf->bit_x[4] = 2;
   tf->bit_y[4] = 2;
   tf->bit_x[5] = 3;
   tf->bit_y[5] = 2;
   tf->bit_x[6] = 5;
   tf->bit_y[6] = 1;
   tf->bit_x[7] = 5;
   tf->bit_y[7] = 2;
   tf->bit_x[8] = 5;
   tf->bit_y[8] = 3;
   tf->bit_x[9] = 5;
   tf->bit_y[9] = 4;
   tf->bit_x[10] = 4;
   tf->bit_y[10] = 2;
   tf->bit_x[11] = 4;
   tf->bit_y[11] = 3;
   tf->bit_x[12] = 5;
   tf->bit_y[12] = 5;
   tf->bit_x[13] = 4;
   tf->bit_y[13] = 5;
   tf->bit_x[14] = 3;
   tf->bit_y[14] = 5;
   tf->bit_x[15] = 2;
   tf->bit_y[15] = 5;
   tf->bit_x[16] = 4;
   tf->bit_y[16] = 4;
   tf->bit_x[17] = 3;
   tf->bit_y[17] = 4;
   tf->bit_x[18] = 1;
   tf->bit_y[18] = 5;
   tf->bit_x[19] = 1;
   tf->bit_y[19] = 4;
   tf->bit_x[20] = 1;
   tf->bit_y[20] = 3;
   tf->bit_x[21] = 1;
   tf->bit_y[21] = 2;
   tf->bit_x[22] = 2;
   tf->bit_y[22] = 4;
   tf->bit_x[23] = 2;
   tf->bit_y[23] = 3;
   tf->bit_x[24] = 3;
   tf->bit_y[24] = 3;
   tf->width_at_border = 7;
   tf->total_width = 9;
   tf->reversed_border = false;
   return tf;
}

void tagAruco5x5_1000_destroy(apriltag_family_t *tf)
{
   free(tf->bit_x);
   free(tf->bit_y);
   free(tf->name);
   free(tf);
}
