/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
#ifndef SKGZOOMSELECTOR_H
#define SKGZOOMSELECTOR_H
/** @file
 * A zoom selector.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include <qtimer.h>
#include "ui_skgzoomselector.h"
#include "skgbasegui_export.h"

/**
 * This file is a zoom selector.
 */
class SKGBASEGUI_EXPORT SKGZoomSelector : public QWidget
{
    Q_OBJECT
    /**
     * Value of the zoom
     */
    Q_PROPERTY(int value READ value WRITE setValue USER true)

    /**
     * Value of the zoom
     */
    Q_PROPERTY(int resetValue READ resetValue WRITE setResetValue)

public:
    /**
     * Default Constructor
     * @param iParent the parent
     */
    explicit SKGZoomSelector(QWidget* iParent);

    /**
     * Default Destructor
     */
    ~SKGZoomSelector() override;

    /**
     * Get the value of the zoom
     * @return the value
     */
    virtual int value() const;

    /**
     * Get the value of the zoom when reseted
     * @return the value
     */
    virtual int resetValue() const;

public Q_SLOTS:
    /**
     * Set the value of the zoom
     * @param iValue the value
     * @param iEmitEvent to emit delayed event
     */
    virtual void setValue(int iValue, bool iEmitEvent = true);

    /**
     * Set the value of the zoom when reseted
     * @param iValue the value
     */
    virtual void setResetValue(int iValue);

    /**
     * Reinitialize zoom
     */
    virtual void initializeZoom();

    /**
     * Zoom in
     */
    virtual void zoomIn();

    /**
     * Zoom out
     */
    virtual void zoomOut();

Q_SIGNALS:
    /**
     * Emitted when the value is changed
     * @param iValue the value
     */
    void changed(int iValue);

private Q_SLOTS:
    void onZoomChanged();
    void onZoomChangedDelayed();

private:
    Ui::skgzoomselector ui;
    QTimer m_timer;

    int m_resetValue;
};

#endif  // SKGZOOMSELECTOR_H
