\name{subspaceDistance}
\alias{subspaceDistance}
\title{
  Distance Between Linear Spaces
}
\description{
  Evaluate the distance between two linear subspaces
  using the measure proposed by Li, Zha and Chiaromonte (2005). 
}
\usage{
subspaceDistance(B0, B1)
}
\arguments{
  \item{B0}{
    Matrix whose columns are a basis for the first subspace.
  }
  \item{B1}{
    Matrix whose columns are a basis for the second subspace.
  }
}
\details{
  This algorithm calculates the maximum absolute value of the
  eigenvalues of \eqn{P1-P0} where \eqn{P0,P1} are the projection
  matrices onto the subspaces generated by \code{B0,B1}.
  This measure of distance was proposed by Li, Zha and Chiaromonte
  (2005). See also Xia (2007).
}
\value{
  A single numeric value.
}
\references{
  Guan, Y. and Wang, H. (2010)
  Sufficient dimension reduction for spatial point
  processes directed by Gaussian random fields.
  \emph{Journal of the Royal Statistical Society, Series B},
  \bold{72}, 367--387.

  Li, B., Zha, H. and Chiaromonte, F. (2005) Contour regression: a
  general approach to dimension reduction. 
  \emph{Annals of Statistics} \bold{33}, 1580--1616.

  Xia, Y. (2007)
  A constructive approach to the estimation of dimension reduction
  directions. 
  \emph{Annals of Statistics} \bold{35}, 2654--2690.
}
\author{
  Matlab original by Yongtao Guan,
  translated to \R by Suman Rakshit.
}
\keyword{multivariate}
\keyword{algebra}
