# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .resource import Resource


class ResourceHealthMetadata(Resource):
    """Used for getting ResourceHealthCheck settings.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :param name: Resource Name.
    :type name: str
    :param kind: Kind of resource.
    :type kind: str
    :param location: Resource Location.
    :type location: str
    :param type: Resource type.
    :type type: str
    :param tags: Resource tags.
    :type tags: dict
    :param resource_health_metadata_id: ARM Resource Id
    :type resource_health_metadata_id: str
    :param category: The category that the resource matches in the RHC Policy
     File
    :type category: str
    :param signal_availability: Is there a health signal for the resource
    :type signal_availability: bool
    """

    _validation = {
        'id': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'resource_health_metadata_id': {'key': 'properties.id', 'type': 'str'},
        'category': {'key': 'properties.category', 'type': 'str'},
        'signal_availability': {'key': 'properties.signalAvailability', 'type': 'bool'},
    }

    def __init__(self, location, name=None, kind=None, type=None, tags=None, resource_health_metadata_id=None, category=None, signal_availability=None):
        super(ResourceHealthMetadata, self).__init__(name=name, kind=kind, location=location, type=type, tags=tags)
        self.resource_health_metadata_id = resource_health_metadata_id
        self.category = category
        self.signal_availability = signal_availability
