/*
 * Copyright 2021-2025 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.opentest4j.reporting.tooling.core.htmlreport;

import com.microsoft.playwright.Tracing;
import com.microsoft.playwright.impl.junit.BrowserContextExtension;
import org.junit.jupiter.api.MediaType;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestWatcher;

class PlaywrightTracePublisher implements BeforeTestExecutionCallback, TestWatcher {

	@Override
	public void beforeTestExecution(ExtensionContext context) {
		var startOptions = new Tracing.StartOptions() //
				.setSnapshots(true) //
				.setScreenshots(true) //
				.setTitle(context.getDisplayName());
		BrowserContextExtension.getOrCreateBrowserContext(context).tracing().start(startOptions);
	}

	@Override
	public void testFailed(ExtensionContext context, Throwable cause) {
		context.publishFile("trace.zip", MediaType.parse("application/zip"), path -> {
			var browserContext = BrowserContextExtension.getOrCreateBrowserContext(context);
			browserContext.tracing().stop(new Tracing.StopOptions().setPath(path));
		});
	}
}
