/* foundry-symbol-intent.h
 *
 * Copyright 2025 Christian Hergert <chergert@redhat.com>
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of the
 * License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: LGPL-2.1-or-later
 */

#pragma once

#include "foundry-intent.h"
#include "foundry-symbol-locator.h"
#include "foundry-version-macros.h"

G_BEGIN_DECLS

#define FOUNDRY_TYPE_SYMBOL_INTENT (foundry_symbol_intent_get_type())

FOUNDRY_AVAILABLE_IN_1_1
G_DECLARE_FINAL_TYPE (FoundrySymbolIntent, foundry_symbol_intent, FOUNDRY, SYMBOL_INTENT, FoundryIntent)

FOUNDRY_AVAILABLE_IN_1_1
FoundryIntent        *foundry_symbol_intent_new         (FoundrySymbolLocator  *locator);
FOUNDRY_AVAILABLE_IN_1_1
FoundrySymbolLocator *foundry_symbol_intent_dup_locator (FoundrySymbolIntent   *self);

G_END_DECLS
