/* foundry-sdk-manager.h
 *
 * Copyright 2024 Christian Hergert <chergert@redhat.com>
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of the
 * License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: LGPL-2.1-or-later
 */

#pragma once

#include "foundry-service.h"
#include "foundry-types.h"
#include "foundry-version-macros.h"

G_BEGIN_DECLS

#define FOUNDRY_TYPE_SDK_MANAGER (foundry_sdk_manager_get_type())

FOUNDRY_AVAILABLE_IN_ALL
FOUNDRY_DECLARE_INTERNAL_TYPE (FoundrySdkManager, foundry_sdk_manager, FOUNDRY, SDK_MANAGER, FoundryService)

FOUNDRY_AVAILABLE_IN_ALL
FoundrySdk *foundry_sdk_manager_dup_sdk    (FoundrySdkManager *self);
FOUNDRY_AVAILABLE_IN_ALL
void        foundry_sdk_manager_set_sdk    (FoundrySdkManager *self,
                                            FoundrySdk        *sdk);
FOUNDRY_AVAILABLE_IN_ALL
DexFuture  *foundry_sdk_manager_find_by_id (FoundrySdkManager *self,
                                            const char        *sdk_id) G_GNUC_WARN_UNUSED_RESULT;

G_END_DECLS
