/*
// $Id: //open/dev/farrago/ext/mql/src/net/sf/farrago/namespace/mql/MedMqlUdx.java#4 $
// Farrago is an extensible data management system.
// Copyright (C) 2008-2009 The Eigenbase Project
// Copyright (C) 2008-2009 SQLStream, Inc.
// Copyright (C) 2008-2009 LucidEra, Inc.
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 of the License, or (at your option)
// any later version approved by The Eigenbase Project.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
package net.sf.farrago.namespace.mql;

import java.net.*;
import java.io.*;
import java.sql.*;
import java.util.*;

import java.util.logging.*;

import net.sf.farrago.trace.*;

/**
 * MedMqlUdx is the UDX which implements the execution of an MQL query
 * generated by the optimizer.
 *
 * @author John Sichi
 * @version $Id: //open/dev/farrago/ext/mql/src/net/sf/farrago/namespace/mql/MedMqlUdx.java#4 $
 */
public abstract class MedMqlUdx
{
    private static final Logger tracer =
        FarragoTrace.getClassTracer(MedMqlUdx.class);

    public static void execute(
        String urlBase,
        String mql,
        String rowType,
        PreparedStatement resultInserter)
        throws Exception
    {
        boolean tracing = tracer.isLoggable(Level.FINE);

        // FIXME jvs 7-Jan-2008:  use a proper JSON library
        // for all of this

        if (tracing) {
            tracer.fine(mql);
        }

        Map<String, Integer> rowMap = new HashMap<String, Integer>();
        String [] colNames = rowType.split("\\|");
        if (tracing) {
            tracer.fine("Mapped columns = " + Arrays.asList(colNames));
        }
        int iColumn = 1;
        for (String colName : colNames) {
            rowMap.put(colName, iColumn);
            ++iColumn;
        }

        String escaped = escapeUri(mql);
        String urlString = urlBase + "?query=" + escaped;
        if (tracing) {
            tracer.fine(urlString);
        }
        URL url = new URL(urlString);
        InputStream inputStream = null;
        try {
            inputStream = url.openStream();
            InputStreamReader reader = new InputStreamReader(inputStream);
            LineNumberReader lineReader = new LineNumberReader(reader);
            boolean readingResult = false;
            boolean readingRow = false;
            for (;;) {
                String line = lineReader.readLine();
                if (line == null) {
                    return;
                }
                if (tracing) {
                    tracer.fine(line);
                }
                line = line.trim();
                if (!readingResult) {
                    if (line.startsWith("\"result\"")) {
                        readingResult = true;
                    }
                    continue;
                }
                if (!readingRow) {
                    if (line.startsWith("{")) {
                        readingRow = true;
                    } else if (line.startsWith("]")) {
                        readingResult = false;
                    }
                    continue;
                }
                if (line.startsWith("}")) {
                    resultInserter.executeUpdate();
                    readingRow = false;
                    continue;
                }
                if (!line.startsWith("\"")) {
                    continue;
                }
                int iColon = line.indexOf(':');
                if (iColon == -1) {
                    continue;
                }
                String colName = line.substring(1, iColon - 1);
                Integer iParam = rowMap.get(colName);
                if (iParam == null) {
                    continue;
                }
                line = line.substring(iColon + 1);
                if (line.startsWith("\"")) {
                    int iEndQuote = line.indexOf("\"", 1);
                    if (iEndQuote == -1) {
                        continue;
                    }
                    line = line.substring(1, iEndQuote);
                }
                resultInserter.setString(iParam, line);
            }
        } finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    // NOTE jvs 8-Jan-2009:  code below was taken from
    // http://www.w3.org/International/URLUTF8Encoder.java

    private final static String[] hex = {
        "%00", "%01", "%02", "%03", "%04", "%05", "%06", "%07",
        "%08", "%09", "%0a", "%0b", "%0c", "%0d", "%0e", "%0f",
        "%10", "%11", "%12", "%13", "%14", "%15", "%16", "%17",
        "%18", "%19", "%1a", "%1b", "%1c", "%1d", "%1e", "%1f",
        "%20", "%21", "%22", "%23", "%24", "%25", "%26", "%27",
        "%28", "%29", "%2a", "%2b", "%2c", "%2d", "%2e", "%2f",
        "%30", "%31", "%32", "%33", "%34", "%35", "%36", "%37",
        "%38", "%39", "%3a", "%3b", "%3c", "%3d", "%3e", "%3f",
        "%40", "%41", "%42", "%43", "%44", "%45", "%46", "%47",
        "%48", "%49", "%4a", "%4b", "%4c", "%4d", "%4e", "%4f",
        "%50", "%51", "%52", "%53", "%54", "%55", "%56", "%57",
        "%58", "%59", "%5a", "%5b", "%5c", "%5d", "%5e", "%5f",
        "%60", "%61", "%62", "%63", "%64", "%65", "%66", "%67",
        "%68", "%69", "%6a", "%6b", "%6c", "%6d", "%6e", "%6f",
        "%70", "%71", "%72", "%73", "%74", "%75", "%76", "%77",
        "%78", "%79", "%7a", "%7b", "%7c", "%7d", "%7e", "%7f",
        "%80", "%81", "%82", "%83", "%84", "%85", "%86", "%87",
        "%88", "%89", "%8a", "%8b", "%8c", "%8d", "%8e", "%8f",
        "%90", "%91", "%92", "%93", "%94", "%95", "%96", "%97",
        "%98", "%99", "%9a", "%9b", "%9c", "%9d", "%9e", "%9f",
        "%a0", "%a1", "%a2", "%a3", "%a4", "%a5", "%a6", "%a7",
        "%a8", "%a9", "%aa", "%ab", "%ac", "%ad", "%ae", "%af",
        "%b0", "%b1", "%b2", "%b3", "%b4", "%b5", "%b6", "%b7",
        "%b8", "%b9", "%ba", "%bb", "%bc", "%bd", "%be", "%bf",
        "%c0", "%c1", "%c2", "%c3", "%c4", "%c5", "%c6", "%c7",
        "%c8", "%c9", "%ca", "%cb", "%cc", "%cd", "%ce", "%cf",
        "%d0", "%d1", "%d2", "%d3", "%d4", "%d5", "%d6", "%d7",
        "%d8", "%d9", "%da", "%db", "%dc", "%dd", "%de", "%df",
        "%e0", "%e1", "%e2", "%e3", "%e4", "%e5", "%e6", "%e7",
        "%e8", "%e9", "%ea", "%eb", "%ec", "%ed", "%ee", "%ef",
        "%f0", "%f1", "%f2", "%f3", "%f4", "%f5", "%f6", "%f7",
        "%f8", "%f9", "%fa", "%fb", "%fc", "%fd", "%fe", "%ff"
    };

    private static String escapeUri(String s)
    {
        StringBuffer sbuf = new StringBuffer();
        int len = s.length();
        for (int i = 0; i < len; i++) {
            int ch = s.charAt(i);
            if ('A' <= ch && ch <= 'Z') {
                // 'A'..'Z'
                sbuf.append((char)ch);
            } else if ('a' <= ch && ch <= 'z') {
                // 'a'..'z'
                sbuf.append((char)ch);
            } else if ('0' <= ch && ch <= '9') {
                // '0'..'9'
                sbuf.append((char)ch);
            } else if (ch == ' ') {
                // space
                sbuf.append('+');
            } else if (ch == '-' || ch == '_'
                || ch == '.' || ch == '!'
                || ch == '~' || ch == '*'
                || ch == '\'' || ch == '('
                || ch == ')')
            {
                // unreserved
                sbuf.append((char)ch);
            } else if (ch <= 0x007f) {
                // other ASCII
                sbuf.append(hex[ch]);
            } else if (ch <= 0x07FF) {
                // non-ASCII <= 0x7FF
                sbuf.append(hex[0xc0 | (ch >> 6)]);
                sbuf.append(hex[0x80 | (ch & 0x3F)]);
            } else {
                // 0x7FF < ch <= 0xFFFF
                sbuf.append(hex[0xe0 | (ch >> 12)]);
                sbuf.append(hex[0x80 | ((ch >> 6) & 0x3F)]);
                sbuf.append(hex[0x80 | (ch & 0x3F)]);
            }
        }
        return sbuf.toString();
    }
}

// End MedMqlUdx.java
