#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Grow: Song of the Evertree
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250907.1

PLAYIT_COMPATIBILITY_LEVEL='2.33'

GAME_ID='grow-song-of-the-evertree'
GAME_NAME='Grow: Song of the Evertree'

ARCHIVE_BASE_0_NAME='setup_grow_song_of_the_evertree_1.0.6.3369_(64bit)_(54063).exe'
ARCHIVE_BASE_0_MD5='a099df449e5f892ea7684b6a21868a2b'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_PART1_NAME='setup_grow_song_of_the_evertree_1.0.6.3369_(64bit)_(54063)-1.bin'
ARCHIVE_BASE_0_PART1_MD5='34d143e6eb44b5a3637419cb9245c5ad'
ARCHIVE_BASE_0_SIZE='2600000'
ARCHIVE_BASE_0_VERSION='1.0.6.3369-gog54063'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/grow_song_of_the_evertree'

UNITY3D_NAME='grow'

CONTENT_PATH_DEFAULT='.'

WINE_PERSISTENT_DIRECTORIES='
users/${USER}/AppData/LocalLow/505 Games/Grow_ Song of The Evertree'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='64'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions.

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run default initialisation actions.

initialization_default "$@"

# Extract game data.

archive_extraction_default

# Include game data.

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers.

launchers_generation

# Build packages.

packages_generation
print_instructions

# Clean up.

working_directory_cleanup

exit 0
