/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.reasoner.rulesys;

import java.util.List;
import org.apache.jena.graph.Graph;
import org.apache.jena.reasoner.InfGraph;
import org.apache.jena.reasoner.Reasoner;
import org.apache.jena.reasoner.ReasonerException;
import org.apache.jena.reasoner.ReasonerFactory;
import org.apache.jena.reasoner.rulesys.FBRuleInfGraph;
import org.apache.jena.reasoner.rulesys.FBRuleReasoner;
import org.apache.jena.reasoner.rulesys.Rule;
import org.apache.jena.reasoner.rulesys.impl.OWLRuleTranslationHook;
import org.apache.jena.shared.impl.JenaParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OWLFBRuleReasoner
extends FBRuleReasoner {
    protected static final String RULE_FILE = "etc/owl-fb.rules";
    protected static List<Rule> ruleSet;
    protected static FBRuleInfGraph staticPreload;
    protected static Logger logger;

    public OWLFBRuleReasoner(ReasonerFactory factory) {
        super(OWLFBRuleReasoner.loadRules(), factory);
    }

    private OWLFBRuleReasoner(OWLFBRuleReasoner parent, InfGraph schemaGraph) {
        super(parent.rules, schemaGraph, parent.factory);
    }

    public static List<Rule> loadRules() {
        if (ruleSet == null) {
            ruleSet = OWLFBRuleReasoner.loadRules(RULE_FILE);
        }
        return ruleSet;
    }

    @Override
    public Reasoner bindSchema(Graph tbox) throws ReasonerException {
        this.checkArgGraph(tbox);
        if (this.schemaGraph != null) {
            throw new ReasonerException("Can only bind one schema at a time to an OWLRuleReasoner");
        }
        FBRuleInfGraph graph = new FBRuleInfGraph(this, this.rules, this.getPreload(), tbox);
        graph.addPreprocessingHook(new OWLRuleTranslationHook());
        graph.prepare();
        return new OWLFBRuleReasoner(this, graph);
    }

    @Override
    public InfGraph bind(Graph data) throws ReasonerException {
        this.checkArgGraph(data);
        FBRuleInfGraph graph = null;
        InfGraph schemaArg = this.schemaGraph == null ? this.getPreload() : (FBRuleInfGraph)this.schemaGraph;
        List<Rule> baseRules = ((FBRuleInfGraph)schemaArg).getRules();
        graph = new FBRuleInfGraph(this, baseRules, schemaArg);
        graph.addPreprocessingHook(new OWLRuleTranslationHook());
        graph.setDerivationLogging(this.recordDerivations);
        graph.setTraceOn(this.traceOn);
        graph.rebind(data);
        graph.setDatatypeRangeValidation(true);
        return graph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized InfGraph getPreload() {
        Class<OWLFBRuleReasoner> clazz = OWLFBRuleReasoner.class;
        synchronized (OWLFBRuleReasoner.class) {
            if (staticPreload == null) {
                boolean prior = JenaParameters.enableFilteringOfHiddenInfNodes;
                try {
                    JenaParameters.enableFilteringOfHiddenInfNodes = true;
                    staticPreload = new FBRuleInfGraph(this, this.rules, null);
                    staticPreload.prepare();
                }
                finally {
                    JenaParameters.enableFilteringOfHiddenInfNodes = prior;
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return staticPreload;
        }
    }

    private void checkArgGraph(Graph g) {
        if (JenaParameters.enableOWLRuleOverOWLRuleWarnings && g instanceof InfGraph && ((InfGraph)g).getReasoner() instanceof OWLFBRuleReasoner) {
            logger.warn("Creating OWL rule reasoner working over another OWL rule reasoner");
        }
    }

    static {
        logger = LoggerFactory.getLogger(OWLFBRuleReasoner.class);
    }
}

