/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfvalidator;

import java.io.IOException;
import java.io.InputStream;
import org.odftoolkit.odfvalidator.InternalResources;
import org.odftoolkit.odfvalidator.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.XMLFilterImpl;

class MathML101Filter
extends XMLFilterImpl {
    private String m_aMathMLDTD;
    private static final String MATHML_NAMESPACE_URI = "http://www.w3.org/1998/Math/MathML";
    private static final String MATHML_PUBLIC_ID = "-//W3C//DTD MathML 1.01//EN";
    private static final String OOO_MATHML_PUBLIC_ID = "-//OpenOffice.org//DTD Modified W3C MathML 1.01//EN";
    private Logger m_aLogger;

    MathML101Filter(String aMathMLDTD, Logger aLogger) {
        this.m_aMathMLDTD = aMathMLDTD;
        this.m_aLogger = aLogger;
    }

    @Override
    public void startElement(String aUri, String aLocalName, String aQName, Attributes aAtts) throws SAXException {
        super.startElement(aUri, aLocalName, aQName, aAtts);
    }

    @Override
    public void endElement(String aUri, String aLocalName, String aQName) throws SAXException {
        super.endElement(aUri, aLocalName, aQName);
    }

    @Override
    public InputSource resolveEntity(String aPublicId, String aSystemId) throws SAXException, IOException {
        InputSource aRet = null;
        String aEntity = null;
        if (aPublicId != null && (aPublicId.equals(MATHML_PUBLIC_ID) || aPublicId.equals(OOO_MATHML_PUBLIC_ID))) {
            aEntity = this.m_aMathMLDTD;
            if (InternalResources.isInternalResourceIdentifer(aEntity)) {
                String aPath = InternalResources.getResourcePath(aEntity);
                InputStream aInStream = this.getClass().getResourceAsStream(aPath);
                if (aInStream == null) {
                    this.m_aLogger.logFatalError("Missing internal schema file: ".concat(aPath));
                } else {
                    aRet = new InputSource(aInStream);
                    aRet.setPublicId(aPublicId);
                    aRet.setSystemId(aEntity);
                }
            }
        } else {
            aEntity = aSystemId;
        }
        String aMsg = "Reading doctype definition '" + aEntity + "'";
        this.m_aLogger.logInfo(aMsg, false);
        if (aRet == null) {
            aRet = new InputSource(aEntity);
        }
        return aRet;
    }
}

