; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -arm-parallel-dsp -mtriple=armv7-a -S %s -o - | FileCheck %s

define i32 @overlap_1(ptr %a, ptr %b, i32 %acc) {
; CHECK-LABEL: @overlap_1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ADDR_A_1:%.*]] = getelementptr i16, ptr [[A:%.*]], i32 1
; CHECK-NEXT:    [[ADDR_B_1:%.*]] = getelementptr i16, ptr [[B:%.*]], i32 1
; CHECK-NEXT:    [[LD_A_0:%.*]] = load i16, ptr [[A]], align 2
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr [[A]], align 2
; CHECK-NEXT:    [[TMP2:%.*]] = trunc i32 [[TMP1]] to i16
; CHECK-NEXT:    [[TMP3:%.*]] = sext i16 [[TMP2]] to i32
; CHECK-NEXT:    [[TMP4:%.*]] = lshr i32 [[TMP1]], 16
; CHECK-NEXT:    [[TMP5:%.*]] = trunc i32 [[TMP4]] to i16
; CHECK-NEXT:    [[TMP6:%.*]] = sext i16 [[TMP5]] to i32
; CHECK-NEXT:    [[SEXT_A_0:%.*]] = sext i16 [[LD_A_0]] to i32
; CHECK-NEXT:    [[LD_B_0:%.*]] = load i16, ptr [[B]], align 2
; CHECK-NEXT:    [[TMP8:%.*]] = load i32, ptr [[B]], align 2
; CHECK-NEXT:    [[TMP9:%.*]] = trunc i32 [[TMP8]] to i16
; CHECK-NEXT:    [[TMP10:%.*]] = call i32 @llvm.arm.smlad(i32 [[TMP1]], i32 [[TMP8]], i32 [[ACC:%.*]])
; CHECK-NEXT:    [[TMP11:%.*]] = sext i16 [[TMP9]] to i32
; CHECK-NEXT:    [[TMP12:%.*]] = lshr i32 [[TMP8]], 16
; CHECK-NEXT:    [[TMP13:%.*]] = trunc i32 [[TMP12]] to i16
; CHECK-NEXT:    [[TMP14:%.*]] = sext i16 [[TMP13]] to i32
; CHECK-NEXT:    [[LD_A_1:%.*]] = load i16, ptr [[ADDR_A_1]], align 2
; CHECK-NEXT:    [[TMP16:%.*]] = load i32, ptr [[ADDR_A_1]], align 2
; CHECK-NEXT:    [[TMP17:%.*]] = trunc i32 [[TMP16]] to i16
; CHECK-NEXT:    [[TMP18:%.*]] = sext i16 [[TMP17]] to i32
; CHECK-NEXT:    [[TMP19:%.*]] = lshr i32 [[TMP16]], 16
; CHECK-NEXT:    [[TMP20:%.*]] = trunc i32 [[TMP19]] to i16
; CHECK-NEXT:    [[TMP21:%.*]] = sext i16 [[TMP20]] to i32
; CHECK-NEXT:    [[LD_B_1:%.*]] = load i16, ptr [[ADDR_B_1]], align 2
; CHECK-NEXT:    [[TMP23:%.*]] = load i32, ptr [[ADDR_B_1]], align 2
; CHECK-NEXT:    [[TMP24:%.*]] = trunc i32 [[TMP23]] to i16
; CHECK-NEXT:    [[TMP25:%.*]] = call i32 @llvm.arm.smlad(i32 [[TMP16]], i32 [[TMP23]], i32 [[TMP10]])
; CHECK-NEXT:    [[TMP26:%.*]] = sext i16 [[TMP24]] to i32
; CHECK-NEXT:    [[TMP27:%.*]] = lshr i32 [[TMP23]], 16
; CHECK-NEXT:    [[TMP28:%.*]] = trunc i32 [[TMP27]] to i16
; CHECK-NEXT:    [[TMP29:%.*]] = sext i16 [[TMP28]] to i32
; CHECK-NEXT:    [[SEXT_A_1:%.*]] = sext i16 [[LD_A_1]] to i32
; CHECK-NEXT:    [[SEXT_B_1:%.*]] = sext i16 [[LD_B_1]] to i32
; CHECK-NEXT:    [[SEXT_B_0:%.*]] = sext i16 [[LD_B_0]] to i32
; CHECK-NEXT:    [[MUL_0:%.*]] = mul i32 [[TMP3]], [[TMP11]]
; CHECK-NEXT:    [[MUL_1:%.*]] = mul i32 [[TMP6]], [[TMP14]]
; CHECK-NEXT:    [[ADDR_A_2:%.*]] = getelementptr i16, ptr [[A]], i32 2
; CHECK-NEXT:    [[ADDR_B_2:%.*]] = getelementptr i16, ptr [[B]], i32 2
; CHECK-NEXT:    [[LD_A_2:%.*]] = load i16, ptr [[ADDR_A_2]], align 2
; CHECK-NEXT:    [[LD_B_2:%.*]] = load i16, ptr [[ADDR_B_2]], align 2
; CHECK-NEXT:    [[SEXT_A_2:%.*]] = sext i16 [[LD_A_2]] to i32
; CHECK-NEXT:    [[SEXT_B_2:%.*]] = sext i16 [[LD_B_2]] to i32
; CHECK-NEXT:    [[MUL_2:%.*]] = mul i32 [[TMP21]], [[TMP29]]
; CHECK-NEXT:    [[ADD:%.*]] = add i32 [[MUL_0]], [[MUL_1]]
; CHECK-NEXT:    [[ADD_1:%.*]] = add i32 [[MUL_1]], [[MUL_2]]
; CHECK-NEXT:    [[ADD_2:%.*]] = add i32 [[ADD_1]], [[ADD]]
; CHECK-NEXT:    [[RES:%.*]] = add i32 [[ADD_2]], [[ACC]]
; CHECK-NEXT:    ret i32 [[TMP25]]
;
entry:
  %addr.a.1 = getelementptr i16, ptr %a, i32 1
  %addr.b.1 = getelementptr i16, ptr %b, i32 1
  %ld.a.0 = load i16, ptr %a
  %sext.a.0 = sext i16 %ld.a.0 to i32
  %ld.b.0 = load i16, ptr %b
  %ld.a.1 = load i16, ptr %addr.a.1
  %ld.b.1 = load i16, ptr %addr.b.1
  %sext.a.1 = sext i16 %ld.a.1 to i32
  %sext.b.1 = sext i16 %ld.b.1 to i32
  %sext.b.0 = sext i16 %ld.b.0 to i32
  %mul.0 = mul i32 %sext.a.0, %sext.b.0
  %mul.1 = mul i32 %sext.a.1, %sext.b.1
  %addr.a.2 = getelementptr i16, ptr %a, i32 2
  %addr.b.2 = getelementptr i16, ptr %b, i32 2
  %ld.a.2 = load i16, ptr %addr.a.2
  %ld.b.2 = load i16, ptr %addr.b.2
  %sext.a.2 = sext i16 %ld.a.2 to i32
  %sext.b.2 = sext i16 %ld.b.2 to i32
  %mul.2 = mul i32 %sext.a.2, %sext.b.2
  %add = add i32 %mul.0, %mul.1
  %add.1 = add i32 %mul.1, %mul.2
  %add.2 = add i32 %add.1, %add
  %res = add i32 %add.2, %acc
  ret i32 %res
}

; TODO: Is it really best to generate smlald for the first instruction? Does
; this just increase register pressure unnecessarily?
define i64 @overlap_64_1(ptr %a, ptr %b, i64 %acc) {
; CHECK-LABEL: @overlap_64_1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ADDR_A_1:%.*]] = getelementptr i16, ptr [[A:%.*]], i32 1
; CHECK-NEXT:    [[ADDR_B_1:%.*]] = getelementptr i16, ptr [[B:%.*]], i32 1
; CHECK-NEXT:    [[LD_A_0:%.*]] = load i16, ptr [[A]], align 2
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr [[A]], align 2
; CHECK-NEXT:    [[TMP2:%.*]] = trunc i32 [[TMP1]] to i16
; CHECK-NEXT:    [[TMP3:%.*]] = sext i16 [[TMP2]] to i32
; CHECK-NEXT:    [[TMP4:%.*]] = lshr i32 [[TMP1]], 16
; CHECK-NEXT:    [[TMP5:%.*]] = trunc i32 [[TMP4]] to i16
; CHECK-NEXT:    [[TMP6:%.*]] = sext i16 [[TMP5]] to i32
; CHECK-NEXT:    [[SEXT_A_0:%.*]] = sext i16 [[LD_A_0]] to i32
; CHECK-NEXT:    [[LD_B_0:%.*]] = load i16, ptr [[B]], align 2
; CHECK-NEXT:    [[TMP8:%.*]] = load i32, ptr [[B]], align 2
; CHECK-NEXT:    [[TMP9:%.*]] = trunc i32 [[TMP8]] to i16
; CHECK-NEXT:    [[TMP10:%.*]] = call i64 @llvm.arm.smlald(i32 [[TMP1]], i32 [[TMP8]], i64 [[ACC:%.*]])
; CHECK-NEXT:    [[TMP11:%.*]] = sext i16 [[TMP9]] to i32
; CHECK-NEXT:    [[TMP12:%.*]] = lshr i32 [[TMP8]], 16
; CHECK-NEXT:    [[TMP13:%.*]] = trunc i32 [[TMP12]] to i16
; CHECK-NEXT:    [[TMP14:%.*]] = sext i16 [[TMP13]] to i32
; CHECK-NEXT:    [[LD_A_1:%.*]] = load i16, ptr [[ADDR_A_1]], align 2
; CHECK-NEXT:    [[TMP16:%.*]] = load i32, ptr [[ADDR_A_1]], align 2
; CHECK-NEXT:    [[TMP17:%.*]] = trunc i32 [[TMP16]] to i16
; CHECK-NEXT:    [[TMP18:%.*]] = sext i16 [[TMP17]] to i32
; CHECK-NEXT:    [[TMP19:%.*]] = lshr i32 [[TMP16]], 16
; CHECK-NEXT:    [[TMP20:%.*]] = trunc i32 [[TMP19]] to i16
; CHECK-NEXT:    [[TMP21:%.*]] = sext i16 [[TMP20]] to i32
; CHECK-NEXT:    [[LD_B_1:%.*]] = load i16, ptr [[ADDR_B_1]], align 2
; CHECK-NEXT:    [[TMP23:%.*]] = load i32, ptr [[ADDR_B_1]], align 2
; CHECK-NEXT:    [[TMP24:%.*]] = trunc i32 [[TMP23]] to i16
; CHECK-NEXT:    [[TMP25:%.*]] = call i64 @llvm.arm.smlald(i32 [[TMP16]], i32 [[TMP23]], i64 [[TMP10]])
; CHECK-NEXT:    [[TMP26:%.*]] = sext i16 [[TMP24]] to i32
; CHECK-NEXT:    [[TMP27:%.*]] = lshr i32 [[TMP23]], 16
; CHECK-NEXT:    [[TMP28:%.*]] = trunc i32 [[TMP27]] to i16
; CHECK-NEXT:    [[TMP29:%.*]] = sext i16 [[TMP28]] to i32
; CHECK-NEXT:    [[SEXT_A_1:%.*]] = sext i16 [[LD_A_1]] to i32
; CHECK-NEXT:    [[SEXT_B_1:%.*]] = sext i16 [[LD_B_1]] to i32
; CHECK-NEXT:    [[SEXT_B_0:%.*]] = sext i16 [[LD_B_0]] to i32
; CHECK-NEXT:    [[MUL_0:%.*]] = mul i32 [[TMP3]], [[TMP11]]
; CHECK-NEXT:    [[MUL_1:%.*]] = mul i32 [[TMP6]], [[TMP14]]
; CHECK-NEXT:    [[ADDR_A_2:%.*]] = getelementptr i16, ptr [[A]], i32 2
; CHECK-NEXT:    [[ADDR_B_2:%.*]] = getelementptr i16, ptr [[B]], i32 2
; CHECK-NEXT:    [[LD_A_2:%.*]] = load i16, ptr [[ADDR_A_2]], align 2
; CHECK-NEXT:    [[LD_B_2:%.*]] = load i16, ptr [[ADDR_B_2]], align 2
; CHECK-NEXT:    [[SEXT_A_2:%.*]] = sext i16 [[LD_A_2]] to i32
; CHECK-NEXT:    [[SEXT_B_2:%.*]] = sext i16 [[LD_B_2]] to i32
; CHECK-NEXT:    [[MUL_2:%.*]] = mul i32 [[TMP21]], [[TMP29]]
; CHECK-NEXT:    [[ADD:%.*]] = add i32 [[MUL_0]], [[MUL_1]]
; CHECK-NEXT:    [[ADD_1:%.*]] = add i32 [[MUL_1]], [[MUL_2]]
; CHECK-NEXT:    [[SEXT_ADD:%.*]] = sext i32 [[ADD]] to i64
; CHECK-NEXT:    [[SEXT_ADD_1:%.*]] = sext i32 [[ADD_1]] to i64
; CHECK-NEXT:    [[ADD_2:%.*]] = add i64 [[SEXT_ADD_1]], [[SEXT_ADD]]
; CHECK-NEXT:    [[RES:%.*]] = add i64 [[ADD_2]], [[ACC]]
; CHECK-NEXT:    ret i64 [[TMP25]]
;
entry:
  %addr.a.1 = getelementptr i16, ptr %a, i32 1
  %addr.b.1 = getelementptr i16, ptr %b, i32 1
  %ld.a.0 = load i16, ptr %a
  %sext.a.0 = sext i16 %ld.a.0 to i32
  %ld.b.0 = load i16, ptr %b
  %ld.a.1 = load i16, ptr %addr.a.1
  %ld.b.1 = load i16, ptr %addr.b.1
  %sext.a.1 = sext i16 %ld.a.1 to i32
  %sext.b.1 = sext i16 %ld.b.1 to i32
  %sext.b.0 = sext i16 %ld.b.0 to i32
  %mul.0 = mul i32 %sext.a.0, %sext.b.0
  %mul.1 = mul i32 %sext.a.1, %sext.b.1
  %addr.a.2 = getelementptr i16, ptr %a, i32 2
  %addr.b.2 = getelementptr i16, ptr %b, i32 2
  %ld.a.2 = load i16, ptr %addr.a.2
  %ld.b.2 = load i16, ptr %addr.b.2
  %sext.a.2 = sext i16 %ld.a.2 to i32
  %sext.b.2 = sext i16 %ld.b.2 to i32
  %mul.2 = mul i32 %sext.a.2, %sext.b.2
  %add = add i32 %mul.0, %mul.1
  %add.1 = add i32 %mul.1, %mul.2
  %sext.add = sext i32 %add to i64
  %sext.add.1 = sext i32 %add.1 to i64
  %add.2 = add i64 %sext.add.1, %sext.add
  %res = add i64 %add.2, %acc
  ret i64 %res
}

define i32 @overlap_2(ptr %a, ptr %b, i32 %acc) {
; CHECK-LABEL: @overlap_2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ADDR_A_1:%.*]] = getelementptr i16, ptr [[A:%.*]], i32 1
; CHECK-NEXT:    [[ADDR_B_1:%.*]] = getelementptr i16, ptr [[B:%.*]], i32 1
; CHECK-NEXT:    [[LD_A_0:%.*]] = load i16, ptr [[A]], align 2
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr [[A]], align 2
; CHECK-NEXT:    [[TMP2:%.*]] = trunc i32 [[TMP1]] to i16
; CHECK-NEXT:    [[TMP3:%.*]] = sext i16 [[TMP2]] to i32
; CHECK-NEXT:    [[TMP4:%.*]] = lshr i32 [[TMP1]], 16
; CHECK-NEXT:    [[TMP5:%.*]] = trunc i32 [[TMP4]] to i16
; CHECK-NEXT:    [[TMP6:%.*]] = sext i16 [[TMP5]] to i32
; CHECK-NEXT:    [[SEXT_A_0:%.*]] = sext i16 [[LD_A_0]] to i32
; CHECK-NEXT:    [[LD_B_0:%.*]] = load i16, ptr [[B]], align 2
; CHECK-NEXT:    [[TMP8:%.*]] = load i32, ptr [[B]], align 2
; CHECK-NEXT:    [[TMP9:%.*]] = trunc i32 [[TMP8]] to i16
; CHECK-NEXT:    [[TMP10:%.*]] = sext i16 [[TMP9]] to i32
; CHECK-NEXT:    [[TMP11:%.*]] = lshr i32 [[TMP8]], 16
; CHECK-NEXT:    [[TMP12:%.*]] = trunc i32 [[TMP11]] to i16
; CHECK-NEXT:    [[TMP13:%.*]] = sext i16 [[TMP12]] to i32
; CHECK-NEXT:    [[LD_A_1:%.*]] = load i16, ptr [[ADDR_A_1]], align 2
; CHECK-NEXT:    [[LD_B_1:%.*]] = load i16, ptr [[ADDR_B_1]], align 2
; CHECK-NEXT:    [[SEXT_A_1:%.*]] = sext i16 [[LD_A_1]] to i32
; CHECK-NEXT:    [[SEXT_B_1:%.*]] = sext i16 [[LD_B_1]] to i32
; CHECK-NEXT:    [[SEXT_B_0:%.*]] = sext i16 [[LD_B_0]] to i32
; CHECK-NEXT:    [[MUL_0:%.*]] = mul i32 [[TMP3]], [[TMP10]]
; CHECK-NEXT:    [[MUL_1:%.*]] = mul i32 [[TMP6]], [[TMP13]]
; CHECK-NEXT:    [[TMP14:%.*]] = add i32 [[MUL_1]], [[ACC:%.*]]
; CHECK-NEXT:    [[ADDR_A_2:%.*]] = getelementptr i16, ptr [[A]], i32 2
; CHECK-NEXT:    [[ADDR_B_2:%.*]] = getelementptr i16, ptr [[B]], i32 2
; CHECK-NEXT:    [[LD_A_2:%.*]] = load i16, ptr [[ADDR_A_2]], align 2
; CHECK-NEXT:    [[LD_B_2:%.*]] = load i16, ptr [[ADDR_B_2]], align 2
; CHECK-NEXT:    [[SEXT_A_2:%.*]] = sext i16 [[LD_A_2]] to i32
; CHECK-NEXT:    [[SEXT_B_2:%.*]] = sext i16 [[LD_B_2]] to i32
; CHECK-NEXT:    [[MUL_2:%.*]] = mul i32 [[SEXT_B_2]], [[SEXT_A_2]]
; CHECK-NEXT:    [[TMP15:%.*]] = add i32 [[MUL_2]], [[TMP14]]
; CHECK-NEXT:    [[TMP16:%.*]] = call i32 @llvm.arm.smlad(i32 [[TMP1]], i32 [[TMP8]], i32 [[TMP15]])
; CHECK-NEXT:    [[ADD:%.*]] = add i32 [[MUL_0]], [[MUL_1]]
; CHECK-NEXT:    [[ADD_1:%.*]] = add i32 [[MUL_1]], [[MUL_2]]
; CHECK-NEXT:    [[ADD_2:%.*]] = add i32 [[ADD]], [[ADD_1]]
; CHECK-NEXT:    [[RES:%.*]] = add i32 [[ADD_2]], [[ACC]]
; CHECK-NEXT:    ret i32 [[TMP16]]
;
entry:
  %addr.a.1 = getelementptr i16, ptr %a, i32 1
  %addr.b.1 = getelementptr i16, ptr %b, i32 1
  %ld.a.0 = load i16, ptr %a
  %sext.a.0 = sext i16 %ld.a.0 to i32
  %ld.b.0 = load i16, ptr %b
  %ld.a.1 = load i16, ptr %addr.a.1
  %ld.b.1 = load i16, ptr %addr.b.1
  %sext.a.1 = sext i16 %ld.a.1 to i32
  %sext.b.1 = sext i16 %ld.b.1 to i32
  %sext.b.0 = sext i16 %ld.b.0 to i32
  %mul.0 = mul i32 %sext.a.0, %sext.b.0
  %mul.1 = mul i32 %sext.a.1, %sext.b.1
  %addr.a.2 = getelementptr i16, ptr %a, i32 2
  %addr.b.2 = getelementptr i16, ptr %b, i32 2
  %ld.a.2 = load i16, ptr %addr.a.2
  %ld.b.2 = load i16, ptr %addr.b.2
  %sext.a.2 = sext i16 %ld.a.2 to i32
  %sext.b.2 = sext i16 %ld.b.2 to i32
  %mul.2 = mul i32 %sext.b.2, %sext.a.2
  %add = add i32 %mul.0, %mul.1
  %add.1 = add i32 %mul.1, %mul.2
  %add.2 = add i32 %add, %add.1
  %res = add i32 %add.2, %acc
  ret i32 %res
}

define i32 @overlap_3(ptr %a, ptr %b, i32 %acc) {
; CHECK-LABEL: @overlap_3(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ADDR_A_1:%.*]] = getelementptr i16, ptr [[A:%.*]], i32 1
; CHECK-NEXT:    [[ADDR_B_1:%.*]] = getelementptr i16, ptr [[B:%.*]], i32 1
; CHECK-NEXT:    [[LD_A_0:%.*]] = load i16, ptr [[A]], align 2
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr [[A]], align 2
; CHECK-NEXT:    [[TMP2:%.*]] = trunc i32 [[TMP1]] to i16
; CHECK-NEXT:    [[TMP3:%.*]] = sext i16 [[TMP2]] to i32
; CHECK-NEXT:    [[TMP4:%.*]] = lshr i32 [[TMP1]], 16
; CHECK-NEXT:    [[TMP5:%.*]] = trunc i32 [[TMP4]] to i16
; CHECK-NEXT:    [[TMP6:%.*]] = sext i16 [[TMP5]] to i32
; CHECK-NEXT:    [[SEXT_A_0:%.*]] = sext i16 [[LD_A_0]] to i32
; CHECK-NEXT:    [[LD_B_0:%.*]] = load i16, ptr [[B]], align 2
; CHECK-NEXT:    [[TMP8:%.*]] = load i32, ptr [[B]], align 2
; CHECK-NEXT:    [[TMP9:%.*]] = trunc i32 [[TMP8]] to i16
; CHECK-NEXT:    [[TMP10:%.*]] = call i32 @llvm.arm.smlad(i32 [[TMP1]], i32 [[TMP8]], i32 [[ACC:%.*]])
; CHECK-NEXT:    [[TMP11:%.*]] = sext i16 [[TMP9]] to i32
; CHECK-NEXT:    [[TMP12:%.*]] = lshr i32 [[TMP8]], 16
; CHECK-NEXT:    [[TMP13:%.*]] = trunc i32 [[TMP12]] to i16
; CHECK-NEXT:    [[TMP14:%.*]] = sext i16 [[TMP13]] to i32
; CHECK-NEXT:    [[LD_A_1:%.*]] = load i16, ptr [[ADDR_A_1]], align 2
; CHECK-NEXT:    [[LD_B_1:%.*]] = load i16, ptr [[ADDR_B_1]], align 2
; CHECK-NEXT:    [[TMP16:%.*]] = load i32, ptr [[ADDR_B_1]], align 2
; CHECK-NEXT:    [[TMP17:%.*]] = trunc i32 [[TMP16]] to i16
; CHECK-NEXT:    [[TMP18:%.*]] = sext i16 [[TMP17]] to i32
; CHECK-NEXT:    [[TMP19:%.*]] = lshr i32 [[TMP16]], 16
; CHECK-NEXT:    [[TMP20:%.*]] = trunc i32 [[TMP19]] to i16
; CHECK-NEXT:    [[TMP21:%.*]] = sext i16 [[TMP20]] to i32
; CHECK-NEXT:    [[SEXT_A_1:%.*]] = sext i16 [[LD_A_1]] to i32
; CHECK-NEXT:    [[SEXT_B_1:%.*]] = sext i16 [[LD_B_1]] to i32
; CHECK-NEXT:    [[SEXT_B_0:%.*]] = sext i16 [[LD_B_0]] to i32
; CHECK-NEXT:    [[MUL_0:%.*]] = mul i32 [[TMP3]], [[TMP11]]
; CHECK-NEXT:    [[MUL_1:%.*]] = mul i32 [[TMP6]], [[TMP14]]
; CHECK-NEXT:    [[ADDR_A_2:%.*]] = getelementptr i16, ptr [[A]], i32 2
; CHECK-NEXT:    [[ADDR_B_2:%.*]] = getelementptr i16, ptr [[B]], i32 2
; CHECK-NEXT:    [[ADDR_A_3:%.*]] = getelementptr i16, ptr [[A]], i32 3
; CHECK-NEXT:    [[LD_A_2:%.*]] = load i16, ptr [[ADDR_A_2]], align 2
; CHECK-NEXT:    [[TMP23:%.*]] = load i32, ptr [[ADDR_A_2]], align 2
; CHECK-NEXT:    [[TMP24:%.*]] = trunc i32 [[TMP23]] to i16
; CHECK-NEXT:    [[TMP25:%.*]] = call i32 @llvm.arm.smlad(i32 [[TMP23]], i32 [[TMP16]], i32 [[TMP10]])
; CHECK-NEXT:    [[TMP26:%.*]] = sext i16 [[TMP24]] to i32
; CHECK-NEXT:    [[TMP27:%.*]] = lshr i32 [[TMP23]], 16
; CHECK-NEXT:    [[TMP28:%.*]] = trunc i32 [[TMP27]] to i16
; CHECK-NEXT:    [[TMP29:%.*]] = sext i16 [[TMP28]] to i32
; CHECK-NEXT:    [[LD_B_2:%.*]] = load i16, ptr [[ADDR_B_2]], align 2
; CHECK-NEXT:    [[LD_A_3:%.*]] = load i16, ptr [[ADDR_A_3]], align 2
; CHECK-NEXT:    [[SEXT_A_2:%.*]] = sext i16 [[LD_A_2]] to i32
; CHECK-NEXT:    [[SEXT_B_2:%.*]] = sext i16 [[LD_B_2]] to i32
; CHECK-NEXT:    [[SEXT_A_3:%.*]] = sext i16 [[LD_A_3]] to i32
; CHECK-NEXT:    [[MUL_2:%.*]] = mul i32 [[TMP26]], [[TMP14]]
; CHECK-NEXT:    [[MUL_3:%.*]] = mul i32 [[TMP29]], [[TMP21]]
; CHECK-NEXT:    [[ADD:%.*]] = add i32 [[MUL_0]], [[MUL_1]]
; CHECK-NEXT:    [[ADD_1:%.*]] = add i32 [[MUL_2]], [[MUL_3]]
; CHECK-NEXT:    [[ADD_2:%.*]] = add i32 [[ADD_1]], [[ADD]]
; CHECK-NEXT:    [[RES:%.*]] = add i32 [[ADD_2]], [[ACC]]
; CHECK-NEXT:    ret i32 [[TMP25]]
;
entry:
  %addr.a.1 = getelementptr i16, ptr %a, i32 1
  %addr.b.1 = getelementptr i16, ptr %b, i32 1
  %ld.a.0 = load i16, ptr %a
  %sext.a.0 = sext i16 %ld.a.0 to i32
  %ld.b.0 = load i16, ptr %b
  %ld.a.1 = load i16, ptr %addr.a.1
  %ld.b.1 = load i16, ptr %addr.b.1
  %sext.a.1 = sext i16 %ld.a.1 to i32
  %sext.b.1 = sext i16 %ld.b.1 to i32
  %sext.b.0 = sext i16 %ld.b.0 to i32
  %mul.0 = mul i32 %sext.a.0, %sext.b.0
  %mul.1 = mul i32 %sext.a.1, %sext.b.1
  %addr.a.2 = getelementptr i16, ptr %a, i32 2
  %addr.b.2 = getelementptr i16, ptr %b, i32 2
  %addr.a.3 = getelementptr i16, ptr %a, i32 3
  %ld.a.2 = load i16, ptr %addr.a.2
  %ld.b.2 = load i16, ptr %addr.b.2
  %ld.a.3 = load i16, ptr %addr.a.3
  %sext.a.2 = sext i16 %ld.a.2 to i32
  %sext.b.2 = sext i16 %ld.b.2 to i32
  %sext.a.3 = sext i16 %ld.a.3 to i32
  %mul.2 = mul i32 %sext.a.2, %sext.b.1
  %mul.3 = mul i32 %sext.a.3, %sext.b.2
  %add = add i32 %mul.0, %mul.1
  %add.1 = add i32 %mul.2, %mul.3
  %add.2 = add i32 %add.1, %add
  %res = add i32 %add.2, %acc
  ret i32 %res
}

define i32 @overlap_4(ptr %a, ptr %b, i32 %acc) {
; CHECK-LABEL: @overlap_4(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ADDR_A_1:%.*]] = getelementptr i16, ptr [[A:%.*]], i32 1
; CHECK-NEXT:    [[ADDR_B_1:%.*]] = getelementptr i16, ptr [[B:%.*]], i32 1
; CHECK-NEXT:    [[LD_A_0:%.*]] = load i16, ptr [[A]], align 2
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr [[A]], align 2
; CHECK-NEXT:    [[TMP2:%.*]] = trunc i32 [[TMP1]] to i16
; CHECK-NEXT:    [[TMP3:%.*]] = sext i16 [[TMP2]] to i32
; CHECK-NEXT:    [[TMP4:%.*]] = lshr i32 [[TMP1]], 16
; CHECK-NEXT:    [[TMP5:%.*]] = trunc i32 [[TMP4]] to i16
; CHECK-NEXT:    [[TMP6:%.*]] = sext i16 [[TMP5]] to i32
; CHECK-NEXT:    [[SEXT_A_0:%.*]] = sext i16 [[LD_A_0]] to i32
; CHECK-NEXT:    [[LD_B_0:%.*]] = load i16, ptr [[B]], align 2
; CHECK-NEXT:    [[TMP8:%.*]] = load i32, ptr [[B]], align 2
; CHECK-NEXT:    [[TMP9:%.*]] = trunc i32 [[TMP8]] to i16
; CHECK-NEXT:    [[TMP10:%.*]] = call i32 @llvm.arm.smlad(i32 [[TMP1]], i32 [[TMP8]], i32 [[ACC:%.*]])
; CHECK-NEXT:    [[TMP11:%.*]] = sext i16 [[TMP9]] to i32
; CHECK-NEXT:    [[TMP12:%.*]] = lshr i32 [[TMP8]], 16
; CHECK-NEXT:    [[TMP13:%.*]] = trunc i32 [[TMP12]] to i16
; CHECK-NEXT:    [[TMP14:%.*]] = sext i16 [[TMP13]] to i32
; CHECK-NEXT:    [[LD_A_1:%.*]] = load i16, ptr [[ADDR_A_1]], align 2
; CHECK-NEXT:    [[LD_B_1:%.*]] = load i16, ptr [[ADDR_B_1]], align 2
; CHECK-NEXT:    [[TMP16:%.*]] = load i32, ptr [[ADDR_B_1]], align 2
; CHECK-NEXT:    [[TMP17:%.*]] = trunc i32 [[TMP16]] to i16
; CHECK-NEXT:    [[TMP18:%.*]] = sext i16 [[TMP17]] to i32
; CHECK-NEXT:    [[TMP19:%.*]] = lshr i32 [[TMP16]], 16
; CHECK-NEXT:    [[TMP20:%.*]] = trunc i32 [[TMP19]] to i16
; CHECK-NEXT:    [[TMP21:%.*]] = sext i16 [[TMP20]] to i32
; CHECK-NEXT:    [[SEXT_A_1:%.*]] = sext i16 [[LD_A_1]] to i32
; CHECK-NEXT:    [[SEXT_B_1:%.*]] = sext i16 [[LD_B_1]] to i32
; CHECK-NEXT:    [[SEXT_B_0:%.*]] = sext i16 [[LD_B_0]] to i32
; CHECK-NEXT:    [[MUL_0:%.*]] = mul i32 [[TMP3]], [[TMP11]]
; CHECK-NEXT:    [[MUL_1:%.*]] = mul i32 [[TMP6]], [[TMP14]]
; CHECK-NEXT:    [[ADDR_A_2:%.*]] = getelementptr i16, ptr [[A]], i32 2
; CHECK-NEXT:    [[ADDR_B_2:%.*]] = getelementptr i16, ptr [[B]], i32 2
; CHECK-NEXT:    [[ADDR_A_3:%.*]] = getelementptr i16, ptr [[A]], i32 3
; CHECK-NEXT:    [[LD_A_2:%.*]] = load i16, ptr [[ADDR_A_2]], align 2
; CHECK-NEXT:    [[TMP23:%.*]] = load i32, ptr [[ADDR_A_2]], align 2
; CHECK-NEXT:    [[TMP24:%.*]] = trunc i32 [[TMP23]] to i16
; CHECK-NEXT:    [[TMP25:%.*]] = call i32 @llvm.arm.smladx(i32 [[TMP23]], i32 [[TMP16]], i32 [[TMP10]])
; CHECK-NEXT:    [[TMP26:%.*]] = sext i16 [[TMP24]] to i32
; CHECK-NEXT:    [[TMP27:%.*]] = lshr i32 [[TMP23]], 16
; CHECK-NEXT:    [[TMP28:%.*]] = trunc i32 [[TMP27]] to i16
; CHECK-NEXT:    [[TMP29:%.*]] = sext i16 [[TMP28]] to i32
; CHECK-NEXT:    [[LD_B_2:%.*]] = load i16, ptr [[ADDR_B_2]], align 2
; CHECK-NEXT:    [[LD_A_3:%.*]] = load i16, ptr [[ADDR_A_3]], align 2
; CHECK-NEXT:    [[SEXT_A_2:%.*]] = sext i16 [[LD_A_2]] to i32
; CHECK-NEXT:    [[SEXT_B_2:%.*]] = sext i16 [[LD_B_2]] to i32
; CHECK-NEXT:    [[SEXT_A_3:%.*]] = sext i16 [[LD_A_3]] to i32
; CHECK-NEXT:    [[MUL_2:%.*]] = mul i32 [[TMP21]], [[TMP26]]
; CHECK-NEXT:    [[MUL_3:%.*]] = mul i32 [[TMP14]], [[TMP29]]
; CHECK-NEXT:    [[ADD:%.*]] = add i32 [[MUL_0]], [[MUL_1]]
; CHECK-NEXT:    [[ADD_1:%.*]] = add i32 [[MUL_2]], [[MUL_3]]
; CHECK-NEXT:    [[ADD_2:%.*]] = add i32 [[ADD_1]], [[ADD]]
; CHECK-NEXT:    [[RES:%.*]] = add i32 [[ADD_2]], [[ACC]]
; CHECK-NEXT:    ret i32 [[TMP25]]
;
entry:
  %addr.a.1 = getelementptr i16, ptr %a, i32 1
  %addr.b.1 = getelementptr i16, ptr %b, i32 1
  %ld.a.0 = load i16, ptr %a
  %sext.a.0 = sext i16 %ld.a.0 to i32
  %ld.b.0 = load i16, ptr %b
  %ld.a.1 = load i16, ptr %addr.a.1
  %ld.b.1 = load i16, ptr %addr.b.1
  %sext.a.1 = sext i16 %ld.a.1 to i32
  %sext.b.1 = sext i16 %ld.b.1 to i32
  %sext.b.0 = sext i16 %ld.b.0 to i32
  %mul.0 = mul i32 %sext.a.0, %sext.b.0
  %mul.1 = mul i32 %sext.a.1, %sext.b.1
  %addr.a.2 = getelementptr i16, ptr %a, i32 2
  %addr.b.2 = getelementptr i16, ptr %b, i32 2
  %addr.a.3 = getelementptr i16, ptr %a, i32 3
  %ld.a.2 = load i16, ptr %addr.a.2
  %ld.b.2 = load i16, ptr %addr.b.2
  %ld.a.3 = load i16, ptr %addr.a.3
  %sext.a.2 = sext i16 %ld.a.2 to i32
  %sext.b.2 = sext i16 %ld.b.2 to i32
  %sext.a.3 = sext i16 %ld.a.3 to i32
  %mul.2 = mul i32 %sext.b.2, %sext.a.2
  %mul.3 = mul i32 %sext.b.1, %sext.a.3
  %add = add i32 %mul.0, %mul.1
  %add.1 = add i32 %mul.2, %mul.3
  %add.2 = add i32 %add.1, %add
  %res = add i32 %add.2, %acc
  ret i32 %res
}
