set(VCPKG_BUILD_TYPE release) # header-only

vcpkg_from_github(
    OUT_SOURCE_PATH SOURCE_PATH
    REPO bw-hro/webthing-cpp
    REF "v${VERSION}"
    SHA512 a4df3424721542ea4a7951ffc643905d31d906bcf87bed613b422ba8c0babb406f842459ba6c6df73c332c70c6fdd639413dc42272fd3b27fdf96b2cee528d36
    HEAD_REF master
)

vcpkg_check_features(OUT_FEATURE_OPTIONS FEATURE_OPTIONS
    FEATURES
        ssl   WT_WITH_SSL
)

vcpkg_cmake_configure(
    SOURCE_PATH "${SOURCE_PATH}"
    OPTIONS
        ${FEATURE_OPTIONS}
        -DWT_BUILD_EXAMPLES=OFF
        -DWT_BUILD_TESTS=OFF
)

vcpkg_cmake_install()

vcpkg_install_copyright(FILE_LIST "${SOURCE_PATH}/LICENSE.txt")

file(INSTALL "${CMAKE_CURRENT_LIST_DIR}/usage" DESTINATION "${CURRENT_PACKAGES_DIR}/share/${PORT}")
