v {xschem version=3.4.6 file_version=1.2
*
* This file is part of XSCHEM,
* a schematic capture and Spice/Vhdl/Verilog netlisting tool for circuit
* simulation.
* Copyright (C) 1998-2024 Stefan Frederik Schippers
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
}
G {}
K {type=subcircuit
format="@name @pinlist @symname"
template="name=x1"

}
V {}
S {}
E {}
L 15 270 -540 340 -470 {}
L 15 270 -410 340 -470 {}
B 2 1400 -260 1660 -130 {flags=graph
y1=-44
y2=44
divy=4
subdivy=1
x1=0.0247231
x2=0.0249981
divx=8
subdivx=4
dataset=0
unitx=m


color=7
node=tcleval($\{path\}outi)
jpeg_quality=30
hilight_wave=0
xlabmag=1.4
linewidth_mult=1.2}
B 2 960 -980 1094 -893 {flags=image alpha=0.7
image_data=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
symbol_ignore=true}
B 2 1400 -440 1660 -260 {flags=graph
y1=0
y2=170
divy=4
subdivy=1
x1=0.0247231
x2=0.0249981
divx=8
subdivx=4
dataset=0
unitx=m



color="8 7"
node="tcleval(\\"Xm1 power;vpp $\{path\}outi - i(v.$\{path\}vu) *\\"
\\"Average;vpp $\{path\}outi - i(v.$\{path\}vu) * 200u ravg()\\")"
jpeg_quality=30
xlabmag=1.4}
B 2 1400 -620 1660 -440 {flags=graph
y1=-0.078
y2=170
divy=4
subdivy=1
x1=0.0247231
x2=0.0249981
divx=8
subdivx=4
dataset=0
unitx=m

color="8 7"
node="tcleval(Xm2 Power;$\{path\}outi vnn - i(v.$\{path\}vd) *
Average;$\{path\}outi vnn - i(v.$\{path\}vd) * 200u ravg())"
jpeg_quality=30
xlabmag=1.4}
B 2 960 -1050 1094 -987 {flags=image
alpha=0.7
image=/home/schippes/x/3.png
image_data=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
symbol_ignore=true}
P 4 5 0 -1290 1390 -1290 1390 -130 0 -130 0 -1290 {dash=3}
T {ANALOG AUDIO AMPLIFIER
N-Channel only power stage} 290 -380 0 0 0.5 0.5 {layer=8 symbol_ignore=true}
T {@name} 40 -1350 0 0 0.8 0.8 {}
T {@symname} 1320 -1350 0 1 0.8 0.8 {}
T {( @#0:resolved_net )} 120 -635 0 1 0.2 0.2 {name=p0 layer=15}
T {( @#0:resolved_net )} 120 -585 0 1 0.2 0.2 {name=p1 layer=15}
T {( @#0:resolved_net )} 1360 -665 0 1 0.2 0.2 {name=p5 layer=15}
T {@name} 805 -486.25 2 0 0.2 0.2 {
name=R11}
T {@value} 783.75 -545 2 1 0.2 0.2 {
name=R11}
T {m=@m} 805 -501.25 2 0 0.2 0.2 {
name=R11}
N 180 -590 180 -550 {lab=E9}
N 260 -550 340 -550 {lab=E9}
N 340 -590 340 -550 {lab=E9}
N 1110 -790 1110 -760 {lab=SA}
N 840 -1110 840 -1070 {lab=E4}
N 1110 -680 1110 -660 {lab=OUTI}
N 1110 -600 1110 -560 {lab=#net1}
N 180 -1110 180 -1070 {lab=E1}
N 390 -880 520 -880 {lab=C2}
N 230 -1040 230 -990 {lab=#net2}
N 180 -990 230 -990 {lab=#net2}
N 390 -880 390 -830 {lab=C2}
N 340 -830 390 -830 {lab=C2}
N 180 -1010 180 -990 {lab=#net2}
N 220 -1040 230 -1040 {lab=#net2}
N 340 -850 340 -830 {lab=C2}
N 380 -880 390 -880 {lab=C2}
N 180 -1210 180 -1170 {lab=VBOOST}
N 840 -1210 840 -1170 {lab=VBOOST}
N 180 -1210 690 -1210 {lab=VBOOST}
N 690 -1210 840 -1210 {lab=VBOOST}
N 1110 -1270 1240 -1270 {lab=VPP}
N 840 -1210 1240 -1210 {lab=VBOOST}
N 860 -530 1070 -530 {lab=GB}
N 560 -550 560 -530 {lab=C8}
N 1240 -990 1240 -960 {lab=#net3}
N 560 -670 560 -610 {lab=E8}
N 560 -850 560 -730 {lab=C6}
N 840 -870 840 -850 {lab=GA}
N 690 -900 690 -880 {lab=B1}
N 690 -900 800 -900 {lab=B1}
N 690 -1210 690 -970 {lab=VBOOST}
N 690 -910 690 -900 {lab=B1}
N 260 -550 260 -540 {lab=E9}
N 150 -180 260 -180 {lab=VSS}
N 50 -300 220 -300 {lab=B3}
N 260 -270 260 -240 {lab=E3}
N 150 -240 150 -180 {lab=VSS}
N 50 -220 50 -180 {lab=VSS}
N 50 -180 150 -180 {lab=VSS}
N 690 -690 1110 -690 {lab=OUTI}
N 180 -550 260 -550 {lab=E9}
N 1110 -700 1110 -690 {lab=OUTI}
N 860 -470 1110 -470 {lab=SB}
N 860 -790 1110 -790 {lab=SA}
N 1240 -1210 1240 -1050 {lab=VBOOST}
N 1110 -500 1110 -470 {lab=SB}
N 1110 -820 1110 -790 {lab=SA}
N 860 -850 1070 -850 {lab=GA}
N 340 -830 340 -780 {lab=C2}
N 340 -720 340 -650 {lab=C9}
N 220 -720 340 -720 {lab=C9}
N 180 -690 180 -650 {lab=C5}
N 1330 -680 1390 -680 {lab=OUT}
N 1110 -680 1240 -680 {lab=OUTI}
N 1110 -690 1110 -680 {lab=OUTI}
N 340 -950 340 -910 {lab=#net4}
N 560 -950 560 -910 {lab=#net5}
N 560 -1110 560 -1010 {lab=E6}
N 340 -1110 340 -1010 {lab=E2}
N 260 -360 260 -330 {lab=C3}
N 730 -530 770 -530 {lab=#net6}
N 560 -530 670 -530 {lab=C8}
N 690 -740 690 -690 {lab=OUTI}
N 690 -820 690 -800 {lab=#net7}
N 180 -930 180 -750 {lab=C7}
N 840 -950 840 -930 {lab=E11}
N 1240 -900 1240 -680 {lab=OUTI}
N 860 -850 860 -840 {lab=GA}
N 860 -800 860 -790 {lab=SA}
N 860 -530 860 -520 {lab=GB}
N 860 -480 860 -470 {lab=SB}
N 1240 -680 1270 -680 {lab=OUTI}
N 830 -530 860 -530 {lab=GB}
N 840 -850 860 -850 {lab=GA}
N 340 -1270 340 -1170 { lab=VPP}
N 560 -1270 560 -1170 { lab=VPP}
N 0 -1270 340 -1270 {lab=VPP}
N 340 -1270 560 -1270 {lab=VPP}
N 1110 -1270 1110 -880 { lab=VPP}
N 560 -1270 1110 -1270 {lab=VPP}
N 230 -1040 800 -1040 { lab=#net2}
N 0 -180 50 -180 {
lab=VSS}
N 0 -140 1110 -140 {
lab=VNN}
N 1110 -410 1110 -140 {lab=VNN}
N 0 -620 140 -620 {
lab=PLUS}
N 0 -570 400 -570 {
lab=MINUS}
N 400 -620 400 -570 {
lab=MINUS}
N 380 -620 400 -620 {
lab=MINUS}
N 150 -400 150 -360 {
lab=VPP}
N 50 -300 50 -280 {
lab=B3}
C {ipin.sym} 0 -620 0 0 {name=p0 lab=PLUS}
C {ipin.sym} 0 -140 0 0 {name=p3 lab=VNN}
C {nmos3.sym} 1090 -530 0 0 {name=xm2 model=irf540 m=1
program=evince
url="https://www.vishay.com/docs/91021/irf540.pdf"
}
C {res.sym} 960 -500 0 1 {name=R7 m=1 value=320}
C {nmos3.sym} 1090 -850 0 0 {name=xm1 model=irf540 m=1
program=evince
url="https://www.vishay.com/docs/91021/irf540.pdf"}
C {res.sym} 960 -820 0 1 {name=R0 m=1 value=320}
C {lab_wire.sym} 880 -530 0 0 {name=l8 lab=GB}
C {res.sym} 340 -1140 0 1 {name=R2 m=1 value=50}
C {res.sym} 180 -1140 0 1 {name=R3 m=1 value=50}
C {lab_pin.sym} 340 -1170 0 0 {name=p10 lab=VPP}
C {npn.sym} 160 -620 0 0 {name=Q5 model=q2n2222 area=1}
C {pnp.sym} 820 -1040 0 0 {name=Q4 model=q2n2907p area=1}
C {res.sym} 840 -1140 0 1 {name=R9 m=1 value=50}
C {pnp.sym} 540 -880 0 0 {name=Q6 model=q2n2907p area=1}
C {res.sym} 560 -1140 0 1 {name=R4 m=1 value=50}
C {lab_pin.sym} 180 -670 0 0 {name=p15 lab=C5}
C {lab_pin.sym} 340 -670 0 1 {name=p16 lab=C9}
C {lab_pin.sym} 180 -1090 0 0 {name=p17 lab=E1}
C {lab_pin.sym} 560 -1170 0 0 {name=p25 lab=VPP}
C {lab_pin.sym} 340 -1090 0 1 {name=p23 lab=E2}
C {lab_pin.sym} 560 -1070 0 1 {name=p28 lab=E6}
C {lab_pin.sym} 840 -1090 0 0 {name=p29 lab=E4}
C {lab_pin.sym} 180 -1210 0 0 {name=p34 lab=VBOOST}
C {ammeter.sym} 1110 -630 0 0 {name=vd}
C {ammeter.sym} 1110 -730 0 0 {name=vu}
C {pnp.sym} 200 -1040 0 1 {name=Q1 model=q2n2907p area=1}
C {pnp.sym} 360 -880 0 1 {name=Q2 model=q2n2907p area=1}
C {npn.sym} 360 -620 0 1 {name=Q9 model=q2n2222 area=1}
C {lab_pin.sym} 560 -760 0 0 {name=p9 lab=C6}
C {code.sym} 970 -350 0 0 {name=STIMULI
only_toplevel=true
value=".option PARHIER=LOCAL RUNLVL=6 post MODMONTE=1 warn maxwarn=6000
.option sampling_method = SRS ingold=1
.option method=gear
.option savecurrents
.temp 30



vvss vss 0 dc 0 
vvpp vpp 0 dc 50
vvnn vnn 0 dc -50

rfb1 vpp minus 100k
rfb2 out minus 100k
rfb3 minus vdc '100k/43'


vvdc vdc 0 dc 21.3
eref vref 0 plus vdc 45

vplus plus vdc dc 0

evboost vboost 0 vol='v(out)>=40 ? v(out)+10 : 50'
rload out 0 4

** models are generally not free: you must download
** SPICE models for active devices and put them  into the below 
** referenced file in simulation directory.
.include \\"models_poweramp.txt\\"
.dc vplus '-1.5' '1.5' 0.1
.save all
.op
*.probe dc v(plus,vdc)
"}
C {lab_wire.sym} 920 -850 0 0 {name=l1 lab=GA}
C {res.sym} 800 -530 1 1 {name=R11 m=1 value=1000
hide_texts=true}
C {pnp.sym} 540 -580 0 0 {name=Q8 model=q2n2907p area=1}
C {capa.sym} 1240 -1020 0 0 {name=C12 m=1 value="40u"}
C {diode.sym} 920 -1240 0 0 {name=D0 model=d1n4148 area=1
url="http://pdf.datasheetcatalog.com/datasheet/bytes/1N5406.pdf"}
C {res.sym} 1240 -930 0 1 {name=R18 m=1 value=200}
C {zener.sym} 1240 -1240 0 0 {name=D1 model=d1n758 area=1
url="http://www.futurlec.com/Datasheet/Diodes/1N746-1N759.pdf"}
C {res.sym} 690 -850 0 1 {name=R14 m=1 value=4k}
C {pnp.sym} 820 -900 0 0 {name=Q11 model=q2n2907p area=1}
C {res.sym} 690 -940 0 1 {name=R15 m=1 value=4k}
C {res.sym} 260 -510 0 1 {name=R5 m=1 value=40}
C {res.sym} 260 -450 0 1 {name=R6 m=1 value=40}
C {zener.sym} 150 -270 2 0 {name=D2 model=1N746 area=1
url="http://www.futurlec.com/Datasheet/Diodes/1N746-1N759.pdf"
}
C {npn.sym} 240 -300 0 0 {name=Q3 model=q2n2222 area=1}
C {res.sym} 150 -330 0 1 {name=R1 m=1 value=7k}
C {lab_pin.sym} 150 -400 0 0 {name=p7 lab=VPP}
C {res.sym} 260 -210 0 1 {name=R10 m=1 value=110}
C {capa.sym} 50 -250 0 0 {name=C3 m=1 value=100n}
C {res.sym} 560 -700 0 1 {name=R12 m=1 value=400}
C {lab_pin.sym} 690 -890 0 0 {name=p12 lab=B1}
C {lab_pin.sym} 340 -550 0 1 {name=p13 lab=E9}
C {lab_pin.sym} 560 -530 0 0 {name=p19 lab=C8}
C {lab_pin.sym} 560 -650 0 1 {name=p20 lab=E8}
C {lab_pin.sym} 840 -940 0 0 {name=p21 lab=E11}
C {lab_pin.sym} 260 -260 0 1 {name=p22 lab=E3}
C {lab_pin.sym} 260 -350 0 0 {name=p26 lab=C3}
C {lab_pin.sym} 50 -300 0 0 {name=p30 lab=B3}
C {lab_pin.sym} 520 -580 0 0 {name=p33 lab=VSS}
C {res.sym} 340 -750 0 1 {name=R13 m=1 value=300}
C {npn.sym} 200 -720 0 1 {name=Q7 model=q2n2222 area=1}
C {lab_pin.sym} 180 -780 0 0 {name=p8 lab=C7}
C {lab_pin.sym} 340 -800 0 1 {name=p31 lab=C2}
C {title.sym} 160 -30 0 0 {name=l2 author="Stefan Schippers"}
C {lab_pin.sym} 860 -790 0 0 {name=p32 lab=SA}
C {ammeter.sym} 1110 -440 0 0 {name=v0}
C {lab_pin.sym} 860 -470 0 0 {name=p35 lab=SB}
C {ammeter.sym} 560 -980 0 0 {name=v1}
C {ammeter.sym} 340 -980 0 0 {name=v2}
C {ammeter.sym} 260 -390 0 0 {name=v3}
C {ammeter.sym} 700 -530 3 0 {name=v4}
C {ammeter.sym} 690 -770 0 0 {name=v5}
C {ammeter.sym} 180 -960 0 1 {name=v6}
C {ammeter.sym} 840 -980 0 0 {name=v7}
C {spice_probe_vdiff.sym} 860 -500 0 0 {name=p37 }
C {spice_probe_vdiff.sym} 860 -820 0 0 {name=p38 voltage=3.68}
C {ammeter.sym} 1300 -680 3 0 {name=v8}
C {opin.sym} 1390 -680 0 0 {name=p5 lab=OUT}
C {ipin.sym} 0 -570 0 0 {name=p1 lab=MINUS}
C {ipin.sym} 0 -180 0 0 {name=p4 lab=VSS}
C {launcher.sym} 510 -420 0 0 {name=h2
descr="Ctrl-Click
Clear all probes" 
tclcommand="
    xschem push_undo
    xschem set no_undo 1
    xschem set no_draw 1
 
    set lastinst [xschem get instances]
    for \{ set i 0 \} \{ $i < $lastinst \} \{incr i \} \{
      set type [xschem getprop instance $i cell::type]
      if \{ [regexp \{(^|/)probe$\} $type ] \} \{
        xschem setprop $i voltage fast
      \}
      if \{ [regexp \{current_probe$\} $type ] \} \{
        xschem setprop $i current fast
      \}
      if \{ [regexp \{differential_probe$\} $type ] \} \{
        xschem setprop $i voltage fast
      \}
    \}
    xschem set no_undo 0
    xschem set no_draw 0
    xschem redraw
"
}
C {ngspice_get_expr.sym} 800 -1090 0 1 {name=r8 
node="[format %.4g [expr [ngspice::get_voltage e4] - [ngspice::get_voltage c7]]]"
descr = veb
}
C {ngspice_get_expr.sym} 880 -1070 0 0 {name=r16 
node="[format %.4g [expr [ngspice::get_current \{q4[ic]\}] / [ngspice::get_current \{q4[ib]\}] ] ]"
descr = beta
}
C {ngspice_get_expr.sym} 860 -1010 0 0 {name=r17 
node="[format %.4g [expr ([ngspice::get_voltage e4] - [ngspice::get_voltage e11]) * [ngspice::get_current \{q4[ic]\}]]] W"
descr = power
}
C {ngspice_get_expr.sym} 800 -1060 0 1 {name=r23 
node="[ngspice::get_current \{q4[ib]\}]"
descr = Ib
}
C {ngspice_get_expr.sym} 580 -550 0 0 {name=r24 
node="[format %.4g [expr ([ngspice::get_voltage e8] - [ngspice::get_voltage c8]) * [ngspice::get_current \{q8[ic]\}]]] W"
descr = power
}
C {ngspice_get_expr.sym} 240 -300 0 1 {name=r26 
node="[format %.4g [expr [ngspice::get_current \{q3[ic]\}] / [ngspice::get_current \{q3[ib]\}] ] ]"
descr = beta
}
C {ngspice_get_expr.sym} 860 -870 0 0 {name=r27 
node="[format %.4g [expr ([ngspice::get_voltage e11] - [ngspice::get_voltage ga]) * [ngspice::get_current \{q11[ic]\}]]] W"
descr = power
}
C {ngspice_get_expr.sym} 1000 -800 0 0 {name=r28 
node="[to_eng [ngspice::get_current \{r0[i]\}]]" 
descr = current
}
C {ngspice_get_expr.sym} 300 -290 2 1 {name=r29 
node="[format %.4g [expr ([ngspice::get_voltage c3] - [ngspice::get_voltage e3]) * [ngspice::get_current \{q3[ic]\}]]] W"
descr = power
}
C {ngspice_get_expr.sym} 300 -260 2 1 {name=r30 
node="[format %.4g [expr [ngspice::get_voltage b3] - [ngspice::get_voltage e3]]]"
descr = vbe
}
C {ngspice_get_expr.sym} 340 -470 0 0 {name=r31 
node="[format %.4g [expr ([ngspice::get_voltage e9] - [ngspice::get_voltage c3]) * [ngspice::get_current \{r5[i]\}]]] W"
descr = power
}
C {ngspice_get_expr.sym} 570 -910 0 0 {name=r32 
node="[format %.4g [expr ([ngspice::get_voltage e6] - [ngspice::get_voltage c6]) * [ngspice::get_current \{q6[ic]\}]]] W"
descr = power
}
C {ngspice_get_expr.sym} 130 -690 0 1 {name=r33 
node="[format %.4g [expr ([ngspice::get_voltage c7] - [ngspice::get_voltage c5]) * [ngspice::get_current \{q7[ic]\}]]]"
descr = power
}
C {ngspice_get_expr.sym} 200 -590 0 0 {name=r34 
node="[format %.4g [expr ([ngspice::get_voltage c5] - [ngspice::get_voltage e9]) * [ngspice::get_current \{q5[ic]\}]]]"
descr = power
}
C {ngspice_get_expr.sym} 320 -590 0 1 {name=r35 
node="[format %.4g [expr ([ngspice::get_voltage c9] - [ngspice::get_voltage e9]) * [ngspice::get_current \{q9[ic]\}]]]"
descr = power
}
C {ngspice_get_expr.sym} 330 -850 0 1 {name=r36 
node="[format %.4g [expr [ngspice::get_current \{q2[ic]\}] / [ngspice::get_current \{q2[ib]\}] ] ]"
descr = beta
}
C {ngspice_get_expr.sym} 140 -350 0 1 {name=r42 
node="[format %.4g [expr ([ngspice::get_node v(vpp)] - [ngspice::get_voltage b3]) * [ngspice::get_current \{r1[i]\}]]] W"
descr = power
}
C {ngspice_get_expr.sym} 1130 -830 2 1 {name=r43 
node="[format %.4g [expr \{([ngspice::get_node v(vpp)] - [ngspice::get_voltage outi]) * [ngspice::get_current vu]\}]] W"
descr = power
}
C {lab_wire.sym} 910 -690 0 1 {name=l40 lab=OUTI}
C {ngspice_get_expr.sym} 1130 -510 2 1 {name=r46 
node="[format %.4g [expr \{([ngspice::get_voltage outi] - [ngspice::get_node v(vnn)]) * [ngspice::get_current vd]\}]] W"
descr = power
}
C {ngspice_get_expr.sym} 150 -250 2 0 {name=r47 
node="[format %.4g [expr -[ngspice::get_voltage b3] * [ngspice::get_current \{d2[id]\}]]] W"
descr = power
}
C {launcher.sym} 760 -260 0 0 {name=h3
descr="Load file into gaw" 
comment="
  This launcher gets raw filename from current schematic using 'xschem get schname'
  and stripping off path and suffix.  It then loads raw file into gaw.
  This allow to use it in any schematic without changes.
"
tclcommand="
set rawfile [file tail [file rootname [xschem get schname]]].raw
gaw_cmd \\"tabledel $rawfile
load $netlist_dir/$rawfile
table_set $rawfile\\"
unset rawfile"
}
C {spice_probe.sym} 1010 -850 0 0 {name=p40  voltage=3.543}
C {spice_probe.sym} 1000 -530 0 0 {name=p56  voltage=-46.18}
C {spice_probe.sym} 420 -880 0 0 {name=p57 voltage=48.06}
C {spice_probe.sym} 280 -1040 0 0 {name=p58  voltage=47.27}
C {spice_probe.sym} 180 -810 0 0 {name=p59  voltage=47.27}
C {spice_probe.sym} 1020 -1210 0 0 {name=p62  voltage=49.04}
C {launcher.sym} 760 -300 0 0 {name=h1
descr=Backannotate
tclcommand="xschem annotate_op"}
C {launcher.sym} 760 -340 0 0 {name=h4
descr="View Raw file" 
tclcommand="textwindow $netlist_dir/[file tail [file rootname [ xschem get schname 0 ] ] ].raw"
}
C {spice_probe.sym} 790 -690 0 0 {name=p60 analysis=tran voltage=-0.1364}
C {ipin.sym} 0 -1270 0 0 {name=p11 lab=VPP}
C {ngspice_get_expr.sym} 1130 -550 0 0 {name=r19 
node="[ngspice::get_current \{xm2.rd[i]\}]" 
descr = current
}
C {ngspice_get_expr.sym} 1130 -860 0 0 {name=r22 
node="[ngspice::get_current \{xm1.rd[i]\}]" 
descr = current
}
C {ngspice_get_expr.sym} 610 -830 0 1 {name=r20 
node="[format %.4g [expr [ngspice::get_current \{q6[ic]\}] / [ngspice::get_current \{q6[ib]\}] ] ]"
descr = beta
}
C {ngspice_get_expr.sym} 130 -730 0 1 {name=r21 
node="[format %.4g [expr [ngspice::get_current \{q7[ic]\}] / [ngspice::get_current \{q7[ib]\}] ] ]"
descr = beta
}
C {launcher.sym} 460 -190 0 0 {name=h5
descr=hi_current
tclcommand="
set incr_hilight 0
foreach \{n s t\} [xschem instance_list] \{
  if \{$t == \{label\} || $t == \{ipin\} || $t == \{opin\} || $t == \{iopin\}\} \{continue\}
  set curr 0
  if \{$t == \{resistor\} || $t == \{ammeter\} \} \{
    set curr [expr \{ abs([from_eng [xschem translate $n \{@spice_get_current\}]])\}]
  \} elseif \{$t == \{pnp\}  || $t == \{npn\}\} \{
    set curr [expr \{abs([ngspice::get_current $n\\\\\\[ic\\\\\\]])\}]
  \} elseif \{$t == \{nmos\}\} \{
    set curr [expr \{abs([ngspice::get_current $n.rd\\\\\\[i\\\\\\]])\}]
  \} else \{continue\}
  if \{$curr > 0.02\} \{
    xschem set hilight_color 11
    xschem hilight_instname $n fast
  \} elseif \{$curr > 0.01\} \{
    xschem set hilight_color 0
    xschem hilight_instname $n fast
  \} else \{
    xschem set hilight_color 4
    xschem hilight_instname $n fast
  \}
\}
xschem redraw

"
}
