<div align="center">
  <h1><code>wasip1</code></h1>

<strong>A <a href="https://bytecodealliance.org/">Bytecode Alliance</a> project</strong>

  <p>
    <strong>WASIp1 API Bindings for Rust</strong>
  </p>

  <p>
    <a href="https://crates.io/crates/wasip1"><img src="https://img.shields.io/crates/v/wasip1.svg?style=flat-square" alt="Crates.io version" /></a>
    <a href="https://crates.io/crates/wasip1"><img src="https://img.shields.io/crates/d/wasip1.svg?style=flat-square" alt="Download" /></a>
    <a href="https://docs.rs/wasip1/"><img src="https://img.shields.io/badge/docs-latest-blue.svg?style=flat-square" alt="docs.rs docs" /></a>
  </p>
</div>

> **Note**: Development of WASIp1 has ceased at the standards body level and
> development of this crate has all but ceased as well. This is present for
> ongoing maintenance but is not expected to receive any further major updates.
> See the `wasip2` crate for a more up-to-date experience.

This crate contains API bindings for [WASIp1](https://github.com/WebAssembly/WASI)
system calls in Rust, and currently reflects the `wasi_snapshot_preview1`
module. This crate is quite low-level and provides conceptually a "system call"
interface. In most settings, it's better to use the Rust standard library, which
has WASI support.

The `wasip1` crate is also entirely procedurally generated from the `*.witx` files
describing the WASI apis. While some conveniences are provided the bindings here
are intentionally low-level!

# Usage

First you can depend on this crate via `Cargo.toml`:

```toml
[dependencies]
wasip1 = "1.0.0"
```

Next you can use the APIs in the root of the module like so:

```rust
fn main() {
    let stdout = 1;
    let message = "Hello, World!\n";
    let data = [wasip1::Ciovec {
        buf: message.as_ptr(),
        buf_len: message.len(),
    }];
    wasip1::fd_write(stdout, &data).unwrap();
}
```

# Development

The bulk of the `wasip1` crate is generated by the `witx-bindgen` tool, which
lives at `crates/witx-bindgen` and is part of the cargo workspace.

The `src/lib_generated.rs` file can be re-generated with the following command:

```
cargo run -p witx-bindgen -- crates/wasip1/wasi_snapshot_preview1.witx > crates/wasip1/src/lib_generated.rs
```

The `*.witx` files are vendored with `./ci/vendor-wit.sh` and are located at
`crates/wasip1/*.witx`.
