# Live Panel

In release [v0.9.9v](https://github.com/directvt/vtm/releases/tag/v0.9.9v) a slot for the desktop live panel was introduced. 

## Panel contents

The following [configuration](../src/vtm.xml) section deals with setting up the panel:
```xml
<config>
    <desktop>
        <panel> <!-- Desktop info panel. -->
            <cmd = ""/> <!-- Command-line to activate. -->
            <cwd = ""/> <!-- Working directory. -->
            <height = 1 /> <!-- Desktop space reserved on top. -->
        </panel>
    </desktop>
</config>
```

This section can be used to specify the panel height and commands for continuous content generation. The content for the panel can be any console output, be it generated by a script, by a CUI application, or by something else. All emitted text and control sequences will be processed at the [VT-100](https://invisible-island.net/xterm/ctlseqs/ctlseqs.html) compatibility level. Note that vtm will be automatically disconnected when the connected source ends.

### Live script example

For this script I will be using `python3`, but I guess you can adapt this to your favorite language. A bash version will be below, to help if you don't understand python.

Set the path to your script in `settings.xml` by changing the `config/desktop/panel/cmd` tag to contain the path, place your script at that location, and we can start.

First, the concept.

The panel works by running your command in a terminal control at the top of the desktop. This means that by default you will have a scrollback buffer and scrollbars. To change that, (and thus to save a little amount of memory) print the following vt-sequence: `\e[?1049h`. This sequence will switch the terminal control to an alternate buffer mode, in which the working area is only the terminal viewport without scrollback buffer.

This means our script now looks like this:
```python
#!/usr/bin/env python3
# my custom panel

print("\033[?1049h") # switch to altbuf mode

```

If you print data, that data will push the previous data off-screen. The script has to run in a loop to make sure the data gets updated. So, add a loop which collects data and prints that.
```python
#!/usr/bin/env python3
# my custom panel
from time import sleep # import sleep() function

print("\033[?1049h") # switch to altbuf mode
while True: # loop infinitly
    data='My data' # collect data
    print(data) # print data
    sleep(1) # wait 1 second before looping back to the start

```
This will print `My data` to the panel every 1 second.

I guess we now want to print some actual data. Lets print the time.
    In python, we get that from `datetime.datetime.now()`. `datetime.datetime.now()` returns the time in this format: `YYYY-MM-DD HH:MM:SS.SSSSSS`. We don't want the date or nanoseconds, so lets split those off: `datetime.datetime.now().split(' ')[1].split('.')[0]` returns `HH:MM:SS`. perfect.
Now lets put that in the script:
```python
#!/usr/bin/env python3
# my custom panel
from time import sleep # import sleep() function
import datetime

print("\033[?1049h") # switch to altbuf mode
while True: # loop infinitly
    time=datetime.datetime.now().split(' ')[1].split('.')[0] # get current time
    print(time) # print data: the time
    sleep(1) # wait 1 second before looping back to the start

```
This will print the current time to the panel, and you can see it update every second.

You probably want to add more data, and that is possible. Just collect more data, and add the variables to the `print()` function.
Here I added a date and the text `Hello world!`, and I seperated them all by ` | `:
```python
#!/usr/bin/env python3
# my custom panel
from time import sleep # import sleep() function
import datetime

print("\033[?1049h") # switch to altbuf mode
while True: # loop infinitly
    time=datetime.datetime.now().split(' ')[1].split('.')[0] # get current time
    date=datetime.datetime.now().split(' ')[0]
    print(time,'|',date,'|','Hello world!') # print data: time | date | Hello world!
    sleep(1) # wait 1 second before looping back to the start

```

A full script to base your own panel on can be found [here](https://github.com/Vosjedev/vtm-panel/). The full script provides live status of system resource usage.

A bash adaptation of the script we just created in python (so people that don't 'speak' python know what's going on):
```shell
#!/usr/bin/env bash
# my custom panel

echo -e "\e[?1049h" # switch to altbuf mode

while true; do
    time="$(date +%X)" # get time (in local format)
    date="$(date +%x)" # get date (in local format)
    echo "$time | $date | Hello world!" # print data: time | date | Hello world!
    sleep 1
done

```

<sub>Written by [vosjedev](https://vosjedev.pii.at/)</sub>
