package com.unciv.logic

import com.badlogic.gdx.Gdx
import com.unciv.UncivGame
import com.unciv.logic.files.UncivFiles
import com.unciv.models.metadata.GameSettings
import com.unciv.models.ruleset.RulesetCache
import com.unciv.testing.GdxTestRunner
import com.unciv.testing.RedirectOutput
import com.unciv.testing.RedirectPolicy
import org.junit.Before
import org.junit.Ignore
import org.junit.Test
import org.junit.runner.RunWith


@RunWith(GdxTestRunner::class)
class LoadGameTest {
    // Created 2023-08, v4.7.12, vanilla base ruleset, Spectator, 4 AI, 9 CS, startingEra=Information era and advanced to turn 13:
    // Updated 2025-11-23 to remove reliance on backward compatibility
    private val vanillaGameWithCityStates = "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"

    // Created 2023-06-23, 4.12.2-patch1, G&K base ruleset, Spectator, 3 AI, 4 CS, tiny hex map, startingEra=Renaissance and advanced to turn 60, forced a war by manipulating diplomacy flags:
    // Updated 2025-11-23 to remove reliance on backward compatibility
    private val gnkWithReligion = "H4sIAAAAAAAA/+19bXPbOLLuX1Hp0zl1rRwC4Guq7gfHM3Gymzje2Htyb23lAyVRNm8kUYeUkvFO5b/fBsAXkARI8E327GyNazckHxFAowF099MAf59/D+IkjPbz17/P96fdMojnr82L+SoO/GOw/hIeH+mTY/Dbcf56br5C7itkzS9yKEKO9/Mn4MPv4Tb8p3+EVyXz1//4nd658XcB/OqNHy/9OPThwQW8aZW+cfWYfA6SwI9Xj8EafjL/JfZ3/szfr2e3UXCMnwD96XAMV/RnH/3jY7Dz06vrU7hd89urx3AfMOzHcB/uH+Afv+4f4F4Q86s7HyrG769PK1ZB+PclLZX97OoUx8F+Rf95Gx2P/OblQxyuTtvjKQ7g6n0c7Wdfovgbf8/9YxBtowdWZnD0t7MrPznyR1fQ+mN8WqWlXPnbYL/2Y1bTJNqzd98dg2DLsLuDn9BWvIviJFj6q2+zz+Gav+j28Snhbb2P/cOB33wD9fhnINTk6jH87m/ZW6FSsy+P/M2X+3AH1Xp3SpYgTfb4SxxmVaQ9NbsL4u/hKmAlhdsoiQ6PT/Ov0JGHaBuuwgD68HferWKT0rv/cwqS40d/7z9QFaB34mAbPgCgdPMh2q6D/eUDe9k8OUZxsH7HGhNAs19j18v06NPmWsAi+luqf7dBdNgG9MeHKNwfk7dRfAOKeE2fXQfQ7f72Kjrtj6zAObs9S+/D6w2DKmaQHKBeUKlS1aDtUJ2nchtO4T4p3Ql+O2xppT8HD3yEwAuhLlv/KYjvnw5Ut9+ddj7t6ULb7w7B6ujD2wVlj4MD1A3kf1/VenQhGwlvQZqPR6qyW3gZ9DpXhXw0gAr5OxglPwJayuUqOiXpE1CqJb1g6ndzWm3hrbO3p4Tf+Bgtw20wu/dXKfxztIyyEZYNn88wYOLIZ+NLPng++AlMGqpR9MbfbsOsPm9PdAzNaLvZuN0foh9rVuu3QXykUwa7qI6jX1fRPtplTSqNKVpmCDJLx+blkeJmdEzGvPR9NkwDEF60251Aeum8JA66zwF05CrwlyCQWz8+KgYiFSgo7Hp2Ge/YC2Aagtaxst7v1yBrmNmymY9J7BhA+49BIhuwtOO2RyqKOxhk+2O4EesuDEW4gDqFK1q5fCqglT8dueglk+VHEOfRj59m7N18cMMkSEU6u42DpGEefRNmM9rnaPUte58wuZbnVNoHfj4JciWFWeNIr3552vs7aD/TJD73ac6rn8PNtjbD3vjfwwe/qtBhkmr09TZaiuIXZlwoPYy4LmWzdW0Olk6zl+vvPohvPStp8hhzLVPz7Snmkg42cQhzTVb1262flXWZ0EEf7bgA9hGdIvZZK24f/XgHmnsCsL9NJp21X8pMvA5hJoZGP9HXX8HIeIRn9N8RqHN8lU+++aP8JyCkO5iOT9Ca+W0AYpv/5B340X/yJW/IH7W/4SagP91CtyeKF4mI5vf9N2hcdPrO5Vd5U/Gs+R1/hbENq9H6JHlH8az5HZ/DaLYOZn/x90EYR5IXVQDNb7sL19yyrLyE32/6Lfx4D3dAf75E+zWd8mBZ/EhVbPZXWJP85HH+FSARm0H57P4hemCGJ/wKyiR25TF/xu3Yf9xER1iVfoHafJ09+slsGQT72RJmw+Ms3M/+kanRV6hjuOI/nr+hkyWM6/f0xn8Vb6AV8VdFGR8iXuIlX7Gg9dv0Dv33bzAeLuagx+ZPZk2wKSI6BOvQF34Q7r9BNXnTxaJ+/vxK/5OYJvNjdPgQbI5pGchghWADBAlLPCySn5lJwZ8u0scLeM5qQQf9/LVDRENGGAmZHZPwheXTBiyAo3sPgqZNdoyL9A9f2A79Y5dfpaaNZN2qLVJtVr9o8DyLByDaMfreQGkpExaqwmT5IzgJ4uoEXRzBvLTZRj8ym+M1ssvrUWr4X6WyfI2xC+NlHR3AvbzNYf+A5ZpKBtbyZEfbT98bhA97ZlO8jQOwIR+jE7eKBeiMCmgbMHPjLoAOA0eTvYAZ5um7ClPrc/A92p5YF3wtnI/Lam1g7kj7vqLqyLyQ/X2VL7ow8miN3x+DXUI96fd76lYnIGJQ+VVQLJW3MYg2OHLXh01Dkt9cRQkbv3fB8bhlvjd0xe4AxvAj9dVjNrF8CJcxmIDs33/fh8y5BxFSLLjhMahPwi5uUhGC/LbbgK6l6KemjZB26FufxQY8t8DQSZzOHL/uH5kB9Tm9P293BpFLBjiDt9DMaC9YINzouOhrreRF0tfesnfUfnAJ5jntEAsqzu+kekZvIkxHwTaivQa/u769jaIt1XKO/BhQA3pPdbn0suwym7/m9VdfVOr7VW5ZzZPD0wdWFViR9nxCf/8bzHh06FfWowVfkKyf2TrGlvkHqMIDM+1T14muqzCZ73w2y4JMs/UKmWxFiv3k7vD0qx+DtwRP2ZgO9j6Y6lQZZvCcVVbD4JtTS/jqMUqC/efghx+v2QQBVUhOMCF9h4lw9h/+ep3MDtEBRjytxewYzfwZdUH+k5XSw2A8xv46SM2ERzBuPm023O74fb7a0jn49RzcyVenPYz0VzDjh6tX7Cev7un/MvT8IpP1pwMYFG+ieM29tSOPFsCiEgS7gHX8+pRa/q+RR+UXnc5YosutCKX9JT76GK1h7mQV+x3mFH+1Cg5H6jb/Euy47buwX2ELPL9gD8oO4/7TKb4Ez4kKEywNMDX+LxgAyacNf/dr7L6yUleYhURiWHaoA5yC7w4hvGL/9/zXtGVZw16jVw78+M2Jvn8N8yaNBARrWPmpxnE81IOKLG0rvfezp8X+fCqBzq4SRl+VKHUPYd1T6W/75xgejrICldLQK4uWV8ThJP6HEKMbWh5h2jWi36TbTpy2s6+PpVuOScuha2kc/RbumDUhTqnzGzDTHpcRU7HaIJtfgd1IyxK6f/6Wx2cqIktvC15seidtIbtia/rhdLgEC+iYjkyu1jTEKLgasND42xN9UBjrVL9hiQjTIV1ZBu3UJYIiQnBV5ssNMjcIBQvsm8uFaXtosQwwXizdpUGWq5VtmJtirN1Sex7MJ7izgVmQWujQF2U3qliuuBlTXLn0V9H6jplF4Bs6sNaBjtLIYnKEuTTKndjf54KZgTn1cnyqW57UiMw81tR5BvOKj/rbJ3DCQiqjkv1YshhpAHLL1SSzKanpAWt0GmZNjUkQabiHefiB+m61aoDvAb2xn70//tOnhoJJ6yuA/nYKaB/9owz8ymPv/j4jplJjPBMPLJiF0clESQsHACuTCjx7OIs2NLz6ASzc/Ro7dLTCAnEdremDL6BPrz164+oxpnE+cBiodpuWZQgF3D+GyfsE3vIu2j5dAeLThuq1+BPRBuMWzTHcplpW0izxkpQvUXrpZrez6/LjFG2mlxa/tNJLs1wSKV9a5YKd8psdKTi7dMq32fr0A3zMYH0vNtWS1pbIK0+kckHVhlMVSz7F0BngsFz5h/BI7XRQoQCmMGaDUFcjgdVyxSd38K3oZASKtmfWwX2U/iqbAelvaSmVGcDJ7WA2AcCwN1ZoYyzWtm0vzNUGL1zf8xaWZ5rO0lkT4gTFBHAffvO3TaOf2s+Xq/85hXyIN00Hdnk6QKRhOsj8EDTyXPCBxovA5U7KU0DNcSxmheapQPRGXaKaBwRU2yxA7N6zAK7OAm59FsBOOWotGde5vgjqa5a01y6NmjKyPChwaQST0lvM0ggtX5WniXIJVglZHtjlSYAohnO5NuVWuJIySKVuX6Uj9Cr2l8JifMVzDVjMok65Xswf/eRXUIpPP8CxVEwDxwgu0hAT+J6gfMcgofaBbeH0KYtXlJ5hE54lMCUk78KEeyC/zw06gyBs3hhXxq1xTci98Ra7xjvjC0GXBmg7YgCH3OAr89a8Jua9wwAeBZgAwBzg3ZArcmtfEysFuBmAMICLM4B975YBZgXgMAAqABYFYIJuLAAgTMtA1ltsme+sDGKXIIQ2hEIcp4A4HEJEiM1qkkNcDrFEiFOGeAxi4hubQkwZBBlVDGYYxxMwqIpBdQyuYEyLl4UFDKlizDqGCRhb5Ma5sqn8oCjvLca46ETERWwbN+6VRVvOIMg1BQgXsY1ziH2PQVkMV8A4BcZhGMIw2BIwbgWDLYYxHQHjVTEGw9jWO2TmisfFbHs3XlohXphD3iGSg7icHZSBXKg1Avl4IghXQI7HQa4I4pKGkZCB8D3GAHJEkFkCmde2y0G2CLIKkM1AJgOREoiL27EzEK04eYtRqXVOFWQxkJ29ieYuYS5wGF/IgDFMUSZDefAqnKO4yF2rQIE4zbcE2QKKcJl76AahFIUZimARhbRQXOqeU0JZOQpzFBFQIFJLjjK1UJYWypah7CrKKaNcOcoVUNBD3rXrchQRUV4V5ZkcZQook8meGOYNonMxcq49IkGhGgre5VRRWEAxRUWGwWGWCCNlmAMwm8NsEWbWYAhxmCPCmPgJEmGgr24OMy9tCrM5zC3qVoZZHObowVgPEIwozGXTBIKO8qowrwYzPA6zBZhl1GG2BIbqMMJhlgjjvYCh3wmd59JeqMGIHoz3AgGBmFSL7GvPy1HoC7E5yhJQDtVuL22AKaJ4H5hGgSL3xKiieBeYpEAZ9wRx7S5QroDy2HgyOQqLKK+KclyOQjlK5G5NkbsVw9qN3K1FLvI/08n/tLnbF5mgOS49+wckZVnf3UdZ77HshZRkzp6+zz01qhzZ09dg2P5s5m9hGpDytx8DGsZfxT7rqSuo9D+DffIYHuYs1w5KAoczzyAMl0F85FlQh9MS3tLIx1oqPta+4P9Z/D8lD9tCqd6G36iXwpjRv51CGseLAzqQKFNaZF/Qy5xglZOoNdb102+bKF7PSnf7Ma3ItOpU662/h3GnRbGarj0uxYqmplhzmvQ1thQZZDKe8zpMHmiE/aXTnFWactScsov5Zus/cJmuox9MCNCqgHa/gj2z3Z96JA+n+5QcXI0AIjkB155093yUm3t2ys1ppdzqffj+AaQcgMB2LA8EVPQGZE3JUtNSd582Nes1ELOfg80podFUmBJ5EsoVi99kFVggphfN/C2W8bONhO5ZyUPz/NTh4LRNzdJQShien6pE3pmoSldGVRbzTgtVKT4dga7kzKdeIiubUD4HzCjgU0/ML0pEgiQ5gWV+nnWehKX4zPMkLfFnM3ebpdRm1K1vYXvtbxbLtRUszI2JFp5NyIL4yPFJsEKBZxZ1EZylMnkjPFBzNZScEckapxcNc/cI3hAtSE7BvvPjJZtyBGu0QtHUDc1RaJv7OFieViw50fFUrE0BgpdtoA/zZsJ7v4drsJTiaEeJ1Kt0UGr1kKha/8//7r8C1X94dXdMHceM4E+FQ5WkmTHCIq3bjTGy6SKV9RdNNoNBN7uO6LyBJBSyBnlESmQOLl2RErWDStQKLl2h4nfC783i9wLxs0AlHqh8RUpsDi6uhLv8tY6MKxIKlxZDKnWRtQLX21STk1mSTHM1yw3ryCIzjqqVQ65zWGh8DgvbRMlhIdvoz2EZN/jKFikqZFVILJIhMgqqQJCC5nIows0QZpnGyhGWxRCmgLDKCJfce2+xZQsIm1Nh9o15hYxbh8bzqxCnCnFqEBZwQx5lujjEYxCRqPBKEPfawxTiiBBOYyHP4hgWlEYgWc8QQagKsiiIlFiRlMgyKEnFQTYDmSLhkTJZBQghwlA0TEgqXJZhZiji3SP0lpRrblVANORLUV7pVTzOj9CNk6EsisKOlbIUAqUloliJGJsiyq2iMGEoAzTEqdBaIoq/y3AFVMprIZKjKN9J+SEiojjHgilj5zJSz0QMRbvZqTBbAsrGDGWL9UqpLRHlchQWUWYJZV4jx5SgrAKF0C1C18jl1bdL1bdrMKoUFGaKMC59TAkuj5aJDYejoI/sHOVWUSitvy2ivCqKSp+iHAGVMlwCyjQkqFT6Xo6yQPqUeXNFFC5QCNNGYip+CvNEGCnBPEC5EhQXP2EEHegFdBOmHQA4xxBxVgVHrmGuk+BSgjHHmdfE4I1w8Ducd0FKdKU4xjFbDoOZnghzazCbMJhliDCvDvM4DAkwznUJMJdysgyW1a0guxi1iagaYUznOgYj77Cdw3AN5qUwS4SRGoySQAxnizizjkMpzhFxvCdcN8MZfMCbgHMZLuXF7DoO1heG80ScI+IMhjMdhrMNEeeWcci5Nm0Gg/VKgKWso8VJKnibZXAUiNjKUJZRQ5kcRUQUElC8SMuWwHAdxhsK66QAIzWYbUhgZh2GJTCrDkubYIkwuw6zJTDOeRkizGW5JinM5DC3BnMMDrNFmFeH4SpMoL1cVN2yWHGSG9kv07rI/4h7YRr878/Ifv1h9yPK6a46HVYmvIrnr5FrtFBeMLFrUF4ppyXuSOzOglEJbxkb8T2YfT5tg577FO2L9M9iOxQt/teXHytvM6zuJWylxO7YdiFddgz6HXQleYwOvakyGMVDmDJkms9zMo2MzXoHwzIOv1FuRE5oLZy+jBY+1749fwYuavJIoyps2u65Q2/g3iT7j8lLGeeOt3qj7AQzz70NrLwPrc5s/esyO/iZeB38UnidbJOZYleaSOZk0Bqdkz0Yh9BRUxVpeJRuc+FkxcqwHMtYOgtsrNyFifzlwrMdY7GExhuBs1nh1boYyJe7BFaVtU8PNqhvNSkbvw2kBSqTFq7di7WobBlpITFSM6CNqshX/0bWQnsLGrWOabSaphEhFYFRgNp2nWBnGIeQ7jqh9AGbk+++UZvH6UUhLEh5x1SmWpWAf779KjMYUCnQXv01SsPpxT/yoH3lPfQ6u2VWq5L+OL9RqVS5DsXvKnvCsmvVBpVaEyv1wKXGVOperY5Mdrguq1Krem5So1bl7BNz314CxWATNcUwhGGw2C4Zi2744Hs5qrtknBTgIUYOCNsiSBmAXAwIYggbbdJtMuYNubIAgU3CEHZln4yIMO+9MsIuEDZDMH7BsQqEU0XY93yvSI5I2QV0Y0IpDiAYAYGcAuFVES5FEGHLT8YtkBziMW7BJAIGFRhKyrAopsED3DnVkVELxo0FL3IBhPmLHAm1kIEItjnIkDALGEA2rZLLOAMa5awzCxzk5iBbQizUQJRXKEBOxlFwELF4YNsqFZfTCjbN6EY5ykEiyiuhcI6i5FOxV8SovsvlVICD6/tlRBSnFTyrvmEmQ5Fr4rASieHVd8wgUqBYRJhgs75lRkDxgDAhbn3PDDb4HiaKshjKwgINU7AKDs+Az1HiJpaMVMAllFlFuVooTweVkQotKKSFSkkFs4Syqigue4L4DiqnhEI5yiyh6LsQR1kiyqqiqH7VUHaB4pFMZLBQJsGeCHOqMM/lKFdEpTvxSIEy6W49gh0R5ZVRHov+V1Epl2AalF4x0j04dRSqoRyOEgWWMgkiypagSA1lSVBmDWXmKNaRbGMKF76JUw7JpbQxcqoou4ZCHGWJKC5702OsCqbBfMqqpDCUw7jwLZLCoGZOWibf/YGFLTMFDFssYE5hRIClBIIIs9JCkQhDdRjmMEOE8Q6wrAJGd0XCQog8EcZ7wOYUDcBAGykH4ua7YbCwZ6aMIw7HlRph1XHY5Tgs4uw6jlJDbr6PBQs7Z7BtZzgXcAbH8eYSYe9MGUdJOjcfVUTYPYNtt8B5mG7hzJSclLfPILoXeCX1zpsphCy0yv5QEWn99+GHf4LDDyXEg3DEr5x5EABgWrcwD5ZB2ra+pP9BYeA0n7Zr6lUyhuDpNlx9ozEPftrFOIF/Ktn0n1dxlCTL6Ee2caagASRB+zn0Y/gAnsnfihRXBsmivNwJmuUu0kX2i7gyHNPbcrovK+XT/p6fAuuB9+UffSS6XHTUDy5bCEtXCzVRUShT3KRWZHoOyCw9/pFtghlarCW2tXSsJPUhH9hB2Uz6wn4CGgcK92tQ+PWp/lSMsRlidI06x7X8aeenBjND2KkdbTuV5OwLTqkMeswt9VDZzHXMEezonBd4XPXI23o6RISnYlXk+wrOGVtviAXzmK0QCeY36un+/L52on8tCqw4h6zQxyJDmY1AjahxfbsPm+3vw+2WJk4zKjNj9uavPcobr2AIbJ/S7TMwTH82xp7dLOi82Vh47a+sReAunYXpLtHCD2xnsQ6MtYUw2FRrynrt6+ZQOegsPtE+3gy7o0abhYPKpEcW6SW6f1omsOL7PMLF4+GySLEIaz2hyOodK3aN9uhvdlLYonJEWHpducwDm075qZMHPI3iX9UYqVGJsmY38rd41evygyoOq8K5TmPVaxWrttxR1afeODLVuWJnCdgSQ32uEaFn36+y+YIbF/6WzZRgjyRUieYCQGjiX4IfATWWC7/IQqVzBWoUYrNzhK0L/kfQBfYusst/O0d/Uueo+HiO3Dcqnr9Ght3iGxGW+yf1jchF6b+JfCMw6EFrjlW/SEyHatv23+YWtfsJtRFZ8Y/S9JWaY2RXnYXM/pV4R3ReYZ9wYt+gCYNklCqIbhLBI5er6Z4RNEF7m13SluKH9XhTsx3dHn8LHuHshlurM26ujtLhllXUoGz6NjioRNdBpcjC6qerfM3kN3Q8VNtod1CdISdp/NEd0LqTcsO+sxOsLzexT70LhPMN/fRCfSyBJJ2IdvcGvCb2LRGW2qiXnzfWcdr9fWZ+dAFzcYUmsFMZznZ8gfXHdMVlh4S352Ol54F3c5qpPVvzmpmONrjN6dHIuffsrVcrZDnGwrGCzcJES7Lwl667IGtCDGvl2IZLCu+5Nl2WXeja44a0LeOs54TnFk5ratcgz7tIJndcldtdJHu15Wfh3j43MjScbifPuebXdq4aJY80v7Yq+DQ/ya48tyq/98reevE+u/I+S/4+t/J7T+VwK8qvlqdsT7X8av2q7c3l19H7vo9Pm832xfjfyDUaEqYK/xmjEq+YZcS2uM34AjvpX04uYvxvt/lP6jYXX8OVu83Fc5jD2s7vs5hGNlKKDv/v/JTimK5zXjGpC5MNRD3fiQi+Ex0fpxkIAv6vI5UoKVSDwhTKpqOmVub7/feAfRisvSQNT9wy+hag6XL3L6Cbby0pp9Wx7S82bX/W1vVnTdFytvvyrZbb7s3SQ9v+tN6s/gaUsmdKzsavKgo/k1tsVgtH7hkdWuNl+7OZj6rn0WqfI9dGMb8NYzpt7I8+880ylrko62dnLlnqFreQycV5qswpRksXo7VjLtzNKliYFsELd2msF4FjmZbvO/B2q3CKs6m27Avn9nHpWzm4ySf2KtyypecS9/xcTrcdT+MR0pbyizldCOn+vrGn4RqXT+pKN9Dkjl/5hLP0svI055fLB6Cll5U9PpXdSFa5XKv8W6v8W6v824o3q2SnK+hKC01ZSVhRDyITB6lK54/tJBOaXqZwki1XoKBh9ICdBv975EtntA38vcBC2/Rc2pV0hemQnWv9Ozv3z+5Jnz07l7vS58rOrabkKlxr4fSO0VN1xbGp6Rwag3N0FYVq+m69c3Qbim32U+lHycpcbH7UfbUW1Bh7mlGLbcZPMhkobTrvZkVXTFG11+pok7AlDlbmtWItElbLbfX+jG6rwDLqfY8Z4dp5/DWfzkHn82ZN/TNX/v0p6A60bzlCQPMdJz+Xw2g5lqMz/9vjUI6UBIZF+6lpKHXzhnFfZ5glLDBveE2wTQxrswgCZ7MwvRVauGRpLLBPVi4KfOK6duENi/N42SMu2br6XnEl45plIp8/41r7kI6Sr4ssJQ3cydk1h2RfV4/jcCxb9zgOt+wfLipObvEcV56TyjUS8KUHZoUkJpXrQhlLL3Iq+Op1xXVdSE/6bii/2pDq+5UNR5XnYns48F81V9tiX51Z+jH8gaox1YQp3N8d6BDkEj9ESZiN8VQs8+Tg06pQl5mxflRSIi4/saQOxj+/CgODez3Sg+3zI+ikj0sTVd1O2ETbbfQjiN9AOcGmNLGUXkPrIj0Tp/ick+SprHDJpF+vg+xltArlwZ6XXbpNV8XksPWfbqQP5TVKTRn2sFSTW/8APu5tHO748ZGfeYecEnou0pH5p5L6F6jLmM7QwkesqR8OrgL8Mw7puVeCZNk3rqsC5b9pqbVKgPTH7HsLYBxsWDTiiVmn4Z6tC3Re/OgfaKE7/3Drx/DqY2pDZGfPgcMTHgJYl6kJBKi78J+BUMv7cE/FEvvr8JTw1Kcf4Zo6Bximh0d6vBcN47KFjQ9e6iT/Nw3CMsPABMv3FZ79B1vbZshAxn/C65KADXIHeYhgy4GlBlbKH3R9u3+EleGRhZsWxiuDpLN7fhzjLtzCaI+feJQKbKof3AWrq12Uzg+flIi0idln57jJQDNKdtF3dh7fx2AHbwnq4184iYgevpQe6AlV8/cjVox/3SnOKob6VWzpJwH9iJQf7pmfC64oLYcF7djdtwHlYvlZqu/AEqM6n02+b57Yh0VqNRSmGEFRRStJtOi5lUgXjx0YqbwJdELjZkwc+Wu1LB5Lxx3J6nLDxhgsMUd43/6Y7luaoD/KvimNObGtrx/zFuG0p7BeTxVHfUnWDeHhVxb/UjytdvDtFv6fVnqiLoyFj3NETAzZncsdNezZoY/lfmZhE2rHs7fS7s4dnc9wMYIKXElVQDEwlBLTHg8V0ZXr0lOYd49BQA/bK4vu1k/SALO2iOgxT886TNJwZ8P4IBrjQz4wFCNCPhTEue4sExp4wbvJJrRKe//l9Zge5tVPOr/JpDNcGaQtb6lH0wR9puX3vMtutf3FOY8D+kNoo9ByzeaebVD+ln0Jq95YWClZZl2/4SdRvAaDoV76uTWuFkGceKYYxS4UGlhd6YRH2kuc2cVYxzIDMH8kMf+QQs8Uxl8fRVN3YevwEooTeomeK1eqitYy9yLUedp1rpO9VhFPl3n1RWgBPRS0oxaUjifu4c5ezN+CEJLj2fzaD4wOne144dqKQI8a7L/QqrybF28E05M3X6i/gtLJ3Ooymcvdefk8Psws6tZdb4rotnxG+yXgsaaiNzPC5/eqQ+/v6NTHjgG7j96Lz9h5Lvoq7+r2faleYrJQc2VkFul5QiaDxwVfLwcZovXZQG6IDvCAGmz+53d9XpLdWRVSfqJ+3y7q4hTVFvKyRG4DP94mnZRT3XRJY/PE4cncItnk1qCaY0u9SdLK0VmvxEs2340+dpvwXYgzuf/yIZ/mFtZj1XiEacAbEqdSaMILt+K7K8OwUdd7OTqDcGX69vfY34ennUThTF1fZwrTUCuCeaYAid2JI5NGSBZNIZKFKkZyrqElEmU+JXI1TQ75iCO95l+lJXZGO3B0irJkY7cIYMopR9fm0F7nu1sbGgKY3BHQFoNODGdkJuBcJgD9kk9vG4BMThp07KKzkjWxJF2w0h/w5vxjvfpdMsQ5SzMrzZogfgmSIJ7GTyjVSpZJaGZ7FafzGuQxIk1Xtl6z87iyyiHV0H2jU+SNNoFcrK2s7JiOGH7WPirNOqoUvk4GJtzxvwfSLCwztTAdPQsz2xGtNJ9MeehWoWLPYF5+4aozJOlKT9W00qwyn/9cqqZez5Cii8ZbWBu6p9c4lnnN9fp/WgUsXXV6fkBSnxeh8SM4VGgAD9nFq0ib2Ng7nRI8zhbP0PMtde3WSXzLZkt10kVeV0xKt+csYlK5f9PlCnZxTrvMJWO5phrG/2TkgKyLzBfjoJsqTR0YrtBx/b7Q3Y21+bxzKsEQp898MW64OZ0b3ml0PgtrV1KLt2HyKFGA9FUiH2lU1lsFE5nJ9pkJQOG836lCgy2U7xt/D/91CLbU7DJx3DE6uIaoDTtZVMPKjy+b0qhp1bS7YyTNiq6rmiPRNO2IUr2dAyNK+ny/VnRpQD8oDd3RAkzPJTy5xrBTYKXhZFGHxCKqAeP9abtl+sO/8l66tirXduXaqVy7lWuvfE2/sl66RpVrttlCrKx88I5CDlb2Nbpd4jREnV9iSeM0RKHX57CA9Zn3kaN/qm7Kjhyp9lF2v8resv7xOmU/SjsoCz/Ku6h4+rzByT/uyM2v1VFMXeFOFrOR2HLdAmMqpRY7qqrY4jOZcnuau72LQ0QaIp4K7Ubn1W5NLwNNrhXqGOIAWUwS0/zjjA3ZHhp1nPJcIXhdx1YVkGfHttN/TrtDrkfyZ10GzfZta8SyOXp7noilJBda1LzMGBD3KLE5OXvQIauh4/atpo06PQPpsi0O7U6eZc/7eHmqVI6RTt1o9/l1XSplrK85xNRzOOi6x9PsGOggNcnIaKl5s8MsqfVHP+ZfGR8uXWHaLdf9Uyg7l8Np74axbRRVuDfdcKAMB/XUS+25QSm5nFhslVQbrSPp+stjNI7GytYXSzH1TJMdpDGkraH8YH8pTLqzQhFKbF1SCnKi05JivYiAtTV5KoWuDWk9S2pe6+RKWgOs2Tf57OftSTv7WsJzmaH9QsCWSniTkJMyFWilJpsYEm5AD2FI/nA9Zj57j7WlyPXiurz+HWlO2JFa7Mvo0WivVy4qmWYiHMTmSCIwigCwJWNKzrdxytM8BjL7do/SNbcb6BLtQdtHC2VKpzppIJ1mZZv7UfWkAbmKck++UUfVZws0Fq+mOZ5Ns9ttU4VSS+k/ZQhNt32DUteQSpbaht4o52P0lF1Jw0xliHY8SWqGuiXy7JlzpyFHPflZ0hm1WYBnF10RVH9hPM5CReRMetJvt4Ejiyg3BpRtdfS+C6ehE1DrfVwOsxjUi0AHlqOP0HvLWR2q70xN/OW0f9gG/WOZvUU/ZHv9QnUYybN0D7E0+keZD9rgSfWO1GvkWpqVQrpkwPU4zq/L+W39Yv0SWkjSV6bTmQRTRokn6bme6dT1HmY5LH1DlaOksuvZiJ1sw25yLcsz/yCejvT6UYf9fQaF2IqPNanDgPW+Gk2AXekCe+g+mfahryORsY4bHY3LE1RPw19OIzcyh9XM/OW2w/cl88HIOW5Ylq2v65M3NlGtWPWOHY0wqBDHaSa50BqsVLeR0kEGalyn5b8466Lb/KYyMsfshqrMm04LTV8lOyY0fSRNGNT8toejzla2G3aV2wrf4Wwh4lbb+3J72oV7qfHtalmPQ7RH7fxNSbd34NVGcsPPyUsP6pDpEkb09lHxYca+93imajQFuJp4IzUBKGkXb1a9Vfen/Tr2a806304cexp59wlwTyV7+6XK3lLJPq/Z6Elyfful32G7jVsMh/LndbGNu7OtKy9er890uY7dmdFhrgauUnOKyL9JWiP/Ri9HQGZwmxpq0CHIOS7/LoyY+/i02Wwl56ClB51rHG1ChtDy/ef2oUkaV7G/nPen3JSRbd0WdaIrVadYddyNdBVHSbKMfvAPUD4G/pZ+W5PYqbcBDfDTr2HTKOgx3NCvcYJW7CJ6l33JU7yCRoDCxLP3gLpcrU6xv3qCC5Dznn2U4tPmVkBTn1jrQ2xO06Y+p3FT3zTzXDdqt9eBbN0O0NJV1NoRWrKYBe6ktu0mrIpKVOlwCV9V4tLDVIs/RPuH5EcUr5OyHjsk1WOzqrT/55Y7Sx12lsqVEDUqIVIpYZ8kgtEY7yEZA9NrRX3wn094LZx/j5m8P9F/zkwJxR6UeihRGuJsyyXpFhzprjWjsNA9NoGPTTKrF7kxzg8YL7diyELV1ju1BUqWi9HjxNcxwtNqq3XKmoyp5D2OHxpxC2q3E51GIGiVe4Cm4L/Lo+KefrJ+/zCDGh3nOnHQdk5KHZQZ5RDENlJfkqIs0ULL01BDJdna/YDksVIWdAJF3ZnLfp2qIsd7HLwq55+bxkwnc2ukpAatDwSPRgWOEmFQEPvlaosSr2qF+KwxDP+CkiScEQ8T1c+McBRz3GRi6HUuG+6XtOSMeIxtV5F2+jLIMJEOXBzNfqfeOSpzp88nYNrODm1JuHC6fT5hBC2eiHp1VMb3RJ+VGS+T4jqGnppdxseQqZ1yi5Pm91ad7Ng3VWfLD2RyFB5dPxptnLSbIR6dnm597qJbz0zrO4p4RvcemiQFRnZozgQDvN5+XftznNwKl1fDHXtl1CePJR7PaDQ/b526cfoxswFscUPv12t2t49+TNH5DR2g3mhR+2pWtzmrezfW4lIyqt9RdGrTxKHaXDBpEoDdNraG5LO96MSahs4ZUf56CYuk3lEqO6fWyKq1UwNob+jW/RKmlelMQ3KQK6fBLJW69RkYkyhcrznnA+O0Zzu+S0hXaS08NJfoPDqsmUg0yvo84Ftr5sQLaacvnUikMTJR0yuzpUsW3KicMWnpnCk4YyH5o15wv12WIyxjoxx8MIkgm04/qBfYL0I/NKeh9dh7W//wbA0tniwxRbkIa34sEKVqoMwakC/ASKE9nWJPWt2THnQkCNSR5XQ06JVyTh4lg0N3BPUbNsp0n+HHmg5vfTGs6/WTe/bDJmHlYTTDt/VPlO6Sff+3TYrdTqF5bs5f+fWS50qW6JbMMvSUhzb/DKSgOFBx9CNElJ91Pn9PqD7mPLL/3zF5uVM0/zb8FrSsqq4s7ZNcKFKWv8qzlJFmmmh+Uqo6EYXw1XkUMqP8FRtP8ysp+pVUPRz5PPVRiYuzJt3URTEwP6PhoIkee8g7p2aMzwFVpav3/WbVQQijEeKN2S+tmUljJMFMpJeqfBFdyalzWho5kYFZLgPdkjZZ9z2EVZHlodUxqvVNlEZ1hhefSTfnqFY5ZOh+REgeulXEbLVdtD4pKcNmG12Fq803lpKI6/bph/HWNY04q9vjEKeh/SE5qqnLKNcU+uiHcU2b/eaeJ1XrTMYxMpDMOsZjWcfHpwOjU6AVl8ejv/oW0GEs1QNujXb7wVdabHL8HKzSxt1Lfl6f1lyF6TZZFpamUo2eFN+c/+cq3L+z5yBpWUNWv9RKt7u7rZP8pxRnz8+4dU0K6p3a1yCjUT6IpyOjetBMmlYyYt7URElS7tCjtjsKrh6znVhwmgIYPZm+kVOTVcTjFfH6Jiz1y1KqEvWqVbvT6fsNqzbJVm2stWrfPUarb8NjWly2nmzqyB9JnIfs2VTzocQlbVDRM2vG8OSl1jQQd2L56iQI/utJ1XlOqdrjSXV4DpR2zppMjPZzitFSifG8SUnWCDLotKn2vC3u+ekahDSzXUyF+BRpbu35Ct1OccclHScN6V4NVTx3ulfrHkpFp5AhmV1dtG5YQhJWCXzcjK6WauAztxqpWt09q3BwJs1oSVHtYe3s/B6cW706B1ExQxhWJH4kG0eFwZq9UT+5SmrsogZjFyl0YqTkqvK4zp/Ngv3K3x3Y7Xq+1VkT2LLeQl7WW6Zmb7k9O4uPCVlimaSLug+goSFmvfHVtWPPPQh5V+rshZSOGvl4kY4UrZMwh2SH4voIkWfu1Umvl5W5N176okbmXsPReVNKonlrdUNCXv9QVKc0Qb1zULitq5ea1/Wkr9FPN2iTb+tXGQdt3xl+vFfzl3EaUvHOlBTZ4Lj1j7y3JjbWjzOVndejoabKb16fT1jdPgDeN3zQ5yMRgzJShn0nacjpQv0Jx2a2QnmeyQf/WzBWTk8vyahjmQO+zaLMp9BKgOh4AtYnPwmTkbJONFKd9HKd5EH3Tgl03bPQmgOUk6WtDHTyBiYCjREF6CLu0aTYlNFSrowssaWM6JDformx2UsVVslxoQaOq67nE3+0spvGqGaZfkEzparsafv87Zdov2bdxl4/+6sfbv1B2aLtA/Il5pG1by5x9Df+d0wZbd3ujwzNrYaZ8mDpwlk8lOWOeiojYNSPbXZMa1R9SKK8i1/rexIKHTY1lFj9PQmdeqhGQN2ae5ZMrvqOc80Z6szpb97kh/ZqJq2MnJvWkravlMRzusHe2TLQvIm3bTY17wx5Yl6nIFiPpJuG5o2eBdaiNV7faOgIbZ380KRO2XDPZFu7nT8Mc7lbnpJH9mWYlpRy3IEV0koaXyAjNYQN/Uzz0o++9ss2F98xbrZUczJildzgtZBUokFz36+0vRS9cTO6DDpmaMr9t3ql1Ls4eywHU6eF5gNSc/9vvpvIaEoHZyovUWf3Rfak260np0mHfGEycdpG/DmSGbWL7ysUdQxftzu0U+/aU8KsMRs9OPdQUo1Rs+d+CXiYoUUoplIok57EpT4obmq5fAoVp4loZhR2kdTwfDbSbZrolrvUkMbX1AvaAYveyRR4ylbrbU1ASjnIebLOh1B1M/baT0TUrcAkrerSW92P66rzKvLaDsrh1M0Z7ZyMOknOkl5w26cn0Mx103Pq9dQ9L6VHClOPj8mOHdjq9vHXvraW2RZf6haUmCbJpVvmUB/mstvJXi3JQdZ5k4Passvk9DyRbYpW26X1xnT5mmSbQSyToq0KcY/JmffMnMHugNSZMbKQ9MwE5fdrRkumUXu0YyQI6R1DMGWykDrI0f8Yj3GPSSIyzlAZr5Jw+ZPKSpXlMGo2j+wjWwppYa9XnoC2RTqS2CTlaZ/WoyOxbkdZKWTZV5QKlZhYoK2nID1TDpRlDhFjfRYa03jXSBHKBFuvSKtDPnauRj26VDkkzN9VP3ukmiX6ZROlsuiWTHHWs8Cy3hor32NQJ6k327TuRVX1GxrSbw3HGZ13D0Vj19VrOYwn6JJ1nNbhOdM9MjGMnO/RZmmmxXb5ptmIq1b/T6lps6xpUdMFPBobqHui/PAGdsq+6MBh92766N+n65LhMeZ5gLRBkg3VPzU3TxsNu6fzZ7Lt09lD7WlxyKrqNnXlKGdoKLuStv0BeuPWj+F/QVt5kszWf2L/BJGuHqMk2F+F32nrhddwTJpy8u5E+5GlDAvwXC7VB3nNZL8QG/FTyMahx7HSA1hpV5vQ+r2/3AafARbtbpiDkdxG0Xb++hifAnicHOAWlPErw62z+9/DFV3Yab3ZaPwl2oGSMsFDWQnoNPTKw6+wQL+ef4YywiTx96tgFrAle+f/dk+TgEBDLCPf1Q9TuJHr8C2TS0VY6TP62ztaxH1IBwBykIcItk3DcxzeD++honPL8twAG/YC+dhZmKs1Xviu4S6Ia9iEYNM18Ia+9DFYfUtOO/jFQ3C5/nC4fBPh7fc3yd++//XdKvxfd5v/Orx7/78BuQWFoSP1fTakUvOG1wUqRfn6/w/ZxPhycJkBAA=="

    private val screenshotGamePath = "../../../extraImages/Screenshots/ScreenshotGenerationGame"

    @Before
    fun loadRulesets() {
        RulesetCache.loadRulesets(noMods = true)
        val game = UncivGame() // Saves might need this for setTransients
        UncivGame.Current = game
        game.settings = GameSettings()
    }

    @Test
    fun loadVanillaGameFromStringTest() {
        UncivFiles.gameInfoFromString(vanillaGameWithCityStates)
    }

    @Test
    fun loadReligionGameFromStringTest() {
        UncivFiles.gameInfoFromString(gnkWithReligion)
    }

    @Test
    fun loadScreenshotGameTest() {
        val files = UncivFiles(Gdx.files)
        // Switch to java.io since Gdx doesn't like '..'ing out of their virtual roots
        val file = files.getSave(screenshotGamePath).file().canonicalFile
        val data = file.readText(Charsets.UTF_8)
        UncivFiles.gameInfoFromString(data)
    }

    // To use these, comment out the `@Ignore`, run, take the new string from the console and paste it into the corresponding val above
    @Test
    @Ignore("Use only to update the hardcoded value to remove reliance on backward compatibility")
    @RedirectOutput(RedirectPolicy.Show)
    fun updateVanillaGameString() {
        val oldGame = UncivFiles.gameInfoFromString(vanillaGameWithCityStates)
        val newGame = oldGame.clone()
        val data = UncivFiles.gameInfoToString(newGame, forceZip = true, updateChecksum = true)
        println(data)
    }

    @Test
    @Ignore("Use only to update the hardcoded value to remove reliance on backward compatibility")
    @RedirectOutput(RedirectPolicy.Show)
    fun updateReligionGameString() {
        val oldGame = UncivFiles.gameInfoFromString(gnkWithReligion)
        val newGame = oldGame.clone()
        val data = UncivFiles.gameInfoToString(newGame, forceZip = true, updateChecksum = true)
        println(data)
    }

    @Test
    @Ignore("Use only to update the screenshot-save to remove reliance on backward compatibility")
    fun updateScreenshotGame() {
        val files = UncivFiles(Gdx.files)
        val file = files.getSave(screenshotGamePath).file().canonicalFile
        val oldData = file.readText(Charsets.UTF_8)
        val oldGame = UncivFiles.gameInfoFromString(oldData)
        // The LastSeenImprovement backaward compat code couldn't prevent Gdx from actually storing the values as the proxy class
        // `private class HashMapVector2 : LastSeenImprovement()` - and Gdx would write out that class on re-serialization.
        val newGame = oldGame.clone()
        val newData = UncivFiles.gameInfoToString(newGame, forceZip = true, updateChecksum = true)
        file.writeText(newData, Charsets.UTF_8)
    }
}
