#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 1241
#define LARGE_STATE_COUNT 12
#define SYMBOL_COUNT 187
#define ALIAS_COUNT 6
#define TOKEN_COUNT 102
#define EXTERNAL_TOKEN_COUNT 6
#define FIELD_COUNT 28
#define MAX_ALIAS_SEQUENCE_LENGTH 11
#define PRODUCTION_ID_COUNT 79

enum ts_symbol_identifiers {
  sym_identifier = 1,
  aux_sym_template_content_token1 = 2,
  anon_sym_LBRACE_PERCENT_PERCENT = 3,
  anon_sym_LBRACE_LBRACE_LBRACE = 4,
  anon_sym_liquid = 5,
  aux_sym__liquid_node_token1 = 6,
  anon_sym_LBRACE_PERCENT = 7,
  anon_sym_LBRACE_PERCENT_DASH = 8,
  anon_sym_PERCENT_RBRACE = 9,
  anon_sym_DASH_PERCENT_RBRACE = 10,
  anon_sym_LBRACE_LBRACE = 11,
  anon_sym_LBRACE_LBRACE_DASH = 12,
  anon_sym_RBRACE_RBRACE = 13,
  anon_sym_DASH_RBRACE_RBRACE = 14,
  anon_sym_SQUOTE = 15,
  aux_sym_string_token1 = 16,
  anon_sym_DQUOTE = 17,
  aux_sym_string_token2 = 18,
  sym_number = 19,
  anon_sym_true = 20,
  anon_sym_false = 21,
  anon_sym_PLUS = 22,
  anon_sym_DASH = 23,
  anon_sym_STAR = 24,
  anon_sym_SLASH = 25,
  anon_sym_PERCENT = 26,
  anon_sym_CARET = 27,
  anon_sym_EQ_EQ = 28,
  anon_sym_LT = 29,
  anon_sym_LT_EQ = 30,
  anon_sym_BANG_EQ = 31,
  anon_sym_GT_EQ = 32,
  anon_sym_GT = 33,
  anon_sym_and = 34,
  anon_sym_or = 35,
  anon_sym_contains = 36,
  sym_break_statement = 37,
  sym_continue_statement = 38,
  anon_sym_echo = 39,
  anon_sym_section = 40,
  anon_sym_sections = 41,
  anon_sym_increment = 42,
  anon_sym_decrement = 43,
  anon_sym_layout = 44,
  anon_sym_none = 45,
  anon_sym_assign = 46,
  anon_sym_EQ = 47,
  anon_sym_cycle = 48,
  anon_sym_COLON = 49,
  anon_sym_COMMA = 50,
  anon_sym_include = 51,
  anon_sym_include_relative = 52,
  aux_sym_include_statement_token1 = 53,
  anon_sym_EQ2 = 54,
  anon_sym_render = 55,
  anon_sym_for = 56,
  anon_sym_with = 57,
  anon_sym_as = 58,
  anon_sym_PIPE = 59,
  anon_sym_DOT = 60,
  anon_sym_LBRACK = 61,
  anon_sym_RBRACK = 62,
  anon_sym_LPAREN = 63,
  anon_sym_DOT_DOT = 64,
  anon_sym_RPAREN = 65,
  anon_sym_if = 66,
  anon_sym_endif = 67,
  anon_sym_elsif = 68,
  anon_sym_else = 69,
  anon_sym_in = 70,
  anon_sym_endfor = 71,
  anon_sym_case = 72,
  anon_sym_endcase = 73,
  anon_sym_when = 74,
  anon_sym_unless = 75,
  anon_sym_endunless = 76,
  anon_sym_capture = 77,
  anon_sym_endcapture = 78,
  anon_sym_form = 79,
  anon_sym_endform = 80,
  anon_sym_tablerow = 81,
  anon_sym_endtablerow = 82,
  anon_sym_paginate = 83,
  anon_sym_by = 84,
  anon_sym_endpaginate = 85,
  anon_sym_schema = 86,
  anon_sym_endschema = 87,
  anon_sym_style = 88,
  anon_sym_endstyle = 89,
  anon_sym_javascript = 90,
  anon_sym_endjavascript = 91,
  anon_sym_raw = 92,
  anon_sym_endraw = 93,
  anon_sym_comment = 94,
  anon_sym_endcomment = 95,
  sym__inline_comment_content = 96,
  sym__paired_comment_content = 97,
  sym__paired_comment_content_liq = 98,
  sym_raw_content = 99,
  sym_front_matter = 100,
  sym_error_sentinel = 101,
  sym_program = 102,
  sym__node = 103,
  sym_template_content = 104,
  sym__statement = 105,
  sym_liquid_tag = 106,
  sym__liquid_node = 107,
  sym__tagged_unpaired_statement = 108,
  sym__output_statement = 109,
  sym__untagged_unpaired_statement = 110,
  sym__tagged_paired_statment = 111,
  sym__untagged_paired_statement = 112,
  sym__expression = 113,
  sym__literal = 114,
  sym_string = 115,
  sym_boolean = 116,
  sym_predicate = 117,
  sym_echo_statement = 118,
  sym_section_statement = 119,
  sym_sections_statement = 120,
  sym_increment_statement = 121,
  sym_decrement_statement = 122,
  sym_layout_statement = 123,
  sym_custom_unpaired_statement = 124,
  sym_assignment_statement = 125,
  sym_cycle_statement = 126,
  sym_include_statement = 127,
  sym__include_param = 128,
  sym_render_statement = 129,
  sym__render_param = 130,
  sym_filter = 131,
  sym_access = 132,
  sym_argument_list = 133,
  sym_argument = 134,
  sym_range = 135,
  sym_if_statement = 136,
  sym_elsif_clause = 137,
  sym_else_clause = 138,
  sym_for_loop_statement = 139,
  sym_case_statement = 140,
  sym_when_clause = 141,
  sym_unless_statement = 142,
  sym_capture_statement = 143,
  sym_form_statement = 144,
  sym_tablerow_statement = 145,
  sym_paginate_statement = 146,
  sym__if_liq = 147,
  sym__elsif_liq = 148,
  sym__else_liq = 149,
  sym__for_loop_liq = 150,
  sym__case_liq = 151,
  sym__when_liq = 152,
  sym__unless_liq = 153,
  sym__capture_liq = 154,
  sym__form_liq = 155,
  sym__tablerow_liq = 156,
  sym__paginate_liq = 157,
  sym__else_aliased = 158,
  sym__elsif_aliased = 159,
  sym__when_aliased = 160,
  sym__iterator = 161,
  sym__page_iterator = 162,
  sym_schema_statement = 163,
  sym_style_statement = 164,
  sym_javascript_statement = 165,
  sym_raw_statement = 166,
  sym_comment = 167,
  sym_comment_liq = 168,
  sym__inline_comment = 169,
  sym__paired_comment = 170,
  sym__paired_comment_liq = 171,
  aux_sym_program_repeat1 = 172,
  aux_sym_template_content_repeat1 = 173,
  aux_sym_liquid_tag_repeat1 = 174,
  aux_sym_custom_unpaired_statement_repeat1 = 175,
  aux_sym_cycle_statement_repeat1 = 176,
  aux_sym_include_statement_repeat1 = 177,
  aux_sym_argument_list_repeat1 = 178,
  aux_sym_if_statement_repeat1 = 179,
  aux_sym_case_statement_repeat1 = 180,
  aux_sym__if_liq_repeat1 = 181,
  aux_sym__if_liq_repeat2 = 182,
  aux_sym__case_liq_repeat1 = 183,
  aux_sym_style_statement_repeat1 = 184,
  aux_sym_javascript_statement_repeat1 = 185,
  aux_sym__inline_comment_repeat1 = 186,
  anon_alias_sym_ = 187,
  alias_sym_block = 188,
  anon_alias_sym_custom_keyword = 189,
  alias_sym_js_content = 190,
  alias_sym_json_content = 191,
  alias_sym_style_content = 192,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [aux_sym_template_content_token1] = "template_content_token1",
  [anon_sym_LBRACE_PERCENT_PERCENT] = "{%%",
  [anon_sym_LBRACE_LBRACE_LBRACE] = "{{{",
  [anon_sym_liquid] = "liquid",
  [aux_sym__liquid_node_token1] = "_liquid_node_token1",
  [anon_sym_LBRACE_PERCENT] = "{%",
  [anon_sym_LBRACE_PERCENT_DASH] = "{%-",
  [anon_sym_PERCENT_RBRACE] = "%}",
  [anon_sym_DASH_PERCENT_RBRACE] = "-%}",
  [anon_sym_LBRACE_LBRACE] = "{{",
  [anon_sym_LBRACE_LBRACE_DASH] = "{{-",
  [anon_sym_RBRACE_RBRACE] = "}}",
  [anon_sym_DASH_RBRACE_RBRACE] = "-}}",
  [anon_sym_SQUOTE] = "'",
  [aux_sym_string_token1] = "string_token1",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym_string_token2] = "string_token2",
  [sym_number] = "number",
  [anon_sym_true] = "true",
  [anon_sym_false] = "false",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_STAR] = "*",
  [anon_sym_SLASH] = "/",
  [anon_sym_PERCENT] = "%",
  [anon_sym_CARET] = "^",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_LT] = "<",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_GT] = ">",
  [anon_sym_and] = "and",
  [anon_sym_or] = "or",
  [anon_sym_contains] = "contains",
  [sym_break_statement] = "break_statement",
  [sym_continue_statement] = "continue_statement",
  [anon_sym_echo] = "echo",
  [anon_sym_section] = "section",
  [anon_sym_sections] = "sections",
  [anon_sym_increment] = "increment",
  [anon_sym_decrement] = "decrement",
  [anon_sym_layout] = "layout",
  [anon_sym_none] = "none",
  [anon_sym_assign] = "assign",
  [anon_sym_EQ] = "=",
  [anon_sym_cycle] = "cycle",
  [anon_sym_COLON] = ":",
  [anon_sym_COMMA] = ",",
  [anon_sym_include] = "include",
  [anon_sym_include_relative] = "include_relative",
  [aux_sym_include_statement_token1] = "string",
  [anon_sym_EQ2] = "=",
  [anon_sym_render] = "render",
  [anon_sym_for] = "for",
  [anon_sym_with] = "with",
  [anon_sym_as] = "as",
  [anon_sym_PIPE] = "|",
  [anon_sym_DOT] = ".",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_LPAREN] = "(",
  [anon_sym_DOT_DOT] = "..",
  [anon_sym_RPAREN] = ")",
  [anon_sym_if] = "if",
  [anon_sym_endif] = "endif",
  [anon_sym_elsif] = "elsif",
  [anon_sym_else] = "else",
  [anon_sym_in] = "in",
  [anon_sym_endfor] = "endfor",
  [anon_sym_case] = "case",
  [anon_sym_endcase] = "endcase",
  [anon_sym_when] = "when",
  [anon_sym_unless] = "unless",
  [anon_sym_endunless] = "endunless",
  [anon_sym_capture] = "capture",
  [anon_sym_endcapture] = "endcapture",
  [anon_sym_form] = "form",
  [anon_sym_endform] = "endform",
  [anon_sym_tablerow] = "tablerow",
  [anon_sym_endtablerow] = "endtablerow",
  [anon_sym_paginate] = "paginate",
  [anon_sym_by] = "by",
  [anon_sym_endpaginate] = "endpaginate",
  [anon_sym_schema] = "schema",
  [anon_sym_endschema] = "endschema",
  [anon_sym_style] = "style",
  [anon_sym_endstyle] = "endstyle",
  [anon_sym_javascript] = "javascript",
  [anon_sym_endjavascript] = "endjavascript",
  [anon_sym_raw] = "raw",
  [anon_sym_endraw] = "endraw",
  [anon_sym_comment] = "comment",
  [anon_sym_endcomment] = "endcomment",
  [sym__inline_comment_content] = "_inline_comment_content",
  [sym__paired_comment_content] = "_paired_comment_content",
  [sym__paired_comment_content_liq] = "_paired_comment_content_liq",
  [sym_raw_content] = "raw_content",
  [sym_front_matter] = "front_matter",
  [sym_error_sentinel] = "error_sentinel",
  [sym_program] = "program",
  [sym__node] = "_node",
  [sym_template_content] = "template_content",
  [sym__statement] = "_statement",
  [sym_liquid_tag] = "liquid_tag",
  [sym__liquid_node] = "_liquid_node",
  [sym__tagged_unpaired_statement] = "_tagged_unpaired_statement",
  [sym__output_statement] = "_output_statement",
  [sym__untagged_unpaired_statement] = "_untagged_unpaired_statement",
  [sym__tagged_paired_statment] = "_tagged_paired_statment",
  [sym__untagged_paired_statement] = "_untagged_paired_statement",
  [sym__expression] = "_expression",
  [sym__literal] = "_literal",
  [sym_string] = "string",
  [sym_boolean] = "boolean",
  [sym_predicate] = "predicate",
  [sym_echo_statement] = "echo_statement",
  [sym_section_statement] = "section_statement",
  [sym_sections_statement] = "sections_statement",
  [sym_increment_statement] = "increment_statement",
  [sym_decrement_statement] = "decrement_statement",
  [sym_layout_statement] = "layout_statement",
  [sym_custom_unpaired_statement] = "custom_unpaired_statement",
  [sym_assignment_statement] = "assignment_statement",
  [sym_cycle_statement] = "cycle_statement",
  [sym_include_statement] = "include_statement",
  [sym__include_param] = "_include_param",
  [sym_render_statement] = "render_statement",
  [sym__render_param] = "_render_param",
  [sym_filter] = "filter",
  [sym_access] = "access",
  [sym_argument_list] = "argument_list",
  [sym_argument] = "argument",
  [sym_range] = "range",
  [sym_if_statement] = "if_statement",
  [sym_elsif_clause] = "elsif_clause",
  [sym_else_clause] = "else_clause",
  [sym_for_loop_statement] = "for_loop_statement",
  [sym_case_statement] = "case_statement",
  [sym_when_clause] = "when_clause",
  [sym_unless_statement] = "unless_statement",
  [sym_capture_statement] = "capture_statement",
  [sym_form_statement] = "form_statement",
  [sym_tablerow_statement] = "tablerow_statement",
  [sym_paginate_statement] = "paginate_statement",
  [sym__if_liq] = "if_statement",
  [sym__elsif_liq] = "elsif_clause",
  [sym__else_liq] = "else_clause",
  [sym__for_loop_liq] = "for_loop_statement",
  [sym__case_liq] = "case_statement",
  [sym__when_liq] = "when_clause",
  [sym__unless_liq] = "unless_statement",
  [sym__capture_liq] = "capture_statement",
  [sym__form_liq] = "form_statement",
  [sym__tablerow_liq] = "tablerow_statement",
  [sym__paginate_liq] = "paginate_statement",
  [sym__else_aliased] = "_else_aliased",
  [sym__elsif_aliased] = "_elsif_aliased",
  [sym__when_aliased] = "_when_aliased",
  [sym__iterator] = "_iterator",
  [sym__page_iterator] = "_page_iterator",
  [sym_schema_statement] = "schema_statement",
  [sym_style_statement] = "style_statement",
  [sym_javascript_statement] = "javascript_statement",
  [sym_raw_statement] = "raw_statement",
  [sym_comment] = "comment",
  [sym_comment_liq] = "comment",
  [sym__inline_comment] = "_inline_comment",
  [sym__paired_comment] = "_paired_comment",
  [sym__paired_comment_liq] = "_paired_comment_liq",
  [aux_sym_program_repeat1] = "program_repeat1",
  [aux_sym_template_content_repeat1] = "template_content_repeat1",
  [aux_sym_liquid_tag_repeat1] = "liquid_tag_repeat1",
  [aux_sym_custom_unpaired_statement_repeat1] = "custom_unpaired_statement_repeat1",
  [aux_sym_cycle_statement_repeat1] = "cycle_statement_repeat1",
  [aux_sym_include_statement_repeat1] = "include_statement_repeat1",
  [aux_sym_argument_list_repeat1] = "argument_list_repeat1",
  [aux_sym_if_statement_repeat1] = "if_statement_repeat1",
  [aux_sym_case_statement_repeat1] = "case_statement_repeat1",
  [aux_sym__if_liq_repeat1] = "_if_liq_repeat1",
  [aux_sym__if_liq_repeat2] = "_if_liq_repeat2",
  [aux_sym__case_liq_repeat1] = "_case_liq_repeat1",
  [aux_sym_style_statement_repeat1] = "style_statement_repeat1",
  [aux_sym_javascript_statement_repeat1] = "javascript_statement_repeat1",
  [aux_sym__inline_comment_repeat1] = "_inline_comment_repeat1",
  [anon_alias_sym_] = "",
  [alias_sym_block] = "block",
  [anon_alias_sym_custom_keyword] = "custom_keyword",
  [alias_sym_js_content] = "js_content",
  [alias_sym_json_content] = "json_content",
  [alias_sym_style_content] = "style_content",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [aux_sym_template_content_token1] = aux_sym_template_content_token1,
  [anon_sym_LBRACE_PERCENT_PERCENT] = anon_sym_LBRACE_PERCENT_PERCENT,
  [anon_sym_LBRACE_LBRACE_LBRACE] = anon_sym_LBRACE_LBRACE_LBRACE,
  [anon_sym_liquid] = anon_sym_liquid,
  [aux_sym__liquid_node_token1] = aux_sym__liquid_node_token1,
  [anon_sym_LBRACE_PERCENT] = anon_sym_LBRACE_PERCENT,
  [anon_sym_LBRACE_PERCENT_DASH] = anon_sym_LBRACE_PERCENT_DASH,
  [anon_sym_PERCENT_RBRACE] = anon_sym_PERCENT_RBRACE,
  [anon_sym_DASH_PERCENT_RBRACE] = anon_sym_DASH_PERCENT_RBRACE,
  [anon_sym_LBRACE_LBRACE] = anon_sym_LBRACE_LBRACE,
  [anon_sym_LBRACE_LBRACE_DASH] = anon_sym_LBRACE_LBRACE_DASH,
  [anon_sym_RBRACE_RBRACE] = anon_sym_RBRACE_RBRACE,
  [anon_sym_DASH_RBRACE_RBRACE] = anon_sym_DASH_RBRACE_RBRACE,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [aux_sym_string_token1] = aux_sym_string_token1,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym_string_token2] = aux_sym_string_token2,
  [sym_number] = sym_number,
  [anon_sym_true] = anon_sym_true,
  [anon_sym_false] = anon_sym_false,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_and] = anon_sym_and,
  [anon_sym_or] = anon_sym_or,
  [anon_sym_contains] = anon_sym_contains,
  [sym_break_statement] = sym_break_statement,
  [sym_continue_statement] = sym_continue_statement,
  [anon_sym_echo] = anon_sym_echo,
  [anon_sym_section] = anon_sym_section,
  [anon_sym_sections] = anon_sym_sections,
  [anon_sym_increment] = anon_sym_increment,
  [anon_sym_decrement] = anon_sym_decrement,
  [anon_sym_layout] = anon_sym_layout,
  [anon_sym_none] = anon_sym_none,
  [anon_sym_assign] = anon_sym_assign,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_cycle] = anon_sym_cycle,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_include] = anon_sym_include,
  [anon_sym_include_relative] = anon_sym_include_relative,
  [aux_sym_include_statement_token1] = sym_string,
  [anon_sym_EQ2] = anon_sym_EQ,
  [anon_sym_render] = anon_sym_render,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_with] = anon_sym_with,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_DOT_DOT] = anon_sym_DOT_DOT,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_endif] = anon_sym_endif,
  [anon_sym_elsif] = anon_sym_elsif,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_endfor] = anon_sym_endfor,
  [anon_sym_case] = anon_sym_case,
  [anon_sym_endcase] = anon_sym_endcase,
  [anon_sym_when] = anon_sym_when,
  [anon_sym_unless] = anon_sym_unless,
  [anon_sym_endunless] = anon_sym_endunless,
  [anon_sym_capture] = anon_sym_capture,
  [anon_sym_endcapture] = anon_sym_endcapture,
  [anon_sym_form] = anon_sym_form,
  [anon_sym_endform] = anon_sym_endform,
  [anon_sym_tablerow] = anon_sym_tablerow,
  [anon_sym_endtablerow] = anon_sym_endtablerow,
  [anon_sym_paginate] = anon_sym_paginate,
  [anon_sym_by] = anon_sym_by,
  [anon_sym_endpaginate] = anon_sym_endpaginate,
  [anon_sym_schema] = anon_sym_schema,
  [anon_sym_endschema] = anon_sym_endschema,
  [anon_sym_style] = anon_sym_style,
  [anon_sym_endstyle] = anon_sym_endstyle,
  [anon_sym_javascript] = anon_sym_javascript,
  [anon_sym_endjavascript] = anon_sym_endjavascript,
  [anon_sym_raw] = anon_sym_raw,
  [anon_sym_endraw] = anon_sym_endraw,
  [anon_sym_comment] = anon_sym_comment,
  [anon_sym_endcomment] = anon_sym_endcomment,
  [sym__inline_comment_content] = sym__inline_comment_content,
  [sym__paired_comment_content] = sym__paired_comment_content,
  [sym__paired_comment_content_liq] = sym__paired_comment_content_liq,
  [sym_raw_content] = sym_raw_content,
  [sym_front_matter] = sym_front_matter,
  [sym_error_sentinel] = sym_error_sentinel,
  [sym_program] = sym_program,
  [sym__node] = sym__node,
  [sym_template_content] = sym_template_content,
  [sym__statement] = sym__statement,
  [sym_liquid_tag] = sym_liquid_tag,
  [sym__liquid_node] = sym__liquid_node,
  [sym__tagged_unpaired_statement] = sym__tagged_unpaired_statement,
  [sym__output_statement] = sym__output_statement,
  [sym__untagged_unpaired_statement] = sym__untagged_unpaired_statement,
  [sym__tagged_paired_statment] = sym__tagged_paired_statment,
  [sym__untagged_paired_statement] = sym__untagged_paired_statement,
  [sym__expression] = sym__expression,
  [sym__literal] = sym__literal,
  [sym_string] = sym_string,
  [sym_boolean] = sym_boolean,
  [sym_predicate] = sym_predicate,
  [sym_echo_statement] = sym_echo_statement,
  [sym_section_statement] = sym_section_statement,
  [sym_sections_statement] = sym_sections_statement,
  [sym_increment_statement] = sym_increment_statement,
  [sym_decrement_statement] = sym_decrement_statement,
  [sym_layout_statement] = sym_layout_statement,
  [sym_custom_unpaired_statement] = sym_custom_unpaired_statement,
  [sym_assignment_statement] = sym_assignment_statement,
  [sym_cycle_statement] = sym_cycle_statement,
  [sym_include_statement] = sym_include_statement,
  [sym__include_param] = sym__include_param,
  [sym_render_statement] = sym_render_statement,
  [sym__render_param] = sym__render_param,
  [sym_filter] = sym_filter,
  [sym_access] = sym_access,
  [sym_argument_list] = sym_argument_list,
  [sym_argument] = sym_argument,
  [sym_range] = sym_range,
  [sym_if_statement] = sym_if_statement,
  [sym_elsif_clause] = sym_elsif_clause,
  [sym_else_clause] = sym_else_clause,
  [sym_for_loop_statement] = sym_for_loop_statement,
  [sym_case_statement] = sym_case_statement,
  [sym_when_clause] = sym_when_clause,
  [sym_unless_statement] = sym_unless_statement,
  [sym_capture_statement] = sym_capture_statement,
  [sym_form_statement] = sym_form_statement,
  [sym_tablerow_statement] = sym_tablerow_statement,
  [sym_paginate_statement] = sym_paginate_statement,
  [sym__if_liq] = sym_if_statement,
  [sym__elsif_liq] = sym_elsif_clause,
  [sym__else_liq] = sym_else_clause,
  [sym__for_loop_liq] = sym_for_loop_statement,
  [sym__case_liq] = sym_case_statement,
  [sym__when_liq] = sym_when_clause,
  [sym__unless_liq] = sym_unless_statement,
  [sym__capture_liq] = sym_capture_statement,
  [sym__form_liq] = sym_form_statement,
  [sym__tablerow_liq] = sym_tablerow_statement,
  [sym__paginate_liq] = sym_paginate_statement,
  [sym__else_aliased] = sym__else_aliased,
  [sym__elsif_aliased] = sym__elsif_aliased,
  [sym__when_aliased] = sym__when_aliased,
  [sym__iterator] = sym__iterator,
  [sym__page_iterator] = sym__page_iterator,
  [sym_schema_statement] = sym_schema_statement,
  [sym_style_statement] = sym_style_statement,
  [sym_javascript_statement] = sym_javascript_statement,
  [sym_raw_statement] = sym_raw_statement,
  [sym_comment] = sym_comment,
  [sym_comment_liq] = sym_comment,
  [sym__inline_comment] = sym__inline_comment,
  [sym__paired_comment] = sym__paired_comment,
  [sym__paired_comment_liq] = sym__paired_comment_liq,
  [aux_sym_program_repeat1] = aux_sym_program_repeat1,
  [aux_sym_template_content_repeat1] = aux_sym_template_content_repeat1,
  [aux_sym_liquid_tag_repeat1] = aux_sym_liquid_tag_repeat1,
  [aux_sym_custom_unpaired_statement_repeat1] = aux_sym_custom_unpaired_statement_repeat1,
  [aux_sym_cycle_statement_repeat1] = aux_sym_cycle_statement_repeat1,
  [aux_sym_include_statement_repeat1] = aux_sym_include_statement_repeat1,
  [aux_sym_argument_list_repeat1] = aux_sym_argument_list_repeat1,
  [aux_sym_if_statement_repeat1] = aux_sym_if_statement_repeat1,
  [aux_sym_case_statement_repeat1] = aux_sym_case_statement_repeat1,
  [aux_sym__if_liq_repeat1] = aux_sym__if_liq_repeat1,
  [aux_sym__if_liq_repeat2] = aux_sym__if_liq_repeat2,
  [aux_sym__case_liq_repeat1] = aux_sym__case_liq_repeat1,
  [aux_sym_style_statement_repeat1] = aux_sym_style_statement_repeat1,
  [aux_sym_javascript_statement_repeat1] = aux_sym_javascript_statement_repeat1,
  [aux_sym__inline_comment_repeat1] = aux_sym__inline_comment_repeat1,
  [anon_alias_sym_] = anon_alias_sym_,
  [alias_sym_block] = alias_sym_block,
  [anon_alias_sym_custom_keyword] = anon_alias_sym_custom_keyword,
  [alias_sym_js_content] = alias_sym_js_content,
  [alias_sym_json_content] = alias_sym_json_content,
  [alias_sym_style_content] = alias_sym_style_content,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_template_content_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_LBRACE_PERCENT_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE_LBRACE_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_liquid] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__liquid_node_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_LBRACE_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE_PERCENT_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_PERCENT_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE_LBRACE_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_RBRACE_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_string_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_string_token2] = {
    .visible = false,
    .named = false,
  },
  [sym_number] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_true] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_false] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_and] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_or] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_contains] = {
    .visible = true,
    .named = false,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_statement] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_echo] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_section] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sections] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_increment] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_decrement] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_layout] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_none] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_assign] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_cycle] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_include] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_include_relative] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_include_statement_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_EQ2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_render] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_with] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_endif] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_elsif] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_endfor] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_endcase] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_when] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unless] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_endunless] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_capture] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_endcapture] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_form] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_endform] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_tablerow] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_endtablerow] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_paginate] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_by] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_endpaginate] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_schema] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_endschema] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_style] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_endstyle] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_javascript] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_endjavascript] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_raw] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_endraw] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_comment] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_endcomment] = {
    .visible = true,
    .named = false,
  },
  [sym__inline_comment_content] = {
    .visible = false,
    .named = true,
  },
  [sym__paired_comment_content] = {
    .visible = false,
    .named = true,
  },
  [sym__paired_comment_content_liq] = {
    .visible = false,
    .named = true,
  },
  [sym_raw_content] = {
    .visible = true,
    .named = true,
  },
  [sym_front_matter] = {
    .visible = true,
    .named = true,
  },
  [sym_error_sentinel] = {
    .visible = true,
    .named = true,
  },
  [sym_program] = {
    .visible = true,
    .named = true,
  },
  [sym__node] = {
    .visible = false,
    .named = true,
  },
  [sym_template_content] = {
    .visible = true,
    .named = true,
  },
  [sym__statement] = {
    .visible = false,
    .named = true,
  },
  [sym_liquid_tag] = {
    .visible = true,
    .named = true,
  },
  [sym__liquid_node] = {
    .visible = false,
    .named = true,
  },
  [sym__tagged_unpaired_statement] = {
    .visible = false,
    .named = true,
  },
  [sym__output_statement] = {
    .visible = false,
    .named = true,
  },
  [sym__untagged_unpaired_statement] = {
    .visible = false,
    .named = true,
  },
  [sym__tagged_paired_statment] = {
    .visible = false,
    .named = true,
  },
  [sym__untagged_paired_statement] = {
    .visible = false,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
  },
  [sym__literal] = {
    .visible = false,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_boolean] = {
    .visible = true,
    .named = true,
  },
  [sym_predicate] = {
    .visible = true,
    .named = true,
  },
  [sym_echo_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_section_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_sections_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_increment_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_decrement_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_layout_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_custom_unpaired_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_cycle_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_include_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__include_param] = {
    .visible = false,
    .named = true,
  },
  [sym_render_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__render_param] = {
    .visible = false,
    .named = true,
  },
  [sym_filter] = {
    .visible = true,
    .named = true,
  },
  [sym_access] = {
    .visible = true,
    .named = true,
  },
  [sym_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_range] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_elsif_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_else_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_for_loop_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_case_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_when_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_unless_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_capture_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_form_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_tablerow_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_paginate_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__if_liq] = {
    .visible = true,
    .named = true,
  },
  [sym__elsif_liq] = {
    .visible = true,
    .named = true,
  },
  [sym__else_liq] = {
    .visible = true,
    .named = true,
  },
  [sym__for_loop_liq] = {
    .visible = true,
    .named = true,
  },
  [sym__case_liq] = {
    .visible = true,
    .named = true,
  },
  [sym__when_liq] = {
    .visible = true,
    .named = true,
  },
  [sym__unless_liq] = {
    .visible = true,
    .named = true,
  },
  [sym__capture_liq] = {
    .visible = true,
    .named = true,
  },
  [sym__form_liq] = {
    .visible = true,
    .named = true,
  },
  [sym__tablerow_liq] = {
    .visible = true,
    .named = true,
  },
  [sym__paginate_liq] = {
    .visible = true,
    .named = true,
  },
  [sym__else_aliased] = {
    .visible = false,
    .named = true,
  },
  [sym__elsif_aliased] = {
    .visible = false,
    .named = true,
  },
  [sym__when_aliased] = {
    .visible = false,
    .named = true,
  },
  [sym__iterator] = {
    .visible = false,
    .named = true,
  },
  [sym__page_iterator] = {
    .visible = false,
    .named = true,
  },
  [sym_schema_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_style_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_javascript_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_raw_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_comment_liq] = {
    .visible = true,
    .named = true,
  },
  [sym__inline_comment] = {
    .visible = false,
    .named = true,
  },
  [sym__paired_comment] = {
    .visible = false,
    .named = true,
  },
  [sym__paired_comment_liq] = {
    .visible = false,
    .named = true,
  },
  [aux_sym_program_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_template_content_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_liquid_tag_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_custom_unpaired_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_cycle_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_include_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_if_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_case_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__if_liq_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__if_liq_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__case_liq_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_style_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_javascript_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__inline_comment_repeat1] = {
    .visible = false,
    .named = false,
  },
  [anon_alias_sym_] = {
    .visible = true,
    .named = false,
  },
  [alias_sym_block] = {
    .visible = true,
    .named = true,
  },
  [anon_alias_sym_custom_keyword] = {
    .visible = true,
    .named = false,
  },
  [alias_sym_js_content] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_json_content] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_style_content] = {
    .visible = true,
    .named = true,
  },
};

enum ts_field_identifiers {
  field_alternative = 1,
  field_arguments = 2,
  field_body = 3,
  field_condition = 4,
  field_conditions = 5,
  field_consequence = 6,
  field_end = 7,
  field_file = 8,
  field_group_item = 9,
  field_group_name = 10,
  field_item = 11,
  field_iteration = 12,
  field_iterator = 13,
  field_key = 14,
  field_left = 15,
  field_modifier = 16,
  field_name = 17,
  field_operator = 18,
  field_parameters = 19,
  field_property = 20,
  field_receiver = 21,
  field_right = 22,
  field_start = 23,
  field_type = 24,
  field_value = 25,
  field_variable = 26,
  field_variable_name = 27,
  field_with = 28,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alternative] = "alternative",
  [field_arguments] = "arguments",
  [field_body] = "body",
  [field_condition] = "condition",
  [field_conditions] = "conditions",
  [field_consequence] = "consequence",
  [field_end] = "end",
  [field_file] = "file",
  [field_group_item] = "group_item",
  [field_group_name] = "group_name",
  [field_item] = "item",
  [field_iteration] = "iteration",
  [field_iterator] = "iterator",
  [field_key] = "key",
  [field_left] = "left",
  [field_modifier] = "modifier",
  [field_name] = "name",
  [field_operator] = "operator",
  [field_parameters] = "parameters",
  [field_property] = "property",
  [field_receiver] = "receiver",
  [field_right] = "right",
  [field_start] = "start",
  [field_type] = "type",
  [field_value] = "value",
  [field_variable] = "variable",
  [field_variable_name] = "variable_name",
  [field_with] = "with",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [2] = {.index = 0, .length = 3},
  [3] = {.index = 3, .length = 5},
  [4] = {.index = 8, .length = 3},
  [5] = {.index = 11, .length = 2},
  [6] = {.index = 13, .length = 2},
  [7] = {.index = 15, .length = 4},
  [8] = {.index = 19, .length = 1},
  [9] = {.index = 20, .length = 1},
  [10] = {.index = 21, .length = 2},
  [13] = {.index = 23, .length = 2},
  [14] = {.index = 25, .length = 3},
  [15] = {.index = 28, .length = 2},
  [16] = {.index = 30, .length = 1},
  [17] = {.index = 31, .length = 1},
  [18] = {.index = 32, .length = 1},
  [19] = {.index = 33, .length = 1},
  [20] = {.index = 34, .length = 2},
  [21] = {.index = 36, .length = 1},
  [22] = {.index = 37, .length = 1},
  [23] = {.index = 38, .length = 2},
  [24] = {.index = 40, .length = 3},
  [25] = {.index = 43, .length = 3},
  [26] = {.index = 46, .length = 4},
  [27] = {.index = 50, .length = 4},
  [28] = {.index = 54, .length = 1},
  [30] = {.index = 55, .length = 2},
  [31] = {.index = 57, .length = 2},
  [32] = {.index = 59, .length = 2},
  [33] = {.index = 61, .length = 2},
  [34] = {.index = 63, .length = 2},
  [35] = {.index = 65, .length = 2},
  [36] = {.index = 67, .length = 2},
  [37] = {.index = 69, .length = 4},
  [38] = {.index = 73, .length = 2},
  [39] = {.index = 75, .length = 3},
  [40] = {.index = 30, .length = 1},
  [41] = {.index = 78, .length = 3},
  [42] = {.index = 81, .length = 3},
  [43] = {.index = 84, .length = 3},
  [44] = {.index = 87, .length = 3},
  [45] = {.index = 90, .length = 3},
  [46] = {.index = 93, .length = 2},
  [47] = {.index = 95, .length = 1},
  [48] = {.index = 96, .length = 1},
  [49] = {.index = 97, .length = 1},
  [50] = {.index = 98, .length = 1},
  [51] = {.index = 99, .length = 1},
  [52] = {.index = 100, .length = 3},
  [55] = {.index = 103, .length = 4},
  [56] = {.index = 107, .length = 4},
  [57] = {.index = 111, .length = 4},
  [59] = {.index = 115, .length = 2},
  [60] = {.index = 117, .length = 2},
  [61] = {.index = 119, .length = 2},
  [62] = {.index = 121, .length = 2},
  [63] = {.index = 123, .length = 2},
  [64] = {.index = 125, .length = 2},
  [66] = {.index = 127, .length = 5},
  [67] = {.index = 132, .length = 2},
  [68] = {.index = 134, .length = 3},
  [69] = {.index = 96, .length = 1},
  [70] = {.index = 137, .length = 3},
  [71] = {.index = 140, .length = 3},
  [72] = {.index = 143, .length = 3},
  [73] = {.index = 146, .length = 3},
  [74] = {.index = 149, .length = 3},
  [75] = {.index = 152, .length = 4},
  [76] = {.index = 156, .length = 4},
  [77] = {.index = 160, .length = 4},
  [78] = {.index = 164, .length = 5},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_alternative, 0, .inherited = true},
    {field_condition, 0, .inherited = true},
    {field_consequence, 0, .inherited = true},
  [3] =
    {field_alternative, 0, .inherited = true},
    {field_body, 0, .inherited = true},
    {field_item, 0, .inherited = true},
    {field_iterator, 0, .inherited = true},
    {field_modifier, 0, .inherited = true},
  [8] =
    {field_alternative, 0, .inherited = true},
    {field_conditions, 0, .inherited = true},
    {field_receiver, 0, .inherited = true},
  [11] =
    {field_value, 0, .inherited = true},
    {field_variable, 0, .inherited = true},
  [13] =
    {field_parameters, 0, .inherited = true},
    {field_type, 0, .inherited = true},
  [15] =
    {field_body, 0, .inherited = true},
    {field_item, 0, .inherited = true},
    {field_iterator, 0, .inherited = true},
    {field_modifier, 0, .inherited = true},
  [19] =
    {field_group_item, 1},
  [20] =
    {field_file, 1},
  [21] =
    {field_group_item, 1},
    {field_group_item, 2},
  [23] =
    {field_property, 2},
    {field_receiver, 0},
  [25] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [28] =
    {field_body, 0},
    {field_name, 2},
  [30] =
    {field_condition, 1},
  [31] =
    {field_condition, 0, .inherited = true},
  [32] =
    {field_alternative, 0},
  [33] =
    {field_receiver, 1},
  [34] =
    {field_condition, 0, .inherited = true},
    {field_consequence, 0, .inherited = true},
  [36] =
    {field_variable, 1},
  [37] =
    {field_type, 1},
  [38] =
    {field_value, 3},
    {field_variable_name, 1},
  [40] =
    {field_group_item, 3},
    {field_group_name, 1},
    {field_group_name, 2},
  [43] =
    {field_arguments, 2},
    {field_arguments, 3},
    {field_file, 1},
  [46] =
    {field_file, 1},
    {field_item, 3, .inherited = true},
    {field_iteration, 2},
    {field_iteration, 3},
  [50] =
    {field_file, 1},
    {field_item, 3, .inherited = true},
    {field_with, 2},
    {field_with, 3},
  [54] =
    {field_iterator, 0},
  [55] =
    {field_alternative, 2},
    {field_condition, 1},
  [57] =
    {field_condition, 1},
    {field_consequence, 2},
  [59] =
    {field_alternative, 2, .inherited = true},
    {field_condition, 1},
  [61] =
    {field_alternative, 0, .inherited = true},
    {field_alternative, 1, .inherited = true},
  [63] =
    {field_alternative, 2},
    {field_receiver, 1},
  [65] =
    {field_conditions, 2},
    {field_receiver, 1},
  [67] =
    {field_value, 2},
    {field_variable, 1},
  [69] =
    {field_group_item, 3},
    {field_group_item, 4},
    {field_group_name, 1},
    {field_group_name, 2},
  [73] =
    {field_iterator, 0},
    {field_modifier, 1},
  [75] =
    {field_item, 1},
    {field_iterator, 3, .inherited = true},
    {field_modifier, 3, .inherited = true},
  [78] =
    {field_alternative, 3},
    {field_condition, 1},
    {field_consequence, 2},
  [81] =
    {field_alternative, 3, .inherited = true},
    {field_condition, 1},
    {field_consequence, 2},
  [84] =
    {field_alternative, 2, .inherited = true},
    {field_alternative, 3},
    {field_condition, 1},
  [87] =
    {field_alternative, 3},
    {field_conditions, 2},
    {field_receiver, 1},
  [90] =
    {field_parameters, 2},
    {field_parameters, 3},
    {field_type, 1},
  [93] =
    {field_key, 0},
    {field_value, 2},
  [95] =
    {field_item, 2},
  [96] =
    {field_condition, 2},
  [97] =
    {field_receiver, 2},
  [98] =
    {field_variable, 2},
  [99] =
    {field_type, 2},
  [100] =
    {field_iterator, 0},
    {field_modifier, 1},
    {field_modifier, 2},
  [103] =
    {field_alternative, 4},
    {field_item, 1},
    {field_iterator, 3, .inherited = true},
    {field_modifier, 3, .inherited = true},
  [107] =
    {field_body, 4},
    {field_item, 1},
    {field_iterator, 3, .inherited = true},
    {field_modifier, 3, .inherited = true},
  [111] =
    {field_alternative, 3, .inherited = true},
    {field_alternative, 4},
    {field_condition, 1},
    {field_consequence, 2},
  [115] =
    {field_alternative, 4},
    {field_condition, 2},
  [117] =
    {field_condition, 2},
    {field_consequence, 4},
  [119] =
    {field_alternative, 4, .inherited = true},
    {field_condition, 2},
  [121] =
    {field_alternative, 4},
    {field_receiver, 2},
  [123] =
    {field_conditions, 4},
    {field_receiver, 2},
  [125] =
    {field_value, 4},
    {field_variable, 2},
  [127] =
    {field_alternative, 5},
    {field_body, 4},
    {field_item, 1},
    {field_iterator, 3, .inherited = true},
    {field_modifier, 3, .inherited = true},
  [132] =
    {field_end, 3},
    {field_start, 1},
  [134] =
    {field_item, 2},
    {field_iterator, 4, .inherited = true},
    {field_modifier, 4, .inherited = true},
  [137] =
    {field_alternative, 5},
    {field_condition, 2},
    {field_consequence, 4},
  [140] =
    {field_alternative, 5, .inherited = true},
    {field_condition, 2},
    {field_consequence, 4},
  [143] =
    {field_alternative, 4, .inherited = true},
    {field_alternative, 5},
    {field_condition, 2},
  [146] =
    {field_alternative, 5},
    {field_conditions, 4},
    {field_receiver, 2},
  [149] =
    {field_parameters, 3},
    {field_parameters, 4},
    {field_type, 2},
  [152] =
    {field_alternative, 6},
    {field_item, 2},
    {field_iterator, 4, .inherited = true},
    {field_modifier, 4, .inherited = true},
  [156] =
    {field_body, 6},
    {field_item, 2},
    {field_iterator, 4, .inherited = true},
    {field_modifier, 4, .inherited = true},
  [160] =
    {field_alternative, 5, .inherited = true},
    {field_alternative, 6},
    {field_condition, 2},
    {field_consequence, 4},
  [164] =
    {field_alternative, 7},
    {field_body, 6},
    {field_item, 2},
    {field_iterator, 4, .inherited = true},
    {field_modifier, 4, .inherited = true},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = anon_alias_sym_custom_keyword,
  },
  [11] = {
    [0] = alias_sym_style_content,
  },
  [12] = {
    [0] = alias_sym_js_content,
  },
  [29] = {
    [1] = alias_sym_block,
  },
  [31] = {
    [2] = alias_sym_block,
  },
  [35] = {
    [2] = alias_sym_block,
  },
  [36] = {
    [2] = alias_sym_block,
  },
  [40] = {
    [2] = alias_sym_block,
  },
  [41] = {
    [2] = alias_sym_block,
  },
  [42] = {
    [2] = alias_sym_block,
  },
  [44] = {
    [2] = alias_sym_block,
  },
  [53] = {
    [3] = alias_sym_json_content,
  },
  [54] = {
    [0] = anon_alias_sym_,
    [2] = anon_alias_sym_,
    [4] = anon_alias_sym_,
    [6] = anon_alias_sym_,
  },
  [56] = {
    [4] = alias_sym_block,
  },
  [57] = {
    [2] = alias_sym_block,
  },
  [58] = {
    [3] = alias_sym_block,
  },
  [60] = {
    [4] = alias_sym_block,
  },
  [63] = {
    [4] = alias_sym_block,
  },
  [64] = {
    [4] = alias_sym_block,
  },
  [65] = {
    [0] = anon_alias_sym_,
    [2] = anon_alias_sym_,
    [5] = anon_alias_sym_,
    [7] = anon_alias_sym_,
  },
  [66] = {
    [4] = alias_sym_block,
  },
  [69] = {
    [4] = alias_sym_block,
  },
  [70] = {
    [4] = alias_sym_block,
  },
  [71] = {
    [4] = alias_sym_block,
  },
  [73] = {
    [4] = alias_sym_block,
  },
  [76] = {
    [6] = alias_sym_block,
  },
  [77] = {
    [4] = alias_sym_block,
  },
  [78] = {
    [6] = alias_sym_block,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym_template_content, 4,
    sym_template_content,
    alias_sym_js_content,
    alias_sym_json_content,
    alias_sym_style_content,
  aux_sym_program_repeat1, 2,
    aux_sym_program_repeat1,
    alias_sym_block,
  aux_sym_case_statement_repeat1, 2,
    aux_sym_case_statement_repeat1,
    alias_sym_block,
  aux_sym__if_liq_repeat1, 2,
    aux_sym__if_liq_repeat1,
    alias_sym_block,
  aux_sym__case_liq_repeat1, 2,
    aux_sym__case_liq_repeat1,
    alias_sym_block,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 4,
  [5] = 5,
  [6] = 6,
  [7] = 7,
  [8] = 8,
  [9] = 9,
  [10] = 10,
  [11] = 11,
  [12] = 12,
  [13] = 13,
  [14] = 14,
  [15] = 15,
  [16] = 16,
  [17] = 17,
  [18] = 18,
  [19] = 19,
  [20] = 20,
  [21] = 21,
  [22] = 22,
  [23] = 23,
  [24] = 24,
  [25] = 25,
  [26] = 26,
  [27] = 27,
  [28] = 28,
  [29] = 29,
  [30] = 30,
  [31] = 31,
  [32] = 32,
  [33] = 33,
  [34] = 34,
  [35] = 35,
  [36] = 36,
  [37] = 37,
  [38] = 38,
  [39] = 39,
  [40] = 40,
  [41] = 41,
  [42] = 42,
  [43] = 43,
  [44] = 44,
  [45] = 45,
  [46] = 46,
  [47] = 47,
  [48] = 48,
  [49] = 49,
  [50] = 50,
  [51] = 51,
  [52] = 52,
  [53] = 53,
  [54] = 54,
  [55] = 55,
  [56] = 56,
  [57] = 57,
  [58] = 58,
  [59] = 58,
  [60] = 60,
  [61] = 61,
  [62] = 60,
  [63] = 61,
  [64] = 57,
  [65] = 65,
  [66] = 65,
  [67] = 67,
  [68] = 68,
  [69] = 67,
  [70] = 70,
  [71] = 71,
  [72] = 72,
  [73] = 73,
  [74] = 74,
  [75] = 68,
  [76] = 70,
  [77] = 71,
  [78] = 74,
  [79] = 73,
  [80] = 72,
  [81] = 81,
  [82] = 82,
  [83] = 83,
  [84] = 84,
  [85] = 85,
  [86] = 86,
  [87] = 87,
  [88] = 83,
  [89] = 86,
  [90] = 81,
  [91] = 91,
  [92] = 92,
  [93] = 93,
  [94] = 94,
  [95] = 95,
  [96] = 93,
  [97] = 97,
  [98] = 95,
  [99] = 99,
  [100] = 100,
  [101] = 101,
  [102] = 97,
  [103] = 85,
  [104] = 84,
  [105] = 105,
  [106] = 82,
  [107] = 99,
  [108] = 100,
  [109] = 109,
  [110] = 101,
  [111] = 105,
  [112] = 112,
  [113] = 109,
  [114] = 112,
  [115] = 115,
  [116] = 116,
  [117] = 117,
  [118] = 118,
  [119] = 119,
  [120] = 91,
  [121] = 121,
  [122] = 122,
  [123] = 117,
  [124] = 92,
  [125] = 118,
  [126] = 119,
  [127] = 116,
  [128] = 121,
  [129] = 122,
  [130] = 115,
  [131] = 87,
  [132] = 94,
  [133] = 133,
  [134] = 133,
  [135] = 135,
  [136] = 136,
  [137] = 137,
  [138] = 138,
  [139] = 139,
  [140] = 140,
  [141] = 141,
  [142] = 142,
  [143] = 143,
  [144] = 136,
  [145] = 145,
  [146] = 145,
  [147] = 147,
  [148] = 148,
  [149] = 148,
  [150] = 143,
  [151] = 151,
  [152] = 152,
  [153] = 153,
  [154] = 152,
  [155] = 155,
  [156] = 156,
  [157] = 157,
  [158] = 158,
  [159] = 159,
  [160] = 160,
  [161] = 161,
  [162] = 162,
  [163] = 163,
  [164] = 161,
  [165] = 160,
  [166] = 166,
  [167] = 167,
  [168] = 166,
  [169] = 167,
  [170] = 170,
  [171] = 39,
  [172] = 172,
  [173] = 173,
  [174] = 174,
  [175] = 175,
  [176] = 176,
  [177] = 31,
  [178] = 178,
  [179] = 163,
  [180] = 180,
  [181] = 181,
  [182] = 182,
  [183] = 183,
  [184] = 184,
  [185] = 185,
  [186] = 178,
  [187] = 181,
  [188] = 182,
  [189] = 189,
  [190] = 190,
  [191] = 173,
  [192] = 192,
  [193] = 193,
  [194] = 175,
  [195] = 195,
  [196] = 184,
  [197] = 174,
  [198] = 176,
  [199] = 195,
  [200] = 200,
  [201] = 201,
  [202] = 185,
  [203] = 32,
  [204] = 172,
  [205] = 183,
  [206] = 193,
  [207] = 180,
  [208] = 22,
  [209] = 209,
  [210] = 20,
  [211] = 211,
  [212] = 212,
  [213] = 213,
  [214] = 214,
  [215] = 212,
  [216] = 214,
  [217] = 211,
  [218] = 213,
  [219] = 219,
  [220] = 26,
  [221] = 25,
  [222] = 32,
  [223] = 31,
  [224] = 37,
  [225] = 36,
  [226] = 38,
  [227] = 44,
  [228] = 39,
  [229] = 229,
  [230] = 43,
  [231] = 40,
  [232] = 41,
  [233] = 40,
  [234] = 42,
  [235] = 45,
  [236] = 54,
  [237] = 49,
  [238] = 47,
  [239] = 20,
  [240] = 46,
  [241] = 51,
  [242] = 22,
  [243] = 50,
  [244] = 229,
  [245] = 53,
  [246] = 48,
  [247] = 26,
  [248] = 25,
  [249] = 44,
  [250] = 36,
  [251] = 37,
  [252] = 52,
  [253] = 38,
  [254] = 39,
  [255] = 41,
  [256] = 43,
  [257] = 22,
  [258] = 40,
  [259] = 45,
  [260] = 42,
  [261] = 55,
  [262] = 20,
  [263] = 26,
  [264] = 46,
  [265] = 32,
  [266] = 31,
  [267] = 47,
  [268] = 50,
  [269] = 48,
  [270] = 49,
  [271] = 51,
  [272] = 53,
  [273] = 25,
  [274] = 54,
  [275] = 38,
  [276] = 37,
  [277] = 44,
  [278] = 36,
  [279] = 56,
  [280] = 45,
  [281] = 43,
  [282] = 41,
  [283] = 42,
  [284] = 284,
  [285] = 285,
  [286] = 286,
  [287] = 287,
  [288] = 288,
  [289] = 54,
  [290] = 285,
  [291] = 291,
  [292] = 292,
  [293] = 47,
  [294] = 285,
  [295] = 48,
  [296] = 296,
  [297] = 297,
  [298] = 298,
  [299] = 284,
  [300] = 285,
  [301] = 49,
  [302] = 46,
  [303] = 286,
  [304] = 304,
  [305] = 305,
  [306] = 306,
  [307] = 51,
  [308] = 305,
  [309] = 292,
  [310] = 297,
  [311] = 53,
  [312] = 50,
  [313] = 296,
  [314] = 287,
  [315] = 315,
  [316] = 316,
  [317] = 298,
  [318] = 316,
  [319] = 319,
  [320] = 288,
  [321] = 137,
  [322] = 322,
  [323] = 322,
  [324] = 324,
  [325] = 325,
  [326] = 326,
  [327] = 327,
  [328] = 328,
  [329] = 329,
  [330] = 330,
  [331] = 331,
  [332] = 332,
  [333] = 328,
  [334] = 331,
  [335] = 335,
  [336] = 336,
  [337] = 337,
  [338] = 325,
  [339] = 339,
  [340] = 332,
  [341] = 326,
  [342] = 342,
  [343] = 343,
  [344] = 344,
  [345] = 345,
  [346] = 346,
  [347] = 329,
  [348] = 327,
  [349] = 335,
  [350] = 337,
  [351] = 326,
  [352] = 329,
  [353] = 327,
  [354] = 335,
  [355] = 345,
  [356] = 337,
  [357] = 343,
  [358] = 325,
  [359] = 346,
  [360] = 326,
  [361] = 336,
  [362] = 346,
  [363] = 329,
  [364] = 346,
  [365] = 324,
  [366] = 325,
  [367] = 337,
  [368] = 335,
  [369] = 327,
  [370] = 138,
  [371] = 371,
  [372] = 372,
  [373] = 373,
  [374] = 372,
  [375] = 375,
  [376] = 376,
  [377] = 375,
  [378] = 371,
  [379] = 376,
  [380] = 376,
  [381] = 376,
  [382] = 382,
  [383] = 382,
  [384] = 382,
  [385] = 382,
  [386] = 382,
  [387] = 387,
  [388] = 387,
  [389] = 387,
  [390] = 387,
  [391] = 387,
  [392] = 392,
  [393] = 393,
  [394] = 394,
  [395] = 395,
  [396] = 396,
  [397] = 397,
  [398] = 398,
  [399] = 399,
  [400] = 400,
  [401] = 401,
  [402] = 402,
  [403] = 403,
  [404] = 404,
  [405] = 405,
  [406] = 393,
  [407] = 394,
  [408] = 408,
  [409] = 409,
  [410] = 410,
  [411] = 411,
  [412] = 412,
  [413] = 413,
  [414] = 414,
  [415] = 415,
  [416] = 416,
  [417] = 417,
  [418] = 418,
  [419] = 419,
  [420] = 420,
  [421] = 421,
  [422] = 422,
  [423] = 423,
  [424] = 424,
  [425] = 425,
  [426] = 426,
  [427] = 427,
  [428] = 428,
  [429] = 429,
  [430] = 430,
  [431] = 431,
  [432] = 432,
  [433] = 433,
  [434] = 434,
  [435] = 435,
  [436] = 436,
  [437] = 437,
  [438] = 438,
  [439] = 439,
  [440] = 440,
  [441] = 441,
  [442] = 442,
  [443] = 443,
  [444] = 444,
  [445] = 445,
  [446] = 446,
  [447] = 447,
  [448] = 448,
  [449] = 449,
  [450] = 450,
  [451] = 451,
  [452] = 452,
  [453] = 453,
  [454] = 454,
  [455] = 455,
  [456] = 456,
  [457] = 457,
  [458] = 458,
  [459] = 459,
  [460] = 460,
  [461] = 461,
  [462] = 462,
  [463] = 463,
  [464] = 464,
  [465] = 465,
  [466] = 466,
  [467] = 467,
  [468] = 468,
  [469] = 469,
  [470] = 470,
  [471] = 471,
  [472] = 472,
  [473] = 473,
  [474] = 474,
  [475] = 475,
  [476] = 476,
  [477] = 477,
  [478] = 478,
  [479] = 479,
  [480] = 480,
  [481] = 481,
  [482] = 482,
  [483] = 483,
  [484] = 484,
  [485] = 485,
  [486] = 486,
  [487] = 487,
  [488] = 488,
  [489] = 489,
  [490] = 490,
  [491] = 491,
  [492] = 492,
  [493] = 493,
  [494] = 494,
  [495] = 495,
  [496] = 496,
  [497] = 497,
  [498] = 498,
  [499] = 499,
  [500] = 500,
  [501] = 501,
  [502] = 502,
  [503] = 503,
  [504] = 504,
  [505] = 505,
  [506] = 506,
  [507] = 507,
  [508] = 508,
  [509] = 509,
  [510] = 510,
  [511] = 511,
  [512] = 512,
  [513] = 513,
  [514] = 514,
  [515] = 515,
  [516] = 516,
  [517] = 517,
  [518] = 518,
  [519] = 519,
  [520] = 520,
  [521] = 521,
  [522] = 522,
  [523] = 523,
  [524] = 524,
  [525] = 525,
  [526] = 526,
  [527] = 527,
  [528] = 528,
  [529] = 529,
  [530] = 475,
  [531] = 140,
  [532] = 527,
  [533] = 526,
  [534] = 525,
  [535] = 523,
  [536] = 522,
  [537] = 521,
  [538] = 520,
  [539] = 519,
  [540] = 514,
  [541] = 518,
  [542] = 517,
  [543] = 513,
  [544] = 411,
  [545] = 510,
  [546] = 39,
  [547] = 418,
  [548] = 404,
  [549] = 509,
  [550] = 508,
  [551] = 507,
  [552] = 504,
  [553] = 412,
  [554] = 516,
  [555] = 515,
  [556] = 503,
  [557] = 415,
  [558] = 502,
  [559] = 413,
  [560] = 414,
  [561] = 512,
  [562] = 500,
  [563] = 396,
  [564] = 410,
  [565] = 565,
  [566] = 511,
  [567] = 492,
  [568] = 498,
  [569] = 497,
  [570] = 496,
  [571] = 495,
  [572] = 491,
  [573] = 488,
  [574] = 494,
  [575] = 493,
  [576] = 430,
  [577] = 489,
  [578] = 487,
  [579] = 486,
  [580] = 484,
  [581] = 483,
  [582] = 482,
  [583] = 481,
  [584] = 485,
  [585] = 479,
  [586] = 480,
  [587] = 477,
  [588] = 474,
  [589] = 473,
  [590] = 402,
  [591] = 468,
  [592] = 429,
  [593] = 467,
  [594] = 478,
  [595] = 476,
  [596] = 466,
  [597] = 465,
  [598] = 464,
  [599] = 416,
  [600] = 461,
  [601] = 460,
  [602] = 450,
  [603] = 528,
  [604] = 499,
  [605] = 472,
  [606] = 458,
  [607] = 457,
  [608] = 456,
  [609] = 455,
  [610] = 454,
  [611] = 452,
  [612] = 451,
  [613] = 459,
  [614] = 449,
  [615] = 448,
  [616] = 447,
  [617] = 446,
  [618] = 529,
  [619] = 403,
  [620] = 405,
  [621] = 395,
  [622] = 524,
  [623] = 419,
  [624] = 417,
  [625] = 625,
  [626] = 626,
  [627] = 445,
  [628] = 444,
  [629] = 443,
  [630] = 442,
  [631] = 441,
  [632] = 440,
  [633] = 439,
  [634] = 438,
  [635] = 436,
  [636] = 431,
  [637] = 490,
  [638] = 453,
  [639] = 408,
  [640] = 421,
  [641] = 428,
  [642] = 409,
  [643] = 427,
  [644] = 426,
  [645] = 645,
  [646] = 471,
  [647] = 470,
  [648] = 469,
  [649] = 463,
  [650] = 462,
  [651] = 437,
  [652] = 435,
  [653] = 434,
  [654] = 433,
  [655] = 506,
  [656] = 505,
  [657] = 501,
  [658] = 420,
  [659] = 422,
  [660] = 425,
  [661] = 424,
  [662] = 432,
  [663] = 423,
  [664] = 664,
  [665] = 665,
  [666] = 22,
  [667] = 394,
  [668] = 668,
  [669] = 665,
  [670] = 670,
  [671] = 671,
  [672] = 664,
  [673] = 673,
  [674] = 671,
  [675] = 670,
  [676] = 676,
  [677] = 20,
  [678] = 678,
  [679] = 679,
  [680] = 680,
  [681] = 681,
  [682] = 682,
  [683] = 678,
  [684] = 684,
  [685] = 685,
  [686] = 686,
  [687] = 25,
  [688] = 688,
  [689] = 673,
  [690] = 26,
  [691] = 691,
  [692] = 692,
  [693] = 693,
  [694] = 694,
  [695] = 695,
  [696] = 696,
  [697] = 668,
  [698] = 698,
  [699] = 699,
  [700] = 700,
  [701] = 684,
  [702] = 702,
  [703] = 679,
  [704] = 681,
  [705] = 688,
  [706] = 706,
  [707] = 698,
  [708] = 702,
  [709] = 686,
  [710] = 710,
  [711] = 699,
  [712] = 700,
  [713] = 153,
  [714] = 696,
  [715] = 715,
  [716] = 716,
  [717] = 717,
  [718] = 718,
  [719] = 719,
  [720] = 695,
  [721] = 693,
  [722] = 36,
  [723] = 723,
  [724] = 724,
  [725] = 37,
  [726] = 726,
  [727] = 38,
  [728] = 719,
  [729] = 729,
  [730] = 730,
  [731] = 682,
  [732] = 732,
  [733] = 706,
  [734] = 734,
  [735] = 715,
  [736] = 710,
  [737] = 691,
  [738] = 738,
  [739] = 739,
  [740] = 740,
  [741] = 716,
  [742] = 738,
  [743] = 718,
  [744] = 738,
  [745] = 745,
  [746] = 738,
  [747] = 732,
  [748] = 685,
  [749] = 749,
  [750] = 750,
  [751] = 751,
  [752] = 752,
  [753] = 753,
  [754] = 754,
  [755] = 755,
  [756] = 756,
  [757] = 757,
  [758] = 758,
  [759] = 759,
  [760] = 752,
  [761] = 761,
  [762] = 759,
  [763] = 763,
  [764] = 764,
  [765] = 765,
  [766] = 766,
  [767] = 767,
  [768] = 752,
  [769] = 769,
  [770] = 770,
  [771] = 771,
  [772] = 761,
  [773] = 745,
  [774] = 774,
  [775] = 749,
  [776] = 753,
  [777] = 761,
  [778] = 778,
  [779] = 771,
  [780] = 162,
  [781] = 756,
  [782] = 782,
  [783] = 730,
  [784] = 784,
  [785] = 785,
  [786] = 729,
  [787] = 782,
  [788] = 784,
  [789] = 789,
  [790] = 767,
  [791] = 766,
  [792] = 785,
  [793] = 765,
  [794] = 754,
  [795] = 764,
  [796] = 763,
  [797] = 726,
  [798] = 798,
  [799] = 799,
  [800] = 750,
  [801] = 757,
  [802] = 758,
  [803] = 803,
  [804] = 804,
  [805] = 805,
  [806] = 806,
  [807] = 807,
  [808] = 808,
  [809] = 809,
  [810] = 810,
  [811] = 811,
  [812] = 812,
  [813] = 751,
  [814] = 809,
  [815] = 810,
  [816] = 816,
  [817] = 817,
  [818] = 818,
  [819] = 819,
  [820] = 820,
  [821] = 821,
  [822] = 822,
  [823] = 823,
  [824] = 824,
  [825] = 825,
  [826] = 774,
  [827] = 804,
  [828] = 828,
  [829] = 829,
  [830] = 830,
  [831] = 817,
  [832] = 832,
  [833] = 833,
  [834] = 834,
  [835] = 835,
  [836] = 803,
  [837] = 837,
  [838] = 838,
  [839] = 839,
  [840] = 840,
  [841] = 841,
  [842] = 842,
  [843] = 843,
  [844] = 844,
  [845] = 845,
  [846] = 846,
  [847] = 847,
  [848] = 808,
  [849] = 849,
  [850] = 850,
  [851] = 851,
  [852] = 845,
  [853] = 805,
  [854] = 816,
  [855] = 835,
  [856] = 834,
  [857] = 830,
  [858] = 844,
  [859] = 810,
  [860] = 839,
  [861] = 809,
  [862] = 849,
  [863] = 863,
  [864] = 864,
  [865] = 865,
  [866] = 866,
  [867] = 867,
  [868] = 868,
  [869] = 869,
  [870] = 870,
  [871] = 871,
  [872] = 872,
  [873] = 873,
  [874] = 874,
  [875] = 875,
  [876] = 864,
  [877] = 877,
  [878] = 878,
  [879] = 866,
  [880] = 880,
  [881] = 881,
  [882] = 882,
  [883] = 435,
  [884] = 437,
  [885] = 511,
  [886] = 512,
  [887] = 867,
  [888] = 888,
  [889] = 840,
  [890] = 890,
  [891] = 841,
  [892] = 869,
  [893] = 893,
  [894] = 894,
  [895] = 880,
  [896] = 896,
  [897] = 897,
  [898] = 898,
  [899] = 899,
  [900] = 900,
  [901] = 901,
  [902] = 902,
  [903] = 903,
  [904] = 904,
  [905] = 905,
  [906] = 906,
  [907] = 907,
  [908] = 908,
  [909] = 909,
  [910] = 910,
  [911] = 911,
  [912] = 912,
  [913] = 913,
  [914] = 914,
  [915] = 915,
  [916] = 916,
  [917] = 917,
  [918] = 918,
  [919] = 840,
  [920] = 915,
  [921] = 921,
  [922] = 922,
  [923] = 923,
  [924] = 924,
  [925] = 925,
  [926] = 841,
  [927] = 916,
  [928] = 928,
  [929] = 863,
  [930] = 930,
  [931] = 931,
  [932] = 932,
  [933] = 933,
  [934] = 934,
  [935] = 818,
  [936] = 936,
  [937] = 937,
  [938] = 938,
  [939] = 939,
  [940] = 940,
  [941] = 941,
  [942] = 819,
  [943] = 820,
  [944] = 944,
  [945] = 934,
  [946] = 946,
  [947] = 906,
  [948] = 948,
  [949] = 896,
  [950] = 950,
  [951] = 899,
  [952] = 952,
  [953] = 901,
  [954] = 931,
  [955] = 930,
  [956] = 956,
  [957] = 821,
  [958] = 958,
  [959] = 959,
  [960] = 898,
  [961] = 890,
  [962] = 881,
  [963] = 875,
  [964] = 874,
  [965] = 873,
  [966] = 872,
  [967] = 871,
  [968] = 870,
  [969] = 868,
  [970] = 970,
  [971] = 971,
  [972] = 972,
  [973] = 973,
  [974] = 847,
  [975] = 846,
  [976] = 843,
  [977] = 842,
  [978] = 837,
  [979] = 979,
  [980] = 833,
  [981] = 832,
  [982] = 829,
  [983] = 828,
  [984] = 825,
  [985] = 824,
  [986] = 823,
  [987] = 822,
  [988] = 812,
  [989] = 811,
  [990] = 807,
  [991] = 806,
  [992] = 850,
  [993] = 878,
  [994] = 882,
  [995] = 893,
  [996] = 894,
  [997] = 900,
  [998] = 902,
  [999] = 903,
  [1000] = 913,
  [1001] = 925,
  [1002] = 928,
  [1003] = 940,
  [1004] = 941,
  [1005] = 952,
  [1006] = 958,
  [1007] = 972,
  [1008] = 877,
  [1009] = 1009,
  [1010] = 1010,
  [1011] = 1011,
  [1012] = 904,
  [1013] = 1013,
  [1014] = 1014,
  [1015] = 1015,
  [1016] = 1016,
  [1017] = 979,
  [1018] = 959,
  [1019] = 948,
  [1020] = 944,
  [1021] = 939,
  [1022] = 938,
  [1023] = 937,
  [1024] = 936,
  [1025] = 933,
  [1026] = 932,
  [1027] = 924,
  [1028] = 1028,
  [1029] = 923,
  [1030] = 922,
  [1031] = 921,
  [1032] = 918,
  [1033] = 917,
  [1034] = 914,
  [1035] = 912,
  [1036] = 905,
  [1037] = 946,
  [1038] = 1016,
  [1039] = 1015,
  [1040] = 915,
  [1041] = 916,
  [1042] = 1014,
  [1043] = 870,
  [1044] = 868,
  [1045] = 823,
  [1046] = 822,
  [1047] = 1028,
  [1048] = 1013,
  [1049] = 1011,
  [1050] = 1010,
  [1051] = 1009,
  [1052] = 1052,
  [1053] = 1053,
  [1054] = 1054,
  [1055] = 1055,
  [1056] = 1056,
  [1057] = 1052,
  [1058] = 1058,
  [1059] = 1059,
  [1060] = 1060,
  [1061] = 1061,
  [1062] = 1062,
  [1063] = 1063,
  [1064] = 1064,
  [1065] = 1065,
  [1066] = 1066,
  [1067] = 1067,
  [1068] = 1068,
  [1069] = 1069,
  [1070] = 1054,
  [1071] = 1071,
  [1072] = 1072,
  [1073] = 1073,
  [1074] = 1074,
  [1075] = 1060,
  [1076] = 1076,
  [1077] = 1077,
  [1078] = 1078,
  [1079] = 1067,
  [1080] = 1080,
  [1081] = 1081,
  [1082] = 151,
  [1083] = 1083,
  [1084] = 1056,
  [1085] = 1085,
  [1086] = 1086,
  [1087] = 1087,
  [1088] = 1054,
  [1089] = 1089,
  [1090] = 1090,
  [1091] = 1054,
  [1092] = 1092,
  [1093] = 1093,
  [1094] = 1072,
  [1095] = 1095,
  [1096] = 1096,
  [1097] = 1097,
  [1098] = 1098,
  [1099] = 1073,
  [1100] = 1060,
  [1101] = 1101,
  [1102] = 1102,
  [1103] = 1067,
  [1104] = 1104,
  [1105] = 1105,
  [1106] = 1093,
  [1107] = 1069,
  [1108] = 1108,
  [1109] = 1109,
  [1110] = 1110,
  [1111] = 1111,
  [1112] = 1112,
  [1113] = 1113,
  [1114] = 1072,
  [1115] = 1073,
  [1116] = 1116,
  [1117] = 1117,
  [1118] = 1060,
  [1119] = 907,
  [1120] = 1120,
  [1121] = 1121,
  [1122] = 1122,
  [1123] = 1123,
  [1124] = 1067,
  [1125] = 1125,
  [1126] = 1126,
  [1127] = 1127,
  [1128] = 1123,
  [1129] = 1129,
  [1130] = 1122,
  [1131] = 1117,
  [1132] = 1132,
  [1133] = 1076,
  [1134] = 1077,
  [1135] = 1089,
  [1136] = 1090,
  [1137] = 1137,
  [1138] = 1138,
  [1139] = 1058,
  [1140] = 1140,
  [1141] = 1141,
  [1142] = 1142,
  [1143] = 1086,
  [1144] = 1087,
  [1145] = 1145,
  [1146] = 1073,
  [1147] = 1072,
  [1148] = 1052,
  [1149] = 1104,
  [1150] = 1150,
  [1151] = 1151,
  [1152] = 1152,
  [1153] = 1153,
  [1154] = 1154,
  [1155] = 1155,
  [1156] = 1156,
  [1157] = 1157,
  [1158] = 1158,
  [1159] = 1159,
  [1160] = 1160,
  [1161] = 1083,
  [1162] = 1162,
  [1163] = 1163,
  [1164] = 1164,
  [1165] = 1165,
  [1166] = 1074,
  [1167] = 1167,
  [1168] = 1168,
  [1169] = 1108,
  [1170] = 1059,
  [1171] = 1121,
  [1172] = 1078,
  [1173] = 1120,
  [1174] = 1174,
  [1175] = 1080,
  [1176] = 1176,
  [1177] = 1086,
  [1178] = 1087,
  [1179] = 1179,
  [1180] = 1180,
  [1181] = 1181,
  [1182] = 1182,
  [1183] = 1058,
  [1184] = 1052,
  [1185] = 908,
  [1186] = 1186,
  [1187] = 1187,
  [1188] = 1188,
  [1189] = 1189,
  [1190] = 1190,
  [1191] = 1191,
  [1192] = 1192,
  [1193] = 1193,
  [1194] = 1194,
  [1195] = 1195,
  [1196] = 1196,
  [1197] = 1197,
  [1198] = 1198,
  [1199] = 1092,
  [1200] = 909,
  [1201] = 910,
  [1202] = 1095,
  [1203] = 1096,
  [1204] = 1097,
  [1205] = 1205,
  [1206] = 1206,
  [1207] = 911,
  [1208] = 1098,
  [1209] = 1101,
  [1210] = 1210,
  [1211] = 147,
  [1212] = 1102,
  [1213] = 1127,
  [1214] = 1126,
  [1215] = 1058,
  [1216] = 1216,
  [1217] = 1217,
  [1218] = 1218,
  [1219] = 1127,
  [1220] = 1126,
  [1221] = 1055,
  [1222] = 1222,
  [1223] = 851,
  [1224] = 1206,
  [1225] = 1109,
  [1226] = 1226,
  [1227] = 1227,
  [1228] = 1228,
  [1229] = 1125,
  [1230] = 973,
  [1231] = 1231,
  [1232] = 971,
  [1233] = 1112,
  [1234] = 1113,
  [1235] = 1137,
  [1236] = 1129,
  [1237] = 970,
  [1238] = 1210,
  [1239] = 1197,
  [1240] = 1116,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(21);
      ADVANCE_MAP(
        '!', 8,
        '"', 42,
        '%', 57,
        '\'', 38,
        '(', 79,
        ')', 81,
        '*', 54,
        '+', 48,
        ',', 68,
        '-', 50,
        '.', 75,
        '/', 55,
        ':', 67,
        '<', 60,
        '=', 71,
        '>', 64,
        '[', 77,
        ']', 78,
        '^', 58,
        '{', 6,
        '|', 72,
        '}', 14,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(19);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(46);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(37);
      END_STATE();
    case 1:
      ADVANCE_MAP(
        '\n', 27,
        '\r', 27,
        '!', 8,
        '"', 42,
        '%', 56,
        '\'', 38,
        '*', 54,
        '+', 48,
        ',', 68,
        '-', 53,
        '.', 76,
        '/', 55,
        ':', 67,
        '<', 60,
        '=', 9,
        '>', 64,
        '[', 77,
        '^', 58,
        '{', 12,
        '|', 72,
      );
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(1);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(46);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(37);
      END_STATE();
    case 2:
      ADVANCE_MAP(
        '\n', 27,
        '\r', 27,
        '!', 8,
        '%', 56,
        '*', 54,
        '+', 48,
        ',', 68,
        '-', 49,
        '.', 73,
        '/', 55,
        ':', 67,
        '<', 60,
        '=', 9,
        '>', 64,
        '[', 77,
        '^', 58,
        '|', 72,
      );
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(2);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(37);
      END_STATE();
    case 3:
      ADVANCE_MAP(
        '!', 8,
        '"', 42,
        '%', 57,
        '\'', 38,
        '*', 54,
        '+', 48,
        ',', 68,
        '-', 51,
        '.', 76,
        '/', 55,
        ':', 67,
        '<', 60,
        '=', 9,
        '>', 64,
        '[', 77,
        '^', 58,
        '{', 12,
        '|', 72,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(3);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(46);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(37);
      END_STATE();
    case 4:
      ADVANCE_MAP(
        '!', 8,
        '%', 57,
        ')', 81,
        '*', 54,
        '+', 48,
        ',', 68,
        '-', 52,
        '.', 74,
        '/', 55,
        ':', 67,
        '<', 60,
        '=', 9,
        '>', 64,
        '[', 77,
        ']', 78,
        '^', 58,
        '|', 72,
        '}', 14,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(4);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(37);
      END_STATE();
    case 5:
      if (lookahead == '"') ADVANCE(43);
      if (lookahead == '\'') ADVANCE(39);
      if (lookahead == '{') ADVANCE(13);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(5);
      if (lookahead != 0) ADVANCE(69);
      END_STATE();
    case 6:
      if (lookahead == '%') ADVANCE(28);
      if (lookahead == '{') ADVANCE(33);
      END_STATE();
    case 7:
      if (lookahead == '%') ADVANCE(28);
      if (lookahead == '{') ADVANCE(33);
      if (lookahead != 0) ADVANCE(22);
      END_STATE();
    case 8:
      if (lookahead == '=') ADVANCE(62);
      END_STATE();
    case 9:
      if (lookahead == '=') ADVANCE(59);
      END_STATE();
    case 10:
      if (lookahead == '=') ADVANCE(70);
      END_STATE();
    case 11:
      if (lookahead == '=') ADVANCE(65);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(11);
      END_STATE();
    case 12:
      if (lookahead == '{') ADVANCE(32);
      END_STATE();
    case 13:
      if (lookahead == '{') ADVANCE(32);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != '%') ADVANCE(69);
      END_STATE();
    case 14:
      if (lookahead == '}') ADVANCE(35);
      END_STATE();
    case 15:
      if (lookahead == '}') ADVANCE(31);
      END_STATE();
    case 16:
      if (lookahead == '}') ADVANCE(36);
      END_STATE();
    case 17:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(47);
      END_STATE();
    case 18:
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != '%' &&
          lookahead != '{') ADVANCE(69);
      END_STATE();
    case 19:
      if (eof) ADVANCE(21);
      ADVANCE_MAP(
        '!', 8,
        '"', 42,
        '%', 57,
        '\'', 38,
        '(', 79,
        ')', 81,
        '*', 54,
        '+', 48,
        ',', 68,
        '-', 50,
        '.', 75,
        '/', 55,
        ':', 67,
        '<', 60,
        '=', 66,
        '>', 64,
        '[', 77,
        ']', 78,
        '^', 58,
        '{', 6,
        '|', 72,
        '}', 14,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(19);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(46);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(37);
      END_STATE();
    case 20:
      if (eof) ADVANCE(21);
      if (lookahead == '{') ADVANCE(7);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(23);
      if (lookahead != 0) ADVANCE(24);
      END_STATE();
    case 21:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 22:
      ACCEPT_TOKEN(aux_sym_template_content_token1);
      END_STATE();
    case 23:
      ACCEPT_TOKEN(aux_sym_template_content_token1);
      if (lookahead == '{') ADVANCE(7);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(23);
      if (lookahead != 0) ADVANCE(24);
      END_STATE();
    case 24:
      ACCEPT_TOKEN(aux_sym_template_content_token1);
      if (lookahead != 0 &&
          lookahead != '{') ADVANCE(24);
      END_STATE();
    case 25:
      ACCEPT_TOKEN(anon_sym_LBRACE_PERCENT_PERCENT);
      END_STATE();
    case 26:
      ACCEPT_TOKEN(anon_sym_LBRACE_LBRACE_LBRACE);
      END_STATE();
    case 27:
      ACCEPT_TOKEN(aux_sym__liquid_node_token1);
      if (lookahead == '\n') ADVANCE(27);
      if (lookahead == '\r') ADVANCE(27);
      END_STATE();
    case 28:
      ACCEPT_TOKEN(anon_sym_LBRACE_PERCENT);
      if (lookahead == '%') ADVANCE(25);
      if (lookahead == '-') ADVANCE(29);
      END_STATE();
    case 29:
      ACCEPT_TOKEN(anon_sym_LBRACE_PERCENT_DASH);
      END_STATE();
    case 30:
      ACCEPT_TOKEN(anon_sym_PERCENT_RBRACE);
      END_STATE();
    case 31:
      ACCEPT_TOKEN(anon_sym_DASH_PERCENT_RBRACE);
      END_STATE();
    case 32:
      ACCEPT_TOKEN(anon_sym_LBRACE_LBRACE);
      if (lookahead == '-') ADVANCE(34);
      END_STATE();
    case 33:
      ACCEPT_TOKEN(anon_sym_LBRACE_LBRACE);
      if (lookahead == '-') ADVANCE(34);
      if (lookahead == '{') ADVANCE(26);
      END_STATE();
    case 34:
      ACCEPT_TOKEN(anon_sym_LBRACE_LBRACE_DASH);
      END_STATE();
    case 35:
      ACCEPT_TOKEN(anon_sym_RBRACE_RBRACE);
      END_STATE();
    case 36:
      ACCEPT_TOKEN(anon_sym_DASH_RBRACE_RBRACE);
      END_STATE();
    case 37:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(37);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 39:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      if (lookahead == '{') ADVANCE(18);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ') ADVANCE(69);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(40);
      if (lookahead != 0 &&
          lookahead != '\'') ADVANCE(41);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead != 0 &&
          lookahead != '\'') ADVANCE(41);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      if (lookahead == '{') ADVANCE(18);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ') ADVANCE(69);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(aux_sym_string_token2);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(44);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(45);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(aux_sym_string_token2);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(45);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(17);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(46);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(sym_number);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(47);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '%') ADVANCE(15);
      if (lookahead == '.') ADVANCE(17);
      if (lookahead == '}') ADVANCE(16);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(46);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '%') ADVANCE(15);
      if (lookahead == '.') ADVANCE(17);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(46);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '%') ADVANCE(15);
      if (lookahead == '}') ADVANCE(16);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '.') ADVANCE(17);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(46);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(anon_sym_SLASH);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '}') ADVANCE(30);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '=') ADVANCE(61);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(63);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(59);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(aux_sym_include_statement_token1);
      if (lookahead == '{') ADVANCE(18);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ') ADVANCE(69);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_EQ2);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_EQ2);
      if (lookahead == '=') ADVANCE(59);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(80);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(80);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(47);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(47);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_DOT_DOT);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      ADVANCE_MAP(
        'a', 1,
        'b', 2,
        'c', 3,
        'd', 4,
        'e', 5,
        'f', 6,
        'i', 7,
        'j', 8,
        'l', 9,
        'n', 10,
        'o', 11,
        'p', 12,
        'r', 13,
        's', 14,
        't', 15,
        'u', 16,
        'w', 17,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(0);
      END_STATE();
    case 1:
      if (lookahead == 'n') ADVANCE(18);
      if (lookahead == 's') ADVANCE(19);
      END_STATE();
    case 2:
      if (lookahead == 'r') ADVANCE(20);
      if (lookahead == 'y') ADVANCE(21);
      END_STATE();
    case 3:
      if (lookahead == 'a') ADVANCE(22);
      if (lookahead == 'o') ADVANCE(23);
      if (lookahead == 'y') ADVANCE(24);
      END_STATE();
    case 4:
      if (lookahead == 'e') ADVANCE(25);
      END_STATE();
    case 5:
      if (lookahead == 'c') ADVANCE(26);
      if (lookahead == 'l') ADVANCE(27);
      if (lookahead == 'n') ADVANCE(28);
      END_STATE();
    case 6:
      if (lookahead == 'a') ADVANCE(29);
      if (lookahead == 'o') ADVANCE(30);
      END_STATE();
    case 7:
      if (lookahead == 'f') ADVANCE(31);
      if (lookahead == 'n') ADVANCE(32);
      END_STATE();
    case 8:
      if (lookahead == 'a') ADVANCE(33);
      END_STATE();
    case 9:
      if (lookahead == 'a') ADVANCE(34);
      if (lookahead == 'i') ADVANCE(35);
      END_STATE();
    case 10:
      if (lookahead == 'o') ADVANCE(36);
      END_STATE();
    case 11:
      if (lookahead == 'r') ADVANCE(37);
      END_STATE();
    case 12:
      if (lookahead == 'a') ADVANCE(38);
      END_STATE();
    case 13:
      if (lookahead == 'a') ADVANCE(39);
      if (lookahead == 'e') ADVANCE(40);
      END_STATE();
    case 14:
      if (lookahead == 'c') ADVANCE(41);
      if (lookahead == 'e') ADVANCE(42);
      if (lookahead == 't') ADVANCE(43);
      END_STATE();
    case 15:
      if (lookahead == 'a') ADVANCE(44);
      if (lookahead == 'r') ADVANCE(45);
      END_STATE();
    case 16:
      if (lookahead == 'n') ADVANCE(46);
      END_STATE();
    case 17:
      if (lookahead == 'h') ADVANCE(47);
      if (lookahead == 'i') ADVANCE(48);
      END_STATE();
    case 18:
      if (lookahead == 'd') ADVANCE(49);
      END_STATE();
    case 19:
      ACCEPT_TOKEN(anon_sym_as);
      if (lookahead == 's') ADVANCE(50);
      END_STATE();
    case 20:
      if (lookahead == 'e') ADVANCE(51);
      END_STATE();
    case 21:
      ACCEPT_TOKEN(anon_sym_by);
      END_STATE();
    case 22:
      if (lookahead == 'p') ADVANCE(52);
      if (lookahead == 's') ADVANCE(53);
      END_STATE();
    case 23:
      if (lookahead == 'm') ADVANCE(54);
      if (lookahead == 'n') ADVANCE(55);
      END_STATE();
    case 24:
      if (lookahead == 'c') ADVANCE(56);
      END_STATE();
    case 25:
      if (lookahead == 'c') ADVANCE(57);
      END_STATE();
    case 26:
      if (lookahead == 'h') ADVANCE(58);
      END_STATE();
    case 27:
      if (lookahead == 's') ADVANCE(59);
      END_STATE();
    case 28:
      if (lookahead == 'd') ADVANCE(60);
      END_STATE();
    case 29:
      if (lookahead == 'l') ADVANCE(61);
      END_STATE();
    case 30:
      if (lookahead == 'r') ADVANCE(62);
      END_STATE();
    case 31:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 32:
      ACCEPT_TOKEN(anon_sym_in);
      if (lookahead == 'c') ADVANCE(63);
      END_STATE();
    case 33:
      if (lookahead == 'v') ADVANCE(64);
      END_STATE();
    case 34:
      if (lookahead == 'y') ADVANCE(65);
      END_STATE();
    case 35:
      if (lookahead == 'q') ADVANCE(66);
      END_STATE();
    case 36:
      if (lookahead == 'n') ADVANCE(67);
      END_STATE();
    case 37:
      ACCEPT_TOKEN(anon_sym_or);
      END_STATE();
    case 38:
      if (lookahead == 'g') ADVANCE(68);
      END_STATE();
    case 39:
      if (lookahead == 'w') ADVANCE(69);
      END_STATE();
    case 40:
      if (lookahead == 'n') ADVANCE(70);
      END_STATE();
    case 41:
      if (lookahead == 'h') ADVANCE(71);
      END_STATE();
    case 42:
      if (lookahead == 'c') ADVANCE(72);
      END_STATE();
    case 43:
      if (lookahead == 'y') ADVANCE(73);
      END_STATE();
    case 44:
      if (lookahead == 'b') ADVANCE(74);
      END_STATE();
    case 45:
      if (lookahead == 'u') ADVANCE(75);
      END_STATE();
    case 46:
      if (lookahead == 'l') ADVANCE(76);
      END_STATE();
    case 47:
      if (lookahead == 'e') ADVANCE(77);
      END_STATE();
    case 48:
      if (lookahead == 't') ADVANCE(78);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(anon_sym_and);
      END_STATE();
    case 50:
      if (lookahead == 'i') ADVANCE(79);
      END_STATE();
    case 51:
      if (lookahead == 'a') ADVANCE(80);
      END_STATE();
    case 52:
      if (lookahead == 't') ADVANCE(81);
      END_STATE();
    case 53:
      if (lookahead == 'e') ADVANCE(82);
      END_STATE();
    case 54:
      if (lookahead == 'm') ADVANCE(83);
      END_STATE();
    case 55:
      if (lookahead == 't') ADVANCE(84);
      END_STATE();
    case 56:
      if (lookahead == 'l') ADVANCE(85);
      END_STATE();
    case 57:
      if (lookahead == 'r') ADVANCE(86);
      END_STATE();
    case 58:
      if (lookahead == 'o') ADVANCE(87);
      END_STATE();
    case 59:
      if (lookahead == 'e') ADVANCE(88);
      if (lookahead == 'i') ADVANCE(89);
      END_STATE();
    case 60:
      ADVANCE_MAP(
        'c', 90,
        'f', 91,
        'i', 92,
        'j', 93,
        'p', 94,
        'r', 95,
        's', 96,
        't', 97,
        'u', 98,
      );
      END_STATE();
    case 61:
      if (lookahead == 's') ADVANCE(99);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(anon_sym_for);
      if (lookahead == 'm') ADVANCE(100);
      END_STATE();
    case 63:
      if (lookahead == 'l') ADVANCE(101);
      if (lookahead == 'r') ADVANCE(102);
      END_STATE();
    case 64:
      if (lookahead == 'a') ADVANCE(103);
      END_STATE();
    case 65:
      if (lookahead == 'o') ADVANCE(104);
      END_STATE();
    case 66:
      if (lookahead == 'u') ADVANCE(105);
      END_STATE();
    case 67:
      if (lookahead == 'e') ADVANCE(106);
      END_STATE();
    case 68:
      if (lookahead == 'i') ADVANCE(107);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_raw);
      END_STATE();
    case 70:
      if (lookahead == 'd') ADVANCE(108);
      END_STATE();
    case 71:
      if (lookahead == 'e') ADVANCE(109);
      END_STATE();
    case 72:
      if (lookahead == 't') ADVANCE(110);
      END_STATE();
    case 73:
      if (lookahead == 'l') ADVANCE(111);
      END_STATE();
    case 74:
      if (lookahead == 'l') ADVANCE(112);
      END_STATE();
    case 75:
      if (lookahead == 'e') ADVANCE(113);
      END_STATE();
    case 76:
      if (lookahead == 'e') ADVANCE(114);
      END_STATE();
    case 77:
      if (lookahead == 'n') ADVANCE(115);
      END_STATE();
    case 78:
      if (lookahead == 'h') ADVANCE(116);
      END_STATE();
    case 79:
      if (lookahead == 'g') ADVANCE(117);
      END_STATE();
    case 80:
      if (lookahead == 'k') ADVANCE(118);
      END_STATE();
    case 81:
      if (lookahead == 'u') ADVANCE(119);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_case);
      END_STATE();
    case 83:
      if (lookahead == 'e') ADVANCE(120);
      END_STATE();
    case 84:
      if (lookahead == 'a') ADVANCE(121);
      if (lookahead == 'i') ADVANCE(122);
      END_STATE();
    case 85:
      if (lookahead == 'e') ADVANCE(123);
      END_STATE();
    case 86:
      if (lookahead == 'e') ADVANCE(124);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_echo);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 89:
      if (lookahead == 'f') ADVANCE(125);
      END_STATE();
    case 90:
      if (lookahead == 'a') ADVANCE(126);
      if (lookahead == 'o') ADVANCE(127);
      END_STATE();
    case 91:
      if (lookahead == 'o') ADVANCE(128);
      END_STATE();
    case 92:
      if (lookahead == 'f') ADVANCE(129);
      END_STATE();
    case 93:
      if (lookahead == 'a') ADVANCE(130);
      END_STATE();
    case 94:
      if (lookahead == 'a') ADVANCE(131);
      END_STATE();
    case 95:
      if (lookahead == 'a') ADVANCE(132);
      END_STATE();
    case 96:
      if (lookahead == 'c') ADVANCE(133);
      if (lookahead == 't') ADVANCE(134);
      END_STATE();
    case 97:
      if (lookahead == 'a') ADVANCE(135);
      END_STATE();
    case 98:
      if (lookahead == 'n') ADVANCE(136);
      END_STATE();
    case 99:
      if (lookahead == 'e') ADVANCE(137);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_form);
      END_STATE();
    case 101:
      if (lookahead == 'u') ADVANCE(138);
      END_STATE();
    case 102:
      if (lookahead == 'e') ADVANCE(139);
      END_STATE();
    case 103:
      if (lookahead == 's') ADVANCE(140);
      END_STATE();
    case 104:
      if (lookahead == 'u') ADVANCE(141);
      END_STATE();
    case 105:
      if (lookahead == 'i') ADVANCE(142);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_none);
      END_STATE();
    case 107:
      if (lookahead == 'n') ADVANCE(143);
      END_STATE();
    case 108:
      if (lookahead == 'e') ADVANCE(144);
      END_STATE();
    case 109:
      if (lookahead == 'm') ADVANCE(145);
      END_STATE();
    case 110:
      if (lookahead == 'i') ADVANCE(146);
      END_STATE();
    case 111:
      if (lookahead == 'e') ADVANCE(147);
      END_STATE();
    case 112:
      if (lookahead == 'e') ADVANCE(148);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_true);
      END_STATE();
    case 114:
      if (lookahead == 's') ADVANCE(149);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_when);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_with);
      END_STATE();
    case 117:
      if (lookahead == 'n') ADVANCE(150);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(sym_break_statement);
      END_STATE();
    case 119:
      if (lookahead == 'r') ADVANCE(151);
      END_STATE();
    case 120:
      if (lookahead == 'n') ADVANCE(152);
      END_STATE();
    case 121:
      if (lookahead == 'i') ADVANCE(153);
      END_STATE();
    case 122:
      if (lookahead == 'n') ADVANCE(154);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_cycle);
      END_STATE();
    case 124:
      if (lookahead == 'm') ADVANCE(155);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_elsif);
      END_STATE();
    case 126:
      if (lookahead == 'p') ADVANCE(156);
      if (lookahead == 's') ADVANCE(157);
      END_STATE();
    case 127:
      if (lookahead == 'm') ADVANCE(158);
      END_STATE();
    case 128:
      if (lookahead == 'r') ADVANCE(159);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_endif);
      END_STATE();
    case 130:
      if (lookahead == 'v') ADVANCE(160);
      END_STATE();
    case 131:
      if (lookahead == 'g') ADVANCE(161);
      END_STATE();
    case 132:
      if (lookahead == 'w') ADVANCE(162);
      END_STATE();
    case 133:
      if (lookahead == 'h') ADVANCE(163);
      END_STATE();
    case 134:
      if (lookahead == 'y') ADVANCE(164);
      END_STATE();
    case 135:
      if (lookahead == 'b') ADVANCE(165);
      END_STATE();
    case 136:
      if (lookahead == 'l') ADVANCE(166);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_false);
      END_STATE();
    case 138:
      if (lookahead == 'd') ADVANCE(167);
      END_STATE();
    case 139:
      if (lookahead == 'm') ADVANCE(168);
      END_STATE();
    case 140:
      if (lookahead == 'c') ADVANCE(169);
      END_STATE();
    case 141:
      if (lookahead == 't') ADVANCE(170);
      END_STATE();
    case 142:
      if (lookahead == 'd') ADVANCE(171);
      END_STATE();
    case 143:
      if (lookahead == 'a') ADVANCE(172);
      END_STATE();
    case 144:
      if (lookahead == 'r') ADVANCE(173);
      END_STATE();
    case 145:
      if (lookahead == 'a') ADVANCE(174);
      END_STATE();
    case 146:
      if (lookahead == 'o') ADVANCE(175);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(anon_sym_style);
      END_STATE();
    case 148:
      if (lookahead == 'r') ADVANCE(176);
      END_STATE();
    case 149:
      if (lookahead == 's') ADVANCE(177);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(anon_sym_assign);
      END_STATE();
    case 151:
      if (lookahead == 'e') ADVANCE(178);
      END_STATE();
    case 152:
      if (lookahead == 't') ADVANCE(179);
      END_STATE();
    case 153:
      if (lookahead == 'n') ADVANCE(180);
      END_STATE();
    case 154:
      if (lookahead == 'u') ADVANCE(181);
      END_STATE();
    case 155:
      if (lookahead == 'e') ADVANCE(182);
      END_STATE();
    case 156:
      if (lookahead == 't') ADVANCE(183);
      END_STATE();
    case 157:
      if (lookahead == 'e') ADVANCE(184);
      END_STATE();
    case 158:
      if (lookahead == 'm') ADVANCE(185);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(anon_sym_endfor);
      if (lookahead == 'm') ADVANCE(186);
      END_STATE();
    case 160:
      if (lookahead == 'a') ADVANCE(187);
      END_STATE();
    case 161:
      if (lookahead == 'i') ADVANCE(188);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_endraw);
      END_STATE();
    case 163:
      if (lookahead == 'e') ADVANCE(189);
      END_STATE();
    case 164:
      if (lookahead == 'l') ADVANCE(190);
      END_STATE();
    case 165:
      if (lookahead == 'l') ADVANCE(191);
      END_STATE();
    case 166:
      if (lookahead == 'e') ADVANCE(192);
      END_STATE();
    case 167:
      if (lookahead == 'e') ADVANCE(193);
      END_STATE();
    case 168:
      if (lookahead == 'e') ADVANCE(194);
      END_STATE();
    case 169:
      if (lookahead == 'r') ADVANCE(195);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(anon_sym_layout);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(anon_sym_liquid);
      END_STATE();
    case 172:
      if (lookahead == 't') ADVANCE(196);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(anon_sym_render);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(anon_sym_schema);
      END_STATE();
    case 175:
      if (lookahead == 'n') ADVANCE(197);
      END_STATE();
    case 176:
      if (lookahead == 'o') ADVANCE(198);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(anon_sym_unless);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(anon_sym_capture);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(anon_sym_comment);
      END_STATE();
    case 180:
      if (lookahead == 's') ADVANCE(199);
      END_STATE();
    case 181:
      if (lookahead == 'e') ADVANCE(200);
      END_STATE();
    case 182:
      if (lookahead == 'n') ADVANCE(201);
      END_STATE();
    case 183:
      if (lookahead == 'u') ADVANCE(202);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(anon_sym_endcase);
      END_STATE();
    case 185:
      if (lookahead == 'e') ADVANCE(203);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(anon_sym_endform);
      END_STATE();
    case 187:
      if (lookahead == 's') ADVANCE(204);
      END_STATE();
    case 188:
      if (lookahead == 'n') ADVANCE(205);
      END_STATE();
    case 189:
      if (lookahead == 'm') ADVANCE(206);
      END_STATE();
    case 190:
      if (lookahead == 'e') ADVANCE(207);
      END_STATE();
    case 191:
      if (lookahead == 'e') ADVANCE(208);
      END_STATE();
    case 192:
      if (lookahead == 's') ADVANCE(209);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(anon_sym_include);
      if (lookahead == '_') ADVANCE(210);
      END_STATE();
    case 194:
      if (lookahead == 'n') ADVANCE(211);
      END_STATE();
    case 195:
      if (lookahead == 'i') ADVANCE(212);
      END_STATE();
    case 196:
      if (lookahead == 'e') ADVANCE(213);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(anon_sym_section);
      if (lookahead == 's') ADVANCE(214);
      END_STATE();
    case 198:
      if (lookahead == 'w') ADVANCE(215);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(anon_sym_contains);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(sym_continue_statement);
      END_STATE();
    case 201:
      if (lookahead == 't') ADVANCE(216);
      END_STATE();
    case 202:
      if (lookahead == 'r') ADVANCE(217);
      END_STATE();
    case 203:
      if (lookahead == 'n') ADVANCE(218);
      END_STATE();
    case 204:
      if (lookahead == 'c') ADVANCE(219);
      END_STATE();
    case 205:
      if (lookahead == 'a') ADVANCE(220);
      END_STATE();
    case 206:
      if (lookahead == 'a') ADVANCE(221);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(anon_sym_endstyle);
      END_STATE();
    case 208:
      if (lookahead == 'r') ADVANCE(222);
      END_STATE();
    case 209:
      if (lookahead == 's') ADVANCE(223);
      END_STATE();
    case 210:
      if (lookahead == 'r') ADVANCE(224);
      END_STATE();
    case 211:
      if (lookahead == 't') ADVANCE(225);
      END_STATE();
    case 212:
      if (lookahead == 'p') ADVANCE(226);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(anon_sym_paginate);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(anon_sym_sections);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(anon_sym_tablerow);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(anon_sym_decrement);
      END_STATE();
    case 217:
      if (lookahead == 'e') ADVANCE(227);
      END_STATE();
    case 218:
      if (lookahead == 't') ADVANCE(228);
      END_STATE();
    case 219:
      if (lookahead == 'r') ADVANCE(229);
      END_STATE();
    case 220:
      if (lookahead == 't') ADVANCE(230);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(anon_sym_endschema);
      END_STATE();
    case 222:
      if (lookahead == 'o') ADVANCE(231);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(anon_sym_endunless);
      END_STATE();
    case 224:
      if (lookahead == 'e') ADVANCE(232);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(anon_sym_increment);
      END_STATE();
    case 226:
      if (lookahead == 't') ADVANCE(233);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(anon_sym_endcapture);
      END_STATE();
    case 228:
      ACCEPT_TOKEN(anon_sym_endcomment);
      END_STATE();
    case 229:
      if (lookahead == 'i') ADVANCE(234);
      END_STATE();
    case 230:
      if (lookahead == 'e') ADVANCE(235);
      END_STATE();
    case 231:
      if (lookahead == 'w') ADVANCE(236);
      END_STATE();
    case 232:
      if (lookahead == 'l') ADVANCE(237);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(anon_sym_javascript);
      END_STATE();
    case 234:
      if (lookahead == 'p') ADVANCE(238);
      END_STATE();
    case 235:
      ACCEPT_TOKEN(anon_sym_endpaginate);
      END_STATE();
    case 236:
      ACCEPT_TOKEN(anon_sym_endtablerow);
      END_STATE();
    case 237:
      if (lookahead == 'a') ADVANCE(239);
      END_STATE();
    case 238:
      if (lookahead == 't') ADVANCE(240);
      END_STATE();
    case 239:
      if (lookahead == 't') ADVANCE(241);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(anon_sym_endjavascript);
      END_STATE();
    case 241:
      if (lookahead == 'i') ADVANCE(242);
      END_STATE();
    case 242:
      if (lookahead == 'v') ADVANCE(243);
      END_STATE();
    case 243:
      if (lookahead == 'e') ADVANCE(244);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(anon_sym_include_relative);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 20, .external_lex_state = 2},
  [2] = {.lex_state = 3},
  [3] = {.lex_state = 3},
  [4] = {.lex_state = 3},
  [5] = {.lex_state = 3},
  [6] = {.lex_state = 3},
  [7] = {.lex_state = 3},
  [8] = {.lex_state = 3},
  [9] = {.lex_state = 3, .external_lex_state = 3},
  [10] = {.lex_state = 3, .external_lex_state = 3},
  [11] = {.lex_state = 3, .external_lex_state = 3},
  [12] = {.lex_state = 3},
  [13] = {.lex_state = 3},
  [14] = {.lex_state = 3},
  [15] = {.lex_state = 3},
  [16] = {.lex_state = 3},
  [17] = {.lex_state = 3},
  [18] = {.lex_state = 3},
  [19] = {.lex_state = 3},
  [20] = {.lex_state = 3},
  [21] = {.lex_state = 3},
  [22] = {.lex_state = 3},
  [23] = {.lex_state = 3},
  [24] = {.lex_state = 3},
  [25] = {.lex_state = 3},
  [26] = {.lex_state = 3},
  [27] = {.lex_state = 3},
  [28] = {.lex_state = 3},
  [29] = {.lex_state = 3},
  [30] = {.lex_state = 3},
  [31] = {.lex_state = 3},
  [32] = {.lex_state = 3},
  [33] = {.lex_state = 3},
  [34] = {.lex_state = 3},
  [35] = {.lex_state = 3},
  [36] = {.lex_state = 3},
  [37] = {.lex_state = 3},
  [38] = {.lex_state = 3},
  [39] = {.lex_state = 3},
  [40] = {.lex_state = 3},
  [41] = {.lex_state = 3},
  [42] = {.lex_state = 3},
  [43] = {.lex_state = 3},
  [44] = {.lex_state = 3},
  [45] = {.lex_state = 3},
  [46] = {.lex_state = 3},
  [47] = {.lex_state = 3},
  [48] = {.lex_state = 3},
  [49] = {.lex_state = 3},
  [50] = {.lex_state = 3},
  [51] = {.lex_state = 3},
  [52] = {.lex_state = 3},
  [53] = {.lex_state = 3},
  [54] = {.lex_state = 3},
  [55] = {.lex_state = 3},
  [56] = {.lex_state = 3},
  [57] = {.lex_state = 0, .external_lex_state = 3},
  [58] = {.lex_state = 0, .external_lex_state = 3},
  [59] = {.lex_state = 0, .external_lex_state = 3},
  [60] = {.lex_state = 0, .external_lex_state = 3},
  [61] = {.lex_state = 0, .external_lex_state = 3},
  [62] = {.lex_state = 0, .external_lex_state = 3},
  [63] = {.lex_state = 0, .external_lex_state = 3},
  [64] = {.lex_state = 0, .external_lex_state = 3},
  [65] = {.lex_state = 0, .external_lex_state = 3},
  [66] = {.lex_state = 0, .external_lex_state = 3},
  [67] = {.lex_state = 0, .external_lex_state = 3},
  [68] = {.lex_state = 0, .external_lex_state = 3},
  [69] = {.lex_state = 0, .external_lex_state = 3},
  [70] = {.lex_state = 0, .external_lex_state = 3},
  [71] = {.lex_state = 0, .external_lex_state = 3},
  [72] = {.lex_state = 0, .external_lex_state = 3},
  [73] = {.lex_state = 0, .external_lex_state = 3},
  [74] = {.lex_state = 0, .external_lex_state = 3},
  [75] = {.lex_state = 0, .external_lex_state = 3},
  [76] = {.lex_state = 0, .external_lex_state = 3},
  [77] = {.lex_state = 0, .external_lex_state = 3},
  [78] = {.lex_state = 0, .external_lex_state = 3},
  [79] = {.lex_state = 0, .external_lex_state = 3},
  [80] = {.lex_state = 0, .external_lex_state = 3},
  [81] = {.lex_state = 0, .external_lex_state = 3},
  [82] = {.lex_state = 0, .external_lex_state = 3},
  [83] = {.lex_state = 0, .external_lex_state = 3},
  [84] = {.lex_state = 0, .external_lex_state = 3},
  [85] = {.lex_state = 0, .external_lex_state = 3},
  [86] = {.lex_state = 0, .external_lex_state = 3},
  [87] = {.lex_state = 0, .external_lex_state = 3},
  [88] = {.lex_state = 0, .external_lex_state = 3},
  [89] = {.lex_state = 0, .external_lex_state = 3},
  [90] = {.lex_state = 0, .external_lex_state = 3},
  [91] = {.lex_state = 0, .external_lex_state = 3},
  [92] = {.lex_state = 0, .external_lex_state = 3},
  [93] = {.lex_state = 0, .external_lex_state = 3},
  [94] = {.lex_state = 0, .external_lex_state = 3},
  [95] = {.lex_state = 0, .external_lex_state = 3},
  [96] = {.lex_state = 0, .external_lex_state = 3},
  [97] = {.lex_state = 0, .external_lex_state = 3},
  [98] = {.lex_state = 0, .external_lex_state = 3},
  [99] = {.lex_state = 0, .external_lex_state = 3},
  [100] = {.lex_state = 0, .external_lex_state = 3},
  [101] = {.lex_state = 0, .external_lex_state = 3},
  [102] = {.lex_state = 0, .external_lex_state = 3},
  [103] = {.lex_state = 0, .external_lex_state = 3},
  [104] = {.lex_state = 0, .external_lex_state = 3},
  [105] = {.lex_state = 0, .external_lex_state = 3},
  [106] = {.lex_state = 0, .external_lex_state = 3},
  [107] = {.lex_state = 0, .external_lex_state = 3},
  [108] = {.lex_state = 0, .external_lex_state = 3},
  [109] = {.lex_state = 0, .external_lex_state = 3},
  [110] = {.lex_state = 0, .external_lex_state = 3},
  [111] = {.lex_state = 0, .external_lex_state = 3},
  [112] = {.lex_state = 0, .external_lex_state = 3},
  [113] = {.lex_state = 0, .external_lex_state = 3},
  [114] = {.lex_state = 0, .external_lex_state = 3},
  [115] = {.lex_state = 0, .external_lex_state = 3},
  [116] = {.lex_state = 0, .external_lex_state = 3},
  [117] = {.lex_state = 0, .external_lex_state = 3},
  [118] = {.lex_state = 0, .external_lex_state = 3},
  [119] = {.lex_state = 0, .external_lex_state = 3},
  [120] = {.lex_state = 0, .external_lex_state = 3},
  [121] = {.lex_state = 0, .external_lex_state = 3},
  [122] = {.lex_state = 0, .external_lex_state = 3},
  [123] = {.lex_state = 0, .external_lex_state = 3},
  [124] = {.lex_state = 0, .external_lex_state = 3},
  [125] = {.lex_state = 0, .external_lex_state = 3},
  [126] = {.lex_state = 0, .external_lex_state = 3},
  [127] = {.lex_state = 0, .external_lex_state = 3},
  [128] = {.lex_state = 0, .external_lex_state = 3},
  [129] = {.lex_state = 0, .external_lex_state = 3},
  [130] = {.lex_state = 0, .external_lex_state = 3},
  [131] = {.lex_state = 0, .external_lex_state = 3},
  [132] = {.lex_state = 0, .external_lex_state = 3},
  [133] = {.lex_state = 0, .external_lex_state = 3},
  [134] = {.lex_state = 0, .external_lex_state = 3},
  [135] = {.lex_state = 3},
  [136] = {.lex_state = 3},
  [137] = {.lex_state = 3},
  [138] = {.lex_state = 3},
  [139] = {.lex_state = 1},
  [140] = {.lex_state = 3},
  [141] = {.lex_state = 3},
  [142] = {.lex_state = 3},
  [143] = {.lex_state = 20},
  [144] = {.lex_state = 3, .external_lex_state = 3},
  [145] = {.lex_state = 20},
  [146] = {.lex_state = 20},
  [147] = {.lex_state = 3, .external_lex_state = 3},
  [148] = {.lex_state = 20},
  [149] = {.lex_state = 20},
  [150] = {.lex_state = 20},
  [151] = {.lex_state = 3, .external_lex_state = 3},
  [152] = {.lex_state = 20},
  [153] = {.lex_state = 3},
  [154] = {.lex_state = 20},
  [155] = {.lex_state = 3, .external_lex_state = 3},
  [156] = {.lex_state = 3},
  [157] = {.lex_state = 20},
  [158] = {.lex_state = 20},
  [159] = {.lex_state = 20},
  [160] = {.lex_state = 20},
  [161] = {.lex_state = 20},
  [162] = {.lex_state = 3},
  [163] = {.lex_state = 20},
  [164] = {.lex_state = 20},
  [165] = {.lex_state = 20},
  [166] = {.lex_state = 20},
  [167] = {.lex_state = 20},
  [168] = {.lex_state = 20},
  [169] = {.lex_state = 20},
  [170] = {.lex_state = 20},
  [171] = {.lex_state = 1},
  [172] = {.lex_state = 20},
  [173] = {.lex_state = 20},
  [174] = {.lex_state = 20},
  [175] = {.lex_state = 20},
  [176] = {.lex_state = 20},
  [177] = {.lex_state = 4},
  [178] = {.lex_state = 20},
  [179] = {.lex_state = 20},
  [180] = {.lex_state = 20},
  [181] = {.lex_state = 20},
  [182] = {.lex_state = 20},
  [183] = {.lex_state = 20},
  [184] = {.lex_state = 20},
  [185] = {.lex_state = 20},
  [186] = {.lex_state = 20},
  [187] = {.lex_state = 20},
  [188] = {.lex_state = 20},
  [189] = {.lex_state = 20},
  [190] = {.lex_state = 20},
  [191] = {.lex_state = 20},
  [192] = {.lex_state = 20},
  [193] = {.lex_state = 20},
  [194] = {.lex_state = 20},
  [195] = {.lex_state = 20},
  [196] = {.lex_state = 20},
  [197] = {.lex_state = 20},
  [198] = {.lex_state = 20},
  [199] = {.lex_state = 20},
  [200] = {.lex_state = 20},
  [201] = {.lex_state = 20},
  [202] = {.lex_state = 20},
  [203] = {.lex_state = 4},
  [204] = {.lex_state = 20},
  [205] = {.lex_state = 20},
  [206] = {.lex_state = 20},
  [207] = {.lex_state = 20},
  [208] = {.lex_state = 1},
  [209] = {.lex_state = 20},
  [210] = {.lex_state = 1},
  [211] = {.lex_state = 20},
  [212] = {.lex_state = 20},
  [213] = {.lex_state = 20},
  [214] = {.lex_state = 20},
  [215] = {.lex_state = 20},
  [216] = {.lex_state = 20},
  [217] = {.lex_state = 20},
  [218] = {.lex_state = 20},
  [219] = {.lex_state = 20},
  [220] = {.lex_state = 1},
  [221] = {.lex_state = 1},
  [222] = {.lex_state = 1},
  [223] = {.lex_state = 1},
  [224] = {.lex_state = 1},
  [225] = {.lex_state = 1},
  [226] = {.lex_state = 1},
  [227] = {.lex_state = 1},
  [228] = {.lex_state = 4},
  [229] = {.lex_state = 3},
  [230] = {.lex_state = 1},
  [231] = {.lex_state = 4},
  [232] = {.lex_state = 1},
  [233] = {.lex_state = 1},
  [234] = {.lex_state = 1},
  [235] = {.lex_state = 1},
  [236] = {.lex_state = 1},
  [237] = {.lex_state = 1},
  [238] = {.lex_state = 1},
  [239] = {.lex_state = 4},
  [240] = {.lex_state = 1},
  [241] = {.lex_state = 1},
  [242] = {.lex_state = 4},
  [243] = {.lex_state = 1},
  [244] = {.lex_state = 1},
  [245] = {.lex_state = 1},
  [246] = {.lex_state = 1},
  [247] = {.lex_state = 4},
  [248] = {.lex_state = 4},
  [249] = {.lex_state = 4},
  [250] = {.lex_state = 4},
  [251] = {.lex_state = 4},
  [252] = {.lex_state = 4},
  [253] = {.lex_state = 4},
  [254] = {.lex_state = 2},
  [255] = {.lex_state = 4},
  [256] = {.lex_state = 4},
  [257] = {.lex_state = 2},
  [258] = {.lex_state = 2},
  [259] = {.lex_state = 4},
  [260] = {.lex_state = 4},
  [261] = {.lex_state = 4},
  [262] = {.lex_state = 2},
  [263] = {.lex_state = 2},
  [264] = {.lex_state = 4},
  [265] = {.lex_state = 2},
  [266] = {.lex_state = 2},
  [267] = {.lex_state = 4},
  [268] = {.lex_state = 4},
  [269] = {.lex_state = 4},
  [270] = {.lex_state = 4},
  [271] = {.lex_state = 4},
  [272] = {.lex_state = 4},
  [273] = {.lex_state = 2},
  [274] = {.lex_state = 4},
  [275] = {.lex_state = 2},
  [276] = {.lex_state = 2},
  [277] = {.lex_state = 2},
  [278] = {.lex_state = 2},
  [279] = {.lex_state = 4},
  [280] = {.lex_state = 2},
  [281] = {.lex_state = 2},
  [282] = {.lex_state = 2},
  [283] = {.lex_state = 2},
  [284] = {.lex_state = 4},
  [285] = {.lex_state = 4},
  [286] = {.lex_state = 4},
  [287] = {.lex_state = 3},
  [288] = {.lex_state = 3},
  [289] = {.lex_state = 2},
  [290] = {.lex_state = 4},
  [291] = {.lex_state = 4},
  [292] = {.lex_state = 4},
  [293] = {.lex_state = 2},
  [294] = {.lex_state = 4},
  [295] = {.lex_state = 2},
  [296] = {.lex_state = 4},
  [297] = {.lex_state = 4},
  [298] = {.lex_state = 4},
  [299] = {.lex_state = 2},
  [300] = {.lex_state = 4},
  [301] = {.lex_state = 2},
  [302] = {.lex_state = 2},
  [303] = {.lex_state = 4},
  [304] = {.lex_state = 3},
  [305] = {.lex_state = 4},
  [306] = {.lex_state = 4},
  [307] = {.lex_state = 2},
  [308] = {.lex_state = 4},
  [309] = {.lex_state = 4},
  [310] = {.lex_state = 4},
  [311] = {.lex_state = 2},
  [312] = {.lex_state = 2},
  [313] = {.lex_state = 2},
  [314] = {.lex_state = 1},
  [315] = {.lex_state = 3},
  [316] = {.lex_state = 2},
  [317] = {.lex_state = 2},
  [318] = {.lex_state = 2},
  [319] = {.lex_state = 3},
  [320] = {.lex_state = 1},
  [321] = {.lex_state = 0},
  [322] = {.lex_state = 4},
  [323] = {.lex_state = 4},
  [324] = {.lex_state = 3},
  [325] = {.lex_state = 3},
  [326] = {.lex_state = 3},
  [327] = {.lex_state = 3},
  [328] = {.lex_state = 3},
  [329] = {.lex_state = 3},
  [330] = {.lex_state = 3},
  [331] = {.lex_state = 3},
  [332] = {.lex_state = 3},
  [333] = {.lex_state = 3},
  [334] = {.lex_state = 3},
  [335] = {.lex_state = 3},
  [336] = {.lex_state = 3},
  [337] = {.lex_state = 3},
  [338] = {.lex_state = 3},
  [339] = {.lex_state = 3},
  [340] = {.lex_state = 3},
  [341] = {.lex_state = 3},
  [342] = {.lex_state = 3},
  [343] = {.lex_state = 3},
  [344] = {.lex_state = 3},
  [345] = {.lex_state = 3},
  [346] = {.lex_state = 3},
  [347] = {.lex_state = 3},
  [348] = {.lex_state = 3},
  [349] = {.lex_state = 3},
  [350] = {.lex_state = 3},
  [351] = {.lex_state = 3},
  [352] = {.lex_state = 3},
  [353] = {.lex_state = 3},
  [354] = {.lex_state = 3},
  [355] = {.lex_state = 3},
  [356] = {.lex_state = 3},
  [357] = {.lex_state = 3},
  [358] = {.lex_state = 3},
  [359] = {.lex_state = 3},
  [360] = {.lex_state = 3},
  [361] = {.lex_state = 3},
  [362] = {.lex_state = 3},
  [363] = {.lex_state = 3},
  [364] = {.lex_state = 3},
  [365] = {.lex_state = 3},
  [366] = {.lex_state = 3},
  [367] = {.lex_state = 3},
  [368] = {.lex_state = 3},
  [369] = {.lex_state = 3},
  [370] = {.lex_state = 0},
  [371] = {.lex_state = 0},
  [372] = {.lex_state = 0},
  [373] = {.lex_state = 0},
  [374] = {.lex_state = 0},
  [375] = {.lex_state = 0},
  [376] = {.lex_state = 0},
  [377] = {.lex_state = 0},
  [378] = {.lex_state = 0},
  [379] = {.lex_state = 0},
  [380] = {.lex_state = 0},
  [381] = {.lex_state = 0},
  [382] = {.lex_state = 0},
  [383] = {.lex_state = 0},
  [384] = {.lex_state = 0},
  [385] = {.lex_state = 0},
  [386] = {.lex_state = 0},
  [387] = {.lex_state = 0},
  [388] = {.lex_state = 0},
  [389] = {.lex_state = 0},
  [390] = {.lex_state = 0},
  [391] = {.lex_state = 0},
  [392] = {.lex_state = 0},
  [393] = {.lex_state = 20},
  [394] = {.lex_state = 20},
  [395] = {.lex_state = 20},
  [396] = {.lex_state = 20},
  [397] = {.lex_state = 0},
  [398] = {.lex_state = 0},
  [399] = {.lex_state = 0},
  [400] = {.lex_state = 0},
  [401] = {.lex_state = 0},
  [402] = {.lex_state = 20},
  [403] = {.lex_state = 20},
  [404] = {.lex_state = 20},
  [405] = {.lex_state = 20},
  [406] = {.lex_state = 20},
  [407] = {.lex_state = 20},
  [408] = {.lex_state = 20},
  [409] = {.lex_state = 20},
  [410] = {.lex_state = 20},
  [411] = {.lex_state = 20},
  [412] = {.lex_state = 20},
  [413] = {.lex_state = 20},
  [414] = {.lex_state = 20},
  [415] = {.lex_state = 20},
  [416] = {.lex_state = 20},
  [417] = {.lex_state = 20},
  [418] = {.lex_state = 20},
  [419] = {.lex_state = 20},
  [420] = {.lex_state = 20},
  [421] = {.lex_state = 20},
  [422] = {.lex_state = 20},
  [423] = {.lex_state = 20},
  [424] = {.lex_state = 20},
  [425] = {.lex_state = 20},
  [426] = {.lex_state = 20},
  [427] = {.lex_state = 20},
  [428] = {.lex_state = 20},
  [429] = {.lex_state = 20},
  [430] = {.lex_state = 20},
  [431] = {.lex_state = 20},
  [432] = {.lex_state = 20},
  [433] = {.lex_state = 20},
  [434] = {.lex_state = 20},
  [435] = {.lex_state = 20},
  [436] = {.lex_state = 20},
  [437] = {.lex_state = 20},
  [438] = {.lex_state = 20},
  [439] = {.lex_state = 20},
  [440] = {.lex_state = 20},
  [441] = {.lex_state = 20},
  [442] = {.lex_state = 20},
  [443] = {.lex_state = 20},
  [444] = {.lex_state = 20},
  [445] = {.lex_state = 20},
  [446] = {.lex_state = 20},
  [447] = {.lex_state = 20},
  [448] = {.lex_state = 20},
  [449] = {.lex_state = 20},
  [450] = {.lex_state = 20},
  [451] = {.lex_state = 20},
  [452] = {.lex_state = 20},
  [453] = {.lex_state = 20},
  [454] = {.lex_state = 20},
  [455] = {.lex_state = 20},
  [456] = {.lex_state = 20},
  [457] = {.lex_state = 20},
  [458] = {.lex_state = 20},
  [459] = {.lex_state = 20},
  [460] = {.lex_state = 20},
  [461] = {.lex_state = 20},
  [462] = {.lex_state = 20},
  [463] = {.lex_state = 20},
  [464] = {.lex_state = 20},
  [465] = {.lex_state = 20},
  [466] = {.lex_state = 20},
  [467] = {.lex_state = 20},
  [468] = {.lex_state = 20},
  [469] = {.lex_state = 20},
  [470] = {.lex_state = 20},
  [471] = {.lex_state = 20},
  [472] = {.lex_state = 20},
  [473] = {.lex_state = 20},
  [474] = {.lex_state = 20},
  [475] = {.lex_state = 20},
  [476] = {.lex_state = 20},
  [477] = {.lex_state = 20},
  [478] = {.lex_state = 20},
  [479] = {.lex_state = 20},
  [480] = {.lex_state = 20},
  [481] = {.lex_state = 20},
  [482] = {.lex_state = 20},
  [483] = {.lex_state = 20},
  [484] = {.lex_state = 20},
  [485] = {.lex_state = 20},
  [486] = {.lex_state = 20},
  [487] = {.lex_state = 20},
  [488] = {.lex_state = 20},
  [489] = {.lex_state = 20},
  [490] = {.lex_state = 20},
  [491] = {.lex_state = 20},
  [492] = {.lex_state = 20},
  [493] = {.lex_state = 20},
  [494] = {.lex_state = 20},
  [495] = {.lex_state = 20},
  [496] = {.lex_state = 20},
  [497] = {.lex_state = 20},
  [498] = {.lex_state = 20},
  [499] = {.lex_state = 20},
  [500] = {.lex_state = 20},
  [501] = {.lex_state = 20},
  [502] = {.lex_state = 20},
  [503] = {.lex_state = 20},
  [504] = {.lex_state = 20},
  [505] = {.lex_state = 20},
  [506] = {.lex_state = 20},
  [507] = {.lex_state = 20},
  [508] = {.lex_state = 20},
  [509] = {.lex_state = 20},
  [510] = {.lex_state = 20},
  [511] = {.lex_state = 20},
  [512] = {.lex_state = 20},
  [513] = {.lex_state = 20},
  [514] = {.lex_state = 20},
  [515] = {.lex_state = 20},
  [516] = {.lex_state = 20},
  [517] = {.lex_state = 20},
  [518] = {.lex_state = 20},
  [519] = {.lex_state = 20},
  [520] = {.lex_state = 20},
  [521] = {.lex_state = 20},
  [522] = {.lex_state = 20},
  [523] = {.lex_state = 20},
  [524] = {.lex_state = 20},
  [525] = {.lex_state = 20},
  [526] = {.lex_state = 20},
  [527] = {.lex_state = 20},
  [528] = {.lex_state = 20},
  [529] = {.lex_state = 20},
  [530] = {.lex_state = 20},
  [531] = {.lex_state = 0},
  [532] = {.lex_state = 20},
  [533] = {.lex_state = 20},
  [534] = {.lex_state = 20},
  [535] = {.lex_state = 20},
  [536] = {.lex_state = 20},
  [537] = {.lex_state = 20},
  [538] = {.lex_state = 20},
  [539] = {.lex_state = 20},
  [540] = {.lex_state = 20},
  [541] = {.lex_state = 20},
  [542] = {.lex_state = 20},
  [543] = {.lex_state = 20},
  [544] = {.lex_state = 20},
  [545] = {.lex_state = 20},
  [546] = {.lex_state = 0},
  [547] = {.lex_state = 20},
  [548] = {.lex_state = 20},
  [549] = {.lex_state = 20},
  [550] = {.lex_state = 20},
  [551] = {.lex_state = 20},
  [552] = {.lex_state = 20},
  [553] = {.lex_state = 20},
  [554] = {.lex_state = 20},
  [555] = {.lex_state = 20},
  [556] = {.lex_state = 20},
  [557] = {.lex_state = 20},
  [558] = {.lex_state = 20},
  [559] = {.lex_state = 20},
  [560] = {.lex_state = 20},
  [561] = {.lex_state = 20},
  [562] = {.lex_state = 20},
  [563] = {.lex_state = 20},
  [564] = {.lex_state = 20},
  [565] = {.lex_state = 0},
  [566] = {.lex_state = 20},
  [567] = {.lex_state = 20},
  [568] = {.lex_state = 20},
  [569] = {.lex_state = 20},
  [570] = {.lex_state = 20},
  [571] = {.lex_state = 20},
  [572] = {.lex_state = 20},
  [573] = {.lex_state = 20},
  [574] = {.lex_state = 20},
  [575] = {.lex_state = 20},
  [576] = {.lex_state = 20},
  [577] = {.lex_state = 20},
  [578] = {.lex_state = 20},
  [579] = {.lex_state = 20},
  [580] = {.lex_state = 20},
  [581] = {.lex_state = 20},
  [582] = {.lex_state = 20},
  [583] = {.lex_state = 20},
  [584] = {.lex_state = 20},
  [585] = {.lex_state = 20},
  [586] = {.lex_state = 20},
  [587] = {.lex_state = 20},
  [588] = {.lex_state = 20},
  [589] = {.lex_state = 20},
  [590] = {.lex_state = 20},
  [591] = {.lex_state = 20},
  [592] = {.lex_state = 20},
  [593] = {.lex_state = 20},
  [594] = {.lex_state = 20},
  [595] = {.lex_state = 20},
  [596] = {.lex_state = 20},
  [597] = {.lex_state = 20},
  [598] = {.lex_state = 20},
  [599] = {.lex_state = 20},
  [600] = {.lex_state = 20},
  [601] = {.lex_state = 20},
  [602] = {.lex_state = 20},
  [603] = {.lex_state = 20},
  [604] = {.lex_state = 20},
  [605] = {.lex_state = 20},
  [606] = {.lex_state = 20},
  [607] = {.lex_state = 20},
  [608] = {.lex_state = 20},
  [609] = {.lex_state = 20},
  [610] = {.lex_state = 20},
  [611] = {.lex_state = 20},
  [612] = {.lex_state = 20},
  [613] = {.lex_state = 20},
  [614] = {.lex_state = 20},
  [615] = {.lex_state = 20},
  [616] = {.lex_state = 20},
  [617] = {.lex_state = 20},
  [618] = {.lex_state = 20},
  [619] = {.lex_state = 20},
  [620] = {.lex_state = 20},
  [621] = {.lex_state = 20},
  [622] = {.lex_state = 20},
  [623] = {.lex_state = 20},
  [624] = {.lex_state = 20},
  [625] = {.lex_state = 20},
  [626] = {.lex_state = 20},
  [627] = {.lex_state = 20},
  [628] = {.lex_state = 20},
  [629] = {.lex_state = 20},
  [630] = {.lex_state = 20},
  [631] = {.lex_state = 20},
  [632] = {.lex_state = 20},
  [633] = {.lex_state = 20},
  [634] = {.lex_state = 20},
  [635] = {.lex_state = 20},
  [636] = {.lex_state = 20},
  [637] = {.lex_state = 20},
  [638] = {.lex_state = 20},
  [639] = {.lex_state = 20},
  [640] = {.lex_state = 20},
  [641] = {.lex_state = 20},
  [642] = {.lex_state = 20},
  [643] = {.lex_state = 20},
  [644] = {.lex_state = 20},
  [645] = {.lex_state = 0},
  [646] = {.lex_state = 20},
  [647] = {.lex_state = 20},
  [648] = {.lex_state = 20},
  [649] = {.lex_state = 20},
  [650] = {.lex_state = 20},
  [651] = {.lex_state = 20},
  [652] = {.lex_state = 20},
  [653] = {.lex_state = 20},
  [654] = {.lex_state = 20},
  [655] = {.lex_state = 20},
  [656] = {.lex_state = 20},
  [657] = {.lex_state = 20},
  [658] = {.lex_state = 20},
  [659] = {.lex_state = 20},
  [660] = {.lex_state = 20},
  [661] = {.lex_state = 20},
  [662] = {.lex_state = 20},
  [663] = {.lex_state = 20},
  [664] = {.lex_state = 5},
  [665] = {.lex_state = 0},
  [666] = {.lex_state = 0},
  [667] = {.lex_state = 20},
  [668] = {.lex_state = 0},
  [669] = {.lex_state = 0},
  [670] = {.lex_state = 0},
  [671] = {.lex_state = 0},
  [672] = {.lex_state = 5},
  [673] = {.lex_state = 0},
  [674] = {.lex_state = 0},
  [675] = {.lex_state = 0},
  [676] = {.lex_state = 0},
  [677] = {.lex_state = 0},
  [678] = {.lex_state = 0},
  [679] = {.lex_state = 0},
  [680] = {.lex_state = 0},
  [681] = {.lex_state = 0},
  [682] = {.lex_state = 0},
  [683] = {.lex_state = 0},
  [684] = {.lex_state = 0},
  [685] = {.lex_state = 0},
  [686] = {.lex_state = 0},
  [687] = {.lex_state = 0},
  [688] = {.lex_state = 0},
  [689] = {.lex_state = 1},
  [690] = {.lex_state = 0},
  [691] = {.lex_state = 0},
  [692] = {.lex_state = 0},
  [693] = {.lex_state = 0},
  [694] = {.lex_state = 0},
  [695] = {.lex_state = 0},
  [696] = {.lex_state = 20},
  [697] = {.lex_state = 1},
  [698] = {.lex_state = 0},
  [699] = {.lex_state = 0},
  [700] = {.lex_state = 0},
  [701] = {.lex_state = 0},
  [702] = {.lex_state = 0},
  [703] = {.lex_state = 0},
  [704] = {.lex_state = 0},
  [705] = {.lex_state = 0},
  [706] = {.lex_state = 0},
  [707] = {.lex_state = 0},
  [708] = {.lex_state = 0},
  [709] = {.lex_state = 0},
  [710] = {.lex_state = 0},
  [711] = {.lex_state = 0},
  [712] = {.lex_state = 0},
  [713] = {.lex_state = 0},
  [714] = {.lex_state = 20},
  [715] = {.lex_state = 0},
  [716] = {.lex_state = 0, .external_lex_state = 3},
  [717] = {.lex_state = 0, .external_lex_state = 3},
  [718] = {.lex_state = 0},
  [719] = {.lex_state = 0},
  [720] = {.lex_state = 1},
  [721] = {.lex_state = 1},
  [722] = {.lex_state = 0},
  [723] = {.lex_state = 0},
  [724] = {.lex_state = 0},
  [725] = {.lex_state = 0},
  [726] = {.lex_state = 0},
  [727] = {.lex_state = 0},
  [728] = {.lex_state = 0},
  [729] = {.lex_state = 0},
  [730] = {.lex_state = 0},
  [731] = {.lex_state = 1},
  [732] = {.lex_state = 0},
  [733] = {.lex_state = 1},
  [734] = {.lex_state = 0},
  [735] = {.lex_state = 1},
  [736] = {.lex_state = 1},
  [737] = {.lex_state = 1},
  [738] = {.lex_state = 0},
  [739] = {.lex_state = 0},
  [740] = {.lex_state = 0},
  [741] = {.lex_state = 0, .external_lex_state = 3},
  [742] = {.lex_state = 0},
  [743] = {.lex_state = 0},
  [744] = {.lex_state = 0},
  [745] = {.lex_state = 0},
  [746] = {.lex_state = 0},
  [747] = {.lex_state = 0},
  [748] = {.lex_state = 1},
  [749] = {.lex_state = 0},
  [750] = {.lex_state = 0},
  [751] = {.lex_state = 0},
  [752] = {.lex_state = 0},
  [753] = {.lex_state = 0},
  [754] = {.lex_state = 0},
  [755] = {.lex_state = 0},
  [756] = {.lex_state = 0},
  [757] = {.lex_state = 0},
  [758] = {.lex_state = 0},
  [759] = {.lex_state = 0},
  [760] = {.lex_state = 0},
  [761] = {.lex_state = 0},
  [762] = {.lex_state = 0},
  [763] = {.lex_state = 0},
  [764] = {.lex_state = 0},
  [765] = {.lex_state = 0},
  [766] = {.lex_state = 0},
  [767] = {.lex_state = 0},
  [768] = {.lex_state = 0},
  [769] = {.lex_state = 0},
  [770] = {.lex_state = 0},
  [771] = {.lex_state = 0},
  [772] = {.lex_state = 0},
  [773] = {.lex_state = 1},
  [774] = {.lex_state = 0},
  [775] = {.lex_state = 1},
  [776] = {.lex_state = 0},
  [777] = {.lex_state = 0},
  [778] = {.lex_state = 0},
  [779] = {.lex_state = 0},
  [780] = {.lex_state = 0},
  [781] = {.lex_state = 0},
  [782] = {.lex_state = 0},
  [783] = {.lex_state = 1},
  [784] = {.lex_state = 0},
  [785] = {.lex_state = 0},
  [786] = {.lex_state = 1},
  [787] = {.lex_state = 0},
  [788] = {.lex_state = 0},
  [789] = {.lex_state = 0},
  [790] = {.lex_state = 0},
  [791] = {.lex_state = 0},
  [792] = {.lex_state = 0},
  [793] = {.lex_state = 0},
  [794] = {.lex_state = 0},
  [795] = {.lex_state = 0},
  [796] = {.lex_state = 0},
  [797] = {.lex_state = 1},
  [798] = {.lex_state = 0},
  [799] = {.lex_state = 0},
  [800] = {.lex_state = 0},
  [801] = {.lex_state = 0},
  [802] = {.lex_state = 0},
  [803] = {.lex_state = 0},
  [804] = {.lex_state = 0},
  [805] = {.lex_state = 0},
  [806] = {.lex_state = 0},
  [807] = {.lex_state = 0},
  [808] = {.lex_state = 0},
  [809] = {.lex_state = 0},
  [810] = {.lex_state = 0},
  [811] = {.lex_state = 0},
  [812] = {.lex_state = 0},
  [813] = {.lex_state = 1},
  [814] = {.lex_state = 0},
  [815] = {.lex_state = 0},
  [816] = {.lex_state = 0},
  [817] = {.lex_state = 0},
  [818] = {.lex_state = 0},
  [819] = {.lex_state = 0},
  [820] = {.lex_state = 0},
  [821] = {.lex_state = 0},
  [822] = {.lex_state = 0},
  [823] = {.lex_state = 0},
  [824] = {.lex_state = 0},
  [825] = {.lex_state = 0},
  [826] = {.lex_state = 1},
  [827] = {.lex_state = 0},
  [828] = {.lex_state = 0},
  [829] = {.lex_state = 0},
  [830] = {.lex_state = 0},
  [831] = {.lex_state = 0},
  [832] = {.lex_state = 0},
  [833] = {.lex_state = 0},
  [834] = {.lex_state = 0},
  [835] = {.lex_state = 0},
  [836] = {.lex_state = 0},
  [837] = {.lex_state = 0},
  [838] = {.lex_state = 0},
  [839] = {.lex_state = 0},
  [840] = {.lex_state = 0},
  [841] = {.lex_state = 0},
  [842] = {.lex_state = 0},
  [843] = {.lex_state = 0},
  [844] = {.lex_state = 0},
  [845] = {.lex_state = 0},
  [846] = {.lex_state = 0},
  [847] = {.lex_state = 0},
  [848] = {.lex_state = 0},
  [849] = {.lex_state = 0},
  [850] = {.lex_state = 0},
  [851] = {.lex_state = 0},
  [852] = {.lex_state = 0},
  [853] = {.lex_state = 0},
  [854] = {.lex_state = 0},
  [855] = {.lex_state = 0},
  [856] = {.lex_state = 0},
  [857] = {.lex_state = 0},
  [858] = {.lex_state = 0},
  [859] = {.lex_state = 0},
  [860] = {.lex_state = 0},
  [861] = {.lex_state = 0},
  [862] = {.lex_state = 0},
  [863] = {.lex_state = 0},
  [864] = {.lex_state = 0},
  [865] = {.lex_state = 0},
  [866] = {.lex_state = 0},
  [867] = {.lex_state = 0},
  [868] = {.lex_state = 0},
  [869] = {.lex_state = 0},
  [870] = {.lex_state = 0},
  [871] = {.lex_state = 0},
  [872] = {.lex_state = 0},
  [873] = {.lex_state = 0},
  [874] = {.lex_state = 0},
  [875] = {.lex_state = 0},
  [876] = {.lex_state = 0},
  [877] = {.lex_state = 0},
  [878] = {.lex_state = 0},
  [879] = {.lex_state = 0},
  [880] = {.lex_state = 0},
  [881] = {.lex_state = 0},
  [882] = {.lex_state = 0},
  [883] = {.lex_state = 0},
  [884] = {.lex_state = 0},
  [885] = {.lex_state = 0},
  [886] = {.lex_state = 0},
  [887] = {.lex_state = 0},
  [888] = {.lex_state = 0},
  [889] = {.lex_state = 0},
  [890] = {.lex_state = 0},
  [891] = {.lex_state = 0},
  [892] = {.lex_state = 0},
  [893] = {.lex_state = 0},
  [894] = {.lex_state = 0},
  [895] = {.lex_state = 0},
  [896] = {.lex_state = 0},
  [897] = {.lex_state = 0},
  [898] = {.lex_state = 0},
  [899] = {.lex_state = 0},
  [900] = {.lex_state = 0},
  [901] = {.lex_state = 0},
  [902] = {.lex_state = 0},
  [903] = {.lex_state = 0},
  [904] = {.lex_state = 0},
  [905] = {.lex_state = 0},
  [906] = {.lex_state = 0},
  [907] = {.lex_state = 0},
  [908] = {.lex_state = 0},
  [909] = {.lex_state = 0},
  [910] = {.lex_state = 0},
  [911] = {.lex_state = 0},
  [912] = {.lex_state = 0},
  [913] = {.lex_state = 0},
  [914] = {.lex_state = 0},
  [915] = {.lex_state = 0},
  [916] = {.lex_state = 0},
  [917] = {.lex_state = 0},
  [918] = {.lex_state = 0},
  [919] = {.lex_state = 0},
  [920] = {.lex_state = 0},
  [921] = {.lex_state = 0},
  [922] = {.lex_state = 0},
  [923] = {.lex_state = 0},
  [924] = {.lex_state = 0},
  [925] = {.lex_state = 0},
  [926] = {.lex_state = 0},
  [927] = {.lex_state = 0},
  [928] = {.lex_state = 0},
  [929] = {.lex_state = 0},
  [930] = {.lex_state = 0},
  [931] = {.lex_state = 0},
  [932] = {.lex_state = 0},
  [933] = {.lex_state = 0},
  [934] = {.lex_state = 0},
  [935] = {.lex_state = 0},
  [936] = {.lex_state = 0},
  [937] = {.lex_state = 0},
  [938] = {.lex_state = 0},
  [939] = {.lex_state = 0},
  [940] = {.lex_state = 0},
  [941] = {.lex_state = 0},
  [942] = {.lex_state = 0},
  [943] = {.lex_state = 0},
  [944] = {.lex_state = 0},
  [945] = {.lex_state = 0},
  [946] = {.lex_state = 0},
  [947] = {.lex_state = 0},
  [948] = {.lex_state = 0},
  [949] = {.lex_state = 0},
  [950] = {.lex_state = 0},
  [951] = {.lex_state = 0},
  [952] = {.lex_state = 0},
  [953] = {.lex_state = 0},
  [954] = {.lex_state = 0},
  [955] = {.lex_state = 0},
  [956] = {.lex_state = 0},
  [957] = {.lex_state = 0},
  [958] = {.lex_state = 0},
  [959] = {.lex_state = 0},
  [960] = {.lex_state = 0},
  [961] = {.lex_state = 0},
  [962] = {.lex_state = 0},
  [963] = {.lex_state = 0},
  [964] = {.lex_state = 0},
  [965] = {.lex_state = 0},
  [966] = {.lex_state = 0},
  [967] = {.lex_state = 0},
  [968] = {.lex_state = 0},
  [969] = {.lex_state = 0},
  [970] = {.lex_state = 0},
  [971] = {.lex_state = 0},
  [972] = {.lex_state = 0},
  [973] = {.lex_state = 0},
  [974] = {.lex_state = 0},
  [975] = {.lex_state = 0},
  [976] = {.lex_state = 0},
  [977] = {.lex_state = 0},
  [978] = {.lex_state = 0},
  [979] = {.lex_state = 0},
  [980] = {.lex_state = 0},
  [981] = {.lex_state = 0},
  [982] = {.lex_state = 0},
  [983] = {.lex_state = 0},
  [984] = {.lex_state = 0},
  [985] = {.lex_state = 0},
  [986] = {.lex_state = 0},
  [987] = {.lex_state = 0},
  [988] = {.lex_state = 0},
  [989] = {.lex_state = 0},
  [990] = {.lex_state = 0},
  [991] = {.lex_state = 0},
  [992] = {.lex_state = 0},
  [993] = {.lex_state = 0},
  [994] = {.lex_state = 0},
  [995] = {.lex_state = 0},
  [996] = {.lex_state = 0},
  [997] = {.lex_state = 0},
  [998] = {.lex_state = 0},
  [999] = {.lex_state = 0},
  [1000] = {.lex_state = 0},
  [1001] = {.lex_state = 0},
  [1002] = {.lex_state = 0},
  [1003] = {.lex_state = 0},
  [1004] = {.lex_state = 0},
  [1005] = {.lex_state = 0},
  [1006] = {.lex_state = 0},
  [1007] = {.lex_state = 0},
  [1008] = {.lex_state = 0},
  [1009] = {.lex_state = 0},
  [1010] = {.lex_state = 0},
  [1011] = {.lex_state = 0},
  [1012] = {.lex_state = 0},
  [1013] = {.lex_state = 0},
  [1014] = {.lex_state = 0},
  [1015] = {.lex_state = 0},
  [1016] = {.lex_state = 0},
  [1017] = {.lex_state = 0},
  [1018] = {.lex_state = 0},
  [1019] = {.lex_state = 0},
  [1020] = {.lex_state = 0},
  [1021] = {.lex_state = 0},
  [1022] = {.lex_state = 0},
  [1023] = {.lex_state = 0},
  [1024] = {.lex_state = 0},
  [1025] = {.lex_state = 0},
  [1026] = {.lex_state = 0},
  [1027] = {.lex_state = 0},
  [1028] = {.lex_state = 0},
  [1029] = {.lex_state = 0},
  [1030] = {.lex_state = 0},
  [1031] = {.lex_state = 0},
  [1032] = {.lex_state = 0},
  [1033] = {.lex_state = 0},
  [1034] = {.lex_state = 0},
  [1035] = {.lex_state = 0},
  [1036] = {.lex_state = 0},
  [1037] = {.lex_state = 0},
  [1038] = {.lex_state = 0},
  [1039] = {.lex_state = 0},
  [1040] = {.lex_state = 0},
  [1041] = {.lex_state = 0},
  [1042] = {.lex_state = 0},
  [1043] = {.lex_state = 0},
  [1044] = {.lex_state = 0},
  [1045] = {.lex_state = 0},
  [1046] = {.lex_state = 0},
  [1047] = {.lex_state = 0},
  [1048] = {.lex_state = 0},
  [1049] = {.lex_state = 0},
  [1050] = {.lex_state = 0},
  [1051] = {.lex_state = 0},
  [1052] = {.lex_state = 40},
  [1053] = {.lex_state = 1},
  [1054] = {.lex_state = 0},
  [1055] = {.lex_state = 0},
  [1056] = {.lex_state = 0},
  [1057] = {.lex_state = 40},
  [1058] = {.lex_state = 44},
  [1059] = {.lex_state = 0, .external_lex_state = 4},
  [1060] = {.lex_state = 0},
  [1061] = {.lex_state = 1},
  [1062] = {.lex_state = 1},
  [1063] = {.lex_state = 1},
  [1064] = {.lex_state = 0},
  [1065] = {.lex_state = 0},
  [1066] = {.lex_state = 1},
  [1067] = {.lex_state = 0},
  [1068] = {.lex_state = 0},
  [1069] = {.lex_state = 0},
  [1070] = {.lex_state = 0},
  [1071] = {.lex_state = 1},
  [1072] = {.lex_state = 0},
  [1073] = {.lex_state = 0},
  [1074] = {.lex_state = 0},
  [1075] = {.lex_state = 0},
  [1076] = {.lex_state = 0},
  [1077] = {.lex_state = 0},
  [1078] = {.lex_state = 0},
  [1079] = {.lex_state = 0},
  [1080] = {.lex_state = 0},
  [1081] = {.lex_state = 0},
  [1082] = {.lex_state = 0},
  [1083] = {.lex_state = 0},
  [1084] = {.lex_state = 0},
  [1085] = {.lex_state = 1},
  [1086] = {.lex_state = 0},
  [1087] = {.lex_state = 0},
  [1088] = {.lex_state = 0},
  [1089] = {.lex_state = 0},
  [1090] = {.lex_state = 0},
  [1091] = {.lex_state = 0},
  [1092] = {.lex_state = 0},
  [1093] = {.lex_state = 10},
  [1094] = {.lex_state = 0},
  [1095] = {.lex_state = 0},
  [1096] = {.lex_state = 0},
  [1097] = {.lex_state = 0},
  [1098] = {.lex_state = 0},
  [1099] = {.lex_state = 0},
  [1100] = {.lex_state = 0},
  [1101] = {.lex_state = 0},
  [1102] = {.lex_state = 0},
  [1103] = {.lex_state = 0},
  [1104] = {.lex_state = 11},
  [1105] = {.lex_state = 0},
  [1106] = {.lex_state = 10},
  [1107] = {.lex_state = 0},
  [1108] = {.lex_state = 1},
  [1109] = {.lex_state = 0},
  [1110] = {.lex_state = 0},
  [1111] = {.lex_state = 0},
  [1112] = {.lex_state = 0},
  [1113] = {.lex_state = 0},
  [1114] = {.lex_state = 0},
  [1115] = {.lex_state = 0},
  [1116] = {.lex_state = 0},
  [1117] = {.lex_state = 0},
  [1118] = {.lex_state = 0},
  [1119] = {.lex_state = 1},
  [1120] = {.lex_state = 0},
  [1121] = {.lex_state = 0},
  [1122] = {.lex_state = 0},
  [1123] = {.lex_state = 0},
  [1124] = {.lex_state = 0},
  [1125] = {.lex_state = 0},
  [1126] = {.lex_state = 0, .external_lex_state = 5},
  [1127] = {.lex_state = 0, .external_lex_state = 6},
  [1128] = {.lex_state = 0},
  [1129] = {.lex_state = 0},
  [1130] = {.lex_state = 0},
  [1131] = {.lex_state = 0},
  [1132] = {.lex_state = 1},
  [1133] = {.lex_state = 0},
  [1134] = {.lex_state = 0},
  [1135] = {.lex_state = 0},
  [1136] = {.lex_state = 0},
  [1137] = {.lex_state = 0},
  [1138] = {.lex_state = 1},
  [1139] = {.lex_state = 44},
  [1140] = {.lex_state = 1},
  [1141] = {.lex_state = 0},
  [1142] = {.lex_state = 1},
  [1143] = {.lex_state = 0},
  [1144] = {.lex_state = 0},
  [1145] = {.lex_state = 0},
  [1146] = {.lex_state = 0},
  [1147] = {.lex_state = 0},
  [1148] = {.lex_state = 40},
  [1149] = {.lex_state = 11},
  [1150] = {.lex_state = 0},
  [1151] = {.lex_state = 1},
  [1152] = {.lex_state = 1},
  [1153] = {.lex_state = 0},
  [1154] = {.lex_state = 1},
  [1155] = {.lex_state = 1},
  [1156] = {.lex_state = 0},
  [1157] = {.lex_state = 1},
  [1158] = {.lex_state = 1},
  [1159] = {.lex_state = 1},
  [1160] = {.lex_state = 1},
  [1161] = {.lex_state = 0},
  [1162] = {.lex_state = 1},
  [1163] = {.lex_state = 1},
  [1164] = {.lex_state = 0},
  [1165] = {.lex_state = 1},
  [1166] = {.lex_state = 0},
  [1167] = {.lex_state = 1},
  [1168] = {.lex_state = 1},
  [1169] = {.lex_state = 1},
  [1170] = {.lex_state = 0, .external_lex_state = 4},
  [1171] = {.lex_state = 0},
  [1172] = {.lex_state = 0},
  [1173] = {.lex_state = 0},
  [1174] = {.lex_state = 0},
  [1175] = {.lex_state = 0},
  [1176] = {.lex_state = 0},
  [1177] = {.lex_state = 0},
  [1178] = {.lex_state = 0},
  [1179] = {.lex_state = 1},
  [1180] = {.lex_state = 0},
  [1181] = {.lex_state = 1},
  [1182] = {.lex_state = 0},
  [1183] = {.lex_state = 44},
  [1184] = {.lex_state = 40},
  [1185] = {.lex_state = 1},
  [1186] = {.lex_state = 1},
  [1187] = {.lex_state = 0},
  [1188] = {.lex_state = 1},
  [1189] = {.lex_state = 1},
  [1190] = {.lex_state = 1},
  [1191] = {.lex_state = 1},
  [1192] = {.lex_state = 0},
  [1193] = {.lex_state = 1},
  [1194] = {.lex_state = 1},
  [1195] = {.lex_state = 1},
  [1196] = {.lex_state = 1},
  [1197] = {.lex_state = 0},
  [1198] = {.lex_state = 1},
  [1199] = {.lex_state = 0},
  [1200] = {.lex_state = 1},
  [1201] = {.lex_state = 1},
  [1202] = {.lex_state = 0},
  [1203] = {.lex_state = 0},
  [1204] = {.lex_state = 0},
  [1205] = {.lex_state = 0},
  [1206] = {.lex_state = 0},
  [1207] = {.lex_state = 1},
  [1208] = {.lex_state = 0},
  [1209] = {.lex_state = 0},
  [1210] = {.lex_state = 0},
  [1211] = {.lex_state = 0},
  [1212] = {.lex_state = 0},
  [1213] = {.lex_state = 0, .external_lex_state = 6},
  [1214] = {.lex_state = 0, .external_lex_state = 5},
  [1215] = {.lex_state = 44},
  [1216] = {.lex_state = 1},
  [1217] = {.lex_state = 0},
  [1218] = {.lex_state = 1},
  [1219] = {.lex_state = 0, .external_lex_state = 6},
  [1220] = {.lex_state = 0, .external_lex_state = 5},
  [1221] = {.lex_state = 0},
  [1222] = {.lex_state = 1},
  [1223] = {.lex_state = 1},
  [1224] = {.lex_state = 0},
  [1225] = {.lex_state = 0},
  [1226] = {.lex_state = 1},
  [1227] = {.lex_state = 1},
  [1228] = {.lex_state = 1},
  [1229] = {.lex_state = 0},
  [1230] = {.lex_state = 1},
  [1231] = {.lex_state = 0},
  [1232] = {.lex_state = 1},
  [1233] = {.lex_state = 0},
  [1234] = {.lex_state = 0},
  [1235] = {.lex_state = 0},
  [1236] = {.lex_state = 0},
  [1237] = {.lex_state = 1},
  [1238] = {.lex_state = 0},
  [1239] = {.lex_state = 0},
  [1240] = {.lex_state = 0},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [anon_sym_LBRACE_PERCENT_PERCENT] = ACTIONS(1),
    [anon_sym_LBRACE_LBRACE_LBRACE] = ACTIONS(1),
    [anon_sym_liquid] = ACTIONS(1),
    [anon_sym_LBRACE_PERCENT] = ACTIONS(1),
    [anon_sym_LBRACE_PERCENT_DASH] = ACTIONS(1),
    [anon_sym_PERCENT_RBRACE] = ACTIONS(1),
    [anon_sym_DASH_PERCENT_RBRACE] = ACTIONS(1),
    [anon_sym_LBRACE_LBRACE] = ACTIONS(1),
    [anon_sym_LBRACE_LBRACE_DASH] = ACTIONS(1),
    [anon_sym_RBRACE_RBRACE] = ACTIONS(1),
    [anon_sym_DASH_RBRACE_RBRACE] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [sym_number] = ACTIONS(1),
    [anon_sym_true] = ACTIONS(1),
    [anon_sym_false] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_and] = ACTIONS(1),
    [anon_sym_or] = ACTIONS(1),
    [anon_sym_contains] = ACTIONS(1),
    [sym_break_statement] = ACTIONS(1),
    [sym_continue_statement] = ACTIONS(1),
    [anon_sym_echo] = ACTIONS(1),
    [anon_sym_section] = ACTIONS(1),
    [anon_sym_sections] = ACTIONS(1),
    [anon_sym_increment] = ACTIONS(1),
    [anon_sym_decrement] = ACTIONS(1),
    [anon_sym_layout] = ACTIONS(1),
    [anon_sym_none] = ACTIONS(1),
    [anon_sym_assign] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_cycle] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_include] = ACTIONS(1),
    [anon_sym_include_relative] = ACTIONS(1),
    [anon_sym_EQ2] = ACTIONS(1),
    [anon_sym_render] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_with] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_DOT_DOT] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_endif] = ACTIONS(1),
    [anon_sym_elsif] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_endfor] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_endcase] = ACTIONS(1),
    [anon_sym_when] = ACTIONS(1),
    [anon_sym_unless] = ACTIONS(1),
    [anon_sym_endunless] = ACTIONS(1),
    [anon_sym_capture] = ACTIONS(1),
    [anon_sym_endcapture] = ACTIONS(1),
    [anon_sym_form] = ACTIONS(1),
    [anon_sym_endform] = ACTIONS(1),
    [anon_sym_tablerow] = ACTIONS(1),
    [anon_sym_endtablerow] = ACTIONS(1),
    [anon_sym_paginate] = ACTIONS(1),
    [anon_sym_by] = ACTIONS(1),
    [anon_sym_endpaginate] = ACTIONS(1),
    [anon_sym_schema] = ACTIONS(1),
    [anon_sym_endschema] = ACTIONS(1),
    [anon_sym_style] = ACTIONS(1),
    [anon_sym_endstyle] = ACTIONS(1),
    [anon_sym_javascript] = ACTIONS(1),
    [anon_sym_endjavascript] = ACTIONS(1),
    [anon_sym_raw] = ACTIONS(1),
    [anon_sym_endraw] = ACTIONS(1),
    [anon_sym_comment] = ACTIONS(1),
    [anon_sym_endcomment] = ACTIONS(1),
    [sym__inline_comment_content] = ACTIONS(1),
    [sym__paired_comment_content] = ACTIONS(1),
    [sym__paired_comment_content_liq] = ACTIONS(1),
    [sym_raw_content] = ACTIONS(1),
    [sym_front_matter] = ACTIONS(1),
    [sym_error_sentinel] = ACTIONS(1),
  },
  [1] = {
    [sym_program] = STATE(1105),
    [sym__node] = STATE(453),
    [sym_template_content] = STATE(453),
    [sym__statement] = STATE(453),
    [sym__tagged_unpaired_statement] = STATE(453),
    [sym__output_statement] = STATE(453),
    [sym__tagged_paired_statment] = STATE(453),
    [sym_if_statement] = STATE(453),
    [sym_for_loop_statement] = STATE(453),
    [sym_case_statement] = STATE(453),
    [sym_unless_statement] = STATE(453),
    [sym_capture_statement] = STATE(453),
    [sym_form_statement] = STATE(453),
    [sym_tablerow_statement] = STATE(453),
    [sym_paginate_statement] = STATE(453),
    [sym_schema_statement] = STATE(453),
    [sym_style_statement] = STATE(453),
    [sym_javascript_statement] = STATE(453),
    [sym_raw_statement] = STATE(453),
    [sym_comment] = STATE(453),
    [sym__inline_comment] = STATE(408),
    [sym__paired_comment] = STATE(408),
    [aux_sym_program_repeat1] = STATE(157),
    [aux_sym_template_content_repeat1] = STATE(394),
    [ts_builtin_sym_end] = ACTIONS(3),
    [aux_sym_template_content_token1] = ACTIONS(5),
    [anon_sym_LBRACE_PERCENT_PERCENT] = ACTIONS(7),
    [anon_sym_LBRACE_LBRACE_LBRACE] = ACTIONS(7),
    [anon_sym_LBRACE_PERCENT] = ACTIONS(9),
    [anon_sym_LBRACE_PERCENT_DASH] = ACTIONS(9),
    [anon_sym_LBRACE_LBRACE] = ACTIONS(11),
    [anon_sym_LBRACE_LBRACE_DASH] = ACTIONS(11),
    [sym_front_matter] = ACTIONS(13),
  },
  [2] = {
    [sym__liquid_node] = STATE(135),
    [sym__untagged_unpaired_statement] = STATE(1108),
    [sym__untagged_paired_statement] = STATE(1108),
    [sym__expression] = STATE(316),
    [sym__literal] = STATE(316),
    [sym_string] = STATE(316),
    [sym_boolean] = STATE(316),
    [sym_predicate] = STATE(316),
    [sym_echo_statement] = STATE(1108),
    [sym_section_statement] = STATE(1108),
    [sym_sections_statement] = STATE(1108),
    [sym_increment_statement] = STATE(1108),
    [sym_decrement_statement] = STATE(1108),
    [sym_layout_statement] = STATE(1108),
    [sym_custom_unpaired_statement] = STATE(1108),
    [sym_assignment_statement] = STATE(1108),
    [sym_cycle_statement] = STATE(1108),
    [sym_include_statement] = STATE(1108),
    [sym_render_statement] = STATE(1108),
    [sym_filter] = STATE(316),
    [sym_access] = STATE(277),
    [sym__if_liq] = STATE(1168),
    [sym__elsif_liq] = STATE(740),
    [sym__else_liq] = STATE(1064),
    [sym__for_loop_liq] = STATE(1167),
    [sym__case_liq] = STATE(1165),
    [sym__unless_liq] = STATE(1163),
    [sym__capture_liq] = STATE(1162),
    [sym__form_liq] = STATE(1158),
    [sym__tablerow_liq] = STATE(1157),
    [sym__paginate_liq] = STATE(1155),
    [sym__else_aliased] = STATE(1064),
    [sym__elsif_aliased] = STATE(739),
    [aux_sym__if_liq_repeat1] = STATE(7),
    [aux_sym__if_liq_repeat2] = STATE(397),
    [sym_identifier] = ACTIONS(15),
    [anon_sym_LBRACE_LBRACE] = ACTIONS(17),
    [anon_sym_LBRACE_LBRACE_DASH] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE] = ACTIONS(23),
    [sym_number] = ACTIONS(25),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(29),
    [anon_sym_DASH] = ACTIONS(31),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_SLASH] = ACTIONS(33),
    [anon_sym_PERCENT] = ACTIONS(33),
    [anon_sym_CARET] = ACTIONS(35),
    [anon_sym_EQ_EQ] = ACTIONS(37),
    [anon_sym_LT] = ACTIONS(39),
    [anon_sym_LT_EQ] = ACTIONS(37),
    [anon_sym_BANG_EQ] = ACTIONS(37),
    [anon_sym_GT_EQ] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(39),
    [anon_sym_and] = ACTIONS(41),
    [anon_sym_or] = ACTIONS(41),
    [anon_sym_contains] = ACTIONS(43),
    [sym_break_statement] = ACTIONS(45),
    [sym_continue_statement] = ACTIONS(45),
    [anon_sym_echo] = ACTIONS(47),
    [anon_sym_section] = ACTIONS(49),
    [anon_sym_sections] = ACTIONS(51),
    [anon_sym_increment] = ACTIONS(53),
    [anon_sym_decrement] = ACTIONS(55),
    [anon_sym_layout] = ACTIONS(57),
    [anon_sym_assign] = ACTIONS(59),
    [anon_sym_cycle] = ACTIONS(61),
    [anon_sym_include] = ACTIONS(63),
    [anon_sym_include_relative] = ACTIONS(63),
    [anon_sym_render] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(71),
    [anon_sym_elsif] = ACTIONS(73),
    [anon_sym_else] = ACTIONS(75),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_unless] = ACTIONS(79),
    [anon_sym_endunless] = ACTIONS(81),
    [anon_sym_capture] = ACTIONS(83),
    [anon_sym_form] = ACTIONS(85),
    [anon_sym_tablerow] = ACTIONS(87),
    [anon_sym_paginate] = ACTIONS(89),
  },
  [3] = {
    [sym__liquid_node] = STATE(135),
    [sym__untagged_unpaired_statement] = STATE(1108),
    [sym__untagged_paired_statement] = STATE(1108),
    [sym__expression] = STATE(316),
    [sym__literal] = STATE(316),
    [sym_string] = STATE(316),
    [sym_boolean] = STATE(316),
    [sym_predicate] = STATE(316),
    [sym_echo_statement] = STATE(1108),
    [sym_section_statement] = STATE(1108),
    [sym_sections_statement] = STATE(1108),
    [sym_increment_statement] = STATE(1108),
    [sym_decrement_statement] = STATE(1108),
    [sym_layout_statement] = STATE(1108),
    [sym_custom_unpaired_statement] = STATE(1108),
    [sym_assignment_statement] = STATE(1108),
    [sym_cycle_statement] = STATE(1108),
    [sym_include_statement] = STATE(1108),
    [sym_render_statement] = STATE(1108),
    [sym_filter] = STATE(316),
    [sym_access] = STATE(277),
    [sym__if_liq] = STATE(1168),
    [sym__elsif_liq] = STATE(740),
    [sym__else_liq] = STATE(1081),
    [sym__for_loop_liq] = STATE(1167),
    [sym__case_liq] = STATE(1165),
    [sym__unless_liq] = STATE(1163),
    [sym__capture_liq] = STATE(1162),
    [sym__form_liq] = STATE(1158),
    [sym__tablerow_liq] = STATE(1157),
    [sym__paginate_liq] = STATE(1155),
    [sym__else_aliased] = STATE(1081),
    [sym__elsif_aliased] = STATE(739),
    [aux_sym__if_liq_repeat1] = STATE(8),
    [aux_sym__if_liq_repeat2] = STATE(401),
    [sym_identifier] = ACTIONS(15),
    [anon_sym_LBRACE_LBRACE] = ACTIONS(17),
    [anon_sym_LBRACE_LBRACE_DASH] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE] = ACTIONS(23),
    [sym_number] = ACTIONS(25),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(29),
    [anon_sym_DASH] = ACTIONS(31),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_SLASH] = ACTIONS(33),
    [anon_sym_PERCENT] = ACTIONS(33),
    [anon_sym_CARET] = ACTIONS(35),
    [anon_sym_EQ_EQ] = ACTIONS(37),
    [anon_sym_LT] = ACTIONS(39),
    [anon_sym_LT_EQ] = ACTIONS(37),
    [anon_sym_BANG_EQ] = ACTIONS(37),
    [anon_sym_GT_EQ] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(39),
    [anon_sym_and] = ACTIONS(41),
    [anon_sym_or] = ACTIONS(41),
    [anon_sym_contains] = ACTIONS(43),
    [sym_break_statement] = ACTIONS(45),
    [sym_continue_statement] = ACTIONS(45),
    [anon_sym_echo] = ACTIONS(47),
    [anon_sym_section] = ACTIONS(49),
    [anon_sym_sections] = ACTIONS(51),
    [anon_sym_increment] = ACTIONS(53),
    [anon_sym_decrement] = ACTIONS(55),
    [anon_sym_layout] = ACTIONS(57),
    [anon_sym_assign] = ACTIONS(59),
    [anon_sym_cycle] = ACTIONS(61),
    [anon_sym_include] = ACTIONS(63),
    [anon_sym_include_relative] = ACTIONS(63),
    [anon_sym_render] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(71),
    [anon_sym_endif] = ACTIONS(91),
    [anon_sym_elsif] = ACTIONS(73),
    [anon_sym_else] = ACTIONS(75),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_unless] = ACTIONS(79),
    [anon_sym_capture] = ACTIONS(83),
    [anon_sym_form] = ACTIONS(85),
    [anon_sym_tablerow] = ACTIONS(87),
    [anon_sym_paginate] = ACTIONS(89),
  },
  [4] = {
    [sym__liquid_node] = STATE(135),
    [sym__untagged_unpaired_statement] = STATE(1108),
    [sym__untagged_paired_statement] = STATE(1108),
    [sym__expression] = STATE(316),
    [sym__literal] = STATE(316),
    [sym_string] = STATE(316),
    [sym_boolean] = STATE(316),
    [sym_predicate] = STATE(316),
    [sym_echo_statement] = STATE(1108),
    [sym_section_statement] = STATE(1108),
    [sym_sections_statement] = STATE(1108),
    [sym_increment_statement] = STATE(1108),
    [sym_decrement_statement] = STATE(1108),
    [sym_layout_statement] = STATE(1108),
    [sym_custom_unpaired_statement] = STATE(1108),
    [sym_assignment_statement] = STATE(1108),
    [sym_cycle_statement] = STATE(1108),
    [sym_include_statement] = STATE(1108),
    [sym_render_statement] = STATE(1108),
    [sym_filter] = STATE(316),
    [sym_access] = STATE(277),
    [sym__if_liq] = STATE(1168),
    [sym__for_loop_liq] = STATE(1167),
    [sym__case_liq] = STATE(1165),
    [sym__unless_liq] = STATE(1163),
    [sym__capture_liq] = STATE(1162),
    [sym__form_liq] = STATE(1158),
    [sym__tablerow_liq] = STATE(1157),
    [sym__paginate_liq] = STATE(1155),
    [aux_sym__if_liq_repeat1] = STATE(17),
    [sym_identifier] = ACTIONS(15),
    [anon_sym_LBRACE_LBRACE] = ACTIONS(17),
    [anon_sym_LBRACE_LBRACE_DASH] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE] = ACTIONS(23),
    [sym_number] = ACTIONS(25),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(29),
    [anon_sym_DASH] = ACTIONS(31),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_SLASH] = ACTIONS(33),
    [anon_sym_PERCENT] = ACTIONS(33),
    [anon_sym_CARET] = ACTIONS(35),
    [anon_sym_EQ_EQ] = ACTIONS(37),
    [anon_sym_LT] = ACTIONS(39),
    [anon_sym_LT_EQ] = ACTIONS(37),
    [anon_sym_BANG_EQ] = ACTIONS(37),
    [anon_sym_GT_EQ] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(39),
    [anon_sym_and] = ACTIONS(41),
    [anon_sym_or] = ACTIONS(41),
    [anon_sym_contains] = ACTIONS(43),
    [sym_break_statement] = ACTIONS(45),
    [sym_continue_statement] = ACTIONS(45),
    [anon_sym_echo] = ACTIONS(47),
    [anon_sym_section] = ACTIONS(49),
    [anon_sym_sections] = ACTIONS(51),
    [anon_sym_increment] = ACTIONS(53),
    [anon_sym_decrement] = ACTIONS(55),
    [anon_sym_layout] = ACTIONS(57),
    [anon_sym_assign] = ACTIONS(59),
    [anon_sym_cycle] = ACTIONS(61),
    [anon_sym_include] = ACTIONS(63),
    [anon_sym_include_relative] = ACTIONS(63),
    [anon_sym_render] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(71),
    [anon_sym_endif] = ACTIONS(93),
    [anon_sym_elsif] = ACTIONS(93),
    [anon_sym_else] = ACTIONS(93),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_unless] = ACTIONS(79),
    [anon_sym_endunless] = ACTIONS(93),
    [anon_sym_capture] = ACTIONS(83),
    [anon_sym_form] = ACTIONS(85),
    [anon_sym_tablerow] = ACTIONS(87),
    [anon_sym_paginate] = ACTIONS(89),
  },
  [5] = {
    [sym__liquid_node] = STATE(135),
    [sym__untagged_unpaired_statement] = STATE(1108),
    [sym__untagged_paired_statement] = STATE(1108),
    [sym__expression] = STATE(316),
    [sym__literal] = STATE(316),
    [sym_string] = STATE(316),
    [sym_boolean] = STATE(316),
    [sym_predicate] = STATE(316),
    [sym_echo_statement] = STATE(1108),
    [sym_section_statement] = STATE(1108),
    [sym_sections_statement] = STATE(1108),
    [sym_increment_statement] = STATE(1108),
    [sym_decrement_statement] = STATE(1108),
    [sym_layout_statement] = STATE(1108),
    [sym_custom_unpaired_statement] = STATE(1108),
    [sym_assignment_statement] = STATE(1108),
    [sym_cycle_statement] = STATE(1108),
    [sym_include_statement] = STATE(1108),
    [sym_render_statement] = STATE(1108),
    [sym_filter] = STATE(316),
    [sym_access] = STATE(277),
    [sym__if_liq] = STATE(1168),
    [sym__for_loop_liq] = STATE(1167),
    [sym__case_liq] = STATE(1165),
    [sym__unless_liq] = STATE(1163),
    [sym__capture_liq] = STATE(1162),
    [sym__form_liq] = STATE(1158),
    [sym__tablerow_liq] = STATE(1157),
    [sym__paginate_liq] = STATE(1155),
    [aux_sym__if_liq_repeat1] = STATE(19),
    [sym_identifier] = ACTIONS(15),
    [anon_sym_LBRACE_LBRACE] = ACTIONS(17),
    [anon_sym_LBRACE_LBRACE_DASH] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE] = ACTIONS(23),
    [sym_number] = ACTIONS(25),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(95),
    [anon_sym_DASH] = ACTIONS(97),
    [anon_sym_STAR] = ACTIONS(95),
    [anon_sym_SLASH] = ACTIONS(95),
    [anon_sym_PERCENT] = ACTIONS(95),
    [anon_sym_CARET] = ACTIONS(95),
    [anon_sym_EQ_EQ] = ACTIONS(95),
    [anon_sym_LT] = ACTIONS(97),
    [anon_sym_LT_EQ] = ACTIONS(95),
    [anon_sym_BANG_EQ] = ACTIONS(95),
    [anon_sym_GT_EQ] = ACTIONS(95),
    [anon_sym_GT] = ACTIONS(97),
    [anon_sym_and] = ACTIONS(97),
    [anon_sym_or] = ACTIONS(97),
    [anon_sym_contains] = ACTIONS(97),
    [sym_break_statement] = ACTIONS(45),
    [sym_continue_statement] = ACTIONS(45),
    [anon_sym_echo] = ACTIONS(47),
    [anon_sym_section] = ACTIONS(49),
    [anon_sym_sections] = ACTIONS(51),
    [anon_sym_increment] = ACTIONS(53),
    [anon_sym_decrement] = ACTIONS(55),
    [anon_sym_layout] = ACTIONS(57),
    [anon_sym_assign] = ACTIONS(59),
    [anon_sym_cycle] = ACTIONS(61),
    [anon_sym_include] = ACTIONS(63),
    [anon_sym_include_relative] = ACTIONS(63),
    [anon_sym_render] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_PIPE] = ACTIONS(95),
    [anon_sym_if] = ACTIONS(71),
    [anon_sym_else] = ACTIONS(99),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_endcase] = ACTIONS(99),
    [anon_sym_when] = ACTIONS(99),
    [anon_sym_unless] = ACTIONS(79),
    [anon_sym_capture] = ACTIONS(83),
    [anon_sym_form] = ACTIONS(85),
    [anon_sym_tablerow] = ACTIONS(87),
    [anon_sym_paginate] = ACTIONS(89),
  },
  [6] = {
    [sym__liquid_node] = STATE(135),
    [sym__untagged_unpaired_statement] = STATE(1108),
    [sym__untagged_paired_statement] = STATE(1108),
    [sym__expression] = STATE(316),
    [sym__literal] = STATE(316),
    [sym_string] = STATE(316),
    [sym_boolean] = STATE(316),
    [sym_predicate] = STATE(316),
    [sym_echo_statement] = STATE(1108),
    [sym_section_statement] = STATE(1108),
    [sym_sections_statement] = STATE(1108),
    [sym_increment_statement] = STATE(1108),
    [sym_decrement_statement] = STATE(1108),
    [sym_layout_statement] = STATE(1108),
    [sym_custom_unpaired_statement] = STATE(1108),
    [sym_assignment_statement] = STATE(1108),
    [sym_cycle_statement] = STATE(1108),
    [sym_include_statement] = STATE(1108),
    [sym_render_statement] = STATE(1108),
    [sym_filter] = STATE(316),
    [sym_access] = STATE(277),
    [sym__if_liq] = STATE(1168),
    [sym__for_loop_liq] = STATE(1167),
    [sym__case_liq] = STATE(1165),
    [sym__unless_liq] = STATE(1163),
    [sym__capture_liq] = STATE(1162),
    [sym__form_liq] = STATE(1158),
    [sym__tablerow_liq] = STATE(1157),
    [sym__paginate_liq] = STATE(1155),
    [aux_sym__if_liq_repeat1] = STATE(6),
    [sym_identifier] = ACTIONS(101),
    [anon_sym_LBRACE_LBRACE] = ACTIONS(104),
    [anon_sym_LBRACE_LBRACE_DASH] = ACTIONS(107),
    [anon_sym_SQUOTE] = ACTIONS(110),
    [anon_sym_DQUOTE] = ACTIONS(113),
    [sym_number] = ACTIONS(116),
    [anon_sym_true] = ACTIONS(119),
    [anon_sym_false] = ACTIONS(119),
    [sym_break_statement] = ACTIONS(122),
    [sym_continue_statement] = ACTIONS(122),
    [anon_sym_echo] = ACTIONS(125),
    [anon_sym_section] = ACTIONS(128),
    [anon_sym_sections] = ACTIONS(131),
    [anon_sym_increment] = ACTIONS(134),
    [anon_sym_decrement] = ACTIONS(137),
    [anon_sym_layout] = ACTIONS(140),
    [anon_sym_assign] = ACTIONS(143),
    [anon_sym_cycle] = ACTIONS(146),
    [anon_sym_include] = ACTIONS(149),
    [anon_sym_include_relative] = ACTIONS(149),
    [anon_sym_render] = ACTIONS(152),
    [anon_sym_for] = ACTIONS(155),
    [anon_sym_if] = ACTIONS(158),
    [anon_sym_endif] = ACTIONS(161),
    [anon_sym_elsif] = ACTIONS(161),
    [anon_sym_else] = ACTIONS(161),
    [anon_sym_endfor] = ACTIONS(161),
    [anon_sym_case] = ACTIONS(163),
    [anon_sym_endcase] = ACTIONS(161),
    [anon_sym_when] = ACTIONS(161),
    [anon_sym_unless] = ACTIONS(166),
    [anon_sym_endunless] = ACTIONS(161),
    [anon_sym_capture] = ACTIONS(169),
    [anon_sym_endcapture] = ACTIONS(161),
    [anon_sym_form] = ACTIONS(172),
    [anon_sym_endform] = ACTIONS(161),
    [anon_sym_tablerow] = ACTIONS(175),
    [anon_sym_endtablerow] = ACTIONS(161),
    [anon_sym_paginate] = ACTIONS(178),
    [anon_sym_endpaginate] = ACTIONS(161),
  },
  [7] = {
    [sym__liquid_node] = STATE(135),
    [sym__untagged_unpaired_statement] = STATE(1108),
    [sym__untagged_paired_statement] = STATE(1108),
    [sym__expression] = STATE(316),
    [sym__literal] = STATE(316),
    [sym_string] = STATE(316),
    [sym_boolean] = STATE(316),
    [sym_predicate] = STATE(316),
    [sym_echo_statement] = STATE(1108),
    [sym_section_statement] = STATE(1108),
    [sym_sections_statement] = STATE(1108),
    [sym_increment_statement] = STATE(1108),
    [sym_decrement_statement] = STATE(1108),
    [sym_layout_statement] = STATE(1108),
    [sym_custom_unpaired_statement] = STATE(1108),
    [sym_assignment_statement] = STATE(1108),
    [sym_cycle_statement] = STATE(1108),
    [sym_include_statement] = STATE(1108),
    [sym_render_statement] = STATE(1108),
    [sym_filter] = STATE(316),
    [sym_access] = STATE(277),
    [sym__if_liq] = STATE(1168),
    [sym__elsif_liq] = STATE(740),
    [sym__else_liq] = STATE(1153),
    [sym__for_loop_liq] = STATE(1167),
    [sym__case_liq] = STATE(1165),
    [sym__unless_liq] = STATE(1163),
    [sym__capture_liq] = STATE(1162),
    [sym__form_liq] = STATE(1158),
    [sym__tablerow_liq] = STATE(1157),
    [sym__paginate_liq] = STATE(1155),
    [sym__else_aliased] = STATE(1153),
    [sym__elsif_aliased] = STATE(739),
    [aux_sym__if_liq_repeat1] = STATE(6),
    [aux_sym__if_liq_repeat2] = STATE(399),
    [sym_identifier] = ACTIONS(15),
    [anon_sym_LBRACE_LBRACE] = ACTIONS(17),
    [anon_sym_LBRACE_LBRACE_DASH] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE] = ACTIONS(23),
    [sym_number] = ACTIONS(25),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [sym_break_statement] = ACTIONS(45),
    [sym_continue_statement] = ACTIONS(45),
    [anon_sym_echo] = ACTIONS(47),
    [anon_sym_section] = ACTIONS(49),
    [anon_sym_sections] = ACTIONS(51),
    [anon_sym_increment] = ACTIONS(53),
    [anon_sym_decrement] = ACTIONS(55),
    [anon_sym_layout] = ACTIONS(57),
    [anon_sym_assign] = ACTIONS(59),
    [anon_sym_cycle] = ACTIONS(61),
    [anon_sym_include] = ACTIONS(63),
    [anon_sym_include_relative] = ACTIONS(63),
    [anon_sym_render] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(71),
    [anon_sym_elsif] = ACTIONS(73),
    [anon_sym_else] = ACTIONS(75),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_unless] = ACTIONS(79),
    [anon_sym_endunless] = ACTIONS(181),
    [anon_sym_capture] = ACTIONS(83),
    [anon_sym_form] = ACTIONS(85),
    [anon_sym_tablerow] = ACTIONS(87),
    [anon_sym_paginate] = ACTIONS(89),
  },
  [8] = {
    [sym__liquid_node] = STATE(135),
    [sym__untagged_unpaired_statement] = STATE(1108),
    [sym__untagged_paired_statement] = STATE(1108),
    [sym__expression] = STATE(316),
    [sym__literal] = STATE(316),
    [sym_string] = STATE(316),
    [sym_boolean] = STATE(316),
    [sym_predicate] = STATE(316),
    [sym_echo_statement] = STATE(1108),
    [sym_section_statement] = STATE(1108),
    [sym_sections_statement] = STATE(1108),
    [sym_increment_statement] = STATE(1108),
    [sym_decrement_statement] = STATE(1108),
    [sym_layout_statement] = STATE(1108),
    [sym_custom_unpaired_statement] = STATE(1108),
    [sym_assignment_statement] = STATE(1108),
    [sym_cycle_statement] = STATE(1108),
    [sym_include_statement] = STATE(1108),
    [sym_render_statement] = STATE(1108),
    [sym_filter] = STATE(316),
    [sym_access] = STATE(277),
    [sym__if_liq] = STATE(1168),
    [sym__elsif_liq] = STATE(740),
    [sym__else_liq] = STATE(1141),
    [sym__for_loop_liq] = STATE(1167),
    [sym__case_liq] = STATE(1165),
    [sym__unless_liq] = STATE(1163),
    [sym__capture_liq] = STATE(1162),
    [sym__form_liq] = STATE(1158),
    [sym__tablerow_liq] = STATE(1157),
    [sym__paginate_liq] = STATE(1155),
    [sym__else_aliased] = STATE(1141),
    [sym__elsif_aliased] = STATE(739),
    [aux_sym__if_liq_repeat1] = STATE(6),
    [aux_sym__if_liq_repeat2] = STATE(398),
    [sym_identifier] = ACTIONS(15),
    [anon_sym_LBRACE_LBRACE] = ACTIONS(17),
    [anon_sym_LBRACE_LBRACE_DASH] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE] = ACTIONS(23),
    [sym_number] = ACTIONS(25),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [sym_break_statement] = ACTIONS(45),
    [sym_continue_statement] = ACTIONS(45),
    [anon_sym_echo] = ACTIONS(47),
    [anon_sym_section] = ACTIONS(49),
    [anon_sym_sections] = ACTIONS(51),
    [anon_sym_increment] = ACTIONS(53),
    [anon_sym_decrement] = ACTIONS(55),
    [anon_sym_layout] = ACTIONS(57),
    [anon_sym_assign] = ACTIONS(59),
    [anon_sym_cycle] = ACTIONS(61),
    [anon_sym_include] = ACTIONS(63),
    [anon_sym_include_relative] = ACTIONS(63),
    [anon_sym_render] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(71),
    [anon_sym_endif] = ACTIONS(183),
    [anon_sym_elsif] = ACTIONS(73),
    [anon_sym_else] = ACTIONS(75),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_unless] = ACTIONS(79),
    [anon_sym_capture] = ACTIONS(83),
    [anon_sym_form] = ACTIONS(85),
    [anon_sym_tablerow] = ACTIONS(87),
    [anon_sym_paginate] = ACTIONS(89),
  },
  [9] = {
    [sym__liquid_node] = STATE(11),
    [sym__untagged_unpaired_statement] = STATE(1169),
    [sym__untagged_paired_statement] = STATE(1169),
    [sym__expression] = STATE(318),
    [sym__literal] = STATE(318),
    [sym_string] = STATE(318),
    [sym_boolean] = STATE(318),
    [sym_predicate] = STATE(318),
    [sym_echo_statement] = STATE(1169),
    [sym_section_statement] = STATE(1169),
    [sym_sections_statement] = STATE(1169),
    [sym_increment_statement] = STATE(1169),
    [sym_decrement_statement] = STATE(1169),
    [sym_layout_statement] = STATE(1169),
    [sym_custom_unpaired_statement] = STATE(1169),
    [sym_assignment_statement] = STATE(1169),
    [sym_cycle_statement] = STATE(1169),
    [sym_include_statement] = STATE(1169),
    [sym_render_statement] = STATE(1169),
    [sym_filter] = STATE(318),
    [sym_access] = STATE(277),
    [sym__if_liq] = STATE(1168),
    [sym__for_loop_liq] = STATE(1167),
    [sym__case_liq] = STATE(1165),
    [sym__unless_liq] = STATE(1163),
    [sym__capture_liq] = STATE(1162),
    [sym__form_liq] = STATE(1158),
    [sym__tablerow_liq] = STATE(1157),
    [sym__paginate_liq] = STATE(1155),
    [sym_comment_liq] = STATE(11),
    [sym__paired_comment_liq] = STATE(155),
    [aux_sym_liquid_tag_repeat1] = STATE(11),
    [sym_identifier] = ACTIONS(15),
    [anon_sym_PERCENT_RBRACE] = ACTIONS(185),
    [anon_sym_DASH_PERCENT_RBRACE] = ACTIONS(185),
    [anon_sym_LBRACE_LBRACE] = ACTIONS(17),
    [anon_sym_LBRACE_LBRACE_DASH] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE] = ACTIONS(23),
    [sym_number] = ACTIONS(187),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [sym_break_statement] = ACTIONS(189),
    [sym_continue_statement] = ACTIONS(189),
    [anon_sym_echo] = ACTIONS(47),
    [anon_sym_section] = ACTIONS(49),
    [anon_sym_sections] = ACTIONS(51),
    [anon_sym_increment] = ACTIONS(53),
    [anon_sym_decrement] = ACTIONS(55),
    [anon_sym_layout] = ACTIONS(57),
    [anon_sym_assign] = ACTIONS(59),
    [anon_sym_cycle] = ACTIONS(61),
    [anon_sym_include] = ACTIONS(63),
    [anon_sym_include_relative] = ACTIONS(63),
    [anon_sym_render] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(71),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_unless] = ACTIONS(79),
    [anon_sym_capture] = ACTIONS(83),
    [anon_sym_form] = ACTIONS(85),
    [anon_sym_tablerow] = ACTIONS(87),
    [anon_sym_paginate] = ACTIONS(89),
    [anon_sym_comment] = ACTIONS(191),
    [sym__inline_comment_content] = ACTIONS(193),
  },
  [10] = {
    [sym__liquid_node] = STATE(10),
    [sym__untagged_unpaired_statement] = STATE(1169),
    [sym__untagged_paired_statement] = STATE(1169),
    [sym__expression] = STATE(318),
    [sym__literal] = STATE(318),
    [sym_string] = STATE(318),
    [sym_boolean] = STATE(318),
    [sym_predicate] = STATE(318),
    [sym_echo_statement] = STATE(1169),
    [sym_section_statement] = STATE(1169),
    [sym_sections_statement] = STATE(1169),
    [sym_increment_statement] = STATE(1169),
    [sym_decrement_statement] = STATE(1169),
    [sym_layout_statement] = STATE(1169),
    [sym_custom_unpaired_statement] = STATE(1169),
    [sym_assignment_statement] = STATE(1169),
    [sym_cycle_statement] = STATE(1169),
    [sym_include_statement] = STATE(1169),
    [sym_render_statement] = STATE(1169),
    [sym_filter] = STATE(318),
    [sym_access] = STATE(277),
    [sym__if_liq] = STATE(1168),
    [sym__for_loop_liq] = STATE(1167),
    [sym__case_liq] = STATE(1165),
    [sym__unless_liq] = STATE(1163),
    [sym__capture_liq] = STATE(1162),
    [sym__form_liq] = STATE(1158),
    [sym__tablerow_liq] = STATE(1157),
    [sym__paginate_liq] = STATE(1155),
    [sym_comment_liq] = STATE(10),
    [sym__paired_comment_liq] = STATE(155),
    [aux_sym_liquid_tag_repeat1] = STATE(10),
    [sym_identifier] = ACTIONS(195),
    [anon_sym_PERCENT_RBRACE] = ACTIONS(198),
    [anon_sym_DASH_PERCENT_RBRACE] = ACTIONS(198),
    [anon_sym_LBRACE_LBRACE] = ACTIONS(200),
    [anon_sym_LBRACE_LBRACE_DASH] = ACTIONS(203),
    [anon_sym_SQUOTE] = ACTIONS(206),
    [anon_sym_DQUOTE] = ACTIONS(209),
    [sym_number] = ACTIONS(212),
    [anon_sym_true] = ACTIONS(215),
    [anon_sym_false] = ACTIONS(215),
    [sym_break_statement] = ACTIONS(218),
    [sym_continue_statement] = ACTIONS(218),
    [anon_sym_echo] = ACTIONS(221),
    [anon_sym_section] = ACTIONS(224),
    [anon_sym_sections] = ACTIONS(227),
    [anon_sym_increment] = ACTIONS(230),
    [anon_sym_decrement] = ACTIONS(233),
    [anon_sym_layout] = ACTIONS(236),
    [anon_sym_assign] = ACTIONS(239),
    [anon_sym_cycle] = ACTIONS(242),
    [anon_sym_include] = ACTIONS(245),
    [anon_sym_include_relative] = ACTIONS(245),
    [anon_sym_render] = ACTIONS(248),
    [anon_sym_for] = ACTIONS(251),
    [anon_sym_if] = ACTIONS(254),
    [anon_sym_case] = ACTIONS(257),
    [anon_sym_unless] = ACTIONS(260),
    [anon_sym_capture] = ACTIONS(263),
    [anon_sym_form] = ACTIONS(266),
    [anon_sym_tablerow] = ACTIONS(269),
    [anon_sym_paginate] = ACTIONS(272),
    [anon_sym_comment] = ACTIONS(275),
    [sym__inline_comment_content] = ACTIONS(278),
  },
  [11] = {
    [sym__liquid_node] = STATE(10),
    [sym__untagged_unpaired_statement] = STATE(1169),
    [sym__untagged_paired_statement] = STATE(1169),
    [sym__expression] = STATE(318),
    [sym__literal] = STATE(318),
    [sym_string] = STATE(318),
    [sym_boolean] = STATE(318),
    [sym_predicate] = STATE(318),
    [sym_echo_statement] = STATE(1169),
    [sym_section_statement] = STATE(1169),
    [sym_sections_statement] = STATE(1169),
    [sym_increment_statement] = STATE(1169),
    [sym_decrement_statement] = STATE(1169),
    [sym_layout_statement] = STATE(1169),
    [sym_custom_unpaired_statement] = STATE(1169),
    [sym_assignment_statement] = STATE(1169),
    [sym_cycle_statement] = STATE(1169),
    [sym_include_statement] = STATE(1169),
    [sym_render_statement] = STATE(1169),
    [sym_filter] = STATE(318),
    [sym_access] = STATE(277),
    [sym__if_liq] = STATE(1168),
    [sym__for_loop_liq] = STATE(1167),
    [sym__case_liq] = STATE(1165),
    [sym__unless_liq] = STATE(1163),
    [sym__capture_liq] = STATE(1162),
    [sym__form_liq] = STATE(1158),
    [sym__tablerow_liq] = STATE(1157),
    [sym__paginate_liq] = STATE(1155),
    [sym_comment_liq] = STATE(10),
    [sym__paired_comment_liq] = STATE(155),
    [aux_sym_liquid_tag_repeat1] = STATE(10),
    [sym_identifier] = ACTIONS(15),
    [anon_sym_PERCENT_RBRACE] = ACTIONS(281),
    [anon_sym_DASH_PERCENT_RBRACE] = ACTIONS(281),
    [anon_sym_LBRACE_LBRACE] = ACTIONS(17),
    [anon_sym_LBRACE_LBRACE_DASH] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE] = ACTIONS(23),
    [sym_number] = ACTIONS(187),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [sym_break_statement] = ACTIONS(189),
    [sym_continue_statement] = ACTIONS(189),
    [anon_sym_echo] = ACTIONS(47),
    [anon_sym_section] = ACTIONS(49),
    [anon_sym_sections] = ACTIONS(51),
    [anon_sym_increment] = ACTIONS(53),
    [anon_sym_decrement] = ACTIONS(55),
    [anon_sym_layout] = ACTIONS(57),
    [anon_sym_assign] = ACTIONS(59),
    [anon_sym_cycle] = ACTIONS(61),
    [anon_sym_include] = ACTIONS(63),
    [anon_sym_include_relative] = ACTIONS(63),
    [anon_sym_render] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(71),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_unless] = ACTIONS(79),
    [anon_sym_capture] = ACTIONS(83),
    [anon_sym_form] = ACTIONS(85),
    [anon_sym_tablerow] = ACTIONS(87),
    [anon_sym_paginate] = ACTIONS(89),
    [anon_sym_comment] = ACTIONS(191),
    [sym__inline_comment_content] = ACTIONS(193),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 40,
    ACTIONS(15), 1,
      sym_identifier,
    ACTIONS(17), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(19), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(21), 1,
      anon_sym_SQUOTE,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    ACTIONS(25), 1,
      sym_number,
    ACTIONS(47), 1,
      anon_sym_echo,
    ACTIONS(49), 1,
      anon_sym_section,
    ACTIONS(51), 1,
      anon_sym_sections,
    ACTIONS(53), 1,
      anon_sym_increment,
    ACTIONS(55), 1,
      anon_sym_decrement,
    ACTIONS(57), 1,
      anon_sym_layout,
    ACTIONS(59), 1,
      anon_sym_assign,
    ACTIONS(61), 1,
      anon_sym_cycle,
    ACTIONS(65), 1,
      anon_sym_render,
    ACTIONS(67), 1,
      anon_sym_for,
    ACTIONS(71), 1,
      anon_sym_if,
    ACTIONS(77), 1,
      anon_sym_case,
    ACTIONS(79), 1,
      anon_sym_unless,
    ACTIONS(83), 1,
      anon_sym_capture,
    ACTIONS(85), 1,
      anon_sym_form,
    ACTIONS(87), 1,
      anon_sym_tablerow,
    ACTIONS(89), 1,
      anon_sym_paginate,
    STATE(15), 1,
      aux_sym__if_liq_repeat1,
    STATE(135), 1,
      sym__liquid_node,
    STATE(277), 1,
      sym_access,
    STATE(1155), 1,
      sym__paginate_liq,
    STATE(1157), 1,
      sym__tablerow_liq,
    STATE(1158), 1,
      sym__form_liq,
    STATE(1162), 1,
      sym__capture_liq,
    STATE(1163), 1,
      sym__unless_liq,
    STATE(1165), 1,
      sym__case_liq,
    STATE(1167), 1,
      sym__for_loop_liq,
    STATE(1168), 1,
      sym__if_liq,
    ACTIONS(27), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(45), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(63), 2,
      anon_sym_include,
      anon_sym_include_relative,
    ACTIONS(283), 4,
      anon_sym_endif,
      anon_sym_endfor,
      anon_sym_endcase,
      anon_sym_endunless,
    STATE(316), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
    STATE(1108), 13,
      sym__untagged_unpaired_statement,
      sym__untagged_paired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [144] = 42,
    ACTIONS(15), 1,
      sym_identifier,
    ACTIONS(17), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(19), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(21), 1,
      anon_sym_SQUOTE,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    ACTIONS(25), 1,
      sym_number,
    ACTIONS(47), 1,
      anon_sym_echo,
    ACTIONS(49), 1,
      anon_sym_section,
    ACTIONS(51), 1,
      anon_sym_sections,
    ACTIONS(53), 1,
      anon_sym_increment,
    ACTIONS(55), 1,
      anon_sym_decrement,
    ACTIONS(57), 1,
      anon_sym_layout,
    ACTIONS(59), 1,
      anon_sym_assign,
    ACTIONS(61), 1,
      anon_sym_cycle,
    ACTIONS(65), 1,
      anon_sym_render,
    ACTIONS(67), 1,
      anon_sym_for,
    ACTIONS(71), 1,
      anon_sym_if,
    ACTIONS(75), 1,
      anon_sym_else,
    ACTIONS(77), 1,
      anon_sym_case,
    ACTIONS(79), 1,
      anon_sym_unless,
    ACTIONS(83), 1,
      anon_sym_capture,
    ACTIONS(85), 1,
      anon_sym_form,
    ACTIONS(87), 1,
      anon_sym_tablerow,
    ACTIONS(89), 1,
      anon_sym_paginate,
    ACTIONS(285), 1,
      anon_sym_endfor,
    STATE(6), 1,
      aux_sym__if_liq_repeat1,
    STATE(135), 1,
      sym__liquid_node,
    STATE(277), 1,
      sym_access,
    STATE(1155), 1,
      sym__paginate_liq,
    STATE(1157), 1,
      sym__tablerow_liq,
    STATE(1158), 1,
      sym__form_liq,
    STATE(1162), 1,
      sym__capture_liq,
    STATE(1163), 1,
      sym__unless_liq,
    STATE(1165), 1,
      sym__case_liq,
    STATE(1167), 1,
      sym__for_loop_liq,
    STATE(1168), 1,
      sym__if_liq,
    ACTIONS(27), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(45), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(63), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(1217), 2,
      sym__else_liq,
      sym__else_aliased,
    STATE(316), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
    STATE(1108), 13,
      sym__untagged_unpaired_statement,
      sym__untagged_paired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [292] = 42,
    ACTIONS(15), 1,
      sym_identifier,
    ACTIONS(17), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(19), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(21), 1,
      anon_sym_SQUOTE,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    ACTIONS(25), 1,
      sym_number,
    ACTIONS(47), 1,
      anon_sym_echo,
    ACTIONS(49), 1,
      anon_sym_section,
    ACTIONS(51), 1,
      anon_sym_sections,
    ACTIONS(53), 1,
      anon_sym_increment,
    ACTIONS(55), 1,
      anon_sym_decrement,
    ACTIONS(57), 1,
      anon_sym_layout,
    ACTIONS(59), 1,
      anon_sym_assign,
    ACTIONS(61), 1,
      anon_sym_cycle,
    ACTIONS(65), 1,
      anon_sym_render,
    ACTIONS(67), 1,
      anon_sym_for,
    ACTIONS(71), 1,
      anon_sym_if,
    ACTIONS(75), 1,
      anon_sym_else,
    ACTIONS(77), 1,
      anon_sym_case,
    ACTIONS(79), 1,
      anon_sym_unless,
    ACTIONS(83), 1,
      anon_sym_capture,
    ACTIONS(85), 1,
      anon_sym_form,
    ACTIONS(87), 1,
      anon_sym_tablerow,
    ACTIONS(89), 1,
      anon_sym_paginate,
    ACTIONS(287), 1,
      anon_sym_endfor,
    STATE(13), 1,
      aux_sym__if_liq_repeat1,
    STATE(135), 1,
      sym__liquid_node,
    STATE(277), 1,
      sym_access,
    STATE(1155), 1,
      sym__paginate_liq,
    STATE(1157), 1,
      sym__tablerow_liq,
    STATE(1158), 1,
      sym__form_liq,
    STATE(1162), 1,
      sym__capture_liq,
    STATE(1163), 1,
      sym__unless_liq,
    STATE(1165), 1,
      sym__case_liq,
    STATE(1167), 1,
      sym__for_loop_liq,
    STATE(1168), 1,
      sym__if_liq,
    ACTIONS(27), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(45), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(63), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(1180), 2,
      sym__else_liq,
      sym__else_aliased,
    STATE(316), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
    STATE(1108), 13,
      sym__untagged_unpaired_statement,
      sym__untagged_paired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [440] = 40,
    ACTIONS(15), 1,
      sym_identifier,
    ACTIONS(17), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(19), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(21), 1,
      anon_sym_SQUOTE,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    ACTIONS(25), 1,
      sym_number,
    ACTIONS(47), 1,
      anon_sym_echo,
    ACTIONS(49), 1,
      anon_sym_section,
    ACTIONS(51), 1,
      anon_sym_sections,
    ACTIONS(53), 1,
      anon_sym_increment,
    ACTIONS(55), 1,
      anon_sym_decrement,
    ACTIONS(57), 1,
      anon_sym_layout,
    ACTIONS(59), 1,
      anon_sym_assign,
    ACTIONS(61), 1,
      anon_sym_cycle,
    ACTIONS(65), 1,
      anon_sym_render,
    ACTIONS(67), 1,
      anon_sym_for,
    ACTIONS(71), 1,
      anon_sym_if,
    ACTIONS(77), 1,
      anon_sym_case,
    ACTIONS(79), 1,
      anon_sym_unless,
    ACTIONS(83), 1,
      anon_sym_capture,
    ACTIONS(85), 1,
      anon_sym_form,
    ACTIONS(87), 1,
      anon_sym_tablerow,
    ACTIONS(89), 1,
      anon_sym_paginate,
    STATE(6), 1,
      aux_sym__if_liq_repeat1,
    STATE(135), 1,
      sym__liquid_node,
    STATE(277), 1,
      sym_access,
    STATE(1155), 1,
      sym__paginate_liq,
    STATE(1157), 1,
      sym__tablerow_liq,
    STATE(1158), 1,
      sym__form_liq,
    STATE(1162), 1,
      sym__capture_liq,
    STATE(1163), 1,
      sym__unless_liq,
    STATE(1165), 1,
      sym__case_liq,
    STATE(1167), 1,
      sym__for_loop_liq,
    STATE(1168), 1,
      sym__if_liq,
    ACTIONS(27), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(45), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(63), 2,
      anon_sym_include,
      anon_sym_include_relative,
    ACTIONS(289), 4,
      anon_sym_endif,
      anon_sym_endfor,
      anon_sym_endcase,
      anon_sym_endunless,
    STATE(316), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
    STATE(1108), 13,
      sym__untagged_unpaired_statement,
      sym__untagged_paired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [584] = 43,
    ACTIONS(15), 1,
      sym_identifier,
    ACTIONS(17), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(19), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(21), 1,
      anon_sym_SQUOTE,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    ACTIONS(25), 1,
      sym_number,
    ACTIONS(47), 1,
      anon_sym_echo,
    ACTIONS(49), 1,
      anon_sym_section,
    ACTIONS(51), 1,
      anon_sym_sections,
    ACTIONS(53), 1,
      anon_sym_increment,
    ACTIONS(55), 1,
      anon_sym_decrement,
    ACTIONS(57), 1,
      anon_sym_layout,
    ACTIONS(59), 1,
      anon_sym_assign,
    ACTIONS(61), 1,
      anon_sym_cycle,
    ACTIONS(65), 1,
      anon_sym_render,
    ACTIONS(67), 1,
      anon_sym_for,
    ACTIONS(71), 1,
      anon_sym_if,
    ACTIONS(77), 1,
      anon_sym_case,
    ACTIONS(79), 1,
      anon_sym_unless,
    ACTIONS(83), 1,
      anon_sym_capture,
    ACTIONS(85), 1,
      anon_sym_form,
    ACTIONS(87), 1,
      anon_sym_tablerow,
    ACTIONS(89), 1,
      anon_sym_paginate,
    ACTIONS(291), 1,
      anon_sym_COMMA,
    ACTIONS(293), 1,
      anon_sym_DOT,
    ACTIONS(295), 1,
      anon_sym_LBRACK,
    ACTIONS(297), 1,
      anon_sym_endform,
    STATE(33), 1,
      aux_sym__if_liq_repeat1,
    STATE(135), 1,
      sym__liquid_node,
    STATE(277), 1,
      sym_access,
    STATE(1155), 1,
      sym__paginate_liq,
    STATE(1157), 1,
      sym__tablerow_liq,
    STATE(1158), 1,
      sym__form_liq,
    STATE(1162), 1,
      sym__capture_liq,
    STATE(1163), 1,
      sym__unless_liq,
    STATE(1165), 1,
      sym__case_liq,
    STATE(1167), 1,
      sym__for_loop_liq,
    STATE(1168), 1,
      sym__if_liq,
    ACTIONS(27), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(45), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(63), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(316), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
    STATE(1108), 13,
      sym__untagged_unpaired_statement,
      sym__untagged_paired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [734] = 40,
    ACTIONS(15), 1,
      sym_identifier,
    ACTIONS(17), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(19), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(21), 1,
      anon_sym_SQUOTE,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    ACTIONS(25), 1,
      sym_number,
    ACTIONS(47), 1,
      anon_sym_echo,
    ACTIONS(49), 1,
      anon_sym_section,
    ACTIONS(51), 1,
      anon_sym_sections,
    ACTIONS(53), 1,
      anon_sym_increment,
    ACTIONS(55), 1,
      anon_sym_decrement,
    ACTIONS(57), 1,
      anon_sym_layout,
    ACTIONS(59), 1,
      anon_sym_assign,
    ACTIONS(61), 1,
      anon_sym_cycle,
    ACTIONS(65), 1,
      anon_sym_render,
    ACTIONS(67), 1,
      anon_sym_for,
    ACTIONS(71), 1,
      anon_sym_if,
    ACTIONS(77), 1,
      anon_sym_case,
    ACTIONS(79), 1,
      anon_sym_unless,
    ACTIONS(83), 1,
      anon_sym_capture,
    ACTIONS(85), 1,
      anon_sym_form,
    ACTIONS(87), 1,
      anon_sym_tablerow,
    ACTIONS(89), 1,
      anon_sym_paginate,
    STATE(6), 1,
      aux_sym__if_liq_repeat1,
    STATE(135), 1,
      sym__liquid_node,
    STATE(277), 1,
      sym_access,
    STATE(1155), 1,
      sym__paginate_liq,
    STATE(1157), 1,
      sym__tablerow_liq,
    STATE(1158), 1,
      sym__form_liq,
    STATE(1162), 1,
      sym__capture_liq,
    STATE(1163), 1,
      sym__unless_liq,
    STATE(1165), 1,
      sym__case_liq,
    STATE(1167), 1,
      sym__for_loop_liq,
    STATE(1168), 1,
      sym__if_liq,
    ACTIONS(27), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(45), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(63), 2,
      anon_sym_include,
      anon_sym_include_relative,
    ACTIONS(299), 4,
      anon_sym_endif,
      anon_sym_elsif,
      anon_sym_else,
      anon_sym_endunless,
    STATE(316), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
    STATE(1108), 13,
      sym__untagged_unpaired_statement,
      sym__untagged_paired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [878] = 40,
    ACTIONS(15), 1,
      sym_identifier,
    ACTIONS(17), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(19), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(21), 1,
      anon_sym_SQUOTE,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    ACTIONS(25), 1,
      sym_number,
    ACTIONS(47), 1,
      anon_sym_echo,
    ACTIONS(49), 1,
      anon_sym_section,
    ACTIONS(51), 1,
      anon_sym_sections,
    ACTIONS(53), 1,
      anon_sym_increment,
    ACTIONS(55), 1,
      anon_sym_decrement,
    ACTIONS(57), 1,
      anon_sym_layout,
    ACTIONS(59), 1,
      anon_sym_assign,
    ACTIONS(61), 1,
      anon_sym_cycle,
    ACTIONS(65), 1,
      anon_sym_render,
    ACTIONS(67), 1,
      anon_sym_for,
    ACTIONS(71), 1,
      anon_sym_if,
    ACTIONS(77), 1,
      anon_sym_case,
    ACTIONS(79), 1,
      anon_sym_unless,
    ACTIONS(83), 1,
      anon_sym_capture,
    ACTIONS(85), 1,
      anon_sym_form,
    ACTIONS(87), 1,
      anon_sym_tablerow,
    ACTIONS(89), 1,
      anon_sym_paginate,
    STATE(19), 1,
      aux_sym__if_liq_repeat1,
    STATE(135), 1,
      sym__liquid_node,
    STATE(277), 1,
      sym_access,
    STATE(1155), 1,
      sym__paginate_liq,
    STATE(1157), 1,
      sym__tablerow_liq,
    STATE(1158), 1,
      sym__form_liq,
    STATE(1162), 1,
      sym__capture_liq,
    STATE(1163), 1,
      sym__unless_liq,
    STATE(1165), 1,
      sym__case_liq,
    STATE(1167), 1,
      sym__for_loop_liq,
    STATE(1168), 1,
      sym__if_liq,
    ACTIONS(27), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(45), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(63), 2,
      anon_sym_include,
      anon_sym_include_relative,
    ACTIONS(99), 3,
      anon_sym_else,
      anon_sym_endcase,
      anon_sym_when,
    STATE(316), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
    STATE(1108), 13,
      sym__untagged_unpaired_statement,
      sym__untagged_paired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [1021] = 40,
    ACTIONS(15), 1,
      sym_identifier,
    ACTIONS(17), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(19), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(21), 1,
      anon_sym_SQUOTE,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    ACTIONS(25), 1,
      sym_number,
    ACTIONS(47), 1,
      anon_sym_echo,
    ACTIONS(49), 1,
      anon_sym_section,
    ACTIONS(51), 1,
      anon_sym_sections,
    ACTIONS(53), 1,
      anon_sym_increment,
    ACTIONS(55), 1,
      anon_sym_decrement,
    ACTIONS(57), 1,
      anon_sym_layout,
    ACTIONS(59), 1,
      anon_sym_assign,
    ACTIONS(61), 1,
      anon_sym_cycle,
    ACTIONS(65), 1,
      anon_sym_render,
    ACTIONS(67), 1,
      anon_sym_for,
    ACTIONS(71), 1,
      anon_sym_if,
    ACTIONS(77), 1,
      anon_sym_case,
    ACTIONS(79), 1,
      anon_sym_unless,
    ACTIONS(83), 1,
      anon_sym_capture,
    ACTIONS(85), 1,
      anon_sym_form,
    ACTIONS(87), 1,
      anon_sym_tablerow,
    ACTIONS(89), 1,
      anon_sym_paginate,
    STATE(6), 1,
      aux_sym__if_liq_repeat1,
    STATE(135), 1,
      sym__liquid_node,
    STATE(277), 1,
      sym_access,
    STATE(1155), 1,
      sym__paginate_liq,
    STATE(1157), 1,
      sym__tablerow_liq,
    STATE(1158), 1,
      sym__form_liq,
    STATE(1162), 1,
      sym__capture_liq,
    STATE(1163), 1,
      sym__unless_liq,
    STATE(1165), 1,
      sym__case_liq,
    STATE(1167), 1,
      sym__for_loop_liq,
    STATE(1168), 1,
      sym__if_liq,
    ACTIONS(27), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(45), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(63), 2,
      anon_sym_include,
      anon_sym_include_relative,
    ACTIONS(301), 3,
      anon_sym_else,
      anon_sym_endcase,
      anon_sym_when,
    STATE(316), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
    STATE(1108), 13,
      sym__untagged_unpaired_statement,
      sym__untagged_paired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [1164] = 6,
    ACTIONS(293), 1,
      anon_sym_DOT,
    ACTIONS(295), 1,
      anon_sym_LBRACK,
    ACTIONS(307), 1,
      anon_sym_COMMA,
    STATE(37), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(305), 15,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
    ACTIONS(303), 42,
      anon_sym_LBRACE_LBRACE,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_echo,
      anon_sym_section,
      anon_sym_sections,
      anon_sym_increment,
      anon_sym_decrement,
      anon_sym_layout,
      anon_sym_assign,
      anon_sym_cycle,
      anon_sym_include,
      anon_sym_include_relative,
      anon_sym_render,
      anon_sym_for,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_elsif,
      anon_sym_else,
      anon_sym_endfor,
      anon_sym_case,
      anon_sym_endcase,
      anon_sym_when,
      anon_sym_unless,
      anon_sym_endunless,
      anon_sym_capture,
      anon_sym_form,
      anon_sym_endform,
      anon_sym_tablerow,
      anon_sym_endtablerow,
      anon_sym_paginate,
      anon_sym_endpaginate,
  [1238] = 41,
    ACTIONS(15), 1,
      sym_identifier,
    ACTIONS(17), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(19), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(21), 1,
      anon_sym_SQUOTE,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    ACTIONS(25), 1,
      sym_number,
    ACTIONS(47), 1,
      anon_sym_echo,
    ACTIONS(49), 1,
      anon_sym_section,
    ACTIONS(51), 1,
      anon_sym_sections,
    ACTIONS(53), 1,
      anon_sym_increment,
    ACTIONS(55), 1,
      anon_sym_decrement,
    ACTIONS(57), 1,
      anon_sym_layout,
    ACTIONS(59), 1,
      anon_sym_assign,
    ACTIONS(61), 1,
      anon_sym_cycle,
    ACTIONS(65), 1,
      anon_sym_render,
    ACTIONS(67), 1,
      anon_sym_for,
    ACTIONS(71), 1,
      anon_sym_if,
    ACTIONS(77), 1,
      anon_sym_case,
    ACTIONS(79), 1,
      anon_sym_unless,
    ACTIONS(83), 1,
      anon_sym_capture,
    ACTIONS(85), 1,
      anon_sym_form,
    ACTIONS(87), 1,
      anon_sym_tablerow,
    ACTIONS(89), 1,
      anon_sym_paginate,
    ACTIONS(291), 1,
      anon_sym_COMMA,
    ACTIONS(297), 1,
      anon_sym_endform,
    STATE(33), 1,
      aux_sym__if_liq_repeat1,
    STATE(135), 1,
      sym__liquid_node,
    STATE(277), 1,
      sym_access,
    STATE(1155), 1,
      sym__paginate_liq,
    STATE(1157), 1,
      sym__tablerow_liq,
    STATE(1158), 1,
      sym__form_liq,
    STATE(1162), 1,
      sym__capture_liq,
    STATE(1163), 1,
      sym__unless_liq,
    STATE(1165), 1,
      sym__case_liq,
    STATE(1167), 1,
      sym__for_loop_liq,
    STATE(1168), 1,
      sym__if_liq,
    ACTIONS(27), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(45), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(63), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(316), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
    STATE(1108), 13,
      sym__untagged_unpaired_statement,
      sym__untagged_paired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [1382] = 5,
    ACTIONS(293), 1,
      anon_sym_DOT,
    ACTIONS(295), 1,
      anon_sym_LBRACK,
    ACTIONS(313), 1,
      anon_sym_COLON,
    ACTIONS(311), 16,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_COMMA,
      anon_sym_PIPE,
    ACTIONS(309), 42,
      anon_sym_LBRACE_LBRACE,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_echo,
      anon_sym_section,
      anon_sym_sections,
      anon_sym_increment,
      anon_sym_decrement,
      anon_sym_layout,
      anon_sym_assign,
      anon_sym_cycle,
      anon_sym_include,
      anon_sym_include_relative,
      anon_sym_render,
      anon_sym_for,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_elsif,
      anon_sym_else,
      anon_sym_endfor,
      anon_sym_case,
      anon_sym_endcase,
      anon_sym_when,
      anon_sym_unless,
      anon_sym_endunless,
      anon_sym_capture,
      anon_sym_form,
      anon_sym_endform,
      anon_sym_tablerow,
      anon_sym_endtablerow,
      anon_sym_paginate,
      anon_sym_endpaginate,
  [1454] = 40,
    ACTIONS(15), 1,
      sym_identifier,
    ACTIONS(17), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(19), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(21), 1,
      anon_sym_SQUOTE,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    ACTIONS(25), 1,
      sym_number,
    ACTIONS(47), 1,
      anon_sym_echo,
    ACTIONS(49), 1,
      anon_sym_section,
    ACTIONS(51), 1,
      anon_sym_sections,
    ACTIONS(53), 1,
      anon_sym_increment,
    ACTIONS(55), 1,
      anon_sym_decrement,
    ACTIONS(57), 1,
      anon_sym_layout,
    ACTIONS(59), 1,
      anon_sym_assign,
    ACTIONS(61), 1,
      anon_sym_cycle,
    ACTIONS(65), 1,
      anon_sym_render,
    ACTIONS(67), 1,
      anon_sym_for,
    ACTIONS(71), 1,
      anon_sym_if,
    ACTIONS(77), 1,
      anon_sym_case,
    ACTIONS(79), 1,
      anon_sym_unless,
    ACTIONS(83), 1,
      anon_sym_capture,
    ACTIONS(85), 1,
      anon_sym_form,
    ACTIONS(87), 1,
      anon_sym_tablerow,
    ACTIONS(89), 1,
      anon_sym_paginate,
    ACTIONS(315), 1,
      anon_sym_endtablerow,
    STATE(29), 1,
      aux_sym__if_liq_repeat1,
    STATE(135), 1,
      sym__liquid_node,
    STATE(277), 1,
      sym_access,
    STATE(1155), 1,
      sym__paginate_liq,
    STATE(1157), 1,
      sym__tablerow_liq,
    STATE(1158), 1,
      sym__form_liq,
    STATE(1162), 1,
      sym__capture_liq,
    STATE(1163), 1,
      sym__unless_liq,
    STATE(1165), 1,
      sym__case_liq,
    STATE(1167), 1,
      sym__for_loop_liq,
    STATE(1168), 1,
      sym__if_liq,
    ACTIONS(27), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(45), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(63), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(316), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
    STATE(1108), 13,
      sym__untagged_unpaired_statement,
      sym__untagged_paired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [1595] = 40,
    ACTIONS(15), 1,
      sym_identifier,
    ACTIONS(17), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(19), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(21), 1,
      anon_sym_SQUOTE,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    ACTIONS(25), 1,
      sym_number,
    ACTIONS(47), 1,
      anon_sym_echo,
    ACTIONS(49), 1,
      anon_sym_section,
    ACTIONS(51), 1,
      anon_sym_sections,
    ACTIONS(53), 1,
      anon_sym_increment,
    ACTIONS(55), 1,
      anon_sym_decrement,
    ACTIONS(57), 1,
      anon_sym_layout,
    ACTIONS(59), 1,
      anon_sym_assign,
    ACTIONS(61), 1,
      anon_sym_cycle,
    ACTIONS(65), 1,
      anon_sym_render,
    ACTIONS(67), 1,
      anon_sym_for,
    ACTIONS(71), 1,
      anon_sym_if,
    ACTIONS(77), 1,
      anon_sym_case,
    ACTIONS(79), 1,
      anon_sym_unless,
    ACTIONS(83), 1,
      anon_sym_capture,
    ACTIONS(85), 1,
      anon_sym_form,
    ACTIONS(87), 1,
      anon_sym_tablerow,
    ACTIONS(89), 1,
      anon_sym_paginate,
    ACTIONS(317), 1,
      anon_sym_endform,
    STATE(30), 1,
      aux_sym__if_liq_repeat1,
    STATE(135), 1,
      sym__liquid_node,
    STATE(277), 1,
      sym_access,
    STATE(1155), 1,
      sym__paginate_liq,
    STATE(1157), 1,
      sym__tablerow_liq,
    STATE(1158), 1,
      sym__form_liq,
    STATE(1162), 1,
      sym__capture_liq,
    STATE(1163), 1,
      sym__unless_liq,
    STATE(1165), 1,
      sym__case_liq,
    STATE(1167), 1,
      sym__for_loop_liq,
    STATE(1168), 1,
      sym__if_liq,
    ACTIONS(27), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(45), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(63), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(316), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
    STATE(1108), 13,
      sym__untagged_unpaired_statement,
      sym__untagged_paired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [1736] = 4,
    ACTIONS(293), 1,
      anon_sym_DOT,
    ACTIONS(295), 1,
      anon_sym_LBRACK,
    ACTIONS(311), 16,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_COMMA,
      anon_sym_PIPE,
    ACTIONS(309), 42,
      anon_sym_LBRACE_LBRACE,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_echo,
      anon_sym_section,
      anon_sym_sections,
      anon_sym_increment,
      anon_sym_decrement,
      anon_sym_layout,
      anon_sym_assign,
      anon_sym_cycle,
      anon_sym_include,
      anon_sym_include_relative,
      anon_sym_render,
      anon_sym_for,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_elsif,
      anon_sym_else,
      anon_sym_endfor,
      anon_sym_case,
      anon_sym_endcase,
      anon_sym_when,
      anon_sym_unless,
      anon_sym_endunless,
      anon_sym_capture,
      anon_sym_form,
      anon_sym_endform,
      anon_sym_tablerow,
      anon_sym_endtablerow,
      anon_sym_paginate,
      anon_sym_endpaginate,
  [1805] = 4,
    ACTIONS(293), 1,
      anon_sym_DOT,
    ACTIONS(295), 1,
      anon_sym_LBRACK,
    ACTIONS(321), 16,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_COMMA,
      anon_sym_PIPE,
    ACTIONS(319), 42,
      anon_sym_LBRACE_LBRACE,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_echo,
      anon_sym_section,
      anon_sym_sections,
      anon_sym_increment,
      anon_sym_decrement,
      anon_sym_layout,
      anon_sym_assign,
      anon_sym_cycle,
      anon_sym_include,
      anon_sym_include_relative,
      anon_sym_render,
      anon_sym_for,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_elsif,
      anon_sym_else,
      anon_sym_endfor,
      anon_sym_case,
      anon_sym_endcase,
      anon_sym_when,
      anon_sym_unless,
      anon_sym_endunless,
      anon_sym_capture,
      anon_sym_form,
      anon_sym_endform,
      anon_sym_tablerow,
      anon_sym_endtablerow,
      anon_sym_paginate,
      anon_sym_endpaginate,
  [1874] = 40,
    ACTIONS(15), 1,
      sym_identifier,
    ACTIONS(17), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(19), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(21), 1,
      anon_sym_SQUOTE,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    ACTIONS(25), 1,
      sym_number,
    ACTIONS(47), 1,
      anon_sym_echo,
    ACTIONS(49), 1,
      anon_sym_section,
    ACTIONS(51), 1,
      anon_sym_sections,
    ACTIONS(53), 1,
      anon_sym_increment,
    ACTIONS(55), 1,
      anon_sym_decrement,
    ACTIONS(57), 1,
      anon_sym_layout,
    ACTIONS(59), 1,
      anon_sym_assign,
    ACTIONS(61), 1,
      anon_sym_cycle,
    ACTIONS(65), 1,
      anon_sym_render,
    ACTIONS(67), 1,
      anon_sym_for,
    ACTIONS(71), 1,
      anon_sym_if,
    ACTIONS(77), 1,
      anon_sym_case,
    ACTIONS(79), 1,
      anon_sym_unless,
    ACTIONS(83), 1,
      anon_sym_capture,
    ACTIONS(85), 1,
      anon_sym_form,
    ACTIONS(87), 1,
      anon_sym_tablerow,
    ACTIONS(89), 1,
      anon_sym_paginate,
    ACTIONS(323), 1,
      anon_sym_endcapture,
    STATE(6), 1,
      aux_sym__if_liq_repeat1,
    STATE(135), 1,
      sym__liquid_node,
    STATE(277), 1,
      sym_access,
    STATE(1155), 1,
      sym__paginate_liq,
    STATE(1157), 1,
      sym__tablerow_liq,
    STATE(1158), 1,
      sym__form_liq,
    STATE(1162), 1,
      sym__capture_liq,
    STATE(1163), 1,
      sym__unless_liq,
    STATE(1165), 1,
      sym__case_liq,
    STATE(1167), 1,
      sym__for_loop_liq,
    STATE(1168), 1,
      sym__if_liq,
    ACTIONS(27), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(45), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(63), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(316), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
    STATE(1108), 13,
      sym__untagged_unpaired_statement,
      sym__untagged_paired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [2015] = 40,
    ACTIONS(15), 1,
      sym_identifier,
    ACTIONS(17), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(19), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(21), 1,
      anon_sym_SQUOTE,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    ACTIONS(25), 1,
      sym_number,
    ACTIONS(47), 1,
      anon_sym_echo,
    ACTIONS(49), 1,
      anon_sym_section,
    ACTIONS(51), 1,
      anon_sym_sections,
    ACTIONS(53), 1,
      anon_sym_increment,
    ACTIONS(55), 1,
      anon_sym_decrement,
    ACTIONS(57), 1,
      anon_sym_layout,
    ACTIONS(59), 1,
      anon_sym_assign,
    ACTIONS(61), 1,
      anon_sym_cycle,
    ACTIONS(65), 1,
      anon_sym_render,
    ACTIONS(67), 1,
      anon_sym_for,
    ACTIONS(71), 1,
      anon_sym_if,
    ACTIONS(77), 1,
      anon_sym_case,
    ACTIONS(79), 1,
      anon_sym_unless,
    ACTIONS(83), 1,
      anon_sym_capture,
    ACTIONS(85), 1,
      anon_sym_form,
    ACTIONS(87), 1,
      anon_sym_tablerow,
    ACTIONS(89), 1,
      anon_sym_paginate,
    ACTIONS(325), 1,
      anon_sym_endpaginate,
    STATE(6), 1,
      aux_sym__if_liq_repeat1,
    STATE(135), 1,
      sym__liquid_node,
    STATE(277), 1,
      sym_access,
    STATE(1155), 1,
      sym__paginate_liq,
    STATE(1157), 1,
      sym__tablerow_liq,
    STATE(1158), 1,
      sym__form_liq,
    STATE(1162), 1,
      sym__capture_liq,
    STATE(1163), 1,
      sym__unless_liq,
    STATE(1165), 1,
      sym__case_liq,
    STATE(1167), 1,
      sym__for_loop_liq,
    STATE(1168), 1,
      sym__if_liq,
    ACTIONS(27), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(45), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(63), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(316), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
    STATE(1108), 13,
      sym__untagged_unpaired_statement,
      sym__untagged_paired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [2156] = 40,
    ACTIONS(15), 1,
      sym_identifier,
    ACTIONS(17), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(19), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(21), 1,
      anon_sym_SQUOTE,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    ACTIONS(25), 1,
      sym_number,
    ACTIONS(47), 1,
      anon_sym_echo,
    ACTIONS(49), 1,
      anon_sym_section,
    ACTIONS(51), 1,
      anon_sym_sections,
    ACTIONS(53), 1,
      anon_sym_increment,
    ACTIONS(55), 1,
      anon_sym_decrement,
    ACTIONS(57), 1,
      anon_sym_layout,
    ACTIONS(59), 1,
      anon_sym_assign,
    ACTIONS(61), 1,
      anon_sym_cycle,
    ACTIONS(65), 1,
      anon_sym_render,
    ACTIONS(67), 1,
      anon_sym_for,
    ACTIONS(71), 1,
      anon_sym_if,
    ACTIONS(77), 1,
      anon_sym_case,
    ACTIONS(79), 1,
      anon_sym_unless,
    ACTIONS(83), 1,
      anon_sym_capture,
    ACTIONS(85), 1,
      anon_sym_form,
    ACTIONS(87), 1,
      anon_sym_tablerow,
    ACTIONS(89), 1,
      anon_sym_paginate,
    ACTIONS(327), 1,
      anon_sym_endtablerow,
    STATE(6), 1,
      aux_sym__if_liq_repeat1,
    STATE(135), 1,
      sym__liquid_node,
    STATE(277), 1,
      sym_access,
    STATE(1155), 1,
      sym__paginate_liq,
    STATE(1157), 1,
      sym__tablerow_liq,
    STATE(1158), 1,
      sym__form_liq,
    STATE(1162), 1,
      sym__capture_liq,
    STATE(1163), 1,
      sym__unless_liq,
    STATE(1165), 1,
      sym__case_liq,
    STATE(1167), 1,
      sym__for_loop_liq,
    STATE(1168), 1,
      sym__if_liq,
    ACTIONS(27), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(45), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(63), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(316), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
    STATE(1108), 13,
      sym__untagged_unpaired_statement,
      sym__untagged_paired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [2297] = 40,
    ACTIONS(15), 1,
      sym_identifier,
    ACTIONS(17), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(19), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(21), 1,
      anon_sym_SQUOTE,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    ACTIONS(25), 1,
      sym_number,
    ACTIONS(47), 1,
      anon_sym_echo,
    ACTIONS(49), 1,
      anon_sym_section,
    ACTIONS(51), 1,
      anon_sym_sections,
    ACTIONS(53), 1,
      anon_sym_increment,
    ACTIONS(55), 1,
      anon_sym_decrement,
    ACTIONS(57), 1,
      anon_sym_layout,
    ACTIONS(59), 1,
      anon_sym_assign,
    ACTIONS(61), 1,
      anon_sym_cycle,
    ACTIONS(65), 1,
      anon_sym_render,
    ACTIONS(67), 1,
      anon_sym_for,
    ACTIONS(71), 1,
      anon_sym_if,
    ACTIONS(77), 1,
      anon_sym_case,
    ACTIONS(79), 1,
      anon_sym_unless,
    ACTIONS(83), 1,
      anon_sym_capture,
    ACTIONS(85), 1,
      anon_sym_form,
    ACTIONS(87), 1,
      anon_sym_tablerow,
    ACTIONS(89), 1,
      anon_sym_paginate,
    ACTIONS(329), 1,
      anon_sym_endform,
    STATE(6), 1,
      aux_sym__if_liq_repeat1,
    STATE(135), 1,
      sym__liquid_node,
    STATE(277), 1,
      sym_access,
    STATE(1155), 1,
      sym__paginate_liq,
    STATE(1157), 1,
      sym__tablerow_liq,
    STATE(1158), 1,
      sym__form_liq,
    STATE(1162), 1,
      sym__capture_liq,
    STATE(1163), 1,
      sym__unless_liq,
    STATE(1165), 1,
      sym__case_liq,
    STATE(1167), 1,
      sym__for_loop_liq,
    STATE(1168), 1,
      sym__if_liq,
    ACTIONS(27), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(45), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(63), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(316), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
    STATE(1108), 13,
      sym__untagged_unpaired_statement,
      sym__untagged_paired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [2438] = 2,
    ACTIONS(333), 17,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_LBRACK,
    ACTIONS(331), 43,
      anon_sym_LBRACE_LBRACE,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_echo,
      anon_sym_section,
      anon_sym_sections,
      anon_sym_increment,
      anon_sym_decrement,
      anon_sym_layout,
      anon_sym_assign,
      anon_sym_cycle,
      anon_sym_include,
      anon_sym_include_relative,
      anon_sym_render,
      anon_sym_for,
      anon_sym_DOT,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_elsif,
      anon_sym_else,
      anon_sym_endfor,
      anon_sym_case,
      anon_sym_endcase,
      anon_sym_when,
      anon_sym_unless,
      anon_sym_endunless,
      anon_sym_capture,
      anon_sym_form,
      anon_sym_endform,
      anon_sym_tablerow,
      anon_sym_endtablerow,
      anon_sym_paginate,
      anon_sym_endpaginate,
  [2503] = 2,
    ACTIONS(337), 17,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_LBRACK,
    ACTIONS(335), 43,
      anon_sym_LBRACE_LBRACE,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_echo,
      anon_sym_section,
      anon_sym_sections,
      anon_sym_increment,
      anon_sym_decrement,
      anon_sym_layout,
      anon_sym_assign,
      anon_sym_cycle,
      anon_sym_include,
      anon_sym_include_relative,
      anon_sym_render,
      anon_sym_for,
      anon_sym_DOT,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_elsif,
      anon_sym_else,
      anon_sym_endfor,
      anon_sym_case,
      anon_sym_endcase,
      anon_sym_when,
      anon_sym_unless,
      anon_sym_endunless,
      anon_sym_capture,
      anon_sym_form,
      anon_sym_endform,
      anon_sym_tablerow,
      anon_sym_endtablerow,
      anon_sym_paginate,
      anon_sym_endpaginate,
  [2568] = 40,
    ACTIONS(15), 1,
      sym_identifier,
    ACTIONS(17), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(19), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(21), 1,
      anon_sym_SQUOTE,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    ACTIONS(25), 1,
      sym_number,
    ACTIONS(47), 1,
      anon_sym_echo,
    ACTIONS(49), 1,
      anon_sym_section,
    ACTIONS(51), 1,
      anon_sym_sections,
    ACTIONS(53), 1,
      anon_sym_increment,
    ACTIONS(55), 1,
      anon_sym_decrement,
    ACTIONS(57), 1,
      anon_sym_layout,
    ACTIONS(59), 1,
      anon_sym_assign,
    ACTIONS(61), 1,
      anon_sym_cycle,
    ACTIONS(65), 1,
      anon_sym_render,
    ACTIONS(67), 1,
      anon_sym_for,
    ACTIONS(71), 1,
      anon_sym_if,
    ACTIONS(77), 1,
      anon_sym_case,
    ACTIONS(79), 1,
      anon_sym_unless,
    ACTIONS(83), 1,
      anon_sym_capture,
    ACTIONS(85), 1,
      anon_sym_form,
    ACTIONS(87), 1,
      anon_sym_tablerow,
    ACTIONS(89), 1,
      anon_sym_paginate,
    ACTIONS(339), 1,
      anon_sym_endform,
    STATE(6), 1,
      aux_sym__if_liq_repeat1,
    STATE(135), 1,
      sym__liquid_node,
    STATE(277), 1,
      sym_access,
    STATE(1155), 1,
      sym__paginate_liq,
    STATE(1157), 1,
      sym__tablerow_liq,
    STATE(1158), 1,
      sym__form_liq,
    STATE(1162), 1,
      sym__capture_liq,
    STATE(1163), 1,
      sym__unless_liq,
    STATE(1165), 1,
      sym__case_liq,
    STATE(1167), 1,
      sym__for_loop_liq,
    STATE(1168), 1,
      sym__if_liq,
    ACTIONS(27), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(45), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(63), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(316), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
    STATE(1108), 13,
      sym__untagged_unpaired_statement,
      sym__untagged_paired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [2709] = 40,
    ACTIONS(15), 1,
      sym_identifier,
    ACTIONS(17), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(19), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(21), 1,
      anon_sym_SQUOTE,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    ACTIONS(25), 1,
      sym_number,
    ACTIONS(47), 1,
      anon_sym_echo,
    ACTIONS(49), 1,
      anon_sym_section,
    ACTIONS(51), 1,
      anon_sym_sections,
    ACTIONS(53), 1,
      anon_sym_increment,
    ACTIONS(55), 1,
      anon_sym_decrement,
    ACTIONS(57), 1,
      anon_sym_layout,
    ACTIONS(59), 1,
      anon_sym_assign,
    ACTIONS(61), 1,
      anon_sym_cycle,
    ACTIONS(65), 1,
      anon_sym_render,
    ACTIONS(67), 1,
      anon_sym_for,
    ACTIONS(71), 1,
      anon_sym_if,
    ACTIONS(77), 1,
      anon_sym_case,
    ACTIONS(79), 1,
      anon_sym_unless,
    ACTIONS(83), 1,
      anon_sym_capture,
    ACTIONS(85), 1,
      anon_sym_form,
    ACTIONS(87), 1,
      anon_sym_tablerow,
    ACTIONS(89), 1,
      anon_sym_paginate,
    ACTIONS(341), 1,
      anon_sym_endpaginate,
    STATE(28), 1,
      aux_sym__if_liq_repeat1,
    STATE(135), 1,
      sym__liquid_node,
    STATE(277), 1,
      sym_access,
    STATE(1155), 1,
      sym__paginate_liq,
    STATE(1157), 1,
      sym__tablerow_liq,
    STATE(1158), 1,
      sym__form_liq,
    STATE(1162), 1,
      sym__capture_liq,
    STATE(1163), 1,
      sym__unless_liq,
    STATE(1165), 1,
      sym__case_liq,
    STATE(1167), 1,
      sym__for_loop_liq,
    STATE(1168), 1,
      sym__if_liq,
    ACTIONS(27), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(45), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(63), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(316), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
    STATE(1108), 13,
      sym__untagged_unpaired_statement,
      sym__untagged_paired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [2850] = 40,
    ACTIONS(15), 1,
      sym_identifier,
    ACTIONS(17), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(19), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(21), 1,
      anon_sym_SQUOTE,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    ACTIONS(25), 1,
      sym_number,
    ACTIONS(47), 1,
      anon_sym_echo,
    ACTIONS(49), 1,
      anon_sym_section,
    ACTIONS(51), 1,
      anon_sym_sections,
    ACTIONS(53), 1,
      anon_sym_increment,
    ACTIONS(55), 1,
      anon_sym_decrement,
    ACTIONS(57), 1,
      anon_sym_layout,
    ACTIONS(59), 1,
      anon_sym_assign,
    ACTIONS(61), 1,
      anon_sym_cycle,
    ACTIONS(65), 1,
      anon_sym_render,
    ACTIONS(67), 1,
      anon_sym_for,
    ACTIONS(71), 1,
      anon_sym_if,
    ACTIONS(77), 1,
      anon_sym_case,
    ACTIONS(79), 1,
      anon_sym_unless,
    ACTIONS(83), 1,
      anon_sym_capture,
    ACTIONS(85), 1,
      anon_sym_form,
    ACTIONS(87), 1,
      anon_sym_tablerow,
    ACTIONS(89), 1,
      anon_sym_paginate,
    ACTIONS(343), 1,
      anon_sym_endcapture,
    STATE(27), 1,
      aux_sym__if_liq_repeat1,
    STATE(135), 1,
      sym__liquid_node,
    STATE(277), 1,
      sym_access,
    STATE(1155), 1,
      sym__paginate_liq,
    STATE(1157), 1,
      sym__tablerow_liq,
    STATE(1158), 1,
      sym__form_liq,
    STATE(1162), 1,
      sym__capture_liq,
    STATE(1163), 1,
      sym__unless_liq,
    STATE(1165), 1,
      sym__case_liq,
    STATE(1167), 1,
      sym__for_loop_liq,
    STATE(1168), 1,
      sym__if_liq,
    ACTIONS(27), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(45), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(63), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(316), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
    STATE(1108), 13,
      sym__untagged_unpaired_statement,
      sym__untagged_paired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [2991] = 4,
    ACTIONS(345), 1,
      anon_sym_COMMA,
    STATE(36), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(311), 15,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
    ACTIONS(309), 42,
      anon_sym_LBRACE_LBRACE,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_echo,
      anon_sym_section,
      anon_sym_sections,
      anon_sym_increment,
      anon_sym_decrement,
      anon_sym_layout,
      anon_sym_assign,
      anon_sym_cycle,
      anon_sym_include,
      anon_sym_include_relative,
      anon_sym_render,
      anon_sym_for,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_elsif,
      anon_sym_else,
      anon_sym_endfor,
      anon_sym_case,
      anon_sym_endcase,
      anon_sym_when,
      anon_sym_unless,
      anon_sym_endunless,
      anon_sym_capture,
      anon_sym_form,
      anon_sym_endform,
      anon_sym_tablerow,
      anon_sym_endtablerow,
      anon_sym_paginate,
      anon_sym_endpaginate,
  [3059] = 4,
    ACTIONS(307), 1,
      anon_sym_COMMA,
    STATE(36), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(350), 15,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
    ACTIONS(348), 42,
      anon_sym_LBRACE_LBRACE,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_echo,
      anon_sym_section,
      anon_sym_sections,
      anon_sym_increment,
      anon_sym_decrement,
      anon_sym_layout,
      anon_sym_assign,
      anon_sym_cycle,
      anon_sym_include,
      anon_sym_include_relative,
      anon_sym_render,
      anon_sym_for,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_elsif,
      anon_sym_else,
      anon_sym_endfor,
      anon_sym_case,
      anon_sym_endcase,
      anon_sym_when,
      anon_sym_unless,
      anon_sym_endunless,
      anon_sym_capture,
      anon_sym_form,
      anon_sym_endform,
      anon_sym_tablerow,
      anon_sym_endtablerow,
      anon_sym_paginate,
      anon_sym_endpaginate,
  [3127] = 4,
    ACTIONS(307), 1,
      anon_sym_COMMA,
    STATE(37), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(305), 15,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
    ACTIONS(303), 42,
      anon_sym_LBRACE_LBRACE,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_echo,
      anon_sym_section,
      anon_sym_sections,
      anon_sym_increment,
      anon_sym_decrement,
      anon_sym_layout,
      anon_sym_assign,
      anon_sym_cycle,
      anon_sym_include,
      anon_sym_include_relative,
      anon_sym_render,
      anon_sym_for,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_elsif,
      anon_sym_else,
      anon_sym_endfor,
      anon_sym_case,
      anon_sym_endcase,
      anon_sym_when,
      anon_sym_unless,
      anon_sym_endunless,
      anon_sym_capture,
      anon_sym_form,
      anon_sym_endform,
      anon_sym_tablerow,
      anon_sym_endtablerow,
      anon_sym_paginate,
      anon_sym_endpaginate,
  [3195] = 7,
    ACTIONS(293), 1,
      anon_sym_DOT,
    ACTIONS(295), 1,
      anon_sym_LBRACK,
    ACTIONS(307), 1,
      anon_sym_COMMA,
    ACTIONS(313), 1,
      anon_sym_COLON,
    STATE(37), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(305), 15,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
    ACTIONS(303), 39,
      anon_sym_LBRACE_LBRACE,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_echo,
      anon_sym_section,
      anon_sym_sections,
      anon_sym_increment,
      anon_sym_decrement,
      anon_sym_layout,
      anon_sym_assign,
      anon_sym_cycle,
      anon_sym_include,
      anon_sym_include_relative,
      anon_sym_render,
      anon_sym_for,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_elsif,
      anon_sym_else,
      anon_sym_case,
      anon_sym_endcase,
      anon_sym_when,
      anon_sym_unless,
      anon_sym_endunless,
      anon_sym_capture,
      anon_sym_form,
      anon_sym_endform,
      anon_sym_tablerow,
      anon_sym_paginate,
  [3269] = 2,
    ACTIONS(354), 16,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_COMMA,
      anon_sym_PIPE,
    ACTIONS(352), 42,
      anon_sym_LBRACE_LBRACE,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_echo,
      anon_sym_section,
      anon_sym_sections,
      anon_sym_increment,
      anon_sym_decrement,
      anon_sym_layout,
      anon_sym_assign,
      anon_sym_cycle,
      anon_sym_include,
      anon_sym_include_relative,
      anon_sym_render,
      anon_sym_for,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_elsif,
      anon_sym_else,
      anon_sym_endfor,
      anon_sym_case,
      anon_sym_endcase,
      anon_sym_when,
      anon_sym_unless,
      anon_sym_endunless,
      anon_sym_capture,
      anon_sym_form,
      anon_sym_endform,
      anon_sym_tablerow,
      anon_sym_endtablerow,
      anon_sym_paginate,
      anon_sym_endpaginate,
  [3332] = 2,
    ACTIONS(311), 16,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_COMMA,
      anon_sym_PIPE,
    ACTIONS(309), 42,
      anon_sym_LBRACE_LBRACE,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_echo,
      anon_sym_section,
      anon_sym_sections,
      anon_sym_increment,
      anon_sym_decrement,
      anon_sym_layout,
      anon_sym_assign,
      anon_sym_cycle,
      anon_sym_include,
      anon_sym_include_relative,
      anon_sym_render,
      anon_sym_for,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_elsif,
      anon_sym_else,
      anon_sym_endfor,
      anon_sym_case,
      anon_sym_endcase,
      anon_sym_when,
      anon_sym_unless,
      anon_sym_endunless,
      anon_sym_capture,
      anon_sym_form,
      anon_sym_endform,
      anon_sym_tablerow,
      anon_sym_endtablerow,
      anon_sym_paginate,
      anon_sym_endpaginate,
  [3395] = 2,
    ACTIONS(358), 16,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_COMMA,
      anon_sym_PIPE,
    ACTIONS(356), 42,
      anon_sym_LBRACE_LBRACE,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_echo,
      anon_sym_section,
      anon_sym_sections,
      anon_sym_increment,
      anon_sym_decrement,
      anon_sym_layout,
      anon_sym_assign,
      anon_sym_cycle,
      anon_sym_include,
      anon_sym_include_relative,
      anon_sym_render,
      anon_sym_for,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_elsif,
      anon_sym_else,
      anon_sym_endfor,
      anon_sym_case,
      anon_sym_endcase,
      anon_sym_when,
      anon_sym_unless,
      anon_sym_endunless,
      anon_sym_capture,
      anon_sym_form,
      anon_sym_endform,
      anon_sym_tablerow,
      anon_sym_endtablerow,
      anon_sym_paginate,
      anon_sym_endpaginate,
  [3458] = 2,
    ACTIONS(321), 16,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_COMMA,
      anon_sym_PIPE,
    ACTIONS(319), 42,
      anon_sym_LBRACE_LBRACE,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_echo,
      anon_sym_section,
      anon_sym_sections,
      anon_sym_increment,
      anon_sym_decrement,
      anon_sym_layout,
      anon_sym_assign,
      anon_sym_cycle,
      anon_sym_include,
      anon_sym_include_relative,
      anon_sym_render,
      anon_sym_for,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_elsif,
      anon_sym_else,
      anon_sym_endfor,
      anon_sym_case,
      anon_sym_endcase,
      anon_sym_when,
      anon_sym_unless,
      anon_sym_endunless,
      anon_sym_capture,
      anon_sym_form,
      anon_sym_endform,
      anon_sym_tablerow,
      anon_sym_endtablerow,
      anon_sym_paginate,
      anon_sym_endpaginate,
  [3521] = 4,
    ACTIONS(293), 1,
      anon_sym_DOT,
    ACTIONS(295), 1,
      anon_sym_LBRACK,
    ACTIONS(95), 15,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
    ACTIONS(97), 38,
      anon_sym_LBRACE_LBRACE,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_echo,
      anon_sym_section,
      anon_sym_sections,
      anon_sym_increment,
      anon_sym_decrement,
      anon_sym_layout,
      anon_sym_assign,
      anon_sym_cycle,
      anon_sym_include,
      anon_sym_include_relative,
      anon_sym_render,
      anon_sym_for,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_elsif,
      anon_sym_else,
      anon_sym_case,
      anon_sym_endcase,
      anon_sym_when,
      anon_sym_unless,
      anon_sym_endunless,
      anon_sym_capture,
      anon_sym_form,
      anon_sym_tablerow,
      anon_sym_paginate,
  [3585] = 3,
    ACTIONS(364), 1,
      anon_sym_COLON,
    ACTIONS(362), 15,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
    ACTIONS(360), 38,
      anon_sym_LBRACE_LBRACE,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_echo,
      anon_sym_section,
      anon_sym_sections,
      anon_sym_increment,
      anon_sym_decrement,
      anon_sym_layout,
      anon_sym_assign,
      anon_sym_cycle,
      anon_sym_include,
      anon_sym_include_relative,
      anon_sym_render,
      anon_sym_for,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_elsif,
      anon_sym_else,
      anon_sym_case,
      anon_sym_endcase,
      anon_sym_when,
      anon_sym_unless,
      anon_sym_endunless,
      anon_sym_capture,
      anon_sym_form,
      anon_sym_tablerow,
      anon_sym_paginate,
  [3646] = 2,
    ACTIONS(368), 15,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
    ACTIONS(366), 38,
      anon_sym_LBRACE_LBRACE,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_echo,
      anon_sym_section,
      anon_sym_sections,
      anon_sym_increment,
      anon_sym_decrement,
      anon_sym_layout,
      anon_sym_assign,
      anon_sym_cycle,
      anon_sym_include,
      anon_sym_include_relative,
      anon_sym_render,
      anon_sym_for,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_elsif,
      anon_sym_else,
      anon_sym_case,
      anon_sym_endcase,
      anon_sym_when,
      anon_sym_unless,
      anon_sym_endunless,
      anon_sym_capture,
      anon_sym_form,
      anon_sym_tablerow,
      anon_sym_paginate,
  [3704] = 10,
    ACTIONS(29), 1,
      anon_sym_PLUS,
    ACTIONS(31), 1,
      anon_sym_DASH,
    ACTIONS(35), 1,
      anon_sym_CARET,
    ACTIONS(374), 1,
      anon_sym_PERCENT,
    ACTIONS(33), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(39), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(41), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(37), 4,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
    ACTIONS(372), 7,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_PIPE,
    ACTIONS(370), 32,
      anon_sym_LBRACE_LBRACE,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_contains,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_echo,
      anon_sym_section,
      anon_sym_sections,
      anon_sym_increment,
      anon_sym_decrement,
      anon_sym_layout,
      anon_sym_assign,
      anon_sym_cycle,
      anon_sym_include,
      anon_sym_include_relative,
      anon_sym_render,
      anon_sym_for,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_elsif,
      anon_sym_else,
      anon_sym_case,
      anon_sym_endcase,
      anon_sym_when,
      anon_sym_unless,
      anon_sym_endunless,
      anon_sym_capture,
      anon_sym_form,
      anon_sym_tablerow,
      anon_sym_paginate,
  [3778] = 9,
    ACTIONS(29), 1,
      anon_sym_PLUS,
    ACTIONS(31), 1,
      anon_sym_DASH,
    ACTIONS(35), 1,
      anon_sym_CARET,
    ACTIONS(374), 1,
      anon_sym_PERCENT,
    ACTIONS(33), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(39), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(37), 4,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
    ACTIONS(372), 7,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_PIPE,
    ACTIONS(370), 34,
      anon_sym_LBRACE_LBRACE,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_echo,
      anon_sym_section,
      anon_sym_sections,
      anon_sym_increment,
      anon_sym_decrement,
      anon_sym_layout,
      anon_sym_assign,
      anon_sym_cycle,
      anon_sym_include,
      anon_sym_include_relative,
      anon_sym_render,
      anon_sym_for,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_elsif,
      anon_sym_else,
      anon_sym_case,
      anon_sym_endcase,
      anon_sym_when,
      anon_sym_unless,
      anon_sym_endunless,
      anon_sym_capture,
      anon_sym_form,
      anon_sym_tablerow,
      anon_sym_paginate,
  [3850] = 7,
    ACTIONS(29), 1,
      anon_sym_PLUS,
    ACTIONS(31), 1,
      anon_sym_DASH,
    ACTIONS(35), 1,
      anon_sym_CARET,
    ACTIONS(374), 1,
      anon_sym_PERCENT,
    ACTIONS(33), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(372), 11,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
    ACTIONS(370), 36,
      anon_sym_LBRACE_LBRACE,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_echo,
      anon_sym_section,
      anon_sym_sections,
      anon_sym_increment,
      anon_sym_decrement,
      anon_sym_layout,
      anon_sym_assign,
      anon_sym_cycle,
      anon_sym_include,
      anon_sym_include_relative,
      anon_sym_render,
      anon_sym_for,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_elsif,
      anon_sym_else,
      anon_sym_case,
      anon_sym_endcase,
      anon_sym_when,
      anon_sym_unless,
      anon_sym_endunless,
      anon_sym_capture,
      anon_sym_form,
      anon_sym_tablerow,
      anon_sym_paginate,
  [3918] = 2,
    ACTIONS(378), 15,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
    ACTIONS(376), 38,
      anon_sym_LBRACE_LBRACE,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_echo,
      anon_sym_section,
      anon_sym_sections,
      anon_sym_increment,
      anon_sym_decrement,
      anon_sym_layout,
      anon_sym_assign,
      anon_sym_cycle,
      anon_sym_include,
      anon_sym_include_relative,
      anon_sym_render,
      anon_sym_for,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_elsif,
      anon_sym_else,
      anon_sym_case,
      anon_sym_endcase,
      anon_sym_when,
      anon_sym_unless,
      anon_sym_endunless,
      anon_sym_capture,
      anon_sym_form,
      anon_sym_tablerow,
      anon_sym_paginate,
  [3976] = 2,
    ACTIONS(372), 15,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
    ACTIONS(370), 38,
      anon_sym_LBRACE_LBRACE,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_echo,
      anon_sym_section,
      anon_sym_sections,
      anon_sym_increment,
      anon_sym_decrement,
      anon_sym_layout,
      anon_sym_assign,
      anon_sym_cycle,
      anon_sym_include,
      anon_sym_include_relative,
      anon_sym_render,
      anon_sym_for,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_elsif,
      anon_sym_else,
      anon_sym_case,
      anon_sym_endcase,
      anon_sym_when,
      anon_sym_unless,
      anon_sym_endunless,
      anon_sym_capture,
      anon_sym_form,
      anon_sym_tablerow,
      anon_sym_paginate,
  [4034] = 9,
    ACTIONS(293), 1,
      anon_sym_DOT,
    ACTIONS(295), 1,
      anon_sym_LBRACK,
    ACTIONS(307), 1,
      anon_sym_COMMA,
    ACTIONS(313), 1,
      anon_sym_COLON,
    STATE(37), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(305), 4,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
    ACTIONS(97), 6,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
    ACTIONS(95), 10,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
    ACTIONS(303), 28,
      anon_sym_LBRACE_LBRACE,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_echo,
      anon_sym_section,
      anon_sym_sections,
      anon_sym_increment,
      anon_sym_decrement,
      anon_sym_layout,
      anon_sym_assign,
      anon_sym_cycle,
      anon_sym_include,
      anon_sym_include_relative,
      anon_sym_render,
      anon_sym_for,
      anon_sym_if,
      anon_sym_else,
      anon_sym_case,
      anon_sym_endcase,
      anon_sym_when,
      anon_sym_unless,
      anon_sym_capture,
      anon_sym_form,
      anon_sym_tablerow,
      anon_sym_paginate,
  [4106] = 3,
    ACTIONS(35), 1,
      anon_sym_CARET,
    ACTIONS(372), 14,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
    ACTIONS(370), 38,
      anon_sym_LBRACE_LBRACE,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_echo,
      anon_sym_section,
      anon_sym_sections,
      anon_sym_increment,
      anon_sym_decrement,
      anon_sym_layout,
      anon_sym_assign,
      anon_sym_cycle,
      anon_sym_include,
      anon_sym_include_relative,
      anon_sym_render,
      anon_sym_for,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_elsif,
      anon_sym_else,
      anon_sym_case,
      anon_sym_endcase,
      anon_sym_when,
      anon_sym_unless,
      anon_sym_endunless,
      anon_sym_capture,
      anon_sym_form,
      anon_sym_tablerow,
      anon_sym_paginate,
  [4166] = 5,
    ACTIONS(35), 1,
      anon_sym_CARET,
    ACTIONS(374), 1,
      anon_sym_PERCENT,
    ACTIONS(33), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(372), 12,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
    ACTIONS(370), 37,
      anon_sym_LBRACE_LBRACE,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_echo,
      anon_sym_section,
      anon_sym_sections,
      anon_sym_increment,
      anon_sym_decrement,
      anon_sym_layout,
      anon_sym_assign,
      anon_sym_cycle,
      anon_sym_include,
      anon_sym_include_relative,
      anon_sym_render,
      anon_sym_for,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_elsif,
      anon_sym_else,
      anon_sym_case,
      anon_sym_endcase,
      anon_sym_when,
      anon_sym_unless,
      anon_sym_endunless,
      anon_sym_capture,
      anon_sym_form,
      anon_sym_tablerow,
      anon_sym_paginate,
  [4230] = 8,
    ACTIONS(293), 1,
      anon_sym_DOT,
    ACTIONS(295), 1,
      anon_sym_LBRACK,
    ACTIONS(307), 1,
      anon_sym_COMMA,
    STATE(37), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(305), 4,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
    ACTIONS(97), 6,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
    ACTIONS(95), 10,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
    ACTIONS(303), 28,
      anon_sym_LBRACE_LBRACE,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_echo,
      anon_sym_section,
      anon_sym_sections,
      anon_sym_increment,
      anon_sym_decrement,
      anon_sym_layout,
      anon_sym_assign,
      anon_sym_cycle,
      anon_sym_include,
      anon_sym_include_relative,
      anon_sym_render,
      anon_sym_for,
      anon_sym_if,
      anon_sym_else,
      anon_sym_case,
      anon_sym_endcase,
      anon_sym_when,
      anon_sym_unless,
      anon_sym_capture,
      anon_sym_form,
      anon_sym_tablerow,
      anon_sym_paginate,
  [4299] = 6,
    ACTIONS(307), 1,
      anon_sym_COMMA,
    STATE(37), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(305), 4,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
    ACTIONS(97), 6,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
    ACTIONS(95), 10,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
    ACTIONS(303), 28,
      anon_sym_LBRACE_LBRACE,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_echo,
      anon_sym_section,
      anon_sym_sections,
      anon_sym_increment,
      anon_sym_decrement,
      anon_sym_layout,
      anon_sym_assign,
      anon_sym_cycle,
      anon_sym_include,
      anon_sym_include_relative,
      anon_sym_render,
      anon_sym_for,
      anon_sym_if,
      anon_sym_else,
      anon_sym_case,
      anon_sym_endcase,
      anon_sym_when,
      anon_sym_unless,
      anon_sym_capture,
      anon_sym_form,
      anon_sym_tablerow,
      anon_sym_paginate,
  [4362] = 32,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(410), 1,
      anon_sym_endif,
    ACTIONS(412), 1,
      anon_sym_elsif,
    ACTIONS(414), 1,
      anon_sym_else,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_javascript,
    ACTIONS(434), 1,
      anon_sym_raw,
    ACTIONS(436), 1,
      anon_sym_comment,
    ACTIONS(438), 1,
      sym__inline_comment_content,
    STATE(716), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(929), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [4473] = 32,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(412), 1,
      anon_sym_elsif,
    ACTIONS(414), 1,
      anon_sym_else,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_javascript,
    ACTIONS(434), 1,
      anon_sym_raw,
    ACTIONS(436), 1,
      anon_sym_comment,
    ACTIONS(438), 1,
      sym__inline_comment_content,
    ACTIONS(440), 1,
      anon_sym_endunless,
    STATE(716), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(929), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [4584] = 32,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(412), 1,
      anon_sym_elsif,
    ACTIONS(414), 1,
      anon_sym_else,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_javascript,
    ACTIONS(434), 1,
      anon_sym_raw,
    ACTIONS(436), 1,
      anon_sym_comment,
    ACTIONS(438), 1,
      sym__inline_comment_content,
    ACTIONS(442), 1,
      anon_sym_endunless,
    STATE(716), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(929), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [4695] = 32,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(412), 1,
      anon_sym_elsif,
    ACTIONS(414), 1,
      anon_sym_else,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_javascript,
    ACTIONS(434), 1,
      anon_sym_raw,
    ACTIONS(436), 1,
      anon_sym_comment,
    ACTIONS(438), 1,
      sym__inline_comment_content,
    ACTIONS(444), 1,
      anon_sym_endunless,
    STATE(716), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(929), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [4806] = 32,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(412), 1,
      anon_sym_elsif,
    ACTIONS(414), 1,
      anon_sym_else,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_javascript,
    ACTIONS(434), 1,
      anon_sym_raw,
    ACTIONS(436), 1,
      anon_sym_comment,
    ACTIONS(438), 1,
      sym__inline_comment_content,
    ACTIONS(446), 1,
      anon_sym_endif,
    STATE(716), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(929), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [4917] = 32,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(412), 1,
      anon_sym_elsif,
    ACTIONS(414), 1,
      anon_sym_else,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_javascript,
    ACTIONS(434), 1,
      anon_sym_raw,
    ACTIONS(436), 1,
      anon_sym_comment,
    ACTIONS(438), 1,
      sym__inline_comment_content,
    ACTIONS(448), 1,
      anon_sym_endunless,
    STATE(716), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(929), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [5028] = 32,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(412), 1,
      anon_sym_elsif,
    ACTIONS(414), 1,
      anon_sym_else,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_javascript,
    ACTIONS(434), 1,
      anon_sym_raw,
    ACTIONS(436), 1,
      anon_sym_comment,
    ACTIONS(438), 1,
      sym__inline_comment_content,
    ACTIONS(450), 1,
      anon_sym_endif,
    STATE(716), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(929), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [5139] = 32,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(412), 1,
      anon_sym_elsif,
    ACTIONS(414), 1,
      anon_sym_else,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_javascript,
    ACTIONS(434), 1,
      anon_sym_raw,
    ACTIONS(436), 1,
      anon_sym_comment,
    ACTIONS(438), 1,
      sym__inline_comment_content,
    ACTIONS(452), 1,
      anon_sym_endif,
    STATE(716), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(929), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [5250] = 31,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(414), 1,
      anon_sym_else,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_javascript,
    ACTIONS(434), 1,
      anon_sym_raw,
    ACTIONS(436), 1,
      anon_sym_comment,
    ACTIONS(438), 1,
      sym__inline_comment_content,
    ACTIONS(454), 1,
      anon_sym_endfor,
    STATE(716), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(929), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [5358] = 31,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(414), 1,
      anon_sym_else,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_javascript,
    ACTIONS(434), 1,
      anon_sym_raw,
    ACTIONS(436), 1,
      anon_sym_comment,
    ACTIONS(438), 1,
      sym__inline_comment_content,
    ACTIONS(456), 1,
      anon_sym_endfor,
    STATE(716), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(929), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [5466] = 31,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(414), 1,
      anon_sym_else,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_javascript,
    ACTIONS(434), 1,
      anon_sym_raw,
    ACTIONS(436), 1,
      anon_sym_comment,
    ACTIONS(438), 1,
      sym__inline_comment_content,
    ACTIONS(458), 1,
      anon_sym_endfor,
    STATE(716), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(929), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [5574] = 31,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(414), 1,
      anon_sym_else,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_javascript,
    ACTIONS(434), 1,
      anon_sym_raw,
    ACTIONS(436), 1,
      anon_sym_comment,
    ACTIONS(438), 1,
      sym__inline_comment_content,
    ACTIONS(460), 1,
      anon_sym_endfor,
    STATE(716), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(929), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [5682] = 31,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(414), 1,
      anon_sym_else,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_javascript,
    ACTIONS(434), 1,
      anon_sym_raw,
    ACTIONS(436), 1,
      anon_sym_comment,
    ACTIONS(438), 1,
      sym__inline_comment_content,
    ACTIONS(462), 1,
      anon_sym_endfor,
    STATE(716), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(929), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [5790] = 31,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(414), 1,
      anon_sym_else,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_javascript,
    ACTIONS(434), 1,
      anon_sym_raw,
    ACTIONS(436), 1,
      anon_sym_comment,
    ACTIONS(438), 1,
      sym__inline_comment_content,
    ACTIONS(464), 1,
      anon_sym_endfor,
    STATE(716), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(929), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [5898] = 31,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(414), 1,
      anon_sym_else,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_javascript,
    ACTIONS(434), 1,
      anon_sym_raw,
    ACTIONS(436), 1,
      anon_sym_comment,
    ACTIONS(438), 1,
      sym__inline_comment_content,
    ACTIONS(466), 1,
      anon_sym_endfor,
    STATE(716), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(929), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [6006] = 31,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(414), 1,
      anon_sym_else,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_javascript,
    ACTIONS(434), 1,
      anon_sym_raw,
    ACTIONS(436), 1,
      anon_sym_comment,
    ACTIONS(438), 1,
      sym__inline_comment_content,
    ACTIONS(468), 1,
      anon_sym_endfor,
    STATE(716), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(929), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [6114] = 31,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(414), 1,
      anon_sym_else,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_javascript,
    ACTIONS(434), 1,
      anon_sym_raw,
    ACTIONS(436), 1,
      anon_sym_comment,
    ACTIONS(438), 1,
      sym__inline_comment_content,
    ACTIONS(470), 1,
      anon_sym_endfor,
    STATE(716), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(929), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [6222] = 31,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(414), 1,
      anon_sym_else,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_javascript,
    ACTIONS(434), 1,
      anon_sym_raw,
    ACTIONS(436), 1,
      anon_sym_comment,
    ACTIONS(438), 1,
      sym__inline_comment_content,
    ACTIONS(472), 1,
      anon_sym_endfor,
    STATE(716), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(929), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [6330] = 31,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(414), 1,
      anon_sym_else,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_javascript,
    ACTIONS(434), 1,
      anon_sym_raw,
    ACTIONS(436), 1,
      anon_sym_comment,
    ACTIONS(438), 1,
      sym__inline_comment_content,
    ACTIONS(474), 1,
      anon_sym_endfor,
    STATE(716), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(929), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [6438] = 31,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(414), 1,
      anon_sym_else,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_javascript,
    ACTIONS(434), 1,
      anon_sym_raw,
    ACTIONS(436), 1,
      anon_sym_comment,
    ACTIONS(438), 1,
      sym__inline_comment_content,
    ACTIONS(476), 1,
      anon_sym_endfor,
    STATE(716), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(929), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [6546] = 31,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(414), 1,
      anon_sym_else,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_javascript,
    ACTIONS(434), 1,
      anon_sym_raw,
    ACTIONS(436), 1,
      anon_sym_comment,
    ACTIONS(438), 1,
      sym__inline_comment_content,
    ACTIONS(478), 1,
      anon_sym_endfor,
    STATE(716), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(929), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [6654] = 31,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(414), 1,
      anon_sym_else,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_javascript,
    ACTIONS(434), 1,
      anon_sym_raw,
    ACTIONS(436), 1,
      anon_sym_comment,
    ACTIONS(438), 1,
      sym__inline_comment_content,
    ACTIONS(480), 1,
      anon_sym_endfor,
    STATE(716), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(929), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [6762] = 31,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(414), 1,
      anon_sym_else,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_javascript,
    ACTIONS(434), 1,
      anon_sym_raw,
    ACTIONS(436), 1,
      anon_sym_comment,
    ACTIONS(438), 1,
      sym__inline_comment_content,
    ACTIONS(482), 1,
      anon_sym_endfor,
    STATE(716), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(929), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [6870] = 31,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(414), 1,
      anon_sym_else,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_javascript,
    ACTIONS(434), 1,
      anon_sym_raw,
    ACTIONS(436), 1,
      anon_sym_comment,
    ACTIONS(438), 1,
      sym__inline_comment_content,
    ACTIONS(484), 1,
      anon_sym_endfor,
    STATE(716), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(929), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [6978] = 30,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_javascript,
    ACTIONS(434), 1,
      anon_sym_raw,
    ACTIONS(436), 1,
      anon_sym_comment,
    ACTIONS(438), 1,
      sym__inline_comment_content,
    ACTIONS(486), 1,
      anon_sym_endcapture,
    STATE(716), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(929), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [7083] = 30,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_javascript,
    ACTIONS(434), 1,
      anon_sym_raw,
    ACTIONS(436), 1,
      anon_sym_comment,
    ACTIONS(438), 1,
      sym__inline_comment_content,
    ACTIONS(488), 1,
      anon_sym_endtablerow,
    STATE(716), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(929), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [7188] = 30,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_javascript,
    ACTIONS(434), 1,
      anon_sym_raw,
    ACTIONS(436), 1,
      anon_sym_comment,
    ACTIONS(438), 1,
      sym__inline_comment_content,
    ACTIONS(490), 1,
      anon_sym_endjavascript,
    STATE(716), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(929), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [7293] = 30,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_javascript,
    ACTIONS(434), 1,
      anon_sym_raw,
    ACTIONS(436), 1,
      anon_sym_comment,
    ACTIONS(438), 1,
      sym__inline_comment_content,
    ACTIONS(492), 1,
      anon_sym_endstyle,
    STATE(716), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(929), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [7398] = 30,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_javascript,
    ACTIONS(434), 1,
      anon_sym_raw,
    ACTIONS(436), 1,
      anon_sym_comment,
    ACTIONS(438), 1,
      sym__inline_comment_content,
    ACTIONS(494), 1,
      anon_sym_endform,
    STATE(716), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(929), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [7503] = 30,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_javascript,
    ACTIONS(434), 1,
      anon_sym_raw,
    ACTIONS(436), 1,
      anon_sym_comment,
    ACTIONS(438), 1,
      sym__inline_comment_content,
    ACTIONS(496), 1,
      anon_sym_endstyle,
    STATE(716), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(929), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [7608] = 30,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_javascript,
    ACTIONS(434), 1,
      anon_sym_raw,
    ACTIONS(436), 1,
      anon_sym_comment,
    ACTIONS(438), 1,
      sym__inline_comment_content,
    ACTIONS(498), 1,
      anon_sym_endform,
    STATE(716), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(929), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [7713] = 30,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_javascript,
    ACTIONS(434), 1,
      anon_sym_raw,
    ACTIONS(436), 1,
      anon_sym_comment,
    ACTIONS(438), 1,
      sym__inline_comment_content,
    ACTIONS(500), 1,
      anon_sym_endjavascript,
    STATE(716), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(929), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [7818] = 30,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_javascript,
    ACTIONS(434), 1,
      anon_sym_raw,
    ACTIONS(436), 1,
      anon_sym_comment,
    ACTIONS(438), 1,
      sym__inline_comment_content,
    ACTIONS(502), 1,
      anon_sym_endstyle,
    STATE(716), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(929), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [7923] = 30,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_javascript,
    ACTIONS(434), 1,
      anon_sym_raw,
    ACTIONS(436), 1,
      anon_sym_comment,
    ACTIONS(438), 1,
      sym__inline_comment_content,
    ACTIONS(504), 1,
      anon_sym_endcapture,
    STATE(716), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(929), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [8028] = 30,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_javascript,
    ACTIONS(434), 1,
      anon_sym_raw,
    ACTIONS(436), 1,
      anon_sym_comment,
    ACTIONS(438), 1,
      sym__inline_comment_content,
    ACTIONS(506), 1,
      anon_sym_endcapture,
    STATE(716), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(929), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [8133] = 30,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_javascript,
    ACTIONS(434), 1,
      anon_sym_raw,
    ACTIONS(436), 1,
      anon_sym_comment,
    ACTIONS(438), 1,
      sym__inline_comment_content,
    ACTIONS(508), 1,
      anon_sym_endform,
    STATE(716), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(929), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [8238] = 30,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_javascript,
    ACTIONS(434), 1,
      anon_sym_raw,
    ACTIONS(436), 1,
      anon_sym_comment,
    ACTIONS(438), 1,
      sym__inline_comment_content,
    ACTIONS(510), 1,
      anon_sym_endpaginate,
    STATE(716), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(929), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [8343] = 30,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_javascript,
    ACTIONS(434), 1,
      anon_sym_raw,
    ACTIONS(436), 1,
      anon_sym_comment,
    ACTIONS(438), 1,
      sym__inline_comment_content,
    ACTIONS(512), 1,
      anon_sym_endtablerow,
    STATE(716), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(929), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [8448] = 30,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_javascript,
    ACTIONS(434), 1,
      anon_sym_raw,
    ACTIONS(436), 1,
      anon_sym_comment,
    ACTIONS(438), 1,
      sym__inline_comment_content,
    ACTIONS(514), 1,
      anon_sym_endpaginate,
    STATE(716), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(929), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [8553] = 30,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_javascript,
    ACTIONS(434), 1,
      anon_sym_raw,
    ACTIONS(436), 1,
      anon_sym_comment,
    ACTIONS(438), 1,
      sym__inline_comment_content,
    ACTIONS(516), 1,
      anon_sym_endpaginate,
    STATE(716), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(929), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [8658] = 30,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_javascript,
    ACTIONS(434), 1,
      anon_sym_raw,
    ACTIONS(436), 1,
      anon_sym_comment,
    ACTIONS(438), 1,
      sym__inline_comment_content,
    ACTIONS(518), 1,
      anon_sym_endpaginate,
    STATE(716), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(929), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [8763] = 30,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_javascript,
    ACTIONS(434), 1,
      anon_sym_raw,
    ACTIONS(436), 1,
      anon_sym_comment,
    ACTIONS(438), 1,
      sym__inline_comment_content,
    ACTIONS(520), 1,
      anon_sym_endpaginate,
    STATE(716), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(929), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [8868] = 30,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_javascript,
    ACTIONS(434), 1,
      anon_sym_raw,
    ACTIONS(436), 1,
      anon_sym_comment,
    ACTIONS(438), 1,
      sym__inline_comment_content,
    ACTIONS(522), 1,
      anon_sym_endpaginate,
    STATE(716), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(929), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [8973] = 30,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_javascript,
    ACTIONS(434), 1,
      anon_sym_raw,
    ACTIONS(436), 1,
      anon_sym_comment,
    ACTIONS(438), 1,
      sym__inline_comment_content,
    ACTIONS(524), 1,
      anon_sym_endtablerow,
    STATE(716), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(929), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [9078] = 30,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_javascript,
    ACTIONS(434), 1,
      anon_sym_raw,
    ACTIONS(436), 1,
      anon_sym_comment,
    ACTIONS(438), 1,
      sym__inline_comment_content,
    ACTIONS(526), 1,
      anon_sym_endtablerow,
    STATE(716), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(929), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [9183] = 30,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_javascript,
    ACTIONS(434), 1,
      anon_sym_raw,
    ACTIONS(436), 1,
      anon_sym_comment,
    ACTIONS(438), 1,
      sym__inline_comment_content,
    ACTIONS(528), 1,
      anon_sym_endpaginate,
    STATE(716), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(929), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [9288] = 30,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_javascript,
    ACTIONS(434), 1,
      anon_sym_raw,
    ACTIONS(436), 1,
      anon_sym_comment,
    ACTIONS(438), 1,
      sym__inline_comment_content,
    ACTIONS(530), 1,
      anon_sym_endform,
    STATE(716), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(929), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [9393] = 30,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_javascript,
    ACTIONS(434), 1,
      anon_sym_raw,
    ACTIONS(436), 1,
      anon_sym_comment,
    ACTIONS(438), 1,
      sym__inline_comment_content,
    ACTIONS(532), 1,
      anon_sym_endstyle,
    STATE(716), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(929), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [9498] = 30,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_javascript,
    ACTIONS(434), 1,
      anon_sym_raw,
    ACTIONS(436), 1,
      anon_sym_comment,
    ACTIONS(438), 1,
      sym__inline_comment_content,
    ACTIONS(534), 1,
      anon_sym_endtablerow,
    STATE(716), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(929), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [9603] = 30,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_javascript,
    ACTIONS(434), 1,
      anon_sym_raw,
    ACTIONS(436), 1,
      anon_sym_comment,
    ACTIONS(438), 1,
      sym__inline_comment_content,
    ACTIONS(536), 1,
      anon_sym_endtablerow,
    STATE(716), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(929), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [9708] = 30,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_javascript,
    ACTIONS(434), 1,
      anon_sym_raw,
    ACTIONS(436), 1,
      anon_sym_comment,
    ACTIONS(438), 1,
      sym__inline_comment_content,
    ACTIONS(538), 1,
      anon_sym_endpaginate,
    STATE(716), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(929), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [9813] = 30,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_javascript,
    ACTIONS(434), 1,
      anon_sym_raw,
    ACTIONS(436), 1,
      anon_sym_comment,
    ACTIONS(438), 1,
      sym__inline_comment_content,
    ACTIONS(540), 1,
      anon_sym_endtablerow,
    STATE(716), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(929), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [9918] = 30,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_javascript,
    ACTIONS(434), 1,
      anon_sym_raw,
    ACTIONS(436), 1,
      anon_sym_comment,
    ACTIONS(438), 1,
      sym__inline_comment_content,
    ACTIONS(542), 1,
      anon_sym_endform,
    STATE(716), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(929), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [10023] = 30,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_javascript,
    ACTIONS(434), 1,
      anon_sym_raw,
    ACTIONS(436), 1,
      anon_sym_comment,
    ACTIONS(438), 1,
      sym__inline_comment_content,
    ACTIONS(544), 1,
      anon_sym_endtablerow,
    STATE(716), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(929), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [10128] = 30,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_javascript,
    ACTIONS(434), 1,
      anon_sym_raw,
    ACTIONS(436), 1,
      anon_sym_comment,
    ACTIONS(438), 1,
      sym__inline_comment_content,
    ACTIONS(546), 1,
      anon_sym_endtablerow,
    STATE(716), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(929), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [10233] = 30,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_javascript,
    ACTIONS(434), 1,
      anon_sym_raw,
    ACTIONS(436), 1,
      anon_sym_comment,
    ACTIONS(438), 1,
      sym__inline_comment_content,
    ACTIONS(548), 1,
      anon_sym_endjavascript,
    STATE(716), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(929), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [10338] = 30,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_javascript,
    ACTIONS(434), 1,
      anon_sym_raw,
    ACTIONS(436), 1,
      anon_sym_comment,
    ACTIONS(438), 1,
      sym__inline_comment_content,
    ACTIONS(550), 1,
      anon_sym_endform,
    STATE(716), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(929), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [10443] = 30,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_javascript,
    ACTIONS(434), 1,
      anon_sym_raw,
    ACTIONS(436), 1,
      anon_sym_comment,
    ACTIONS(438), 1,
      sym__inline_comment_content,
    ACTIONS(552), 1,
      anon_sym_endjavascript,
    STATE(716), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(929), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [10548] = 30,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_javascript,
    ACTIONS(434), 1,
      anon_sym_raw,
    ACTIONS(436), 1,
      anon_sym_comment,
    ACTIONS(438), 1,
      sym__inline_comment_content,
    ACTIONS(554), 1,
      anon_sym_endtablerow,
    STATE(716), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(929), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [10653] = 30,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_javascript,
    ACTIONS(434), 1,
      anon_sym_raw,
    ACTIONS(436), 1,
      anon_sym_comment,
    ACTIONS(438), 1,
      sym__inline_comment_content,
    ACTIONS(556), 1,
      anon_sym_endtablerow,
    STATE(716), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(929), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [10758] = 30,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_javascript,
    ACTIONS(434), 1,
      anon_sym_raw,
    ACTIONS(436), 1,
      anon_sym_comment,
    ACTIONS(438), 1,
      sym__inline_comment_content,
    ACTIONS(558), 1,
      anon_sym_endtablerow,
    STATE(716), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(929), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [10863] = 30,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_javascript,
    ACTIONS(434), 1,
      anon_sym_raw,
    ACTIONS(436), 1,
      anon_sym_comment,
    ACTIONS(438), 1,
      sym__inline_comment_content,
    ACTIONS(560), 1,
      anon_sym_endpaginate,
    STATE(716), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(929), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [10968] = 30,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_javascript,
    ACTIONS(434), 1,
      anon_sym_raw,
    ACTIONS(436), 1,
      anon_sym_comment,
    ACTIONS(438), 1,
      sym__inline_comment_content,
    ACTIONS(562), 1,
      anon_sym_endpaginate,
    STATE(716), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(929), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [11073] = 30,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_javascript,
    ACTIONS(434), 1,
      anon_sym_raw,
    ACTIONS(436), 1,
      anon_sym_comment,
    ACTIONS(438), 1,
      sym__inline_comment_content,
    ACTIONS(564), 1,
      anon_sym_endcapture,
    STATE(716), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(929), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [11178] = 30,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_javascript,
    ACTIONS(434), 1,
      anon_sym_raw,
    ACTIONS(436), 1,
      anon_sym_comment,
    ACTIONS(438), 1,
      sym__inline_comment_content,
    ACTIONS(566), 1,
      anon_sym_endpaginate,
    STATE(716), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(929), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [11283] = 30,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_javascript,
    ACTIONS(434), 1,
      anon_sym_raw,
    ACTIONS(436), 1,
      anon_sym_comment,
    ACTIONS(438), 1,
      sym__inline_comment_content,
    ACTIONS(568), 1,
      anon_sym_endpaginate,
    STATE(716), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(929), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [11388] = 30,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_javascript,
    ACTIONS(434), 1,
      anon_sym_raw,
    ACTIONS(436), 1,
      anon_sym_comment,
    ACTIONS(438), 1,
      sym__inline_comment_content,
    ACTIONS(570), 1,
      anon_sym_endtablerow,
    STATE(716), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(929), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [11493] = 30,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_javascript,
    ACTIONS(434), 1,
      anon_sym_raw,
    ACTIONS(436), 1,
      anon_sym_comment,
    ACTIONS(438), 1,
      sym__inline_comment_content,
    ACTIONS(572), 1,
      anon_sym_endform,
    STATE(716), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(929), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [11598] = 30,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_javascript,
    ACTIONS(434), 1,
      anon_sym_raw,
    ACTIONS(436), 1,
      anon_sym_comment,
    ACTIONS(438), 1,
      sym__inline_comment_content,
    ACTIONS(574), 1,
      anon_sym_endpaginate,
    STATE(716), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(929), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [11703] = 30,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_javascript,
    ACTIONS(434), 1,
      anon_sym_raw,
    ACTIONS(436), 1,
      anon_sym_comment,
    ACTIONS(438), 1,
      sym__inline_comment_content,
    ACTIONS(576), 1,
      anon_sym_endpaginate,
    STATE(716), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(929), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [11808] = 30,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_javascript,
    ACTIONS(434), 1,
      anon_sym_raw,
    ACTIONS(436), 1,
      anon_sym_comment,
    ACTIONS(438), 1,
      sym__inline_comment_content,
    ACTIONS(578), 1,
      anon_sym_endtablerow,
    STATE(716), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(929), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [11913] = 30,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_javascript,
    ACTIONS(434), 1,
      anon_sym_raw,
    ACTIONS(436), 1,
      anon_sym_comment,
    ACTIONS(438), 1,
      sym__inline_comment_content,
    ACTIONS(580), 1,
      anon_sym_endpaginate,
    STATE(716), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(929), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [12018] = 30,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_javascript,
    ACTIONS(434), 1,
      anon_sym_raw,
    ACTIONS(436), 1,
      anon_sym_comment,
    ACTIONS(438), 1,
      sym__inline_comment_content,
    ACTIONS(582), 1,
      anon_sym_endpaginate,
    STATE(716), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(929), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [12123] = 30,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_javascript,
    ACTIONS(434), 1,
      anon_sym_raw,
    ACTIONS(436), 1,
      anon_sym_comment,
    ACTIONS(438), 1,
      sym__inline_comment_content,
    ACTIONS(584), 1,
      anon_sym_endtablerow,
    STATE(716), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(929), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [12228] = 30,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_javascript,
    ACTIONS(434), 1,
      anon_sym_raw,
    ACTIONS(436), 1,
      anon_sym_comment,
    ACTIONS(438), 1,
      sym__inline_comment_content,
    ACTIONS(586), 1,
      anon_sym_endform,
    STATE(716), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(929), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [12333] = 30,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_javascript,
    ACTIONS(434), 1,
      anon_sym_raw,
    ACTIONS(436), 1,
      anon_sym_comment,
    ACTIONS(438), 1,
      sym__inline_comment_content,
    ACTIONS(588), 1,
      anon_sym_endtablerow,
    STATE(716), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(929), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [12438] = 29,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_javascript,
    ACTIONS(434), 1,
      anon_sym_raw,
    ACTIONS(436), 1,
      anon_sym_comment,
    ACTIONS(438), 1,
      sym__inline_comment_content,
    STATE(716), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(929), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [12540] = 29,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(592), 1,
      anon_sym_for,
    ACTIONS(594), 1,
      anon_sym_if,
    ACTIONS(596), 1,
      anon_sym_case,
    ACTIONS(598), 1,
      anon_sym_unless,
    ACTIONS(600), 1,
      anon_sym_capture,
    ACTIONS(602), 1,
      anon_sym_form,
    ACTIONS(604), 1,
      anon_sym_tablerow,
    ACTIONS(606), 1,
      anon_sym_paginate,
    ACTIONS(608), 1,
      anon_sym_schema,
    ACTIONS(610), 1,
      anon_sym_style,
    ACTIONS(612), 1,
      anon_sym_javascript,
    ACTIONS(614), 1,
      anon_sym_raw,
    ACTIONS(616), 1,
      anon_sym_comment,
    ACTIONS(618), 1,
      sym__inline_comment_content,
    STATE(741), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    ACTIONS(590), 2,
      sym_break_statement,
      sym_continue_statement,
    STATE(863), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [12642] = 2,
    ACTIONS(622), 4,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
    ACTIONS(620), 36,
      anon_sym_LBRACE_LBRACE,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_echo,
      anon_sym_section,
      anon_sym_sections,
      anon_sym_increment,
      anon_sym_decrement,
      anon_sym_layout,
      anon_sym_assign,
      anon_sym_cycle,
      anon_sym_include,
      anon_sym_include_relative,
      anon_sym_render,
      anon_sym_for,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_elsif,
      anon_sym_else,
      anon_sym_endfor,
      anon_sym_case,
      anon_sym_endcase,
      anon_sym_when,
      anon_sym_unless,
      anon_sym_endunless,
      anon_sym_capture,
      anon_sym_endcapture,
      anon_sym_form,
      anon_sym_endform,
      anon_sym_tablerow,
      anon_sym_endtablerow,
      anon_sym_paginate,
      anon_sym_endpaginate,
  [12687] = 2,
    ACTIONS(626), 4,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
    ACTIONS(624), 36,
      anon_sym_LBRACE_LBRACE,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_echo,
      anon_sym_section,
      anon_sym_sections,
      anon_sym_increment,
      anon_sym_decrement,
      anon_sym_layout,
      anon_sym_assign,
      anon_sym_cycle,
      anon_sym_include,
      anon_sym_include_relative,
      anon_sym_render,
      anon_sym_for,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_elsif,
      anon_sym_else,
      anon_sym_endfor,
      anon_sym_case,
      anon_sym_endcase,
      anon_sym_when,
      anon_sym_unless,
      anon_sym_endunless,
      anon_sym_capture,
      anon_sym_endcapture,
      anon_sym_form,
      anon_sym_endform,
      anon_sym_tablerow,
      anon_sym_endtablerow,
      anon_sym_paginate,
      anon_sym_endpaginate,
  [12732] = 7,
    ACTIONS(293), 1,
      anon_sym_DOT,
    ACTIONS(295), 1,
      anon_sym_LBRACK,
    STATE(20), 1,
      sym_access,
    STATE(141), 1,
      sym_argument_list,
    ACTIONS(630), 4,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
    STATE(38), 4,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_argument,
    ACTIONS(628), 28,
      anon_sym_LBRACE_LBRACE,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_echo,
      anon_sym_section,
      anon_sym_sections,
      anon_sym_increment,
      anon_sym_decrement,
      anon_sym_layout,
      anon_sym_assign,
      anon_sym_cycle,
      anon_sym_include,
      anon_sym_include_relative,
      anon_sym_render,
      anon_sym_for,
      anon_sym_if,
      anon_sym_else,
      anon_sym_endfor,
      anon_sym_case,
      anon_sym_unless,
      anon_sym_capture,
      anon_sym_form,
      anon_sym_tablerow,
      anon_sym_endtablerow,
      anon_sym_paginate,
  [12787] = 5,
    STATE(20), 1,
      sym_access,
    STATE(141), 1,
      sym_argument_list,
    ACTIONS(630), 4,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
    STATE(38), 4,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_argument,
    ACTIONS(628), 28,
      anon_sym_LBRACE_LBRACE,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_echo,
      anon_sym_section,
      anon_sym_sections,
      anon_sym_increment,
      anon_sym_decrement,
      anon_sym_layout,
      anon_sym_assign,
      anon_sym_cycle,
      anon_sym_include,
      anon_sym_include_relative,
      anon_sym_render,
      anon_sym_for,
      anon_sym_if,
      anon_sym_else,
      anon_sym_endfor,
      anon_sym_case,
      anon_sym_unless,
      anon_sym_capture,
      anon_sym_form,
      anon_sym_tablerow,
      anon_sym_endtablerow,
      anon_sym_paginate,
  [12836] = 13,
    ACTIONS(632), 1,
      sym_identifier,
    ACTIONS(634), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(639), 1,
      anon_sym_SQUOTE,
    ACTIONS(641), 1,
      anon_sym_DQUOTE,
    ACTIONS(643), 1,
      sym_number,
    ACTIONS(647), 1,
      anon_sym_DOT,
    ACTIONS(649), 1,
      anon_sym_LBRACK,
    STATE(227), 1,
      sym_access,
    STATE(314), 1,
      aux_sym_custom_unpaired_statement_repeat1,
    ACTIONS(637), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(645), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(244), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
    ACTIONS(97), 16,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_PIPE,
  [12898] = 7,
    ACTIONS(293), 1,
      anon_sym_DOT,
    ACTIONS(295), 1,
      anon_sym_LBRACK,
    ACTIONS(307), 1,
      anon_sym_COMMA,
    ACTIONS(313), 1,
      anon_sym_COLON,
    STATE(37), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(653), 4,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
    ACTIONS(651), 26,
      anon_sym_LBRACE_LBRACE,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_echo,
      anon_sym_section,
      anon_sym_sections,
      anon_sym_increment,
      anon_sym_decrement,
      anon_sym_layout,
      anon_sym_assign,
      anon_sym_cycle,
      anon_sym_include,
      anon_sym_include_relative,
      anon_sym_render,
      anon_sym_for,
      anon_sym_if,
      anon_sym_case,
      anon_sym_unless,
      anon_sym_capture,
      anon_sym_form,
      anon_sym_tablerow,
      anon_sym_paginate,
      anon_sym_endpaginate,
  [12948] = 2,
    ACTIONS(657), 6,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
    ACTIONS(655), 28,
      anon_sym_LBRACE_LBRACE,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_echo,
      anon_sym_section,
      anon_sym_sections,
      anon_sym_increment,
      anon_sym_decrement,
      anon_sym_layout,
      anon_sym_assign,
      anon_sym_cycle,
      anon_sym_include,
      anon_sym_include_relative,
      anon_sym_render,
      anon_sym_for,
      anon_sym_if,
      anon_sym_else,
      anon_sym_endfor,
      anon_sym_case,
      anon_sym_unless,
      anon_sym_capture,
      anon_sym_form,
      anon_sym_tablerow,
      anon_sym_endtablerow,
      anon_sym_paginate,
  [12987] = 2,
    ACTIONS(661), 6,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
    ACTIONS(659), 28,
      anon_sym_LBRACE_LBRACE,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_echo,
      anon_sym_section,
      anon_sym_sections,
      anon_sym_increment,
      anon_sym_decrement,
      anon_sym_layout,
      anon_sym_assign,
      anon_sym_cycle,
      anon_sym_include,
      anon_sym_include_relative,
      anon_sym_render,
      anon_sym_for,
      anon_sym_if,
      anon_sym_else,
      anon_sym_endfor,
      anon_sym_case,
      anon_sym_unless,
      anon_sym_capture,
      anon_sym_form,
      anon_sym_tablerow,
      anon_sym_endtablerow,
      anon_sym_paginate,
  [13026] = 11,
    ACTIONS(663), 1,
      aux_sym_template_content_token1,
    STATE(179), 1,
      aux_sym_program_repeat1,
    STATE(407), 1,
      aux_sym_template_content_repeat1,
    STATE(681), 1,
      aux_sym_if_statement_repeat1,
    STATE(895), 1,
      sym_else_clause,
    STATE(956), 1,
      sym_elsif_clause,
    ACTIONS(665), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(667), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    ACTIONS(669), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    STATE(639), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(638), 19,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [13082] = 2,
    ACTIONS(626), 7,
      sym__inline_comment_content,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
    ACTIONS(624), 26,
      anon_sym_LBRACE_LBRACE,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_echo,
      anon_sym_section,
      anon_sym_sections,
      anon_sym_increment,
      anon_sym_decrement,
      anon_sym_layout,
      anon_sym_assign,
      anon_sym_cycle,
      anon_sym_include,
      anon_sym_include_relative,
      anon_sym_render,
      anon_sym_for,
      anon_sym_if,
      anon_sym_case,
      anon_sym_unless,
      anon_sym_capture,
      anon_sym_form,
      anon_sym_tablerow,
      anon_sym_paginate,
      anon_sym_comment,
  [13120] = 11,
    ACTIONS(663), 1,
      aux_sym_template_content_token1,
    STATE(148), 1,
      aux_sym_program_repeat1,
    STATE(407), 1,
      aux_sym_template_content_repeat1,
    STATE(700), 1,
      aux_sym_if_statement_repeat1,
    STATE(896), 1,
      sym_else_clause,
    STATE(956), 1,
      sym_elsif_clause,
    ACTIONS(665), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(669), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(671), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(639), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(638), 19,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [13176] = 11,
    ACTIONS(663), 1,
      aux_sym_template_content_token1,
    STATE(149), 1,
      aux_sym_program_repeat1,
    STATE(407), 1,
      aux_sym_template_content_repeat1,
    STATE(712), 1,
      aux_sym_if_statement_repeat1,
    STATE(949), 1,
      sym_else_clause,
    STATE(956), 1,
      sym_elsif_clause,
    ACTIONS(665), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(669), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(673), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(639), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(638), 19,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [13232] = 2,
    ACTIONS(677), 7,
      sym__inline_comment_content,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
    ACTIONS(675), 26,
      anon_sym_LBRACE_LBRACE,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_echo,
      anon_sym_section,
      anon_sym_sections,
      anon_sym_increment,
      anon_sym_decrement,
      anon_sym_layout,
      anon_sym_assign,
      anon_sym_cycle,
      anon_sym_include,
      anon_sym_include_relative,
      anon_sym_render,
      anon_sym_for,
      anon_sym_if,
      anon_sym_case,
      anon_sym_unless,
      anon_sym_capture,
      anon_sym_form,
      anon_sym_tablerow,
      anon_sym_paginate,
      anon_sym_comment,
  [13270] = 11,
    ACTIONS(663), 1,
      aux_sym_template_content_token1,
    STATE(179), 1,
      aux_sym_program_repeat1,
    STATE(407), 1,
      aux_sym_template_content_repeat1,
    STATE(703), 1,
      aux_sym_if_statement_repeat1,
    STATE(866), 1,
      sym_else_clause,
    STATE(956), 1,
      sym_elsif_clause,
    ACTIONS(665), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(669), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(679), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(639), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(638), 19,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [13326] = 11,
    ACTIONS(663), 1,
      aux_sym_template_content_token1,
    STATE(179), 1,
      aux_sym_program_repeat1,
    STATE(407), 1,
      aux_sym_template_content_repeat1,
    STATE(679), 1,
      aux_sym_if_statement_repeat1,
    STATE(879), 1,
      sym_else_clause,
    STATE(956), 1,
      sym_elsif_clause,
    ACTIONS(665), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(669), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(681), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(639), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(638), 19,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [13382] = 11,
    ACTIONS(663), 1,
      aux_sym_template_content_token1,
    STATE(179), 1,
      aux_sym_program_repeat1,
    STATE(407), 1,
      aux_sym_template_content_repeat1,
    STATE(704), 1,
      aux_sym_if_statement_repeat1,
    STATE(880), 1,
      sym_else_clause,
    STATE(956), 1,
      sym_elsif_clause,
    ACTIONS(665), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(669), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(683), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(639), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(638), 19,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [13438] = 2,
    ACTIONS(687), 7,
      sym__inline_comment_content,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
    ACTIONS(685), 26,
      anon_sym_LBRACE_LBRACE,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_echo,
      anon_sym_section,
      anon_sym_sections,
      anon_sym_increment,
      anon_sym_decrement,
      anon_sym_layout,
      anon_sym_assign,
      anon_sym_cycle,
      anon_sym_include,
      anon_sym_include_relative,
      anon_sym_render,
      anon_sym_for,
      anon_sym_if,
      anon_sym_case,
      anon_sym_unless,
      anon_sym_capture,
      anon_sym_form,
      anon_sym_tablerow,
      anon_sym_paginate,
      anon_sym_comment,
  [13476] = 11,
    ACTIONS(663), 1,
      aux_sym_template_content_token1,
    STATE(143), 1,
      aux_sym_program_repeat1,
    STATE(407), 1,
      aux_sym_template_content_repeat1,
    STATE(707), 1,
      aux_sym_if_statement_repeat1,
    STATE(953), 1,
      sym_else_clause,
    STATE(956), 1,
      sym_elsif_clause,
    ACTIONS(665), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(669), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(689), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(639), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(638), 19,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [13532] = 5,
    ACTIONS(293), 1,
      anon_sym_DOT,
    ACTIONS(295), 1,
      anon_sym_LBRACK,
    ACTIONS(695), 1,
      anon_sym_COMMA,
    ACTIONS(693), 4,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
    ACTIONS(691), 26,
      anon_sym_LBRACE_LBRACE,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_echo,
      anon_sym_section,
      anon_sym_sections,
      anon_sym_increment,
      anon_sym_decrement,
      anon_sym_layout,
      anon_sym_assign,
      anon_sym_cycle,
      anon_sym_include,
      anon_sym_include_relative,
      anon_sym_render,
      anon_sym_for,
      anon_sym_if,
      anon_sym_case,
      anon_sym_unless,
      anon_sym_capture,
      anon_sym_form,
      anon_sym_tablerow,
      anon_sym_paginate,
      anon_sym_endpaginate,
  [13576] = 11,
    ACTIONS(663), 1,
      aux_sym_template_content_token1,
    STATE(150), 1,
      aux_sym_program_repeat1,
    STATE(407), 1,
      aux_sym_template_content_repeat1,
    STATE(698), 1,
      aux_sym_if_statement_repeat1,
    STATE(901), 1,
      sym_else_clause,
    STATE(956), 1,
      sym_elsif_clause,
    ACTIONS(665), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(669), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(697), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(639), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(638), 19,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [13632] = 2,
    ACTIONS(701), 7,
      sym__inline_comment_content,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
    ACTIONS(699), 26,
      anon_sym_LBRACE_LBRACE,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_echo,
      anon_sym_section,
      anon_sym_sections,
      anon_sym_increment,
      anon_sym_decrement,
      anon_sym_layout,
      anon_sym_assign,
      anon_sym_cycle,
      anon_sym_include,
      anon_sym_include_relative,
      anon_sym_render,
      anon_sym_for,
      anon_sym_if,
      anon_sym_case,
      anon_sym_unless,
      anon_sym_capture,
      anon_sym_form,
      anon_sym_tablerow,
      anon_sym_paginate,
      anon_sym_comment,
  [13670] = 2,
    ACTIONS(653), 6,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
    ACTIONS(651), 26,
      anon_sym_LBRACE_LBRACE,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_echo,
      anon_sym_section,
      anon_sym_sections,
      anon_sym_increment,
      anon_sym_decrement,
      anon_sym_layout,
      anon_sym_assign,
      anon_sym_cycle,
      anon_sym_include,
      anon_sym_include_relative,
      anon_sym_render,
      anon_sym_for,
      anon_sym_if,
      anon_sym_case,
      anon_sym_unless,
      anon_sym_capture,
      anon_sym_form,
      anon_sym_tablerow,
      anon_sym_paginate,
      anon_sym_endpaginate,
  [13707] = 9,
    ACTIONS(5), 1,
      aux_sym_template_content_token1,
    ACTIONS(703), 1,
      ts_builtin_sym_end,
    STATE(163), 1,
      aux_sym_program_repeat1,
    STATE(394), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(7), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(9), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    ACTIONS(11), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    STATE(408), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(453), 19,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [13757] = 9,
    ACTIONS(5), 1,
      aux_sym_template_content_token1,
    ACTIONS(705), 1,
      ts_builtin_sym_end,
    STATE(163), 1,
      aux_sym_program_repeat1,
    STATE(394), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(7), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(9), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    ACTIONS(11), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    STATE(408), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(453), 19,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [13807] = 9,
    ACTIONS(5), 1,
      aux_sym_template_content_token1,
    ACTIONS(703), 1,
      ts_builtin_sym_end,
    STATE(158), 1,
      aux_sym_program_repeat1,
    STATE(394), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(7), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(9), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    ACTIONS(11), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    STATE(408), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(453), 19,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [13857] = 10,
    ACTIONS(663), 1,
      aux_sym_template_content_token1,
    ACTIONS(707), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(709), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(161), 1,
      aux_sym_program_repeat1,
    STATE(407), 1,
      aux_sym_template_content_repeat1,
    STATE(849), 1,
      sym_else_clause,
    ACTIONS(665), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(669), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    STATE(639), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(638), 19,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [13909] = 10,
    ACTIONS(663), 1,
      aux_sym_template_content_token1,
    ACTIONS(711), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(713), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(179), 1,
      aux_sym_program_repeat1,
    STATE(407), 1,
      aux_sym_template_content_repeat1,
    STATE(808), 1,
      sym_else_clause,
    ACTIONS(665), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(669), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    STATE(639), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(638), 19,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [13961] = 3,
    ACTIONS(695), 1,
      anon_sym_COMMA,
    ACTIONS(693), 4,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
    ACTIONS(691), 26,
      anon_sym_LBRACE_LBRACE,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_echo,
      anon_sym_section,
      anon_sym_sections,
      anon_sym_increment,
      anon_sym_decrement,
      anon_sym_layout,
      anon_sym_assign,
      anon_sym_cycle,
      anon_sym_include,
      anon_sym_include_relative,
      anon_sym_render,
      anon_sym_for,
      anon_sym_if,
      anon_sym_case,
      anon_sym_unless,
      anon_sym_capture,
      anon_sym_form,
      anon_sym_tablerow,
      anon_sym_paginate,
      anon_sym_endpaginate,
  [13999] = 9,
    ACTIONS(715), 1,
      ts_builtin_sym_end,
    ACTIONS(717), 1,
      aux_sym_template_content_token1,
    STATE(163), 1,
      aux_sym_program_repeat1,
    STATE(394), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(720), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(723), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    ACTIONS(726), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    STATE(408), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(453), 19,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [14049] = 10,
    ACTIONS(663), 1,
      aux_sym_template_content_token1,
    ACTIONS(729), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(731), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(179), 1,
      aux_sym_program_repeat1,
    STATE(407), 1,
      aux_sym_template_content_repeat1,
    STATE(848), 1,
      sym_else_clause,
    ACTIONS(665), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(669), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    STATE(639), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(638), 19,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [14101] = 10,
    ACTIONS(663), 1,
      aux_sym_template_content_token1,
    ACTIONS(733), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(735), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(164), 1,
      aux_sym_program_repeat1,
    STATE(407), 1,
      aux_sym_template_content_repeat1,
    STATE(862), 1,
      sym_else_clause,
    ACTIONS(665), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(669), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    STATE(639), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(638), 19,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [14153] = 10,
    ACTIONS(663), 1,
      aux_sym_template_content_token1,
    ACTIONS(737), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(739), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(169), 1,
      aux_sym_program_repeat1,
    STATE(407), 1,
      aux_sym_template_content_repeat1,
    STATE(860), 1,
      sym_else_clause,
    ACTIONS(665), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(669), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    STATE(639), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(638), 19,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [14205] = 10,
    ACTIONS(663), 1,
      aux_sym_template_content_token1,
    ACTIONS(741), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(743), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(179), 1,
      aux_sym_program_repeat1,
    STATE(407), 1,
      aux_sym_template_content_repeat1,
    STATE(852), 1,
      sym_else_clause,
    ACTIONS(665), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(669), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    STATE(639), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(638), 19,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [14257] = 10,
    ACTIONS(663), 1,
      aux_sym_template_content_token1,
    ACTIONS(745), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(747), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(167), 1,
      aux_sym_program_repeat1,
    STATE(407), 1,
      aux_sym_template_content_repeat1,
    STATE(839), 1,
      sym_else_clause,
    ACTIONS(665), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(669), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    STATE(639), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(638), 19,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [14309] = 10,
    ACTIONS(663), 1,
      aux_sym_template_content_token1,
    ACTIONS(749), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(751), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(179), 1,
      aux_sym_program_repeat1,
    STATE(407), 1,
      aux_sym_template_content_repeat1,
    STATE(845), 1,
      sym_else_clause,
    ACTIONS(665), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(669), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    STATE(639), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(638), 19,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [14361] = 8,
    ACTIONS(663), 1,
      aux_sym_template_content_token1,
    STATE(200), 1,
      aux_sym_program_repeat1,
    STATE(407), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(665), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(669), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(753), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(639), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(638), 19,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [14408] = 7,
    ACTIONS(305), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(756), 1,
      anon_sym_COLON,
    ACTIONS(758), 1,
      anon_sym_COMMA,
    ACTIONS(760), 1,
      anon_sym_DOT,
    ACTIONS(762), 1,
      anon_sym_LBRACK,
    STATE(224), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(303), 24,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      sym_identifier,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_PIPE,
  [14453] = 9,
    ACTIONS(663), 1,
      aux_sym_template_content_token1,
    ACTIONS(764), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(766), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(179), 1,
      aux_sym_program_repeat1,
    STATE(407), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(665), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(669), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    STATE(639), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(638), 19,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [14502] = 8,
    ACTIONS(663), 1,
      aux_sym_template_content_token1,
    STATE(179), 1,
      aux_sym_program_repeat1,
    STATE(407), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(665), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(669), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(768), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(639), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(638), 19,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [14549] = 9,
    ACTIONS(663), 1,
      aux_sym_template_content_token1,
    ACTIONS(770), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(772), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(194), 1,
      aux_sym_program_repeat1,
    STATE(407), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(665), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(669), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    STATE(639), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(638), 19,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [14598] = 9,
    ACTIONS(663), 1,
      aux_sym_template_content_token1,
    ACTIONS(774), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(776), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(179), 1,
      aux_sym_program_repeat1,
    STATE(407), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(665), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(669), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    STATE(639), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(638), 19,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [14647] = 8,
    ACTIONS(663), 1,
      aux_sym_template_content_token1,
    STATE(193), 1,
      aux_sym_program_repeat1,
    STATE(407), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(665), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(669), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(778), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(639), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(638), 19,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [14694] = 2,
    ACTIONS(331), 13,
      sym_identifier,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_DOT,
      anon_sym_else,
      anon_sym_endcase,
      anon_sym_when,
      anon_sym_by,
    ACTIONS(333), 17,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_LBRACK,
      anon_sym_DOT_DOT,
      anon_sym_RPAREN,
  [14729] = 9,
    ACTIONS(663), 1,
      aux_sym_template_content_token1,
    ACTIONS(780), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(782), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(207), 1,
      aux_sym_program_repeat1,
    STATE(407), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(665), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(669), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    STATE(639), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(638), 19,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [14778] = 8,
    ACTIONS(784), 1,
      aux_sym_template_content_token1,
    STATE(179), 1,
      aux_sym_program_repeat1,
    STATE(407), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(787), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(790), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    ACTIONS(793), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    STATE(639), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(638), 19,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [14825] = 9,
    ACTIONS(663), 1,
      aux_sym_template_content_token1,
    ACTIONS(796), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(798), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(179), 1,
      aux_sym_program_repeat1,
    STATE(407), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(665), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(669), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    STATE(639), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(638), 19,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [14874] = 9,
    ACTIONS(663), 1,
      aux_sym_template_content_token1,
    ACTIONS(800), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(802), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(205), 1,
      aux_sym_program_repeat1,
    STATE(407), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(665), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(669), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    STATE(639), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(638), 19,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [14923] = 9,
    ACTIONS(663), 1,
      aux_sym_template_content_token1,
    ACTIONS(804), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(806), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(204), 1,
      aux_sym_program_repeat1,
    STATE(407), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(665), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(669), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    STATE(639), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(638), 19,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [14972] = 9,
    ACTIONS(663), 1,
      aux_sym_template_content_token1,
    ACTIONS(808), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(810), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(179), 1,
      aux_sym_program_repeat1,
    STATE(407), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(665), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(669), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    STATE(639), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(638), 19,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [15021] = 8,
    ACTIONS(663), 1,
      aux_sym_template_content_token1,
    STATE(202), 1,
      aux_sym_program_repeat1,
    STATE(407), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(665), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(669), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(812), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(639), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(638), 19,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [15068] = 8,
    ACTIONS(663), 1,
      aux_sym_template_content_token1,
    STATE(179), 1,
      aux_sym_program_repeat1,
    STATE(407), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(665), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(669), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(814), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(639), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(638), 19,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [15115] = 9,
    ACTIONS(663), 1,
      aux_sym_template_content_token1,
    ACTIONS(816), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(818), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(180), 1,
      aux_sym_program_repeat1,
    STATE(407), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(665), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(669), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    STATE(639), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(638), 19,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [15164] = 9,
    ACTIONS(663), 1,
      aux_sym_template_content_token1,
    ACTIONS(820), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(822), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(183), 1,
      aux_sym_program_repeat1,
    STATE(407), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(665), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(669), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    STATE(639), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(638), 19,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [15213] = 9,
    ACTIONS(663), 1,
      aux_sym_template_content_token1,
    ACTIONS(824), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(826), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(172), 1,
      aux_sym_program_repeat1,
    STATE(407), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(665), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(669), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    STATE(639), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(638), 19,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [15262] = 8,
    ACTIONS(663), 1,
      aux_sym_template_content_token1,
    STATE(179), 1,
      aux_sym_program_repeat1,
    STATE(407), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(665), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(669), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(828), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(639), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(638), 19,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [15309] = 8,
    ACTIONS(663), 1,
      aux_sym_template_content_token1,
    STATE(179), 1,
      aux_sym_program_repeat1,
    STATE(407), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(665), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(669), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(831), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(639), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(638), 19,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [15356] = 8,
    ACTIONS(663), 1,
      aux_sym_template_content_token1,
    STATE(179), 1,
      aux_sym_program_repeat1,
    STATE(407), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(665), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(669), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(834), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(639), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(638), 19,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [15403] = 8,
    ACTIONS(663), 1,
      aux_sym_template_content_token1,
    STATE(189), 1,
      aux_sym_program_repeat1,
    STATE(407), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(665), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(669), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(836), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(639), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(638), 19,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [15450] = 8,
    ACTIONS(663), 1,
      aux_sym_template_content_token1,
    STATE(179), 1,
      aux_sym_program_repeat1,
    STATE(407), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(665), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(669), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(839), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(639), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(638), 19,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [15497] = 9,
    ACTIONS(663), 1,
      aux_sym_template_content_token1,
    ACTIONS(841), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(843), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(179), 1,
      aux_sym_program_repeat1,
    STATE(407), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(665), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(669), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    STATE(639), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(638), 19,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [15546] = 8,
    ACTIONS(663), 1,
      aux_sym_template_content_token1,
    STATE(173), 1,
      aux_sym_program_repeat1,
    STATE(407), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(665), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(669), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(845), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(639), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(638), 19,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [15593] = 8,
    ACTIONS(663), 1,
      aux_sym_template_content_token1,
    STATE(185), 1,
      aux_sym_program_repeat1,
    STATE(407), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(665), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(669), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(847), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(639), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(638), 19,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [15640] = 9,
    ACTIONS(663), 1,
      aux_sym_template_content_token1,
    ACTIONS(849), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(851), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(175), 1,
      aux_sym_program_repeat1,
    STATE(407), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(665), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(669), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    STATE(639), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(638), 19,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [15689] = 8,
    ACTIONS(663), 1,
      aux_sym_template_content_token1,
    STATE(206), 1,
      aux_sym_program_repeat1,
    STATE(407), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(665), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(669), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(853), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(639), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(638), 19,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [15736] = 8,
    ACTIONS(663), 1,
      aux_sym_template_content_token1,
    STATE(191), 1,
      aux_sym_program_repeat1,
    STATE(407), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(665), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(669), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(855), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(639), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(638), 19,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [15783] = 8,
    ACTIONS(663), 1,
      aux_sym_template_content_token1,
    STATE(179), 1,
      aux_sym_program_repeat1,
    STATE(407), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(665), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(669), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(857), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(639), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(638), 19,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [15830] = 8,
    ACTIONS(663), 1,
      aux_sym_template_content_token1,
    STATE(190), 1,
      aux_sym_program_repeat1,
    STATE(407), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(665), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(669), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(860), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(639), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(638), 19,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [15877] = 8,
    ACTIONS(663), 1,
      aux_sym_template_content_token1,
    STATE(179), 1,
      aux_sym_program_repeat1,
    STATE(407), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(665), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(669), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(863), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(639), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(638), 19,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [15924] = 2,
    ACTIONS(335), 13,
      sym_identifier,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_DOT,
      anon_sym_else,
      anon_sym_endcase,
      anon_sym_when,
      anon_sym_by,
    ACTIONS(337), 17,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_LBRACK,
      anon_sym_DOT_DOT,
      anon_sym_RPAREN,
  [15959] = 9,
    ACTIONS(663), 1,
      aux_sym_template_content_token1,
    ACTIONS(865), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(867), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(179), 1,
      aux_sym_program_repeat1,
    STATE(407), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(665), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(669), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    STATE(639), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(638), 19,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [16008] = 9,
    ACTIONS(663), 1,
      aux_sym_template_content_token1,
    ACTIONS(869), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(871), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(179), 1,
      aux_sym_program_repeat1,
    STATE(407), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(665), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(669), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    STATE(639), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(638), 19,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [16057] = 8,
    ACTIONS(663), 1,
      aux_sym_template_content_token1,
    STATE(179), 1,
      aux_sym_program_repeat1,
    STATE(407), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(665), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(669), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(873), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(639), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(638), 19,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [16104] = 9,
    ACTIONS(663), 1,
      aux_sym_template_content_token1,
    ACTIONS(875), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(877), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(179), 1,
      aux_sym_program_repeat1,
    STATE(407), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(665), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(669), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    STATE(639), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(638), 19,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [16153] = 5,
    ACTIONS(311), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(756), 1,
      anon_sym_COLON,
    ACTIONS(760), 1,
      anon_sym_DOT,
    ACTIONS(762), 1,
      anon_sym_LBRACK,
    ACTIONS(309), 25,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      sym_identifier,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_COMMA,
      anon_sym_PIPE,
  [16193] = 8,
    ACTIONS(879), 1,
      aux_sym_template_content_token1,
    STATE(407), 1,
      aux_sym_template_content_repeat1,
    STATE(626), 1,
      sym_template_content,
    ACTIONS(882), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(885), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    ACTIONS(888), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    STATE(639), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(209), 18,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
      aux_sym_javascript_statement_repeat1,
  [16239] = 6,
    ACTIONS(305), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(758), 1,
      anon_sym_COMMA,
    ACTIONS(760), 1,
      anon_sym_DOT,
    ACTIONS(762), 1,
      anon_sym_LBRACK,
    STATE(224), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(303), 24,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      sym_identifier,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_PIPE,
  [16281] = 8,
    ACTIONS(663), 1,
      aux_sym_template_content_token1,
    STATE(407), 1,
      aux_sym_template_content_repeat1,
    STATE(625), 1,
      sym_template_content,
    ACTIONS(665), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(669), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(891), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(639), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(219), 18,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
      aux_sym_style_statement_repeat1,
  [16327] = 8,
    ACTIONS(663), 1,
      aux_sym_template_content_token1,
    STATE(407), 1,
      aux_sym_template_content_repeat1,
    STATE(626), 1,
      sym_template_content,
    ACTIONS(665), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(669), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(893), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(639), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(214), 18,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
      aux_sym_javascript_statement_repeat1,
  [16373] = 8,
    ACTIONS(663), 1,
      aux_sym_template_content_token1,
    STATE(407), 1,
      aux_sym_template_content_repeat1,
    STATE(625), 1,
      sym_template_content,
    ACTIONS(665), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(669), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(895), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(639), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(211), 18,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
      aux_sym_style_statement_repeat1,
  [16419] = 8,
    ACTIONS(663), 1,
      aux_sym_template_content_token1,
    STATE(407), 1,
      aux_sym_template_content_repeat1,
    STATE(626), 1,
      sym_template_content,
    ACTIONS(665), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(669), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(897), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(639), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(209), 18,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
      aux_sym_javascript_statement_repeat1,
  [16465] = 8,
    ACTIONS(663), 1,
      aux_sym_template_content_token1,
    STATE(407), 1,
      aux_sym_template_content_repeat1,
    STATE(626), 1,
      sym_template_content,
    ACTIONS(665), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(669), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(899), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(639), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(216), 18,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
      aux_sym_javascript_statement_repeat1,
  [16511] = 8,
    ACTIONS(663), 1,
      aux_sym_template_content_token1,
    STATE(407), 1,
      aux_sym_template_content_repeat1,
    STATE(626), 1,
      sym_template_content,
    ACTIONS(665), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(669), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(901), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(639), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(209), 18,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
      aux_sym_javascript_statement_repeat1,
  [16557] = 8,
    ACTIONS(663), 1,
      aux_sym_template_content_token1,
    STATE(407), 1,
      aux_sym_template_content_repeat1,
    STATE(625), 1,
      sym_template_content,
    ACTIONS(665), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(669), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(903), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(639), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(219), 18,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
      aux_sym_style_statement_repeat1,
  [16603] = 8,
    ACTIONS(663), 1,
      aux_sym_template_content_token1,
    STATE(407), 1,
      aux_sym_template_content_repeat1,
    STATE(625), 1,
      sym_template_content,
    ACTIONS(665), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(669), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(905), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(639), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(217), 18,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
      aux_sym_style_statement_repeat1,
  [16649] = 8,
    ACTIONS(907), 1,
      aux_sym_template_content_token1,
    STATE(407), 1,
      aux_sym_template_content_repeat1,
    STATE(625), 1,
      sym_template_content,
    ACTIONS(910), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(913), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    ACTIONS(916), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    STATE(639), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(219), 18,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
      aux_sym_style_statement_repeat1,
  [16695] = 4,
    ACTIONS(321), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(760), 1,
      anon_sym_DOT,
    ACTIONS(762), 1,
      anon_sym_LBRACK,
    ACTIONS(319), 25,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      sym_identifier,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_COMMA,
      anon_sym_PIPE,
  [16732] = 4,
    ACTIONS(311), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(760), 1,
      anon_sym_DOT,
    ACTIONS(762), 1,
      anon_sym_LBRACK,
    ACTIONS(309), 25,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      sym_identifier,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_COMMA,
      anon_sym_PIPE,
  [16769] = 2,
    ACTIONS(337), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(335), 27,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      sym_identifier,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_LBRACK,
  [16802] = 2,
    ACTIONS(333), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(331), 27,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      sym_identifier,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_LBRACK,
  [16835] = 4,
    ACTIONS(350), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(758), 1,
      anon_sym_COMMA,
    STATE(225), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(348), 24,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      sym_identifier,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_PIPE,
  [16871] = 4,
    ACTIONS(311), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(919), 1,
      anon_sym_COMMA,
    STATE(225), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(309), 24,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      sym_identifier,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_PIPE,
  [16907] = 4,
    ACTIONS(305), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(758), 1,
      anon_sym_COMMA,
    STATE(224), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(303), 24,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      sym_identifier,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_PIPE,
  [16943] = 4,
    ACTIONS(95), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(760), 1,
      anon_sym_DOT,
    ACTIONS(762), 1,
      anon_sym_LBRACK,
    ACTIONS(97), 24,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      sym_identifier,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_PIPE,
  [16979] = 7,
    ACTIONS(922), 1,
      anon_sym_COLON,
    ACTIONS(924), 1,
      anon_sym_COMMA,
    ACTIONS(926), 1,
      anon_sym_DOT,
    ACTIONS(928), 1,
      anon_sym_LBRACK,
    STATE(251), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(303), 8,
      sym_identifier,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
    ACTIONS(305), 13,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
  [17020] = 12,
    ACTIONS(29), 1,
      anon_sym_PLUS,
    ACTIONS(31), 1,
      anon_sym_DASH,
    ACTIONS(35), 1,
      anon_sym_CARET,
    ACTIONS(43), 1,
      anon_sym_contains,
    ACTIONS(69), 1,
      anon_sym_PIPE,
    ACTIONS(374), 1,
      anon_sym_PERCENT,
    ACTIONS(33), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(39), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(41), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(37), 4,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
    ACTIONS(930), 4,
      anon_sym_LBRACE_LBRACE,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(932), 6,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
  [17071] = 2,
    ACTIONS(321), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(319), 25,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      sym_identifier,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_COMMA,
      anon_sym_PIPE,
  [17102] = 2,
    ACTIONS(352), 10,
      sym_identifier,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_for,
      anon_sym_with,
    ACTIONS(354), 16,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_RBRACK,
  [17133] = 2,
    ACTIONS(311), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(309), 25,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      sym_identifier,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_COMMA,
      anon_sym_PIPE,
  [17164] = 2,
    ACTIONS(354), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(352), 25,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      sym_identifier,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_COMMA,
      anon_sym_PIPE,
  [17195] = 2,
    ACTIONS(358), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(356), 25,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      sym_identifier,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_COMMA,
      anon_sym_PIPE,
  [17226] = 3,
    ACTIONS(362), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(934), 1,
      anon_sym_COLON,
    ACTIONS(360), 24,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      sym_identifier,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_PIPE,
  [17259] = 4,
    ACTIONS(372), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(938), 1,
      anon_sym_CARET,
    ACTIONS(936), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(370), 20,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      sym_identifier,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_PIPE,
  [17293] = 5,
    ACTIONS(372), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(938), 1,
      anon_sym_CARET,
    ACTIONS(940), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(936), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(370), 18,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      sym_identifier,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_PIPE,
  [17329] = 7,
    ACTIONS(372), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(938), 1,
      anon_sym_CARET,
    ACTIONS(940), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(944), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(936), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(942), 6,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
    ACTIONS(370), 10,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      sym_identifier,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      anon_sym_contains,
      anon_sym_PIPE,
  [17369] = 6,
    ACTIONS(924), 1,
      anon_sym_COMMA,
    ACTIONS(926), 1,
      anon_sym_DOT,
    ACTIONS(928), 1,
      anon_sym_LBRACK,
    STATE(251), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(303), 8,
      sym_identifier,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
    ACTIONS(305), 13,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
  [17407] = 2,
    ACTIONS(368), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(366), 24,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      sym_identifier,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_PIPE,
  [17437] = 2,
    ACTIONS(372), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(370), 24,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      sym_identifier,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_PIPE,
  [17467] = 5,
    ACTIONS(922), 1,
      anon_sym_COLON,
    ACTIONS(926), 1,
      anon_sym_DOT,
    ACTIONS(928), 1,
      anon_sym_LBRACK,
    ACTIONS(309), 8,
      sym_identifier,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
    ACTIONS(311), 14,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_COMMA,
      anon_sym_PIPE,
  [17503] = 2,
    ACTIONS(378), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(376), 24,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      sym_identifier,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_PIPE,
  [17533] = 9,
    ACTIONS(932), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(938), 1,
      anon_sym_CARET,
    ACTIONS(946), 1,
      anon_sym_contains,
    ACTIONS(948), 1,
      anon_sym_PIPE,
    ACTIONS(940), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(944), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(936), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(942), 6,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
    ACTIONS(930), 8,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      sym_identifier,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [17577] = 3,
    ACTIONS(372), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(938), 1,
      anon_sym_CARET,
    ACTIONS(370), 23,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      sym_identifier,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_PIPE,
  [17609] = 6,
    ACTIONS(372), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(938), 1,
      anon_sym_CARET,
    ACTIONS(940), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(936), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(942), 6,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
    ACTIONS(370), 12,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      sym_identifier,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_PIPE,
  [17647] = 4,
    ACTIONS(926), 1,
      anon_sym_DOT,
    ACTIONS(928), 1,
      anon_sym_LBRACK,
    ACTIONS(319), 8,
      sym_identifier,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
    ACTIONS(321), 14,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_COMMA,
      anon_sym_PIPE,
  [17680] = 4,
    ACTIONS(926), 1,
      anon_sym_DOT,
    ACTIONS(928), 1,
      anon_sym_LBRACK,
    ACTIONS(309), 8,
      sym_identifier,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
    ACTIONS(311), 14,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_COMMA,
      anon_sym_PIPE,
  [17713] = 4,
    ACTIONS(926), 1,
      anon_sym_DOT,
    ACTIONS(928), 1,
      anon_sym_LBRACK,
    ACTIONS(97), 8,
      sym_identifier,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
    ACTIONS(95), 13,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
  [17745] = 4,
    ACTIONS(950), 1,
      anon_sym_COMMA,
    STATE(250), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(309), 8,
      sym_identifier,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
    ACTIONS(311), 13,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
  [17777] = 4,
    ACTIONS(924), 1,
      anon_sym_COMMA,
    STATE(250), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(348), 8,
      sym_identifier,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
    ACTIONS(350), 13,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
  [17809] = 8,
    ACTIONS(926), 1,
      anon_sym_DOT,
    ACTIONS(928), 1,
      anon_sym_LBRACK,
    ACTIONS(953), 1,
      anon_sym_COLON,
    ACTIONS(955), 1,
      anon_sym_COMMA,
    STATE(725), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(305), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
    ACTIONS(97), 4,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(95), 12,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_PIPE,
  [17849] = 4,
    ACTIONS(924), 1,
      anon_sym_COMMA,
    STATE(251), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(303), 8,
      sym_identifier,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
    ACTIONS(305), 13,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
  [17881] = 7,
    ACTIONS(305), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(647), 1,
      anon_sym_DOT,
    ACTIONS(649), 1,
      anon_sym_LBRACK,
    ACTIONS(957), 1,
      anon_sym_COLON,
    ACTIONS(959), 1,
      anon_sym_COMMA,
    STATE(276), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(303), 17,
      sym_identifier,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_PIPE,
  [17919] = 2,
    ACTIONS(309), 8,
      sym_identifier,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
    ACTIONS(311), 14,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_COMMA,
      anon_sym_PIPE,
  [17946] = 2,
    ACTIONS(319), 8,
      sym_identifier,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
    ACTIONS(321), 14,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_COMMA,
      anon_sym_PIPE,
  [17973] = 5,
    ACTIONS(311), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(647), 1,
      anon_sym_DOT,
    ACTIONS(649), 1,
      anon_sym_LBRACK,
    ACTIONS(957), 1,
      anon_sym_COLON,
    ACTIONS(309), 18,
      sym_identifier,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_COMMA,
      anon_sym_PIPE,
  [18006] = 2,
    ACTIONS(354), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(352), 21,
      sym_identifier,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_for,
      anon_sym_with,
      anon_sym_PIPE,
  [18033] = 3,
    ACTIONS(961), 1,
      anon_sym_COLON,
    ACTIONS(360), 8,
      sym_identifier,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
    ACTIONS(362), 13,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
  [18062] = 2,
    ACTIONS(356), 8,
      sym_identifier,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
    ACTIONS(358), 14,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_COMMA,
      anon_sym_PIPE,
  [18089] = 7,
    ACTIONS(926), 1,
      anon_sym_DOT,
    ACTIONS(928), 1,
      anon_sym_LBRACK,
    ACTIONS(955), 1,
      anon_sym_COMMA,
    STATE(725), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(305), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
    ACTIONS(97), 4,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(95), 12,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_PIPE,
  [18126] = 6,
    ACTIONS(305), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(647), 1,
      anon_sym_DOT,
    ACTIONS(649), 1,
      anon_sym_LBRACK,
    ACTIONS(959), 1,
      anon_sym_COMMA,
    STATE(276), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(303), 17,
      sym_identifier,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_PIPE,
  [18161] = 4,
    ACTIONS(321), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(647), 1,
      anon_sym_DOT,
    ACTIONS(649), 1,
      anon_sym_LBRACK,
    ACTIONS(319), 18,
      sym_identifier,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_COMMA,
      anon_sym_PIPE,
  [18191] = 2,
    ACTIONS(366), 8,
      sym_identifier,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
    ACTIONS(368), 13,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
  [18217] = 2,
    ACTIONS(337), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(335), 20,
      sym_identifier,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_LBRACK,
  [18243] = 2,
    ACTIONS(333), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(331), 20,
      sym_identifier,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_LBRACK,
  [18269] = 10,
    ACTIONS(963), 1,
      anon_sym_PLUS,
    ACTIONS(965), 1,
      anon_sym_DASH,
    ACTIONS(969), 1,
      anon_sym_PERCENT,
    ACTIONS(971), 1,
      anon_sym_CARET,
    ACTIONS(370), 2,
      sym_identifier,
      anon_sym_contains,
    ACTIONS(967), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(975), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(977), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(973), 4,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
    ACTIONS(372), 5,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
      anon_sym_PIPE,
  [18311] = 2,
    ACTIONS(376), 8,
      sym_identifier,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
    ACTIONS(378), 13,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
  [18337] = 9,
    ACTIONS(963), 1,
      anon_sym_PLUS,
    ACTIONS(965), 1,
      anon_sym_DASH,
    ACTIONS(969), 1,
      anon_sym_PERCENT,
    ACTIONS(971), 1,
      anon_sym_CARET,
    ACTIONS(967), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(975), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(370), 4,
      sym_identifier,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
    ACTIONS(973), 4,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
    ACTIONS(372), 5,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
      anon_sym_PIPE,
  [18377] = 7,
    ACTIONS(963), 1,
      anon_sym_PLUS,
    ACTIONS(965), 1,
      anon_sym_DASH,
    ACTIONS(969), 1,
      anon_sym_PERCENT,
    ACTIONS(971), 1,
      anon_sym_CARET,
    ACTIONS(967), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(370), 6,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
    ACTIONS(372), 9,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
  [18413] = 2,
    ACTIONS(370), 8,
      sym_identifier,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
    ACTIONS(372), 13,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
  [18439] = 3,
    ACTIONS(971), 1,
      anon_sym_CARET,
    ACTIONS(370), 8,
      sym_identifier,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
    ACTIONS(372), 12,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
  [18467] = 4,
    ACTIONS(311), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(647), 1,
      anon_sym_DOT,
    ACTIONS(649), 1,
      anon_sym_LBRACK,
    ACTIONS(309), 18,
      sym_identifier,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_COMMA,
      anon_sym_PIPE,
  [18497] = 5,
    ACTIONS(969), 1,
      anon_sym_PERCENT,
    ACTIONS(971), 1,
      anon_sym_CARET,
    ACTIONS(967), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(370), 7,
      sym_identifier,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
    ACTIONS(372), 10,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
  [18529] = 4,
    ACTIONS(305), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(959), 1,
      anon_sym_COMMA,
    STATE(276), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(303), 17,
      sym_identifier,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_PIPE,
  [18558] = 4,
    ACTIONS(350), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(959), 1,
      anon_sym_COMMA,
    STATE(278), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(348), 17,
      sym_identifier,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_PIPE,
  [18587] = 4,
    ACTIONS(95), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(647), 1,
      anon_sym_DOT,
    ACTIONS(649), 1,
      anon_sym_LBRACK,
    ACTIONS(97), 17,
      sym_identifier,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_PIPE,
  [18616] = 4,
    ACTIONS(311), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(979), 1,
      anon_sym_COMMA,
    STATE(278), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(309), 17,
      sym_identifier,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_PIPE,
  [18645] = 5,
    ACTIONS(955), 1,
      anon_sym_COMMA,
    STATE(725), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(305), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
    ACTIONS(97), 4,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(95), 12,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_PIPE,
  [18676] = 3,
    ACTIONS(362), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(982), 1,
      anon_sym_COLON,
    ACTIONS(360), 17,
      sym_identifier,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_PIPE,
  [18702] = 2,
    ACTIONS(321), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(319), 18,
      sym_identifier,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_COMMA,
      anon_sym_PIPE,
  [18726] = 2,
    ACTIONS(311), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(309), 18,
      sym_identifier,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_COMMA,
      anon_sym_PIPE,
  [18750] = 2,
    ACTIONS(358), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(356), 18,
      sym_identifier,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_COMMA,
      anon_sym_PIPE,
  [18774] = 12,
    ACTIONS(963), 1,
      anon_sym_PLUS,
    ACTIONS(965), 1,
      anon_sym_DASH,
    ACTIONS(969), 1,
      anon_sym_PERCENT,
    ACTIONS(971), 1,
      anon_sym_CARET,
    ACTIONS(984), 1,
      sym_identifier,
    ACTIONS(988), 1,
      anon_sym_contains,
    ACTIONS(990), 1,
      anon_sym_PIPE,
    ACTIONS(967), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(975), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(977), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(986), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
    ACTIONS(973), 4,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
  [18818] = 10,
    ACTIONS(963), 1,
      anon_sym_PLUS,
    ACTIONS(965), 1,
      anon_sym_DASH,
    ACTIONS(971), 1,
      anon_sym_CARET,
    ACTIONS(990), 1,
      anon_sym_PIPE,
    ACTIONS(996), 1,
      anon_sym_contains,
    ACTIONS(975), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(992), 2,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
    ACTIONS(994), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(967), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(973), 4,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
  [18857] = 10,
    ACTIONS(963), 1,
      anon_sym_PLUS,
    ACTIONS(965), 1,
      anon_sym_DASH,
    ACTIONS(971), 1,
      anon_sym_CARET,
    ACTIONS(990), 1,
      anon_sym_PIPE,
    ACTIONS(996), 1,
      anon_sym_contains,
    ACTIONS(975), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(994), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(998), 2,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
    ACTIONS(967), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(973), 4,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
  [18896] = 11,
    ACTIONS(1000), 1,
      sym_identifier,
    ACTIONS(1004), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1006), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1008), 1,
      anon_sym_SQUOTE,
    ACTIONS(1010), 1,
      anon_sym_DQUOTE,
    ACTIONS(1012), 1,
      sym_number,
    STATE(44), 1,
      sym_access,
    STATE(288), 1,
      aux_sym_custom_unpaired_statement_repeat1,
    ACTIONS(1002), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
    ACTIONS(1014), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(229), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [18937] = 11,
    ACTIONS(1016), 1,
      sym_identifier,
    ACTIONS(1021), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1024), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1027), 1,
      anon_sym_SQUOTE,
    ACTIONS(1030), 1,
      anon_sym_DQUOTE,
    ACTIONS(1033), 1,
      sym_number,
    STATE(44), 1,
      sym_access,
    STATE(288), 1,
      aux_sym_custom_unpaired_statement_repeat1,
    ACTIONS(1019), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
    ACTIONS(1036), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(229), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [18978] = 4,
    ACTIONS(372), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(1041), 1,
      anon_sym_CARET,
    ACTIONS(1039), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(370), 13,
      sym_identifier,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_PIPE,
  [19005] = 10,
    ACTIONS(963), 1,
      anon_sym_PLUS,
    ACTIONS(965), 1,
      anon_sym_DASH,
    ACTIONS(971), 1,
      anon_sym_CARET,
    ACTIONS(990), 1,
      anon_sym_PIPE,
    ACTIONS(996), 1,
      anon_sym_contains,
    ACTIONS(975), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(994), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1043), 2,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
    ACTIONS(967), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(973), 4,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
  [19044] = 11,
    ACTIONS(963), 1,
      anon_sym_PLUS,
    ACTIONS(965), 1,
      anon_sym_DASH,
    ACTIONS(969), 1,
      anon_sym_PERCENT,
    ACTIONS(971), 1,
      anon_sym_CARET,
    ACTIONS(990), 1,
      anon_sym_PIPE,
    ACTIONS(996), 1,
      anon_sym_contains,
    ACTIONS(967), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(975), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(994), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1045), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
    ACTIONS(973), 4,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
  [19085] = 11,
    ACTIONS(963), 1,
      anon_sym_PLUS,
    ACTIONS(965), 1,
      anon_sym_DASH,
    ACTIONS(969), 1,
      anon_sym_PERCENT,
    ACTIONS(971), 1,
      anon_sym_CARET,
    ACTIONS(990), 1,
      anon_sym_PIPE,
    ACTIONS(996), 1,
      anon_sym_contains,
    ACTIONS(967), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(975), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(994), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1047), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
    ACTIONS(973), 4,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
  [19126] = 7,
    ACTIONS(372), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(1041), 1,
      anon_sym_CARET,
    ACTIONS(1049), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1053), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(370), 3,
      sym_identifier,
      anon_sym_contains,
      anon_sym_PIPE,
    ACTIONS(1039), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1051), 6,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
  [19159] = 10,
    ACTIONS(963), 1,
      anon_sym_PLUS,
    ACTIONS(965), 1,
      anon_sym_DASH,
    ACTIONS(971), 1,
      anon_sym_CARET,
    ACTIONS(990), 1,
      anon_sym_PIPE,
    ACTIONS(996), 1,
      anon_sym_contains,
    ACTIONS(975), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(994), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1055), 2,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
    ACTIONS(967), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(973), 4,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
  [19198] = 6,
    ACTIONS(372), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(1041), 1,
      anon_sym_CARET,
    ACTIONS(1049), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1039), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(370), 5,
      sym_identifier,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_PIPE,
    ACTIONS(1051), 6,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
  [19229] = 11,
    ACTIONS(963), 1,
      anon_sym_PLUS,
    ACTIONS(965), 1,
      anon_sym_DASH,
    ACTIONS(969), 1,
      anon_sym_PERCENT,
    ACTIONS(971), 1,
      anon_sym_CARET,
    ACTIONS(990), 1,
      anon_sym_PIPE,
    ACTIONS(996), 1,
      anon_sym_contains,
    ACTIONS(967), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(975), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(994), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1057), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
    ACTIONS(973), 4,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
  [19270] = 11,
    ACTIONS(963), 1,
      anon_sym_PLUS,
    ACTIONS(965), 1,
      anon_sym_DASH,
    ACTIONS(969), 1,
      anon_sym_PERCENT,
    ACTIONS(971), 1,
      anon_sym_CARET,
    ACTIONS(990), 1,
      anon_sym_PIPE,
    ACTIONS(996), 1,
      anon_sym_contains,
    ACTIONS(967), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(975), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(994), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1059), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
    ACTIONS(973), 4,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
  [19311] = 11,
    ACTIONS(963), 1,
      anon_sym_PLUS,
    ACTIONS(965), 1,
      anon_sym_DASH,
    ACTIONS(969), 1,
      anon_sym_PERCENT,
    ACTIONS(971), 1,
      anon_sym_CARET,
    ACTIONS(990), 1,
      anon_sym_PIPE,
    ACTIONS(996), 1,
      anon_sym_contains,
    ACTIONS(967), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(975), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(994), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1061), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
    ACTIONS(973), 4,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
  [19352] = 9,
    ACTIONS(984), 1,
      sym_identifier,
    ACTIONS(986), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(1041), 1,
      anon_sym_CARET,
    ACTIONS(1063), 1,
      anon_sym_contains,
    ACTIONS(1065), 1,
      anon_sym_PIPE,
    ACTIONS(1049), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1053), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1039), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1051), 6,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
  [19389] = 10,
    ACTIONS(963), 1,
      anon_sym_PLUS,
    ACTIONS(965), 1,
      anon_sym_DASH,
    ACTIONS(971), 1,
      anon_sym_CARET,
    ACTIONS(990), 1,
      anon_sym_PIPE,
    ACTIONS(996), 1,
      anon_sym_contains,
    ACTIONS(975), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(994), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1067), 2,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
    ACTIONS(967), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(973), 4,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
  [19428] = 5,
    ACTIONS(372), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(1041), 1,
      anon_sym_CARET,
    ACTIONS(1049), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1039), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(370), 11,
      sym_identifier,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_PIPE,
  [19457] = 2,
    ACTIONS(368), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(366), 17,
      sym_identifier,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_PIPE,
  [19480] = 10,
    ACTIONS(963), 1,
      anon_sym_PLUS,
    ACTIONS(965), 1,
      anon_sym_DASH,
    ACTIONS(971), 1,
      anon_sym_CARET,
    ACTIONS(990), 1,
      anon_sym_PIPE,
    ACTIONS(996), 1,
      anon_sym_contains,
    ACTIONS(975), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(994), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1069), 2,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
    ACTIONS(967), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(973), 4,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
  [19519] = 11,
    ACTIONS(1000), 1,
      sym_identifier,
    ACTIONS(1004), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1006), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1008), 1,
      anon_sym_SQUOTE,
    ACTIONS(1010), 1,
      anon_sym_DQUOTE,
    ACTIONS(1012), 1,
      sym_number,
    STATE(44), 1,
      sym_access,
    STATE(287), 1,
      aux_sym_custom_unpaired_statement_repeat1,
    ACTIONS(1014), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(1071), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
    STATE(229), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [19560] = 10,
    ACTIONS(963), 1,
      anon_sym_PLUS,
    ACTIONS(965), 1,
      anon_sym_DASH,
    ACTIONS(971), 1,
      anon_sym_CARET,
    ACTIONS(990), 1,
      anon_sym_PIPE,
    ACTIONS(996), 1,
      anon_sym_contains,
    ACTIONS(975), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(994), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1073), 2,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
    ACTIONS(967), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(973), 4,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
  [19599] = 3,
    ACTIONS(1075), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
    ACTIONS(97), 4,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(95), 12,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_PIPE,
  [19624] = 2,
    ACTIONS(372), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(370), 17,
      sym_identifier,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_PIPE,
  [19647] = 10,
    ACTIONS(963), 1,
      anon_sym_PLUS,
    ACTIONS(965), 1,
      anon_sym_DASH,
    ACTIONS(971), 1,
      anon_sym_CARET,
    ACTIONS(990), 1,
      anon_sym_PIPE,
    ACTIONS(996), 1,
      anon_sym_contains,
    ACTIONS(975), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(994), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1077), 2,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
    ACTIONS(967), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(973), 4,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
  [19686] = 11,
    ACTIONS(963), 1,
      anon_sym_PLUS,
    ACTIONS(965), 1,
      anon_sym_DASH,
    ACTIONS(969), 1,
      anon_sym_PERCENT,
    ACTIONS(971), 1,
      anon_sym_CARET,
    ACTIONS(990), 1,
      anon_sym_PIPE,
    ACTIONS(996), 1,
      anon_sym_contains,
    ACTIONS(967), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(975), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(994), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1079), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
    ACTIONS(973), 4,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
  [19727] = 11,
    ACTIONS(963), 1,
      anon_sym_PLUS,
    ACTIONS(965), 1,
      anon_sym_DASH,
    ACTIONS(969), 1,
      anon_sym_PERCENT,
    ACTIONS(971), 1,
      anon_sym_CARET,
    ACTIONS(990), 1,
      anon_sym_PIPE,
    ACTIONS(996), 1,
      anon_sym_contains,
    ACTIONS(967), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(975), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(994), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1081), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
    ACTIONS(973), 4,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
  [19768] = 3,
    ACTIONS(372), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(1041), 1,
      anon_sym_CARET,
    ACTIONS(370), 16,
      sym_identifier,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_PIPE,
  [19793] = 2,
    ACTIONS(378), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(376), 17,
      sym_identifier,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_PIPE,
  [19816] = 8,
    ACTIONS(1041), 1,
      anon_sym_CARET,
    ACTIONS(1057), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(1063), 1,
      anon_sym_contains,
    ACTIONS(1065), 1,
      anon_sym_PIPE,
    ACTIONS(1049), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1053), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1039), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1051), 6,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
  [19850] = 10,
    ACTIONS(632), 1,
      sym_identifier,
    ACTIONS(639), 1,
      anon_sym_SQUOTE,
    ACTIONS(641), 1,
      anon_sym_DQUOTE,
    ACTIONS(643), 1,
      sym_number,
    ACTIONS(1002), 1,
      aux_sym__liquid_node_token1,
    STATE(227), 1,
      sym_access,
    STATE(320), 1,
      aux_sym_custom_unpaired_statement_repeat1,
    ACTIONS(637), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(645), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(244), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [19888] = 13,
    ACTIONS(1083), 1,
      sym_identifier,
    ACTIONS(1085), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1087), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1089), 1,
      anon_sym_SQUOTE,
    ACTIONS(1091), 1,
      anon_sym_DQUOTE,
    ACTIONS(1093), 1,
      sym_number,
    STATE(261), 1,
      sym_access,
    STATE(306), 1,
      sym_predicate,
    STATE(727), 1,
      sym_argument,
    STATE(838), 1,
      sym_argument_list,
    ACTIONS(1095), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(322), 2,
      sym__expression,
      sym_filter,
    STATE(279), 3,
      sym__literal,
      sym_string,
      sym_boolean,
  [19932] = 8,
    ACTIONS(1041), 1,
      anon_sym_CARET,
    ACTIONS(1063), 1,
      anon_sym_contains,
    ACTIONS(1065), 1,
      anon_sym_PIPE,
    ACTIONS(1097), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(1049), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1053), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1039), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1051), 6,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
  [19966] = 8,
    ACTIONS(1041), 1,
      anon_sym_CARET,
    ACTIONS(1061), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(1063), 1,
      anon_sym_contains,
    ACTIONS(1065), 1,
      anon_sym_PIPE,
    ACTIONS(1049), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1053), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1039), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1051), 6,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
  [20000] = 8,
    ACTIONS(1041), 1,
      anon_sym_CARET,
    ACTIONS(1063), 1,
      anon_sym_contains,
    ACTIONS(1065), 1,
      anon_sym_PIPE,
    ACTIONS(1099), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(1049), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1053), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1039), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1051), 6,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
  [20034] = 13,
    ACTIONS(1008), 1,
      anon_sym_SQUOTE,
    ACTIONS(1010), 1,
      anon_sym_DQUOTE,
    ACTIONS(1085), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1087), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1101), 1,
      sym_identifier,
    ACTIONS(1103), 1,
      sym_number,
    STATE(5), 1,
      sym_predicate,
    STATE(18), 1,
      sym_argument_list,
    STATE(38), 1,
      sym_argument,
    STATE(55), 1,
      sym_access,
    ACTIONS(1014), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(323), 2,
      sym__expression,
      sym_filter,
    STATE(56), 3,
      sym__literal,
      sym_string,
      sym_boolean,
  [20078] = 10,
    ACTIONS(1019), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(1105), 1,
      sym_identifier,
    ACTIONS(1111), 1,
      anon_sym_SQUOTE,
    ACTIONS(1114), 1,
      anon_sym_DQUOTE,
    ACTIONS(1117), 1,
      sym_number,
    STATE(227), 1,
      sym_access,
    STATE(320), 1,
      aux_sym_custom_unpaired_statement_repeat1,
    ACTIONS(1108), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1120), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(244), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [20116] = 11,
    ACTIONS(293), 1,
      anon_sym_DOT,
    ACTIONS(295), 1,
      anon_sym_LBRACK,
    ACTIONS(1089), 1,
      anon_sym_SQUOTE,
    ACTIONS(1091), 1,
      anon_sym_DQUOTE,
    ACTIONS(1123), 1,
      sym_identifier,
    ACTIONS(1125), 1,
      sym_number,
    STATE(141), 1,
      sym_argument_list,
    STATE(677), 1,
      sym_access,
    ACTIONS(630), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
    ACTIONS(1095), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(727), 4,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_argument,
  [20155] = 8,
    ACTIONS(971), 1,
      anon_sym_CARET,
    ACTIONS(990), 1,
      anon_sym_PIPE,
    ACTIONS(996), 1,
      anon_sym_contains,
    ACTIONS(963), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(975), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(994), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(967), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(973), 4,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
  [20188] = 8,
    ACTIONS(35), 1,
      anon_sym_CARET,
    ACTIONS(990), 1,
      anon_sym_PIPE,
    ACTIONS(1129), 1,
      anon_sym_contains,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(39), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1127), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(33), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(37), 4,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
  [20221] = 9,
    ACTIONS(17), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(19), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(21), 1,
      anon_sym_SQUOTE,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    ACTIONS(1131), 1,
      sym_identifier,
    ACTIONS(1133), 1,
      sym_number,
    STATE(277), 1,
      sym_access,
    ACTIONS(27), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [20255] = 9,
    ACTIONS(17), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(19), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(21), 1,
      anon_sym_SQUOTE,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    ACTIONS(1131), 1,
      sym_identifier,
    ACTIONS(1135), 1,
      sym_number,
    STATE(277), 1,
      sym_access,
    ACTIONS(27), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(289), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [20289] = 9,
    ACTIONS(1085), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1087), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1089), 1,
      anon_sym_SQUOTE,
    ACTIONS(1091), 1,
      anon_sym_DQUOTE,
    ACTIONS(1137), 1,
      sym_identifier,
    ACTIONS(1139), 1,
      sym_number,
    STATE(249), 1,
      sym_access,
    ACTIONS(1095), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(267), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [20323] = 9,
    ACTIONS(1085), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1087), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1089), 1,
      anon_sym_SQUOTE,
    ACTIONS(1091), 1,
      anon_sym_DQUOTE,
    ACTIONS(1137), 1,
      sym_identifier,
    ACTIONS(1141), 1,
      sym_number,
    STATE(249), 1,
      sym_access,
    ACTIONS(1095), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(270), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [20357] = 9,
    ACTIONS(1085), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1087), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1089), 1,
      anon_sym_SQUOTE,
    ACTIONS(1091), 1,
      anon_sym_DQUOTE,
    ACTIONS(1137), 1,
      sym_identifier,
    ACTIONS(1143), 1,
      sym_number,
    STATE(249), 1,
      sym_access,
    ACTIONS(1095), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(296), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [20391] = 9,
    ACTIONS(1085), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1087), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1089), 1,
      anon_sym_SQUOTE,
    ACTIONS(1091), 1,
      anon_sym_DQUOTE,
    ACTIONS(1137), 1,
      sym_identifier,
    ACTIONS(1145), 1,
      sym_number,
    STATE(249), 1,
      sym_access,
    ACTIONS(1095), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(269), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [20425] = 9,
    ACTIONS(1000), 1,
      sym_identifier,
    ACTIONS(1004), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1006), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1008), 1,
      anon_sym_SQUOTE,
    ACTIONS(1010), 1,
      anon_sym_DQUOTE,
    ACTIONS(1147), 1,
      sym_number,
    STATE(44), 1,
      sym_access,
    ACTIONS(1014), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(4), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [20459] = 9,
    ACTIONS(1085), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1087), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1089), 1,
      anon_sym_SQUOTE,
    ACTIONS(1091), 1,
      anon_sym_DQUOTE,
    ACTIONS(1137), 1,
      sym_identifier,
    ACTIONS(1149), 1,
      sym_number,
    STATE(249), 1,
      sym_access,
    ACTIONS(1095), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(284), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [20493] = 9,
    ACTIONS(1085), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1087), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1089), 1,
      anon_sym_SQUOTE,
    ACTIONS(1091), 1,
      anon_sym_DQUOTE,
    ACTIONS(1137), 1,
      sym_identifier,
    ACTIONS(1151), 1,
      sym_number,
    STATE(249), 1,
      sym_access,
    ACTIONS(1095), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(308), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [20527] = 9,
    ACTIONS(17), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(19), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(21), 1,
      anon_sym_SQUOTE,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    ACTIONS(1131), 1,
      sym_identifier,
    ACTIONS(1153), 1,
      sym_number,
    STATE(277), 1,
      sym_access,
    ACTIONS(27), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(313), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [20561] = 9,
    ACTIONS(17), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(19), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(21), 1,
      anon_sym_SQUOTE,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    ACTIONS(1131), 1,
      sym_identifier,
    ACTIONS(1155), 1,
      sym_number,
    STATE(277), 1,
      sym_access,
    ACTIONS(27), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(299), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [20595] = 9,
    ACTIONS(1085), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1087), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1089), 1,
      anon_sym_SQUOTE,
    ACTIONS(1091), 1,
      anon_sym_DQUOTE,
    ACTIONS(1137), 1,
      sym_identifier,
    ACTIONS(1157), 1,
      sym_number,
    STATE(249), 1,
      sym_access,
    ACTIONS(1095), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(271), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [20629] = 9,
    ACTIONS(1085), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1087), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1089), 1,
      anon_sym_SQUOTE,
    ACTIONS(1091), 1,
      anon_sym_DQUOTE,
    ACTIONS(1137), 1,
      sym_identifier,
    ACTIONS(1159), 1,
      sym_number,
    STATE(249), 1,
      sym_access,
    ACTIONS(1095), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(303), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [20663] = 9,
    ACTIONS(1085), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1087), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1089), 1,
      anon_sym_SQUOTE,
    ACTIONS(1091), 1,
      anon_sym_DQUOTE,
    ACTIONS(1137), 1,
      sym_identifier,
    ACTIONS(1161), 1,
      sym_number,
    STATE(249), 1,
      sym_access,
    ACTIONS(1095), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(272), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [20697] = 9,
    ACTIONS(1085), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1087), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1089), 1,
      anon_sym_SQUOTE,
    ACTIONS(1091), 1,
      anon_sym_DQUOTE,
    ACTIONS(1137), 1,
      sym_identifier,
    ACTIONS(1163), 1,
      sym_number,
    STATE(249), 1,
      sym_access,
    ACTIONS(1095), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(274), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [20731] = 9,
    ACTIONS(1085), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1087), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1089), 1,
      anon_sym_SQUOTE,
    ACTIONS(1091), 1,
      anon_sym_DQUOTE,
    ACTIONS(1137), 1,
      sym_identifier,
    ACTIONS(1165), 1,
      sym_number,
    STATE(249), 1,
      sym_access,
    ACTIONS(1095), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(291), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [20765] = 9,
    ACTIONS(1085), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1087), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1089), 1,
      anon_sym_SQUOTE,
    ACTIONS(1091), 1,
      anon_sym_DQUOTE,
    ACTIONS(1137), 1,
      sym_identifier,
    ACTIONS(1167), 1,
      sym_number,
    STATE(249), 1,
      sym_access,
    ACTIONS(1095), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(305), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [20799] = 9,
    ACTIONS(17), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(19), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(21), 1,
      anon_sym_SQUOTE,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    ACTIONS(1131), 1,
      sym_identifier,
    ACTIONS(1169), 1,
      sym_number,
    STATE(277), 1,
      sym_access,
    ACTIONS(27), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(293), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [20833] = 9,
    ACTIONS(1000), 1,
      sym_identifier,
    ACTIONS(1004), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1006), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1008), 1,
      anon_sym_SQUOTE,
    ACTIONS(1010), 1,
      anon_sym_DQUOTE,
    ACTIONS(1171), 1,
      sym_number,
    STATE(44), 1,
      sym_access,
    ACTIONS(1014), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(2), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [20867] = 9,
    ACTIONS(1085), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1087), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1089), 1,
      anon_sym_SQUOTE,
    ACTIONS(1091), 1,
      anon_sym_DQUOTE,
    ACTIONS(1137), 1,
      sym_identifier,
    ACTIONS(1173), 1,
      sym_number,
    STATE(249), 1,
      sym_access,
    ACTIONS(1095), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(292), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [20901] = 9,
    ACTIONS(1000), 1,
      sym_identifier,
    ACTIONS(1004), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1006), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1008), 1,
      anon_sym_SQUOTE,
    ACTIONS(1010), 1,
      anon_sym_DQUOTE,
    ACTIONS(1175), 1,
      sym_number,
    STATE(44), 1,
      sym_access,
    ACTIONS(1014), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(3), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [20935] = 9,
    ACTIONS(1085), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1087), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1089), 1,
      anon_sym_SQUOTE,
    ACTIONS(1091), 1,
      anon_sym_DQUOTE,
    ACTIONS(1137), 1,
      sym_identifier,
    ACTIONS(1177), 1,
      sym_number,
    STATE(249), 1,
      sym_access,
    ACTIONS(1095), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(297), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [20969] = 9,
    ACTIONS(1085), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1087), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1089), 1,
      anon_sym_SQUOTE,
    ACTIONS(1091), 1,
      anon_sym_DQUOTE,
    ACTIONS(1137), 1,
      sym_identifier,
    ACTIONS(1179), 1,
      sym_number,
    STATE(249), 1,
      sym_access,
    ACTIONS(1095), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(290), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [21003] = 9,
    ACTIONS(17), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(19), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(21), 1,
      anon_sym_SQUOTE,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    ACTIONS(1131), 1,
      sym_identifier,
    ACTIONS(1181), 1,
      sym_number,
    STATE(277), 1,
      sym_access,
    ACTIONS(27), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(295), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [21037] = 9,
    ACTIONS(17), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(19), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(21), 1,
      anon_sym_SQUOTE,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    ACTIONS(1131), 1,
      sym_identifier,
    ACTIONS(1183), 1,
      sym_number,
    STATE(277), 1,
      sym_access,
    ACTIONS(27), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(301), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [21071] = 9,
    ACTIONS(17), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(19), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(21), 1,
      anon_sym_SQUOTE,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    ACTIONS(1131), 1,
      sym_identifier,
    ACTIONS(1185), 1,
      sym_number,
    STATE(277), 1,
      sym_access,
    ACTIONS(27), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(307), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [21105] = 9,
    ACTIONS(17), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(19), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(21), 1,
      anon_sym_SQUOTE,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    ACTIONS(1131), 1,
      sym_identifier,
    ACTIONS(1187), 1,
      sym_number,
    STATE(277), 1,
      sym_access,
    ACTIONS(27), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(311), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [21139] = 9,
    ACTIONS(1000), 1,
      sym_identifier,
    ACTIONS(1004), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1006), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1008), 1,
      anon_sym_SQUOTE,
    ACTIONS(1010), 1,
      anon_sym_DQUOTE,
    ACTIONS(1189), 1,
      sym_number,
    STATE(44), 1,
      sym_access,
    ACTIONS(1014), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(47), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [21173] = 9,
    ACTIONS(1000), 1,
      sym_identifier,
    ACTIONS(1004), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1006), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1008), 1,
      anon_sym_SQUOTE,
    ACTIONS(1010), 1,
      anon_sym_DQUOTE,
    ACTIONS(1191), 1,
      sym_number,
    STATE(44), 1,
      sym_access,
    ACTIONS(1014), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(48), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [21207] = 9,
    ACTIONS(1000), 1,
      sym_identifier,
    ACTIONS(1004), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1006), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1008), 1,
      anon_sym_SQUOTE,
    ACTIONS(1010), 1,
      anon_sym_DQUOTE,
    ACTIONS(1193), 1,
      sym_number,
    STATE(44), 1,
      sym_access,
    ACTIONS(1014), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(49), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [21241] = 9,
    ACTIONS(1000), 1,
      sym_identifier,
    ACTIONS(1004), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1006), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1008), 1,
      anon_sym_SQUOTE,
    ACTIONS(1010), 1,
      anon_sym_DQUOTE,
    ACTIONS(1195), 1,
      sym_number,
    STATE(44), 1,
      sym_access,
    ACTIONS(1014), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(51), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [21275] = 9,
    ACTIONS(1085), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1087), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1089), 1,
      anon_sym_SQUOTE,
    ACTIONS(1091), 1,
      anon_sym_DQUOTE,
    ACTIONS(1137), 1,
      sym_identifier,
    ACTIONS(1197), 1,
      sym_number,
    STATE(249), 1,
      sym_access,
    ACTIONS(1095), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(310), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [21309] = 9,
    ACTIONS(1000), 1,
      sym_identifier,
    ACTIONS(1004), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1006), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1008), 1,
      anon_sym_SQUOTE,
    ACTIONS(1010), 1,
      anon_sym_DQUOTE,
    ACTIONS(1199), 1,
      sym_number,
    STATE(44), 1,
      sym_access,
    ACTIONS(1014), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(53), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [21343] = 9,
    ACTIONS(1085), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1087), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1089), 1,
      anon_sym_SQUOTE,
    ACTIONS(1091), 1,
      anon_sym_DQUOTE,
    ACTIONS(1137), 1,
      sym_identifier,
    ACTIONS(1201), 1,
      sym_number,
    STATE(249), 1,
      sym_access,
    ACTIONS(1095), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(309), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [21377] = 9,
    ACTIONS(1000), 1,
      sym_identifier,
    ACTIONS(1004), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1006), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1008), 1,
      anon_sym_SQUOTE,
    ACTIONS(1010), 1,
      anon_sym_DQUOTE,
    ACTIONS(1203), 1,
      sym_number,
    STATE(44), 1,
      sym_access,
    ACTIONS(1014), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(54), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [21411] = 9,
    ACTIONS(1085), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1087), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1089), 1,
      anon_sym_SQUOTE,
    ACTIONS(1091), 1,
      anon_sym_DQUOTE,
    ACTIONS(1137), 1,
      sym_identifier,
    ACTIONS(1205), 1,
      sym_number,
    STATE(249), 1,
      sym_access,
    ACTIONS(1095), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(285), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [21445] = 9,
    ACTIONS(632), 1,
      sym_identifier,
    ACTIONS(637), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1207), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1209), 1,
      anon_sym_SQUOTE,
    ACTIONS(1211), 1,
      anon_sym_DQUOTE,
    ACTIONS(1213), 1,
      sym_number,
    STATE(227), 1,
      sym_access,
    ACTIONS(645), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(238), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [21479] = 9,
    ACTIONS(1085), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1087), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1089), 1,
      anon_sym_SQUOTE,
    ACTIONS(1091), 1,
      anon_sym_DQUOTE,
    ACTIONS(1137), 1,
      sym_identifier,
    ACTIONS(1215), 1,
      sym_number,
    STATE(249), 1,
      sym_access,
    ACTIONS(1095), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(286), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [21513] = 9,
    ACTIONS(1085), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1087), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1089), 1,
      anon_sym_SQUOTE,
    ACTIONS(1091), 1,
      anon_sym_DQUOTE,
    ACTIONS(1137), 1,
      sym_identifier,
    ACTIONS(1217), 1,
      sym_number,
    STATE(249), 1,
      sym_access,
    ACTIONS(1095), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(300), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [21547] = 9,
    ACTIONS(632), 1,
      sym_identifier,
    ACTIONS(637), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1207), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1209), 1,
      anon_sym_SQUOTE,
    ACTIONS(1211), 1,
      anon_sym_DQUOTE,
    ACTIONS(1219), 1,
      sym_number,
    STATE(227), 1,
      sym_access,
    ACTIONS(645), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(246), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [21581] = 9,
    ACTIONS(1085), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1087), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1089), 1,
      anon_sym_SQUOTE,
    ACTIONS(1091), 1,
      anon_sym_DQUOTE,
    ACTIONS(1137), 1,
      sym_identifier,
    ACTIONS(1221), 1,
      sym_number,
    STATE(249), 1,
      sym_access,
    ACTIONS(1095), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(294), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [21615] = 9,
    ACTIONS(1085), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1087), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1089), 1,
      anon_sym_SQUOTE,
    ACTIONS(1091), 1,
      anon_sym_DQUOTE,
    ACTIONS(1137), 1,
      sym_identifier,
    ACTIONS(1223), 1,
      sym_number,
    STATE(249), 1,
      sym_access,
    ACTIONS(1095), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(298), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [21649] = 9,
    ACTIONS(632), 1,
      sym_identifier,
    ACTIONS(637), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1207), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1209), 1,
      anon_sym_SQUOTE,
    ACTIONS(1211), 1,
      anon_sym_DQUOTE,
    ACTIONS(1225), 1,
      sym_number,
    STATE(227), 1,
      sym_access,
    ACTIONS(645), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(236), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [21683] = 9,
    ACTIONS(632), 1,
      sym_identifier,
    ACTIONS(637), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1207), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1209), 1,
      anon_sym_SQUOTE,
    ACTIONS(1211), 1,
      anon_sym_DQUOTE,
    ACTIONS(1227), 1,
      sym_number,
    STATE(227), 1,
      sym_access,
    ACTIONS(645), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(245), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [21717] = 9,
    ACTIONS(632), 1,
      sym_identifier,
    ACTIONS(637), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1207), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1209), 1,
      anon_sym_SQUOTE,
    ACTIONS(1211), 1,
      anon_sym_DQUOTE,
    ACTIONS(1229), 1,
      sym_number,
    STATE(227), 1,
      sym_access,
    ACTIONS(645), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(241), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [21751] = 9,
    ACTIONS(632), 1,
      sym_identifier,
    ACTIONS(637), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1207), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1209), 1,
      anon_sym_SQUOTE,
    ACTIONS(1211), 1,
      anon_sym_DQUOTE,
    ACTIONS(1231), 1,
      sym_number,
    STATE(227), 1,
      sym_access,
    ACTIONS(645), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(237), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [21785] = 9,
    ACTIONS(1089), 1,
      anon_sym_SQUOTE,
    ACTIONS(1091), 1,
      anon_sym_DQUOTE,
    ACTIONS(1123), 1,
      sym_identifier,
    ACTIONS(1125), 1,
      sym_number,
    STATE(141), 1,
      sym_argument_list,
    STATE(677), 1,
      sym_access,
    ACTIONS(630), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
    ACTIONS(1095), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(727), 4,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_argument,
  [21818] = 8,
    ACTIONS(21), 1,
      anon_sym_SQUOTE,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    ACTIONS(1233), 1,
      sym_identifier,
    ACTIONS(1235), 1,
      sym_number,
    STATE(262), 1,
      sym_access,
    STATE(1230), 1,
      sym_argument_list,
    ACTIONS(27), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(275), 4,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_argument,
  [21847] = 8,
    ACTIONS(1089), 1,
      anon_sym_SQUOTE,
    ACTIONS(1091), 1,
      anon_sym_DQUOTE,
    ACTIONS(1125), 1,
      sym_number,
    ACTIONS(1237), 1,
      sym_identifier,
    STATE(677), 1,
      sym_access,
    STATE(820), 1,
      sym_argument_list,
    ACTIONS(1095), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(727), 4,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_argument,
  [21876] = 8,
    ACTIONS(1008), 1,
      anon_sym_SQUOTE,
    ACTIONS(1010), 1,
      anon_sym_DQUOTE,
    ACTIONS(1239), 1,
      sym_identifier,
    ACTIONS(1241), 1,
      sym_number,
    STATE(20), 1,
      sym_access,
    STATE(24), 1,
      sym_argument_list,
    ACTIONS(1014), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(38), 4,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_argument,
  [21905] = 8,
    ACTIONS(1089), 1,
      anon_sym_SQUOTE,
    ACTIONS(1091), 1,
      anon_sym_DQUOTE,
    ACTIONS(1125), 1,
      sym_number,
    ACTIONS(1237), 1,
      sym_identifier,
    STATE(677), 1,
      sym_access,
    STATE(943), 1,
      sym_argument_list,
    ACTIONS(1095), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(727), 4,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_argument,
  [21934] = 8,
    ACTIONS(1008), 1,
      anon_sym_SQUOTE,
    ACTIONS(1010), 1,
      anon_sym_DQUOTE,
    ACTIONS(1241), 1,
      sym_number,
    ACTIONS(1243), 1,
      sym_identifier,
    STATE(20), 1,
      sym_access,
    STATE(156), 1,
      sym_argument_list,
    ACTIONS(1014), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(38), 4,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_argument,
  [21963] = 8,
    ACTIONS(1209), 1,
      anon_sym_SQUOTE,
    ACTIONS(1211), 1,
      anon_sym_DQUOTE,
    ACTIONS(1245), 1,
      sym_identifier,
    ACTIONS(1247), 1,
      sym_number,
    STATE(210), 1,
      sym_access,
    STATE(243), 1,
      sym_argument_list,
    ACTIONS(645), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(226), 4,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_argument,
  [21992] = 8,
    ACTIONS(1089), 1,
      anon_sym_SQUOTE,
    ACTIONS(1091), 1,
      anon_sym_DQUOTE,
    ACTIONS(1125), 1,
      sym_number,
    ACTIONS(1249), 1,
      sym_identifier,
    STATE(156), 1,
      sym_argument_list,
    STATE(677), 1,
      sym_access,
    ACTIONS(1095), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(727), 4,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_argument,
  [22021] = 8,
    ACTIONS(1089), 1,
      anon_sym_SQUOTE,
    ACTIONS(1091), 1,
      anon_sym_DQUOTE,
    ACTIONS(1125), 1,
      sym_number,
    ACTIONS(1237), 1,
      sym_identifier,
    STATE(677), 1,
      sym_access,
    STATE(973), 1,
      sym_argument_list,
    ACTIONS(1095), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(727), 4,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_argument,
  [22050] = 8,
    ACTIONS(1008), 1,
      anon_sym_SQUOTE,
    ACTIONS(1010), 1,
      anon_sym_DQUOTE,
    ACTIONS(1239), 1,
      sym_identifier,
    ACTIONS(1241), 1,
      sym_number,
    STATE(20), 1,
      sym_access,
    STATE(50), 1,
      sym_argument_list,
    ACTIONS(1014), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(38), 4,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_argument,
  [22079] = 8,
    ACTIONS(1089), 1,
      anon_sym_SQUOTE,
    ACTIONS(1091), 1,
      anon_sym_DQUOTE,
    ACTIONS(1251), 1,
      sym_identifier,
    ACTIONS(1253), 1,
      sym_number,
    STATE(239), 1,
      sym_access,
    STATE(268), 1,
      sym_argument_list,
    ACTIONS(1095), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(253), 4,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_argument,
  [22108] = 8,
    ACTIONS(21), 1,
      anon_sym_SQUOTE,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    ACTIONS(1233), 1,
      sym_identifier,
    ACTIONS(1235), 1,
      sym_number,
    STATE(262), 1,
      sym_access,
    STATE(312), 1,
      sym_argument_list,
    ACTIONS(27), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(275), 4,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_argument,
  [22137] = 7,
    ACTIONS(1008), 1,
      anon_sym_SQUOTE,
    ACTIONS(1010), 1,
      anon_sym_DQUOTE,
    ACTIONS(1255), 1,
      sym_identifier,
    ACTIONS(1257), 1,
      sym_number,
    STATE(25), 1,
      sym_access,
    ACTIONS(1014), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(41), 4,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_argument,
  [22163] = 7,
    ACTIONS(21), 1,
      anon_sym_SQUOTE,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    ACTIONS(1259), 1,
      sym_identifier,
    ACTIONS(1261), 1,
      sym_number,
    STATE(273), 1,
      sym_access,
    ACTIONS(27), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(282), 4,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_argument,
  [22189] = 7,
    ACTIONS(1089), 1,
      anon_sym_SQUOTE,
    ACTIONS(1091), 1,
      anon_sym_DQUOTE,
    ACTIONS(1257), 1,
      sym_number,
    ACTIONS(1263), 1,
      sym_identifier,
    STATE(687), 1,
      sym_access,
    ACTIONS(1095), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(41), 4,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_argument,
  [22215] = 7,
    ACTIONS(1209), 1,
      anon_sym_SQUOTE,
    ACTIONS(1211), 1,
      anon_sym_DQUOTE,
    ACTIONS(1265), 1,
      sym_identifier,
    ACTIONS(1267), 1,
      sym_number,
    STATE(221), 1,
      sym_access,
    ACTIONS(645), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(232), 4,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_argument,
  [22241] = 7,
    ACTIONS(1089), 1,
      anon_sym_SQUOTE,
    ACTIONS(1091), 1,
      anon_sym_DQUOTE,
    ACTIONS(1269), 1,
      sym_identifier,
    ACTIONS(1271), 1,
      sym_number,
    STATE(248), 1,
      sym_access,
    ACTIONS(1095), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(255), 4,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_argument,
  [22267] = 7,
    ACTIONS(1089), 1,
      anon_sym_SQUOTE,
    ACTIONS(1091), 1,
      anon_sym_DQUOTE,
    ACTIONS(1273), 1,
      sym_identifier,
    ACTIONS(1275), 1,
      sym_number,
    STATE(247), 1,
      sym_access,
    ACTIONS(1095), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(256), 3,
      sym__literal,
      sym_string,
      sym_boolean,
  [22292] = 7,
    ACTIONS(1008), 1,
      anon_sym_SQUOTE,
    ACTIONS(1010), 1,
      anon_sym_DQUOTE,
    ACTIONS(1277), 1,
      sym_identifier,
    ACTIONS(1279), 1,
      sym_number,
    STATE(26), 1,
      sym_access,
    ACTIONS(1014), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(43), 3,
      sym__literal,
      sym_string,
      sym_boolean,
  [22317] = 7,
    ACTIONS(1089), 1,
      anon_sym_SQUOTE,
    ACTIONS(1091), 1,
      anon_sym_DQUOTE,
    ACTIONS(1279), 1,
      sym_number,
    ACTIONS(1281), 1,
      sym_identifier,
    STATE(690), 1,
      sym_access,
    ACTIONS(1095), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(43), 3,
      sym__literal,
      sym_string,
      sym_boolean,
  [22342] = 7,
    ACTIONS(21), 1,
      anon_sym_SQUOTE,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    ACTIONS(1283), 1,
      sym_identifier,
    ACTIONS(1285), 1,
      sym_number,
    STATE(263), 1,
      sym_access,
    ACTIONS(27), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 3,
      sym__literal,
      sym_string,
      sym_boolean,
  [22367] = 7,
    ACTIONS(1209), 1,
      anon_sym_SQUOTE,
    ACTIONS(1211), 1,
      anon_sym_DQUOTE,
    ACTIONS(1287), 1,
      sym_identifier,
    ACTIONS(1289), 1,
      sym_number,
    STATE(220), 1,
      sym_access,
    ACTIONS(645), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(230), 3,
      sym__literal,
      sym_string,
      sym_boolean,
  [22392] = 9,
    ACTIONS(926), 1,
      anon_sym_DOT,
    ACTIONS(928), 1,
      anon_sym_LBRACK,
    ACTIONS(1291), 1,
      anon_sym_else,
    ACTIONS(1293), 1,
      anon_sym_endcase,
    ACTIONS(1295), 1,
      anon_sym_when,
    STATE(400), 1,
      aux_sym__case_liq_repeat1,
    STATE(769), 1,
      sym__when_liq,
    STATE(770), 1,
      sym__when_aliased,
    STATE(1068), 2,
      sym__else_liq,
      sym__else_aliased,
  [22421] = 5,
    ACTIONS(1297), 1,
      ts_builtin_sym_end,
    ACTIONS(1299), 1,
      aux_sym_template_content_token1,
    STATE(393), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(1302), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(1305), 4,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [22441] = 5,
    ACTIONS(1307), 1,
      ts_builtin_sym_end,
    ACTIONS(1309), 1,
      aux_sym_template_content_token1,
    STATE(393), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(1312), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(1315), 4,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [22461] = 2,
    ACTIONS(1317), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1319), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [22474] = 2,
    ACTIONS(1321), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1323), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [22487] = 7,
    ACTIONS(1291), 1,
      anon_sym_else,
    ACTIONS(1325), 1,
      anon_sym_elsif,
    ACTIONS(1327), 1,
      anon_sym_endunless,
    STATE(565), 1,
      aux_sym__if_liq_repeat2,
    STATE(739), 1,
      sym__elsif_aliased,
    STATE(740), 1,
      sym__elsif_liq,
    STATE(1156), 2,
      sym__else_liq,
      sym__else_aliased,
  [22510] = 7,
    ACTIONS(1291), 1,
      anon_sym_else,
    ACTIONS(1325), 1,
      anon_sym_elsif,
    ACTIONS(1329), 1,
      anon_sym_endif,
    STATE(565), 1,
      aux_sym__if_liq_repeat2,
    STATE(739), 1,
      sym__elsif_aliased,
    STATE(740), 1,
      sym__elsif_liq,
    STATE(1187), 2,
      sym__else_liq,
      sym__else_aliased,
  [22533] = 7,
    ACTIONS(1291), 1,
      anon_sym_else,
    ACTIONS(1325), 1,
      anon_sym_elsif,
    ACTIONS(1331), 1,
      anon_sym_endunless,
    STATE(565), 1,
      aux_sym__if_liq_repeat2,
    STATE(739), 1,
      sym__elsif_aliased,
    STATE(740), 1,
      sym__elsif_liq,
    STATE(1192), 2,
      sym__else_liq,
      sym__else_aliased,
  [22556] = 7,
    ACTIONS(1291), 1,
      anon_sym_else,
    ACTIONS(1295), 1,
      anon_sym_when,
    ACTIONS(1333), 1,
      anon_sym_endcase,
    STATE(676), 1,
      aux_sym__case_liq_repeat1,
    STATE(769), 1,
      sym__when_liq,
    STATE(770), 1,
      sym__when_aliased,
    STATE(1150), 2,
      sym__else_liq,
      sym__else_aliased,
  [22579] = 7,
    ACTIONS(1291), 1,
      anon_sym_else,
    ACTIONS(1325), 1,
      anon_sym_elsif,
    ACTIONS(1335), 1,
      anon_sym_endif,
    STATE(565), 1,
      aux_sym__if_liq_repeat2,
    STATE(739), 1,
      sym__elsif_aliased,
    STATE(740), 1,
      sym__elsif_liq,
    STATE(1145), 2,
      sym__else_liq,
      sym__else_aliased,
  [22602] = 2,
    ACTIONS(1337), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1339), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [22615] = 2,
    ACTIONS(1341), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1343), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [22628] = 2,
    ACTIONS(1345), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1347), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [22641] = 2,
    ACTIONS(1349), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1351), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [22654] = 4,
    ACTIONS(1353), 1,
      aux_sym_template_content_token1,
    STATE(406), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(1356), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(1305), 4,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [22671] = 4,
    ACTIONS(1359), 1,
      aux_sym_template_content_token1,
    STATE(406), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(1362), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(1315), 4,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [22688] = 2,
    ACTIONS(1365), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1367), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [22701] = 2,
    ACTIONS(1369), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1371), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [22714] = 2,
    ACTIONS(1369), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1371), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [22727] = 2,
    ACTIONS(1369), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1371), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [22740] = 2,
    ACTIONS(1369), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1371), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [22753] = 2,
    ACTIONS(1369), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1371), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [22766] = 2,
    ACTIONS(1369), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1371), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [22779] = 2,
    ACTIONS(1369), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1371), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [22792] = 2,
    ACTIONS(1369), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1371), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [22805] = 2,
    ACTIONS(1373), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1375), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [22818] = 2,
    ACTIONS(1373), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1375), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [22831] = 2,
    ACTIONS(1377), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1379), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [22844] = 2,
    ACTIONS(1373), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1375), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [22857] = 2,
    ACTIONS(1381), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1383), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [22870] = 2,
    ACTIONS(1373), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1375), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [22883] = 2,
    ACTIONS(1373), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1375), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [22896] = 2,
    ACTIONS(1373), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1375), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [22909] = 2,
    ACTIONS(1373), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1375), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [22922] = 2,
    ACTIONS(1373), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1375), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [22935] = 2,
    ACTIONS(1385), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1387), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [22948] = 2,
    ACTIONS(1385), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1387), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [22961] = 2,
    ACTIONS(1385), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1387), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [22974] = 2,
    ACTIONS(1385), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1387), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [22987] = 2,
    ACTIONS(1385), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1387), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23000] = 2,
    ACTIONS(1389), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1391), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23013] = 2,
    ACTIONS(1393), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1395), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23026] = 2,
    ACTIONS(1397), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1399), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23039] = 2,
    ACTIONS(1401), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1403), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23052] = 2,
    ACTIONS(1385), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1387), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23065] = 2,
    ACTIONS(1405), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1407), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23078] = 2,
    ACTIONS(1385), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1387), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23091] = 2,
    ACTIONS(1385), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1387), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23104] = 2,
    ACTIONS(1409), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1411), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23117] = 2,
    ACTIONS(1413), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1415), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23130] = 2,
    ACTIONS(1413), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1415), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23143] = 2,
    ACTIONS(1413), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1415), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23156] = 2,
    ACTIONS(1413), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1415), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23169] = 2,
    ACTIONS(1417), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1419), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23182] = 2,
    ACTIONS(1417), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1419), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23195] = 2,
    ACTIONS(1417), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1419), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23208] = 2,
    ACTIONS(1417), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1419), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23221] = 2,
    ACTIONS(1317), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1319), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23234] = 2,
    ACTIONS(1317), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1319), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23247] = 2,
    ACTIONS(1317), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1319), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23260] = 2,
    ACTIONS(1317), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1319), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23273] = 2,
    ACTIONS(1421), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1423), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23286] = 2,
    ACTIONS(1425), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1427), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23299] = 2,
    ACTIONS(1425), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1427), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23312] = 2,
    ACTIONS(1425), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1427), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23325] = 2,
    ACTIONS(1425), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1427), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23338] = 2,
    ACTIONS(1317), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1319), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23351] = 2,
    ACTIONS(1317), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1319), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23364] = 2,
    ACTIONS(1317), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1319), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23377] = 2,
    ACTIONS(1425), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1427), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23390] = 2,
    ACTIONS(1429), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1431), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23403] = 2,
    ACTIONS(1433), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1435), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23416] = 2,
    ACTIONS(1425), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1427), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23429] = 2,
    ACTIONS(1425), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1427), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23442] = 2,
    ACTIONS(1425), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1427), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23455] = 2,
    ACTIONS(1437), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1439), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23468] = 2,
    ACTIONS(1437), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1439), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23481] = 2,
    ACTIONS(1441), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1443), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23494] = 2,
    ACTIONS(1441), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1443), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23507] = 2,
    ACTIONS(1441), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1443), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23520] = 2,
    ACTIONS(1441), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1443), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23533] = 2,
    ACTIONS(1437), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1439), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23546] = 2,
    ACTIONS(1437), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1439), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23559] = 2,
    ACTIONS(1445), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1447), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23572] = 2,
    ACTIONS(1449), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1451), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23585] = 2,
    ACTIONS(1437), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1439), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23598] = 2,
    ACTIONS(1453), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1455), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23611] = 2,
    ACTIONS(1457), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1459), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23624] = 2,
    ACTIONS(1437), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1439), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23637] = 2,
    ACTIONS(1437), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1439), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23650] = 2,
    ACTIONS(1437), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1439), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23663] = 2,
    ACTIONS(1461), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1463), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23676] = 2,
    ACTIONS(1461), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1463), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23689] = 2,
    ACTIONS(1465), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1467), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23702] = 2,
    ACTIONS(1465), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1467), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23715] = 2,
    ACTIONS(1465), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1467), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23728] = 2,
    ACTIONS(1465), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1467), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23741] = 2,
    ACTIONS(1461), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1463), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23754] = 2,
    ACTIONS(1461), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1463), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23767] = 2,
    ACTIONS(1469), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1471), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23780] = 2,
    ACTIONS(1473), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1475), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23793] = 2,
    ACTIONS(1461), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1463), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23806] = 2,
    ACTIONS(1461), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1463), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23819] = 2,
    ACTIONS(1461), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1463), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23832] = 2,
    ACTIONS(1461), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1463), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23845] = 2,
    ACTIONS(1477), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1479), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23858] = 2,
    ACTIONS(1321), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1323), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23871] = 2,
    ACTIONS(1321), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1323), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23884] = 2,
    ACTIONS(1321), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1323), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23897] = 2,
    ACTIONS(1481), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1483), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23910] = 2,
    ACTIONS(1485), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1487), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23923] = 2,
    ACTIONS(1485), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1487), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23936] = 2,
    ACTIONS(1485), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1487), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23949] = 2,
    ACTIONS(1489), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1491), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23962] = 2,
    ACTIONS(1493), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1495), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23975] = 2,
    ACTIONS(1485), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1487), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23988] = 2,
    ACTIONS(1497), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1499), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24001] = 2,
    ACTIONS(1501), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1503), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24014] = 2,
    ACTIONS(1505), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1507), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24027] = 2,
    ACTIONS(1509), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1511), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24040] = 2,
    ACTIONS(1513), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1515), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24053] = 2,
    ACTIONS(1505), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1507), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24066] = 2,
    ACTIONS(1505), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1507), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24079] = 2,
    ACTIONS(1517), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1519), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24092] = 2,
    ACTIONS(1517), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1519), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24105] = 2,
    ACTIONS(1517), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1519), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24118] = 2,
    ACTIONS(1517), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1519), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24131] = 2,
    ACTIONS(1505), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1507), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24144] = 2,
    ACTIONS(1521), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1523), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24157] = 2,
    ACTIONS(1521), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1523), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24170] = 2,
    ACTIONS(1521), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1523), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24183] = 2,
    ACTIONS(1521), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1523), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24196] = 2,
    ACTIONS(1525), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1527), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24209] = 2,
    ACTIONS(1517), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1519), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24222] = 2,
    ACTIONS(1517), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1519), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24235] = 2,
    ACTIONS(1517), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1519), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24248] = 2,
    ACTIONS(1517), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1519), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24261] = 2,
    ACTIONS(1529), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1531), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24274] = 2,
    ACTIONS(1445), 1,
      aux_sym_template_content_token1,
    ACTIONS(1447), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24286] = 6,
    ACTIONS(926), 1,
      anon_sym_DOT,
    ACTIONS(928), 1,
      anon_sym_LBRACK,
    ACTIONS(953), 1,
      anon_sym_COLON,
    ACTIONS(955), 1,
      anon_sym_COMMA,
    STATE(725), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(653), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [24306] = 2,
    ACTIONS(1517), 1,
      aux_sym_template_content_token1,
    ACTIONS(1519), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24318] = 2,
    ACTIONS(1517), 1,
      aux_sym_template_content_token1,
    ACTIONS(1519), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24330] = 2,
    ACTIONS(1517), 1,
      aux_sym_template_content_token1,
    ACTIONS(1519), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24342] = 2,
    ACTIONS(1521), 1,
      aux_sym_template_content_token1,
    ACTIONS(1523), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24354] = 2,
    ACTIONS(1521), 1,
      aux_sym_template_content_token1,
    ACTIONS(1523), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24366] = 2,
    ACTIONS(1521), 1,
      aux_sym_template_content_token1,
    ACTIONS(1523), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24378] = 2,
    ACTIONS(1521), 1,
      aux_sym_template_content_token1,
    ACTIONS(1523), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24390] = 2,
    ACTIONS(1505), 1,
      aux_sym_template_content_token1,
    ACTIONS(1507), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24402] = 2,
    ACTIONS(1505), 1,
      aux_sym_template_content_token1,
    ACTIONS(1507), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24414] = 2,
    ACTIONS(1517), 1,
      aux_sym_template_content_token1,
    ACTIONS(1519), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24426] = 2,
    ACTIONS(1517), 1,
      aux_sym_template_content_token1,
    ACTIONS(1519), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24438] = 2,
    ACTIONS(1505), 1,
      aux_sym_template_content_token1,
    ACTIONS(1507), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24450] = 2,
    ACTIONS(1369), 1,
      aux_sym_template_content_token1,
    ACTIONS(1371), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24462] = 2,
    ACTIONS(1505), 1,
      aux_sym_template_content_token1,
    ACTIONS(1507), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24474] = 6,
    ACTIONS(926), 1,
      anon_sym_DOT,
    ACTIONS(928), 1,
      anon_sym_LBRACK,
    ACTIONS(953), 1,
      anon_sym_COLON,
    ACTIONS(955), 1,
      anon_sym_COMMA,
    STATE(725), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(305), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [24494] = 2,
    ACTIONS(1373), 1,
      aux_sym_template_content_token1,
    ACTIONS(1375), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24506] = 2,
    ACTIONS(1345), 1,
      aux_sym_template_content_token1,
    ACTIONS(1347), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24518] = 2,
    ACTIONS(1501), 1,
      aux_sym_template_content_token1,
    ACTIONS(1503), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24530] = 2,
    ACTIONS(1497), 1,
      aux_sym_template_content_token1,
    ACTIONS(1499), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24542] = 2,
    ACTIONS(1485), 1,
      aux_sym_template_content_token1,
    ACTIONS(1487), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24554] = 2,
    ACTIONS(1485), 1,
      aux_sym_template_content_token1,
    ACTIONS(1487), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24566] = 2,
    ACTIONS(1369), 1,
      aux_sym_template_content_token1,
    ACTIONS(1371), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24578] = 2,
    ACTIONS(1517), 1,
      aux_sym_template_content_token1,
    ACTIONS(1519), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24590] = 2,
    ACTIONS(1517), 1,
      aux_sym_template_content_token1,
    ACTIONS(1519), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24602] = 2,
    ACTIONS(1485), 1,
      aux_sym_template_content_token1,
    ACTIONS(1487), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24614] = 2,
    ACTIONS(1369), 1,
      aux_sym_template_content_token1,
    ACTIONS(1371), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24626] = 2,
    ACTIONS(1485), 1,
      aux_sym_template_content_token1,
    ACTIONS(1487), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24638] = 2,
    ACTIONS(1369), 1,
      aux_sym_template_content_token1,
    ACTIONS(1371), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24650] = 2,
    ACTIONS(1369), 1,
      aux_sym_template_content_token1,
    ACTIONS(1371), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24662] = 2,
    ACTIONS(1513), 1,
      aux_sym_template_content_token1,
    ACTIONS(1515), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24674] = 2,
    ACTIONS(1321), 1,
      aux_sym_template_content_token1,
    ACTIONS(1323), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24686] = 2,
    ACTIONS(1321), 1,
      aux_sym_template_content_token1,
    ACTIONS(1323), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24698] = 2,
    ACTIONS(1369), 1,
      aux_sym_template_content_token1,
    ACTIONS(1371), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24710] = 5,
    ACTIONS(1535), 1,
      anon_sym_elsif,
    STATE(565), 1,
      aux_sym__if_liq_repeat2,
    STATE(739), 1,
      sym__elsif_aliased,
    STATE(740), 1,
      sym__elsif_liq,
    ACTIONS(1533), 3,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_endunless,
  [24728] = 2,
    ACTIONS(1509), 1,
      aux_sym_template_content_token1,
    ACTIONS(1511), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24740] = 2,
    ACTIONS(1473), 1,
      aux_sym_template_content_token1,
    ACTIONS(1475), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24752] = 2,
    ACTIONS(1321), 1,
      aux_sym_template_content_token1,
    ACTIONS(1323), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24764] = 2,
    ACTIONS(1477), 1,
      aux_sym_template_content_token1,
    ACTIONS(1479), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24776] = 2,
    ACTIONS(1461), 1,
      aux_sym_template_content_token1,
    ACTIONS(1463), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24788] = 2,
    ACTIONS(1461), 1,
      aux_sym_template_content_token1,
    ACTIONS(1463), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24800] = 2,
    ACTIONS(1469), 1,
      aux_sym_template_content_token1,
    ACTIONS(1471), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24812] = 2,
    ACTIONS(1465), 1,
      aux_sym_template_content_token1,
    ACTIONS(1467), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24824] = 2,
    ACTIONS(1461), 1,
      aux_sym_template_content_token1,
    ACTIONS(1463), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24836] = 2,
    ACTIONS(1461), 1,
      aux_sym_template_content_token1,
    ACTIONS(1463), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24848] = 2,
    ACTIONS(1385), 1,
      aux_sym_template_content_token1,
    ACTIONS(1387), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24860] = 2,
    ACTIONS(1461), 1,
      aux_sym_template_content_token1,
    ACTIONS(1463), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24872] = 2,
    ACTIONS(1465), 1,
      aux_sym_template_content_token1,
    ACTIONS(1467), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24884] = 2,
    ACTIONS(1465), 1,
      aux_sym_template_content_token1,
    ACTIONS(1467), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24896] = 2,
    ACTIONS(1461), 1,
      aux_sym_template_content_token1,
    ACTIONS(1463), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24908] = 2,
    ACTIONS(1461), 1,
      aux_sym_template_content_token1,
    ACTIONS(1463), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24920] = 2,
    ACTIONS(1437), 1,
      aux_sym_template_content_token1,
    ACTIONS(1439), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24932] = 2,
    ACTIONS(1437), 1,
      aux_sym_template_content_token1,
    ACTIONS(1439), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24944] = 2,
    ACTIONS(1465), 1,
      aux_sym_template_content_token1,
    ACTIONS(1467), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24956] = 2,
    ACTIONS(1457), 1,
      aux_sym_template_content_token1,
    ACTIONS(1459), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24968] = 2,
    ACTIONS(1437), 1,
      aux_sym_template_content_token1,
    ACTIONS(1439), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24980] = 2,
    ACTIONS(1437), 1,
      aux_sym_template_content_token1,
    ACTIONS(1439), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24992] = 2,
    ACTIONS(1437), 1,
      aux_sym_template_content_token1,
    ACTIONS(1439), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25004] = 2,
    ACTIONS(1437), 1,
      aux_sym_template_content_token1,
    ACTIONS(1439), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25016] = 2,
    ACTIONS(1337), 1,
      aux_sym_template_content_token1,
    ACTIONS(1339), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25028] = 2,
    ACTIONS(1437), 1,
      aux_sym_template_content_token1,
    ACTIONS(1439), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25040] = 2,
    ACTIONS(1385), 1,
      aux_sym_template_content_token1,
    ACTIONS(1387), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25052] = 2,
    ACTIONS(1437), 1,
      aux_sym_template_content_token1,
    ACTIONS(1439), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25064] = 2,
    ACTIONS(1453), 1,
      aux_sym_template_content_token1,
    ACTIONS(1455), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25076] = 2,
    ACTIONS(1449), 1,
      aux_sym_template_content_token1,
    ACTIONS(1451), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25088] = 2,
    ACTIONS(1425), 1,
      aux_sym_template_content_token1,
    ACTIONS(1427), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25100] = 2,
    ACTIONS(1425), 1,
      aux_sym_template_content_token1,
    ACTIONS(1427), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25112] = 2,
    ACTIONS(1425), 1,
      aux_sym_template_content_token1,
    ACTIONS(1427), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25124] = 2,
    ACTIONS(1369), 1,
      aux_sym_template_content_token1,
    ACTIONS(1371), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25136] = 2,
    ACTIONS(1425), 1,
      aux_sym_template_content_token1,
    ACTIONS(1427), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25148] = 2,
    ACTIONS(1317), 1,
      aux_sym_template_content_token1,
    ACTIONS(1319), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25160] = 2,
    ACTIONS(1317), 1,
      aux_sym_template_content_token1,
    ACTIONS(1319), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25172] = 2,
    ACTIONS(1517), 1,
      aux_sym_template_content_token1,
    ACTIONS(1519), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25184] = 2,
    ACTIONS(1321), 1,
      aux_sym_template_content_token1,
    ACTIONS(1323), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25196] = 2,
    ACTIONS(1441), 1,
      aux_sym_template_content_token1,
    ACTIONS(1443), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25208] = 2,
    ACTIONS(1317), 1,
      aux_sym_template_content_token1,
    ACTIONS(1319), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25220] = 2,
    ACTIONS(1425), 1,
      aux_sym_template_content_token1,
    ACTIONS(1427), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25232] = 2,
    ACTIONS(1425), 1,
      aux_sym_template_content_token1,
    ACTIONS(1427), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25244] = 2,
    ACTIONS(1425), 1,
      aux_sym_template_content_token1,
    ACTIONS(1427), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25256] = 2,
    ACTIONS(1425), 1,
      aux_sym_template_content_token1,
    ACTIONS(1427), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25268] = 2,
    ACTIONS(1317), 1,
      aux_sym_template_content_token1,
    ACTIONS(1319), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25280] = 2,
    ACTIONS(1317), 1,
      aux_sym_template_content_token1,
    ACTIONS(1319), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25292] = 2,
    ACTIONS(1317), 1,
      aux_sym_template_content_token1,
    ACTIONS(1319), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25304] = 2,
    ACTIONS(1317), 1,
      aux_sym_template_content_token1,
    ACTIONS(1319), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25316] = 2,
    ACTIONS(1417), 1,
      aux_sym_template_content_token1,
    ACTIONS(1419), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25328] = 2,
    ACTIONS(1417), 1,
      aux_sym_template_content_token1,
    ACTIONS(1419), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25340] = 2,
    ACTIONS(1417), 1,
      aux_sym_template_content_token1,
    ACTIONS(1419), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25352] = 2,
    ACTIONS(1529), 1,
      aux_sym_template_content_token1,
    ACTIONS(1531), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25364] = 2,
    ACTIONS(1341), 1,
      aux_sym_template_content_token1,
    ACTIONS(1343), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25376] = 2,
    ACTIONS(1349), 1,
      aux_sym_template_content_token1,
    ACTIONS(1351), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25388] = 2,
    ACTIONS(1317), 1,
      aux_sym_template_content_token1,
    ACTIONS(1319), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25400] = 2,
    ACTIONS(1525), 1,
      aux_sym_template_content_token1,
    ACTIONS(1527), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25412] = 2,
    ACTIONS(1377), 1,
      aux_sym_template_content_token1,
    ACTIONS(1379), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25424] = 2,
    ACTIONS(1373), 1,
      aux_sym_template_content_token1,
    ACTIONS(1375), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25436] = 2,
    ACTIONS(1538), 1,
      aux_sym_template_content_token1,
    ACTIONS(1540), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25448] = 2,
    ACTIONS(1542), 1,
      aux_sym_template_content_token1,
    ACTIONS(1544), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25460] = 2,
    ACTIONS(1417), 1,
      aux_sym_template_content_token1,
    ACTIONS(1419), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25472] = 2,
    ACTIONS(1413), 1,
      aux_sym_template_content_token1,
    ACTIONS(1415), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25484] = 2,
    ACTIONS(1413), 1,
      aux_sym_template_content_token1,
    ACTIONS(1415), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25496] = 2,
    ACTIONS(1413), 1,
      aux_sym_template_content_token1,
    ACTIONS(1415), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25508] = 2,
    ACTIONS(1413), 1,
      aux_sym_template_content_token1,
    ACTIONS(1415), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25520] = 2,
    ACTIONS(1409), 1,
      aux_sym_template_content_token1,
    ACTIONS(1411), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25532] = 2,
    ACTIONS(1385), 1,
      aux_sym_template_content_token1,
    ACTIONS(1387), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25544] = 2,
    ACTIONS(1385), 1,
      aux_sym_template_content_token1,
    ACTIONS(1387), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25556] = 2,
    ACTIONS(1385), 1,
      aux_sym_template_content_token1,
    ACTIONS(1387), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25568] = 2,
    ACTIONS(1385), 1,
      aux_sym_template_content_token1,
    ACTIONS(1387), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25580] = 2,
    ACTIONS(1461), 1,
      aux_sym_template_content_token1,
    ACTIONS(1463), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25592] = 2,
    ACTIONS(1421), 1,
      aux_sym_template_content_token1,
    ACTIONS(1423), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25604] = 2,
    ACTIONS(1365), 1,
      aux_sym_template_content_token1,
    ACTIONS(1367), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25616] = 2,
    ACTIONS(1381), 1,
      aux_sym_template_content_token1,
    ACTIONS(1383), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25628] = 2,
    ACTIONS(1385), 1,
      aux_sym_template_content_token1,
    ACTIONS(1387), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25640] = 2,
    ACTIONS(1369), 1,
      aux_sym_template_content_token1,
    ACTIONS(1371), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25652] = 2,
    ACTIONS(1385), 1,
      aux_sym_template_content_token1,
    ACTIONS(1387), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25664] = 2,
    ACTIONS(1373), 1,
      aux_sym_template_content_token1,
    ACTIONS(1375), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25676] = 6,
    ACTIONS(926), 1,
      anon_sym_DOT,
    ACTIONS(928), 1,
      anon_sym_LBRACK,
    ACTIONS(953), 1,
      anon_sym_COLON,
    ACTIONS(955), 1,
      anon_sym_COMMA,
    STATE(725), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(657), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [25696] = 2,
    ACTIONS(1441), 1,
      aux_sym_template_content_token1,
    ACTIONS(1443), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25708] = 2,
    ACTIONS(1441), 1,
      aux_sym_template_content_token1,
    ACTIONS(1443), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25720] = 2,
    ACTIONS(1441), 1,
      aux_sym_template_content_token1,
    ACTIONS(1443), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25732] = 2,
    ACTIONS(1433), 1,
      aux_sym_template_content_token1,
    ACTIONS(1435), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25744] = 2,
    ACTIONS(1429), 1,
      aux_sym_template_content_token1,
    ACTIONS(1431), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25756] = 2,
    ACTIONS(1405), 1,
      aux_sym_template_content_token1,
    ACTIONS(1407), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25768] = 2,
    ACTIONS(1401), 1,
      aux_sym_template_content_token1,
    ACTIONS(1403), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25780] = 2,
    ACTIONS(1397), 1,
      aux_sym_template_content_token1,
    ACTIONS(1399), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25792] = 2,
    ACTIONS(1393), 1,
      aux_sym_template_content_token1,
    ACTIONS(1395), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25804] = 2,
    ACTIONS(1493), 1,
      aux_sym_template_content_token1,
    ACTIONS(1495), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25816] = 2,
    ACTIONS(1489), 1,
      aux_sym_template_content_token1,
    ACTIONS(1491), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25828] = 2,
    ACTIONS(1481), 1,
      aux_sym_template_content_token1,
    ACTIONS(1483), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25840] = 2,
    ACTIONS(1373), 1,
      aux_sym_template_content_token1,
    ACTIONS(1375), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25852] = 2,
    ACTIONS(1373), 1,
      aux_sym_template_content_token1,
    ACTIONS(1375), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25864] = 2,
    ACTIONS(1373), 1,
      aux_sym_template_content_token1,
    ACTIONS(1375), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25876] = 2,
    ACTIONS(1373), 1,
      aux_sym_template_content_token1,
    ACTIONS(1375), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25888] = 2,
    ACTIONS(1389), 1,
      aux_sym_template_content_token1,
    ACTIONS(1391), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25900] = 2,
    ACTIONS(1373), 1,
      aux_sym_template_content_token1,
    ACTIONS(1375), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25912] = 6,
    ACTIONS(1546), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1548), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1550), 1,
      anon_sym_SQUOTE,
    ACTIONS(1552), 1,
      anon_sym_DQUOTE,
    ACTIONS(1554), 1,
      aux_sym_include_statement_token1,
    STATE(710), 1,
      sym_string,
  [25931] = 6,
    ACTIONS(1089), 1,
      anon_sym_SQUOTE,
    ACTIONS(1091), 1,
      anon_sym_DQUOTE,
    ACTIONS(1556), 1,
      sym_identifier,
    ACTIONS(1558), 1,
      sym_number,
    STATE(668), 1,
      sym_access,
    STATE(691), 1,
      sym_string,
  [25950] = 4,
    ACTIONS(926), 1,
      anon_sym_DOT,
    ACTIONS(928), 1,
      anon_sym_LBRACK,
    ACTIONS(953), 1,
      anon_sym_COLON,
    ACTIONS(311), 3,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_COMMA,
  [25965] = 4,
    ACTIONS(1560), 1,
      aux_sym_template_content_token1,
    STATE(406), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(1315), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    ACTIONS(1562), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
  [25980] = 5,
    ACTIONS(926), 1,
      anon_sym_DOT,
    ACTIONS(928), 1,
      anon_sym_LBRACK,
    ACTIONS(1566), 1,
      anon_sym_COMMA,
    STATE(749), 1,
      aux_sym_cycle_statement_repeat1,
    ACTIONS(1564), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [25997] = 6,
    ACTIONS(21), 1,
      anon_sym_SQUOTE,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    ACTIONS(1568), 1,
      sym_identifier,
    ACTIONS(1570), 1,
      sym_number,
    STATE(697), 1,
      sym_access,
    STATE(737), 1,
      sym_string,
  [26016] = 6,
    ACTIONS(1089), 1,
      anon_sym_SQUOTE,
    ACTIONS(1091), 1,
      anon_sym_DQUOTE,
    ACTIONS(1572), 1,
      sym_identifier,
    ACTIONS(1574), 1,
      sym_number,
    STATE(673), 1,
      sym_access,
    STATE(729), 1,
      sym_string,
  [26035] = 6,
    ACTIONS(1089), 1,
      anon_sym_SQUOTE,
    ACTIONS(1091), 1,
      anon_sym_DQUOTE,
    ACTIONS(1576), 1,
      sym_identifier,
    ACTIONS(1578), 1,
      sym_number,
    STATE(682), 1,
      sym_access,
    STATE(774), 1,
      sym_string,
  [26054] = 6,
    ACTIONS(1580), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1582), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1584), 1,
      anon_sym_SQUOTE,
    ACTIONS(1586), 1,
      anon_sym_DQUOTE,
    ACTIONS(1588), 1,
      aux_sym_include_statement_token1,
    STATE(736), 1,
      sym_string,
  [26073] = 5,
    ACTIONS(926), 1,
      anon_sym_DOT,
    ACTIONS(928), 1,
      anon_sym_LBRACK,
    ACTIONS(1566), 1,
      anon_sym_COMMA,
    STATE(726), 1,
      aux_sym_cycle_statement_repeat1,
    ACTIONS(1590), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [26090] = 6,
    ACTIONS(21), 1,
      anon_sym_SQUOTE,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    ACTIONS(1592), 1,
      sym_identifier,
    ACTIONS(1594), 1,
      sym_number,
    STATE(731), 1,
      sym_access,
    STATE(826), 1,
      sym_string,
  [26109] = 6,
    ACTIONS(21), 1,
      anon_sym_SQUOTE,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    ACTIONS(1596), 1,
      sym_identifier,
    ACTIONS(1598), 1,
      sym_number,
    STATE(689), 1,
      sym_access,
    STATE(786), 1,
      sym_string,
  [26128] = 5,
    ACTIONS(1602), 1,
      anon_sym_when,
    STATE(676), 1,
      aux_sym__case_liq_repeat1,
    STATE(769), 1,
      sym__when_liq,
    STATE(770), 1,
      sym__when_aliased,
    ACTIONS(1600), 2,
      anon_sym_else,
      anon_sym_endcase,
  [26145] = 5,
    ACTIONS(926), 1,
      anon_sym_DOT,
    ACTIONS(928), 1,
      anon_sym_LBRACK,
    ACTIONS(955), 1,
      anon_sym_COMMA,
    STATE(725), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(305), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [26162] = 5,
    ACTIONS(1605), 1,
      sym_identifier,
    ACTIONS(1607), 1,
      anon_sym_LPAREN,
    STATE(321), 1,
      sym_access,
    STATE(370), 1,
      sym_range,
    STATE(957), 1,
      sym__iterator,
  [26178] = 5,
    ACTIONS(1609), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(1611), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(724), 1,
      aux_sym_if_statement_repeat1,
    STATE(830), 1,
      sym_else_clause,
    STATE(956), 1,
      sym_elsif_clause,
  [26194] = 5,
    ACTIONS(1607), 1,
      anon_sym_LPAREN,
    ACTIONS(1613), 1,
      sym_identifier,
    STATE(23), 1,
      sym__iterator,
    STATE(137), 1,
      sym_access,
    STATE(138), 1,
      sym_range,
  [26210] = 5,
    ACTIONS(1615), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(1617), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(724), 1,
      aux_sym_if_statement_repeat1,
    STATE(844), 1,
      sym_else_clause,
    STATE(956), 1,
      sym_elsif_clause,
  [26226] = 3,
    ACTIONS(926), 1,
      anon_sym_DOT,
    ACTIONS(928), 1,
      anon_sym_LBRACK,
    ACTIONS(1619), 3,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_COMMA,
  [26238] = 5,
    ACTIONS(1605), 1,
      sym_identifier,
    ACTIONS(1607), 1,
      anon_sym_LPAREN,
    STATE(321), 1,
      sym_access,
    STATE(370), 1,
      sym_range,
    STATE(821), 1,
      sym__iterator,
  [26254] = 4,
    ACTIONS(926), 1,
      anon_sym_DOT,
    ACTIONS(928), 1,
      anon_sym_LBRACK,
    ACTIONS(1623), 1,
      anon_sym_COMMA,
    ACTIONS(1621), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [26268] = 3,
    ACTIONS(1625), 1,
      sym_identifier,
    ACTIONS(1627), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
    STATE(695), 2,
      sym__include_param,
      aux_sym_include_statement_repeat1,
  [26280] = 5,
    ACTIONS(1089), 1,
      anon_sym_SQUOTE,
    ACTIONS(1091), 1,
      anon_sym_DQUOTE,
    ACTIONS(1629), 1,
      sym_identifier,
    STATE(701), 1,
      sym_access,
    STATE(753), 1,
      sym_string,
  [26296] = 3,
    ACTIONS(926), 1,
      anon_sym_DOT,
    ACTIONS(928), 1,
      anon_sym_LBRACK,
    ACTIONS(311), 3,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_COMMA,
  [26308] = 5,
    ACTIONS(1631), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(1633), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(699), 1,
      aux_sym_case_statement_repeat1,
    STATE(899), 1,
      sym_else_clause,
    STATE(950), 1,
      sym_when_clause,
  [26324] = 5,
    ACTIONS(647), 1,
      anon_sym_DOT,
    ACTIONS(649), 1,
      anon_sym_LBRACK,
    ACTIONS(1590), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(1635), 1,
      anon_sym_COMMA,
    STATE(797), 1,
      aux_sym_cycle_statement_repeat1,
  [26340] = 3,
    ACTIONS(926), 1,
      anon_sym_DOT,
    ACTIONS(928), 1,
      anon_sym_LBRACK,
    ACTIONS(321), 3,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_COMMA,
  [26352] = 4,
    ACTIONS(1566), 1,
      anon_sym_COMMA,
    ACTIONS(1637), 1,
      anon_sym_COLON,
    STATE(749), 1,
      aux_sym_cycle_statement_repeat1,
    ACTIONS(1564), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [26366] = 5,
    ACTIONS(1607), 1,
      anon_sym_LPAREN,
    ACTIONS(1613), 1,
      sym_identifier,
    STATE(14), 1,
      sym__iterator,
    STATE(137), 1,
      sym_access,
    STATE(138), 1,
      sym_range,
  [26382] = 3,
    ACTIONS(1625), 1,
      sym_identifier,
    ACTIONS(1639), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
    STATE(685), 2,
      sym__include_param,
      aux_sym_include_statement_repeat1,
  [26394] = 5,
    ACTIONS(1008), 1,
      anon_sym_SQUOTE,
    ACTIONS(1010), 1,
      anon_sym_DQUOTE,
    ACTIONS(1641), 1,
      sym_identifier,
    STATE(16), 1,
      sym_access,
    STATE(21), 1,
      sym_string,
  [26410] = 3,
    ACTIONS(1643), 1,
      sym_identifier,
    ACTIONS(1646), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
    STATE(695), 2,
      sym__include_param,
      aux_sym_include_statement_repeat1,
  [26422] = 4,
    ACTIONS(1648), 1,
      aux_sym_template_content_token1,
    STATE(667), 1,
      aux_sym_template_content_repeat1,
    STATE(906), 1,
      sym_template_content,
    ACTIONS(1650), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
  [26436] = 5,
    ACTIONS(647), 1,
      anon_sym_DOT,
    ACTIONS(649), 1,
      anon_sym_LBRACK,
    ACTIONS(1564), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(1635), 1,
      anon_sym_COMMA,
    STATE(775), 1,
      aux_sym_cycle_statement_repeat1,
  [26452] = 5,
    ACTIONS(1652), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(1654), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(724), 1,
      aux_sym_if_statement_repeat1,
    STATE(869), 1,
      sym_else_clause,
    STATE(956), 1,
      sym_elsif_clause,
  [26468] = 5,
    ACTIONS(1656), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(1658), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(723), 1,
      aux_sym_case_statement_repeat1,
    STATE(867), 1,
      sym_else_clause,
    STATE(950), 1,
      sym_when_clause,
  [26484] = 5,
    ACTIONS(1660), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(1662), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(724), 1,
      aux_sym_if_statement_repeat1,
    STATE(864), 1,
      sym_else_clause,
    STATE(956), 1,
      sym_elsif_clause,
  [26500] = 4,
    ACTIONS(926), 1,
      anon_sym_DOT,
    ACTIONS(928), 1,
      anon_sym_LBRACK,
    ACTIONS(1666), 1,
      anon_sym_COMMA,
    ACTIONS(1664), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [26514] = 5,
    ACTIONS(1605), 1,
      sym_identifier,
    ACTIONS(1607), 1,
      anon_sym_LPAREN,
    STATE(321), 1,
      sym_access,
    STATE(370), 1,
      sym_range,
    STATE(942), 1,
      sym__iterator,
  [26530] = 5,
    ACTIONS(1668), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(1670), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(724), 1,
      aux_sym_if_statement_repeat1,
    STATE(857), 1,
      sym_else_clause,
    STATE(956), 1,
      sym_elsif_clause,
  [26546] = 5,
    ACTIONS(1672), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(1674), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(724), 1,
      aux_sym_if_statement_repeat1,
    STATE(858), 1,
      sym_else_clause,
    STATE(956), 1,
      sym_elsif_clause,
  [26562] = 5,
    ACTIONS(1676), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(1678), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(711), 1,
      aux_sym_case_statement_repeat1,
    STATE(950), 1,
      sym_when_clause,
    STATE(951), 1,
      sym_else_clause,
  [26578] = 3,
    ACTIONS(1625), 1,
      sym_identifier,
    ACTIONS(1680), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
    STATE(695), 2,
      sym__include_param,
      aux_sym_include_statement_repeat1,
  [26590] = 5,
    ACTIONS(1682), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(1684), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(724), 1,
      aux_sym_if_statement_repeat1,
    STATE(892), 1,
      sym_else_clause,
    STATE(956), 1,
      sym_elsif_clause,
  [26606] = 5,
    ACTIONS(1605), 1,
      sym_identifier,
    ACTIONS(1607), 1,
      anon_sym_LPAREN,
    STATE(321), 1,
      sym_access,
    STATE(370), 1,
      sym_range,
    STATE(819), 1,
      sym__iterator,
  [26622] = 5,
    ACTIONS(1089), 1,
      anon_sym_SQUOTE,
    ACTIONS(1091), 1,
      anon_sym_DQUOTE,
    ACTIONS(1686), 1,
      sym_identifier,
    STATE(684), 1,
      sym_access,
    STATE(776), 1,
      sym_string,
  [26638] = 3,
    ACTIONS(1625), 1,
      sym_identifier,
    ACTIONS(1688), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
    STATE(706), 2,
      sym__include_param,
      aux_sym_include_statement_repeat1,
  [26650] = 5,
    ACTIONS(1690), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(1692), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(723), 1,
      aux_sym_case_statement_repeat1,
    STATE(887), 1,
      sym_else_clause,
    STATE(950), 1,
      sym_when_clause,
  [26666] = 5,
    ACTIONS(1694), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(1696), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(724), 1,
      aux_sym_if_statement_repeat1,
    STATE(876), 1,
      sym_else_clause,
    STATE(956), 1,
      sym_elsif_clause,
  [26682] = 4,
    ACTIONS(926), 1,
      anon_sym_DOT,
    ACTIONS(928), 1,
      anon_sym_LBRACK,
    ACTIONS(1698), 1,
      anon_sym_COMMA,
    ACTIONS(693), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [26696] = 4,
    ACTIONS(1648), 1,
      aux_sym_template_content_token1,
    STATE(667), 1,
      aux_sym_template_content_repeat1,
    STATE(947), 1,
      sym_template_content,
    ACTIONS(1650), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
  [26710] = 4,
    ACTIONS(1702), 1,
      anon_sym_COMMA,
    ACTIONS(1704), 1,
      anon_sym_for,
    ACTIONS(1706), 1,
      anon_sym_with,
    ACTIONS(1700), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [26724] = 3,
    ACTIONS(1710), 1,
      sym__inline_comment_content,
    STATE(717), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(1708), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [26735] = 3,
    ACTIONS(1714), 1,
      sym__inline_comment_content,
    STATE(717), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(1712), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [26746] = 4,
    ACTIONS(1717), 1,
      sym_identifier,
    ACTIONS(1719), 1,
      sym_number,
    STATE(713), 1,
      sym_access,
    STATE(818), 1,
      sym__page_iterator,
  [26759] = 4,
    ACTIONS(1089), 1,
      anon_sym_SQUOTE,
    ACTIONS(1091), 1,
      anon_sym_DQUOTE,
    ACTIONS(1721), 1,
      anon_sym_none,
    STATE(911), 1,
      sym_string,
  [26772] = 3,
    ACTIONS(1646), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(1723), 1,
      sym_identifier,
    STATE(720), 2,
      sym__include_param,
      aux_sym_include_statement_repeat1,
  [26783] = 3,
    ACTIONS(1639), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(1726), 1,
      sym_identifier,
    STATE(748), 2,
      sym__include_param,
      aux_sym_include_statement_repeat1,
  [26794] = 3,
    ACTIONS(1728), 1,
      anon_sym_COMMA,
    STATE(722), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(311), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [26805] = 4,
    ACTIONS(1731), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(1734), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(723), 1,
      aux_sym_case_statement_repeat1,
    STATE(950), 1,
      sym_when_clause,
  [26818] = 4,
    ACTIONS(1737), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(1740), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(724), 1,
      aux_sym_if_statement_repeat1,
    STATE(956), 1,
      sym_elsif_clause,
  [26831] = 3,
    ACTIONS(955), 1,
      anon_sym_COMMA,
    STATE(722), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(350), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [26842] = 3,
    ACTIONS(1566), 1,
      anon_sym_COMMA,
    STATE(730), 1,
      aux_sym_cycle_statement_repeat1,
    ACTIONS(1743), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [26853] = 3,
    ACTIONS(955), 1,
      anon_sym_COMMA,
    STATE(725), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(305), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [26864] = 4,
    ACTIONS(21), 1,
      anon_sym_SQUOTE,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    ACTIONS(1745), 1,
      anon_sym_none,
    STATE(1207), 1,
      sym_string,
  [26877] = 3,
    ACTIONS(1566), 1,
      anon_sym_COMMA,
    STATE(726), 1,
      aux_sym_cycle_statement_repeat1,
    ACTIONS(1590), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [26888] = 3,
    ACTIONS(1747), 1,
      anon_sym_COMMA,
    STATE(730), 1,
      aux_sym_cycle_statement_repeat1,
    ACTIONS(1619), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [26899] = 4,
    ACTIONS(647), 1,
      anon_sym_DOT,
    ACTIONS(649), 1,
      anon_sym_LBRACK,
    ACTIONS(1619), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(1750), 1,
      anon_sym_COMMA,
  [26912] = 3,
    ACTIONS(926), 1,
      anon_sym_DOT,
    ACTIONS(928), 1,
      anon_sym_LBRACK,
    ACTIONS(1752), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [26923] = 3,
    ACTIONS(1680), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(1726), 1,
      sym_identifier,
    STATE(720), 2,
      sym__include_param,
      aux_sym_include_statement_repeat1,
  [26934] = 4,
    ACTIONS(1754), 1,
      sym_identifier,
    ACTIONS(1756), 1,
      sym_number,
    STATE(34), 1,
      sym__page_iterator,
    STATE(153), 1,
      sym_access,
  [26947] = 4,
    ACTIONS(1700), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(1758), 1,
      anon_sym_COMMA,
    ACTIONS(1760), 1,
      anon_sym_for,
    ACTIONS(1762), 1,
      anon_sym_with,
  [26960] = 3,
    ACTIONS(1688), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(1726), 1,
      sym_identifier,
    STATE(733), 2,
      sym__include_param,
      aux_sym_include_statement_repeat1,
  [26971] = 4,
    ACTIONS(1564), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(1635), 1,
      anon_sym_COMMA,
    ACTIONS(1764), 1,
      anon_sym_COLON,
    STATE(775), 1,
      aux_sym_cycle_statement_repeat1,
  [26984] = 4,
    ACTIONS(1089), 1,
      anon_sym_SQUOTE,
    ACTIONS(1091), 1,
      anon_sym_DQUOTE,
    ACTIONS(1766), 1,
      sym_number,
    STATE(1091), 1,
      sym_string,
  [26997] = 1,
    ACTIONS(1768), 4,
      anon_sym_endif,
      anon_sym_elsif,
      anon_sym_else,
      anon_sym_endunless,
  [27004] = 1,
    ACTIONS(1770), 4,
      anon_sym_endif,
      anon_sym_elsif,
      anon_sym_else,
      anon_sym_endunless,
  [27011] = 3,
    ACTIONS(1710), 1,
      sym__inline_comment_content,
    STATE(717), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(1772), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [27022] = 4,
    ACTIONS(1089), 1,
      anon_sym_SQUOTE,
    ACTIONS(1091), 1,
      anon_sym_DQUOTE,
    ACTIONS(1774), 1,
      sym_number,
    STATE(1088), 1,
      sym_string,
  [27035] = 4,
    ACTIONS(1717), 1,
      sym_identifier,
    ACTIONS(1719), 1,
      sym_number,
    STATE(713), 1,
      sym_access,
    STATE(935), 1,
      sym__page_iterator,
  [27048] = 4,
    ACTIONS(1089), 1,
      anon_sym_SQUOTE,
    ACTIONS(1091), 1,
      anon_sym_DQUOTE,
    ACTIONS(1776), 1,
      sym_number,
    STATE(1054), 1,
      sym_string,
  [27061] = 3,
    ACTIONS(1566), 1,
      anon_sym_COMMA,
    STATE(749), 1,
      aux_sym_cycle_statement_repeat1,
    ACTIONS(1564), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [27072] = 4,
    ACTIONS(1089), 1,
      anon_sym_SQUOTE,
    ACTIONS(1091), 1,
      anon_sym_DQUOTE,
    ACTIONS(1778), 1,
      sym_number,
    STATE(1070), 1,
      sym_string,
  [27085] = 3,
    ACTIONS(926), 1,
      anon_sym_DOT,
    ACTIONS(928), 1,
      anon_sym_LBRACK,
    ACTIONS(1780), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [27096] = 3,
    ACTIONS(1627), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(1726), 1,
      sym_identifier,
    STATE(720), 2,
      sym__include_param,
      aux_sym_include_statement_repeat1,
  [27107] = 3,
    ACTIONS(1566), 1,
      anon_sym_COMMA,
    STATE(730), 1,
      aux_sym_cycle_statement_repeat1,
    ACTIONS(1782), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [27118] = 3,
    ACTIONS(1784), 1,
      anon_sym_endif,
    ACTIONS(1786), 1,
      anon_sym_elsif,
    ACTIONS(1788), 1,
      anon_sym_else,
  [27128] = 2,
    ACTIONS(1792), 1,
      anon_sym_as,
    ACTIONS(1790), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [27136] = 3,
    ACTIONS(1794), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(1796), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(891), 1,
      sym_raw_statement,
  [27146] = 2,
    ACTIONS(1666), 1,
      anon_sym_COMMA,
    ACTIONS(1664), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [27154] = 3,
    ACTIONS(926), 1,
      anon_sym_DOT,
    ACTIONS(928), 1,
      anon_sym_LBRACK,
    ACTIONS(1798), 1,
      anon_sym_by,
  [27164] = 3,
    ACTIONS(926), 1,
      anon_sym_DOT,
    ACTIONS(928), 1,
      anon_sym_LBRACK,
    ACTIONS(1800), 1,
      anon_sym_by,
  [27174] = 3,
    ACTIONS(1802), 1,
      anon_sym_comment,
    ACTIONS(1804), 1,
      anon_sym_endcomment,
    STATE(1056), 1,
      sym__paired_comment_liq,
  [27184] = 3,
    ACTIONS(1786), 1,
      anon_sym_elsif,
    ACTIONS(1788), 1,
      anon_sym_else,
    ACTIONS(1806), 1,
      anon_sym_endunless,
  [27194] = 3,
    ACTIONS(1786), 1,
      anon_sym_elsif,
    ACTIONS(1788), 1,
      anon_sym_else,
    ACTIONS(1808), 1,
      anon_sym_endunless,
  [27204] = 3,
    ACTIONS(1786), 1,
      anon_sym_elsif,
    ACTIONS(1788), 1,
      anon_sym_else,
    ACTIONS(1810), 1,
      anon_sym_endif,
  [27214] = 3,
    ACTIONS(1812), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(1814), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(926), 1,
      sym_raw_statement,
  [27224] = 3,
    ACTIONS(1816), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(1818), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(919), 1,
      sym__paired_comment,
  [27234] = 3,
    ACTIONS(1786), 1,
      anon_sym_elsif,
    ACTIONS(1788), 1,
      anon_sym_else,
    ACTIONS(1820), 1,
      anon_sym_endif,
  [27244] = 3,
    ACTIONS(1786), 1,
      anon_sym_elsif,
    ACTIONS(1788), 1,
      anon_sym_else,
    ACTIONS(1822), 1,
      anon_sym_endunless,
  [27254] = 3,
    ACTIONS(1786), 1,
      anon_sym_elsif,
    ACTIONS(1788), 1,
      anon_sym_else,
    ACTIONS(1824), 1,
      anon_sym_endunless,
  [27264] = 3,
    ACTIONS(1788), 1,
      anon_sym_else,
    ACTIONS(1826), 1,
      anon_sym_endcase,
    ACTIONS(1828), 1,
      anon_sym_when,
  [27274] = 3,
    ACTIONS(1786), 1,
      anon_sym_elsif,
    ACTIONS(1788), 1,
      anon_sym_else,
    ACTIONS(1830), 1,
      anon_sym_endif,
  [27284] = 3,
    ACTIONS(1786), 1,
      anon_sym_elsif,
    ACTIONS(1788), 1,
      anon_sym_else,
    ACTIONS(1832), 1,
      anon_sym_endif,
  [27294] = 3,
    ACTIONS(1834), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(1836), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(841), 1,
      sym_raw_statement,
  [27304] = 1,
    ACTIONS(1838), 3,
      anon_sym_else,
      anon_sym_endcase,
      anon_sym_when,
  [27310] = 1,
    ACTIONS(1840), 3,
      anon_sym_else,
      anon_sym_endcase,
      anon_sym_when,
  [27316] = 3,
    ACTIONS(1788), 1,
      anon_sym_else,
    ACTIONS(1828), 1,
      anon_sym_when,
    ACTIONS(1842), 1,
      anon_sym_endcase,
  [27326] = 3,
    ACTIONS(1844), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(1846), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(840), 1,
      sym__paired_comment,
  [27336] = 3,
    ACTIONS(1564), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(1635), 1,
      anon_sym_COMMA,
    STATE(775), 1,
      aux_sym_cycle_statement_repeat1,
  [27346] = 1,
    ACTIONS(1619), 3,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_COMMA,
  [27352] = 3,
    ACTIONS(1635), 1,
      anon_sym_COMMA,
    ACTIONS(1782), 1,
      aux_sym__liquid_node_token1,
    STATE(783), 1,
      aux_sym_cycle_statement_repeat1,
  [27362] = 2,
    ACTIONS(1623), 1,
      anon_sym_COMMA,
    ACTIONS(1621), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [27370] = 3,
    ACTIONS(1848), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(1850), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(889), 1,
      sym__paired_comment,
  [27380] = 3,
    ACTIONS(1852), 1,
      sym_identifier,
    ACTIONS(1854), 1,
      sym_number,
    STATE(789), 1,
      sym_access,
  [27390] = 3,
    ACTIONS(1788), 1,
      anon_sym_else,
    ACTIONS(1828), 1,
      anon_sym_when,
    ACTIONS(1856), 1,
      anon_sym_endcase,
  [27400] = 2,
    ACTIONS(1698), 1,
      anon_sym_COMMA,
    ACTIONS(693), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [27408] = 3,
    ACTIONS(1802), 1,
      anon_sym_comment,
    ACTIONS(1858), 1,
      anon_sym_endcomment,
    STATE(1084), 1,
      sym__paired_comment_liq,
  [27418] = 3,
    ACTIONS(21), 1,
      anon_sym_SQUOTE,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    STATE(735), 1,
      sym_string,
  [27428] = 3,
    ACTIONS(1619), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(1860), 1,
      anon_sym_COMMA,
    STATE(783), 1,
      aux_sym_cycle_statement_repeat1,
  [27438] = 3,
    ACTIONS(21), 1,
      anon_sym_SQUOTE,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    STATE(1185), 1,
      sym_string,
  [27448] = 3,
    ACTIONS(21), 1,
      anon_sym_SQUOTE,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    STATE(1119), 1,
      sym_string,
  [27458] = 3,
    ACTIONS(1590), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(1635), 1,
      anon_sym_COMMA,
    STATE(797), 1,
      aux_sym_cycle_statement_repeat1,
  [27468] = 3,
    ACTIONS(1089), 1,
      anon_sym_SQUOTE,
    ACTIONS(1091), 1,
      anon_sym_DQUOTE,
    STATE(715), 1,
      sym_string,
  [27478] = 3,
    ACTIONS(1089), 1,
      anon_sym_SQUOTE,
    ACTIONS(1091), 1,
      anon_sym_DQUOTE,
    STATE(908), 1,
      sym_string,
  [27488] = 3,
    ACTIONS(928), 1,
      anon_sym_LBRACK,
    ACTIONS(1863), 1,
      anon_sym_DOT,
    ACTIONS(1865), 1,
      anon_sym_DOT_DOT,
  [27498] = 3,
    ACTIONS(1786), 1,
      anon_sym_elsif,
    ACTIONS(1788), 1,
      anon_sym_else,
    ACTIONS(1867), 1,
      anon_sym_endif,
  [27508] = 3,
    ACTIONS(1786), 1,
      anon_sym_elsif,
    ACTIONS(1788), 1,
      anon_sym_else,
    ACTIONS(1869), 1,
      anon_sym_endif,
  [27518] = 3,
    ACTIONS(1089), 1,
      anon_sym_SQUOTE,
    ACTIONS(1091), 1,
      anon_sym_DQUOTE,
    STATE(907), 1,
      sym_string,
  [27528] = 3,
    ACTIONS(1788), 1,
      anon_sym_else,
    ACTIONS(1828), 1,
      anon_sym_when,
    ACTIONS(1871), 1,
      anon_sym_endcase,
  [27538] = 3,
    ACTIONS(926), 1,
      anon_sym_DOT,
    ACTIONS(928), 1,
      anon_sym_LBRACK,
    ACTIONS(1873), 1,
      anon_sym_by,
  [27548] = 3,
    ACTIONS(1786), 1,
      anon_sym_elsif,
    ACTIONS(1788), 1,
      anon_sym_else,
    ACTIONS(1875), 1,
      anon_sym_endunless,
  [27558] = 3,
    ACTIONS(1786), 1,
      anon_sym_elsif,
    ACTIONS(1788), 1,
      anon_sym_else,
    ACTIONS(1877), 1,
      anon_sym_endunless,
  [27568] = 3,
    ACTIONS(1635), 1,
      anon_sym_COMMA,
    ACTIONS(1743), 1,
      aux_sym__liquid_node_token1,
    STATE(783), 1,
      aux_sym_cycle_statement_repeat1,
  [27578] = 3,
    ACTIONS(1879), 1,
      sym_identifier,
    ACTIONS(1881), 1,
      sym_number,
    STATE(799), 1,
      sym_access,
  [27588] = 3,
    ACTIONS(926), 1,
      anon_sym_DOT,
    ACTIONS(928), 1,
      anon_sym_LBRACK,
    ACTIONS(1883), 1,
      anon_sym_RPAREN,
  [27598] = 3,
    ACTIONS(1786), 1,
      anon_sym_elsif,
    ACTIONS(1788), 1,
      anon_sym_else,
    ACTIONS(1885), 1,
      anon_sym_endif,
  [27608] = 3,
    ACTIONS(1786), 1,
      anon_sym_elsif,
    ACTIONS(1788), 1,
      anon_sym_else,
    ACTIONS(1887), 1,
      anon_sym_endunless,
  [27618] = 3,
    ACTIONS(1786), 1,
      anon_sym_elsif,
    ACTIONS(1788), 1,
      anon_sym_else,
    ACTIONS(1889), 1,
      anon_sym_endunless,
  [27628] = 1,
    ACTIONS(1891), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [27633] = 1,
    ACTIONS(1893), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [27638] = 2,
    ACTIONS(1895), 1,
      sym_identifier,
    STATE(794), 1,
      sym_access,
  [27645] = 2,
    ACTIONS(1897), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(1899), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [27652] = 2,
    ACTIONS(1901), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(1903), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [27659] = 2,
    ACTIONS(1905), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(1907), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [27666] = 1,
    ACTIONS(1909), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [27671] = 1,
    ACTIONS(1911), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [27676] = 2,
    ACTIONS(1913), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(1915), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [27683] = 2,
    ACTIONS(1917), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(1919), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [27690] = 2,
    ACTIONS(1790), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(1921), 1,
      anon_sym_as,
  [27697] = 1,
    ACTIONS(1923), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [27702] = 1,
    ACTIONS(1925), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [27707] = 1,
    ACTIONS(1927), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [27712] = 2,
    ACTIONS(1929), 1,
      sym_identifier,
    STATE(732), 1,
      sym_access,
  [27719] = 2,
    ACTIONS(1931), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(1933), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [27726] = 2,
    ACTIONS(1935), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(1937), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [27733] = 1,
    ACTIONS(1939), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [27738] = 2,
    ACTIONS(1941), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(1943), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [27745] = 1,
    ACTIONS(1945), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [27750] = 1,
    ACTIONS(1947), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [27755] = 1,
    ACTIONS(1949), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [27760] = 1,
    ACTIONS(1951), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [27765] = 2,
    ACTIONS(1619), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(1750), 1,
      anon_sym_COMMA,
  [27772] = 1,
    ACTIONS(1953), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [27777] = 2,
    ACTIONS(1955), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(1957), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [27784] = 2,
    ACTIONS(1959), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(1961), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [27791] = 2,
    ACTIONS(1963), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(1965), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [27798] = 2,
    ACTIONS(1967), 1,
      sym_identifier,
    STATE(747), 1,
      sym_access,
  [27805] = 1,
    ACTIONS(1969), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [27810] = 1,
    ACTIONS(1971), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [27815] = 1,
    ACTIONS(1973), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [27820] = 1,
    ACTIONS(1975), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [27825] = 1,
    ACTIONS(1977), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [27830] = 1,
    ACTIONS(1979), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [27835] = 1,
    ACTIONS(1075), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [27840] = 2,
    ACTIONS(1981), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(1983), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [27847] = 2,
    ACTIONS(1985), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(1987), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [27854] = 2,
    ACTIONS(1989), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(1991), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [27861] = 2,
    ACTIONS(1993), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(1995), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [27868] = 2,
    ACTIONS(1997), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(1999), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [27875] = 2,
    ACTIONS(2001), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(2003), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [27882] = 2,
    ACTIONS(2005), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(2007), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [27889] = 1,
    ACTIONS(2009), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [27894] = 1,
    ACTIONS(2011), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [27899] = 2,
    ACTIONS(2013), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(2015), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [27906] = 2,
    ACTIONS(2017), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(2019), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [27913] = 1,
    ACTIONS(2021), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [27918] = 1,
    ACTIONS(2023), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [27923] = 2,
    ACTIONS(2025), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(2027), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [27930] = 2,
    ACTIONS(2029), 1,
      sym_identifier,
    STATE(754), 1,
      sym_access,
  [27937] = 1,
    ACTIONS(2031), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [27942] = 1,
    ACTIONS(2033), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [27947] = 1,
    ACTIONS(2035), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [27952] = 2,
    ACTIONS(2037), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(2039), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [27959] = 2,
    ACTIONS(2041), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(2043), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [27966] = 1,
    ACTIONS(2045), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [27971] = 2,
    ACTIONS(2047), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(2049), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [27978] = 1,
    ACTIONS(2051), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [27983] = 2,
    ACTIONS(2053), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(2055), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [27990] = 1,
    ACTIONS(2057), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [27995] = 2,
    ACTIONS(2059), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(2061), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [28002] = 2,
    ACTIONS(2063), 1,
      sym_identifier,
    STATE(392), 1,
      sym_access,
  [28009] = 2,
    ACTIONS(2065), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(2067), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [28016] = 2,
    ACTIONS(2069), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(2071), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [28023] = 1,
    ACTIONS(2073), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28028] = 2,
    ACTIONS(2075), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(2077), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [28035] = 1,
    ACTIONS(2079), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28040] = 1,
    ACTIONS(2081), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28045] = 1,
    ACTIONS(2083), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28050] = 1,
    ACTIONS(2085), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28055] = 1,
    ACTIONS(2087), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28060] = 1,
    ACTIONS(2089), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28065] = 2,
    ACTIONS(2091), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(2093), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [28072] = 2,
    ACTIONS(2095), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2097), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [28079] = 2,
    ACTIONS(2099), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2101), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [28086] = 2,
    ACTIONS(2103), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(2105), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [28093] = 2,
    ACTIONS(2107), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(2109), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [28100] = 1,
    ACTIONS(2111), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28105] = 2,
    ACTIONS(2113), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2115), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [28112] = 2,
    ACTIONS(1401), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    ACTIONS(1403), 1,
      anon_sym_LBRACE_PERCENT,
  [28119] = 2,
    ACTIONS(1405), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    ACTIONS(1407), 1,
      anon_sym_LBRACE_PERCENT,
  [28126] = 2,
    ACTIONS(1509), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    ACTIONS(1511), 1,
      anon_sym_LBRACE_PERCENT,
  [28133] = 2,
    ACTIONS(1513), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    ACTIONS(1515), 1,
      anon_sym_LBRACE_PERCENT,
  [28140] = 2,
    ACTIONS(2117), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(2119), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [28147] = 2,
    ACTIONS(2121), 1,
      sym_identifier,
    STATE(755), 1,
      sym_access,
  [28154] = 2,
    ACTIONS(2123), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(2125), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [28161] = 1,
    ACTIONS(2127), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28166] = 2,
    ACTIONS(2129), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(2131), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [28173] = 2,
    ACTIONS(2133), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(2135), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [28180] = 2,
    ACTIONS(2137), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2139), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [28187] = 2,
    ACTIONS(2141), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2143), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [28194] = 2,
    ACTIONS(2145), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(2147), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [28201] = 2,
    ACTIONS(2149), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(2151), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [28208] = 1,
    ACTIONS(2153), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28213] = 1,
    ACTIONS(2155), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28218] = 2,
    ACTIONS(2157), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(2159), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [28225] = 1,
    ACTIONS(2161), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28230] = 2,
    ACTIONS(2163), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(2165), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [28237] = 1,
    ACTIONS(2167), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28242] = 2,
    ACTIONS(2169), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2171), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [28249] = 2,
    ACTIONS(2173), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2175), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [28256] = 2,
    ACTIONS(2177), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2179), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [28263] = 2,
    ACTIONS(2181), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(2183), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [28270] = 1,
    ACTIONS(2185), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28275] = 1,
    ACTIONS(2187), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28280] = 1,
    ACTIONS(2189), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28285] = 1,
    ACTIONS(2191), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28290] = 1,
    ACTIONS(2193), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28295] = 2,
    ACTIONS(2195), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2197), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [28302] = 2,
    ACTIONS(2199), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2201), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [28309] = 2,
    ACTIONS(2203), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2205), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [28316] = 2,
    ACTIONS(2207), 1,
      anon_sym_comment,
    ACTIONS(2209), 1,
      anon_sym_endcomment,
  [28323] = 2,
    ACTIONS(2211), 1,
      anon_sym_raw,
    ACTIONS(2213), 1,
      anon_sym_endraw,
  [28330] = 2,
    ACTIONS(2215), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2217), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [28337] = 2,
    ACTIONS(2219), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2221), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [28344] = 2,
    ACTIONS(2223), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(2225), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [28351] = 2,
    ACTIONS(2207), 1,
      anon_sym_comment,
    ACTIONS(2227), 1,
      anon_sym_endcomment,
  [28358] = 2,
    ACTIONS(2229), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2231), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [28365] = 2,
    ACTIONS(2233), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2235), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [28372] = 2,
    ACTIONS(2237), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2239), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [28379] = 2,
    ACTIONS(2241), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2243), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [28386] = 2,
    ACTIONS(2245), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2247), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [28393] = 2,
    ACTIONS(2249), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(2251), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [28400] = 2,
    ACTIONS(2211), 1,
      anon_sym_raw,
    ACTIONS(2253), 1,
      anon_sym_endraw,
  [28407] = 2,
    ACTIONS(2255), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2257), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [28414] = 1,
    ACTIONS(2259), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28419] = 1,
    ACTIONS(2261), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28424] = 1,
    ACTIONS(2263), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28429] = 2,
    ACTIONS(2265), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2267), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [28436] = 2,
    ACTIONS(2269), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2271), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [28443] = 2,
    ACTIONS(2273), 1,
      sym_identifier,
    STATE(971), 1,
      sym__render_param,
  [28450] = 2,
    ACTIONS(2275), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2277), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [28457] = 1,
    ACTIONS(2279), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28462] = 2,
    ACTIONS(2281), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2283), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [28469] = 2,
    ACTIONS(2285), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2287), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [28476] = 2,
    ACTIONS(2289), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2291), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [28483] = 1,
    ACTIONS(2293), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28488] = 2,
    ACTIONS(2295), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2297), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [28495] = 2,
    ACTIONS(2299), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2301), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [28502] = 1,
    ACTIONS(2303), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28507] = 2,
    ACTIONS(2305), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2307), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [28514] = 2,
    ACTIONS(2309), 1,
      sym_identifier,
    STATE(1232), 1,
      sym__render_param,
  [28521] = 2,
    ACTIONS(2309), 1,
      sym_identifier,
    STATE(1237), 1,
      sym__render_param,
  [28528] = 2,
    ACTIONS(2311), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(2313), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [28535] = 2,
    ACTIONS(2315), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2317), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [28542] = 2,
    ACTIONS(2319), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(2321), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [28549] = 2,
    ACTIONS(2323), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(2325), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [28556] = 2,
    ACTIONS(2327), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(2329), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [28563] = 2,
    ACTIONS(2331), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2333), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [28570] = 2,
    ACTIONS(2335), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(2337), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [28577] = 1,
    ACTIONS(2339), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28582] = 1,
    ACTIONS(2341), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28587] = 2,
    ACTIONS(2343), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(2345), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [28594] = 2,
    ACTIONS(2347), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2349), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [28601] = 2,
    ACTIONS(2351), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2353), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [28608] = 2,
    ACTIONS(2355), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2357), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [28615] = 1,
    ACTIONS(2359), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28620] = 1,
    ACTIONS(2361), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28625] = 1,
    ACTIONS(2363), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28630] = 1,
    ACTIONS(2365), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28635] = 1,
    ACTIONS(2367), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28640] = 1,
    ACTIONS(2369), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28645] = 1,
    ACTIONS(2371), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28650] = 1,
    ACTIONS(2373), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28655] = 1,
    ACTIONS(2375), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28660] = 1,
    ACTIONS(2377), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28665] = 1,
    ACTIONS(2379), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28670] = 1,
    ACTIONS(2381), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28675] = 2,
    ACTIONS(2383), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2385), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [28682] = 1,
    ACTIONS(2387), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28687] = 1,
    ACTIONS(2389), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28692] = 1,
    ACTIONS(2391), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28697] = 2,
    ACTIONS(2393), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2395), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [28704] = 2,
    ACTIONS(2397), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2399), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [28711] = 1,
    ACTIONS(2401), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28716] = 2,
    ACTIONS(2403), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2405), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [28723] = 1,
    ACTIONS(2407), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28728] = 1,
    ACTIONS(2409), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28733] = 2,
    ACTIONS(2411), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2413), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [28740] = 2,
    ACTIONS(2415), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2417), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [28747] = 1,
    ACTIONS(2419), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28752] = 1,
    ACTIONS(2421), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28757] = 1,
    ACTIONS(2423), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28762] = 1,
    ACTIONS(2425), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28767] = 2,
    ACTIONS(2427), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2429), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [28774] = 2,
    ACTIONS(2431), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2433), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [28781] = 2,
    ACTIONS(2435), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2437), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [28788] = 2,
    ACTIONS(2439), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2441), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [28795] = 1,
    ACTIONS(2443), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28800] = 2,
    ACTIONS(2445), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2447), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [28807] = 2,
    ACTIONS(2449), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2451), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [28814] = 2,
    ACTIONS(2453), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2455), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [28821] = 2,
    ACTIONS(2457), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2459), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [28828] = 1,
    ACTIONS(2461), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28833] = 1,
    ACTIONS(2463), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28838] = 2,
    ACTIONS(2465), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2467), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [28845] = 2,
    ACTIONS(2469), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2471), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [28852] = 2,
    ACTIONS(2473), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2475), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [28859] = 2,
    ACTIONS(2477), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2479), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [28866] = 1,
    ACTIONS(2481), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28871] = 2,
    ACTIONS(2483), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2485), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [28878] = 2,
    ACTIONS(2487), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2489), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [28885] = 2,
    ACTIONS(2491), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2493), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [28892] = 2,
    ACTIONS(2495), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2497), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [28899] = 2,
    ACTIONS(2499), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2501), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [28906] = 2,
    ACTIONS(2503), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2505), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [28913] = 2,
    ACTIONS(2507), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2509), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [28920] = 2,
    ACTIONS(2511), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2513), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [28927] = 2,
    ACTIONS(2515), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2517), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [28934] = 2,
    ACTIONS(2519), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2521), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [28941] = 2,
    ACTIONS(2523), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2525), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [28948] = 2,
    ACTIONS(2527), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2529), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [28955] = 2,
    ACTIONS(2531), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2533), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [28962] = 2,
    ACTIONS(2535), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2537), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [28969] = 2,
    ACTIONS(2539), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2541), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [28976] = 2,
    ACTIONS(2543), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2545), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [28983] = 2,
    ACTIONS(2547), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2549), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [28990] = 2,
    ACTIONS(2551), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2553), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [28997] = 2,
    ACTIONS(2555), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2557), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [29004] = 2,
    ACTIONS(2559), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2561), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [29011] = 1,
    ACTIONS(2563), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [29016] = 2,
    ACTIONS(2565), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2567), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [29023] = 2,
    ACTIONS(2569), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2571), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [29030] = 2,
    ACTIONS(2573), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2575), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [29037] = 2,
    ACTIONS(2577), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2579), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [29044] = 2,
    ACTIONS(2581), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2583), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [29051] = 2,
    ACTIONS(2585), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2587), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [29058] = 2,
    ACTIONS(2589), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2591), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [29065] = 2,
    ACTIONS(2593), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2595), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [29072] = 2,
    ACTIONS(2597), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2599), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [29079] = 2,
    ACTIONS(2601), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2603), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [29086] = 2,
    ACTIONS(2605), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2607), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [29093] = 2,
    ACTIONS(2609), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2611), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [29100] = 2,
    ACTIONS(2273), 1,
      sym_identifier,
    STATE(970), 1,
      sym__render_param,
  [29107] = 2,
    ACTIONS(2613), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2615), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [29114] = 2,
    ACTIONS(2617), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2619), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [29121] = 2,
    ACTIONS(2207), 1,
      anon_sym_comment,
    ACTIONS(2621), 1,
      anon_sym_endcomment,
  [29128] = 2,
    ACTIONS(2211), 1,
      anon_sym_raw,
    ACTIONS(2623), 1,
      anon_sym_endraw,
  [29135] = 2,
    ACTIONS(2625), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2627), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [29142] = 1,
    ACTIONS(2629), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [29147] = 1,
    ACTIONS(2631), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [29152] = 1,
    ACTIONS(2633), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [29157] = 1,
    ACTIONS(2635), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [29162] = 2,
    ACTIONS(2637), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2639), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [29169] = 2,
    ACTIONS(2641), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2643), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [29176] = 2,
    ACTIONS(2645), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2647), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [29183] = 2,
    ACTIONS(2649), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2651), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [29190] = 2,
    ACTIONS(2653), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2655), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [29197] = 1,
    ACTIONS(2657), 1,
      aux_sym_string_token1,
  [29201] = 1,
    ACTIONS(2659), 1,
      aux_sym__liquid_node_token1,
  [29205] = 1,
    ACTIONS(2661), 1,
      anon_sym_RBRACK,
  [29209] = 1,
    ACTIONS(2663), 1,
      sym_identifier,
  [29213] = 1,
    ACTIONS(2665), 1,
      anon_sym_endcomment,
  [29217] = 1,
    ACTIONS(2667), 1,
      aux_sym_string_token1,
  [29221] = 1,
    ACTIONS(2669), 1,
      aux_sym_string_token2,
  [29225] = 1,
    ACTIONS(2671), 1,
      sym__paired_comment_content_liq,
  [29229] = 1,
    ACTIONS(2673), 1,
      anon_sym_SQUOTE,
  [29233] = 1,
    ACTIONS(2675), 1,
      aux_sym__liquid_node_token1,
  [29237] = 1,
    ACTIONS(2677), 1,
      aux_sym__liquid_node_token1,
  [29241] = 1,
    ACTIONS(2679), 1,
      aux_sym__liquid_node_token1,
  [29245] = 1,
    ACTIONS(2681), 1,
      anon_sym_endunless,
  [29249] = 1,
    ACTIONS(1786), 1,
      anon_sym_elsif,
  [29253] = 1,
    ACTIONS(2683), 1,
      aux_sym__liquid_node_token1,
  [29257] = 1,
    ACTIONS(2685), 1,
      sym_identifier,
  [29261] = 1,
    ACTIONS(2687), 1,
      anon_sym_endcase,
  [29265] = 1,
    ACTIONS(2689), 1,
      anon_sym_endschema,
  [29269] = 1,
    ACTIONS(2691), 1,
      anon_sym_RBRACK,
  [29273] = 1,
    ACTIONS(2693), 1,
      aux_sym__liquid_node_token1,
  [29277] = 1,
    ACTIONS(2695), 1,
      sym_identifier,
  [29281] = 1,
    ACTIONS(2697), 1,
      anon_sym_DQUOTE,
  [29285] = 1,
    ACTIONS(2699), 1,
      anon_sym_endif,
  [29289] = 1,
    ACTIONS(2697), 1,
      anon_sym_SQUOTE,
  [29293] = 1,
    ACTIONS(2701), 1,
      anon_sym_endfor,
  [29297] = 1,
    ACTIONS(2703), 1,
      anon_sym_endfor,
  [29301] = 1,
    ACTIONS(2705), 1,
      anon_sym_endcase,
  [29305] = 1,
    ACTIONS(2707), 1,
      sym_identifier,
  [29309] = 1,
    ACTIONS(2709), 1,
      anon_sym_endunless,
  [29313] = 1,
    ACTIONS(2711), 1,
      anon_sym_endif,
  [29317] = 1,
    ACTIONS(687), 1,
      anon_sym_endcomment,
  [29321] = 1,
    ACTIONS(2713), 1,
      sym_identifier,
  [29325] = 1,
    ACTIONS(2715), 1,
      anon_sym_endcomment,
  [29329] = 1,
    ACTIONS(2717), 1,
      aux_sym__liquid_node_token1,
  [29333] = 1,
    ACTIONS(2719), 1,
      anon_sym_endraw,
  [29337] = 1,
    ACTIONS(2721), 1,
      anon_sym_endcomment,
  [29341] = 1,
    ACTIONS(2723), 1,
      anon_sym_RBRACK,
  [29345] = 1,
    ACTIONS(2725), 1,
      anon_sym_endfor,
  [29349] = 1,
    ACTIONS(2727), 1,
      anon_sym_endfor,
  [29353] = 1,
    ACTIONS(2729), 1,
      anon_sym_RBRACK,
  [29357] = 1,
    ACTIONS(2731), 1,
      anon_sym_endif,
  [29361] = 1,
    ACTIONS(2733), 1,
      anon_sym_EQ2,
  [29365] = 1,
    ACTIONS(2735), 1,
      sym_identifier,
  [29369] = 1,
    ACTIONS(2737), 1,
      anon_sym_endif,
  [29373] = 1,
    ACTIONS(2739), 1,
      anon_sym_endif,
  [29377] = 1,
    ACTIONS(2741), 1,
      anon_sym_endcase,
  [29381] = 1,
    ACTIONS(2743), 1,
      anon_sym_endunless,
  [29385] = 1,
    ACTIONS(2745), 1,
      anon_sym_DQUOTE,
  [29389] = 1,
    ACTIONS(2745), 1,
      anon_sym_SQUOTE,
  [29393] = 1,
    ACTIONS(2747), 1,
      anon_sym_endunless,
  [29397] = 1,
    ACTIONS(2749), 1,
      anon_sym_endunless,
  [29401] = 1,
    ACTIONS(2751), 1,
      sym_identifier,
  [29405] = 1,
    ACTIONS(2753), 1,
      anon_sym_EQ,
  [29409] = 1,
    ACTIONS(2755), 1,
      ts_builtin_sym_end,
  [29413] = 1,
    ACTIONS(2757), 1,
      anon_sym_EQ2,
  [29417] = 1,
    ACTIONS(2759), 1,
      anon_sym_endschema,
  [29421] = 1,
    ACTIONS(1097), 1,
      aux_sym__liquid_node_token1,
  [29425] = 1,
    ACTIONS(2761), 1,
      sym_identifier,
  [29429] = 1,
    ACTIONS(2763), 1,
      anon_sym_in,
  [29433] = 1,
    ACTIONS(2765), 1,
      anon_sym_in,
  [29437] = 1,
    ACTIONS(2767), 1,
      anon_sym_endfor,
  [29441] = 1,
    ACTIONS(2769), 1,
      anon_sym_endfor,
  [29445] = 1,
    ACTIONS(2771), 1,
      sym_identifier,
  [29449] = 1,
    ACTIONS(2773), 1,
      anon_sym_DQUOTE,
  [29453] = 1,
    ACTIONS(2775), 1,
      anon_sym_endfor,
  [29457] = 1,
    ACTIONS(2777), 1,
      anon_sym_endfor,
  [29461] = 1,
    ACTIONS(2773), 1,
      anon_sym_SQUOTE,
  [29465] = 1,
    ACTIONS(2185), 1,
      aux_sym__liquid_node_token1,
  [29469] = 1,
    ACTIONS(2779), 1,
      anon_sym_endif,
  [29473] = 1,
    ACTIONS(2781), 1,
      anon_sym_endif,
  [29477] = 1,
    ACTIONS(2783), 1,
      anon_sym_endunless,
  [29481] = 1,
    ACTIONS(2785), 1,
      anon_sym_endunless,
  [29485] = 1,
    ACTIONS(2787), 1,
      sym_identifier,
  [29489] = 1,
    ACTIONS(2789), 1,
      sym_identifier,
  [29493] = 1,
    ACTIONS(2791), 1,
      sym__paired_comment_content,
  [29497] = 1,
    ACTIONS(2793), 1,
      sym_raw_content,
  [29501] = 1,
    ACTIONS(2795), 1,
      anon_sym_endunless,
  [29505] = 1,
    ACTIONS(2797), 1,
      anon_sym_in,
  [29509] = 1,
    ACTIONS(2799), 1,
      anon_sym_endunless,
  [29513] = 1,
    ACTIONS(2801), 1,
      anon_sym_endfor,
  [29517] = 1,
    ACTIONS(2803), 1,
      aux_sym__liquid_node_token1,
  [29521] = 1,
    ACTIONS(2805), 1,
      anon_sym_endfor,
  [29525] = 1,
    ACTIONS(2807), 1,
      anon_sym_endfor,
  [29529] = 1,
    ACTIONS(2809), 1,
      anon_sym_endfor,
  [29533] = 1,
    ACTIONS(2811), 1,
      anon_sym_endfor,
  [29537] = 1,
    ACTIONS(2813), 1,
      anon_sym_in,
  [29541] = 1,
    ACTIONS(2815), 1,
      aux_sym__liquid_node_token1,
  [29545] = 1,
    ACTIONS(2817), 1,
      aux_sym_string_token2,
  [29549] = 1,
    ACTIONS(2819), 1,
      aux_sym__liquid_node_token1,
  [29553] = 1,
    ACTIONS(2821), 1,
      anon_sym_endif,
  [29557] = 1,
    ACTIONS(2823), 1,
      aux_sym__liquid_node_token1,
  [29561] = 1,
    ACTIONS(2825), 1,
      anon_sym_endraw,
  [29565] = 1,
    ACTIONS(2827), 1,
      anon_sym_endcomment,
  [29569] = 1,
    ACTIONS(2829), 1,
      anon_sym_endif,
  [29573] = 1,
    ACTIONS(2673), 1,
      anon_sym_DQUOTE,
  [29577] = 1,
    ACTIONS(2831), 1,
      sym_identifier,
  [29581] = 1,
    ACTIONS(2833), 1,
      aux_sym_string_token1,
  [29585] = 1,
    ACTIONS(2835), 1,
      anon_sym_EQ,
  [29589] = 1,
    ACTIONS(2837), 1,
      anon_sym_endcase,
  [29593] = 1,
    ACTIONS(2839), 1,
      aux_sym__liquid_node_token1,
  [29597] = 1,
    ACTIONS(2841), 1,
      aux_sym__liquid_node_token1,
  [29601] = 1,
    ACTIONS(2843), 1,
      anon_sym_endunless,
  [29605] = 1,
    ACTIONS(2845), 1,
      aux_sym__liquid_node_token1,
  [29609] = 1,
    ACTIONS(2847), 1,
      aux_sym__liquid_node_token1,
  [29613] = 1,
    ACTIONS(2849), 1,
      anon_sym_endunless,
  [29617] = 1,
    ACTIONS(2847), 1,
      aux_sym__liquid_node_token1,
  [29621] = 1,
    ACTIONS(2851), 1,
      aux_sym__liquid_node_token1,
  [29625] = 1,
    ACTIONS(2853), 1,
      aux_sym__liquid_node_token1,
  [29629] = 1,
    ACTIONS(2855), 1,
      aux_sym__liquid_node_token1,
  [29633] = 1,
    ACTIONS(2857), 1,
      sym_identifier,
  [29637] = 1,
    ACTIONS(2859), 1,
      aux_sym__liquid_node_token1,
  [29641] = 1,
    ACTIONS(2861), 1,
      aux_sym__liquid_node_token1,
  [29645] = 1,
    ACTIONS(1865), 1,
      anon_sym_DOT_DOT,
  [29649] = 1,
    ACTIONS(2863), 1,
      aux_sym__liquid_node_token1,
  [29653] = 1,
    ACTIONS(2865), 1,
      anon_sym_endif,
  [29657] = 1,
    ACTIONS(2867), 1,
      aux_sym__liquid_node_token1,
  [29661] = 1,
    ACTIONS(2861), 1,
      aux_sym__liquid_node_token1,
  [29665] = 1,
    ACTIONS(1099), 1,
      aux_sym__liquid_node_token1,
  [29669] = 1,
    ACTIONS(2869), 1,
      sym__paired_comment_content_liq,
  [29673] = 1,
    ACTIONS(2871), 1,
      anon_sym_endif,
  [29677] = 1,
    ACTIONS(2873), 1,
      anon_sym_endcase,
  [29681] = 1,
    ACTIONS(2875), 1,
      anon_sym_endif,
  [29685] = 1,
    ACTIONS(2877), 1,
      sym_identifier,
  [29689] = 1,
    ACTIONS(2879), 1,
      anon_sym_endunless,
  [29693] = 1,
    ACTIONS(2881), 1,
      sym_identifier,
  [29697] = 1,
    ACTIONS(2883), 1,
      anon_sym_endraw,
  [29701] = 1,
    ACTIONS(2885), 1,
      anon_sym_endcomment,
  [29705] = 1,
    ACTIONS(2887), 1,
      aux_sym__liquid_node_token1,
  [29709] = 1,
    ACTIONS(2889), 1,
      anon_sym_endfor,
  [29713] = 1,
    ACTIONS(2891), 1,
      aux_sym__liquid_node_token1,
  [29717] = 1,
    ACTIONS(2893), 1,
      sym_identifier,
  [29721] = 1,
    ACTIONS(2895), 1,
      aux_sym_string_token2,
  [29725] = 1,
    ACTIONS(2897), 1,
      aux_sym_string_token1,
  [29729] = 1,
    ACTIONS(2187), 1,
      aux_sym__liquid_node_token1,
  [29733] = 1,
    ACTIONS(2899), 1,
      aux_sym__liquid_node_token1,
  [29737] = 1,
    ACTIONS(2901), 1,
      anon_sym_endif,
  [29741] = 1,
    ACTIONS(2903), 1,
      aux_sym__liquid_node_token1,
  [29745] = 1,
    ACTIONS(2905), 1,
      aux_sym__liquid_node_token1,
  [29749] = 1,
    ACTIONS(2907), 1,
      aux_sym__liquid_node_token1,
  [29753] = 1,
    ACTIONS(2909), 1,
      aux_sym__liquid_node_token1,
  [29757] = 1,
    ACTIONS(2911), 1,
      anon_sym_endunless,
  [29761] = 1,
    ACTIONS(2913), 1,
      aux_sym__liquid_node_token1,
  [29765] = 1,
    ACTIONS(2915), 1,
      aux_sym__liquid_node_token1,
  [29769] = 1,
    ACTIONS(2917), 1,
      aux_sym__liquid_node_token1,
  [29773] = 1,
    ACTIONS(2919), 1,
      aux_sym__liquid_node_token1,
  [29777] = 1,
    ACTIONS(2921), 1,
      sym_identifier,
  [29781] = 1,
    ACTIONS(2923), 1,
      aux_sym__liquid_node_token1,
  [29785] = 1,
    ACTIONS(2925), 1,
      anon_sym_endif,
  [29789] = 1,
    ACTIONS(2189), 1,
      aux_sym__liquid_node_token1,
  [29793] = 1,
    ACTIONS(2191), 1,
      aux_sym__liquid_node_token1,
  [29797] = 1,
    ACTIONS(2927), 1,
      anon_sym_endif,
  [29801] = 1,
    ACTIONS(2929), 1,
      anon_sym_endif,
  [29805] = 1,
    ACTIONS(2931), 1,
      anon_sym_endcase,
  [29809] = 1,
    ACTIONS(1828), 1,
      anon_sym_when,
  [29813] = 1,
    ACTIONS(2933), 1,
      sym_identifier,
  [29817] = 1,
    ACTIONS(2193), 1,
      aux_sym__liquid_node_token1,
  [29821] = 1,
    ACTIONS(2935), 1,
      anon_sym_endunless,
  [29825] = 1,
    ACTIONS(2937), 1,
      anon_sym_endunless,
  [29829] = 1,
    ACTIONS(2939), 1,
      sym_identifier,
  [29833] = 1,
    ACTIONS(677), 1,
      anon_sym_endcomment,
  [29837] = 1,
    ACTIONS(2941), 1,
      anon_sym_endunless,
  [29841] = 1,
    ACTIONS(2943), 1,
      sym_raw_content,
  [29845] = 1,
    ACTIONS(2945), 1,
      sym__paired_comment_content,
  [29849] = 1,
    ACTIONS(2947), 1,
      aux_sym_string_token2,
  [29853] = 1,
    ACTIONS(2949), 1,
      aux_sym__liquid_node_token1,
  [29857] = 1,
    ACTIONS(2951), 1,
      anon_sym_endfor,
  [29861] = 1,
    ACTIONS(2953), 1,
      aux_sym__liquid_node_token1,
  [29865] = 1,
    ACTIONS(2955), 1,
      sym_raw_content,
  [29869] = 1,
    ACTIONS(2957), 1,
      sym__paired_comment_content,
  [29873] = 1,
    ACTIONS(2959), 1,
      sym_identifier,
  [29877] = 1,
    ACTIONS(2961), 1,
      aux_sym__liquid_node_token1,
  [29881] = 1,
    ACTIONS(2023), 1,
      aux_sym__liquid_node_token1,
  [29885] = 1,
    ACTIONS(2963), 1,
      sym_identifier,
  [29889] = 1,
    ACTIONS(2965), 1,
      sym_identifier,
  [29893] = 1,
    ACTIONS(2967), 1,
      aux_sym__liquid_node_token1,
  [29897] = 1,
    ACTIONS(2969), 1,
      aux_sym__liquid_node_token1,
  [29901] = 1,
    ACTIONS(2971), 1,
      aux_sym__liquid_node_token1,
  [29905] = 1,
    ACTIONS(2973), 1,
      sym_identifier,
  [29909] = 1,
    ACTIONS(2387), 1,
      aux_sym__liquid_node_token1,
  [29913] = 1,
    ACTIONS(1883), 1,
      anon_sym_RPAREN,
  [29917] = 1,
    ACTIONS(2381), 1,
      aux_sym__liquid_node_token1,
  [29921] = 1,
    ACTIONS(2975), 1,
      anon_sym_endfor,
  [29925] = 1,
    ACTIONS(2977), 1,
      anon_sym_endfor,
  [29929] = 1,
    ACTIONS(2979), 1,
      anon_sym_in,
  [29933] = 1,
    ACTIONS(2981), 1,
      anon_sym_in,
  [29937] = 1,
    ACTIONS(2379), 1,
      aux_sym__liquid_node_token1,
  [29941] = 1,
    ACTIONS(2983), 1,
      sym_identifier,
  [29945] = 1,
    ACTIONS(2985), 1,
      sym_identifier,
  [29949] = 1,
    ACTIONS(2987), 1,
      anon_sym_endfor,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(12)] = 0,
  [SMALL_STATE(13)] = 144,
  [SMALL_STATE(14)] = 292,
  [SMALL_STATE(15)] = 440,
  [SMALL_STATE(16)] = 584,
  [SMALL_STATE(17)] = 734,
  [SMALL_STATE(18)] = 878,
  [SMALL_STATE(19)] = 1021,
  [SMALL_STATE(20)] = 1164,
  [SMALL_STATE(21)] = 1238,
  [SMALL_STATE(22)] = 1382,
  [SMALL_STATE(23)] = 1454,
  [SMALL_STATE(24)] = 1595,
  [SMALL_STATE(25)] = 1736,
  [SMALL_STATE(26)] = 1805,
  [SMALL_STATE(27)] = 1874,
  [SMALL_STATE(28)] = 2015,
  [SMALL_STATE(29)] = 2156,
  [SMALL_STATE(30)] = 2297,
  [SMALL_STATE(31)] = 2438,
  [SMALL_STATE(32)] = 2503,
  [SMALL_STATE(33)] = 2568,
  [SMALL_STATE(34)] = 2709,
  [SMALL_STATE(35)] = 2850,
  [SMALL_STATE(36)] = 2991,
  [SMALL_STATE(37)] = 3059,
  [SMALL_STATE(38)] = 3127,
  [SMALL_STATE(39)] = 3195,
  [SMALL_STATE(40)] = 3269,
  [SMALL_STATE(41)] = 3332,
  [SMALL_STATE(42)] = 3395,
  [SMALL_STATE(43)] = 3458,
  [SMALL_STATE(44)] = 3521,
  [SMALL_STATE(45)] = 3585,
  [SMALL_STATE(46)] = 3646,
  [SMALL_STATE(47)] = 3704,
  [SMALL_STATE(48)] = 3778,
  [SMALL_STATE(49)] = 3850,
  [SMALL_STATE(50)] = 3918,
  [SMALL_STATE(51)] = 3976,
  [SMALL_STATE(52)] = 4034,
  [SMALL_STATE(53)] = 4106,
  [SMALL_STATE(54)] = 4166,
  [SMALL_STATE(55)] = 4230,
  [SMALL_STATE(56)] = 4299,
  [SMALL_STATE(57)] = 4362,
  [SMALL_STATE(58)] = 4473,
  [SMALL_STATE(59)] = 4584,
  [SMALL_STATE(60)] = 4695,
  [SMALL_STATE(61)] = 4806,
  [SMALL_STATE(62)] = 4917,
  [SMALL_STATE(63)] = 5028,
  [SMALL_STATE(64)] = 5139,
  [SMALL_STATE(65)] = 5250,
  [SMALL_STATE(66)] = 5358,
  [SMALL_STATE(67)] = 5466,
  [SMALL_STATE(68)] = 5574,
  [SMALL_STATE(69)] = 5682,
  [SMALL_STATE(70)] = 5790,
  [SMALL_STATE(71)] = 5898,
  [SMALL_STATE(72)] = 6006,
  [SMALL_STATE(73)] = 6114,
  [SMALL_STATE(74)] = 6222,
  [SMALL_STATE(75)] = 6330,
  [SMALL_STATE(76)] = 6438,
  [SMALL_STATE(77)] = 6546,
  [SMALL_STATE(78)] = 6654,
  [SMALL_STATE(79)] = 6762,
  [SMALL_STATE(80)] = 6870,
  [SMALL_STATE(81)] = 6978,
  [SMALL_STATE(82)] = 7083,
  [SMALL_STATE(83)] = 7188,
  [SMALL_STATE(84)] = 7293,
  [SMALL_STATE(85)] = 7398,
  [SMALL_STATE(86)] = 7503,
  [SMALL_STATE(87)] = 7608,
  [SMALL_STATE(88)] = 7713,
  [SMALL_STATE(89)] = 7818,
  [SMALL_STATE(90)] = 7923,
  [SMALL_STATE(91)] = 8028,
  [SMALL_STATE(92)] = 8133,
  [SMALL_STATE(93)] = 8238,
  [SMALL_STATE(94)] = 8343,
  [SMALL_STATE(95)] = 8448,
  [SMALL_STATE(96)] = 8553,
  [SMALL_STATE(97)] = 8658,
  [SMALL_STATE(98)] = 8763,
  [SMALL_STATE(99)] = 8868,
  [SMALL_STATE(100)] = 8973,
  [SMALL_STATE(101)] = 9078,
  [SMALL_STATE(102)] = 9183,
  [SMALL_STATE(103)] = 9288,
  [SMALL_STATE(104)] = 9393,
  [SMALL_STATE(105)] = 9498,
  [SMALL_STATE(106)] = 9603,
  [SMALL_STATE(107)] = 9708,
  [SMALL_STATE(108)] = 9813,
  [SMALL_STATE(109)] = 9918,
  [SMALL_STATE(110)] = 10023,
  [SMALL_STATE(111)] = 10128,
  [SMALL_STATE(112)] = 10233,
  [SMALL_STATE(113)] = 10338,
  [SMALL_STATE(114)] = 10443,
  [SMALL_STATE(115)] = 10548,
  [SMALL_STATE(116)] = 10653,
  [SMALL_STATE(117)] = 10758,
  [SMALL_STATE(118)] = 10863,
  [SMALL_STATE(119)] = 10968,
  [SMALL_STATE(120)] = 11073,
  [SMALL_STATE(121)] = 11178,
  [SMALL_STATE(122)] = 11283,
  [SMALL_STATE(123)] = 11388,
  [SMALL_STATE(124)] = 11493,
  [SMALL_STATE(125)] = 11598,
  [SMALL_STATE(126)] = 11703,
  [SMALL_STATE(127)] = 11808,
  [SMALL_STATE(128)] = 11913,
  [SMALL_STATE(129)] = 12018,
  [SMALL_STATE(130)] = 12123,
  [SMALL_STATE(131)] = 12228,
  [SMALL_STATE(132)] = 12333,
  [SMALL_STATE(133)] = 12438,
  [SMALL_STATE(134)] = 12540,
  [SMALL_STATE(135)] = 12642,
  [SMALL_STATE(136)] = 12687,
  [SMALL_STATE(137)] = 12732,
  [SMALL_STATE(138)] = 12787,
  [SMALL_STATE(139)] = 12836,
  [SMALL_STATE(140)] = 12898,
  [SMALL_STATE(141)] = 12948,
  [SMALL_STATE(142)] = 12987,
  [SMALL_STATE(143)] = 13026,
  [SMALL_STATE(144)] = 13082,
  [SMALL_STATE(145)] = 13120,
  [SMALL_STATE(146)] = 13176,
  [SMALL_STATE(147)] = 13232,
  [SMALL_STATE(148)] = 13270,
  [SMALL_STATE(149)] = 13326,
  [SMALL_STATE(150)] = 13382,
  [SMALL_STATE(151)] = 13438,
  [SMALL_STATE(152)] = 13476,
  [SMALL_STATE(153)] = 13532,
  [SMALL_STATE(154)] = 13576,
  [SMALL_STATE(155)] = 13632,
  [SMALL_STATE(156)] = 13670,
  [SMALL_STATE(157)] = 13707,
  [SMALL_STATE(158)] = 13757,
  [SMALL_STATE(159)] = 13807,
  [SMALL_STATE(160)] = 13857,
  [SMALL_STATE(161)] = 13909,
  [SMALL_STATE(162)] = 13961,
  [SMALL_STATE(163)] = 13999,
  [SMALL_STATE(164)] = 14049,
  [SMALL_STATE(165)] = 14101,
  [SMALL_STATE(166)] = 14153,
  [SMALL_STATE(167)] = 14205,
  [SMALL_STATE(168)] = 14257,
  [SMALL_STATE(169)] = 14309,
  [SMALL_STATE(170)] = 14361,
  [SMALL_STATE(171)] = 14408,
  [SMALL_STATE(172)] = 14453,
  [SMALL_STATE(173)] = 14502,
  [SMALL_STATE(174)] = 14549,
  [SMALL_STATE(175)] = 14598,
  [SMALL_STATE(176)] = 14647,
  [SMALL_STATE(177)] = 14694,
  [SMALL_STATE(178)] = 14729,
  [SMALL_STATE(179)] = 14778,
  [SMALL_STATE(180)] = 14825,
  [SMALL_STATE(181)] = 14874,
  [SMALL_STATE(182)] = 14923,
  [SMALL_STATE(183)] = 14972,
  [SMALL_STATE(184)] = 15021,
  [SMALL_STATE(185)] = 15068,
  [SMALL_STATE(186)] = 15115,
  [SMALL_STATE(187)] = 15164,
  [SMALL_STATE(188)] = 15213,
  [SMALL_STATE(189)] = 15262,
  [SMALL_STATE(190)] = 15309,
  [SMALL_STATE(191)] = 15356,
  [SMALL_STATE(192)] = 15403,
  [SMALL_STATE(193)] = 15450,
  [SMALL_STATE(194)] = 15497,
  [SMALL_STATE(195)] = 15546,
  [SMALL_STATE(196)] = 15593,
  [SMALL_STATE(197)] = 15640,
  [SMALL_STATE(198)] = 15689,
  [SMALL_STATE(199)] = 15736,
  [SMALL_STATE(200)] = 15783,
  [SMALL_STATE(201)] = 15830,
  [SMALL_STATE(202)] = 15877,
  [SMALL_STATE(203)] = 15924,
  [SMALL_STATE(204)] = 15959,
  [SMALL_STATE(205)] = 16008,
  [SMALL_STATE(206)] = 16057,
  [SMALL_STATE(207)] = 16104,
  [SMALL_STATE(208)] = 16153,
  [SMALL_STATE(209)] = 16193,
  [SMALL_STATE(210)] = 16239,
  [SMALL_STATE(211)] = 16281,
  [SMALL_STATE(212)] = 16327,
  [SMALL_STATE(213)] = 16373,
  [SMALL_STATE(214)] = 16419,
  [SMALL_STATE(215)] = 16465,
  [SMALL_STATE(216)] = 16511,
  [SMALL_STATE(217)] = 16557,
  [SMALL_STATE(218)] = 16603,
  [SMALL_STATE(219)] = 16649,
  [SMALL_STATE(220)] = 16695,
  [SMALL_STATE(221)] = 16732,
  [SMALL_STATE(222)] = 16769,
  [SMALL_STATE(223)] = 16802,
  [SMALL_STATE(224)] = 16835,
  [SMALL_STATE(225)] = 16871,
  [SMALL_STATE(226)] = 16907,
  [SMALL_STATE(227)] = 16943,
  [SMALL_STATE(228)] = 16979,
  [SMALL_STATE(229)] = 17020,
  [SMALL_STATE(230)] = 17071,
  [SMALL_STATE(231)] = 17102,
  [SMALL_STATE(232)] = 17133,
  [SMALL_STATE(233)] = 17164,
  [SMALL_STATE(234)] = 17195,
  [SMALL_STATE(235)] = 17226,
  [SMALL_STATE(236)] = 17259,
  [SMALL_STATE(237)] = 17293,
  [SMALL_STATE(238)] = 17329,
  [SMALL_STATE(239)] = 17369,
  [SMALL_STATE(240)] = 17407,
  [SMALL_STATE(241)] = 17437,
  [SMALL_STATE(242)] = 17467,
  [SMALL_STATE(243)] = 17503,
  [SMALL_STATE(244)] = 17533,
  [SMALL_STATE(245)] = 17577,
  [SMALL_STATE(246)] = 17609,
  [SMALL_STATE(247)] = 17647,
  [SMALL_STATE(248)] = 17680,
  [SMALL_STATE(249)] = 17713,
  [SMALL_STATE(250)] = 17745,
  [SMALL_STATE(251)] = 17777,
  [SMALL_STATE(252)] = 17809,
  [SMALL_STATE(253)] = 17849,
  [SMALL_STATE(254)] = 17881,
  [SMALL_STATE(255)] = 17919,
  [SMALL_STATE(256)] = 17946,
  [SMALL_STATE(257)] = 17973,
  [SMALL_STATE(258)] = 18006,
  [SMALL_STATE(259)] = 18033,
  [SMALL_STATE(260)] = 18062,
  [SMALL_STATE(261)] = 18089,
  [SMALL_STATE(262)] = 18126,
  [SMALL_STATE(263)] = 18161,
  [SMALL_STATE(264)] = 18191,
  [SMALL_STATE(265)] = 18217,
  [SMALL_STATE(266)] = 18243,
  [SMALL_STATE(267)] = 18269,
  [SMALL_STATE(268)] = 18311,
  [SMALL_STATE(269)] = 18337,
  [SMALL_STATE(270)] = 18377,
  [SMALL_STATE(271)] = 18413,
  [SMALL_STATE(272)] = 18439,
  [SMALL_STATE(273)] = 18467,
  [SMALL_STATE(274)] = 18497,
  [SMALL_STATE(275)] = 18529,
  [SMALL_STATE(276)] = 18558,
  [SMALL_STATE(277)] = 18587,
  [SMALL_STATE(278)] = 18616,
  [SMALL_STATE(279)] = 18645,
  [SMALL_STATE(280)] = 18676,
  [SMALL_STATE(281)] = 18702,
  [SMALL_STATE(282)] = 18726,
  [SMALL_STATE(283)] = 18750,
  [SMALL_STATE(284)] = 18774,
  [SMALL_STATE(285)] = 18818,
  [SMALL_STATE(286)] = 18857,
  [SMALL_STATE(287)] = 18896,
  [SMALL_STATE(288)] = 18937,
  [SMALL_STATE(289)] = 18978,
  [SMALL_STATE(290)] = 19005,
  [SMALL_STATE(291)] = 19044,
  [SMALL_STATE(292)] = 19085,
  [SMALL_STATE(293)] = 19126,
  [SMALL_STATE(294)] = 19159,
  [SMALL_STATE(295)] = 19198,
  [SMALL_STATE(296)] = 19229,
  [SMALL_STATE(297)] = 19270,
  [SMALL_STATE(298)] = 19311,
  [SMALL_STATE(299)] = 19352,
  [SMALL_STATE(300)] = 19389,
  [SMALL_STATE(301)] = 19428,
  [SMALL_STATE(302)] = 19457,
  [SMALL_STATE(303)] = 19480,
  [SMALL_STATE(304)] = 19519,
  [SMALL_STATE(305)] = 19560,
  [SMALL_STATE(306)] = 19599,
  [SMALL_STATE(307)] = 19624,
  [SMALL_STATE(308)] = 19647,
  [SMALL_STATE(309)] = 19686,
  [SMALL_STATE(310)] = 19727,
  [SMALL_STATE(311)] = 19768,
  [SMALL_STATE(312)] = 19793,
  [SMALL_STATE(313)] = 19816,
  [SMALL_STATE(314)] = 19850,
  [SMALL_STATE(315)] = 19888,
  [SMALL_STATE(316)] = 19932,
  [SMALL_STATE(317)] = 19966,
  [SMALL_STATE(318)] = 20000,
  [SMALL_STATE(319)] = 20034,
  [SMALL_STATE(320)] = 20078,
  [SMALL_STATE(321)] = 20116,
  [SMALL_STATE(322)] = 20155,
  [SMALL_STATE(323)] = 20188,
  [SMALL_STATE(324)] = 20221,
  [SMALL_STATE(325)] = 20255,
  [SMALL_STATE(326)] = 20289,
  [SMALL_STATE(327)] = 20323,
  [SMALL_STATE(328)] = 20357,
  [SMALL_STATE(329)] = 20391,
  [SMALL_STATE(330)] = 20425,
  [SMALL_STATE(331)] = 20459,
  [SMALL_STATE(332)] = 20493,
  [SMALL_STATE(333)] = 20527,
  [SMALL_STATE(334)] = 20561,
  [SMALL_STATE(335)] = 20595,
  [SMALL_STATE(336)] = 20629,
  [SMALL_STATE(337)] = 20663,
  [SMALL_STATE(338)] = 20697,
  [SMALL_STATE(339)] = 20731,
  [SMALL_STATE(340)] = 20765,
  [SMALL_STATE(341)] = 20799,
  [SMALL_STATE(342)] = 20833,
  [SMALL_STATE(343)] = 20867,
  [SMALL_STATE(344)] = 20901,
  [SMALL_STATE(345)] = 20935,
  [SMALL_STATE(346)] = 20969,
  [SMALL_STATE(347)] = 21003,
  [SMALL_STATE(348)] = 21037,
  [SMALL_STATE(349)] = 21071,
  [SMALL_STATE(350)] = 21105,
  [SMALL_STATE(351)] = 21139,
  [SMALL_STATE(352)] = 21173,
  [SMALL_STATE(353)] = 21207,
  [SMALL_STATE(354)] = 21241,
  [SMALL_STATE(355)] = 21275,
  [SMALL_STATE(356)] = 21309,
  [SMALL_STATE(357)] = 21343,
  [SMALL_STATE(358)] = 21377,
  [SMALL_STATE(359)] = 21411,
  [SMALL_STATE(360)] = 21445,
  [SMALL_STATE(361)] = 21479,
  [SMALL_STATE(362)] = 21513,
  [SMALL_STATE(363)] = 21547,
  [SMALL_STATE(364)] = 21581,
  [SMALL_STATE(365)] = 21615,
  [SMALL_STATE(366)] = 21649,
  [SMALL_STATE(367)] = 21683,
  [SMALL_STATE(368)] = 21717,
  [SMALL_STATE(369)] = 21751,
  [SMALL_STATE(370)] = 21785,
  [SMALL_STATE(371)] = 21818,
  [SMALL_STATE(372)] = 21847,
  [SMALL_STATE(373)] = 21876,
  [SMALL_STATE(374)] = 21905,
  [SMALL_STATE(375)] = 21934,
  [SMALL_STATE(376)] = 21963,
  [SMALL_STATE(377)] = 21992,
  [SMALL_STATE(378)] = 22021,
  [SMALL_STATE(379)] = 22050,
  [SMALL_STATE(380)] = 22079,
  [SMALL_STATE(381)] = 22108,
  [SMALL_STATE(382)] = 22137,
  [SMALL_STATE(383)] = 22163,
  [SMALL_STATE(384)] = 22189,
  [SMALL_STATE(385)] = 22215,
  [SMALL_STATE(386)] = 22241,
  [SMALL_STATE(387)] = 22267,
  [SMALL_STATE(388)] = 22292,
  [SMALL_STATE(389)] = 22317,
  [SMALL_STATE(390)] = 22342,
  [SMALL_STATE(391)] = 22367,
  [SMALL_STATE(392)] = 22392,
  [SMALL_STATE(393)] = 22421,
  [SMALL_STATE(394)] = 22441,
  [SMALL_STATE(395)] = 22461,
  [SMALL_STATE(396)] = 22474,
  [SMALL_STATE(397)] = 22487,
  [SMALL_STATE(398)] = 22510,
  [SMALL_STATE(399)] = 22533,
  [SMALL_STATE(400)] = 22556,
  [SMALL_STATE(401)] = 22579,
  [SMALL_STATE(402)] = 22602,
  [SMALL_STATE(403)] = 22615,
  [SMALL_STATE(404)] = 22628,
  [SMALL_STATE(405)] = 22641,
  [SMALL_STATE(406)] = 22654,
  [SMALL_STATE(407)] = 22671,
  [SMALL_STATE(408)] = 22688,
  [SMALL_STATE(409)] = 22701,
  [SMALL_STATE(410)] = 22714,
  [SMALL_STATE(411)] = 22727,
  [SMALL_STATE(412)] = 22740,
  [SMALL_STATE(413)] = 22753,
  [SMALL_STATE(414)] = 22766,
  [SMALL_STATE(415)] = 22779,
  [SMALL_STATE(416)] = 22792,
  [SMALL_STATE(417)] = 22805,
  [SMALL_STATE(418)] = 22818,
  [SMALL_STATE(419)] = 22831,
  [SMALL_STATE(420)] = 22844,
  [SMALL_STATE(421)] = 22857,
  [SMALL_STATE(422)] = 22870,
  [SMALL_STATE(423)] = 22883,
  [SMALL_STATE(424)] = 22896,
  [SMALL_STATE(425)] = 22909,
  [SMALL_STATE(426)] = 22922,
  [SMALL_STATE(427)] = 22935,
  [SMALL_STATE(428)] = 22948,
  [SMALL_STATE(429)] = 22961,
  [SMALL_STATE(430)] = 22974,
  [SMALL_STATE(431)] = 22987,
  [SMALL_STATE(432)] = 23000,
  [SMALL_STATE(433)] = 23013,
  [SMALL_STATE(434)] = 23026,
  [SMALL_STATE(435)] = 23039,
  [SMALL_STATE(436)] = 23052,
  [SMALL_STATE(437)] = 23065,
  [SMALL_STATE(438)] = 23078,
  [SMALL_STATE(439)] = 23091,
  [SMALL_STATE(440)] = 23104,
  [SMALL_STATE(441)] = 23117,
  [SMALL_STATE(442)] = 23130,
  [SMALL_STATE(443)] = 23143,
  [SMALL_STATE(444)] = 23156,
  [SMALL_STATE(445)] = 23169,
  [SMALL_STATE(446)] = 23182,
  [SMALL_STATE(447)] = 23195,
  [SMALL_STATE(448)] = 23208,
  [SMALL_STATE(449)] = 23221,
  [SMALL_STATE(450)] = 23234,
  [SMALL_STATE(451)] = 23247,
  [SMALL_STATE(452)] = 23260,
  [SMALL_STATE(453)] = 23273,
  [SMALL_STATE(454)] = 23286,
  [SMALL_STATE(455)] = 23299,
  [SMALL_STATE(456)] = 23312,
  [SMALL_STATE(457)] = 23325,
  [SMALL_STATE(458)] = 23338,
  [SMALL_STATE(459)] = 23351,
  [SMALL_STATE(460)] = 23364,
  [SMALL_STATE(461)] = 23377,
  [SMALL_STATE(462)] = 23390,
  [SMALL_STATE(463)] = 23403,
  [SMALL_STATE(464)] = 23416,
  [SMALL_STATE(465)] = 23429,
  [SMALL_STATE(466)] = 23442,
  [SMALL_STATE(467)] = 23455,
  [SMALL_STATE(468)] = 23468,
  [SMALL_STATE(469)] = 23481,
  [SMALL_STATE(470)] = 23494,
  [SMALL_STATE(471)] = 23507,
  [SMALL_STATE(472)] = 23520,
  [SMALL_STATE(473)] = 23533,
  [SMALL_STATE(474)] = 23546,
  [SMALL_STATE(475)] = 23559,
  [SMALL_STATE(476)] = 23572,
  [SMALL_STATE(477)] = 23585,
  [SMALL_STATE(478)] = 23598,
  [SMALL_STATE(479)] = 23611,
  [SMALL_STATE(480)] = 23624,
  [SMALL_STATE(481)] = 23637,
  [SMALL_STATE(482)] = 23650,
  [SMALL_STATE(483)] = 23663,
  [SMALL_STATE(484)] = 23676,
  [SMALL_STATE(485)] = 23689,
  [SMALL_STATE(486)] = 23702,
  [SMALL_STATE(487)] = 23715,
  [SMALL_STATE(488)] = 23728,
  [SMALL_STATE(489)] = 23741,
  [SMALL_STATE(490)] = 23754,
  [SMALL_STATE(491)] = 23767,
  [SMALL_STATE(492)] = 23780,
  [SMALL_STATE(493)] = 23793,
  [SMALL_STATE(494)] = 23806,
  [SMALL_STATE(495)] = 23819,
  [SMALL_STATE(496)] = 23832,
  [SMALL_STATE(497)] = 23845,
  [SMALL_STATE(498)] = 23858,
  [SMALL_STATE(499)] = 23871,
  [SMALL_STATE(500)] = 23884,
  [SMALL_STATE(501)] = 23897,
  [SMALL_STATE(502)] = 23910,
  [SMALL_STATE(503)] = 23923,
  [SMALL_STATE(504)] = 23936,
  [SMALL_STATE(505)] = 23949,
  [SMALL_STATE(506)] = 23962,
  [SMALL_STATE(507)] = 23975,
  [SMALL_STATE(508)] = 23988,
  [SMALL_STATE(509)] = 24001,
  [SMALL_STATE(510)] = 24014,
  [SMALL_STATE(511)] = 24027,
  [SMALL_STATE(512)] = 24040,
  [SMALL_STATE(513)] = 24053,
  [SMALL_STATE(514)] = 24066,
  [SMALL_STATE(515)] = 24079,
  [SMALL_STATE(516)] = 24092,
  [SMALL_STATE(517)] = 24105,
  [SMALL_STATE(518)] = 24118,
  [SMALL_STATE(519)] = 24131,
  [SMALL_STATE(520)] = 24144,
  [SMALL_STATE(521)] = 24157,
  [SMALL_STATE(522)] = 24170,
  [SMALL_STATE(523)] = 24183,
  [SMALL_STATE(524)] = 24196,
  [SMALL_STATE(525)] = 24209,
  [SMALL_STATE(526)] = 24222,
  [SMALL_STATE(527)] = 24235,
  [SMALL_STATE(528)] = 24248,
  [SMALL_STATE(529)] = 24261,
  [SMALL_STATE(530)] = 24274,
  [SMALL_STATE(531)] = 24286,
  [SMALL_STATE(532)] = 24306,
  [SMALL_STATE(533)] = 24318,
  [SMALL_STATE(534)] = 24330,
  [SMALL_STATE(535)] = 24342,
  [SMALL_STATE(536)] = 24354,
  [SMALL_STATE(537)] = 24366,
  [SMALL_STATE(538)] = 24378,
  [SMALL_STATE(539)] = 24390,
  [SMALL_STATE(540)] = 24402,
  [SMALL_STATE(541)] = 24414,
  [SMALL_STATE(542)] = 24426,
  [SMALL_STATE(543)] = 24438,
  [SMALL_STATE(544)] = 24450,
  [SMALL_STATE(545)] = 24462,
  [SMALL_STATE(546)] = 24474,
  [SMALL_STATE(547)] = 24494,
  [SMALL_STATE(548)] = 24506,
  [SMALL_STATE(549)] = 24518,
  [SMALL_STATE(550)] = 24530,
  [SMALL_STATE(551)] = 24542,
  [SMALL_STATE(552)] = 24554,
  [SMALL_STATE(553)] = 24566,
  [SMALL_STATE(554)] = 24578,
  [SMALL_STATE(555)] = 24590,
  [SMALL_STATE(556)] = 24602,
  [SMALL_STATE(557)] = 24614,
  [SMALL_STATE(558)] = 24626,
  [SMALL_STATE(559)] = 24638,
  [SMALL_STATE(560)] = 24650,
  [SMALL_STATE(561)] = 24662,
  [SMALL_STATE(562)] = 24674,
  [SMALL_STATE(563)] = 24686,
  [SMALL_STATE(564)] = 24698,
  [SMALL_STATE(565)] = 24710,
  [SMALL_STATE(566)] = 24728,
  [SMALL_STATE(567)] = 24740,
  [SMALL_STATE(568)] = 24752,
  [SMALL_STATE(569)] = 24764,
  [SMALL_STATE(570)] = 24776,
  [SMALL_STATE(571)] = 24788,
  [SMALL_STATE(572)] = 24800,
  [SMALL_STATE(573)] = 24812,
  [SMALL_STATE(574)] = 24824,
  [SMALL_STATE(575)] = 24836,
  [SMALL_STATE(576)] = 24848,
  [SMALL_STATE(577)] = 24860,
  [SMALL_STATE(578)] = 24872,
  [SMALL_STATE(579)] = 24884,
  [SMALL_STATE(580)] = 24896,
  [SMALL_STATE(581)] = 24908,
  [SMALL_STATE(582)] = 24920,
  [SMALL_STATE(583)] = 24932,
  [SMALL_STATE(584)] = 24944,
  [SMALL_STATE(585)] = 24956,
  [SMALL_STATE(586)] = 24968,
  [SMALL_STATE(587)] = 24980,
  [SMALL_STATE(588)] = 24992,
  [SMALL_STATE(589)] = 25004,
  [SMALL_STATE(590)] = 25016,
  [SMALL_STATE(591)] = 25028,
  [SMALL_STATE(592)] = 25040,
  [SMALL_STATE(593)] = 25052,
  [SMALL_STATE(594)] = 25064,
  [SMALL_STATE(595)] = 25076,
  [SMALL_STATE(596)] = 25088,
  [SMALL_STATE(597)] = 25100,
  [SMALL_STATE(598)] = 25112,
  [SMALL_STATE(599)] = 25124,
  [SMALL_STATE(600)] = 25136,
  [SMALL_STATE(601)] = 25148,
  [SMALL_STATE(602)] = 25160,
  [SMALL_STATE(603)] = 25172,
  [SMALL_STATE(604)] = 25184,
  [SMALL_STATE(605)] = 25196,
  [SMALL_STATE(606)] = 25208,
  [SMALL_STATE(607)] = 25220,
  [SMALL_STATE(608)] = 25232,
  [SMALL_STATE(609)] = 25244,
  [SMALL_STATE(610)] = 25256,
  [SMALL_STATE(611)] = 25268,
  [SMALL_STATE(612)] = 25280,
  [SMALL_STATE(613)] = 25292,
  [SMALL_STATE(614)] = 25304,
  [SMALL_STATE(615)] = 25316,
  [SMALL_STATE(616)] = 25328,
  [SMALL_STATE(617)] = 25340,
  [SMALL_STATE(618)] = 25352,
  [SMALL_STATE(619)] = 25364,
  [SMALL_STATE(620)] = 25376,
  [SMALL_STATE(621)] = 25388,
  [SMALL_STATE(622)] = 25400,
  [SMALL_STATE(623)] = 25412,
  [SMALL_STATE(624)] = 25424,
  [SMALL_STATE(625)] = 25436,
  [SMALL_STATE(626)] = 25448,
  [SMALL_STATE(627)] = 25460,
  [SMALL_STATE(628)] = 25472,
  [SMALL_STATE(629)] = 25484,
  [SMALL_STATE(630)] = 25496,
  [SMALL_STATE(631)] = 25508,
  [SMALL_STATE(632)] = 25520,
  [SMALL_STATE(633)] = 25532,
  [SMALL_STATE(634)] = 25544,
  [SMALL_STATE(635)] = 25556,
  [SMALL_STATE(636)] = 25568,
  [SMALL_STATE(637)] = 25580,
  [SMALL_STATE(638)] = 25592,
  [SMALL_STATE(639)] = 25604,
  [SMALL_STATE(640)] = 25616,
  [SMALL_STATE(641)] = 25628,
  [SMALL_STATE(642)] = 25640,
  [SMALL_STATE(643)] = 25652,
  [SMALL_STATE(644)] = 25664,
  [SMALL_STATE(645)] = 25676,
  [SMALL_STATE(646)] = 25696,
  [SMALL_STATE(647)] = 25708,
  [SMALL_STATE(648)] = 25720,
  [SMALL_STATE(649)] = 25732,
  [SMALL_STATE(650)] = 25744,
  [SMALL_STATE(651)] = 25756,
  [SMALL_STATE(652)] = 25768,
  [SMALL_STATE(653)] = 25780,
  [SMALL_STATE(654)] = 25792,
  [SMALL_STATE(655)] = 25804,
  [SMALL_STATE(656)] = 25816,
  [SMALL_STATE(657)] = 25828,
  [SMALL_STATE(658)] = 25840,
  [SMALL_STATE(659)] = 25852,
  [SMALL_STATE(660)] = 25864,
  [SMALL_STATE(661)] = 25876,
  [SMALL_STATE(662)] = 25888,
  [SMALL_STATE(663)] = 25900,
  [SMALL_STATE(664)] = 25912,
  [SMALL_STATE(665)] = 25931,
  [SMALL_STATE(666)] = 25950,
  [SMALL_STATE(667)] = 25965,
  [SMALL_STATE(668)] = 25980,
  [SMALL_STATE(669)] = 25997,
  [SMALL_STATE(670)] = 26016,
  [SMALL_STATE(671)] = 26035,
  [SMALL_STATE(672)] = 26054,
  [SMALL_STATE(673)] = 26073,
  [SMALL_STATE(674)] = 26090,
  [SMALL_STATE(675)] = 26109,
  [SMALL_STATE(676)] = 26128,
  [SMALL_STATE(677)] = 26145,
  [SMALL_STATE(678)] = 26162,
  [SMALL_STATE(679)] = 26178,
  [SMALL_STATE(680)] = 26194,
  [SMALL_STATE(681)] = 26210,
  [SMALL_STATE(682)] = 26226,
  [SMALL_STATE(683)] = 26238,
  [SMALL_STATE(684)] = 26254,
  [SMALL_STATE(685)] = 26268,
  [SMALL_STATE(686)] = 26280,
  [SMALL_STATE(687)] = 26296,
  [SMALL_STATE(688)] = 26308,
  [SMALL_STATE(689)] = 26324,
  [SMALL_STATE(690)] = 26340,
  [SMALL_STATE(691)] = 26352,
  [SMALL_STATE(692)] = 26366,
  [SMALL_STATE(693)] = 26382,
  [SMALL_STATE(694)] = 26394,
  [SMALL_STATE(695)] = 26410,
  [SMALL_STATE(696)] = 26422,
  [SMALL_STATE(697)] = 26436,
  [SMALL_STATE(698)] = 26452,
  [SMALL_STATE(699)] = 26468,
  [SMALL_STATE(700)] = 26484,
  [SMALL_STATE(701)] = 26500,
  [SMALL_STATE(702)] = 26514,
  [SMALL_STATE(703)] = 26530,
  [SMALL_STATE(704)] = 26546,
  [SMALL_STATE(705)] = 26562,
  [SMALL_STATE(706)] = 26578,
  [SMALL_STATE(707)] = 26590,
  [SMALL_STATE(708)] = 26606,
  [SMALL_STATE(709)] = 26622,
  [SMALL_STATE(710)] = 26638,
  [SMALL_STATE(711)] = 26650,
  [SMALL_STATE(712)] = 26666,
  [SMALL_STATE(713)] = 26682,
  [SMALL_STATE(714)] = 26696,
  [SMALL_STATE(715)] = 26710,
  [SMALL_STATE(716)] = 26724,
  [SMALL_STATE(717)] = 26735,
  [SMALL_STATE(718)] = 26746,
  [SMALL_STATE(719)] = 26759,
  [SMALL_STATE(720)] = 26772,
  [SMALL_STATE(721)] = 26783,
  [SMALL_STATE(722)] = 26794,
  [SMALL_STATE(723)] = 26805,
  [SMALL_STATE(724)] = 26818,
  [SMALL_STATE(725)] = 26831,
  [SMALL_STATE(726)] = 26842,
  [SMALL_STATE(727)] = 26853,
  [SMALL_STATE(728)] = 26864,
  [SMALL_STATE(729)] = 26877,
  [SMALL_STATE(730)] = 26888,
  [SMALL_STATE(731)] = 26899,
  [SMALL_STATE(732)] = 26912,
  [SMALL_STATE(733)] = 26923,
  [SMALL_STATE(734)] = 26934,
  [SMALL_STATE(735)] = 26947,
  [SMALL_STATE(736)] = 26960,
  [SMALL_STATE(737)] = 26971,
  [SMALL_STATE(738)] = 26984,
  [SMALL_STATE(739)] = 26997,
  [SMALL_STATE(740)] = 27004,
  [SMALL_STATE(741)] = 27011,
  [SMALL_STATE(742)] = 27022,
  [SMALL_STATE(743)] = 27035,
  [SMALL_STATE(744)] = 27048,
  [SMALL_STATE(745)] = 27061,
  [SMALL_STATE(746)] = 27072,
  [SMALL_STATE(747)] = 27085,
  [SMALL_STATE(748)] = 27096,
  [SMALL_STATE(749)] = 27107,
  [SMALL_STATE(750)] = 27118,
  [SMALL_STATE(751)] = 27128,
  [SMALL_STATE(752)] = 27136,
  [SMALL_STATE(753)] = 27146,
  [SMALL_STATE(754)] = 27154,
  [SMALL_STATE(755)] = 27164,
  [SMALL_STATE(756)] = 27174,
  [SMALL_STATE(757)] = 27184,
  [SMALL_STATE(758)] = 27194,
  [SMALL_STATE(759)] = 27204,
  [SMALL_STATE(760)] = 27214,
  [SMALL_STATE(761)] = 27224,
  [SMALL_STATE(762)] = 27234,
  [SMALL_STATE(763)] = 27244,
  [SMALL_STATE(764)] = 27254,
  [SMALL_STATE(765)] = 27264,
  [SMALL_STATE(766)] = 27274,
  [SMALL_STATE(767)] = 27284,
  [SMALL_STATE(768)] = 27294,
  [SMALL_STATE(769)] = 27304,
  [SMALL_STATE(770)] = 27310,
  [SMALL_STATE(771)] = 27316,
  [SMALL_STATE(772)] = 27326,
  [SMALL_STATE(773)] = 27336,
  [SMALL_STATE(774)] = 27346,
  [SMALL_STATE(775)] = 27352,
  [SMALL_STATE(776)] = 27362,
  [SMALL_STATE(777)] = 27370,
  [SMALL_STATE(778)] = 27380,
  [SMALL_STATE(779)] = 27390,
  [SMALL_STATE(780)] = 27400,
  [SMALL_STATE(781)] = 27408,
  [SMALL_STATE(782)] = 27418,
  [SMALL_STATE(783)] = 27428,
  [SMALL_STATE(784)] = 27438,
  [SMALL_STATE(785)] = 27448,
  [SMALL_STATE(786)] = 27458,
  [SMALL_STATE(787)] = 27468,
  [SMALL_STATE(788)] = 27478,
  [SMALL_STATE(789)] = 27488,
  [SMALL_STATE(790)] = 27498,
  [SMALL_STATE(791)] = 27508,
  [SMALL_STATE(792)] = 27518,
  [SMALL_STATE(793)] = 27528,
  [SMALL_STATE(794)] = 27538,
  [SMALL_STATE(795)] = 27548,
  [SMALL_STATE(796)] = 27558,
  [SMALL_STATE(797)] = 27568,
  [SMALL_STATE(798)] = 27578,
  [SMALL_STATE(799)] = 27588,
  [SMALL_STATE(800)] = 27598,
  [SMALL_STATE(801)] = 27608,
  [SMALL_STATE(802)] = 27618,
  [SMALL_STATE(803)] = 27628,
  [SMALL_STATE(804)] = 27633,
  [SMALL_STATE(805)] = 27638,
  [SMALL_STATE(806)] = 27645,
  [SMALL_STATE(807)] = 27652,
  [SMALL_STATE(808)] = 27659,
  [SMALL_STATE(809)] = 27666,
  [SMALL_STATE(810)] = 27671,
  [SMALL_STATE(811)] = 27676,
  [SMALL_STATE(812)] = 27683,
  [SMALL_STATE(813)] = 27690,
  [SMALL_STATE(814)] = 27697,
  [SMALL_STATE(815)] = 27702,
  [SMALL_STATE(816)] = 27707,
  [SMALL_STATE(817)] = 27712,
  [SMALL_STATE(818)] = 27719,
  [SMALL_STATE(819)] = 27726,
  [SMALL_STATE(820)] = 27733,
  [SMALL_STATE(821)] = 27738,
  [SMALL_STATE(822)] = 27745,
  [SMALL_STATE(823)] = 27750,
  [SMALL_STATE(824)] = 27755,
  [SMALL_STATE(825)] = 27760,
  [SMALL_STATE(826)] = 27765,
  [SMALL_STATE(827)] = 27772,
  [SMALL_STATE(828)] = 27777,
  [SMALL_STATE(829)] = 27784,
  [SMALL_STATE(830)] = 27791,
  [SMALL_STATE(831)] = 27798,
  [SMALL_STATE(832)] = 27805,
  [SMALL_STATE(833)] = 27810,
  [SMALL_STATE(834)] = 27815,
  [SMALL_STATE(835)] = 27820,
  [SMALL_STATE(836)] = 27825,
  [SMALL_STATE(837)] = 27830,
  [SMALL_STATE(838)] = 27835,
  [SMALL_STATE(839)] = 27840,
  [SMALL_STATE(840)] = 27847,
  [SMALL_STATE(841)] = 27854,
  [SMALL_STATE(842)] = 27861,
  [SMALL_STATE(843)] = 27868,
  [SMALL_STATE(844)] = 27875,
  [SMALL_STATE(845)] = 27882,
  [SMALL_STATE(846)] = 27889,
  [SMALL_STATE(847)] = 27894,
  [SMALL_STATE(848)] = 27899,
  [SMALL_STATE(849)] = 27906,
  [SMALL_STATE(850)] = 27913,
  [SMALL_STATE(851)] = 27918,
  [SMALL_STATE(852)] = 27923,
  [SMALL_STATE(853)] = 27930,
  [SMALL_STATE(854)] = 27937,
  [SMALL_STATE(855)] = 27942,
  [SMALL_STATE(856)] = 27947,
  [SMALL_STATE(857)] = 27952,
  [SMALL_STATE(858)] = 27959,
  [SMALL_STATE(859)] = 27966,
  [SMALL_STATE(860)] = 27971,
  [SMALL_STATE(861)] = 27978,
  [SMALL_STATE(862)] = 27983,
  [SMALL_STATE(863)] = 27990,
  [SMALL_STATE(864)] = 27995,
  [SMALL_STATE(865)] = 28002,
  [SMALL_STATE(866)] = 28009,
  [SMALL_STATE(867)] = 28016,
  [SMALL_STATE(868)] = 28023,
  [SMALL_STATE(869)] = 28028,
  [SMALL_STATE(870)] = 28035,
  [SMALL_STATE(871)] = 28040,
  [SMALL_STATE(872)] = 28045,
  [SMALL_STATE(873)] = 28050,
  [SMALL_STATE(874)] = 28055,
  [SMALL_STATE(875)] = 28060,
  [SMALL_STATE(876)] = 28065,
  [SMALL_STATE(877)] = 28072,
  [SMALL_STATE(878)] = 28079,
  [SMALL_STATE(879)] = 28086,
  [SMALL_STATE(880)] = 28093,
  [SMALL_STATE(881)] = 28100,
  [SMALL_STATE(882)] = 28105,
  [SMALL_STATE(883)] = 28112,
  [SMALL_STATE(884)] = 28119,
  [SMALL_STATE(885)] = 28126,
  [SMALL_STATE(886)] = 28133,
  [SMALL_STATE(887)] = 28140,
  [SMALL_STATE(888)] = 28147,
  [SMALL_STATE(889)] = 28154,
  [SMALL_STATE(890)] = 28161,
  [SMALL_STATE(891)] = 28166,
  [SMALL_STATE(892)] = 28173,
  [SMALL_STATE(893)] = 28180,
  [SMALL_STATE(894)] = 28187,
  [SMALL_STATE(895)] = 28194,
  [SMALL_STATE(896)] = 28201,
  [SMALL_STATE(897)] = 28208,
  [SMALL_STATE(898)] = 28213,
  [SMALL_STATE(899)] = 28218,
  [SMALL_STATE(900)] = 28225,
  [SMALL_STATE(901)] = 28230,
  [SMALL_STATE(902)] = 28237,
  [SMALL_STATE(903)] = 28242,
  [SMALL_STATE(904)] = 28249,
  [SMALL_STATE(905)] = 28256,
  [SMALL_STATE(906)] = 28263,
  [SMALL_STATE(907)] = 28270,
  [SMALL_STATE(908)] = 28275,
  [SMALL_STATE(909)] = 28280,
  [SMALL_STATE(910)] = 28285,
  [SMALL_STATE(911)] = 28290,
  [SMALL_STATE(912)] = 28295,
  [SMALL_STATE(913)] = 28302,
  [SMALL_STATE(914)] = 28309,
  [SMALL_STATE(915)] = 28316,
  [SMALL_STATE(916)] = 28323,
  [SMALL_STATE(917)] = 28330,
  [SMALL_STATE(918)] = 28337,
  [SMALL_STATE(919)] = 28344,
  [SMALL_STATE(920)] = 28351,
  [SMALL_STATE(921)] = 28358,
  [SMALL_STATE(922)] = 28365,
  [SMALL_STATE(923)] = 28372,
  [SMALL_STATE(924)] = 28379,
  [SMALL_STATE(925)] = 28386,
  [SMALL_STATE(926)] = 28393,
  [SMALL_STATE(927)] = 28400,
  [SMALL_STATE(928)] = 28407,
  [SMALL_STATE(929)] = 28414,
  [SMALL_STATE(930)] = 28419,
  [SMALL_STATE(931)] = 28424,
  [SMALL_STATE(932)] = 28429,
  [SMALL_STATE(933)] = 28436,
  [SMALL_STATE(934)] = 28443,
  [SMALL_STATE(935)] = 28450,
  [SMALL_STATE(936)] = 28457,
  [SMALL_STATE(937)] = 28462,
  [SMALL_STATE(938)] = 28469,
  [SMALL_STATE(939)] = 28476,
  [SMALL_STATE(940)] = 28483,
  [SMALL_STATE(941)] = 28488,
  [SMALL_STATE(942)] = 28495,
  [SMALL_STATE(943)] = 28502,
  [SMALL_STATE(944)] = 28507,
  [SMALL_STATE(945)] = 28514,
  [SMALL_STATE(946)] = 28521,
  [SMALL_STATE(947)] = 28528,
  [SMALL_STATE(948)] = 28535,
  [SMALL_STATE(949)] = 28542,
  [SMALL_STATE(950)] = 28549,
  [SMALL_STATE(951)] = 28556,
  [SMALL_STATE(952)] = 28563,
  [SMALL_STATE(953)] = 28570,
  [SMALL_STATE(954)] = 28577,
  [SMALL_STATE(955)] = 28582,
  [SMALL_STATE(956)] = 28587,
  [SMALL_STATE(957)] = 28594,
  [SMALL_STATE(958)] = 28601,
  [SMALL_STATE(959)] = 28608,
  [SMALL_STATE(960)] = 28615,
  [SMALL_STATE(961)] = 28620,
  [SMALL_STATE(962)] = 28625,
  [SMALL_STATE(963)] = 28630,
  [SMALL_STATE(964)] = 28635,
  [SMALL_STATE(965)] = 28640,
  [SMALL_STATE(966)] = 28645,
  [SMALL_STATE(967)] = 28650,
  [SMALL_STATE(968)] = 28655,
  [SMALL_STATE(969)] = 28660,
  [SMALL_STATE(970)] = 28665,
  [SMALL_STATE(971)] = 28670,
  [SMALL_STATE(972)] = 28675,
  [SMALL_STATE(973)] = 28682,
  [SMALL_STATE(974)] = 28687,
  [SMALL_STATE(975)] = 28692,
  [SMALL_STATE(976)] = 28697,
  [SMALL_STATE(977)] = 28704,
  [SMALL_STATE(978)] = 28711,
  [SMALL_STATE(979)] = 28716,
  [SMALL_STATE(980)] = 28723,
  [SMALL_STATE(981)] = 28728,
  [SMALL_STATE(982)] = 28733,
  [SMALL_STATE(983)] = 28740,
  [SMALL_STATE(984)] = 28747,
  [SMALL_STATE(985)] = 28752,
  [SMALL_STATE(986)] = 28757,
  [SMALL_STATE(987)] = 28762,
  [SMALL_STATE(988)] = 28767,
  [SMALL_STATE(989)] = 28774,
  [SMALL_STATE(990)] = 28781,
  [SMALL_STATE(991)] = 28788,
  [SMALL_STATE(992)] = 28795,
  [SMALL_STATE(993)] = 28800,
  [SMALL_STATE(994)] = 28807,
  [SMALL_STATE(995)] = 28814,
  [SMALL_STATE(996)] = 28821,
  [SMALL_STATE(997)] = 28828,
  [SMALL_STATE(998)] = 28833,
  [SMALL_STATE(999)] = 28838,
  [SMALL_STATE(1000)] = 28845,
  [SMALL_STATE(1001)] = 28852,
  [SMALL_STATE(1002)] = 28859,
  [SMALL_STATE(1003)] = 28866,
  [SMALL_STATE(1004)] = 28871,
  [SMALL_STATE(1005)] = 28878,
  [SMALL_STATE(1006)] = 28885,
  [SMALL_STATE(1007)] = 28892,
  [SMALL_STATE(1008)] = 28899,
  [SMALL_STATE(1009)] = 28906,
  [SMALL_STATE(1010)] = 28913,
  [SMALL_STATE(1011)] = 28920,
  [SMALL_STATE(1012)] = 28927,
  [SMALL_STATE(1013)] = 28934,
  [SMALL_STATE(1014)] = 28941,
  [SMALL_STATE(1015)] = 28948,
  [SMALL_STATE(1016)] = 28955,
  [SMALL_STATE(1017)] = 28962,
  [SMALL_STATE(1018)] = 28969,
  [SMALL_STATE(1019)] = 28976,
  [SMALL_STATE(1020)] = 28983,
  [SMALL_STATE(1021)] = 28990,
  [SMALL_STATE(1022)] = 28997,
  [SMALL_STATE(1023)] = 29004,
  [SMALL_STATE(1024)] = 29011,
  [SMALL_STATE(1025)] = 29016,
  [SMALL_STATE(1026)] = 29023,
  [SMALL_STATE(1027)] = 29030,
  [SMALL_STATE(1028)] = 29037,
  [SMALL_STATE(1029)] = 29044,
  [SMALL_STATE(1030)] = 29051,
  [SMALL_STATE(1031)] = 29058,
  [SMALL_STATE(1032)] = 29065,
  [SMALL_STATE(1033)] = 29072,
  [SMALL_STATE(1034)] = 29079,
  [SMALL_STATE(1035)] = 29086,
  [SMALL_STATE(1036)] = 29093,
  [SMALL_STATE(1037)] = 29100,
  [SMALL_STATE(1038)] = 29107,
  [SMALL_STATE(1039)] = 29114,
  [SMALL_STATE(1040)] = 29121,
  [SMALL_STATE(1041)] = 29128,
  [SMALL_STATE(1042)] = 29135,
  [SMALL_STATE(1043)] = 29142,
  [SMALL_STATE(1044)] = 29147,
  [SMALL_STATE(1045)] = 29152,
  [SMALL_STATE(1046)] = 29157,
  [SMALL_STATE(1047)] = 29162,
  [SMALL_STATE(1048)] = 29169,
  [SMALL_STATE(1049)] = 29176,
  [SMALL_STATE(1050)] = 29183,
  [SMALL_STATE(1051)] = 29190,
  [SMALL_STATE(1052)] = 29197,
  [SMALL_STATE(1053)] = 29201,
  [SMALL_STATE(1054)] = 29205,
  [SMALL_STATE(1055)] = 29209,
  [SMALL_STATE(1056)] = 29213,
  [SMALL_STATE(1057)] = 29217,
  [SMALL_STATE(1058)] = 29221,
  [SMALL_STATE(1059)] = 29225,
  [SMALL_STATE(1060)] = 29229,
  [SMALL_STATE(1061)] = 29233,
  [SMALL_STATE(1062)] = 29237,
  [SMALL_STATE(1063)] = 29241,
  [SMALL_STATE(1064)] = 29245,
  [SMALL_STATE(1065)] = 29249,
  [SMALL_STATE(1066)] = 29253,
  [SMALL_STATE(1067)] = 29257,
  [SMALL_STATE(1068)] = 29261,
  [SMALL_STATE(1069)] = 29265,
  [SMALL_STATE(1070)] = 29269,
  [SMALL_STATE(1071)] = 29273,
  [SMALL_STATE(1072)] = 29277,
  [SMALL_STATE(1073)] = 29281,
  [SMALL_STATE(1074)] = 29285,
  [SMALL_STATE(1075)] = 29289,
  [SMALL_STATE(1076)] = 29293,
  [SMALL_STATE(1077)] = 29297,
  [SMALL_STATE(1078)] = 29301,
  [SMALL_STATE(1079)] = 29305,
  [SMALL_STATE(1080)] = 29309,
  [SMALL_STATE(1081)] = 29313,
  [SMALL_STATE(1082)] = 29317,
  [SMALL_STATE(1083)] = 29321,
  [SMALL_STATE(1084)] = 29325,
  [SMALL_STATE(1085)] = 29329,
  [SMALL_STATE(1086)] = 29333,
  [SMALL_STATE(1087)] = 29337,
  [SMALL_STATE(1088)] = 29341,
  [SMALL_STATE(1089)] = 29345,
  [SMALL_STATE(1090)] = 29349,
  [SMALL_STATE(1091)] = 29353,
  [SMALL_STATE(1092)] = 29357,
  [SMALL_STATE(1093)] = 29361,
  [SMALL_STATE(1094)] = 29365,
  [SMALL_STATE(1095)] = 29369,
  [SMALL_STATE(1096)] = 29373,
  [SMALL_STATE(1097)] = 29377,
  [SMALL_STATE(1098)] = 29381,
  [SMALL_STATE(1099)] = 29385,
  [SMALL_STATE(1100)] = 29389,
  [SMALL_STATE(1101)] = 29393,
  [SMALL_STATE(1102)] = 29397,
  [SMALL_STATE(1103)] = 29401,
  [SMALL_STATE(1104)] = 29405,
  [SMALL_STATE(1105)] = 29409,
  [SMALL_STATE(1106)] = 29413,
  [SMALL_STATE(1107)] = 29417,
  [SMALL_STATE(1108)] = 29421,
  [SMALL_STATE(1109)] = 29425,
  [SMALL_STATE(1110)] = 29429,
  [SMALL_STATE(1111)] = 29433,
  [SMALL_STATE(1112)] = 29437,
  [SMALL_STATE(1113)] = 29441,
  [SMALL_STATE(1114)] = 29445,
  [SMALL_STATE(1115)] = 29449,
  [SMALL_STATE(1116)] = 29453,
  [SMALL_STATE(1117)] = 29457,
  [SMALL_STATE(1118)] = 29461,
  [SMALL_STATE(1119)] = 29465,
  [SMALL_STATE(1120)] = 29469,
  [SMALL_STATE(1121)] = 29473,
  [SMALL_STATE(1122)] = 29477,
  [SMALL_STATE(1123)] = 29481,
  [SMALL_STATE(1124)] = 29485,
  [SMALL_STATE(1125)] = 29489,
  [SMALL_STATE(1126)] = 29493,
  [SMALL_STATE(1127)] = 29497,
  [SMALL_STATE(1128)] = 29501,
  [SMALL_STATE(1129)] = 29505,
  [SMALL_STATE(1130)] = 29509,
  [SMALL_STATE(1131)] = 29513,
  [SMALL_STATE(1132)] = 29517,
  [SMALL_STATE(1133)] = 29521,
  [SMALL_STATE(1134)] = 29525,
  [SMALL_STATE(1135)] = 29529,
  [SMALL_STATE(1136)] = 29533,
  [SMALL_STATE(1137)] = 29537,
  [SMALL_STATE(1138)] = 29541,
  [SMALL_STATE(1139)] = 29545,
  [SMALL_STATE(1140)] = 29549,
  [SMALL_STATE(1141)] = 29553,
  [SMALL_STATE(1142)] = 29557,
  [SMALL_STATE(1143)] = 29561,
  [SMALL_STATE(1144)] = 29565,
  [SMALL_STATE(1145)] = 29569,
  [SMALL_STATE(1146)] = 29573,
  [SMALL_STATE(1147)] = 29577,
  [SMALL_STATE(1148)] = 29581,
  [SMALL_STATE(1149)] = 29585,
  [SMALL_STATE(1150)] = 29589,
  [SMALL_STATE(1151)] = 29593,
  [SMALL_STATE(1152)] = 29597,
  [SMALL_STATE(1153)] = 29601,
  [SMALL_STATE(1154)] = 29605,
  [SMALL_STATE(1155)] = 29609,
  [SMALL_STATE(1156)] = 29613,
  [SMALL_STATE(1157)] = 29617,
  [SMALL_STATE(1158)] = 29621,
  [SMALL_STATE(1159)] = 29625,
  [SMALL_STATE(1160)] = 29629,
  [SMALL_STATE(1161)] = 29633,
  [SMALL_STATE(1162)] = 29637,
  [SMALL_STATE(1163)] = 29641,
  [SMALL_STATE(1164)] = 29645,
  [SMALL_STATE(1165)] = 29649,
  [SMALL_STATE(1166)] = 29653,
  [SMALL_STATE(1167)] = 29657,
  [SMALL_STATE(1168)] = 29661,
  [SMALL_STATE(1169)] = 29665,
  [SMALL_STATE(1170)] = 29669,
  [SMALL_STATE(1171)] = 29673,
  [SMALL_STATE(1172)] = 29677,
  [SMALL_STATE(1173)] = 29681,
  [SMALL_STATE(1174)] = 29685,
  [SMALL_STATE(1175)] = 29689,
  [SMALL_STATE(1176)] = 29693,
  [SMALL_STATE(1177)] = 29697,
  [SMALL_STATE(1178)] = 29701,
  [SMALL_STATE(1179)] = 29705,
  [SMALL_STATE(1180)] = 29709,
  [SMALL_STATE(1181)] = 29713,
  [SMALL_STATE(1182)] = 29717,
  [SMALL_STATE(1183)] = 29721,
  [SMALL_STATE(1184)] = 29725,
  [SMALL_STATE(1185)] = 29729,
  [SMALL_STATE(1186)] = 29733,
  [SMALL_STATE(1187)] = 29737,
  [SMALL_STATE(1188)] = 29741,
  [SMALL_STATE(1189)] = 29745,
  [SMALL_STATE(1190)] = 29749,
  [SMALL_STATE(1191)] = 29753,
  [SMALL_STATE(1192)] = 29757,
  [SMALL_STATE(1193)] = 29761,
  [SMALL_STATE(1194)] = 29765,
  [SMALL_STATE(1195)] = 29769,
  [SMALL_STATE(1196)] = 29773,
  [SMALL_STATE(1197)] = 29777,
  [SMALL_STATE(1198)] = 29781,
  [SMALL_STATE(1199)] = 29785,
  [SMALL_STATE(1200)] = 29789,
  [SMALL_STATE(1201)] = 29793,
  [SMALL_STATE(1202)] = 29797,
  [SMALL_STATE(1203)] = 29801,
  [SMALL_STATE(1204)] = 29805,
  [SMALL_STATE(1205)] = 29809,
  [SMALL_STATE(1206)] = 29813,
  [SMALL_STATE(1207)] = 29817,
  [SMALL_STATE(1208)] = 29821,
  [SMALL_STATE(1209)] = 29825,
  [SMALL_STATE(1210)] = 29829,
  [SMALL_STATE(1211)] = 29833,
  [SMALL_STATE(1212)] = 29837,
  [SMALL_STATE(1213)] = 29841,
  [SMALL_STATE(1214)] = 29845,
  [SMALL_STATE(1215)] = 29849,
  [SMALL_STATE(1216)] = 29853,
  [SMALL_STATE(1217)] = 29857,
  [SMALL_STATE(1218)] = 29861,
  [SMALL_STATE(1219)] = 29865,
  [SMALL_STATE(1220)] = 29869,
  [SMALL_STATE(1221)] = 29873,
  [SMALL_STATE(1222)] = 29877,
  [SMALL_STATE(1223)] = 29881,
  [SMALL_STATE(1224)] = 29885,
  [SMALL_STATE(1225)] = 29889,
  [SMALL_STATE(1226)] = 29893,
  [SMALL_STATE(1227)] = 29897,
  [SMALL_STATE(1228)] = 29901,
  [SMALL_STATE(1229)] = 29905,
  [SMALL_STATE(1230)] = 29909,
  [SMALL_STATE(1231)] = 29913,
  [SMALL_STATE(1232)] = 29917,
  [SMALL_STATE(1233)] = 29921,
  [SMALL_STATE(1234)] = 29925,
  [SMALL_STATE(1235)] = 29929,
  [SMALL_STATE(1236)] = 29933,
  [SMALL_STATE(1237)] = 29937,
  [SMALL_STATE(1238)] = 29941,
  [SMALL_STATE(1239)] = 29945,
  [SMALL_STATE(1240)] = 29949,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_program, 0, 0, 0),
  [5] = {.entry = {.count = 1, .reusable = true}}, SHIFT(394),
  [7] = {.entry = {.count = 1, .reusable = false}}, SHIFT(394),
  [9] = {.entry = {.count = 1, .reusable = false}}, SHIFT(134),
  [11] = {.entry = {.count = 1, .reusable = false}}, SHIFT(332),
  [13] = {.entry = {.count = 1, .reusable = true}}, SHIFT(159),
  [15] = {.entry = {.count = 1, .reusable = false}}, SHIFT(139),
  [17] = {.entry = {.count = 1, .reusable = false}}, SHIFT(362),
  [19] = {.entry = {.count = 1, .reusable = true}}, SHIFT(362),
  [21] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1057),
  [23] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1058),
  [25] = {.entry = {.count = 1, .reusable = true}}, SHIFT(316),
  [27] = {.entry = {.count = 1, .reusable = false}}, SHIFT(283),
  [29] = {.entry = {.count = 1, .reusable = true}}, SHIFT(358),
  [31] = {.entry = {.count = 1, .reusable = false}}, SHIFT(358),
  [33] = {.entry = {.count = 1, .reusable = true}}, SHIFT(356),
  [35] = {.entry = {.count = 1, .reusable = true}}, SHIFT(354),
  [37] = {.entry = {.count = 1, .reusable = true}}, SHIFT(353),
  [39] = {.entry = {.count = 1, .reusable = false}}, SHIFT(353),
  [41] = {.entry = {.count = 1, .reusable = false}}, SHIFT(352),
  [43] = {.entry = {.count = 1, .reusable = false}}, SHIFT(351),
  [45] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1108),
  [47] = {.entry = {.count = 1, .reusable = false}}, SHIFT(324),
  [49] = {.entry = {.count = 1, .reusable = false}}, SHIFT(785),
  [51] = {.entry = {.count = 1, .reusable = false}}, SHIFT(784),
  [53] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1125),
  [55] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1109),
  [57] = {.entry = {.count = 1, .reusable = false}}, SHIFT(728),
  [59] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1055),
  [61] = {.entry = {.count = 1, .reusable = false}}, SHIFT(669),
  [63] = {.entry = {.count = 1, .reusable = false}}, SHIFT(672),
  [65] = {.entry = {.count = 1, .reusable = false}}, SHIFT(782),
  [67] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1182),
  [69] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1072),
  [71] = {.entry = {.count = 1, .reusable = false}}, SHIFT(344),
  [73] = {.entry = {.count = 1, .reusable = false}}, SHIFT(330),
  [75] = {.entry = {.count = 1, .reusable = false}}, SHIFT(12),
  [77] = {.entry = {.count = 1, .reusable = false}}, SHIFT(865),
  [79] = {.entry = {.count = 1, .reusable = false}}, SHIFT(342),
  [81] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1066),
  [83] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1176),
  [85] = {.entry = {.count = 1, .reusable = false}}, SHIFT(694),
  [87] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1174),
  [89] = {.entry = {.count = 1, .reusable = false}}, SHIFT(888),
  [91] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1085),
  [93] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__elsif_liq, 2, 1, 16),
  [95] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__expression, 1, 0, 0),
  [97] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__expression, 1, 0, 0),
  [99] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__when_liq, 2, 1, 16),
  [101] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__if_liq_repeat1, 2, 0, 0), SHIFT_REPEAT(139),
  [104] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__if_liq_repeat1, 2, 0, 0), SHIFT_REPEAT(362),
  [107] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__if_liq_repeat1, 2, 0, 0), SHIFT_REPEAT(362),
  [110] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__if_liq_repeat1, 2, 0, 0), SHIFT_REPEAT(1057),
  [113] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__if_liq_repeat1, 2, 0, 0), SHIFT_REPEAT(1058),
  [116] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__if_liq_repeat1, 2, 0, 0), SHIFT_REPEAT(316),
  [119] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__if_liq_repeat1, 2, 0, 0), SHIFT_REPEAT(283),
  [122] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__if_liq_repeat1, 2, 0, 0), SHIFT_REPEAT(1108),
  [125] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__if_liq_repeat1, 2, 0, 0), SHIFT_REPEAT(324),
  [128] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__if_liq_repeat1, 2, 0, 0), SHIFT_REPEAT(785),
  [131] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__if_liq_repeat1, 2, 0, 0), SHIFT_REPEAT(784),
  [134] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__if_liq_repeat1, 2, 0, 0), SHIFT_REPEAT(1125),
  [137] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__if_liq_repeat1, 2, 0, 0), SHIFT_REPEAT(1109),
  [140] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__if_liq_repeat1, 2, 0, 0), SHIFT_REPEAT(728),
  [143] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__if_liq_repeat1, 2, 0, 0), SHIFT_REPEAT(1055),
  [146] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__if_liq_repeat1, 2, 0, 0), SHIFT_REPEAT(669),
  [149] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__if_liq_repeat1, 2, 0, 0), SHIFT_REPEAT(672),
  [152] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__if_liq_repeat1, 2, 0, 0), SHIFT_REPEAT(782),
  [155] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__if_liq_repeat1, 2, 0, 0), SHIFT_REPEAT(1182),
  [158] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__if_liq_repeat1, 2, 0, 0), SHIFT_REPEAT(344),
  [161] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__if_liq_repeat1, 2, 0, 0),
  [163] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__if_liq_repeat1, 2, 0, 0), SHIFT_REPEAT(865),
  [166] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__if_liq_repeat1, 2, 0, 0), SHIFT_REPEAT(342),
  [169] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__if_liq_repeat1, 2, 0, 0), SHIFT_REPEAT(1176),
  [172] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__if_liq_repeat1, 2, 0, 0), SHIFT_REPEAT(694),
  [175] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__if_liq_repeat1, 2, 0, 0), SHIFT_REPEAT(1174),
  [178] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__if_liq_repeat1, 2, 0, 0), SHIFT_REPEAT(888),
  [181] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1152),
  [183] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1140),
  [185] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_liquid_tag, 1, 0, 0),
  [187] = {.entry = {.count = 1, .reusable = true}}, SHIFT(318),
  [189] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1169),
  [191] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1170),
  [193] = {.entry = {.count = 1, .reusable = true}}, SHIFT(155),
  [195] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_liquid_tag_repeat1, 2, 0, 0), SHIFT_REPEAT(139),
  [198] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_liquid_tag_repeat1, 2, 0, 0),
  [200] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_liquid_tag_repeat1, 2, 0, 0), SHIFT_REPEAT(362),
  [203] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_liquid_tag_repeat1, 2, 0, 0), SHIFT_REPEAT(362),
  [206] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_liquid_tag_repeat1, 2, 0, 0), SHIFT_REPEAT(1057),
  [209] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_liquid_tag_repeat1, 2, 0, 0), SHIFT_REPEAT(1058),
  [212] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_liquid_tag_repeat1, 2, 0, 0), SHIFT_REPEAT(318),
  [215] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_liquid_tag_repeat1, 2, 0, 0), SHIFT_REPEAT(283),
  [218] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_liquid_tag_repeat1, 2, 0, 0), SHIFT_REPEAT(1169),
  [221] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_liquid_tag_repeat1, 2, 0, 0), SHIFT_REPEAT(324),
  [224] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_liquid_tag_repeat1, 2, 0, 0), SHIFT_REPEAT(785),
  [227] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_liquid_tag_repeat1, 2, 0, 0), SHIFT_REPEAT(784),
  [230] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_liquid_tag_repeat1, 2, 0, 0), SHIFT_REPEAT(1125),
  [233] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_liquid_tag_repeat1, 2, 0, 0), SHIFT_REPEAT(1109),
  [236] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_liquid_tag_repeat1, 2, 0, 0), SHIFT_REPEAT(728),
  [239] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_liquid_tag_repeat1, 2, 0, 0), SHIFT_REPEAT(1055),
  [242] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_liquid_tag_repeat1, 2, 0, 0), SHIFT_REPEAT(669),
  [245] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_liquid_tag_repeat1, 2, 0, 0), SHIFT_REPEAT(672),
  [248] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_liquid_tag_repeat1, 2, 0, 0), SHIFT_REPEAT(782),
  [251] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_liquid_tag_repeat1, 2, 0, 0), SHIFT_REPEAT(1182),
  [254] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_liquid_tag_repeat1, 2, 0, 0), SHIFT_REPEAT(344),
  [257] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_liquid_tag_repeat1, 2, 0, 0), SHIFT_REPEAT(865),
  [260] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_liquid_tag_repeat1, 2, 0, 0), SHIFT_REPEAT(342),
  [263] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_liquid_tag_repeat1, 2, 0, 0), SHIFT_REPEAT(1176),
  [266] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_liquid_tag_repeat1, 2, 0, 0), SHIFT_REPEAT(694),
  [269] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_liquid_tag_repeat1, 2, 0, 0), SHIFT_REPEAT(1174),
  [272] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_liquid_tag_repeat1, 2, 0, 0), SHIFT_REPEAT(888),
  [275] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_liquid_tag_repeat1, 2, 0, 0), SHIFT_REPEAT(1170),
  [278] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_liquid_tag_repeat1, 2, 0, 0), SHIFT_REPEAT(155),
  [281] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_liquid_tag, 2, 0, 0),
  [283] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__else_liq, 1, 2, 0),
  [285] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1216),
  [287] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1179),
  [289] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__else_liq, 2, 2, 29),
  [291] = {.entry = {.count = 1, .reusable = true}}, SHIFT(373),
  [293] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1079),
  [295] = {.entry = {.count = 1, .reusable = true}}, SHIFT(746),
  [297] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1062),
  [299] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__elsif_liq, 3, 1, 40),
  [301] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__when_liq, 3, 1, 31),
  [303] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_argument_list, 1, 0, 0),
  [305] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argument_list, 1, 0, 0),
  [307] = {.entry = {.count = 1, .reusable = true}}, SHIFT(382),
  [309] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_argument_list_repeat1, 2, 0, 0),
  [311] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_argument_list_repeat1, 2, 0, 0),
  [313] = {.entry = {.count = 1, .reusable = true}}, SHIFT(388),
  [315] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1195),
  [317] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1194),
  [319] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_argument, 3, 0, 46),
  [321] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argument, 3, 0, 46),
  [323] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1159),
  [325] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1228),
  [327] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1227),
  [329] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1226),
  [331] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_access, 3, 0, 13),
  [333] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_access, 3, 0, 13),
  [335] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_access, 4, 0, 13),
  [337] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_access, 4, 0, 13),
  [339] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1160),
  [341] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1196),
  [343] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1063),
  [345] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_argument_list_repeat1, 2, 0, 0), SHIFT_REPEAT(382),
  [348] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_argument_list, 2, 0, 0),
  [350] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argument_list, 2, 0, 0),
  [352] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string, 3, 0, 0),
  [354] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string, 3, 0, 0),
  [356] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_boolean, 1, 0, 0),
  [358] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_boolean, 1, 0, 0),
  [360] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_filter, 3, 0, 15),
  [362] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_filter, 3, 0, 15),
  [364] = {.entry = {.count = 1, .reusable = true}}, SHIFT(379),
  [366] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__expression, 3, 0, 0),
  [368] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__expression, 3, 0, 0),
  [370] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_predicate, 3, 0, 14),
  [372] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_predicate, 3, 0, 14),
  [374] = {.entry = {.count = 1, .reusable = false}}, SHIFT(356),
  [376] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_filter, 5, 0, 15),
  [378] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_filter, 5, 0, 15),
  [380] = {.entry = {.count = 1, .reusable = false}}, SHIFT(304),
  [382] = {.entry = {.count = 1, .reusable = false}}, SHIFT(9),
  [384] = {.entry = {.count = 1, .reusable = false}}, SHIFT(929),
  [386] = {.entry = {.count = 1, .reusable = false}}, SHIFT(365),
  [388] = {.entry = {.count = 1, .reusable = false}}, SHIFT(792),
  [390] = {.entry = {.count = 1, .reusable = false}}, SHIFT(788),
  [392] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1229),
  [394] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1225),
  [396] = {.entry = {.count = 1, .reusable = false}}, SHIFT(719),
  [398] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1221),
  [400] = {.entry = {.count = 1, .reusable = false}}, SHIFT(665),
  [402] = {.entry = {.count = 1, .reusable = false}}, SHIFT(664),
  [404] = {.entry = {.count = 1, .reusable = false}}, SHIFT(787),
  [406] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1238),
  [408] = {.entry = {.count = 1, .reusable = false}}, SHIFT(355),
  [410] = {.entry = {.count = 1, .reusable = false}}, SHIFT(846),
  [412] = {.entry = {.count = 1, .reusable = false}}, SHIFT(339),
  [414] = {.entry = {.count = 1, .reusable = false}}, SHIFT(897),
  [416] = {.entry = {.count = 1, .reusable = false}}, SHIFT(817),
  [418] = {.entry = {.count = 1, .reusable = false}}, SHIFT(357),
  [420] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1224),
  [422] = {.entry = {.count = 1, .reusable = false}}, SHIFT(709),
  [424] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1239),
  [426] = {.entry = {.count = 1, .reusable = false}}, SHIFT(805),
  [428] = {.entry = {.count = 1, .reusable = false}}, SHIFT(816),
  [430] = {.entry = {.count = 1, .reusable = false}}, SHIFT(835),
  [432] = {.entry = {.count = 1, .reusable = false}}, SHIFT(834),
  [434] = {.entry = {.count = 1, .reusable = false}}, SHIFT(815),
  [436] = {.entry = {.count = 1, .reusable = false}}, SHIFT(814),
  [438] = {.entry = {.count = 1, .reusable = true}}, SHIFT(716),
  [440] = {.entry = {.count = 1, .reusable = false}}, SHIFT(981),
  [442] = {.entry = {.count = 1, .reusable = false}}, SHIFT(832),
  [444] = {.entry = {.count = 1, .reusable = false}}, SHIFT(881),
  [446] = {.entry = {.count = 1, .reusable = false}}, SHIFT(960),
  [448] = {.entry = {.count = 1, .reusable = false}}, SHIFT(962),
  [450] = {.entry = {.count = 1, .reusable = false}}, SHIFT(898),
  [452] = {.entry = {.count = 1, .reusable = false}}, SHIFT(975),
  [454] = {.entry = {.count = 1, .reusable = false}}, SHIFT(988),
  [456] = {.entry = {.count = 1, .reusable = false}}, SHIFT(812),
  [458] = {.entry = {.count = 1, .reusable = false}}, SHIFT(811),
  [460] = {.entry = {.count = 1, .reusable = false}}, SHIFT(948),
  [462] = {.entry = {.count = 1, .reusable = false}}, SHIFT(989),
  [464] = {.entry = {.count = 1, .reusable = false}}, SHIFT(990),
  [466] = {.entry = {.count = 1, .reusable = false}}, SHIFT(991),
  [468] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1018),
  [470] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1015),
  [472] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1014),
  [474] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1019),
  [476] = {.entry = {.count = 1, .reusable = false}}, SHIFT(807),
  [478] = {.entry = {.count = 1, .reusable = false}}, SHIFT(806),
  [480] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1042),
  [482] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1039),
  [484] = {.entry = {.count = 1, .reusable = false}}, SHIFT(959),
  [486] = {.entry = {.count = 1, .reusable = false}}, SHIFT(963),
  [488] = {.entry = {.count = 1, .reusable = false}}, SHIFT(933),
  [490] = {.entry = {.count = 1, .reusable = false}}, SHIFT(955),
  [492] = {.entry = {.count = 1, .reusable = false}}, SHIFT(872),
  [494] = {.entry = {.count = 1, .reusable = false}}, SHIFT(874),
  [496] = {.entry = {.count = 1, .reusable = false}}, SHIFT(954),
  [498] = {.entry = {.count = 1, .reusable = false}}, SHIFT(940),
  [500] = {.entry = {.count = 1, .reusable = false}}, SHIFT(930),
  [502] = {.entry = {.count = 1, .reusable = false}}, SHIFT(931),
  [504] = {.entry = {.count = 1, .reusable = false}}, SHIFT(875),
  [506] = {.entry = {.count = 1, .reusable = false}}, SHIFT(825),
  [508] = {.entry = {.count = 1, .reusable = false}}, SHIFT(824),
  [510] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1032),
  [512] = {.entry = {.count = 1, .reusable = false}}, SHIFT(941),
  [514] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1031),
  [516] = {.entry = {.count = 1, .reusable = false}}, SHIFT(918),
  [518] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1030),
  [520] = {.entry = {.count = 1, .reusable = false}}, SHIFT(921),
  [522] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1029),
  [524] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1028),
  [526] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1027),
  [528] = {.entry = {.count = 1, .reusable = false}}, SHIFT(922),
  [530] = {.entry = {.count = 1, .reusable = false}}, SHIFT(964),
  [532] = {.entry = {.count = 1, .reusable = false}}, SHIFT(966),
  [534] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1026),
  [536] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1025),
  [538] = {.entry = {.count = 1, .reusable = false}}, SHIFT(923),
  [540] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1047),
  [542] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1024),
  [544] = {.entry = {.count = 1, .reusable = false}}, SHIFT(924),
  [546] = {.entry = {.count = 1, .reusable = false}}, SHIFT(932),
  [548] = {.entry = {.count = 1, .reusable = false}}, SHIFT(871),
  [550] = {.entry = {.count = 1, .reusable = false}}, SHIFT(936),
  [552] = {.entry = {.count = 1, .reusable = false}}, SHIFT(967),
  [554] = {.entry = {.count = 1, .reusable = false}}, SHIFT(952),
  [556] = {.entry = {.count = 1, .reusable = false}}, SHIFT(958),
  [558] = {.entry = {.count = 1, .reusable = false}}, SHIFT(972),
  [560] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1011),
  [562] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1010),
  [564] = {.entry = {.count = 1, .reusable = false}}, SHIFT(984),
  [566] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1009),
  [568] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1008),
  [570] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1007),
  [572] = {.entry = {.count = 1, .reusable = false}}, SHIFT(985),
  [574] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1049),
  [576] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1050),
  [578] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1006),
  [580] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1051),
  [582] = {.entry = {.count = 1, .reusable = false}}, SHIFT(877),
  [584] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1005),
  [586] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1003),
  [588] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1004),
  [590] = {.entry = {.count = 1, .reusable = false}}, SHIFT(863),
  [592] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1210),
  [594] = {.entry = {.count = 1, .reusable = false}}, SHIFT(345),
  [596] = {.entry = {.count = 1, .reusable = false}}, SHIFT(831),
  [598] = {.entry = {.count = 1, .reusable = false}}, SHIFT(343),
  [600] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1206),
  [602] = {.entry = {.count = 1, .reusable = false}}, SHIFT(686),
  [604] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1197),
  [606] = {.entry = {.count = 1, .reusable = false}}, SHIFT(853),
  [608] = {.entry = {.count = 1, .reusable = false}}, SHIFT(854),
  [610] = {.entry = {.count = 1, .reusable = false}}, SHIFT(855),
  [612] = {.entry = {.count = 1, .reusable = false}}, SHIFT(856),
  [614] = {.entry = {.count = 1, .reusable = false}}, SHIFT(859),
  [616] = {.entry = {.count = 1, .reusable = false}}, SHIFT(861),
  [618] = {.entry = {.count = 1, .reusable = true}}, SHIFT(741),
  [620] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__if_liq_repeat1, 1, 0, 0),
  [622] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__if_liq_repeat1, 1, 0, 0),
  [624] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__liquid_node, 2, 0, 0),
  [626] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__liquid_node, 2, 0, 0),
  [628] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__iterator, 1, 0, 28),
  [630] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__iterator, 1, 0, 28),
  [632] = {.entry = {.count = 1, .reusable = false}}, SHIFT(227),
  [634] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym__expression, 1, 0, 0), REDUCE(sym_custom_unpaired_statement, 1, 0, 1),
  [637] = {.entry = {.count = 1, .reusable = false}}, SHIFT(364),
  [639] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1052),
  [641] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1215),
  [643] = {.entry = {.count = 1, .reusable = false}}, SHIFT(244),
  [645] = {.entry = {.count = 1, .reusable = false}}, SHIFT(234),
  [647] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1103),
  [649] = {.entry = {.count = 1, .reusable = false}}, SHIFT(738),
  [651] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__page_iterator, 3, 0, 52),
  [653] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__page_iterator, 3, 0, 52),
  [655] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__iterator, 2, 0, 38),
  [657] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__iterator, 2, 0, 38),
  [659] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_range, 5, 0, 67),
  [661] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_range, 5, 0, 67),
  [663] = {.entry = {.count = 1, .reusable = true}}, SHIFT(407),
  [665] = {.entry = {.count = 1, .reusable = false}}, SHIFT(407),
  [667] = {.entry = {.count = 1, .reusable = false}}, SHIFT(57),
  [669] = {.entry = {.count = 1, .reusable = false}}, SHIFT(340),
  [671] = {.entry = {.count = 1, .reusable = false}}, SHIFT(62),
  [673] = {.entry = {.count = 1, .reusable = false}}, SHIFT(60),
  [675] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__paired_comment_liq, 3, 0, 0),
  [677] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__paired_comment_liq, 3, 0, 0),
  [679] = {.entry = {.count = 1, .reusable = false}}, SHIFT(58),
  [681] = {.entry = {.count = 1, .reusable = false}}, SHIFT(59),
  [683] = {.entry = {.count = 1, .reusable = false}}, SHIFT(64),
  [685] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__paired_comment_liq, 4, 0, 0),
  [687] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__paired_comment_liq, 4, 0, 0),
  [689] = {.entry = {.count = 1, .reusable = false}}, SHIFT(63),
  [691] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__page_iterator, 1, 0, 28),
  [693] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__page_iterator, 1, 0, 28),
  [695] = {.entry = {.count = 1, .reusable = true}}, SHIFT(375),
  [697] = {.entry = {.count = 1, .reusable = false}}, SHIFT(61),
  [699] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_comment_liq, 1, 0, 0),
  [701] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_comment_liq, 1, 0, 0),
  [703] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_program, 1, 0, 0),
  [705] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_program, 2, 0, 0),
  [707] = {.entry = {.count = 1, .reusable = false}}, SHIFT(66),
  [709] = {.entry = {.count = 1, .reusable = false}}, SHIFT(67),
  [711] = {.entry = {.count = 1, .reusable = false}}, SHIFT(78),
  [713] = {.entry = {.count = 1, .reusable = false}}, SHIFT(79),
  [715] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_program_repeat1, 2, 0, 0),
  [717] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_program_repeat1, 2, 0, 0), SHIFT_REPEAT(394),
  [720] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2, 0, 0), SHIFT_REPEAT(394),
  [723] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2, 0, 0), SHIFT_REPEAT(134),
  [726] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2, 0, 0), SHIFT_REPEAT(332),
  [729] = {.entry = {.count = 1, .reusable = false}}, SHIFT(74),
  [731] = {.entry = {.count = 1, .reusable = false}}, SHIFT(73),
  [733] = {.entry = {.count = 1, .reusable = false}}, SHIFT(65),
  [735] = {.entry = {.count = 1, .reusable = false}}, SHIFT(69),
  [737] = {.entry = {.count = 1, .reusable = false}}, SHIFT(70),
  [739] = {.entry = {.count = 1, .reusable = false}}, SHIFT(71),
  [741] = {.entry = {.count = 1, .reusable = false}}, SHIFT(80),
  [743] = {.entry = {.count = 1, .reusable = false}}, SHIFT(68),
  [745] = {.entry = {.count = 1, .reusable = false}}, SHIFT(76),
  [747] = {.entry = {.count = 1, .reusable = false}}, SHIFT(77),
  [749] = {.entry = {.count = 1, .reusable = false}}, SHIFT(72),
  [751] = {.entry = {.count = 1, .reusable = false}}, SHIFT(75),
  [753] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_else_clause, 3, 2, 0), SHIFT(133),
  [756] = {.entry = {.count = 1, .reusable = false}}, SHIFT(391),
  [758] = {.entry = {.count = 1, .reusable = false}}, SHIFT(385),
  [760] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1067),
  [762] = {.entry = {.count = 1, .reusable = false}}, SHIFT(744),
  [764] = {.entry = {.count = 1, .reusable = false}}, SHIFT(101),
  [766] = {.entry = {.count = 1, .reusable = false}}, SHIFT(100),
  [768] = {.entry = {.count = 1, .reusable = false}}, SHIFT(92),
  [770] = {.entry = {.count = 1, .reusable = false}}, SHIFT(94),
  [772] = {.entry = {.count = 1, .reusable = false}}, SHIFT(115),
  [774] = {.entry = {.count = 1, .reusable = false}}, SHIFT(106),
  [776] = {.entry = {.count = 1, .reusable = false}}, SHIFT(105),
  [778] = {.entry = {.count = 1, .reusable = false}}, SHIFT(87),
  [780] = {.entry = {.count = 1, .reusable = false}}, SHIFT(126),
  [782] = {.entry = {.count = 1, .reusable = false}}, SHIFT(125),
  [784] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_program_repeat1, 2, 0, 0), SHIFT_REPEAT(407),
  [787] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2, 0, 0), SHIFT_REPEAT(407),
  [790] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2, 0, 0), SHIFT_REPEAT(133),
  [793] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2, 0, 0), SHIFT_REPEAT(340),
  [796] = {.entry = {.count = 1, .reusable = false}}, SHIFT(95),
  [798] = {.entry = {.count = 1, .reusable = false}}, SHIFT(93),
  [800] = {.entry = {.count = 1, .reusable = false}}, SHIFT(129),
  [802] = {.entry = {.count = 1, .reusable = false}}, SHIFT(128),
  [804] = {.entry = {.count = 1, .reusable = false}}, SHIFT(116),
  [806] = {.entry = {.count = 1, .reusable = false}}, SHIFT(117),
  [808] = {.entry = {.count = 1, .reusable = false}}, SHIFT(99),
  [810] = {.entry = {.count = 1, .reusable = false}}, SHIFT(97),
  [812] = {.entry = {.count = 1, .reusable = false}}, SHIFT(81),
  [814] = {.entry = {.count = 1, .reusable = false}}, SHIFT(91),
  [816] = {.entry = {.count = 1, .reusable = false}}, SHIFT(119),
  [818] = {.entry = {.count = 1, .reusable = false}}, SHIFT(118),
  [820] = {.entry = {.count = 1, .reusable = false}}, SHIFT(122),
  [822] = {.entry = {.count = 1, .reusable = false}}, SHIFT(121),
  [824] = {.entry = {.count = 1, .reusable = false}}, SHIFT(127),
  [826] = {.entry = {.count = 1, .reusable = false}}, SHIFT(123),
  [828] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_when_clause, 5, 1, 60), SHIFT(133),
  [831] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_elsif_clause, 5, 1, 69), SHIFT(133),
  [834] = {.entry = {.count = 1, .reusable = false}}, SHIFT(124),
  [836] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_when_clause, 4, 1, 48), SHIFT(133),
  [839] = {.entry = {.count = 1, .reusable = false}}, SHIFT(113),
  [841] = {.entry = {.count = 1, .reusable = false}}, SHIFT(82),
  [843] = {.entry = {.count = 1, .reusable = false}}, SHIFT(111),
  [845] = {.entry = {.count = 1, .reusable = false}}, SHIFT(85),
  [847] = {.entry = {.count = 1, .reusable = false}}, SHIFT(90),
  [849] = {.entry = {.count = 1, .reusable = false}}, SHIFT(132),
  [851] = {.entry = {.count = 1, .reusable = false}}, SHIFT(130),
  [853] = {.entry = {.count = 1, .reusable = false}}, SHIFT(131),
  [855] = {.entry = {.count = 1, .reusable = false}}, SHIFT(103),
  [857] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_else_clause, 4, 2, 58), SHIFT(133),
  [860] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_elsif_clause, 4, 1, 48), SHIFT(133),
  [863] = {.entry = {.count = 1, .reusable = false}}, SHIFT(120),
  [865] = {.entry = {.count = 1, .reusable = false}}, SHIFT(110),
  [867] = {.entry = {.count = 1, .reusable = false}}, SHIFT(108),
  [869] = {.entry = {.count = 1, .reusable = false}}, SHIFT(107),
  [871] = {.entry = {.count = 1, .reusable = false}}, SHIFT(102),
  [873] = {.entry = {.count = 1, .reusable = false}}, SHIFT(109),
  [875] = {.entry = {.count = 1, .reusable = false}}, SHIFT(98),
  [877] = {.entry = {.count = 1, .reusable = false}}, SHIFT(96),
  [879] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_javascript_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(407),
  [882] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_javascript_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(407),
  [885] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_javascript_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(133),
  [888] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_javascript_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(340),
  [891] = {.entry = {.count = 1, .reusable = false}}, SHIFT(84),
  [893] = {.entry = {.count = 1, .reusable = false}}, SHIFT(88),
  [895] = {.entry = {.count = 1, .reusable = false}}, SHIFT(89),
  [897] = {.entry = {.count = 1, .reusable = false}}, SHIFT(112),
  [899] = {.entry = {.count = 1, .reusable = false}}, SHIFT(83),
  [901] = {.entry = {.count = 1, .reusable = false}}, SHIFT(114),
  [903] = {.entry = {.count = 1, .reusable = false}}, SHIFT(104),
  [905] = {.entry = {.count = 1, .reusable = false}}, SHIFT(86),
  [907] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_style_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(407),
  [910] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_style_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(407),
  [913] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_style_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(133),
  [916] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_style_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(340),
  [919] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_argument_list_repeat1, 2, 0, 0), SHIFT_REPEAT(385),
  [922] = {.entry = {.count = 1, .reusable = true}}, SHIFT(387),
  [924] = {.entry = {.count = 1, .reusable = true}}, SHIFT(386),
  [926] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1124),
  [928] = {.entry = {.count = 1, .reusable = true}}, SHIFT(742),
  [930] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_custom_unpaired_statement_repeat1, 1, 0, 0),
  [932] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_custom_unpaired_statement_repeat1, 1, 0, 0),
  [934] = {.entry = {.count = 1, .reusable = false}}, SHIFT(376),
  [936] = {.entry = {.count = 1, .reusable = false}}, SHIFT(367),
  [938] = {.entry = {.count = 1, .reusable = false}}, SHIFT(368),
  [940] = {.entry = {.count = 1, .reusable = false}}, SHIFT(366),
  [942] = {.entry = {.count = 1, .reusable = false}}, SHIFT(369),
  [944] = {.entry = {.count = 1, .reusable = false}}, SHIFT(363),
  [946] = {.entry = {.count = 1, .reusable = false}}, SHIFT(360),
  [948] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1147),
  [950] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_argument_list_repeat1, 2, 0, 0), SHIFT_REPEAT(386),
  [953] = {.entry = {.count = 1, .reusable = true}}, SHIFT(389),
  [955] = {.entry = {.count = 1, .reusable = true}}, SHIFT(384),
  [957] = {.entry = {.count = 1, .reusable = false}}, SHIFT(390),
  [959] = {.entry = {.count = 1, .reusable = false}}, SHIFT(383),
  [961] = {.entry = {.count = 1, .reusable = true}}, SHIFT(380),
  [963] = {.entry = {.count = 1, .reusable = true}}, SHIFT(338),
  [965] = {.entry = {.count = 1, .reusable = false}}, SHIFT(338),
  [967] = {.entry = {.count = 1, .reusable = true}}, SHIFT(337),
  [969] = {.entry = {.count = 1, .reusable = false}}, SHIFT(337),
  [971] = {.entry = {.count = 1, .reusable = true}}, SHIFT(335),
  [973] = {.entry = {.count = 1, .reusable = true}}, SHIFT(327),
  [975] = {.entry = {.count = 1, .reusable = false}}, SHIFT(327),
  [977] = {.entry = {.count = 1, .reusable = false}}, SHIFT(329),
  [979] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_argument_list_repeat1, 2, 0, 0), SHIFT_REPEAT(383),
  [982] = {.entry = {.count = 1, .reusable = false}}, SHIFT(381),
  [984] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__include_param, 3, 0, 0),
  [986] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__include_param, 3, 0, 0),
  [988] = {.entry = {.count = 1, .reusable = false}}, SHIFT(326),
  [990] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1114),
  [992] = {.entry = {.count = 1, .reusable = true}}, SHIFT(264),
  [994] = {.entry = {.count = 1, .reusable = true}}, SHIFT(329),
  [996] = {.entry = {.count = 1, .reusable = true}}, SHIFT(326),
  [998] = {.entry = {.count = 1, .reusable = true}}, SHIFT(721),
  [1000] = {.entry = {.count = 1, .reusable = false}}, SHIFT(44),
  [1002] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_custom_unpaired_statement, 2, 0, 1),
  [1004] = {.entry = {.count = 1, .reusable = false}}, SHIFT(346),
  [1006] = {.entry = {.count = 1, .reusable = true}}, SHIFT(346),
  [1008] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1148),
  [1010] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1139),
  [1012] = {.entry = {.count = 1, .reusable = true}}, SHIFT(229),
  [1014] = {.entry = {.count = 1, .reusable = false}}, SHIFT(42),
  [1016] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_custom_unpaired_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(44),
  [1019] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_custom_unpaired_statement_repeat1, 2, 0, 0),
  [1021] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_custom_unpaired_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(346),
  [1024] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_custom_unpaired_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(346),
  [1027] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_custom_unpaired_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(1148),
  [1030] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_custom_unpaired_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(1139),
  [1033] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_custom_unpaired_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(229),
  [1036] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_custom_unpaired_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(42),
  [1039] = {.entry = {.count = 1, .reusable = false}}, SHIFT(350),
  [1041] = {.entry = {.count = 1, .reusable = false}}, SHIFT(349),
  [1043] = {.entry = {.count = 1, .reusable = true}}, SHIFT(46),
  [1045] = {.entry = {.count = 1, .reusable = true}}, SHIFT(201),
  [1047] = {.entry = {.count = 1, .reusable = true}}, SHIFT(146),
  [1049] = {.entry = {.count = 1, .reusable = false}}, SHIFT(325),
  [1051] = {.entry = {.count = 1, .reusable = false}}, SHIFT(348),
  [1053] = {.entry = {.count = 1, .reusable = false}}, SHIFT(347),
  [1055] = {.entry = {.count = 1, .reusable = true}}, SHIFT(240),
  [1057] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_assignment_statement, 4, 0, 23),
  [1059] = {.entry = {.count = 1, .reusable = true}}, SHIFT(152),
  [1061] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_echo_statement, 2, 0, 0),
  [1063] = {.entry = {.count = 1, .reusable = false}}, SHIFT(341),
  [1065] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1094),
  [1067] = {.entry = {.count = 1, .reusable = true}}, SHIFT(302),
  [1069] = {.entry = {.count = 1, .reusable = true}}, SHIFT(693),
  [1071] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_custom_unpaired_statement, 1, 0, 1),
  [1073] = {.entry = {.count = 1, .reusable = true}}, SHIFT(657),
  [1075] = {.entry = {.count = 1, .reusable = true}}, SHIFT(192),
  [1077] = {.entry = {.count = 1, .reusable = true}}, SHIFT(501),
  [1079] = {.entry = {.count = 1, .reusable = true}}, SHIFT(145),
  [1081] = {.entry = {.count = 1, .reusable = true}}, SHIFT(154),
  [1083] = {.entry = {.count = 1, .reusable = false}}, SHIFT(252),
  [1085] = {.entry = {.count = 1, .reusable = false}}, SHIFT(359),
  [1087] = {.entry = {.count = 1, .reusable = true}}, SHIFT(359),
  [1089] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1184),
  [1091] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1183),
  [1093] = {.entry = {.count = 1, .reusable = true}}, SHIFT(279),
  [1095] = {.entry = {.count = 1, .reusable = false}}, SHIFT(260),
  [1097] = {.entry = {.count = 1, .reusable = true}}, SHIFT(136),
  [1099] = {.entry = {.count = 1, .reusable = true}}, SHIFT(144),
  [1101] = {.entry = {.count = 1, .reusable = false}}, SHIFT(52),
  [1103] = {.entry = {.count = 1, .reusable = true}}, SHIFT(56),
  [1105] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_custom_unpaired_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(227),
  [1108] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_custom_unpaired_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(364),
  [1111] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_custom_unpaired_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(1052),
  [1114] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_custom_unpaired_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(1215),
  [1117] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_custom_unpaired_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(244),
  [1120] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_custom_unpaired_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(234),
  [1123] = {.entry = {.count = 1, .reusable = false}}, SHIFT(645),
  [1125] = {.entry = {.count = 1, .reusable = true}}, SHIFT(727),
  [1127] = {.entry = {.count = 1, .reusable = true}}, SHIFT(352),
  [1129] = {.entry = {.count = 1, .reusable = true}}, SHIFT(351),
  [1131] = {.entry = {.count = 1, .reusable = false}}, SHIFT(277),
  [1133] = {.entry = {.count = 1, .reusable = true}}, SHIFT(317),
  [1135] = {.entry = {.count = 1, .reusable = true}}, SHIFT(289),
  [1137] = {.entry = {.count = 1, .reusable = false}}, SHIFT(249),
  [1139] = {.entry = {.count = 1, .reusable = true}}, SHIFT(267),
  [1141] = {.entry = {.count = 1, .reusable = true}}, SHIFT(270),
  [1143] = {.entry = {.count = 1, .reusable = true}}, SHIFT(296),
  [1145] = {.entry = {.count = 1, .reusable = true}}, SHIFT(269),
  [1147] = {.entry = {.count = 1, .reusable = true}}, SHIFT(4),
  [1149] = {.entry = {.count = 1, .reusable = true}}, SHIFT(284),
  [1151] = {.entry = {.count = 1, .reusable = true}}, SHIFT(308),
  [1153] = {.entry = {.count = 1, .reusable = true}}, SHIFT(313),
  [1155] = {.entry = {.count = 1, .reusable = true}}, SHIFT(299),
  [1157] = {.entry = {.count = 1, .reusable = true}}, SHIFT(271),
  [1159] = {.entry = {.count = 1, .reusable = true}}, SHIFT(303),
  [1161] = {.entry = {.count = 1, .reusable = true}}, SHIFT(272),
  [1163] = {.entry = {.count = 1, .reusable = true}}, SHIFT(274),
  [1165] = {.entry = {.count = 1, .reusable = true}}, SHIFT(291),
  [1167] = {.entry = {.count = 1, .reusable = true}}, SHIFT(305),
  [1169] = {.entry = {.count = 1, .reusable = true}}, SHIFT(293),
  [1171] = {.entry = {.count = 1, .reusable = true}}, SHIFT(2),
  [1173] = {.entry = {.count = 1, .reusable = true}}, SHIFT(292),
  [1175] = {.entry = {.count = 1, .reusable = true}}, SHIFT(3),
  [1177] = {.entry = {.count = 1, .reusable = true}}, SHIFT(297),
  [1179] = {.entry = {.count = 1, .reusable = true}}, SHIFT(290),
  [1181] = {.entry = {.count = 1, .reusable = true}}, SHIFT(295),
  [1183] = {.entry = {.count = 1, .reusable = true}}, SHIFT(301),
  [1185] = {.entry = {.count = 1, .reusable = true}}, SHIFT(307),
  [1187] = {.entry = {.count = 1, .reusable = true}}, SHIFT(311),
  [1189] = {.entry = {.count = 1, .reusable = true}}, SHIFT(47),
  [1191] = {.entry = {.count = 1, .reusable = true}}, SHIFT(48),
  [1193] = {.entry = {.count = 1, .reusable = true}}, SHIFT(49),
  [1195] = {.entry = {.count = 1, .reusable = true}}, SHIFT(51),
  [1197] = {.entry = {.count = 1, .reusable = true}}, SHIFT(310),
  [1199] = {.entry = {.count = 1, .reusable = true}}, SHIFT(53),
  [1201] = {.entry = {.count = 1, .reusable = true}}, SHIFT(309),
  [1203] = {.entry = {.count = 1, .reusable = true}}, SHIFT(54),
  [1205] = {.entry = {.count = 1, .reusable = true}}, SHIFT(285),
  [1207] = {.entry = {.count = 1, .reusable = true}}, SHIFT(364),
  [1209] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1052),
  [1211] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1215),
  [1213] = {.entry = {.count = 1, .reusable = true}}, SHIFT(238),
  [1215] = {.entry = {.count = 1, .reusable = true}}, SHIFT(286),
  [1217] = {.entry = {.count = 1, .reusable = true}}, SHIFT(300),
  [1219] = {.entry = {.count = 1, .reusable = true}}, SHIFT(246),
  [1221] = {.entry = {.count = 1, .reusable = true}}, SHIFT(294),
  [1223] = {.entry = {.count = 1, .reusable = true}}, SHIFT(298),
  [1225] = {.entry = {.count = 1, .reusable = true}}, SHIFT(236),
  [1227] = {.entry = {.count = 1, .reusable = true}}, SHIFT(245),
  [1229] = {.entry = {.count = 1, .reusable = true}}, SHIFT(241),
  [1231] = {.entry = {.count = 1, .reusable = true}}, SHIFT(237),
  [1233] = {.entry = {.count = 1, .reusable = false}}, SHIFT(254),
  [1235] = {.entry = {.count = 1, .reusable = true}}, SHIFT(275),
  [1237] = {.entry = {.count = 1, .reusable = false}}, SHIFT(546),
  [1239] = {.entry = {.count = 1, .reusable = false}}, SHIFT(39),
  [1241] = {.entry = {.count = 1, .reusable = true}}, SHIFT(38),
  [1243] = {.entry = {.count = 1, .reusable = false}}, SHIFT(140),
  [1245] = {.entry = {.count = 1, .reusable = false}}, SHIFT(171),
  [1247] = {.entry = {.count = 1, .reusable = true}}, SHIFT(226),
  [1249] = {.entry = {.count = 1, .reusable = false}}, SHIFT(531),
  [1251] = {.entry = {.count = 1, .reusable = false}}, SHIFT(228),
  [1253] = {.entry = {.count = 1, .reusable = true}}, SHIFT(253),
  [1255] = {.entry = {.count = 1, .reusable = false}}, SHIFT(22),
  [1257] = {.entry = {.count = 1, .reusable = true}}, SHIFT(41),
  [1259] = {.entry = {.count = 1, .reusable = false}}, SHIFT(257),
  [1261] = {.entry = {.count = 1, .reusable = true}}, SHIFT(282),
  [1263] = {.entry = {.count = 1, .reusable = false}}, SHIFT(666),
  [1265] = {.entry = {.count = 1, .reusable = false}}, SHIFT(208),
  [1267] = {.entry = {.count = 1, .reusable = true}}, SHIFT(232),
  [1269] = {.entry = {.count = 1, .reusable = false}}, SHIFT(242),
  [1271] = {.entry = {.count = 1, .reusable = true}}, SHIFT(255),
  [1273] = {.entry = {.count = 1, .reusable = false}}, SHIFT(247),
  [1275] = {.entry = {.count = 1, .reusable = true}}, SHIFT(256),
  [1277] = {.entry = {.count = 1, .reusable = false}}, SHIFT(26),
  [1279] = {.entry = {.count = 1, .reusable = true}}, SHIFT(43),
  [1281] = {.entry = {.count = 1, .reusable = false}}, SHIFT(690),
  [1283] = {.entry = {.count = 1, .reusable = false}}, SHIFT(263),
  [1285] = {.entry = {.count = 1, .reusable = true}}, SHIFT(281),
  [1287] = {.entry = {.count = 1, .reusable = false}}, SHIFT(220),
  [1289] = {.entry = {.count = 1, .reusable = true}}, SHIFT(230),
  [1291] = {.entry = {.count = 1, .reusable = true}}, SHIFT(12),
  [1293] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1071),
  [1295] = {.entry = {.count = 1, .reusable = true}}, SHIFT(319),
  [1297] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_template_content_repeat1, 2, 0, 0),
  [1299] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_template_content_repeat1, 2, 0, 0), SHIFT_REPEAT(393),
  [1302] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_template_content_repeat1, 2, 0, 0), SHIFT_REPEAT(393),
  [1305] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_template_content_repeat1, 2, 0, 0),
  [1307] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_template_content, 1, 0, 0),
  [1309] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_template_content, 1, 0, 0), SHIFT(393),
  [1312] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_template_content, 1, 0, 0), SHIFT(393),
  [1315] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_template_content, 1, 0, 0),
  [1317] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_loop_statement, 10, 0, 76),
  [1319] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_for_loop_statement, 10, 0, 76),
  [1321] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unless_statement, 9, 0, 72),
  [1323] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unless_statement, 9, 0, 72),
  [1325] = {.entry = {.count = 1, .reusable = true}}, SHIFT(330),
  [1327] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1154),
  [1329] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1186),
  [1331] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1191),
  [1333] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1138),
  [1335] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1142),
  [1337] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_style_statement, 6, 0, 0),
  [1339] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_style_statement, 6, 0, 0),
  [1341] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_case_statement, 7, 0, 49),
  [1343] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_case_statement, 7, 0, 49),
  [1345] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_javascript_statement, 6, 0, 0),
  [1347] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_javascript_statement, 6, 0, 0),
  [1349] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unless_statement, 7, 0, 48),
  [1351] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unless_statement, 7, 0, 48),
  [1353] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_template_content_repeat1, 2, 0, 0), SHIFT_REPEAT(406),
  [1356] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_template_content_repeat1, 2, 0, 0), SHIFT_REPEAT(406),
  [1359] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_template_content, 1, 0, 0), SHIFT(406),
  [1362] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_template_content, 1, 0, 0), SHIFT(406),
  [1365] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_comment, 1, 0, 0),
  [1367] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_comment, 1, 0, 0),
  [1369] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_loop_statement, 11, 0, 78),
  [1371] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_for_loop_statement, 11, 0, 78),
  [1373] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_paginate_statement, 10, 0, 76),
  [1375] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_paginate_statement, 10, 0, 76),
  [1377] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_capture_statement, 7, 0, 50),
  [1379] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_capture_statement, 7, 0, 50),
  [1381] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_form_statement, 7, 0, 51),
  [1383] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_form_statement, 7, 0, 51),
  [1385] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tablerow_statement, 10, 0, 76),
  [1387] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tablerow_statement, 10, 0, 76),
  [1389] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_schema_statement, 7, 0, 53),
  [1391] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_schema_statement, 7, 0, 53),
  [1393] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_style_statement, 7, 0, 0),
  [1395] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_style_statement, 7, 0, 0),
  [1397] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_javascript_statement, 7, 0, 0),
  [1399] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_javascript_statement, 7, 0, 0),
  [1401] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_raw_statement, 7, 0, 0),
  [1403] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_raw_statement, 7, 0, 0),
  [1405] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__paired_comment, 7, 0, 54),
  [1407] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__paired_comment, 7, 0, 54),
  [1409] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_form_statement, 10, 0, 74),
  [1411] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_form_statement, 10, 0, 74),
  [1413] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unless_statement, 10, 0, 77),
  [1415] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unless_statement, 10, 0, 77),
  [1417] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 10, 0, 77),
  [1419] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 10, 0, 77),
  [1421] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_program_repeat1, 1, 0, 0),
  [1423] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 1, 0, 0),
  [1425] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_loop_statement, 10, 0, 75),
  [1427] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_for_loop_statement, 10, 0, 75),
  [1429] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 8, 0, 59),
  [1431] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 8, 0, 59),
  [1433] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 8, 0, 60),
  [1435] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 8, 0, 60),
  [1437] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_paginate_statement, 9, 0, 68),
  [1439] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_paginate_statement, 9, 0, 68),
  [1441] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 8, 0, 61),
  [1443] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 8, 0, 61),
  [1445] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_case_statement, 8, 0, 62),
  [1447] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_case_statement, 8, 0, 62),
  [1449] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_case_statement, 8, 0, 63),
  [1451] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_case_statement, 8, 0, 63),
  [1453] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unless_statement, 8, 0, 59),
  [1455] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unless_statement, 8, 0, 59),
  [1457] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unless_statement, 8, 0, 60),
  [1459] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unless_statement, 8, 0, 60),
  [1461] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tablerow_statement, 9, 0, 68),
  [1463] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tablerow_statement, 9, 0, 68),
  [1465] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unless_statement, 8, 0, 61),
  [1467] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unless_statement, 8, 0, 61),
  [1469] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_capture_statement, 8, 0, 64),
  [1471] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_capture_statement, 8, 0, 64),
  [1473] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_form_statement, 8, 0, 51),
  [1475] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_form_statement, 8, 0, 51),
  [1477] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_form_statement, 9, 0, 74),
  [1479] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_form_statement, 9, 0, 74),
  [1481] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__output_statement, 3, 0, 0),
  [1483] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__output_statement, 3, 0, 0),
  [1485] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unless_statement, 9, 0, 71),
  [1487] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unless_statement, 9, 0, 71),
  [1489] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__inline_comment, 3, 0, 0),
  [1491] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__inline_comment, 3, 0, 0),
  [1493] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__tagged_unpaired_statement, 3, 0, 0),
  [1495] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__tagged_unpaired_statement, 3, 0, 0),
  [1497] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unless_statement, 9, 0, 70),
  [1499] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unless_statement, 9, 0, 70),
  [1501] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_case_statement, 9, 0, 73),
  [1503] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_case_statement, 9, 0, 73),
  [1505] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 9, 0, 72),
  [1507] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 9, 0, 72),
  [1509] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_raw_statement, 8, 0, 0),
  [1511] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_raw_statement, 8, 0, 0),
  [1513] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__paired_comment, 8, 0, 65),
  [1515] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__paired_comment, 8, 0, 65),
  [1517] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_loop_statement, 9, 0, 68),
  [1519] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_for_loop_statement, 9, 0, 68),
  [1521] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 9, 0, 71),
  [1523] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 9, 0, 71),
  [1525] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 9, 0, 70),
  [1527] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 9, 0, 70),
  [1529] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 7, 0, 48),
  [1531] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 7, 0, 48),
  [1533] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__if_liq_repeat2, 2, 0, 33),
  [1535] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__if_liq_repeat2, 2, 0, 33), SHIFT_REPEAT(330),
  [1538] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_style_statement_repeat1, 1, 0, 11),
  [1540] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_style_statement_repeat1, 1, 0, 11),
  [1542] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_javascript_statement_repeat1, 1, 0, 12),
  [1544] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_javascript_statement_repeat1, 1, 0, 12),
  [1546] = {.entry = {.count = 1, .reusable = false}}, SHIFT(336),
  [1548] = {.entry = {.count = 1, .reusable = true}}, SHIFT(336),
  [1550] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1184),
  [1552] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1183),
  [1554] = {.entry = {.count = 1, .reusable = false}}, SHIFT(710),
  [1556] = {.entry = {.count = 1, .reusable = true}}, SHIFT(668),
  [1558] = {.entry = {.count = 1, .reusable = true}}, SHIFT(745),
  [1560] = {.entry = {.count = 1, .reusable = true}}, SHIFT(406),
  [1562] = {.entry = {.count = 1, .reusable = false}}, SHIFT(406),
  [1564] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_cycle_statement, 2, 0, 8),
  [1566] = {.entry = {.count = 1, .reusable = true}}, SHIFT(671),
  [1568] = {.entry = {.count = 1, .reusable = true}}, SHIFT(697),
  [1570] = {.entry = {.count = 1, .reusable = true}}, SHIFT(773),
  [1572] = {.entry = {.count = 1, .reusable = true}}, SHIFT(673),
  [1574] = {.entry = {.count = 1, .reusable = true}}, SHIFT(729),
  [1576] = {.entry = {.count = 1, .reusable = true}}, SHIFT(682),
  [1578] = {.entry = {.count = 1, .reusable = true}}, SHIFT(774),
  [1580] = {.entry = {.count = 1, .reusable = false}}, SHIFT(361),
  [1582] = {.entry = {.count = 1, .reusable = true}}, SHIFT(361),
  [1584] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1057),
  [1586] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1058),
  [1588] = {.entry = {.count = 1, .reusable = false}}, SHIFT(736),
  [1590] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_cycle_statement, 4, 0, 24),
  [1592] = {.entry = {.count = 1, .reusable = true}}, SHIFT(731),
  [1594] = {.entry = {.count = 1, .reusable = true}}, SHIFT(826),
  [1596] = {.entry = {.count = 1, .reusable = true}}, SHIFT(689),
  [1598] = {.entry = {.count = 1, .reusable = true}}, SHIFT(786),
  [1600] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__case_liq_repeat1, 2, 0, 0),
  [1602] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__case_liq_repeat1, 2, 0, 0), SHIFT_REPEAT(319),
  [1605] = {.entry = {.count = 1, .reusable = true}}, SHIFT(321),
  [1607] = {.entry = {.count = 1, .reusable = true}}, SHIFT(778),
  [1609] = {.entry = {.count = 1, .reusable = false}}, SHIFT(802),
  [1611] = {.entry = {.count = 1, .reusable = true}}, SHIFT(801),
  [1613] = {.entry = {.count = 1, .reusable = true}}, SHIFT(137),
  [1615] = {.entry = {.count = 1, .reusable = false}}, SHIFT(800),
  [1617] = {.entry = {.count = 1, .reusable = true}}, SHIFT(762),
  [1619] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_cycle_statement_repeat1, 2, 0, 0),
  [1621] = {.entry = {.count = 1, .reusable = true}}, SHIFT(199),
  [1623] = {.entry = {.count = 1, .reusable = true}}, SHIFT(372),
  [1625] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1106),
  [1627] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_include_statement, 5, 0, 0),
  [1629] = {.entry = {.count = 1, .reusable = true}}, SHIFT(701),
  [1631] = {.entry = {.count = 1, .reusable = false}}, SHIFT(771),
  [1633] = {.entry = {.count = 1, .reusable = true}}, SHIFT(771),
  [1635] = {.entry = {.count = 1, .reusable = false}}, SHIFT(674),
  [1637] = {.entry = {.count = 1, .reusable = true}}, SHIFT(670),
  [1639] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_include_statement, 4, 0, 0),
  [1641] = {.entry = {.count = 1, .reusable = true}}, SHIFT(16),
  [1643] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_include_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(1106),
  [1646] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_include_statement_repeat1, 2, 0, 0),
  [1648] = {.entry = {.count = 1, .reusable = true}}, SHIFT(667),
  [1650] = {.entry = {.count = 1, .reusable = false}}, SHIFT(667),
  [1652] = {.entry = {.count = 1, .reusable = false}}, SHIFT(767),
  [1654] = {.entry = {.count = 1, .reusable = true}}, SHIFT(766),
  [1656] = {.entry = {.count = 1, .reusable = false}}, SHIFT(765),
  [1658] = {.entry = {.count = 1, .reusable = true}}, SHIFT(765),
  [1660] = {.entry = {.count = 1, .reusable = false}}, SHIFT(764),
  [1662] = {.entry = {.count = 1, .reusable = true}}, SHIFT(763),
  [1664] = {.entry = {.count = 1, .reusable = true}}, SHIFT(195),
  [1666] = {.entry = {.count = 1, .reusable = true}}, SHIFT(374),
  [1668] = {.entry = {.count = 1, .reusable = false}}, SHIFT(758),
  [1670] = {.entry = {.count = 1, .reusable = true}}, SHIFT(757),
  [1672] = {.entry = {.count = 1, .reusable = false}}, SHIFT(750),
  [1674] = {.entry = {.count = 1, .reusable = true}}, SHIFT(759),
  [1676] = {.entry = {.count = 1, .reusable = false}}, SHIFT(779),
  [1678] = {.entry = {.count = 1, .reusable = true}}, SHIFT(779),
  [1680] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_include_statement, 3, 0, 0),
  [1682] = {.entry = {.count = 1, .reusable = false}}, SHIFT(790),
  [1684] = {.entry = {.count = 1, .reusable = true}}, SHIFT(791),
  [1686] = {.entry = {.count = 1, .reusable = true}}, SHIFT(684),
  [1688] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_include_statement, 2, 0, 0),
  [1690] = {.entry = {.count = 1, .reusable = false}}, SHIFT(793),
  [1692] = {.entry = {.count = 1, .reusable = true}}, SHIFT(793),
  [1694] = {.entry = {.count = 1, .reusable = false}}, SHIFT(795),
  [1696] = {.entry = {.count = 1, .reusable = true}}, SHIFT(796),
  [1698] = {.entry = {.count = 1, .reusable = true}}, SHIFT(377),
  [1700] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_render_statement, 2, 0, 9),
  [1702] = {.entry = {.count = 1, .reusable = true}}, SHIFT(378),
  [1704] = {.entry = {.count = 1, .reusable = true}}, SHIFT(934),
  [1706] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1037),
  [1708] = {.entry = {.count = 1, .reusable = true}}, SHIFT(656),
  [1710] = {.entry = {.count = 1, .reusable = true}}, SHIFT(717),
  [1712] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__inline_comment_repeat1, 2, 0, 0),
  [1714] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__inline_comment_repeat1, 2, 0, 0), SHIFT_REPEAT(717),
  [1717] = {.entry = {.count = 1, .reusable = true}}, SHIFT(713),
  [1719] = {.entry = {.count = 1, .reusable = true}}, SHIFT(780),
  [1721] = {.entry = {.count = 1, .reusable = true}}, SHIFT(911),
  [1723] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_include_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(1093),
  [1726] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1093),
  [1728] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_argument_list_repeat1, 2, 0, 0), SHIFT_REPEAT(384),
  [1731] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_case_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(1205),
  [1734] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_case_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(1205),
  [1737] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_if_statement_repeat1, 2, 0, 33), SHIFT_REPEAT(1065),
  [1740] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_if_statement_repeat1, 2, 0, 33), SHIFT_REPEAT(1065),
  [1743] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_cycle_statement, 5, 0, 37),
  [1745] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1207),
  [1747] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_cycle_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(671),
  [1750] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_cycle_statement_repeat1, 2, 0, 0),
  [1752] = {.entry = {.count = 1, .reusable = true}}, SHIFT(688),
  [1754] = {.entry = {.count = 1, .reusable = true}}, SHIFT(153),
  [1756] = {.entry = {.count = 1, .reusable = true}}, SHIFT(162),
  [1758] = {.entry = {.count = 1, .reusable = false}}, SHIFT(371),
  [1760] = {.entry = {.count = 1, .reusable = false}}, SHIFT(945),
  [1762] = {.entry = {.count = 1, .reusable = false}}, SHIFT(946),
  [1764] = {.entry = {.count = 1, .reusable = false}}, SHIFT(675),
  [1766] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1091),
  [1768] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__if_liq_repeat2, 1, 0, 18),
  [1770] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__elsif_aliased, 1, 0, 17),
  [1772] = {.entry = {.count = 1, .reusable = true}}, SHIFT(505),
  [1774] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1088),
  [1776] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1054),
  [1778] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1070),
  [1780] = {.entry = {.count = 1, .reusable = true}}, SHIFT(705),
  [1782] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_cycle_statement, 3, 0, 10),
  [1784] = {.entry = {.count = 1, .reusable = true}}, SHIFT(993),
  [1786] = {.entry = {.count = 1, .reusable = true}}, SHIFT(339),
  [1788] = {.entry = {.count = 1, .reusable = true}}, SHIFT(897),
  [1790] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__render_param, 1, 0, 0),
  [1792] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1161),
  [1794] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1041),
  [1796] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1041),
  [1798] = {.entry = {.count = 1, .reusable = true}}, SHIFT(743),
  [1800] = {.entry = {.count = 1, .reusable = true}}, SHIFT(734),
  [1802] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1059),
  [1804] = {.entry = {.count = 1, .reusable = true}}, SHIFT(147),
  [1806] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1000),
  [1808] = {.entry = {.count = 1, .reusable = true}}, SHIFT(999),
  [1810] = {.entry = {.count = 1, .reusable = true}}, SHIFT(994),
  [1812] = {.entry = {.count = 1, .reusable = false}}, SHIFT(927),
  [1814] = {.entry = {.count = 1, .reusable = true}}, SHIFT(927),
  [1816] = {.entry = {.count = 1, .reusable = false}}, SHIFT(920),
  [1818] = {.entry = {.count = 1, .reusable = true}}, SHIFT(920),
  [1820] = {.entry = {.count = 1, .reusable = true}}, SHIFT(882),
  [1822] = {.entry = {.count = 1, .reusable = true}}, SHIFT(983),
  [1824] = {.entry = {.count = 1, .reusable = true}}, SHIFT(982),
  [1826] = {.entry = {.count = 1, .reusable = true}}, SHIFT(803),
  [1828] = {.entry = {.count = 1, .reusable = true}}, SHIFT(315),
  [1830] = {.entry = {.count = 1, .reusable = true}}, SHIFT(977),
  [1832] = {.entry = {.count = 1, .reusable = true}}, SHIFT(976),
  [1834] = {.entry = {.count = 1, .reusable = false}}, SHIFT(916),
  [1836] = {.entry = {.count = 1, .reusable = true}}, SHIFT(916),
  [1838] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__when_aliased, 1, 0, 20),
  [1840] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__case_liq_repeat1, 1, 0, 0),
  [1842] = {.entry = {.count = 1, .reusable = true}}, SHIFT(961),
  [1844] = {.entry = {.count = 1, .reusable = false}}, SHIFT(915),
  [1846] = {.entry = {.count = 1, .reusable = true}}, SHIFT(915),
  [1848] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1040),
  [1850] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1040),
  [1852] = {.entry = {.count = 1, .reusable = true}}, SHIFT(789),
  [1854] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1164),
  [1856] = {.entry = {.count = 1, .reusable = true}}, SHIFT(890),
  [1858] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1211),
  [1860] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_cycle_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(674),
  [1863] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1124),
  [1865] = {.entry = {.count = 1, .reusable = true}}, SHIFT(798),
  [1867] = {.entry = {.count = 1, .reusable = true}}, SHIFT(843),
  [1869] = {.entry = {.count = 1, .reusable = true}}, SHIFT(842),
  [1871] = {.entry = {.count = 1, .reusable = true}}, SHIFT(836),
  [1873] = {.entry = {.count = 1, .reusable = true}}, SHIFT(718),
  [1875] = {.entry = {.count = 1, .reusable = true}}, SHIFT(829),
  [1877] = {.entry = {.count = 1, .reusable = true}}, SHIFT(828),
  [1879] = {.entry = {.count = 1, .reusable = true}}, SHIFT(799),
  [1881] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1231),
  [1883] = {.entry = {.count = 1, .reusable = true}}, SHIFT(142),
  [1885] = {.entry = {.count = 1, .reusable = true}}, SHIFT(878),
  [1887] = {.entry = {.count = 1, .reusable = true}}, SHIFT(913),
  [1889] = {.entry = {.count = 1, .reusable = true}}, SHIFT(903),
  [1891] = {.entry = {.count = 1, .reusable = true}}, SHIFT(595),
  [1893] = {.entry = {.count = 1, .reusable = true}}, SHIFT(196),
  [1895] = {.entry = {.count = 1, .reusable = true}}, SHIFT(794),
  [1897] = {.entry = {.count = 1, .reusable = true}}, SHIFT(527),
  [1899] = {.entry = {.count = 1, .reusable = true}}, SHIFT(528),
  [1901] = {.entry = {.count = 1, .reusable = true}}, SHIFT(525),
  [1903] = {.entry = {.count = 1, .reusable = true}}, SHIFT(526),
  [1905] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1076),
  [1907] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1077),
  [1909] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1220),
  [1911] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1219),
  [1913] = {.entry = {.count = 1, .reusable = true}}, SHIFT(517),
  [1915] = {.entry = {.count = 1, .reusable = true}}, SHIFT(518),
  [1917] = {.entry = {.count = 1, .reusable = true}}, SHIFT(515),
  [1919] = {.entry = {.count = 1, .reusable = true}}, SHIFT(516),
  [1921] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1083),
  [1923] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1214),
  [1925] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1213),
  [1927] = {.entry = {.count = 1, .reusable = true}}, SHIFT(696),
  [1929] = {.entry = {.count = 1, .reusable = true}}, SHIFT(732),
  [1931] = {.entry = {.count = 1, .reusable = true}}, SHIFT(187),
  [1933] = {.entry = {.count = 1, .reusable = true}}, SHIFT(186),
  [1935] = {.entry = {.count = 1, .reusable = true}}, SHIFT(197),
  [1937] = {.entry = {.count = 1, .reusable = true}}, SHIFT(188),
  [1939] = {.entry = {.count = 1, .reusable = true}}, SHIFT(198),
  [1941] = {.entry = {.count = 1, .reusable = true}}, SHIFT(165),
  [1943] = {.entry = {.count = 1, .reusable = true}}, SHIFT(166),
  [1945] = {.entry = {.count = 1, .reusable = true}}, SHIFT(512),
  [1947] = {.entry = {.count = 1, .reusable = true}}, SHIFT(511),
  [1949] = {.entry = {.count = 1, .reusable = true}}, SHIFT(492),
  [1951] = {.entry = {.count = 1, .reusable = true}}, SHIFT(491),
  [1953] = {.entry = {.count = 1, .reusable = true}}, SHIFT(184),
  [1955] = {.entry = {.count = 1, .reusable = true}}, SHIFT(487),
  [1957] = {.entry = {.count = 1, .reusable = true}}, SHIFT(488),
  [1959] = {.entry = {.count = 1, .reusable = true}}, SHIFT(485),
  [1961] = {.entry = {.count = 1, .reusable = true}}, SHIFT(486),
  [1963] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1130),
  [1965] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1128),
  [1967] = {.entry = {.count = 1, .reusable = true}}, SHIFT(747),
  [1969] = {.entry = {.count = 1, .reusable = true}}, SHIFT(479),
  [1971] = {.entry = {.count = 1, .reusable = true}}, SHIFT(478),
  [1973] = {.entry = {.count = 1, .reusable = true}}, SHIFT(215),
  [1975] = {.entry = {.count = 1, .reusable = true}}, SHIFT(218),
  [1977] = {.entry = {.count = 1, .reusable = true}}, SHIFT(476),
  [1979] = {.entry = {.count = 1, .reusable = true}}, SHIFT(475),
  [1981] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1240),
  [1983] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1131),
  [1985] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1144),
  [1987] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1144),
  [1989] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1143),
  [1991] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1143),
  [1993] = {.entry = {.count = 1, .reusable = true}}, SHIFT(471),
  [1995] = {.entry = {.count = 1, .reusable = true}}, SHIFT(472),
  [1997] = {.entry = {.count = 1, .reusable = true}}, SHIFT(469),
  [1999] = {.entry = {.count = 1, .reusable = true}}, SHIFT(470),
  [2001] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1173),
  [2003] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1171),
  [2005] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1135),
  [2007] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1136),
  [2009] = {.entry = {.count = 1, .reusable = true}}, SHIFT(463),
  [2011] = {.entry = {.count = 1, .reusable = true}}, SHIFT(462),
  [2013] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1133),
  [2015] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1134),
  [2017] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1233),
  [2019] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1234),
  [2021] = {.entry = {.count = 1, .reusable = true}}, SHIFT(524),
  [2023] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__render_param, 3, 0, 47),
  [2025] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1089),
  [2027] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1090),
  [2029] = {.entry = {.count = 1, .reusable = true}}, SHIFT(754),
  [2031] = {.entry = {.count = 1, .reusable = true}}, SHIFT(714),
  [2033] = {.entry = {.count = 1, .reusable = true}}, SHIFT(213),
  [2035] = {.entry = {.count = 1, .reusable = true}}, SHIFT(212),
  [2037] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1122),
  [2039] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1123),
  [2041] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1120),
  [2043] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1121),
  [2045] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1127),
  [2047] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1116),
  [2049] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1117),
  [2051] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1126),
  [2053] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1112),
  [2055] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1113),
  [2057] = {.entry = {.count = 1, .reusable = true}}, SHIFT(506),
  [2059] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1101),
  [2061] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1102),
  [2063] = {.entry = {.count = 1, .reusable = true}}, SHIFT(392),
  [2065] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1098),
  [2067] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1098),
  [2069] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1097),
  [2071] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1097),
  [2073] = {.entry = {.count = 1, .reusable = true}}, SHIFT(437),
  [2075] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1095),
  [2077] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1096),
  [2079] = {.entry = {.count = 1, .reusable = true}}, SHIFT(435),
  [2081] = {.entry = {.count = 1, .reusable = true}}, SHIFT(434),
  [2083] = {.entry = {.count = 1, .reusable = true}}, SHIFT(433),
  [2085] = {.entry = {.count = 1, .reusable = true}}, SHIFT(432),
  [2087] = {.entry = {.count = 1, .reusable = true}}, SHIFT(421),
  [2089] = {.entry = {.count = 1, .reusable = true}}, SHIFT(419),
  [2091] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1209),
  [2093] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1212),
  [2095] = {.entry = {.count = 1, .reusable = true}}, SHIFT(482),
  [2097] = {.entry = {.count = 1, .reusable = true}}, SHIFT(481),
  [2099] = {.entry = {.count = 1, .reusable = true}}, SHIFT(523),
  [2101] = {.entry = {.count = 1, .reusable = true}}, SHIFT(522),
  [2103] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1208),
  [2105] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1208),
  [2107] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1092),
  [2109] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1092),
  [2111] = {.entry = {.count = 1, .reusable = true}}, SHIFT(405),
  [2113] = {.entry = {.count = 1, .reusable = true}}, SHIFT(521),
  [2115] = {.entry = {.count = 1, .reusable = true}}, SHIFT(520),
  [2117] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1204),
  [2119] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1204),
  [2121] = {.entry = {.count = 1, .reusable = true}}, SHIFT(755),
  [2123] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1087),
  [2125] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1087),
  [2127] = {.entry = {.count = 1, .reusable = true}}, SHIFT(403),
  [2129] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1086),
  [2131] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1086),
  [2133] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1202),
  [2135] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1203),
  [2137] = {.entry = {.count = 1, .reusable = true}}, SHIFT(519),
  [2139] = {.entry = {.count = 1, .reusable = true}}, SHIFT(514),
  [2141] = {.entry = {.count = 1, .reusable = true}}, SHIFT(513),
  [2143] = {.entry = {.count = 1, .reusable = true}}, SHIFT(510),
  [2145] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1199),
  [2147] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1199),
  [2149] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1080),
  [2151] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1080),
  [2153] = {.entry = {.count = 1, .reusable = true}}, SHIFT(170),
  [2155] = {.entry = {.count = 1, .reusable = true}}, SHIFT(529),
  [2157] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1078),
  [2159] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1078),
  [2161] = {.entry = {.count = 1, .reusable = true}}, SHIFT(509),
  [2163] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1074),
  [2165] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1074),
  [2167] = {.entry = {.count = 1, .reusable = true}}, SHIFT(508),
  [2169] = {.entry = {.count = 1, .reusable = true}}, SHIFT(507),
  [2171] = {.entry = {.count = 1, .reusable = true}}, SHIFT(504),
  [2173] = {.entry = {.count = 1, .reusable = true}}, SHIFT(466),
  [2175] = {.entry = {.count = 1, .reusable = true}}, SHIFT(465),
  [2177] = {.entry = {.count = 1, .reusable = true}}, SHIFT(410),
  [2179] = {.entry = {.count = 1, .reusable = true}}, SHIFT(409),
  [2181] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1069),
  [2183] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1069),
  [2185] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_section_statement, 2, 0, 0),
  [2187] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sections_statement, 2, 0, 0),
  [2189] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_increment_statement, 2, 0, 0),
  [2191] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_decrement_statement, 2, 0, 0),
  [2193] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_layout_statement, 2, 0, 0),
  [2195] = {.entry = {.count = 1, .reusable = true}}, SHIFT(412),
  [2197] = {.entry = {.count = 1, .reusable = true}}, SHIFT(411),
  [2199] = {.entry = {.count = 1, .reusable = true}}, SHIFT(503),
  [2201] = {.entry = {.count = 1, .reusable = true}}, SHIFT(502),
  [2203] = {.entry = {.count = 1, .reusable = true}}, SHIFT(414),
  [2205] = {.entry = {.count = 1, .reusable = true}}, SHIFT(413),
  [2207] = {.entry = {.count = 1, .reusable = true}}, SHIFT(809),
  [2209] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1044),
  [2211] = {.entry = {.count = 1, .reusable = true}}, SHIFT(810),
  [2213] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1043),
  [2215] = {.entry = {.count = 1, .reusable = true}}, SHIFT(416),
  [2217] = {.entry = {.count = 1, .reusable = true}}, SHIFT(415),
  [2219] = {.entry = {.count = 1, .reusable = true}}, SHIFT(418),
  [2221] = {.entry = {.count = 1, .reusable = true}}, SHIFT(417),
  [2223] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1178),
  [2225] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1178),
  [2227] = {.entry = {.count = 1, .reusable = true}}, SHIFT(868),
  [2229] = {.entry = {.count = 1, .reusable = true}}, SHIFT(422),
  [2231] = {.entry = {.count = 1, .reusable = true}}, SHIFT(420),
  [2233] = {.entry = {.count = 1, .reusable = true}}, SHIFT(424),
  [2235] = {.entry = {.count = 1, .reusable = true}}, SHIFT(423),
  [2237] = {.entry = {.count = 1, .reusable = true}}, SHIFT(426),
  [2239] = {.entry = {.count = 1, .reusable = true}}, SHIFT(425),
  [2241] = {.entry = {.count = 1, .reusable = true}}, SHIFT(430),
  [2243] = {.entry = {.count = 1, .reusable = true}}, SHIFT(429),
  [2245] = {.entry = {.count = 1, .reusable = true}}, SHIFT(500),
  [2247] = {.entry = {.count = 1, .reusable = true}}, SHIFT(396),
  [2249] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1177),
  [2251] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1177),
  [2253] = {.entry = {.count = 1, .reusable = true}}, SHIFT(870),
  [2255] = {.entry = {.count = 1, .reusable = true}}, SHIFT(499),
  [2257] = {.entry = {.count = 1, .reusable = true}}, SHIFT(498),
  [2259] = {.entry = {.count = 1, .reusable = true}}, SHIFT(655),
  [2261] = {.entry = {.count = 1, .reusable = true}}, SHIFT(404),
  [2263] = {.entry = {.count = 1, .reusable = true}}, SHIFT(402),
  [2265] = {.entry = {.count = 1, .reusable = true}}, SHIFT(436),
  [2267] = {.entry = {.count = 1, .reusable = true}}, SHIFT(431),
  [2269] = {.entry = {.count = 1, .reusable = true}}, SHIFT(439),
  [2271] = {.entry = {.count = 1, .reusable = true}}, SHIFT(438),
  [2273] = {.entry = {.count = 1, .reusable = true}}, SHIFT(751),
  [2275] = {.entry = {.count = 1, .reusable = true}}, SHIFT(181),
  [2277] = {.entry = {.count = 1, .reusable = true}}, SHIFT(178),
  [2279] = {.entry = {.count = 1, .reusable = true}}, SHIFT(440),
  [2281] = {.entry = {.count = 1, .reusable = true}}, SHIFT(442),
  [2283] = {.entry = {.count = 1, .reusable = true}}, SHIFT(441),
  [2285] = {.entry = {.count = 1, .reusable = true}}, SHIFT(444),
  [2287] = {.entry = {.count = 1, .reusable = true}}, SHIFT(443),
  [2289] = {.entry = {.count = 1, .reusable = true}}, SHIFT(446),
  [2291] = {.entry = {.count = 1, .reusable = true}}, SHIFT(445),
  [2293] = {.entry = {.count = 1, .reusable = true}}, SHIFT(497),
  [2295] = {.entry = {.count = 1, .reusable = true}}, SHIFT(496),
  [2297] = {.entry = {.count = 1, .reusable = true}}, SHIFT(495),
  [2299] = {.entry = {.count = 1, .reusable = true}}, SHIFT(174),
  [2301] = {.entry = {.count = 1, .reusable = true}}, SHIFT(182),
  [2303] = {.entry = {.count = 1, .reusable = true}}, SHIFT(176),
  [2305] = {.entry = {.count = 1, .reusable = true}}, SHIFT(448),
  [2307] = {.entry = {.count = 1, .reusable = true}}, SHIFT(447),
  [2309] = {.entry = {.count = 1, .reusable = true}}, SHIFT(813),
  [2311] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1107),
  [2313] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1107),
  [2315] = {.entry = {.count = 1, .reusable = true}}, SHIFT(450),
  [2317] = {.entry = {.count = 1, .reusable = true}}, SHIFT(449),
  [2319] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1175),
  [2321] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1175),
  [2323] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_case_statement_repeat1, 1, 0, 0),
  [2325] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_case_statement_repeat1, 1, 0, 0),
  [2327] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1172),
  [2329] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1172),
  [2331] = {.entry = {.count = 1, .reusable = true}}, SHIFT(494),
  [2333] = {.entry = {.count = 1, .reusable = true}}, SHIFT(493),
  [2335] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1166),
  [2337] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1166),
  [2339] = {.entry = {.count = 1, .reusable = true}}, SHIFT(590),
  [2341] = {.entry = {.count = 1, .reusable = true}}, SHIFT(548),
  [2343] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_if_statement_repeat1, 1, 0, 18),
  [2345] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_if_statement_repeat1, 1, 0, 18),
  [2347] = {.entry = {.count = 1, .reusable = true}}, SHIFT(160),
  [2349] = {.entry = {.count = 1, .reusable = true}}, SHIFT(168),
  [2351] = {.entry = {.count = 1, .reusable = true}}, SHIFT(490),
  [2353] = {.entry = {.count = 1, .reusable = true}}, SHIFT(489),
  [2355] = {.entry = {.count = 1, .reusable = true}}, SHIFT(452),
  [2357] = {.entry = {.count = 1, .reusable = true}}, SHIFT(451),
  [2359] = {.entry = {.count = 1, .reusable = true}}, SHIFT(618),
  [2361] = {.entry = {.count = 1, .reusable = true}}, SHIFT(619),
  [2363] = {.entry = {.count = 1, .reusable = true}}, SHIFT(620),
  [2365] = {.entry = {.count = 1, .reusable = true}}, SHIFT(623),
  [2367] = {.entry = {.count = 1, .reusable = true}}, SHIFT(640),
  [2369] = {.entry = {.count = 1, .reusable = true}}, SHIFT(662),
  [2371] = {.entry = {.count = 1, .reusable = true}}, SHIFT(654),
  [2373] = {.entry = {.count = 1, .reusable = true}}, SHIFT(653),
  [2375] = {.entry = {.count = 1, .reusable = true}}, SHIFT(652),
  [2377] = {.entry = {.count = 1, .reusable = true}}, SHIFT(651),
  [2379] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_render_statement, 4, 0, 27),
  [2381] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_render_statement, 4, 0, 26),
  [2383] = {.entry = {.count = 1, .reusable = true}}, SHIFT(484),
  [2385] = {.entry = {.count = 1, .reusable = true}}, SHIFT(483),
  [2387] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_render_statement, 4, 0, 25),
  [2389] = {.entry = {.count = 1, .reusable = true}}, SHIFT(650),
  [2391] = {.entry = {.count = 1, .reusable = true}}, SHIFT(649),
  [2393] = {.entry = {.count = 1, .reusable = true}}, SHIFT(648),
  [2395] = {.entry = {.count = 1, .reusable = true}}, SHIFT(647),
  [2397] = {.entry = {.count = 1, .reusable = true}}, SHIFT(646),
  [2399] = {.entry = {.count = 1, .reusable = true}}, SHIFT(605),
  [2401] = {.entry = {.count = 1, .reusable = true}}, SHIFT(530),
  [2403] = {.entry = {.count = 1, .reusable = true}}, SHIFT(455),
  [2405] = {.entry = {.count = 1, .reusable = true}}, SHIFT(454),
  [2407] = {.entry = {.count = 1, .reusable = true}}, SHIFT(594),
  [2409] = {.entry = {.count = 1, .reusable = true}}, SHIFT(585),
  [2411] = {.entry = {.count = 1, .reusable = true}}, SHIFT(584),
  [2413] = {.entry = {.count = 1, .reusable = true}}, SHIFT(579),
  [2415] = {.entry = {.count = 1, .reusable = true}}, SHIFT(578),
  [2417] = {.entry = {.count = 1, .reusable = true}}, SHIFT(573),
  [2419] = {.entry = {.count = 1, .reusable = true}}, SHIFT(572),
  [2421] = {.entry = {.count = 1, .reusable = true}}, SHIFT(567),
  [2423] = {.entry = {.count = 1, .reusable = true}}, SHIFT(566),
  [2425] = {.entry = {.count = 1, .reusable = true}}, SHIFT(561),
  [2427] = {.entry = {.count = 1, .reusable = true}}, SHIFT(555),
  [2429] = {.entry = {.count = 1, .reusable = true}}, SHIFT(554),
  [2431] = {.entry = {.count = 1, .reusable = true}}, SHIFT(542),
  [2433] = {.entry = {.count = 1, .reusable = true}}, SHIFT(541),
  [2435] = {.entry = {.count = 1, .reusable = true}}, SHIFT(534),
  [2437] = {.entry = {.count = 1, .reusable = true}}, SHIFT(533),
  [2439] = {.entry = {.count = 1, .reusable = true}}, SHIFT(532),
  [2441] = {.entry = {.count = 1, .reusable = true}}, SHIFT(603),
  [2443] = {.entry = {.count = 1, .reusable = true}}, SHIFT(622),
  [2445] = {.entry = {.count = 1, .reusable = true}}, SHIFT(535),
  [2447] = {.entry = {.count = 1, .reusable = true}}, SHIFT(536),
  [2449] = {.entry = {.count = 1, .reusable = true}}, SHIFT(537),
  [2451] = {.entry = {.count = 1, .reusable = true}}, SHIFT(538),
  [2453] = {.entry = {.count = 1, .reusable = true}}, SHIFT(539),
  [2455] = {.entry = {.count = 1, .reusable = true}}, SHIFT(540),
  [2457] = {.entry = {.count = 1, .reusable = true}}, SHIFT(543),
  [2459] = {.entry = {.count = 1, .reusable = true}}, SHIFT(545),
  [2461] = {.entry = {.count = 1, .reusable = true}}, SHIFT(549),
  [2463] = {.entry = {.count = 1, .reusable = true}}, SHIFT(550),
  [2465] = {.entry = {.count = 1, .reusable = true}}, SHIFT(551),
  [2467] = {.entry = {.count = 1, .reusable = true}}, SHIFT(552),
  [2469] = {.entry = {.count = 1, .reusable = true}}, SHIFT(556),
  [2471] = {.entry = {.count = 1, .reusable = true}}, SHIFT(558),
  [2473] = {.entry = {.count = 1, .reusable = true}}, SHIFT(562),
  [2475] = {.entry = {.count = 1, .reusable = true}}, SHIFT(563),
  [2477] = {.entry = {.count = 1, .reusable = true}}, SHIFT(604),
  [2479] = {.entry = {.count = 1, .reusable = true}}, SHIFT(568),
  [2481] = {.entry = {.count = 1, .reusable = true}}, SHIFT(569),
  [2483] = {.entry = {.count = 1, .reusable = true}}, SHIFT(570),
  [2485] = {.entry = {.count = 1, .reusable = true}}, SHIFT(571),
  [2487] = {.entry = {.count = 1, .reusable = true}}, SHIFT(574),
  [2489] = {.entry = {.count = 1, .reusable = true}}, SHIFT(575),
  [2491] = {.entry = {.count = 1, .reusable = true}}, SHIFT(637),
  [2493] = {.entry = {.count = 1, .reusable = true}}, SHIFT(577),
  [2495] = {.entry = {.count = 1, .reusable = true}}, SHIFT(580),
  [2497] = {.entry = {.count = 1, .reusable = true}}, SHIFT(581),
  [2499] = {.entry = {.count = 1, .reusable = true}}, SHIFT(582),
  [2501] = {.entry = {.count = 1, .reusable = true}}, SHIFT(583),
  [2503] = {.entry = {.count = 1, .reusable = true}}, SHIFT(586),
  [2505] = {.entry = {.count = 1, .reusable = true}}, SHIFT(587),
  [2507] = {.entry = {.count = 1, .reusable = true}}, SHIFT(588),
  [2509] = {.entry = {.count = 1, .reusable = true}}, SHIFT(589),
  [2511] = {.entry = {.count = 1, .reusable = true}}, SHIFT(591),
  [2513] = {.entry = {.count = 1, .reusable = true}}, SHIFT(593),
  [2515] = {.entry = {.count = 1, .reusable = true}}, SHIFT(596),
  [2517] = {.entry = {.count = 1, .reusable = true}}, SHIFT(597),
  [2519] = {.entry = {.count = 1, .reusable = true}}, SHIFT(598),
  [2521] = {.entry = {.count = 1, .reusable = true}}, SHIFT(600),
  [2523] = {.entry = {.count = 1, .reusable = true}}, SHIFT(601),
  [2525] = {.entry = {.count = 1, .reusable = true}}, SHIFT(613),
  [2527] = {.entry = {.count = 1, .reusable = true}}, SHIFT(621),
  [2529] = {.entry = {.count = 1, .reusable = true}}, SHIFT(606),
  [2531] = {.entry = {.count = 1, .reusable = true}}, SHIFT(607),
  [2533] = {.entry = {.count = 1, .reusable = true}}, SHIFT(608),
  [2535] = {.entry = {.count = 1, .reusable = true}}, SHIFT(609),
  [2537] = {.entry = {.count = 1, .reusable = true}}, SHIFT(610),
  [2539] = {.entry = {.count = 1, .reusable = true}}, SHIFT(611),
  [2541] = {.entry = {.count = 1, .reusable = true}}, SHIFT(612),
  [2543] = {.entry = {.count = 1, .reusable = true}}, SHIFT(602),
  [2545] = {.entry = {.count = 1, .reusable = true}}, SHIFT(614),
  [2547] = {.entry = {.count = 1, .reusable = true}}, SHIFT(615),
  [2549] = {.entry = {.count = 1, .reusable = true}}, SHIFT(616),
  [2551] = {.entry = {.count = 1, .reusable = true}}, SHIFT(617),
  [2553] = {.entry = {.count = 1, .reusable = true}}, SHIFT(627),
  [2555] = {.entry = {.count = 1, .reusable = true}}, SHIFT(628),
  [2557] = {.entry = {.count = 1, .reusable = true}}, SHIFT(629),
  [2559] = {.entry = {.count = 1, .reusable = true}}, SHIFT(630),
  [2561] = {.entry = {.count = 1, .reusable = true}}, SHIFT(631),
  [2563] = {.entry = {.count = 1, .reusable = true}}, SHIFT(632),
  [2565] = {.entry = {.count = 1, .reusable = true}}, SHIFT(633),
  [2567] = {.entry = {.count = 1, .reusable = true}}, SHIFT(634),
  [2569] = {.entry = {.count = 1, .reusable = true}}, SHIFT(635),
  [2571] = {.entry = {.count = 1, .reusable = true}}, SHIFT(636),
  [2573] = {.entry = {.count = 1, .reusable = true}}, SHIFT(576),
  [2575] = {.entry = {.count = 1, .reusable = true}}, SHIFT(592),
  [2577] = {.entry = {.count = 1, .reusable = true}}, SHIFT(641),
  [2579] = {.entry = {.count = 1, .reusable = true}}, SHIFT(643),
  [2581] = {.entry = {.count = 1, .reusable = true}}, SHIFT(644),
  [2583] = {.entry = {.count = 1, .reusable = true}}, SHIFT(660),
  [2585] = {.entry = {.count = 1, .reusable = true}}, SHIFT(661),
  [2587] = {.entry = {.count = 1, .reusable = true}}, SHIFT(663),
  [2589] = {.entry = {.count = 1, .reusable = true}}, SHIFT(659),
  [2591] = {.entry = {.count = 1, .reusable = true}}, SHIFT(658),
  [2593] = {.entry = {.count = 1, .reusable = true}}, SHIFT(547),
  [2595] = {.entry = {.count = 1, .reusable = true}}, SHIFT(624),
  [2597] = {.entry = {.count = 1, .reusable = true}}, SHIFT(599),
  [2599] = {.entry = {.count = 1, .reusable = true}}, SHIFT(557),
  [2601] = {.entry = {.count = 1, .reusable = true}}, SHIFT(560),
  [2603] = {.entry = {.count = 1, .reusable = true}}, SHIFT(559),
  [2605] = {.entry = {.count = 1, .reusable = true}}, SHIFT(553),
  [2607] = {.entry = {.count = 1, .reusable = true}}, SHIFT(544),
  [2609] = {.entry = {.count = 1, .reusable = true}}, SHIFT(564),
  [2611] = {.entry = {.count = 1, .reusable = true}}, SHIFT(642),
  [2613] = {.entry = {.count = 1, .reusable = true}}, SHIFT(457),
  [2615] = {.entry = {.count = 1, .reusable = true}}, SHIFT(456),
  [2617] = {.entry = {.count = 1, .reusable = true}}, SHIFT(395),
  [2619] = {.entry = {.count = 1, .reusable = true}}, SHIFT(458),
  [2621] = {.entry = {.count = 1, .reusable = true}}, SHIFT(969),
  [2623] = {.entry = {.count = 1, .reusable = true}}, SHIFT(968),
  [2625] = {.entry = {.count = 1, .reusable = true}}, SHIFT(460),
  [2627] = {.entry = {.count = 1, .reusable = true}}, SHIFT(459),
  [2629] = {.entry = {.count = 1, .reusable = true}}, SHIFT(883),
  [2631] = {.entry = {.count = 1, .reusable = true}}, SHIFT(884),
  [2633] = {.entry = {.count = 1, .reusable = true}}, SHIFT(885),
  [2635] = {.entry = {.count = 1, .reusable = true}}, SHIFT(886),
  [2637] = {.entry = {.count = 1, .reusable = true}}, SHIFT(428),
  [2639] = {.entry = {.count = 1, .reusable = true}}, SHIFT(427),
  [2641] = {.entry = {.count = 1, .reusable = true}}, SHIFT(464),
  [2643] = {.entry = {.count = 1, .reusable = true}}, SHIFT(461),
  [2645] = {.entry = {.count = 1, .reusable = true}}, SHIFT(468),
  [2647] = {.entry = {.count = 1, .reusable = true}}, SHIFT(467),
  [2649] = {.entry = {.count = 1, .reusable = true}}, SHIFT(474),
  [2651] = {.entry = {.count = 1, .reusable = true}}, SHIFT(473),
  [2653] = {.entry = {.count = 1, .reusable = true}}, SHIFT(480),
  [2655] = {.entry = {.count = 1, .reusable = true}}, SHIFT(477),
  [2657] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1060),
  [2659] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__for_loop_liq, 6, 0, 55),
  [2661] = {.entry = {.count = 1, .reusable = true}}, SHIFT(222),
  [2663] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1104),
  [2665] = {.entry = {.count = 1, .reusable = true}}, SHIFT(151),
  [2667] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1100),
  [2669] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1099),
  [2671] = {.entry = {.count = 1, .reusable = true}}, SHIFT(781),
  [2673] = {.entry = {.count = 1, .reusable = true}}, SHIFT(233),
  [2675] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__for_loop_liq, 7, 0, 66),
  [2677] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__form_liq, 3, 0, 22),
  [2679] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__capture_liq, 3, 0, 21),
  [2681] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1151),
  [2683] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__unless_liq, 3, 0, 16),
  [2685] = {.entry = {.count = 1, .reusable = true}}, SHIFT(223),
  [2687] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1198),
  [2689] = {.entry = {.count = 1, .reusable = true}}, SHIFT(965),
  [2691] = {.entry = {.count = 1, .reusable = true}}, SHIFT(32),
  [2693] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__case_liq, 3, 0, 19),
  [2695] = {.entry = {.count = 1, .reusable = true}}, SHIFT(45),
  [2697] = {.entry = {.count = 1, .reusable = true}}, SHIFT(40),
  [2699] = {.entry = {.count = 1, .reusable = true}}, SHIFT(974),
  [2701] = {.entry = {.count = 1, .reusable = true}}, SHIFT(917),
  [2703] = {.entry = {.count = 1, .reusable = true}}, SHIFT(914),
  [2705] = {.entry = {.count = 1, .reusable = true}}, SHIFT(978),
  [2707] = {.entry = {.count = 1, .reusable = true}}, SHIFT(31),
  [2709] = {.entry = {.count = 1, .reusable = true}}, SHIFT(980),
  [2711] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1132),
  [2713] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1223),
  [2715] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1082),
  [2717] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__if_liq, 3, 0, 16),
  [2719] = {.entry = {.count = 1, .reusable = true}}, SHIFT(986),
  [2721] = {.entry = {.count = 1, .reusable = true}}, SHIFT(987),
  [2723] = {.entry = {.count = 1, .reusable = true}}, SHIFT(203),
  [2725] = {.entry = {.count = 1, .reusable = true}}, SHIFT(912),
  [2727] = {.entry = {.count = 1, .reusable = true}}, SHIFT(905),
  [2729] = {.entry = {.count = 1, .reusable = true}}, SHIFT(265),
  [2731] = {.entry = {.count = 1, .reusable = true}}, SHIFT(992),
  [2733] = {.entry = {.count = 1, .reusable = true}}, SHIFT(334),
  [2735] = {.entry = {.count = 1, .reusable = true}}, SHIFT(280),
  [2737] = {.entry = {.count = 1, .reusable = true}}, SHIFT(995),
  [2739] = {.entry = {.count = 1, .reusable = true}}, SHIFT(996),
  [2741] = {.entry = {.count = 1, .reusable = true}}, SHIFT(997),
  [2743] = {.entry = {.count = 1, .reusable = true}}, SHIFT(998),
  [2745] = {.entry = {.count = 1, .reusable = true}}, SHIFT(258),
  [2747] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1001),
  [2749] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1002),
  [2751] = {.entry = {.count = 1, .reusable = true}}, SHIFT(266),
  [2753] = {.entry = {.count = 1, .reusable = true}}, SHIFT(333),
  [2755] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [2757] = {.entry = {.count = 1, .reusable = true}}, SHIFT(331),
  [2759] = {.entry = {.count = 1, .reusable = true}}, SHIFT(873),
  [2761] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1201),
  [2763] = {.entry = {.count = 1, .reusable = true}}, SHIFT(680),
  [2765] = {.entry = {.count = 1, .reusable = true}}, SHIFT(692),
  [2767] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1012),
  [2769] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1013),
  [2771] = {.entry = {.count = 1, .reusable = true}}, SHIFT(259),
  [2773] = {.entry = {.count = 1, .reusable = true}}, SHIFT(231),
  [2775] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1016),
  [2777] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1017),
  [2779] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1020),
  [2781] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1021),
  [2783] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1022),
  [2785] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1023),
  [2787] = {.entry = {.count = 1, .reusable = true}}, SHIFT(177),
  [2789] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1200),
  [2791] = {.entry = {.count = 1, .reusable = true}}, SHIFT(761),
  [2793] = {.entry = {.count = 1, .reusable = true}}, SHIFT(760),
  [2795] = {.entry = {.count = 1, .reusable = true}}, SHIFT(937),
  [2797] = {.entry = {.count = 1, .reusable = true}}, SHIFT(702),
  [2799] = {.entry = {.count = 1, .reusable = true}}, SHIFT(938),
  [2801] = {.entry = {.count = 1, .reusable = true}}, SHIFT(979),
  [2803] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__if_liq, 4, 0, 30),
  [2805] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1033),
  [2807] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1034),
  [2809] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1035),
  [2811] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1036),
  [2813] = {.entry = {.count = 1, .reusable = true}}, SHIFT(678),
  [2815] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__case_liq, 4, 0, 35),
  [2817] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1073),
  [2819] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__if_liq, 4, 0, 31),
  [2821] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1181),
  [2823] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__if_liq, 4, 0, 32),
  [2825] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1045),
  [2827] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1046),
  [2829] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1188),
  [2831] = {.entry = {.count = 1, .reusable = true}}, SHIFT(235),
  [2833] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1075),
  [2835] = {.entry = {.count = 1, .reusable = true}}, SHIFT(328),
  [2837] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1189),
  [2839] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__unless_liq, 4, 0, 30),
  [2841] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__unless_liq, 4, 0, 31),
  [2843] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1190),
  [2845] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__unless_liq, 4, 0, 32),
  [2847] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__untagged_paired_statement, 1, 0, 7),
  [2849] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1193),
  [2851] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__untagged_paired_statement, 1, 0, 6),
  [2853] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__capture_liq, 4, 0, 36),
  [2855] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__form_liq, 4, 0, 22),
  [2857] = {.entry = {.count = 1, .reusable = true}}, SHIFT(851),
  [2859] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__untagged_paired_statement, 1, 0, 5),
  [2861] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__untagged_paired_statement, 1, 0, 2),
  [2863] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__untagged_paired_statement, 1, 0, 4),
  [2865] = {.entry = {.count = 1, .reusable = true}}, SHIFT(847),
  [2867] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__untagged_paired_statement, 1, 0, 3),
  [2869] = {.entry = {.count = 1, .reusable = true}}, SHIFT(756),
  [2871] = {.entry = {.count = 1, .reusable = true}}, SHIFT(939),
  [2873] = {.entry = {.count = 1, .reusable = true}}, SHIFT(837),
  [2875] = {.entry = {.count = 1, .reusable = true}}, SHIFT(944),
  [2877] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1110),
  [2879] = {.entry = {.count = 1, .reusable = true}}, SHIFT(833),
  [2881] = {.entry = {.count = 1, .reusable = true}}, SHIFT(35),
  [2883] = {.entry = {.count = 1, .reusable = true}}, SHIFT(823),
  [2885] = {.entry = {.count = 1, .reusable = true}}, SHIFT(822),
  [2887] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__for_loop_liq, 5, 0, 39),
  [2889] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1053),
  [2891] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__if_liq, 5, 0, 41),
  [2893] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1111),
  [2895] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1115),
  [2897] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1118),
  [2899] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__if_liq, 5, 0, 42),
  [2901] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1218),
  [2903] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__if_liq, 5, 0, 43),
  [2905] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__case_liq, 5, 0, 44),
  [2907] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__unless_liq, 5, 0, 41),
  [2909] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__unless_liq, 5, 0, 42),
  [2911] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1222),
  [2913] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__unless_liq, 5, 0, 43),
  [2915] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__form_liq, 5, 0, 45),
  [2917] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__tablerow_liq, 5, 0, 39),
  [2919] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__paginate_liq, 5, 0, 39),
  [2921] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1129),
  [2923] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__case_liq, 4, 0, 34),
  [2925] = {.entry = {.count = 1, .reusable = true}}, SHIFT(850),
  [2927] = {.entry = {.count = 1, .reusable = true}}, SHIFT(893),
  [2929] = {.entry = {.count = 1, .reusable = true}}, SHIFT(894),
  [2931] = {.entry = {.count = 1, .reusable = true}}, SHIFT(900),
  [2933] = {.entry = {.count = 1, .reusable = true}}, SHIFT(804),
  [2935] = {.entry = {.count = 1, .reusable = true}}, SHIFT(902),
  [2937] = {.entry = {.count = 1, .reusable = true}}, SHIFT(925),
  [2939] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1137),
  [2941] = {.entry = {.count = 1, .reusable = true}}, SHIFT(928),
  [2943] = {.entry = {.count = 1, .reusable = true}}, SHIFT(752),
  [2945] = {.entry = {.count = 1, .reusable = true}}, SHIFT(777),
  [2947] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1146),
  [2949] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__for_loop_liq, 6, 0, 56),
  [2951] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1061),
  [2953] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__if_liq, 6, 0, 57),
  [2955] = {.entry = {.count = 1, .reusable = true}}, SHIFT(768),
  [2957] = {.entry = {.count = 1, .reusable = true}}, SHIFT(772),
  [2959] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1149),
  [2961] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__unless_liq, 6, 0, 57),
  [2963] = {.entry = {.count = 1, .reusable = true}}, SHIFT(827),
  [2965] = {.entry = {.count = 1, .reusable = true}}, SHIFT(910),
  [2967] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__form_liq, 6, 0, 45),
  [2969] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__tablerow_liq, 6, 0, 56),
  [2971] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__paginate_liq, 6, 0, 56),
  [2973] = {.entry = {.count = 1, .reusable = true}}, SHIFT(909),
  [2975] = {.entry = {.count = 1, .reusable = true}}, SHIFT(904),
  [2977] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1048),
  [2979] = {.entry = {.count = 1, .reusable = true}}, SHIFT(683),
  [2981] = {.entry = {.count = 1, .reusable = true}}, SHIFT(708),
  [2983] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1235),
  [2985] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1236),
  [2987] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1038),
};

enum ts_external_scanner_symbol_identifiers {
  ts_external_token__inline_comment_content = 0,
  ts_external_token__paired_comment_content = 1,
  ts_external_token__paired_comment_content_liq = 2,
  ts_external_token_raw_content = 3,
  ts_external_token_front_matter = 4,
  ts_external_token_error_sentinel = 5,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token__inline_comment_content] = sym__inline_comment_content,
  [ts_external_token__paired_comment_content] = sym__paired_comment_content,
  [ts_external_token__paired_comment_content_liq] = sym__paired_comment_content_liq,
  [ts_external_token_raw_content] = sym_raw_content,
  [ts_external_token_front_matter] = sym_front_matter,
  [ts_external_token_error_sentinel] = sym_error_sentinel,
};

static const bool ts_external_scanner_states[7][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token__inline_comment_content] = true,
    [ts_external_token__paired_comment_content] = true,
    [ts_external_token__paired_comment_content_liq] = true,
    [ts_external_token_raw_content] = true,
    [ts_external_token_front_matter] = true,
    [ts_external_token_error_sentinel] = true,
  },
  [2] = {
    [ts_external_token_front_matter] = true,
  },
  [3] = {
    [ts_external_token__inline_comment_content] = true,
  },
  [4] = {
    [ts_external_token__paired_comment_content_liq] = true,
  },
  [5] = {
    [ts_external_token__paired_comment_content] = true,
  },
  [6] = {
    [ts_external_token_raw_content] = true,
  },
};

#ifdef __cplusplus
extern "C" {
#endif
void *tree_sitter_liquid_external_scanner_create(void);
void tree_sitter_liquid_external_scanner_destroy(void *);
bool tree_sitter_liquid_external_scanner_scan(void *, TSLexer *, const bool *);
unsigned tree_sitter_liquid_external_scanner_serialize(void *, char *);
void tree_sitter_liquid_external_scanner_deserialize(void *, const char *, unsigned);

#ifdef TREE_SITTER_HIDE_SYMBOLS
#define TS_PUBLIC
#elif defined(_WIN32)
#define TS_PUBLIC __declspec(dllexport)
#else
#define TS_PUBLIC __attribute__((visibility("default")))
#endif

TS_PUBLIC const TSLanguage *tree_sitter_liquid(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .field_names = ts_field_names,
    .field_map_slices = ts_field_map_slices,
    .field_map_entries = ts_field_map_entries,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .keyword_lex_fn = ts_lex_keywords,
    .keyword_capture_token = sym_identifier,
    .external_scanner = {
      &ts_external_scanner_states[0][0],
      ts_external_scanner_symbol_map,
      tree_sitter_liquid_external_scanner_create,
      tree_sitter_liquid_external_scanner_destroy,
      tree_sitter_liquid_external_scanner_scan,
      tree_sitter_liquid_external_scanner_serialize,
      tree_sitter_liquid_external_scanner_deserialize,
    },
    .primary_state_ids = ts_primary_state_ids,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
