# k6

> Open source load testing tool and SaaS for engineering teams.
> More information: <https://grafana.com/docs/k6/latest/using-k6/k6-options/reference/>.

- Run load test locally:

`k6 run {{script.js}}`

- Run load test locally with a given number of virtual users and duration:

`k6 run {{[-u|--vus]}} {{10}} {{[-d|--duration]}} {{30s}} {{script.js}}`

- Run load test locally with a given environment variable:

`k6 run {{[-e|--env]}} {{HOSTNAME=example.com}} {{script.js}}`

- Run load test locally using InfluxDB to store results:

`k6 run {{[-o|--out]}} influxdb={{http://localhost:8086/k6db}} {{script.js}}`

- Run load test locally and discard response bodies (significantly faster):

`k6 run --discard-response-bodies {{script.js}}`

- Run load test locally using the base JavaScript compatibility mode (significantly faster):

`k6 run --compatibility-mode=base {{script.js}}`

- Log in to cloud service using secret token:

`k6 login cloud --token {{secret}}`

- Run load test on cloud infrastructure:

`k6 cloud {{script.js}}`
