# g++

> C++ மூலக் கோப்புகளைத் தொகுக்கவும்.
> GCC (GNU கம்பைலர் சேகரிப்பு) இன் ஒரு பகுதி.
> மேலும் விவரத்திற்கு: <https://gcc.gnu.org/onlinedocs/gcc/C_002b_002b-Dialect-Options.html>.

- இயங்கக்கூடிய பைனரியில் ஒரு மூலக் குறியீடு கோப்பை தொகுக்கவும்:

`g++ {{மூலம்1.cpp/பாதை மூலம்2.cpp/பாதை ...}} {{[-o|--output]}} {{வெளியீடு_இயங்கக்கூடியது/பாதை}}`

- அனைத்து பிழைகள் மற்றும் எச்சரிக்கைகள் செயல்படுத்தவும்:

`g++ {{மூலம்.cpp/பாதை}} -Wall {{[-o|--output]}} {{வெளியீடு_இயங்கக்கூடியது/பாதை}}`

- பொதுவான எச்சரிக்கைகளைக் காட்டு, வெளியீட்டில் சின்னங்களைப் பிழைத்திருத்தம் செய், பின்னர் பிழைத்திருத்தத்தைப் பாதிக்காமல் மேம்படுத்து:

`g++ {{மூலம்.cpp/பாதை}} -Wall {{[-g|--debug]}} -Og {{[-o|--output]}} {{வெளியீடு_இயங்கக்கூடியது/பாதை}}`

- (C++98/C++11/C++14/C++17) தொகுக்க ஒரு மொழித் தரநிலையைத் தேர்வு செய்யவும்:

`g++ {{மூலம்.cpp/பாதை}} -std={{c++98|c++11|c++14|c++17}} {{[-o|--output]}} {{வெளியீடு_இயங்கக்கூடியது/பாதை}}`

- மூலக் கோப்பை விட வேறு பாதையில் அமைந்துள்ள நூலகங்களைச் சேர்க்கவும்:

`g++ {{மூலம்.cpp/பாதை}} {{[-o|--output]}} {{வெளியீடு_இயங்கக்கூடியது/பாதை}} -I{{தலைப்பு/பாதை}} -L{{நூலகம்/பாதை}} -l{{நூலகம்_பெயர்}}`

- பல மூலக் குறியீடு கோப்புகளை ஒரு இயங்கக்கூடிய பைனரியில் தொகுத்து இணைக்கவும்:

`g++ {{[-c|--compile]}} {{மூலம்_1.cpp/பாதை மூலம்_2.cpp/பாதை ...}} && g++ {{[-o|--output]}} {{வெளியீடு_செயல்படுத்தக்கூடியது/பாதை}} {{மூலம்_1.o/பாதை மூலம்_2.o/பாதை ...}}`

- செயல்திறனுக்காக தொகுக்கப்பட்ட நிரலை மேம்படுத்தவும்:

`g++ {{மூலம்.cpp/பாதை}} -O{{1|2|3|fast}} {{[-o|--output]}} {{வெளியீடு_இயங்கக்கூடியது/பாதை}}`

- பதிப்பைக் காட்டு:

`g++ --version`
