#!/usr/bin/env python
# Eclipse SUMO, Simulation of Urban MObility; see https://eclipse.dev/sumo
# Copyright (C) 2009-2026 German Aerospace Center (DLR) and others.
# This program and the accompanying materials are made available under the
# terms of the Eclipse Public License 2.0 which is available at
# https://www.eclipse.org/legal/epl-2.0/
# This Source Code may also be made available under the following Secondary
# Licenses when the conditions for such availability set forth in the Eclipse
# Public License 2.0 are satisfied: GNU General Public License, version 2
# or later which is available at
# https://www.gnu.org/licenses/old-licenses/gpl-2.0-standalone.html
# SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-or-later

# @file    test.py
# @author  Pablo Alvarez Lopez
# @date    2016-11-25

# import common functions for netedit tests
import os
import sys

sys.path.append(os.path.join(os.environ.get("SUMO_HOME", "."), "tools"))
import neteditTestFunctions as netedit  # noqa

# Open netedit
neteditProcess, referencePosition = netedit.setupAndStart()

# Change to create edge mode
netedit.changeMode("createEdge")

# select two-way mode
netedit.changeEditMode(netedit.attrs.modes.network.twoWayMode)

# create a complex intersection
netedit.leftClick(referencePosition, netedit.positions.network.junction.positionA)
netedit.leftClick(referencePosition, netedit.positions.network.junction.cross.center)

netedit.leftClick(referencePosition, netedit.positions.network.junction.positionB)
netedit.leftClick(referencePosition, netedit.positions.network.junction.cross.center)

netedit.leftClick(referencePosition, netedit.positions.network.junction.positionC)
netedit.leftClick(referencePosition, netedit.positions.network.junction.cross.center)

netedit.leftClick(referencePosition, netedit.positions.network.junction.positionD)
netedit.leftClick(referencePosition, netedit.positions.network.junction.cross.center)

# rebuild network
netedit.computeJunctions()

# Change to delete mode
netedit.changeMode("delete")

# disable "protect elements"
netedit.protectElements()

# remove center edge
netedit.leftClick(referencePosition, netedit.positions.network.junction.cross.center)

# rebuild network
netedit.computeJunctions()

# Check undo
netedit.undo(referencePosition, 1)

# rebuild network
netedit.computeJunctions()

# Change to delete mode
netedit.changeMode("delete")

# remove all junctions
netedit.leftClick(referencePosition, netedit.positions.network.junction.cross.center)
netedit.leftClick(referencePosition, netedit.positions.network.junction.positionA_2)
netedit.leftClick(referencePosition, netedit.positions.network.junction.positionB_2)
netedit.leftClick(referencePosition, netedit.positions.network.junction.positionC_2)
netedit.leftClick(referencePosition, netedit.positions.network.junction.positionD_2)

# rebuild network
netedit.computeJunctions()

# Check undo
netedit.undo(referencePosition, 9)

# rebuild network
netedit.computeJunctions()

# Check redo
netedit.redo(referencePosition, 9)

# save Netedit config
netedit.saveExistentFile("neteditConfig")

# quit netedit
netedit.quit(neteditProcess)
