// Code generated by protoc-gen-go-grpc. DO NOT EDIT.

package proto

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

// SkaffoldServiceClient is the client API for SkaffoldService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type SkaffoldServiceClient interface {
	// Returns the state of the current Skaffold execution
	GetState(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*State, error)
	// DEPRECATED. Events should be used instead.
	// TODO remove (https://github.com/GoogleContainerTools/skaffold/issues/3168)
	EventLog(ctx context.Context, opts ...grpc.CallOption) (SkaffoldService_EventLogClient, error)
	// Returns all the events of the current Skaffold execution from the start
	Events(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (SkaffoldService_EventsClient, error)
	// Allows for a single execution of some or all of the phases (build, sync, deploy) in case autoBuild, autoDeploy or autoSync are disabled.
	Execute(ctx context.Context, in *UserIntentRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Allows for enabling or disabling automatic build trigger
	AutoBuild(ctx context.Context, in *TriggerRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Allows for enabling or disabling automatic sync trigger
	AutoSync(ctx context.Context, in *TriggerRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Allows for enabling or disabling automatic deploy trigger
	AutoDeploy(ctx context.Context, in *TriggerRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// EXPERIMENTAL. It allows for custom events to be implemented in custom builders for example.
	Handle(ctx context.Context, in *Event, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type skaffoldServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewSkaffoldServiceClient(cc grpc.ClientConnInterface) SkaffoldServiceClient {
	return &skaffoldServiceClient{cc}
}

func (c *skaffoldServiceClient) GetState(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*State, error) {
	out := new(State)
	err := c.cc.Invoke(ctx, "/proto.SkaffoldService/GetState", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *skaffoldServiceClient) EventLog(ctx context.Context, opts ...grpc.CallOption) (SkaffoldService_EventLogClient, error) {
	stream, err := c.cc.NewStream(ctx, &SkaffoldService_ServiceDesc.Streams[0], "/proto.SkaffoldService/EventLog", opts...)
	if err != nil {
		return nil, err
	}
	x := &skaffoldServiceEventLogClient{stream}
	return x, nil
}

type SkaffoldService_EventLogClient interface {
	Send(*LogEntry) error
	Recv() (*LogEntry, error)
	grpc.ClientStream
}

type skaffoldServiceEventLogClient struct {
	grpc.ClientStream
}

func (x *skaffoldServiceEventLogClient) Send(m *LogEntry) error {
	return x.ClientStream.SendMsg(m)
}

func (x *skaffoldServiceEventLogClient) Recv() (*LogEntry, error) {
	m := new(LogEntry)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *skaffoldServiceClient) Events(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (SkaffoldService_EventsClient, error) {
	stream, err := c.cc.NewStream(ctx, &SkaffoldService_ServiceDesc.Streams[1], "/proto.SkaffoldService/Events", opts...)
	if err != nil {
		return nil, err
	}
	x := &skaffoldServiceEventsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type SkaffoldService_EventsClient interface {
	Recv() (*LogEntry, error)
	grpc.ClientStream
}

type skaffoldServiceEventsClient struct {
	grpc.ClientStream
}

func (x *skaffoldServiceEventsClient) Recv() (*LogEntry, error) {
	m := new(LogEntry)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *skaffoldServiceClient) Execute(ctx context.Context, in *UserIntentRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/proto.SkaffoldService/Execute", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *skaffoldServiceClient) AutoBuild(ctx context.Context, in *TriggerRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/proto.SkaffoldService/AutoBuild", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *skaffoldServiceClient) AutoSync(ctx context.Context, in *TriggerRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/proto.SkaffoldService/AutoSync", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *skaffoldServiceClient) AutoDeploy(ctx context.Context, in *TriggerRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/proto.SkaffoldService/AutoDeploy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *skaffoldServiceClient) Handle(ctx context.Context, in *Event, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/proto.SkaffoldService/Handle", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SkaffoldServiceServer is the server API for SkaffoldService service.
// All implementations should embed UnimplementedSkaffoldServiceServer
// for forward compatibility
type SkaffoldServiceServer interface {
	// Returns the state of the current Skaffold execution
	GetState(context.Context, *emptypb.Empty) (*State, error)
	// DEPRECATED. Events should be used instead.
	// TODO remove (https://github.com/GoogleContainerTools/skaffold/issues/3168)
	EventLog(SkaffoldService_EventLogServer) error
	// Returns all the events of the current Skaffold execution from the start
	Events(*emptypb.Empty, SkaffoldService_EventsServer) error
	// Allows for a single execution of some or all of the phases (build, sync, deploy) in case autoBuild, autoDeploy or autoSync are disabled.
	Execute(context.Context, *UserIntentRequest) (*emptypb.Empty, error)
	// Allows for enabling or disabling automatic build trigger
	AutoBuild(context.Context, *TriggerRequest) (*emptypb.Empty, error)
	// Allows for enabling or disabling automatic sync trigger
	AutoSync(context.Context, *TriggerRequest) (*emptypb.Empty, error)
	// Allows for enabling or disabling automatic deploy trigger
	AutoDeploy(context.Context, *TriggerRequest) (*emptypb.Empty, error)
	// EXPERIMENTAL. It allows for custom events to be implemented in custom builders for example.
	Handle(context.Context, *Event) (*emptypb.Empty, error)
}

// UnimplementedSkaffoldServiceServer should be embedded to have forward compatible implementations.
type UnimplementedSkaffoldServiceServer struct {
}

func (UnimplementedSkaffoldServiceServer) GetState(context.Context, *emptypb.Empty) (*State, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetState not implemented")
}
func (UnimplementedSkaffoldServiceServer) EventLog(SkaffoldService_EventLogServer) error {
	return status.Errorf(codes.Unimplemented, "method EventLog not implemented")
}
func (UnimplementedSkaffoldServiceServer) Events(*emptypb.Empty, SkaffoldService_EventsServer) error {
	return status.Errorf(codes.Unimplemented, "method Events not implemented")
}
func (UnimplementedSkaffoldServiceServer) Execute(context.Context, *UserIntentRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Execute not implemented")
}
func (UnimplementedSkaffoldServiceServer) AutoBuild(context.Context, *TriggerRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AutoBuild not implemented")
}
func (UnimplementedSkaffoldServiceServer) AutoSync(context.Context, *TriggerRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AutoSync not implemented")
}
func (UnimplementedSkaffoldServiceServer) AutoDeploy(context.Context, *TriggerRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AutoDeploy not implemented")
}
func (UnimplementedSkaffoldServiceServer) Handle(context.Context, *Event) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Handle not implemented")
}

// UnsafeSkaffoldServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to SkaffoldServiceServer will
// result in compilation errors.
type UnsafeSkaffoldServiceServer interface {
	mustEmbedUnimplementedSkaffoldServiceServer()
}

func RegisterSkaffoldServiceServer(s grpc.ServiceRegistrar, srv SkaffoldServiceServer) {
	s.RegisterService(&SkaffoldService_ServiceDesc, srv)
}

func _SkaffoldService_GetState_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(emptypb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SkaffoldServiceServer).GetState(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.SkaffoldService/GetState",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SkaffoldServiceServer).GetState(ctx, req.(*emptypb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _SkaffoldService_EventLog_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(SkaffoldServiceServer).EventLog(&skaffoldServiceEventLogServer{stream})
}

type SkaffoldService_EventLogServer interface {
	Send(*LogEntry) error
	Recv() (*LogEntry, error)
	grpc.ServerStream
}

type skaffoldServiceEventLogServer struct {
	grpc.ServerStream
}

func (x *skaffoldServiceEventLogServer) Send(m *LogEntry) error {
	return x.ServerStream.SendMsg(m)
}

func (x *skaffoldServiceEventLogServer) Recv() (*LogEntry, error) {
	m := new(LogEntry)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _SkaffoldService_Events_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(emptypb.Empty)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(SkaffoldServiceServer).Events(m, &skaffoldServiceEventsServer{stream})
}

type SkaffoldService_EventsServer interface {
	Send(*LogEntry) error
	grpc.ServerStream
}

type skaffoldServiceEventsServer struct {
	grpc.ServerStream
}

func (x *skaffoldServiceEventsServer) Send(m *LogEntry) error {
	return x.ServerStream.SendMsg(m)
}

func _SkaffoldService_Execute_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UserIntentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SkaffoldServiceServer).Execute(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.SkaffoldService/Execute",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SkaffoldServiceServer).Execute(ctx, req.(*UserIntentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SkaffoldService_AutoBuild_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TriggerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SkaffoldServiceServer).AutoBuild(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.SkaffoldService/AutoBuild",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SkaffoldServiceServer).AutoBuild(ctx, req.(*TriggerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SkaffoldService_AutoSync_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TriggerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SkaffoldServiceServer).AutoSync(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.SkaffoldService/AutoSync",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SkaffoldServiceServer).AutoSync(ctx, req.(*TriggerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SkaffoldService_AutoDeploy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TriggerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SkaffoldServiceServer).AutoDeploy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.SkaffoldService/AutoDeploy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SkaffoldServiceServer).AutoDeploy(ctx, req.(*TriggerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SkaffoldService_Handle_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Event)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SkaffoldServiceServer).Handle(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.SkaffoldService/Handle",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SkaffoldServiceServer).Handle(ctx, req.(*Event))
	}
	return interceptor(ctx, in, info, handler)
}

// SkaffoldService_ServiceDesc is the grpc.ServiceDesc for SkaffoldService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var SkaffoldService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "proto.SkaffoldService",
	HandlerType: (*SkaffoldServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetState",
			Handler:    _SkaffoldService_GetState_Handler,
		},
		{
			MethodName: "Execute",
			Handler:    _SkaffoldService_Execute_Handler,
		},
		{
			MethodName: "AutoBuild",
			Handler:    _SkaffoldService_AutoBuild_Handler,
		},
		{
			MethodName: "AutoSync",
			Handler:    _SkaffoldService_AutoSync_Handler,
		},
		{
			MethodName: "AutoDeploy",
			Handler:    _SkaffoldService_AutoDeploy_Handler,
		},
		{
			MethodName: "Handle",
			Handler:    _SkaffoldService_Handle_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "EventLog",
			Handler:       _SkaffoldService_EventLog_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
		{
			StreamName:    "Events",
			Handler:       _SkaffoldService_Events_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "v1/skaffold.proto",
}
