---
title: pysh.rotate
keywords: spherical harmonics, spherical harmonic rotations, python, pyshtools
sidebar: mydoc_sidebar
permalink: python-spherical-harmonic-rotations.html
summary: This module provides routines for rotating either the physical body or the coordinate system of a function expressed in spherical harmonics.
toc: false
folder: mydoc
---

<style>
table:nth-of-type(n) {
    display:table;
    width:100%;
}
table:nth-of-type(n) th:nth-of-type(2) {
    width:75%;
}
</style>

| Function name | Description |
| ------------- | ----------- |
| [djpi2](pydjpi2.html) | Compute the rotation matrix d(&pi;/2) used in rotating data expressed in spherical harmonics. |
| [SHRotateCoef](pyshrotatecoef.html) | Determine the spherical harmonic coefficients of a complex function rotated by three Euler angles. |
| [SHRotateRealCoef](pyshrotaterealcoef.html) | Determine the spherical harmonic coefficients of a real function rotated by three Euler angles. |
