
///////////////////////////////////////////////////////////
//                                                       //
//                         SAGA                          //
//                                                       //
//      System for Automated Geoscientific Analyses      //
//                                                       //
//                     Tool Library                      //
//                    io_webservices                     //
//                                                       //
//-------------------------------------------------------//
//                                                       //
//                       chelsa.h                        //
//                                                       //
//                 Copyrights (C) 2025                   //
//                     Olaf Conrad                       //
//                                                       //
//-------------------------------------------------------//
//                                                       //
// This file is part of 'SAGA - System for Automated     //
// Geoscientific Analyses'. SAGA is free software; you   //
// can redistribute it and/or modify it under the terms  //
// of the GNU General Public License as published by the //
// Free Software Foundation, either version 2 of the     //
// License, or (at your option) any later version.       //
//                                                       //
// SAGA is distributed in the hope that it will be       //
// useful, but WITHOUT ANY WARRANTY; without even the    //
// implied warranty of MERCHANTABILITY or FITNESS FOR A  //
// PARTICULAR PURPOSE. See the GNU General Public        //
// License for more details.                             //
//                                                       //
// You should have received a copy of the GNU General    //
// Public License along with this program; if not, see   //
// <http://www.gnu.org/licenses/>.                       //
//                                                       //
//-------------------------------------------------------//
//                                                       //
//    e-mail:     oconrad@saga-gis.org                   //
//                                                       //
//    contact:    Olaf Conrad                            //
//                Institute of Geography                 //
//                University of Hamburg                  //
//                Germany                                //
//                                                       //
///////////////////////////////////////////////////////////

//---------------------------------------------------------
#ifndef HEADER_INCLUDED__chelsa_H
#define HEADER_INCLUDED__chelsa_H


///////////////////////////////////////////////////////////
//                                                       //
//                                                       //
//                                                       //
///////////////////////////////////////////////////////////

//---------------------------------------------------------
#include <saga_api/saga_api.h>


///////////////////////////////////////////////////////////
//                                                       //
//                                                       //
//                                                       //
///////////////////////////////////////////////////////////

//---------------------------------------------------------
class CCHELSA_Global : public CSG_Tool
{
public:
	CCHELSA_Global(void);

	virtual CSG_String			Get_MenuPath			(void)	{	return( _TL("Climate Data;A:Climate and Weather|Climate Data") );	}

	virtual bool				do_Sync_Projections		(void)	const	{	return( false  );	}

	virtual bool				On_Before_Execution		(void);
	virtual bool				On_After_Execution		(void);


protected:

	virtual int                 On_Parameter_Changed	(CSG_Parameters *pParameters, CSG_Parameter *pParameter);
	virtual int					On_Parameters_Enable	(CSG_Parameters *pParameters, CSG_Parameter *pParameter);

	virtual bool				On_Execute				(void);


private:

	CSG_String					m_Folder, m_Format = "sg-grd-z";

	CSG_Parameter_Grid_List		*m_pGrids = NULL;

	CSG_Grids					*m_pCollection = NULL;

	CSG_Table					m_Attributes;

	CSG_Tool					*m_pImport = NULL, *m_pProject = NULL;

	CSG_Parameters_CRSPicker	m_CRS;


	bool						Get_Daily				(void);
	bool						Get_Monthly				(void);
	bool						Get_Climatology			(void);
	bool						Get_BioClim				(void);
	bool						Get_T21k				(void);
	bool						Get_T21k_BioClim		(void);

	CSG_Grid *					Get_Variable			(int Dataset, int VarID, const CSG_String &Path, const CSG_String &File);

	bool						Initialize				(void);
	bool						Finalize				(void);

	bool						Set_Classification		(int VarID, CSG_Grid *pVariable);

};


///////////////////////////////////////////////////////////
//                                                       //
//                                                       //
//                                                       //
///////////////////////////////////////////////////////////

//---------------------------------------------------------
#endif // #ifndef HEADER_INCLUDED__chelsa_H
