; To build installer (for example, saga-major.minor.revision_setup.exe).
; - Unzip the SAGA binary files in their own folder (for example, saga-major.minor.revision.zip).
; - Place saga.iss and saga_readme.rtf in the SAGA folder (contains saga_gui.exe, etc.).
; - Open saga.iss in Inno Setup.
; - Choose Build | Compile.
; Contributed by Philipp J. Hess

[Setup]
AppName=SAGA - System for Automated Geoscientific Analyses
AppVerName=SAGA {#GetEnv('SAGA_RELEASE')}

ArchitecturesAllowed=x64compatible
ArchitecturesInstallIn64BitMode=x64compatible

DefaultDirName={commonpf}\SAGA {#GetEnv('SAGA_RELEASE')}
DefaultGroupName=SAGA
UninstallDisplayIcon={app}\saga_gui.exe

InfoBeforeFile=saga_setup_readme.rtf

Compression=lzma
SolidCompression=yes

OutputDir=.
OutputBaseFilename=saga-{#GetEnv('SAGA_RELEASE')}_msw_setup

VersionInfoVersion={#GetEnv('SAGA_RELEASE')}
VersionInfoCompany=SAGA User Group Association
VersionInfoCopyright=(c) O.Conrad
VersionInfoDescription=SAGA single-file installer

PrivilegesRequired=admin

[Files]
; Add .exe's separately so can exclude any other .exe's (e.g., old installer).
Source: "saga_gui.exe"; DestDir: "{app}"
Source: "saga_cmd.exe"; DestDir: "{app}"
Source: "*.*"; Excludes: "*.iss,*.ini,*.cfg,*.bak,*.exe,*.bat,*.rtf"; DestDir: "{app}"
Source: "tools\*.*"; DestDir: "{app}\tools"
Source: "tools\toolchains\*.*"; DestDir: "{app}\tools\toolchains"
Source: "dll\*.*"; DestDir: "{app}\dll"; Flags: recursesubdirs
Source: "ArcSAGA\*.*"; DestDir: "{app}\ArcSAGA"
Source: "PySAGA\*.*"; DestDir: "{app}\PySAGA"; Flags: recursesubdirs

[Icons]
; Start up in tools folder so SAGA will load all tools automatically.
Name: "{commonprograms}\SAGA {#GetEnv('SAGA_RELEASE')}"; Filename: "{app}\saga_gui.exe"; WorkingDir: "{app}"
Name:  "{commondesktop}\SAGA {#GetEnv('SAGA_RELEASE')}"; Filename: "{app}\saga_gui.exe"; WorkingDir: "{app}"

[Registry]
Root: HKLM; Subkey: "SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\saga_gui.exe"; ValueType: string; ValueName: ""; ValueData: "{app}\saga_gui.exe"; Flags: uninsdeletekey
Root: HKLM; Subkey: "SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\saga_gui.exe"; ValueType: string; ValueName: "Path"; ValueData: "{app}"

Root: HKLM; Subkey: "SOFTWARE\SAGA User Group Association\SAGA\{#GetEnv('SAGA_RELEASE')}"; ValueType: string; ValueName: "InstallDir"; ValueData: "{app}"; Flags: uninsdeletekey
Root: HKLM; Subkey: "SOFTWARE\SAGA User Group Association\SAGA\{#GetEnv('SAGA_RELEASE')}"; ValueType: string; ValueName: "Version"; ValueData: "{#GetEnv('SAGA_RELEASE')}"
