// Copyright (C) 2016 The Qt Company Ltd.
// SPDX-License-Identifier: LicenseRef-Qt-Commercial OR GPL-3.0-only WITH Qt-GPL-exception-1.0

#pragma once

#include "utils_global.h"

#include <QToolButton>

namespace Utils {

class QTCREATOR_UTILS_EXPORT QtColorButton : public QToolButton
{
    Q_OBJECT
    Q_PROPERTY(bool backgroundCheckered READ isBackgroundCheckered WRITE setBackgroundCheckered)
    Q_PROPERTY(bool alphaAllowed READ isAlphaAllowed WRITE setAlphaAllowed)
    Q_PROPERTY(QColor color READ color WRITE setColor)
public:
    QtColorButton(QWidget *parent = nullptr);
    ~QtColorButton() override;

    bool isBackgroundCheckered() const;
    void setBackgroundCheckered(bool checkered);

    bool isAlphaAllowed() const;
    void setAlphaAllowed(bool allowed);

    QColor color() const;

    bool isDialogOpen() const;

public slots:
    void setColor(const QColor &color);

signals:
    void colorChangeStarted();
    void colorChanged(const QColor &color);
    void colorUnchanged();

protected:
    void paintEvent(QPaintEvent *event) override;
    void mousePressEvent(QMouseEvent *event) override;
    void mouseMoveEvent(QMouseEvent *event) override;
#ifndef QT_NO_DRAGANDDROP
    void dragEnterEvent(QDragEnterEvent *event) override;
    void dragLeaveEvent(QDragLeaveEvent *event) override;
    void dropEvent(QDropEvent *event) override;
#endif
private:
    class QtColorButtonPrivate *d_ptr;
    friend class QtColorButtonPrivate;
};

} // namespace Utils
