import logging
from _typeshed import Incomplete

from authlib.oauth1 import AuthorizationServer as _AuthorizationServer, OAuth1Request, TemporaryCredential

log: logging.Logger

class BaseServer(_AuthorizationServer):
    token_generator: Incomplete
    client_model: Incomplete
    token_model: Incomplete
    SUPPORTED_SIGNATURE_METHODS: Incomplete
    def __init__(self, client_model, token_model, token_generator=None) -> None: ...
    def get_client_by_id(self, client_id): ...
    def exists_nonce(self, nonce, request) -> bool: ...
    def create_token_credential(self, request): ...
    def check_authorization_request(self, request) -> OAuth1Request: ...
    def create_oauth1_request(self, request) -> OAuth1Request: ...
    def handle_response(self, status_code, payload, headers): ...

class CacheAuthorizationServer(BaseServer):
    def __init__(self, client_model, token_model, token_generator=None) -> None: ...
    def create_temporary_credential(self, request) -> TemporaryCredential: ...
    def get_temporary_credential(self, request) -> TemporaryCredential | None: ...
    def delete_temporary_credential(self, request) -> None: ...
    def create_authorization_verifier(self, request) -> str: ...
