import type { ISharedNotebook } from '@jupyter/ydoc';
import { DocumentRegistry } from '@jupyterlab/docregistry';
import { Contents } from '@jupyterlab/services';
import { INotebookModel } from './model';
/**
 * A model factory for notebooks.
 */
export declare class NotebookModelFactory implements DocumentRegistry.IModelFactory<INotebookModel> {
    /**
     * Construct a new notebook model factory.
     */
    constructor(options?: NotebookModelFactory.IOptions);
    /**
     * Define the disableDocumentWideUndoRedo property.
     *
     * @experimental
     * @alpha
     */
    get disableDocumentWideUndoRedo(): boolean;
    set disableDocumentWideUndoRedo(disableDocumentWideUndoRedo: boolean);
    /**
     * The name of the model.
     */
    get name(): string;
    /**
     * The content type of the file.
     */
    get contentType(): Contents.ContentType;
    /**
     * The format of the file.
     */
    get fileFormat(): Contents.FileFormat;
    /**
     * Whether the model is collaborative or not.
     */
    get collaborative(): boolean;
    /**
     * Get whether the model factory has been disposed.
     */
    get isDisposed(): boolean;
    /**
     * Dispose of the model factory.
     */
    dispose(): void;
    /**
     * Create a new model for a given path.
     *
     * @param languagePreference - An optional kernel language preference.
     *
     * @returns A new document model.
     */
    createNew(options?: DocumentRegistry.IModelOptions<ISharedNotebook>): INotebookModel;
    /**
     * Get the preferred kernel language given a path.
     */
    preferredLanguage(path: string): string;
    /**
     * Defines if the document can be undo/redo.
     */
    private _disableDocumentWideUndoRedo;
    private _disposed;
    private _collaborative;
}
/**
 * The namespace for notebook model factory statics.
 */
export declare namespace NotebookModelFactory {
    /**
     * The options used to initialize a NotebookModelFactory.
     */
    interface IOptions {
        /**
         * Whether the model is collaborative or not.
         */
        collaborative?: boolean;
        /**
         * Defines if the document can be undo/redo.
         *
         * Default: true
         *
         * @experimental
         * @alpha
         */
        disableDocumentWideUndoRedo?: boolean;
    }
}
