# Installation
> `npm install --save @types/create-react-class`

# Summary
This package contains type definitions for create-react-class (https://facebook.github.io/react/).

# Details
Files were exported from https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/create-react-class.
## [index.d.ts](https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/create-react-class/index.d.ts)
````ts
import { Component, ComponentClass, ComponentLifecycle, ReactNode, ValidationMap } from "react";

declare namespace createReactClass {
    interface Mixin<P, S> extends ComponentLifecycle<P, S> {
        mixins?: Array<Mixin<P, S>> | undefined;
        statics?: {
            [key: string]: any;
        } | undefined;

        displayName?: string | undefined;
        propTypes?: ValidationMap<any> | undefined;
        contextTypes?: ValidationMap<any> | undefined;
        childContextTypes?: ValidationMap<any> | undefined;

        getDefaultProps?(): P;
        getInitialState?(): S;
    }

    interface ComponentSpec<P, S> extends Mixin<P, S> {
        render(): ReactNode;

        [propertyName: string]: any;
    }
    interface ClassicComponent<P = {}, S = {}> extends Component<P, S> {
        replaceState(nextState: S, callback?: () => void): void;
        isMounted(): boolean;
        getInitialState?(): S;
    }

    interface ClassicComponentClass<P = {}> extends Omit<ComponentClass<P>, "new"> {
        new(props: P, context?: any): ClassicComponent<P, any>;
        getDefaultProps?(): P;
    }
}
declare function createReactClass<P, S = {}>(
    spec: createReactClass.ComponentSpec<P, S>,
): createReactClass.ClassicComponentClass<P>;

export as namespace createReactClass;
export = createReactClass;

````

### Additional Details
 * Last updated: Sat, 06 Jan 2024 09:35:38 GMT
 * Dependencies: [@types/react](https://npmjs.com/package/@types/react)

# Credits
These definitions were written by [John Gozde](https://github.com/jgoz).
