// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
import { Token } from '@lumino/coreutils';
/**
 * The file browser factory token.
 */
export const IFileBrowserFactory = new Token('@jupyterlab/filebrowser:IFileBrowserFactory', `A factory object that creates file browsers.
  Use this if you want to create your own file browser (e.g., for a custom storage backend),
  or to interact with other file browsers that have been created by extensions.`);
/**
 * The default file browser token.
 */
export const IDefaultFileBrowser = new Token('@jupyterlab/filebrowser:IDefaultFileBrowser', 'A service for the default file browser.');
/**
 * The token that indicates the default file browser commands are loaded.
 */
export const IFileBrowserCommands = new Token('@jupyterlab/filebrowser:IFileBrowserCommands', 'A token to ensure file browser commands are loaded.');
//# sourceMappingURL=tokens.js.map