# Copyright 2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License"). You
# may not use this file except in compliance with the License. A copy of
# the License is located at
#
#     http://aws.amazon.com/apache2.0/
#
# or in the "license" file accompanying this file. This file is
# distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF
# ANY KIND, either express or implied. See the License for the specific
# language governing permissions and limitations under the License.
from awscli.customizations.logs.tail import TailCommand
from awscli.customizations.logs.startlivetail import StartLiveTailCommand


def register_logs_commands(event_emitter):
    event_emitter.register('building-command-table.logs', inject_tail_command)
    event_emitter.register(
        'building-command-table.logs', inject_start_live_tail_command
    )


def inject_tail_command(command_table, session, **kwargs):
    command_table['tail'] = TailCommand(session)


def inject_start_live_tail_command(command_table, session, **kwargs):
    command_table['start-live-tail'] = StartLiveTailCommand(session)
