// Copyright (c) 2023, the Dart project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

import 'common/service_test_common.dart';
import 'common/test_helper.dart';

// AUTOGENERATED START
//
// Update these constants by running:
//
// dart pkg/vm_service/test/update_line_numbers.dart <test.dart>
//
const LINE_A = 19;
// AUTOGENERATED END

const file = 'step_through_setter_test.dart';

void code() /* LINE_A */ {
  final bar = Bar();
  bar.barXYZ = 42;
  fooXYZ = 42;
}

// ignore: unused_element
int _xyz = -1;

set fooXYZ(int i) {
  _xyz = i - 1;
}

class Bar {
  int _xyz = -1;

  set barXYZ(int i) {
    _xyz = i - 1;
  }

  int get barXYZ => _xyz + 1;
}

final stops = <String>[];
const expected = <String>[
  '$file:${LINE_A + 0}:10', // after 'code'
  '$file:${LINE_A + 1}:15', // on 'Bar'

  '$file:${LINE_A + 2}:7', // on 'barXYZ'
  '$file:${LINE_A + 16}:18', // on 'i'
  '$file:${LINE_A + 17}:14', // on '-'
  '$file:${LINE_A + 17}:5', // on '_xyz'
  '$file:${LINE_A + 18}:3', // on '}'

  '$file:${LINE_A + 3}:3', // on 'fooXYZ'
  '$file:${LINE_A + 9}:16', // on 'i'
  '$file:${LINE_A + 10}:12', // on '-'
  '$file:${LINE_A + 11}:1', // on '}'

  '$file:${LINE_A + 4}:1', // on ending '}'
];

final tests = <IsolateTest>[
  hasPausedAtStart,
  setBreakpointAtLine(LINE_A),
  runStepIntoThroughProgramRecordingStops(stops),
  checkRecordedStops(
    stops,
    expected,
    debugPrint: true,
    debugPrintFile: file,
    debugPrintLine: LINE_A,
  ),
];

void main([args = const <String>[]]) => runIsolateTestsSynchronous(
      args,
      tests,
      'step_through_setter_test.dart',
      testeeConcurrent: code,
      pauseOnStart: true,
      pauseOnExit: true,
    );
