@page CHANGES-2-1 Version 2.1

Version 2.1.0 (September 15, 2014)
----------------------------

Version 2.1 contains several improvements with respect to 2.0. Users currently working with 2.0 
should have a look at the section "Changes leading to incompatible behavior" below and
might need tiny adjustments in their input files. In 2.1 we restored more features of 1.3
that were missing in 2.0, so users still working with 1.3 could opt for an upgrade.
A tutorial explaining how to move from PLUMED 1 to PLUMED 2 is available (see \ref moving).

Below you find a list of all the changes with respect to version 2.0.
Notice that version 2.1 includes already all the fixes in branch 2.0 up to 2.0.4.

Changes from version 2.0 which are relevant for users:
- Changes leading to incompatible behavior:
  - \ref COORDINATION now skips pairs of one atom with itself.
  - Labels of quantities calculated by \ref BIASVALUE have changed from <i>label</i>.bias.<i>argname</i> to <i>label</i>.<i>argname</i>_bias, which is more consistent with steered MD
  - Labels of quantities calculated by \ref ABMD have change from <i>label</i>.min_<i>argname</i> to <i>label</i>.<i>argname</i>_min, which is more consistent with steered MD
  - Labels of quantities calculated by \ref PIECEWISE have change from <i>label</i>.<i>argnumber</i> to <i>label</i>.<i>argname</i>_pfunc, which is more consistent with steered MD
  - For multicolvars components calculated with LESS_THAN and MORE_THAN keywords are now labelled lessthan and morethan. This change is necessary as the underscore
character now has a special usage in component names.
  - In \ref CONTACTMAP components are now labelled <i>label</i>.contact-\f$n\f$.
  - The command SPHERE has been replaced by \ref UWALLS.
- New configuration system based on autoconf (use ./configure from root directory).
  Optional packages are detected at compile time and correctly
  enabled or disabled. An internal version of LAPACK and BLAS will be used
  if these libraries are not installed.
- New actions:
  - \ref SPRINT topological collective variables.
  - CH3SHIFTS collective variable.
  - \ref POSITION collective variable.
  - \ref FIT_TO_TEMPLATE.
  - \ref COMMITTOR analysis.
  - \ref LOCAL_AVERAGE.
  - \ref NLINKS.
  - \ref DIHCOR.
  - \ref NOE.
  - \ref RDC. 
  - \ref CLASSICAL_MDS.
  - \ref XDISTANCES.
  - \ref YDISTANCES.
  - \ref ZDISTANCES.
  - \ref DUMPMULTICOLVAR.
  - Crystallization module, including \ref Q3, \ref LOCAL_Q3, \ref Q4, \ref Q6, \ref LOCAL_Q4, \ref LOCAL_Q6, \ref MOLECULES, \ref SIMPLECUBIC, \ref TETRAHEDRAL and \ref FCCUBIC.
  - \ref ENSEMBLE to perform Replica-Averaging on any collective variable.
- New features for existing actions:
  - \ref METAD : WALKERS_MPI flag (multiple walkers in a mpi-based multi-replica framework),
    ACCELERATION flag (calculate on the fly the Metadynamics acceleration factor),
    TAU option (alternative way to set Gaussian height in well-tempered metadynamics),
    GRID_SPACING (alternative to GRID_BIN to set grid spacing).
    Notice that now one can also omit GRID_BIN and GRID_SPACING when using
    fixed size Gaussian, and the grid spacing will be automatically set.
  - \ref DISTANCE : added SCALED_COMPONENTS
  - \ref COORDINATION : if a single group is provided, it avoids permuted atom indexes and runs
    at twice the speed.
  - \ref DUMPATOMS : PRECISION option to set number of digits in output file.
  - \ref GROUP : NDX_FILE and NDX_GROUP options to import atom lists from ndx (gromacs) files.
  - In many multicolvars, MIN and MAX options can be used.
  - \ref HISTOGRAM : GRID_SPACING (alternative to GRID_BIN to set grid spacing),
    FREE-ENERGY flags in addition to standard probability density,
    additional option for KERNEL=DISCRETE to accumulate standard histograms. 
  - \ref sum_hills : added options --spacing (alternative to --bin to set grid spacing)
    and --setmintozero to translate the minimum of the output files to zero.
  - \ref CONTACTMAP : parallelized and added weights.
- New features in MD patches (require re-patch):
  - New patch for Gromacs 5.0
  - Gromacs 4.6.X patch updated to 4.6.7
  - Gromacs 4.6.7 supports \ref COMMITTOR analysis; can be now be used to perform energy minimization;
     now passes temperature to PLUMED (this allows temperature to be omitted in some actions,
     namely \ref METAD and analysis actions).
  .
  Notice that if you use runtime binding it is not compulsory to re-patch,
  and that all combinations should work correctly
  (new/old PLUMED with re-patched/non-re-patched MD code).
- Other new features:
  - \ref driver can now read trajectories in many formats using VMD molfile plugin
    (requires VMD plugins to be compiled and installed). In case VMD plugins are not installed,
    the configuration system falls back to an internal version which implements a minimal list
    of plugins (gromacs and dcd) (kindly provided by T. Giorgino).
  - \ref switchingfunction : added STRETCH flag.
  - Negative strides in atom ranges (e.g. ATOMS=10-1:-3 is expanded to ATOMS=10,7,4,1).
  - \ref COORDINATION and \ref DHENERGY with NLIST now work correctly in replica exchange simulations.
  - Multicolvars with neighbor lists now work correctly in replica exchange simulations.
  - Improved multicolvar neighbor lists.
- Optimization:
  - Root-mean-square deviations with align weights different from displace weights
    are now considerably faster. This will affect \ref RMSD calculations plus
    other variables based on RMSD.
  - \ref WHOLEMOLECULES is slightly faster.
  - \ref COORDINATION is slightly faster when NN and MM are even and D_0=0.
  - Atom scattering with domain decomposition is slightly faster.
  - Link cells are now exploited in some multicolvars.
  - Derivatives are not calculated unless they are specifically required, because for instance you are adding
    a bias.
- Documentation:
  - All tutorial material from the recent plumed meeting in Belfast is now in the manual
  - Improvements to documentation, including lists of quantities that are output by each action that can be referenced 
  - Manual has been re-organized following suggestions received at the plumed meeting.
  - An experimental PDF version of the manual is now provided (a link can be found in the documentation homepage).

Changes from version 2.0 which are relevant for developers:
- Added regtests for plumed as a library (e.g. basic/rt-make-0). plumed command has an additional
  flag (--is-installed) to probe if running from a compilation directory or from a fully installed copy
  (this is needed for regtests to work properly).
- Improved class Communicator. Many operations can now be done directly on Vectors, Tensors, std::vector and PLMD::Matrix.
- Modified class RMSD.
- Patches for GPL codes (Quantum Espresso and Gromacs) now also include
  original code so as to simplify their modification.
- Fixed dependencies among actions such that it is now possible (and reliable)
  to use MPI calls inside Action::prepare()
- colvar/CoordinationBase.cpp has been changed to make it faster. If you devised a class which inherits from here,
  consider that CoordinationBase::pairing now needs _squared_ distance instead of distance
- It is possible to run "make install" from sub-directories (e.g. from src/colvar)
- There is a small script which disables/enables all optional modules (make mod-light/mod-heavy/mod-reset)
- Added "-q" option to plumed patch
- You can now create new metrics to measure distances from a reference configurations. If you do so such
  metrics can then be used in paths straightforwardly
- You can now use multicolvars in tandem with manyrestraints in order to add a large numbers of restraints.
- Can now do multicolvar like things in which each colvar is a vector rather than a scalar.
- Updated script that generated header files so that they properly show years. Notice that the script
  should new be run from within a git repository

This list is likely incomplete, if you are developing in PLUMED you are encouraged to follow changes on github.

Version 2.1.1 (December 15, 2014)
----------------------------------------------

This release includes all the fixes available in branch 2.0 until 2.0.5.

For users:
- New patch for AMBER 14 (sander module only). This patch should be compatible
  with any PLUMED 2 version (including 2.0). It includes most PLUMED features
  with the notable exception of multi-replica framework.
- Changed definition in arbitrary phase of eigenvectors. This will change the result of some
  analysis method where the phase does matter (e.g. \ref CLASSICAL_MDS) and make
  some regression test better reproducible.
- Fixed a portability issue in BG/P where gettimeofday is not implemented.
  Notice that this fix implies that one should execute again ./configure to have
  plumed timing working correctly.
- CS2Backbone: fixed a bug that resulted in only a fraction of the chemical shifts being printed with WRITE_CS and 
  parallel simulations (requires to get the last almost updated from SVN)
- NOE: fixed a bug in the replica-averaging
- Fixed a linking issue with ALMOST, where bz2 was always used to link ALMOST to PLUMED even if it is not compulsory 
  to build ALMOST.
- Fixed a wrong include in the GMX5 patch.
- \ref FUNCPATHMSD can now be used together with \ref CONTACTMAP to define pathways in contact-map space
- Configuration is more verbose, a warning is given if a default option cannot be enabled and an error is given if 
  an option explicitly enabled cannot be enabled.
- Compilation is less verbose (use "make VERBOSE=1" to have old behavior)
- Small fixes in documentation.

For developers:
- Tests are now performed at every single push on travis-ci.org
- Manual is built and pushed to the online server from travis-ci.org (see developer doc)
- Fixes in developer doc.

Version 2.1.2 (Mar 16, 2015)
----------------------------------------------

For users:
- Added two new short tutorials to the manual ( \ref cambridge and \ref munster ).
- Fixed a severe bug on \ref DRMSD - cutoff values were ignored by PLUMED.
  Notice that this bug was introduced in 2.1.0, so that it should not affect the 2.0.x series.
- Fixed a bug affecting LAMMPS patch used with a single processor. Notice that
  the fix is inside PLUMED, thus it does not necessarily requires re-patching.
- Sander patch now works with multiple replica (no replica exchange yet). It also contains
  some fix from J. Swails.
- GMX5 patch was not working for bias-exchange like cases
- Patching system now checks for the availability of shared/static/runtime version of plumed before
  patching
- Configure now check better if compiler flag are accepted by the compiler. This makes
  configure on bluegene more robust.
- Sourceme.sh now sets proper library path in linux also.


Version 2.1.3 (June 30, 2015)
----------------------------------------------

For users:
- Fixed bug in \ref ENSEMBLE derivatives when more than 1 argument was provided
- Fixed bug in \ref GHOST : virial is now computed correctly.
- Fixed a serious bug in virial communicated from plumed to gromacs, for both gromacs versions 4.6 and 5.0.
  See \issue{132}.
  This fix requires gromacs to be re-patched and could be very important if you run biased simulations in the NPT ensemble.
- Fixed a bug in the virial computed with \ref FIT_TO_TEMPLATE when the reference pdb had center non located at the origin.
- Fixed a bug in the the forces computed with \ref FIT_TO_TEMPLATE when used in combination with \ref COM, \ref CENTER, or \ref GHOST
- Fixed a bug that could lead plumed to be stuck with domain decomposition in some extreme case (one domain with all atoms, other domains empty).
- Fixed a bug when \ref COMBINE or \ref MATHEVAL are used with PERIODIC keyword. Now when PERIODIC keyword is used the result
  of the calculation is brought within the periodicity domain. See \issue{139}.
- Fixed a bug related to \ref RANDOM_EXCHANGES followed by \ref INCLUDE
- Fixed bug in derivatives of histogram bead with triangular kernels
- Updated gromacs patch 4.5.5 to 4.5.7
- Updated internal molfile plugins to VMD 1.9.2.
- Included crd and crdbox formats to internal molfile.
- Added --natoms to \ref driver . This is required to read coordinate
  files with VMD plugins when number of atoms is not present (e.g. amber
  crd files)
- Added the checks in the driver to detect cases where molinfo does not provide box information
  (e.g. pdb).
- Added support for readdir_r when available, which makes opening files thread safe.
- CFLAGS now include -fPIC by default
- Added a warning when using \ref METAD without grids with a large number of hills.
- Fixes in user documentation.

For developers:
- Allow external VMD plugins to be detected with --has-external-molfile. This
  is required to enable some regtest with amber files.
- Added --dump-full-virial to \ref driver
- Allow definition of variables where some of the components have derivatives and some haven't (\issue{131}).
- Improved travis tests with more debug options.
- Improved some regtest to check out-of-diagonal virial components
- Improved make cppcheck options.
- Fixes in developer documentation.

Version 2.1.4 (Oct 13, 2015)
-----------------------------

For users:
- Fixed NAMD patch. Masses and charges were not passed correctly, thus resulting in wrong
  \ref COM or \ref CENTER with MASS.
  This fix required re-patching NAMD.
  Notice that this bug was present also in v2.0 but in a different form.
  More information here (\issue{162}), including a workaround that allows masses to be fixed
  without re-patching.
- When installing with PLUMED_LIBSUFFIX an underscore is used as separator instead of a dash.
  E.g. `make install PLUMED_LIBSUFFIX=2.1` will result in an executable named `plumed_v2.1`.
  This fix a potential problem (see \ref Installation).
- Fixed erroneously reported message about MPI at the end of ./configure.
- Changed warning message about undocumented components.
- PLUMED now says in the log file if it was compiled from a dirty git repository.
- Fixed a problem leading to rare random crashes when using \ref METAD with WALKERS_MPI and multiple
  processors per replica.
- Small change in numerical accuracy of lattice reduction. Should be more
  robust when running with highly optimizing compilers.
- Fixed a bug in normalization of kernel functions.  This affects \ref HISTOGRAM
  If these actions were used with previous versions of the code care should be taken when analyzing the 
  results.
- Fixed a bug in derivatives of kernel functions with non-diagonal covariance matrices. This affects the 
  derivatives output by \ref sum_hills

Version 2.1.5 (Jan 18, 2016)
---------------------------------------------

\plumednotmaintained

For users:
- PLUMED now reports an error when using \ref HISTOGRAM with FREE-ENERGY without USE_ALL_DATA. See \issue{175}
- Fixed a bug in configure together with --enable-almost. The check for lbz2 library was not working properly.

