/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ebnf;

import net.sourceforge.plantuml.ebnf.Brace;
import net.sourceforge.plantuml.ebnf.CornerCurved;
import net.sourceforge.plantuml.ebnf.ETile;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.UText;
import net.sourceforge.plantuml.style.ISkinParam;

public class ETileOneOrMore
extends ETile {
    private final double deltax = 15.0;
    private final double deltay = 12.0;
    private final ETile orig;
    private final UText loop;
    private final FontConfiguration fc;

    public ETileOneOrMore(ETile orig, String loop, FontConfiguration fc, ISkinParam skinParam) {
        this.orig = orig;
        this.fc = fc;
        this.loop = loop == null ? null : UText.build(loop, fc);
    }

    public ETileOneOrMore(ETile orig) {
        this(orig, null, null, null);
    }

    @Override
    public double getH1(StringBounder stringBounder) {
        double h1 = 12.0 + this.orig.getH1(stringBounder);
        if (this.loop != null) {
            h1 += this.getBraceHeight();
        }
        return h1;
    }

    private double getBraceHeight() {
        if (this.loop == null) {
            return 0.0;
        }
        return 15.0;
    }

    @Override
    public double getH2(StringBounder stringBounder) {
        return this.orig.getH2(stringBounder);
    }

    @Override
    public double getWidth(StringBounder stringBounder) {
        return this.orig.getWidth(stringBounder) + 30.0;
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        XDimension2D fullDim = this.calculateDimension(stringBounder);
        double h1 = this.getH1(stringBounder);
        CornerCurved.createSW(8.0).drawU(ug.apply(new UTranslate(8.0, h1)));
        this.drawVline(ug, 8.0, 13.0 + this.getBraceHeight(), h1 - 8.0);
        CornerCurved.createNW(8.0).drawU(ug.apply(new UTranslate(8.0, 5.0 + this.getBraceHeight())));
        this.drawHlineAntiDirected(ug, 5.0 + this.getBraceHeight(), 15.0, fullDim.getWidth() - 15.0, 0.6);
        CornerCurved.createSE(8.0).drawU(ug.apply(new UTranslate(fullDim.getWidth() - 8.0, h1)));
        this.drawVline(ug, fullDim.getWidth() - 8.0, 13.0 + this.getBraceHeight(), h1 - 8.0);
        CornerCurved.createNE(8.0).drawU(ug.apply(new UTranslate(fullDim.getWidth() - 8.0, 5.0 + this.getBraceHeight())));
        this.drawHline(ug, h1, 0.0, 15.0);
        this.drawHline(ug, h1, fullDim.getWidth() - 15.0, fullDim.getWidth());
        this.orig.drawU(ug.apply(new UTranslate(15.0, 12.0 + this.getBraceHeight())));
        if (this.loop != null) {
            new Brace(fullDim.getWidth(), 10.0).drawU(ug.apply(new UTranslate(0.0, 10.0)));
            XDimension2D dimText = stringBounder.calculateDimension(this.fc.getFont(), this.loop.getText());
            double descent = stringBounder.getDescent(this.fc.getFont(), this.loop.getText());
            ug.apply(new UTranslate((fullDim.getWidth() - dimText.getWidth()) / 2.0, descent)).draw(this.loop);
        }
    }

    @Override
    public void push(ETile tile) {
        throw new UnsupportedOperationException();
    }
}

