/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client.service;

import com.azul.crs.client.Client;
import com.azul.crs.client.PerformanceMetrics;
import com.azul.crs.client.Response;
import com.azul.crs.client.Result;
import com.azul.crs.client.service.ClientService;
import com.azul.crs.client.service.QueueService;
import com.azul.crs.shared.Utils;
import com.azul.crs.shared.models.VMArtifactChunk;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collection;

public class UploadService
implements ClientService {
    private static final int MAX_QUEUE_SIZE = 50000;
    private static final int MAX_WORKERS = 1;
    private static final int BATCH_SIZE = 1;
    private boolean isConnected;
    private final QueueService<Job> queue = new QueueService.Builder().maxQueueSize(50000).maxBatchSize(1).maxWorkers(1).processBatch(this::send).stopMarker(new Job(null, null, null)).name("UPLOAD").build();
    private final Client client;

    public UploadService(Client client) {
        this.client = client;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop(long deadline) {
        if (Utils.currentTimeCount() < deadline) {
            this.logger().info("awaiting artifact data to flush to the cloud", new Object[0]);
            this.queue.stop(deadline);
        } else {
            this.logger().debug("skipping flush of artifact data to the cloud because no time left", new Object[0]);
        }
    }

    public void cancel() {
        this.queue.cancel();
    }

    public void connectionEstablished() {
        this.isConnected = true;
        this.logger().trace("connection established, sending artifact data to the cloud", new Object[0]);
        this.queue.start();
    }

    public void post(VMArtifactChunk chunk, File chunkData, Client.UploadListener<VMArtifactChunk> listener) {
        this.queue.add(new Job(chunk, chunkData, listener));
    }

    public void sync(long deadline) {
        if (Utils.currentTimeCount() < deadline) {
            this.logger().trace("syncing artifact data to the cloud", new Object[0]);
            this.queue.sync(deadline);
        } else {
            this.logger().debug("not syncing artifact data to the cloud because no time left", new Object[0]);
        }
    }

    private void send(String workerId, Collection<Job> jobs) {
        Job job = jobs.iterator().next();
        VMArtifactChunk chunk = job.getChunk();
        try {
            File data = job.getData();
            PerformanceMetrics.logArtifactBytes(data.length());
            this.logger().trace("uploading " + data.getName(), new Object[0]);
            Response<String[]> response = this.client.getConnectionManager().sendVMArtifactChunk(chunk, new FileInputStream(data));
            this.logger().trace("upload finished", new Object[0]);
            if (response.successful()) {
                job.getListener().uploadComplete(chunk);
            } else {
                job.getListener().uploadFailed(chunk, new Result<String[]>(response));
            }
        }
        catch (IOException e) {
            job.getListener().uploadFailed(chunk, new Result<String[]>(e));
        }
    }

    private class Job {
        private VMArtifactChunk chunk;
        private File data;
        private Client.UploadListener<VMArtifactChunk> listener;

        public Job(VMArtifactChunk chunk, File data, Client.UploadListener<VMArtifactChunk> listener) {
            this.chunk = chunk;
            this.data = data;
            this.listener = listener;
        }

        public VMArtifactChunk getChunk() {
            return this.chunk;
        }

        public File getData() {
            return this.data;
        }

        public Client.UploadListener<VMArtifactChunk> getListener() {
            return this.listener;
        }
    }
}

