/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.util.Iterator;
import sun.security.provider.SunEntries;
import sun.security.rsa.SunRsaSignEntries;

public final class VerificationProvider
extends Provider {
    private static final long serialVersionUID = 7482667077568930381L;
    private static final boolean ACTIVE;

    public VerificationProvider() {
        super("SunJarVerification", 1.8, "Jar Verification Provider");
        if (!ACTIVE) {
            return;
        }
        VerificationProvider verificationProvider = this;
        final Iterator<Provider.Service> iterator = new SunEntries(verificationProvider).iterator();
        final Iterator<Provider.Service> iterator2 = new SunRsaSignEntries(verificationProvider).iterator();
        if (System.getSecurityManager() == null) {
            this.putEntries(iterator);
            this.putEntries(iterator2);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Void run() {
                    VerificationProvider.this.putEntries(iterator);
                    VerificationProvider.this.putEntries(iterator2);
                    return null;
                }
            });
        }
    }

    void putEntries(Iterator<Provider.Service> iterator) {
        while (iterator.hasNext()) {
            this.putService(iterator.next());
        }
    }

    static {
        boolean bl;
        try {
            Class.forName("sun.security.provider.Sun");
            Class.forName("sun.security.rsa.SunRsaSign");
            bl = false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            bl = true;
        }
        ACTIVE = bl;
    }
}

