/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap.sasl;

import com.sun.jndi.ldap.Connection;
import com.sun.jndi.ldap.LdapClient;
import com.sun.jndi.ldap.LdapResult;
import com.sun.jndi.ldap.sasl.DefaultCallbackHandler;
import com.sun.jndi.ldap.sasl.SaslInputStream;
import com.sun.jndi.ldap.sasl.SaslOutputStream;
import com.sun.jndi.ldap.sasl.TlsChannelBinding;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.naming.AuthenticationException;
import javax.naming.AuthenticationNotSupportedException;
import javax.naming.NamingException;
import javax.naming.ldap.Control;
import javax.net.ssl.SSLSocket;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;

public final class LdapSasl {
    private static final String SASL_CALLBACK = "java.naming.security.sasl.callback";
    private static final String SASL_AUTHZ_ID = "java.naming.security.sasl.authorizationId";
    private static final String SASL_REALM = "java.naming.security.sasl.realm";
    private static final int LDAP_SUCCESS = 0;
    private static final int LDAP_SASL_BIND_IN_PROGRESS = 14;
    private static final byte[] NO_BYTES = new byte[0];

    private LdapSasl() {
    }

    public static void checkSaslParameters(Hashtable<?, ?> hashtable) throws NamingException {
        TlsChannelBinding.TlsChannelBindingType tlsChannelBindingType = TlsChannelBinding.parseType((String)hashtable.get("com.sun.jndi.ldap.tls.cbtype"));
        if (tlsChannelBindingType == TlsChannelBinding.TlsChannelBindingType.TLS_SERVER_END_POINT) {
            Object obj = hashtable.get("com.sun.jndi.ldap.connect.timeout");
            int n = -1;
            if (obj != null) {
                n = Integer.parseInt((String)obj);
            }
            if (n <= 0) {
                throw new NamingException("com.sun.jndi.ldap.tls.cbtype property requires com.sun.jndi.ldap.connect.timeout property is set.");
            }
        }
    }

    public static LdapResult saslBind(LdapClient ldapClient, Connection connection, String string, String string2, Object object, String string3, Hashtable<?, ?> hashtable, Control[] controlArray) throws IOException, NamingException {
        CallbackHandler callbackHandler;
        SaslClient saslClient = null;
        boolean bl = false;
        CallbackHandler callbackHandler2 = callbackHandler = hashtable != null ? (CallbackHandler)hashtable.get(SASL_CALLBACK) : null;
        if (callbackHandler == null) {
            callbackHandler = new DefaultCallbackHandler(string2, object, (String)hashtable.get(SASL_REALM));
            bl = true;
        }
        String string4 = hashtable != null ? (String)hashtable.get(SASL_AUTHZ_ID) : null;
        String[] stringArray = LdapSasl.getSaslMechanismNames(string3);
        if (hashtable.get("jdk.internal.sasl.tlschannelbinding") != null) {
            throw new NamingException("jdk.internal.sasl.tlschannelbinding property cannot be set explicitly");
        }
        Hashtable hashtable2 = hashtable;
        try {
            Object object2;
            Object[] objectArray;
            Object object3;
            Object object4;
            if (connection.sock instanceof SSLSocket && (object4 = TlsChannelBinding.parseType((String)hashtable.get("com.sun.jndi.ldap.tls.cbtype"))) == TlsChannelBinding.TlsChannelBindingType.TLS_SERVER_END_POINT) {
                object3 = (SSLSocket)connection.sock;
                objectArray = ((SSLSocket)object3).getUseClientMode() ? (Object[])((SSLSocket)object3).getSession().getPeerCertificates() : (Object[])((SSLSocket)object3).getSession().getLocalCertificates();
                if (objectArray != null && objectArray.length > 0 && objectArray[0] instanceof X509Certificate) {
                    object2 = TlsChannelBinding.create((X509Certificate)objectArray[0]);
                    hashtable2 = (Hashtable)hashtable.clone();
                    hashtable2.put("jdk.internal.sasl.tlschannelbinding", ((TlsChannelBinding)object2).getData());
                } else {
                    throw new SaslException("No suitable certificate to generate TLS Channel Binding data");
                }
            }
            if ((saslClient = Sasl.createSaslClient(stringArray, string4, "ldap", string, hashtable2, callbackHandler)) == null) {
                throw new AuthenticationNotSupportedException(string3);
            }
            object3 = saslClient.getMechanismName();
            objectArray = saslClient.hasInitialResponse() ? saslClient.evaluateChallenge(NO_BYTES) : null;
            object4 = ldapClient.ldapBind(null, (byte[])objectArray, controlArray, (String)object3, true);
            while (!(saslClient.isComplete() || ((LdapResult)object4).status != 14 && ((LdapResult)object4).status != 0)) {
                objectArray = saslClient.evaluateChallenge(((LdapResult)object4).serverCreds != null ? ((LdapResult)object4).serverCreds : NO_BYTES);
                if (((LdapResult)object4).status == 0) {
                    if (objectArray == null) break;
                    throw new AuthenticationException("SASL client generated response after success");
                }
                object4 = ldapClient.ldapBind(null, (byte[])objectArray, controlArray, (String)object3, true);
            }
            if (((LdapResult)object4).status == 0) {
                if (!saslClient.isComplete()) {
                    throw new AuthenticationException("SASL authentication not complete despite server claims");
                }
                object2 = (String)saslClient.getNegotiatedProperty("javax.security.sasl.qop");
                if (object2 != null && (((String)object2).equalsIgnoreCase("auth-int") || ((String)object2).equalsIgnoreCase("auth-conf"))) {
                    SaslInputStream saslInputStream = new SaslInputStream(saslClient, connection.inStream);
                    SaslOutputStream saslOutputStream = new SaslOutputStream(saslClient, connection.outStream);
                    connection.replaceStreams(saslInputStream, saslOutputStream);
                } else {
                    saslClient.dispose();
                }
            }
            object2 = object4;
            return object2;
        }
        catch (SaslException saslException) {
            AuthenticationException authenticationException = new AuthenticationException(string3);
            authenticationException.setRootCause(saslException);
            throw authenticationException;
        }
        finally {
            if (bl) {
                ((DefaultCallbackHandler)callbackHandler).clearPassword();
            }
        }
    }

    private static String[] getSaslMechanismNames(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        Vector<String> vector = new Vector<String>(10);
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }
}

