/*
 * Decompiled with CFR 0.152.
 */
package org.openjsse.sun.security.ssl;

import java.io.IOException;
import java.security.AccessController;
import java.security.AlgorithmConstraints;
import org.openjsse.sun.security.ssl.CertificateMessage;
import org.openjsse.sun.security.ssl.HandshakeContext;
import org.openjsse.sun.security.ssl.SSLAlgorithmDecomposer;
import org.openjsse.sun.security.ssl.SSLContextImpl;
import org.openjsse.sun.security.ssl.SSLHandshake;
import org.openjsse.sun.security.ssl.SSLPossession;
import org.openjsse.sun.security.ssl.StatusResponseManager;
import org.openjsse.sun.security.ssl.TransportContext;
import org.openjsse.sun.security.ssl.Utilities;
import sun.security.action.GetLongAction;
import sun.security.util.LegacyAlgorithmConstraints;

class ServerHandshakeContext
extends HandshakeContext {
    static final boolean rejectClientInitiatedRenego = Utilities.getBooleanProperty("jdk.tls.rejectClientInitiatedRenegotiation", false);
    static final AlgorithmConstraints legacyAlgorithmConstraints = new LegacyAlgorithmConstraints("jdk.tls.legacyAlgorithms", new SSLAlgorithmDecomposer());
    SSLPossession interimAuthn;
    StatusResponseManager.StaplingParameters stapleParams;
    CertificateMessage.CertificateEntry currentCertEntry;
    private static final long DEFAULT_STATUS_RESP_DELAY = 5000L;
    final long statusRespTimeout;

    ServerHandshakeContext(SSLContextImpl sslContext, TransportContext conContext) throws IOException {
        super(sslContext, conContext);
        long respTimeOut = AccessController.doPrivileged(new GetLongAction("jdk.tls.stapling.responseTimeout", 5000L));
        this.statusRespTimeout = respTimeOut >= 0L ? respTimeOut : 5000L;
        this.handshakeConsumers.put(SSLHandshake.CLIENT_HELLO.id, SSLHandshake.CLIENT_HELLO);
    }

    @Override
    void kickstart() throws IOException {
        if (!this.conContext.isNegotiated || this.kickstartMessageDelivered) {
            return;
        }
        SSLHandshake.kickstart(this);
        this.kickstartMessageDelivered = true;
    }
}

