/*
 * Copyright (c) 2012, 2021, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2020 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_yi extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_FJ = "\u05e4\u05bf\u05d9\u05d3\u05d6\u05e9\u05d9";
        final String metaValue_ar = "\u05d0\u05b7\u05e8\u05d0\u05b7\u05d1\u05d9\u05e9";
        final String metaValue_el = "\u05d2\u05e8\u05d9\u05db\u05d9\u05e9";
        final Object[][] data = new Object[][] {
            { "PR", "\u05e4\u05bc\u05d0\u05e8\u05d8\u05d0\u05be\u05e8\u05d9\u05e7\u05d0" },
            { "ps", "\u05e4\u05bc\u05d0\u05b7\u05e9\u05d8\u05d0\u05b8" },
            { "PT", "\u05e4\u05bc\u05d0\u05e8\u05d8\u05d5\u05d2\u05d0\u05b7\u05dc" },
            { "pt", "\u05e4\u05bc\u05d0\u05e8\u05d8\u05d5\u05d2\u05e2\u05d6\u05d9\u05e9" },
            { "fil", "\u05e4\u05bf\u05d9\u05dc\u05d9\u05e4\u05bc\u05d9\u05e0\u05d0" },
            { "PY", "\u05e4\u05bc\u05d0\u05b7\u05e8\u05d0\u05b7\u05d2\u05d5\u05d5\u05f2\u05b7" },
            { "lus", "\u05de\u05d9\u05d6\u05d0" },
            { "ban", "\u05d1\u05d0\u05b7\u05dc\u05d9\u05e0\u05e2\u05d6\u05d9\u05e9" },
            { "Hebr", "\u05d4\u05e2\u05d1\u05e8\u05e2\u05d9\u05e9" },
            { "QA", "\u05e7\u05d0\u05b7\u05d8\u05d0\u05b7\u05e8" },
            { "bar", "\u05d1\u05f2\u05b7\u05e2\u05e8\u05d9\u05e9" },
            { "sco", "\u05e1\u05e7\u05d0\u05d8\u05e1" },
            { "scn", "\u05e1\u05d9\u05e6\u05d9\u05dc\u05d9\u05d0\u05b7\u05e0\u05d9\u05e9" },
            { "aa", "\u05d0\u05b7\u05e4\u05bf\u05d0\u05b7\u05e8" },
            { "AD", "\u05d0\u05b7\u05e0\u05d3\u05d0\u05e8\u05e2" },
            { "nl_BE", "\u05e4\u05bf\u05dc\u05e2\u05de\u05d9\u05e9" },
            { "AF", "\u05d0\u05b7\u05e4\u05bf\u05d2\u05d4\u05d0\u05b7\u05e0\u05d9\u05e1\u05d8\u05d0\u05b7\u05df" },
            { "af", "\u05d0\u05b7\u05e4\u05bf\u05e8\u05d9\u05e7\u05d0\u05b7\u05e0\u05e1" },
            { "AG", "\u05d0\u05b7\u05e0\u05d8\u05d9\u05d2\u05d5\u05e2 \u05d0\u05d5\u05df \u05d1\u05d0\u05b7\u05e8\u05d1\u05d5\u05d3\u05e2" },
            { "AL", "\u05d0\u05b7\u05dc\u05d1\u05d0\u05b7\u05e0\u05d9\u05e2" },
            { "AM", "\u05d0\u05b7\u05e8\u05de\u05e2\u05e0\u05d9\u05e2" },
            { "am", "\u05d0\u05b7\u05de\u05d4\u05d0\u05b7\u05e8\u05d9\u05e9" },
            { "Arab", metaValue_ar },
            { "an", "\u05d0\u05b7\u05e8\u05d0\u05b7\u05d2\u05d0\u05e0\u05d9\u05e9" },
            { "AO", "\u05d0\u05b7\u05e0\u05d2\u05d0\u05dc\u05e2" },
            { "AQ", "\u05d0\u05b7\u05e0\u05d8\u05d0\u05b7\u05e8\u05e7\u05d8\u05d9\u05e7\u05e2" },
            { "ar", metaValue_ar },
            { "001", "\u05d5\u05d5\u05e2\u05dc\u05d8" },
            { "AR", "\u05d0\u05b7\u05e8\u05d2\u05e2\u05e0\u05d8\u05d9\u05e0\u05e2" },
            { "002", "\u05d0\u05b7\u05e4\u05bf\u05e8\u05d9\u05e7\u05e2" },
            { "as", "\u05d0\u05b7\u05e1\u05d0\u05b7\u05de\u05d9\u05e9" },
            { "003", "\u05e6\u05e4\u05d5\u05df\u05be\u05d0\u05b7\u05de\u05e2\u05e8\u05d9\u05e7\u05e2" },
            { "AT", "\u05e2\u05e1\u05d8\u05e8\u05d9\u05d9\u05da" },
            { "RE", "\u05e8\u05e2\u05d0\u05d5\u05e0\u05d9\u05d0\u05df" },
            { "AU", "\u05d0\u05d5\u05d9\u05e1\u05d8\u05e8\u05d0\u05b7\u05dc\u05d9\u05e2" },
            { "005", "\u05d3\u05e8\u05d5\u05dd\u05be\u05d0\u05b7\u05de\u05e2\u05e8\u05d9\u05e7\u05e2" },
            { "AW", "\u05d0\u05b7\u05e8\u05d5\u05d1\u05d0\u05b7" },
            { "jbo", "\u05dc\u05d0\u05d6\u05e9\u05d1\u05d0\u05b8\u05df" },
            { "009", "\u05d0\u05e7\u05e2\u05d0\u05b7\u05e0\u05d9\u05e2" },
            { "az", "\u05d0\u05b7\u05d6\u05e2\u05e8\u05d1\u05d9\u05d9\u05d3\u05d6\u05e9\u05d0\u05b7\u05e0\u05d9\u05e9" },
            { "RO", "\u05e8\u05d5\u05de\u05e2\u05e0\u05d9\u05e2" },
            { "ro", "\u05e8\u05d5\u05de\u05e2\u05e0\u05d9\u05e9" },
            { "BA", "\u05d1\u05d0\u05e1\u05e0\u05d9\u05e2 \u05d4\u05e2\u05e8\u05e6\u05e2\u05d2\u05d0\u05d5\u05d5\u05d9\u05e0\u05e2" },
            { "BB", "\u05d1\u05d0\u05b7\u05e8\u05d1\u05d0\u05b7\u05d3\u05d0\u05e1" },
            { "RS", "\u05e1\u05e2\u05e8\u05d1\u05d9\u05e2" },
            { "ceb", "\u05e1\u05e2\u05d1\u05d5\u05d0\u05b7\u05e0\u05d9\u05e9" },
            { "BD", "\u05d1\u05d0\u05b7\u05e0\u05d2\u05dc\u05d0\u05b7\u05d3\u05e2\u05e9" },
            { "BE", "\u05d1\u05e2\u05dc\u05d2\u05d9\u05e2" },
            { "RU", "\u05e8\u05d5\u05e1\u05dc\u05d0\u05b7\u05e0\u05d3" },
            { "be", "\u05d1\u05e2\u05dc\u05d0\u05b7\u05e8\u05d5\u05e1\u05d9\u05e9" },
            { "ru", "\u05e8\u05d5\u05e1\u05d9\u05e9" },
            { "gmh", "\u05de\u05d9\u05d8\u05dc \u05d4\u05d5\u05d9\u05db\u05d3\u05d5\u05d9\u05d8\u05e9" },
            { "BF", "\u05d1\u05d5\u05e8\u05e7\u05d9\u05e0\u05e2 \u05e4\u05bf\u05d0\u05b7\u05e1\u05d0" },
            { "BG", "\u05d1\u05d5\u05dc\u05d2\u05d0\u05b7\u05e8\u05d9\u05e2" },
            { "RW", "\u05e8\u05d5\u05d5\u05d0\u05b7\u05e0\u05d3\u05e2" },
            { "bg", "\u05d1\u05d5\u05dc\u05d2\u05d0\u05b7\u05e8\u05d9\u05e9" },
            { "BI", "\u05d1\u05d5\u05e8\u05d5\u05e0\u05d3\u05d9" },
            { "BJ", "\u05d1\u05e2\u05e0\u05d9\u05df" },
            { "BM", "\u05d1\u05e2\u05e8\u05de\u05d5\u05d3\u05e2" },
            { "BN", "\u05d1\u05e8\u05d5\u05e0\u05d9\u05d9" },
            { "bn", "\u05d1\u05e2\u05e0\u05d2\u05d0\u05b7\u05dc\u05d9\u05e9" },
            { "BO", "\u05d1\u05d0\u05dc\u05d9\u05d5\u05d5\u05d9\u05e2" },
            { "bo", "\u05d8\u05d9\u05d1\u05e2\u05d8\u05d9\u05e9" },
            { "sa", "\u05e1\u05d0\u05b7\u05e0\u05e1\u05e7\u05e8\u05d9\u05d8" },
            { "SB", "\u05e1\u05d0\u05dc\u05d0\u05de\u05d0\u05df \u05d0\u05d9\u05e0\u05d6\u05dc\u05e2\u05df" },
            { "BR", "\u05d1\u05e8\u05d0\u05b7\u05d6\u05d9\u05dc" },
            { "SC", "\u05e1\u05d9\u05d9\u05e9\u05e2\u05dc" },
            { "br", "\u05d1\u05e8\u05e2\u05d8\u05d0\u05e0\u05d9\u05e9" },
            { "sc", "\u05e1\u05d0\u05b7\u05e8\u05d3\u05d9\u05e9" },
            { "BS", "\u05d1\u05d0\u05b7\u05d4\u05d0\u05b7\u05de\u05d0\u05b7\u05e1" },
            { "SD", "\u05e1\u05d5\u05d3\u05d0\u05b7\u05df" },
            { "bs", "\u05d1\u05d0\u05e1\u05e0\u05d9\u05e9" },
            { "sd", "\u05e1\u05d9\u05e0\u05d3\u05d4\u05d9" },
            { "013", "\u05e6\u05e2\u05e0\u05d8\u05e8\u05d0\u05b7\u05dc\u05be\u05d0\u05b7\u05de\u05e2\u05e8\u05d9\u05e7\u05e2" },
            { "BT", "\u05d1\u05d4\u05d5\u05d8\u05d0\u05b7\u05df" },
            { "SE", "\u05e9\u05d5\u05d5\u05e2\u05d3\u05df" },
            { "se", "\u05e0\u05d0\u05e8\u05d3\u05e1\u05d0\u05b7\u05de\u05d9\u05e9" },
            { "arc", "\u05d0\u05b7\u05e8\u05d0\u05b7\u05de\u05d9\u05e9" },
            { "SG", "\u05e1\u05d9\u05e0\u05d2\u05d0\u05b7\u05e4\u05bc\u05d5\u05e8" },
            { "BW", "\u05d1\u05d0\u05e6\u05d5\u05d5\u05d0\u05b7\u05e0\u05e2" },
            { "SH", "\u05e1\u05d8 \u05d4\u05e2\u05dc\u05e2\u05e0\u05e2" },
            { "sh", "\u05e1\u05e2\u05e8\u05d1\u05d0\u05be\u05e7\u05e8\u05d0\u05d0\u05b7\u05d8\u05d9\u05e9" },
            { "SI", "\u05e1\u05dc\u05d0\u05d5\u05d5\u05e2\u05e0\u05d9\u05e2" },
            { "si", "\u05e1\u05d9\u05e0\u05d4\u05d0\u05b7\u05dc\u05d9\u05e9" },
            { "BY", "\u05d1\u05e2\u05dc\u05d0\u05b7\u05e8\u05d5\u05e1" },
            { "sux", "\u05e1\u05d5\u05de\u05e2\u05e8\u05d9\u05e9" },
            { "019", "\u05d0\u05b7\u05de\u05e2\u05e8\u05d9\u05e7\u05e2" },
            { "BZ", "\u05d1\u05e2\u05dc\u05d9\u05d6" },
            { "SK", "\u05e1\u05dc\u05d0\u05d5\u05d5\u05d0\u05b7\u05e7\u05d9\u05d9" },
            { "sk", "\u05e1\u05dc\u05d0\u05d5\u05d5\u05d0\u05b7\u05e7\u05d9\u05e9" },
            { "SL", "\u05e1\u05d9\u05e2\u05e8\u05e2 \u05dc\u05e2\u05d0\u05e0\u05e2" },
            { "sl", "\u05e1\u05dc\u05d0\u05d5\u05d5\u05e2\u05e0\u05d9\u05e9" },
            { "SM", "\u05e1\u05d0\u05b7\u05df \u05de\u05d0\u05b7\u05e8\u05d9\u05e0\u05d0" },
            { "sm", "\u05e1\u05d0\u05b7\u05de\u05d0\u05d0\u05b7\u05e0\u05d9\u05e9" },
            { "SN", "\u05e1\u05e2\u05e0\u05e2\u05d2\u05d0\u05b7\u05dc" },
            { "sn", "\u05e9\u05d0\u05e0\u05d0\u05b7" },
            { "SO", "\u05e1\u05d0\u05de\u05d0\u05b7\u05dc\u05d9\u05e2" },
            { "so", "\u05e1\u05d0\u05de\u05d0\u05b7\u05dc\u05d9\u05e9" },
            { "CA", "\u05e7\u05d0\u05b7\u05e0\u05d0\u05b7\u05d3\u05e2" },
            { "ca", "\u05e7\u05d0\u05b7\u05d8\u05d0\u05b7\u05dc\u05d0\u05e0\u05d9\u05e9" },
            { "sq", "\u05d0\u05b7\u05dc\u05d1\u05d0\u05b7\u05e0\u05d9\u05e9" },
            { "SR", "\u05e1\u05d5\u05e8\u05d9\u05e0\u05d0\u05b7\u05dd" },
            { "sr", "\u05e1\u05e2\u05e8\u05d1\u05d9\u05e9" },
            { "SS", "\u05d3\u05e8\u05d5\u05dd\u05be\u05e1\u05d5\u05d3\u05d0\u05b7\u05df" },
            { "CD", "\u05e7\u05d0\u05e0\u05d2\u05d0\u05be\u05e7\u05d9\u05e0\u05e9\u05d0\u05b7\u05d6\u05e2" },
            { "ST", "\u05e1\u05d0\u05b7\u05d0 \u05d8\u05d0\u05de\u05e2 \u05d0\u05d5\u05df \u05e4\u05bc\u05e8\u05d9\u05e0\u05e1\u05d9\u05e4\u05bc\u05e2" },
            { "CF", "\u05e6\u05e2\u05e0\u05d8\u05e8\u05d0\u05b7\u05dc\u05be\u05d0\u05b7\u05e4\u05bf\u05e8\u05d9\u05e7\u05d0\u05b7\u05e0\u05d9\u05e9\u05e2 \u05e8\u05e2\u05e4\u05bc\u05d5\u05d1\u05dc\u05d9\u05e7" },
            { "SV", "\u05e2\u05dc \u05e1\u05d0\u05b7\u05dc\u05d5\u05d5\u05d0\u05b7\u05d3\u05d0\u05e8" },
            { "sv", "\u05e9\u05d5\u05d5\u05e2\u05d3\u05d9\u05e9" },
            { "sw", "\u05e1\u05d5\u05d5\u05d0\u05b7\u05d4\u05d9\u05dc\u05d9\u05e9" },
            { "CH", "\u05e9\u05d5\u05d5\u05d9\u05d9\u05e5" },
            { "CI", "\u05d4\u05e2\u05dc\u05e4\u05bf\u05d0\u05b7 \u05e0\u05d3\u05d1\u05d9\u05d9\u05df \u05d1\u05d0\u05e8\u05d8\u05df" },
            { "SY", "\u05e1\u05d9\u05e8\u05d9\u05e2" },
            { "SZ", "\u05e1\u05d5\u05d5\u05d0\u05b7\u05d6\u05d9\u05dc\u05d0\u05b7\u05e0\u05d3" },
            { "CK", "\u05e7\u05d5\u05e7 \u05d0\u05d9\u05e0\u05d6\u05dc\u05e2\u05df" },
            { "CL", "\u05d8\u05e9\u05d9\u05dc\u05e2" },
            { "CM", "\u05e7\u05d0\u05b7\u05de\u05e2\u05e8\u05d5\u05df" },
            { "CN", "\u05db\u05d9\u05e0\u05e2" },
            { "CO", "\u05e7\u05d0\u05dc\u05d0\u05de\u05d1\u05d9\u05e2" },
            { "ta", "\u05d8\u05d0\u05b7\u05de\u05d9\u05dc" },
            { "021", "\u05e6\u05e4\u05d5\u05e0\u05d3\u05d9\u05e7\u05e2 \u05d0\u05b7\u05de\u05e2\u05e8\u05d9\u05e7\u05e2" },
            { "142", "\u05d0\u05b7\u05d6\u05d9\u05e2" },
            { "CR", "\u05e7\u05d0\u05e1\u05d8\u05d0\u05b7 \u05e8\u05d9\u05e7\u05d0\u05b7" },
            { "143", "\u05e6\u05e2\u05e0\u05d8\u05e8\u05d0\u05b7\u05dc\u05be\u05d0\u05b7\u05d6\u05d9\u05e2" },
            { "TD", "\u05d8\u05e9\u05d0\u05b7\u05d3" },
            { "cs", "\u05d8\u05e9\u05e2\u05db\u05d9\u05e9" },
            { "145", "\u05de\u05e2\u05e8\u05d1\u05be\u05d0\u05b7\u05d6\u05d9\u05e2" },
            { "CU", "\u05e7\u05d5\u05d1\u05d0\u05b7" },
            { "cu", "\u05e7\u05dc\u05d5\u05d9\u05e1\u05d8\u05e2\u05e8\u05be\u05e1\u05dc\u05d0\u05b7\u05d5\u05d5\u05d9\u05e9" },
            { "CV", "\u05e7\u05d0\u05b7\u05e4\u05bc\u05d5\u05d5\u05e2\u05e8\u05d3\u05d9\u05e9\u05e2 \u05d0\u05d9\u05e0\u05d6\u05dc\u05e2\u05df" },
            { "TG", "\u05d8\u05d0\u05d2\u05d0" },
            { "CW", "\u05e7\u05d5\u05e8\u05d0\u05b7\u05e1\u05d0\u05b7\u05d0" },
            { "TH", "\u05d8\u05d9\u05d9\u05dc\u05d0\u05b7\u05e0\u05d3" },
            { "cy", "\u05d5\u05d5\u05e2\u05dc\u05e9\u05d9\u05e9" },
            { "029", "\u05e7\u05d0\u05b7\u05e8\u05d0\u05b7\u05d0\u05d9\u05d1\u05e2" },
            { "CZ", "\u05d8\u05e9\u05e2\u05db\u05d9\u05d9" },
            { "tk", "\u05d8\u05d5\u05e8\u05e7\u05de\u05e2\u05e0\u05d9\u05e9" },
            { "tl", "\u05d8\u05d0\u05b7\u05d2\u05d0\u05b7\u05dc\u05d0\u05d2" },
            { "TM", "\u05d8\u05d5\u05e8\u05e7\u05de\u05e2\u05e0\u05d9\u05e1\u05d8\u05d0\u05b7\u05df" },
            { "TN", "\u05d8\u05d5\u05e0\u05d9\u05e1\u05d9\u05e2" },
            { "TO", "\u05d8\u05d0\u05e0\u05d2\u05d0\u05b7" },
            { "dyo", "\u05d6\u05e9\u05d0\u05dc\u05d0\u05be\u05e4\u05bf\u05d0\u05e0\u05d9" },
            { "vls", "\u05de\u05e2\u05e8\u05d1 \u05e4\u05bf\u05dc\u05e2\u05de\u05d9\u05e9" },
            { "da", "\u05d3\u05e2\u05e0\u05d9\u05e9" },
            { "TR", "\u05d8\u05e2\u05e8\u05e7\u05d9\u05d9" },
            { "swb", "\u05e7\u05d0\u05de\u05d0\u05e8\u05d9\u05e9" },
            { "TT", "\u05d8\u05e8\u05d9\u05e0\u05d9\u05d3\u05d0\u05b7\u05d3 \u05d0\u05d5\u05df \u05d8\u05d0\u05d1\u05d0\u05b7\u05d2\u05d0" },
            { "tt", "\u05d8\u05d0\u05b8\u05d8\u05e2\u05e8\u05d9\u05e9" },
            { "DE", "\u05d3\u05d9\u05d9\u05d8\u05e9\u05dc\u05d0\u05b7\u05e0\u05d3" },
            { "de", "\u05d3\u05f2\u05b7\u05d8\u05e9" },
            { "goh", "\u05d0\u05b7\u05dc\u05d8\u05be \u05d4\u05d5\u05d9\u05db\u05d3\u05d5\u05d9\u05d8\u05e9" },
            { "TV", "\u05d8\u05d5\u05d0\u05d5\u05d5\u05d0\u05b7\u05dc\u05d5" },
            { "rue", "\u05e8\u05d5\u05e1\u05d9\u05e0\u05d9\u05e9" },
            { "DJ", "\u05d3\u05d6\u05e9\u05d9\u05d1\u05d5\u05d8\u05d9" },
            { "TZ", "\u05d8\u05d0\u05b7\u05e0\u05d6\u05d0\u05b7\u05e0\u05d9\u05e2" },
            { "DK", "\u05d3\u05e2\u05e0\u05de\u05d0\u05b7\u05e8\u05e7" },
            { "DM", "\u05d3\u05d0\u05de\u05d9\u05e0\u05d9\u05e7\u05e2" },
            { "DO", "\u05d3\u05d0\u05de\u05d9\u05e0\u05d9\u05e7\u05d0\u05b7\u05e0\u05d9\u05e9\u05e2 \u05e8\u05e2\u05e4\u05bc\u05d5\u05d1\u05dc\u05d9\u05e7" },
            { "150", "\u05d0\u05d9\u05d9\u05e8\u05d0\u05e4\u05bc\u05e2" },
            { "UA", "\u05d0\u05d5\u05e7\u05e8\u05d0\u05b7\u05d9\u05e0\u05e2" },
            { "sga", "\u05d0\u05b7\u05dc\u05d8\u05be\u05d0\u05d9\u05e8\u05d9\u05e9" },
            { "030", "\u05de\u05d6\u05e8\u05d7 \u05d0\u05b7\u05d6\u05d9\u05e2" },
            { "151", "\u05de\u05d6\u05e8\u05d7\u05be\u05d0\u05d9\u05d9\u05e8\u05d0\u05e4\u05bc\u05e2" },
            { "got", "\u05d2\u05d0\u05d8\u05d9\u05e9" },
            { "154", "\u05e6\u05e4\u05bf\u05d5\u05df\u05be\u05d0\u05d9\u05d9\u05e8\u05d0\u05e4\u05bc\u05e2" },
            { "sw_CD", "\u05e7\u05d0\u05e0\u05d2\u05d0\u05be\u05e1\u05d5\u05d5\u05d0\u05b7\u05d4\u05d9\u05dc\u05d9\u05e9" },
            { "034", "\u05d3\u05e8\u05d5\u05dd\u05be\u05d0\u05b7\u05d6\u05d9\u05e2" },
            { "155", "\u05de\u05e2\u05e8\u05d1\u05be\u05d0\u05d9\u05d9\u05e8\u05d0\u05e4\u05bc\u05e2" },
            { "035", "\u05d3\u05e8\u05d5\u05dd\u05be\u05de\u05d6\u05e8\u05d7 \u05d0\u05b7\u05d6\u05d9\u05e2" },
            { "UG", "\u05d0\u05d5\u05d2\u05d0\u05b7\u05e0\u05d3\u05e2" },
            { "tig", "\u05d8\u05d9\u05d2\u05e8\u05e2" },
            { "039", "\u05d3\u05e8\u05d5\u05dd\u05be\u05d0\u05d9\u05d9\u05e8\u05d0\u05e4\u05bc\u05e2" },
            { "uk", "\u05d0\u05d5\u05e7\u05e8\u05d0\u05b7\u05d0\u05d9\u05e0\u05d9\u05e9" },
            { "liv", "\u05dc\u05d9\u05d5\u05d5\u05d9\u05e9" },
            { "ur", "\u05d0\u05d5\u05e8\u05d3\u05d5" },
            { "EC", "\u05e2\u05e7\u05d5\u05d5\u05d0\u05b7\u05d3\u05d0\u05e8" },
            { "US", "\u05e4\u05bf\u05d0\u05b7\u05e8\u05d0\u05d9\u05d9\u05e0\u05d9\u05d2\u05d8\u05e2 \u05e9\u05d8\u05d0\u05b7\u05d8\u05df" },
            { "EE", "\u05e2\u05e1\u05d8\u05dc\u05d0\u05b7\u05e0\u05d3" },
            { "EG", "\u05e2\u05d2\u05d9\u05e4\u05bc\u05d8\u05df" },
            { "UY", "\u05d0\u05d5\u05e8\u05d5\u05d2\u05d5\u05d5\u05d9\u05d9" },
            { "prg", "\u05e4\u05bc\u05e8\u05d9\u05d9\u05e1\u05d9\u05e9" },
            { "uz", "\u05d0\u05d5\u05d6\u05d1\u05e2\u05e7\u05d9\u05e9" },
            { "el", metaValue_el },
            { "en", "\u05e2\u05e0\u05d2\u05dc\u05d9\u05e9" },
            { "eo", "\u05e2\u05e1\u05e4\u05bc\u05e2\u05e8\u05d0\u05b7\u05e0\u05d8\u05d0" },
            { "VA", "\u05d5\u05d5\u05d0\u05b7\u05d8\u05d9\u05e7\u05d0\u05b7\u05df \u05e9\u05d8\u05d0\u05b8\u05d8" },
            { "ER", "\u05e2\u05e8\u05d9\u05d8\u05e8\u05e2\u05e2" },
            { "ES", "\u05e9\u05e4\u05bc\u05d0\u05b7\u05e0\u05d9\u05e2" },
            { "es", "\u05e9\u05e4\u05bc\u05d0\u05b7\u05e0\u05d9\u05e9" },
            { "ET", "\u05e2\u05d8\u05d9\u05d0\u05e4\u05bc\u05d9\u05e2" },
            { "VE", "\u05d5\u05d5\u05e2\u05e0\u05e2\u05d6\u05d5\u05e2\u05dc\u05e2" },
            { "et", "\u05e2\u05e1\u05d8\u05d9\u05e9" },
            { "EU", "\u05d0\u05d9\u05d9\u05e8\u05d0\u05e4\u05bc\u05e2\u05d9\u05e9\u05e2\u05e8 \u05e4\u05bf\u05d0\u05b7\u05e8\u05d1\u05d0\u05b7\u05e0\u05d3" },
            { "eu", "\u05d1\u05d0\u05b7\u05e1\u05e7\u05d9\u05e9" },
            { "type.ca.gregorian", "\u05d2\u05e8\u05e2\u05d2\u05d0\u05e8\u05d9\u05e9\u05e2\u05e8 \u05e7\u05d0\u05b7\u05dc\u05e2\u05e0\u05d3\u05d0\u05b7\u05e8" },
            { "vi", "\u05d5\u05d5\u05d9\u05e2\u05d8\u05e0\u05d0\u05b7\u05de\u05e2\u05d6\u05d9\u05e9" },
            { "hsb", "\u05d0\u05d9\u05d9\u05d1\u05e2\u05e8\u05be\u05e1\u05d0\u05e8\u05d1\u05d9\u05e9" },
            { "VN", "\u05d5\u05d5\u05d9\u05e2\u05d8\u05e0\u05d0\u05b7\u05dd" },
            { "vo", "\u05d5\u05d5\u05d0\u05dc\u05d0\u05b7\u05e4\u05bc\u05d5\u05e7" },
            { "fa", "\u05e4\u05bc\u05e2\u05e8\u05e1\u05d9\u05e9" },
            { "VU", "\u05d5\u05d5\u05d0\u05b7\u05e0\u05d5\u05d0\u05b7\u05d8\u05d5" },
            { "FI", "\u05e4\u05bf\u05d9\u05e0\u05dc\u05d0\u05b7\u05e0\u05d3" },
            { "fi", "\u05e4\u05bf\u05d9\u05e0\u05d9\u05e9" },
            { "fj", metaValue_FJ },
            { "FJ", metaValue_FJ },
            { "FK", "\u05e4\u05bf\u05d0\u05b7\u05dc\u05e7\u05dc\u05d0\u05b7\u05e0\u05d3 \u05d0\u05d9\u05e0\u05d6\u05dc\u05e2\u05df" },
            { "FM", "\u05de\u05d9\u05e7\u05e8\u05d0\u05e0\u05e2\u05d6\u05d9\u05e2" },
            { "FO", "\u05e4\u05bf\u05d0\u05b7\u05e8\u05d0 \u05d0\u05d9\u05e0\u05d6\u05dc\u05e2\u05df" },
            { "fo", "\u05e4\u05bf\u05d0\u05b7\u05e8\u05d0\u05d9\u05e9" },
            { "FR", "\u05e4\u05bf\u05e8\u05d0\u05b7\u05e0\u05e7\u05e8\u05d9\u05d9\u05da" },
            { "fr", "\u05e4\u05bf\u05e8\u05d0\u05b7\u05e0\u05e6\u05d5\u05d9\u05d6\u05d9\u05e9" },
            { "Grek", metaValue_el },
            { "fy", "\u05de\u05e2\u05e8\u05d1\u05be\u05e4\u05bf\u05e8\u05d9\u05d6\u05d9\u05e9" },
            { "grc", "\u05d0\u05d5\u05e8\u05d0\u05b7\u05dc\u05d8\u05be\u05d2\u05e8\u05d9\u05db\u05d9\u05e9" },
            { "GA", "\u05d2\u05d0\u05b7\u05d1\u05d0\u05df" },
            { "ga", "\u05d0\u05d9\u05e8\u05d9\u05e9" },
            { "GB", "\u05e4\u05bf\u05d0\u05b7\u05e8\u05d0\u05d9\u05d9\u05e0\u05d9\u05d2\u05d8\u05e2 \u05e7\u05e2\u05e0\u05d9\u05d2\u05e8\u05d9\u05d9\u05da" },
            { "WS", "\u05e1\u05d0\u05b7\u05de\u05d0\u05d0\u05b7" },
            { "GD", "\u05d2\u05e8\u05e2\u05e0\u05d0\u05b7\u05d3\u05d0\u05b7" },
            { "gd", "\u05e1\u05e7\u05d0\u05d8\u05d9\u05e9 \u05d2\u05e2\u05dc\u05d9\u05e9" },
            { "GE", "\u05d2\u05e8\u05d5\u05d6\u05d9\u05e2" },
            { "GF", "\u05e4\u05bf\u05e8\u05d0\u05b7\u05e0\u05e6\u05d5\u05d9\u05d6\u05d9\u05e9\u05e2 \u05d2\u05d5\u05d9\u05d0\u05b7\u05e0\u05e2" },
            { "GG", "\u05d2\u05e2\u05e8\u05e0\u05d6\u05d9" },
            { "GH", "\u05d2\u05d4\u05d0\u05b7\u05e0\u05e2" },
            { "GI", "\u05d2\u05d9\u05d1\u05e8\u05d0\u05b7\u05dc\u05d8\u05d0\u05b7\u05e8" },
            { "szl", "\u05e9\u05dc\u05e2\u05d6\u05d9\u05e9" },
            { "GL", "\u05d2\u05e8\u05d9\u05e0\u05dc\u05d0\u05b7\u05e0\u05d3" },
            { "gl", "\u05d2\u05d0\u05b7\u05dc\u05d9\u05e9\u05d9\u05e9" },
            { "enm", "\u05de\u05d9\u05d8\u05dc \u05e2\u05e0\u05d2\u05dc\u05d9\u05e9" },
            { "GM", "\u05d2\u05d0\u05b7\u05de\u05d1\u05d9\u05e2" },
            { "GN", "\u05d2\u05d9\u05e0\u05e2" },
            { "GP", "\u05d2\u05d5\u05d5\u05d0\u05b7\u05d3\u05e2\u05dc\u05d5\u05e4" },
            { "GQ", "\u05e2\u05e7\u05d5\u05d5\u05d0\u05b7\u05d8\u05d0\u05e8\u05d9\u05e9\u05e2 \u05d2\u05d9\u05e0\u05e2" },
            { "und", "\u05d0\u05d5\u05de\u05d1\u05d0\u05b7\u05d5\u05d5\u05d0\u05d5\u05e1\u05d8\u05e2 \u05e9\u05e4\u05bc\u05e8\u05d0\u05b7\u05da" },
            { "061", "\u05e4\u05bc\u05d0\u05dc\u05d9\u05e0\u05e2\u05d6\u05d9\u05e2" },
            { "GR", "\u05d2\u05e8\u05d9\u05db\u05e0\u05dc\u05d0\u05b7\u05e0\u05d3" },
            { "Latn", "\u05d2\u05b7\u05dc\u05d7\u05d9\u05e9" },
            { "GT", "\u05d2\u05d5\u05d5\u05d0\u05b7\u05d8\u05e2\u05de\u05d0\u05b7\u05dc\u05e2" },
            { "GU", "\u05d2\u05d5\u05d5\u05d0\u05b7\u05dd" },
            { "gv", "\u05de\u05d0\u05b7\u05e0\u05e7\u05e1" },
            { "GW", "\u05d2\u05d9\u05e0\u05e2\u05be\u05d1\u05d9\u05e1\u05d0\u05b7\u05d5" },
            { "GY", "\u05d2\u05d5\u05d9\u05d0\u05b7\u05e0\u05e2" },
            { "XK", "\u05e7\u05d0\u05e1\u05d0\u05d5\u05d5\u05d0" },
            { "ha", "\u05d4\u05d0\u05b7\u05d5\u05e1\u05d0\u05b7" },
            { "he", "\u05d4\u05e2\u05d1\u05e8\u05e2\u05d0\u05d9\u05e9" },
            { "hi", "\u05d4\u05d9\u05e0\u05d3\u05d9" },
            { "HN", "\u05d4\u05d0\u05e0\u05d3\u05d5\u05e8\u05d0\u05b7\u05e1" },
            { "HR", "\u05e7\u05e8\u05d0\u05d0\u05b7\u05d8\u05d9\u05e2" },
            { "hr", "\u05e7\u05e8\u05d0\u05d0\u05b7\u05d8\u05d9\u05e9" },
            { "HT", "\u05d4\u05d0\u05b7\u05d9\u05d8\u05d9" },
            { "YE", "\u05ea\u05d9\u05de\u05df" },
            { "HU", "\u05d0\u05d5\u05e0\u05d2\u05e2\u05e8\u05df" },
            { "hu", "\u05d0\u05d5\u05e0\u05d2\u05e2\u05e8\u05d9\u05e9" },
            { "yi", "\u05d9\u05d9\u05b4\u05d3\u05d9\u05e9" },
            { "hy", "\u05d0\u05b7\u05e8\u05de\u05e2\u05e0\u05d9\u05e9" },
            { "IC", "\u05e7\u05d0\u05b7\u05e0\u05d0\u05b7\u05e8\u05d9\u05e9\u05e2 \u05d0\u05d9\u05e0\u05d6\u05dc\u05e2\u05df" },
            { "ID", "\u05d0\u05d9\u05e0\u05d3\u05d0\u05e0\u05e2\u05d6\u05d9\u05e2" },
            { "YT", "\u05de\u05d0\u05b7\u05d9\u05d0\u05d8" },
            { "id", "\u05d0\u05d9\u05e0\u05d3\u05d0\u05e0\u05e2\u05d6\u05d9\u05e9" },
            { "peo", "\u05d0\u05b7\u05dc\u05d8 \u05e4\u05bc\u05e2\u05e8\u05e1\u05d9\u05e9" },
            { "IE", "\u05d0\u05d9\u05e8\u05dc\u05d0\u05b7\u05e0\u05d3" },
            { "nap", "\u05e0\u05d0\u05b7\u05e4\u05bc\u05d0\u05dc\u05d9\u05d8\u05b7\u05e0\u05d9\u05e9" },
            { "fro", "\u05d0\u05b7\u05dc\u05d8\u05be\u05e4\u05bf\u05e8\u05d0\u05b7\u05e0\u05e6\u05d5\u05d9\u05d6\u05d9\u05e9" },
            { "IL", "\u05d9\u05e9\u05e8\u05d0\u05dc" },
            { "IN", "\u05d0\u05d9\u05e0\u05d3\u05d9\u05e2" },
            { "io", "\u05d0\u05d9\u05d3\u05d0" },
            { "frs", "\u05de\u05d6\u05e8\u05d7\u05be\u05e4\u05bf\u05e8\u05d9\u05d6\u05d9\u05e9" },
            { "ZA", "\u05d3\u05e8\u05d5\u05dd\u05be\u05d0\u05b7\u05e4\u05bf\u05e8\u05d9\u05e7\u05e2" },
            { "frr", "\u05d3\u05e8\u05d5\u05dd\u05be\u05e4\u05bf\u05e8\u05d9\u05d6\u05d9\u05e9" },
            { "IR", "\u05d0\u05d9\u05e8\u05d0\u05b7\u05df" },
            { "IS", "\u05d0\u05d9\u05e1\u05dc\u05d0\u05b7\u05e0\u05d3" },
            { "is", "\u05d0\u05d9\u05e1\u05dc\u05d0\u05b7\u05e0\u05d3\u05d9\u05e9" },
            { "IT", "\u05d0\u05d9\u05d8\u05d0\u05b7\u05dc\u05d9\u05e2" },
            { "it", "\u05d0\u05d9\u05d8\u05d0\u05b7\u05dc\u05d9\u05e2\u05e0\u05d9\u05e9" },
            { "Deva", "\u05d3\u05e2\u05d5\u05d5\u05d0\u05b7\u05e0\u05d0\u05b7\u05d2\u05d0\u05b7\u05e8\u05d9" },
            { "zh", "\u05db\u05d9\u05e0\u05e2\u05d6\u05d9\u05e9" },
            { "sli", "\u05d0\u05d5\u05e0\u05d8\u05e2\u05e8 \u05e9\u05dc\u05e2\u05d6\u05d9\u05e9" },
            { "ZM", "\u05d6\u05d0\u05b7\u05de\u05d1\u05d9\u05e2" },
            { "ja", "\u05d9\u05d0\u05b7\u05e4\u05bc\u05d0\u05b7\u05e0\u05d9\u05e9" },
            { "JE", "\u05d3\u05d6\u05e9\u05e2\u05e8\u05d6\u05d9" },
            { "zu", "\u05d6\u05d5\u05dc\u05d5" },
            { "ZW", "\u05d6\u05d9\u05de\u05d1\u05d0\u05b7\u05d1\u05d5\u05d5\u05e2" },
            { "ZZ", "\u05d0\u05d5\u05de\u05d1\u05d0\u05b7\u05d5\u05d5\u05d0\u05d5\u05e1\u05d8\u05e2\u05e8 \u05e8\u05d0\u05b7\u05d9\u05d0\u05df" },
            { "JM", "\u05d3\u05d6\u05e9\u05d0\u05b7\u05de\u05d9\u05d9\u05e7\u05e2" },
            { "JP", "\u05d9\u05d0\u05b7\u05e4\u05bc\u05d0\u05b7\u05df" },
            { "jv", "\u05d9\u05d0\u05b7\u05d5\u05d5\u05d0\u05b7\u05e0\u05e2\u05d6\u05d9\u05e9" },
            { "ka", "\u05d2\u05e8\u05d5\u05d6\u05d9\u05e0\u05d9\u05e9" },
            { "KE", "\u05e7\u05e2\u05e0\u05d9\u05e2" },
            { "419", "\u05dc\u05d0\u05b7\u05d8\u05d9\u05d9\u05df\u05be\u05d0\u05b7\u05de\u05e2\u05e8\u05d9\u05e7\u05e2" },
            { "KH", "\u05e7\u05d0\u05b7\u05de\u05d1\u05d0\u05d3\u05d9\u05e2" },
            { "KI", "\u05e7\u05d9\u05e8\u05d9\u05d1\u05d0\u05b7\u05d8\u05d9" },
            { "kk", "\u05e7\u05d0\u05b7\u05d6\u05d0\u05b7\u05db\u05d9\u05e9" },
            { "KM", "\u05e7\u05d0\u05de\u05d0\u05e8\u05d0\u05e1" },
            { "km", "\u05db\u05de\u05e2\u05e8" },
            { "kn", "\u05e7\u05d0\u05b7\u05e0\u05d0\u05b7\u05d3\u05d0\u05b7" },
            { "ko", "\u05e7\u05d0\u05e8\u05e2\u05d0\u05d9\u05e9" },
            { "ku", "\u05e7\u05d5\u05e8\u05d3\u05d9\u05e9" },
            { "kw", "\u05e7\u05d0\u05e8\u05e0\u05d9\u05e9" },
            { "KY", "\u05e7\u05d9\u05d9\u05de\u05d0\u05b7\u05df \u05d0\u05d9\u05e0\u05d6\u05dc\u05e2\u05df" },
            { "ky", "\u05e7\u05d9\u05e8\u05d2\u05d9\u05d6\u05d9\u05e9" },
            { "Cyrl", "\u05e6\u05d9\u05e8\u05d9\u05dc\u05d9\u05e9" },
            { "LA", "\u05dc\u05d0\u05b7\u05d0\u05e1" },
            { "la", "\u05dc\u05d0\u05d8\u05d9\u05d9\u05e0\u05d9\u05e9" },
            { "LB", "\u05dc\u05d1\u05e0\u05d5\u05df" },
            { "lb", "\u05dc\u05d5\u05e7\u05e1\u05e2\u05de\u05d1\u05d5\u05e8\u05d2\u05d9\u05e9" },
            { "nds", "\u05e0\u05d9\u05d3\u05e2\u05e8\u05d3\u05f2\u05b7\u05d8\u05e9" },
            { "LI", "\u05dc\u05d9\u05db\u05d8\u05e0\u05e9\u05d8\u05d9\u05d9\u05df" },
            { "LK", "\u05e1\u05e8\u05d9\u05be\u05dc\u05d0\u05b7\u05e0\u05e7\u05d0\u05b7" },
            { "akk", "\u05d0\u05b7\u05e7\u05d0\u05b7\u05d3\u05d9\u05e9" },
            { "lo", "\u05dc\u05d0\u05b7\u05d0" },
            { "hif", "\u05e4\u05d9\u05d3\u05d6\u05e9\u05d9 \u05d4\u05d9\u05e0\u05d3\u05d9" },
            { "LR", "\u05dc\u05d9\u05d1\u05e2\u05e8\u05d9\u05e2" },
            { "LS", "\u05dc\u05e2\u05e1\u05d0\u05d8\u05d0" },
            { "LT", "\u05dc\u05d9\u05d8\u05e2" },
            { "lt", "\u05dc\u05d9\u05d8\u05d5\u05d5\u05d9\u05e9" },
            { "LU", "\u05dc\u05d5\u05e7\u05e1\u05e2\u05de\u05d1\u05d5\u05e8\u05d2" },
            { "LV", "\u05dc\u05e2\u05d8\u05dc\u05d0\u05b7\u05e0\u05d3" },
            { "lv", "\u05dc\u05e2\u05d8\u05d9\u05e9" },
            { "LY", "\u05dc\u05d9\u05d1\u05d9\u05e2" },
            { "lad", "\u05dc\u05d0\u05b7\u05d3\u05d9\u05e0\u05d0" },
            { "MA", "\u05de\u05d0\u05b7\u05e8\u05d0\u05e7\u05d0" },
            { "MC", "\u05de\u05d0\u05e0\u05d0\u05b7\u05e7\u05d0" },
            { "MD", "\u05de\u05d0\u05dc\u05d3\u05d0\u05d5\u05d5\u05e2" },
            { "ME", "\u05de\u05d0\u05e0\u05d8\u05e2\u05e0\u05e2\u05d2\u05e8\u05d0" },
            { "MG", "\u05de\u05d0\u05b7\u05d3\u05d0\u05b7\u05d2\u05d0\u05b7\u05e1\u05e7\u05d0\u05b7\u05e8" },
            { "MH", "\u05de\u05d0\u05b7\u05e8\u05e9\u05d0\u05b7\u05dc \u05d0\u05d9\u05e0\u05d6\u05dc\u05e2\u05df" },
            { "mi", "\u05de\u05d0\u05b7\u05d0\u05e8\u05d9\u05e9" },
            { "mk", "\u05de\u05d0\u05b7\u05e7\u05e2\u05d3\u05d0\u05e0\u05d9\u05e9" },
            { "ML", "\u05de\u05d0\u05b7\u05dc\u05d9" },
            { "ml", "\u05de\u05d0\u05b7\u05dc\u05d0\u05b7\u05d9\u05d0\u05b7\u05dc\u05d0\u05b7\u05dd" },
            { "MM", "\u05de\u05d9\u05d0\u05b7\u05e0\u05de\u05d0\u05b7\u05e8" },
            { "MN", "\u05de\u05d0\u05e0\u05d2\u05d0\u05dc\u05d9\u05d9" },
            { "mn", "\u05de\u05d0\u05e0\u05d2\u05d0\u05dc\u05d9\u05e9" },
            { "MQ", "\u05de\u05d0\u05b7\u05e8\u05d8\u05d9\u05e0\u05d9\u05e7" },
            { "MR", "\u05de\u05d0\u05b7\u05e8\u05d9\u05d8\u05d0\u05b7\u05e0\u05d9\u05e2" },
            { "MS", "\u05de\u05d0\u05e0\u05d8\u05e1\u05e2\u05e8\u05d0\u05b7\u05d8" },
            { "MT", "\u05de\u05d0\u05b7\u05dc\u05d8\u05d0\u05b7" },
            { "mt", "\u05de\u05d0\u05b7\u05dc\u05d8\u05e2\u05d6\u05d9\u05e9" },
            { "MU", "\u05de\u05d0\u05e8\u05d9\u05e6\u05d9\u05d5\u05e1" },
            { "MV", "\u05de\u05d0\u05b7\u05dc\u05d3\u05d9\u05d5\u05d5\u05df" },
            { "MW", "\u05de\u05d0\u05b7\u05dc\u05d0\u05b7\u05d5\u05d5\u05d9" },
            { "MX", "\u05de\u05e2\u05e7\u05e1\u05d9\u05e7\u05e2" },
            { "MY", "\u05de\u05d0\u05b7\u05dc\u05d9\u05d9\u05d6\u05d9\u05e2" },
            { "my", "\u05d1\u05d9\u05e8\u05de\u05d0\u05b7\u05e0\u05d9\u05e9" },
            { "MZ", "\u05de\u05d0\u05d6\u05d0\u05b7\u05de\u05d1\u05d9\u05e7" },
            { "dsb", "\u05d0\u05d5\u05e0\u05d8\u05e2\u05e8\u05be\u05e1\u05d0\u05e8\u05d1\u05d9\u05e9" },
            { "NA", "\u05e0\u05d0\u05b7\u05de\u05d9\u05d1\u05d9\u05e2" },
            { "NC", "\u05e0\u05f2\u05b7 \u05e7\u05d0\u05b7\u05dc\u05e2\u05d3\u05d0\u05e0\u05d9\u05e2" },
            { "NE", "\u05e0\u05d9\u05d6\u05e9\u05e2\u05e8" },
            { "ne", "\u05e0\u05e2\u05e4\u05bc\u05d0\u05b7\u05dc\u05d9\u05e9" },
            { "NF", "\u05e0\u05d0\u05e8\u05e4\u05bf\u05d0\u05dc\u05e7 \u05d0\u05d9\u05e0\u05d6\u05dc" },
            { "NG", "\u05e0\u05d9\u05d2\u05e2\u05e8\u05d9\u05e2" },
            { "NI", "\u05e0\u05d9\u05e7\u05d0\u05b7\u05e8\u05d0\u05b7\u05d2\u05d5\u05e2" },
            { "NL", "\u05d4\u05d0\u05dc\u05d0\u05b7\u05e0\u05d3" },
            { "nl", "\u05d4\u05d0\u05dc\u05e2\u05e0\u05d3\u05d9\u05e9" },
            { "nn", "\u05e0\u05f2\u05b7\u05be\u05e0\u05d0\u05e8\u05d5\u05d5\u05e2\u05d2\u05d9\u05e9" },
            { "NO", "\u05e0\u05d0\u05e8\u05d5\u05d5\u05e2\u05d2\u05d9\u05e2" },
            { "no", "\u05e0\u05d0\u05e8\u05d5\u05d5\u05e2\u05d2\u05d9\u05e9" },
            { "NP", "\u05e0\u05e2\u05e4\u05bc\u05d0\u05b7\u05dc" },
            { "NZ", "\u05e0\u05d9\u05d5 \u05d6\u05d9\u05dc\u05d0\u05b7\u05e0\u05d3" },
            { "oc", "\u05d0\u05e7\u05e1\u05d9\u05d8\u05d0\u05b7\u05e0\u05d9\u05e9" },
            { "crh", "\u05e7\u05e8\u05d9\u05dd\u05be\u05d8\u05e2\u05e8\u05e7\u05d9\u05e9" },
            { "ang", "\u05d0\u05b7\u05dc\u05d8 \u05e2\u05e0\u05d2\u05dc\u05d9\u05e9" },
            { "os", "\u05d0\u05e1\u05e2\u05d8\u05d9\u05e9" },
            { "key.nu", "\u05e0\u05d5\u05de\u05e2\u05e8\u05df" },
            { "jpr", "\u05d9\u05d9\u05d3\u05d9\u05e9\u05be\u05e4\u05e2\u05e8\u05e1\u05d9\u05e9" },
            { "PA", "\u05e4\u05bc\u05d0\u05b7\u05e0\u05d0\u05b7\u05de\u05d0\u05b7" },
            { "csb", "\u05e7\u05d0\u05b7\u05e9\u05d5\u05d1\u05d9\u05e9" },
            { "PE", "\u05e4\u05bc\u05e2\u05e8\u05d5" },
            { "PF", "\u05e4\u05bf\u05e8\u05d0\u05b7\u05e0\u05e6\u05d5\u05d9\u05d6\u05d9\u05e9\u05e2 \u05e4\u05bc\u05d0\u05dc\u05d9\u05e0\u05e2\u05d6\u05d9\u05e2" },
            { "PG", "\u05e4\u05bc\u05d0\u05b7\u05e4\u05bc\u05d5\u05d0\u05b7 \u05e0\u05f2\u05b7 \u05d2\u05d9\u05e0\u05e2" },
            { "PH", "\u05e4\u05bf\u05d9\u05dc\u05d9\u05e4\u05bc\u05d9\u05e0\u05e2\u05df" },
            { "PK", "\u05e4\u05bc\u05d0\u05b7\u05e7\u05d9\u05e1\u05d8\u05d0\u05b7\u05df" },
            { "PL", "\u05e4\u05bc\u05d5\u05d9\u05dc\u05df" },
            { "pl", "\u05e4\u05bc\u05d5\u05d9\u05dc\u05d9\u05e9" },
            { "PN", "\u05e4\u05bc\u05d9\u05d8\u05e7\u05e2\u05e8\u05df \u05d0\u05d9\u05e0\u05d6\u05dc\u05e2\u05df" },
        };
        return data;
    }
}
