<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/health/notifications/signl4/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/health/notifications/signl4/metadata.yaml"
sidebar_label: "SIGNL4"
learn_status: "Published"
learn_rel_path: "Alerts & Notifications/Notifications/Agent Dispatched Notifications"
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE NOTIFICATION'S metadata.yaml FILE"
endmeta-->

# SIGNL4


<img src="https://netdata.cloud/img/signl4.svg" width="150"/>


SIGNL4 offers critical alerting, incident response and service dispatching for operating critical infrastructure. It alerts you persistently via app push, SMS text, voice calls, and email including tracking, escalation, on-call duty scheduling and collaboration.
You can send notifications to SIGNL4 using Netdata's Agent alert notification feature, which supports dozens of endpoints, user roles, and more.


<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Setup


### Prerequisites

#### 

- An inbound webhook in SIGNL4
- Access to the terminal where Netdata Agent is running



### Configuration

#### Options

The following options can be defined for this notification

<details open><summary>Config Options</summary>



| Option | Description | Default | Required |
|:-----|:------------|:--------|:---------:|
| SEND_SIGNL4 | Set `SEND_SIGNL4` to YES | YES | yes |
| SIGNL4_WEBHOOK_URL | set `SIGNL4_WEBHOOK_URL` to your SIGNL4 webhook URL. |  | yes |


</details>



#### via File

The configuration file name for this integration is `health_alarm_notify.conf`.


You can edit the configuration file using the [`edit-config`](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#edit-a-configuration-file-using-edit-config) script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config health_alarm_notify.conf
```

##### Examples

###### Basic Configuration



```yaml
SEND_SIGNL4="YES"
SIGNL4_WEBHOOK_URL="https://connect.signl4.com/webhook/xxxxxxxx"

```


## Troubleshooting

### Test Notification

You can run the following command by hand, to test alerts configuration:

```bash
# become user netdata
sudo su -s /bin/bash netdata

# enable debugging info on the console
export NETDATA_ALARM_NOTIFY_DEBUG=1

# send test alarms to sysadmin
/usr/libexec/netdata/plugins.d/alarm-notify.sh test

# send test alarms to any role
/usr/libexec/netdata/plugins.d/alarm-notify.sh test "ROLE"
```

Note that this will test _all_ alert mechanisms for the selected role.


