<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/go/plugin/go.d/collector/zookeeper/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/go/plugin/go.d/collector/zookeeper/metadata.yaml"
sidebar_label: "ZooKeeper"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/Service Discovery / Registry"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# ZooKeeper


<img src="https://netdata.cloud/img/zookeeper.svg" width="150"/>


Plugin: go.d.plugin
Module: zookeeper

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview



It connects to the Zookeeper instance via a TCP and executes the following commands:

- [mntr](https://zookeeper.apache.org/doc/r3.4.8/zookeeperAdmin.html#sc_zkCommands).


This collector is supported on all platforms.

This collector supports collecting metrics from multiple instances of this integration, including remote instances.


### Default Behavior

#### Auto-Detection

By default, it detects instances running on localhost by attempting to connect using known ZooKeeper TCP sockets:

- 127.0.0.1:2181
- 127.0.0.1:2182


#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.

## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per ZooKeeper server

These metrics refer to ZooKeeper servers.

This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| zookeeper.requests | outstanding | requests |
| zookeeper.requests_latency | min, avg, max | ms |
| zookeeper.stale_requests | stale | requests/s |
| zookeeper.stale_requests_dropped | dropped | requests/s |
| zookeeper.connections | alive | connections |
| zookeeper.connections_dropped | dropped | connections/s |
| zookeeper.connections_rejected | rejected | connections/s |
| zookeeper.auth_fails | auth | fails/s |
| zookeeper.global_sessions | global | sessions |
| zookeeper.server_state | leader, follower, observer, standalone | state |
| zookeeper.throttled_ops | throttled | ops/s |
| zookeeper.packets | received, sent | pps |
| zookeeper.file_descriptor | open | file descriptors |
| zookeeper.nodes | znode, ephemerals | nodes |
| zookeeper.watches | watches | watches |
| zookeeper.approximate_data_size | size | KiB |
| zookeeper.uptime | uptime | seconds |



## Alerts

There are no alerts configured by default for this integration.


## Setup


You can configure the **zookeeper** collector in two ways:

| Method                | Best for                                                                                 | How to                                                                                                                                 |
|-----------------------|------------------------------------------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------------------------|
| [**UI**](#via-ui)     | Fast setup without editing files                                                         | Go to **Nodes → Configure this node → Collectors → Jobs**, search for **zookeeper**, then click **+** to add a job. |
| [**File**](#via-file) | If you prefer configuring via file, or need to automate deployments (e.g., with Ansible) | Edit `go.d/zookeeper.conf` and add a job.                                                                        |

:::important

UI configuration requires paid Netdata Cloud plan.

:::


### Prerequisites

#### Whitelist `mntr` command

Add `mntr` to Zookeeper's [4lw.commands.whitelist](https://zookeeper.apache.org/doc/current/zookeeperAdmin.html#sc_4lw).



### Configuration

#### Options

The following options can be defined globally: update_every, autodetection_retry.


<details open><summary>Config options</summary>



| Group | Option | Description | Default | Required |
|:------|:-----|:------------|:--------|:---------:|
| **Collection** | update_every | Data collection interval (seconds). | 1 | no |
|  | autodetection_retry | Autodetection retry interval (seconds). Set 0 to disable. | 0 | no |
| **Target** | address | Zookeeper server address (`IP:PORT`). | 127.0.0.1:2181 | yes |
|  | timeout | Connection, read, write, and TLS handshake timeout (seconds). | 1 | no |
| **TLS** | use_tls | Enable TLS for the connection. | no | no |
|  | tls_skip_verify | Skip TLS certificate and hostname verification (insecure). | no | no |
|  | tls_ca | Path to CA bundle used to validate the server certificate. |  | no |
|  | tls_cert | Path to client TLS certificate (for mTLS). |  | no |
|  | tls_key | Path to client TLS private key (for mTLS). |  | no |
| **Virtual Node** | vnode | Associates this data collection job with a [Virtual Node](https://learn.netdata.cloud/docs/netdata-agent/configuration/organize-systems-metrics-and-alerts#virtual-nodes). |  | no |


</details>


#### via UI

Configure the **zookeeper** collector from the Netdata web interface:

1. Go to **Nodes**.
2. Select the node **where you want the zookeeper data-collection job to run** and click the :gear: (**Configure this node**). That node will run the data collection.
3. The **Collectors → Jobs** view opens by default.
4. In the Search box, type _zookeeper_ (or scroll the list) to locate the **zookeeper** collector.
5. Click the **+** next to the **zookeeper** collector to add a new job.
6. Fill in the job fields, then click **Test** to verify the configuration and **Submit** to save.
    - **Test** runs the job with the provided settings and shows whether data can be collected.
    - If it fails, an error message appears with details (for example, connection refused, timeout, or command execution errors), so you can adjust and retest.


#### via File

The configuration file name for this integration is `go.d/zookeeper.conf`.

The file format is YAML. Generally, the structure is:

```yaml
update_every: 1
autodetection_retry: 0
jobs:
  - name: some_name1
  - name: some_name2
```
You can edit the configuration file using the [`edit-config`](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#edit-a-configuration-file-using-edit-config) script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config go.d/zookeeper.conf
```

##### Examples

###### Basic

Local server.

<details open><summary>Config</summary>

```yaml
jobs:
  - name: local
    address: 127.0.0.1:2181

```
</details>

###### TLS with self-signed certificate

Zookeeper with TLS and self-signed certificate.

<details open><summary>Config</summary>

```yaml
jobs:
  - name: local
    address: 127.0.0.1:2181
    use_tls: yes
    tls_skip_verify: yes

```
</details>

###### Multi-instance

> **Note**: When you define multiple jobs, their names must be unique.

Collecting metrics from local and remote instances.


<details open><summary>Config</summary>

```yaml
jobs:
  - name: local
    address: 127.0.0.1:2181

  - name: remote
    address: 192.0.2.1:2181

```
</details>



## Troubleshooting

### Debug Mode

**Important**: Debug mode is not supported for data collection jobs created via the UI using the Dyncfg feature.

To troubleshoot issues with the `zookeeper` collector, run the `go.d.plugin` with the debug option enabled. The output
should give you clues as to why the collector isn't working.

- Navigate to the `plugins.d` directory, usually at `/usr/libexec/netdata/plugins.d/`. If that's not the case on
  your system, open `netdata.conf` and look for the `plugins` setting under `[directories]`.

  ```bash
  cd /usr/libexec/netdata/plugins.d/
  ```

- Switch to the `netdata` user.

  ```bash
  sudo -u netdata -s
  ```

- Run the `go.d.plugin` to debug the collector:

  ```bash
  ./go.d.plugin -d -m zookeeper
  ```

  To debug a specific job:

  ```bash
  ./go.d.plugin -d -m zookeeper -j jobName
  ```

### Getting Logs

If you're encountering problems with the `zookeeper` collector, follow these steps to retrieve logs and identify potential issues:

- **Run the command** specific to your system (systemd, non-systemd, or Docker container).
- **Examine the output** for any warnings or error messages that might indicate issues.  These messages should provide clues about the root cause of the problem.

#### System with systemd

Use the following command to view logs generated since the last Netdata service restart:

```bash
journalctl _SYSTEMD_INVOCATION_ID="$(systemctl show --value --property=InvocationID netdata)" --namespace=netdata --grep zookeeper
```

#### System without systemd

Locate the collector log file, typically at `/var/log/netdata/collector.log`, and use `grep` to filter for collector's name:

```bash
grep zookeeper /var/log/netdata/collector.log
```

**Note**: This method shows logs from all restarts. Focus on the **latest entries** for troubleshooting current issues.

#### Docker Container

If your Netdata runs in a Docker container named "netdata" (replace if different), use this command:

```bash
docker logs netdata 2>&1 | grep zookeeper
```


