<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/go/plugin/go.d/collector/filecheck/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/go/plugin/go.d/collector/filecheck/metadata.yaml"
sidebar_label: "Files and directories"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/Other"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# Files and directories


<img src="https://netdata.cloud/img/filesystem.svg" width="150"/>


Plugin: go.d.plugin
Module: filecheck

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

This collector monitors the existence, last modification time, and size of arbitrary files and directories on the system.




This collector is supported on all platforms.

This collector supports collecting metrics from multiple instances of this integration, including remote instances.

This collector requires the DAC_READ_SEARCH capability when monitoring files not normally accessible to the Netdata user, but it is set automatically during installation, so no manual configuration is needed.


### Default Behavior

#### Auto-Detection

This integration doesn't support auto-detection.

#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per file

These metrics refer to the File.

Labels:

| Label      | Description     |
|:-----------|:----------------|
| file_path | File absolute path |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| filecheck.file_existence_status | exist, not_exist | status |
| filecheck.file_modification_time_ago | mtime_ago | seconds |
| filecheck.file_size_bytes | size | bytes |

### Per directory

These metrics refer to the Directory.

Labels:

| Label      | Description     |
|:-----------|:----------------|
| dir_path | Directory absolute path |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| filecheck.dir_existence_status | exist, not_exist | status |
| filecheck.dir_modification_time_ago | mtime_ago | seconds |
| filecheck.dir_size_bytes | size | bytes |
| filecheck.dir_files count | files | files |



## Alerts

There are no alerts configured by default for this integration.


## Setup

### Prerequisites

No action required.

### Configuration

#### File

The configuration file name for this integration is `go.d/filecheck.conf`.

The file format is YAML. Generally, the structure is:

```yaml
update_every: 1
autodetection_retry: 0
jobs:
  - name: some_name1
  - name: some_name1
```
You can edit the configuration file using the [`edit-config`](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#edit-a-configuration-file-using-edit-config) script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config go.d/filecheck.conf
```
#### Options

The following options can be defined globally: update_every, autodetection_retry.


<details open><summary>Config options</summary>

| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| update_every | Data collection frequency. | 10 | no |
| autodetection_retry | Recheck interval in seconds. Zero means no recheck will be scheduled. | 0 | no |
| files | List of files to monitor. |  | yes |
| dirs | List of directories to monitor. |  | yes |
| discovery_every | Files and directories discovery interval. | 60 | no |

##### files

Files matching the selector will be monitored.

- Logic: (pattern1 OR pattern2) AND !(pattern3 or pattern4)
- Pattern syntax: [shell file name pattern](https://golang.org/pkg/path/filepath/#Match)
- Syntax:

```yaml
files:
  includes:
    - pattern1
    - pattern2
  excludes:
    - pattern3
    - pattern4
```


##### dirs

Directories matching the selector will be monitored.

- Logic: (pattern1 OR pattern2) AND !(pattern3 or pattern4)
- Pattern syntax: [shell file name pattern](https://golang.org/pkg/path/filepath/#Match)
- Syntax:

```yaml
dirs:
  includes:
    - pattern1
    - pattern2
  excludes:
    - pattern3
    - pattern4
```


</details>

#### Examples

##### Files

Files monitoring example configuration.

<details open><summary>Config</summary>

```yaml
jobs:
  - name: files_example
    files:
      include:
        - '/path/to/file1'
        - '/path/to/file2'
        - '/path/to/*.log'

```
</details>

##### Directories

Directories monitoring example configuration.

<details open><summary>Config</summary>

```yaml
jobs:
  - name: files_example
    dirs:
      collect_dir_size: no
      include:
        - '/path/to/dir1'
        - '/path/to/dir2'
        - '/path/to/dir3*'

```
</details>



## Troubleshooting

### Debug Mode

**Important**: Debug mode is not supported for data collection jobs created via the UI using the Dyncfg feature.

To troubleshoot issues with the `filecheck` collector, run the `go.d.plugin` with the debug option enabled. The output
should give you clues as to why the collector isn't working.

- Navigate to the `plugins.d` directory, usually at `/usr/libexec/netdata/plugins.d/`. If that's not the case on
  your system, open `netdata.conf` and look for the `plugins` setting under `[directories]`.

  ```bash
  cd /usr/libexec/netdata/plugins.d/
  ```

- Switch to the `netdata` user.

  ```bash
  sudo -u netdata -s
  ```

- Run the `go.d.plugin` to debug the collector:

  ```bash
  ./go.d.plugin -d -m filecheck
  ```

### Getting Logs

If you're encountering problems with the `filecheck` collector, follow these steps to retrieve logs and identify potential issues:

- **Run the command** specific to your system (systemd, non-systemd, or Docker container).
- **Examine the output** for any warnings or error messages that might indicate issues.  These messages should provide clues about the root cause of the problem.

#### System with systemd

Use the following command to view logs generated since the last Netdata service restart:

```bash
journalctl _SYSTEMD_INVOCATION_ID="$(systemctl show --value --property=InvocationID netdata)" --namespace=netdata --grep filecheck
```

#### System without systemd

Locate the collector log file, typically at `/var/log/netdata/collector.log`, and use `grep` to filter for collector's name:

```bash
grep filecheck /var/log/netdata/collector.log
```

**Note**: This method shows logs from all restarts. Focus on the **latest entries** for troubleshooting current issues.

#### Docker Container

If your Netdata runs in a Docker container named "netdata" (replace if different), use this command:

```bash
docker logs netdata 2>&1 | grep filecheck
```


