/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl.resolution;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.internal.impl.resolution.ArtifactResolverPostProcessorSupport;
import org.eclipse.aether.repository.ArtifactRepository;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.spi.checksums.TrustedChecksumsSource;
import org.eclipse.aether.spi.connector.checksum.ChecksumAlgorithmFactory;
import org.eclipse.aether.spi.connector.checksum.ChecksumAlgorithmFactorySelector;
import org.eclipse.aether.spi.connector.checksum.ChecksumAlgorithmHelper;
import org.eclipse.aether.transfer.ChecksumFailureException;
import org.eclipse.aether.util.ConfigUtils;
import org.eclipse.aether.util.artifact.ArtifactIdUtils;

@Singleton
@Named(value="trustedChecksums")
public final class TrustedChecksumsArtifactResolverPostProcessor
extends ArtifactResolverPostProcessorSupport {
    public static final String NAME = "trustedChecksums";
    private static final String CONFIG_PROPS_PREFIX = "aether.artifactResolver.postProcessor.trustedChecksums.";
    public static final String CONFIG_PROP_ENABLED = "aether.artifactResolver.postProcessor.trustedChecksums";
    public static final String CONFIG_PROP_CHECKSUM_ALGORITHMS = "aether.artifactResolver.postProcessor.trustedChecksums.checksumAlgorithms";
    public static final String DEFAULT_CHECKSUM_ALGORITHMS = "SHA-1";
    public static final String CONFIG_PROP_FAIL_IF_MISSING = "aether.artifactResolver.postProcessor.trustedChecksums.failIfMissing";
    public static final String CONFIG_PROP_SNAPSHOTS = "aether.artifactResolver.postProcessor.trustedChecksums.snapshots";
    public static final String CONFIG_PROP_RECORD = "aether.artifactResolver.postProcessor.trustedChecksums.record";
    private static final String CHECKSUM_ALGORITHMS_CACHE_KEY = TrustedChecksumsArtifactResolverPostProcessor.class.getName() + ".checksumAlgorithms";
    private final ChecksumAlgorithmFactorySelector checksumAlgorithmFactorySelector;
    private final Map<String, TrustedChecksumsSource> trustedChecksumsSources;

    @Inject
    public TrustedChecksumsArtifactResolverPostProcessor(ChecksumAlgorithmFactorySelector checksumAlgorithmFactorySelector, Map<String, TrustedChecksumsSource> trustedChecksumsSources) {
        this.checksumAlgorithmFactorySelector = Objects.requireNonNull(checksumAlgorithmFactorySelector);
        this.trustedChecksumsSources = Objects.requireNonNull(trustedChecksumsSources);
    }

    @Override
    protected boolean isEnabled(RepositorySystemSession session) {
        return ConfigUtils.getBoolean((RepositorySystemSession)session, (boolean)false, (String[])new String[]{CONFIG_PROP_ENABLED});
    }

    @Override
    protected void doPostProcess(RepositorySystemSession session, List<ArtifactResult> artifactResults) {
        List checksumAlgorithms = (List)session.getData().computeIfAbsent((Object)CHECKSUM_ALGORITHMS_CACHE_KEY, () -> this.checksumAlgorithmFactorySelector.selectList((Collection)ConfigUtils.parseCommaSeparatedUniqueNames((String)ConfigUtils.getString((RepositorySystemSession)session, (String)DEFAULT_CHECKSUM_ALGORITHMS, (String[])new String[]{CONFIG_PROP_CHECKSUM_ALGORITHMS}))));
        boolean failIfMissing = ConfigUtils.getBoolean((RepositorySystemSession)session, (boolean)false, (String[])new String[]{CONFIG_PROP_FAIL_IF_MISSING});
        boolean record = ConfigUtils.getBoolean((RepositorySystemSession)session, (boolean)false, (String[])new String[]{CONFIG_PROP_RECORD});
        boolean snapshots = ConfigUtils.getBoolean((RepositorySystemSession)session, (boolean)false, (String[])new String[]{CONFIG_PROP_SNAPSHOTS});
        for (ArtifactResult artifactResult : artifactResults) {
            if (artifactResult.getRequest().getArtifact().isSnapshot() && !snapshots || !artifactResult.isResolved()) continue;
            if (record) {
                this.recordArtifactChecksums(session, artifactResult, checksumAlgorithms);
                continue;
            }
            if (this.validateArtifactChecksums(session, artifactResult, checksumAlgorithms, failIfMissing)) continue;
            artifactResult.setArtifact(artifactResult.getArtifact().setPath(null));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void recordArtifactChecksums(RepositorySystemSession session, ArtifactResult artifactResult, List<ChecksumAlgorithmFactory> checksumAlgorithmFactories) {
        Artifact artifact = artifactResult.getArtifact();
        ArtifactRepository artifactRepository = artifactResult.getRepository();
        try {
            Map calculatedChecksums = ChecksumAlgorithmHelper.calculate((Path)artifact.getPath(), checksumAlgorithmFactories);
            for (TrustedChecksumsSource trustedChecksumsSource : this.trustedChecksumsSources.values()) {
                TrustedChecksumsSource.Writer writer = trustedChecksumsSource.getTrustedArtifactChecksumsWriter(session);
                if (writer == null) continue;
                try {
                    writer.addTrustedArtifactChecksums(artifact, artifactRepository, checksumAlgorithmFactories, calculatedChecksums);
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Could not write required checksums for " + artifact.getPath(), e);
                    return;
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Could not calculate required checksums for " + artifact.getPath(), e);
        }
    }

    private boolean validateArtifactChecksums(RepositorySystemSession session, ArtifactResult artifactResult, List<ChecksumAlgorithmFactory> checksumAlgorithmFactories, boolean failIfMissing) {
        Artifact artifact = artifactResult.getArtifact();
        ArtifactRepository artifactRepository = artifactResult.getRepository();
        boolean valid = true;
        boolean validated = false;
        try {
            Map calculatedChecksums = ChecksumAlgorithmHelper.calculate((Path)artifact.getPath(), checksumAlgorithmFactories);
            for (Map.Entry<String, TrustedChecksumsSource> entry : this.trustedChecksumsSources.entrySet()) {
                String trustedSourceName = entry.getKey();
                TrustedChecksumsSource trustedChecksumsSource = entry.getValue();
                Map trustedChecksums = trustedChecksumsSource.getTrustedArtifactChecksums(session, artifact, artifactRepository, checksumAlgorithmFactories);
                if (trustedChecksums == null) continue;
                validated = true;
                if (calculatedChecksums.equals(trustedChecksums)) continue;
                HashSet missingTrustedAlg = new HashSet(calculatedChecksums.keySet());
                missingTrustedAlg.removeAll(trustedChecksums.keySet());
                if (!missingTrustedAlg.isEmpty() && failIfMissing) {
                    artifactResult.addException(artifactRepository, (Exception)new ChecksumFailureException("Missing from " + trustedSourceName + " trusted checksum(s) " + missingTrustedAlg + " for artifact " + ArtifactIdUtils.toId((Artifact)artifact)));
                    valid = false;
                }
                for (ChecksumAlgorithmFactory checksumAlgorithmFactory : checksumAlgorithmFactories) {
                    String calculatedChecksum = (String)calculatedChecksums.get(checksumAlgorithmFactory.getName());
                    String trustedChecksum = (String)trustedChecksums.get(checksumAlgorithmFactory.getName());
                    if (trustedChecksum == null || Objects.equals(calculatedChecksum, trustedChecksum)) continue;
                    artifactResult.addException(artifactRepository, (Exception)new ChecksumFailureException("Artifact " + ArtifactIdUtils.toId((Artifact)artifact) + " trusted checksum mismatch: " + trustedSourceName + "=" + trustedChecksum + "; calculated=" + calculatedChecksum));
                    valid = false;
                }
            }
            if (!validated && failIfMissing) {
                artifactResult.addException(artifactRepository, (Exception)new ChecksumFailureException("There are no enabled trusted checksums source(s) to validate against."));
                valid = false;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return valid;
    }
}

