/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl.filter;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.Objects;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.spi.connector.filter.RemoteRepositoryFilter;
import org.eclipse.aether.spi.connector.filter.RemoteRepositoryFilterSource;
import org.eclipse.aether.util.DirectoryUtils;

public abstract class RemoteRepositoryFilterSourceSupport
implements RemoteRepositoryFilterSource {
    protected static final String CONFIG_PROPS_PREFIX = "aether.remoteRepositoryFilter.";

    protected abstract boolean isEnabled(RepositorySystemSession var1);

    protected Path getBasedir(RepositorySystemSession session, String defaultValue, String configPropKey, boolean mayCreate) {
        try {
            return DirectoryUtils.resolveDirectory((RepositorySystemSession)session, (String)defaultValue, (String)configPropKey, (boolean)mayCreate);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    protected static class SimpleResult
    implements RemoteRepositoryFilter.Result {
        private final boolean accepted;
        private final String reasoning;

        public SimpleResult(boolean accepted, String reasoning) {
            this.accepted = accepted;
            this.reasoning = Objects.requireNonNull(reasoning);
        }

        public boolean isAccepted() {
            return this.accepted;
        }

        public String reasoning() {
            return this.reasoning;
        }
    }
}

