/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.model.Contributor;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputLocationTracker;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class Developer
extends Contributor
implements Serializable,
InputLocationTracker {
    final String id;

    protected Developer(Builder builder) {
        super(builder);
        this.id = builder.id != null ? builder.id : (builder.base != null ? builder.base.id : null);
    }

    public String getId() {
        return this.id;
    }

    @Override
    @Nonnull
    public Builder with() {
        return Developer.newBuilder(this);
    }

    @Override
    @Nonnull
    public Developer withName(String name) {
        return Developer.newBuilder(this, true).name(name).build();
    }

    @Override
    @Nonnull
    public Developer withEmail(String email) {
        return Developer.newBuilder(this, true).email(email).build();
    }

    @Override
    @Nonnull
    public Developer withUrl(String url) {
        return Developer.newBuilder(this, true).url(url).build();
    }

    @Override
    @Nonnull
    public Developer withOrganization(String organization) {
        return Developer.newBuilder(this, true).organization(organization).build();
    }

    @Override
    @Nonnull
    public Developer withOrganizationUrl(String organizationUrl) {
        return Developer.newBuilder(this, true).organizationUrl(organizationUrl).build();
    }

    @Override
    @Nonnull
    public Developer withRoles(Collection<String> roles) {
        return ((Builder)Developer.newBuilder(this, true).roles((Collection)roles)).build();
    }

    @Override
    @Nonnull
    public Developer withTimezone(String timezone) {
        return Developer.newBuilder(this, true).timezone(timezone).build();
    }

    @Override
    @Nonnull
    public Developer withProperties(Map<String, String> properties) {
        return ((Builder)Developer.newBuilder(this, true).properties((Map)properties)).build();
    }

    @Nonnull
    public Developer withId(String id) {
        return Developer.newBuilder(this, true).id(id).build();
    }

    @Nonnull
    public static Developer newInstance() {
        return Developer.newInstance(true);
    }

    @Nonnull
    public static Developer newInstance(boolean withDefaults) {
        return Developer.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return Developer.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(Developer from) {
        return Developer.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(Developer from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    @Override
    public String toString() {
        return "Developer {id=" + this.getId() + ", " + super.toString() + "}";
    }

    @NotThreadSafe
    public static class Builder
    extends Contributor.Builder {
        Developer base;
        String id;

        protected Builder(boolean withDefaults) {
            super(withDefaults);
            if (withDefaults) {
                // empty if block
            }
        }

        protected Builder(Developer base, boolean forceCopy) {
            super(base, forceCopy);
            if (forceCopy) {
                this.id = base.id;
                this.locations = base.locations;
                this.importedFrom = base.importedFrom;
            } else {
                this.base = base;
            }
        }

        @Override
        @Nonnull
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        @Nonnull
        public Builder email(String email) {
            this.email = email;
            return this;
        }

        @Override
        @Nonnull
        public Builder url(String url) {
            this.url = url;
            return this;
        }

        @Override
        @Nonnull
        public Builder organization(String organization) {
            this.organization = organization;
            return this;
        }

        @Override
        @Nonnull
        public Builder organizationUrl(String organizationUrl) {
            this.organizationUrl = organizationUrl;
            return this;
        }

        @Override
        @Nonnull
        public Builder roles(Collection<String> roles) {
            this.roles = roles;
            return this;
        }

        @Override
        @Nonnull
        public Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        @Override
        @Nonnull
        public Builder properties(Map<String, String> properties) {
            this.properties = properties;
            return this;
        }

        @Nonnull
        public Builder id(String id) {
            this.id = id;
            return this;
        }

        @Override
        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap(this.locations) : new HashMap();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Override
        @Nonnull
        public Builder importedFrom(InputLocation importedFrom) {
            this.importedFrom = importedFrom;
            return this;
        }

        @Override
        @Nonnull
        public Developer build() {
            if (!(this.base == null || this.name != null && this.name != this.base.name || this.email != null && this.email != this.base.email || this.url != null && this.url != this.base.url || this.organization != null && this.organization != this.base.organization || this.organizationUrl != null && this.organizationUrl != this.base.organizationUrl || this.roles != null && this.roles != this.base.roles || this.timezone != null && this.timezone != this.base.timezone || this.properties != null && this.properties != this.base.properties || this.id != null && this.id != this.base.id)) {
                return this.base;
            }
            return new Developer(this);
        }
    }
}

