/*
 * Decompiled with CFR 0.152.
 */
package org.mvndaemon.mvnd.common.logging;

import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.jline.terminal.Terminal;
import org.mvndaemon.mvnd.common.Message;

public class TerminalInputHandler
implements AutoCloseable {
    private final Terminal terminal;
    private final BlockingQueue<InputRequest> inputRequests;
    private volatile boolean closing;
    private final Thread inputThread;
    private final boolean dumb;
    private volatile int maxThreads;
    private volatile Consumer<Message> daemonDispatch;
    private volatile Consumer<Message> daemonReceive;

    public TerminalInputHandler(Terminal terminal, boolean dumb) {
        this.terminal = terminal;
        this.inputRequests = new LinkedBlockingQueue<InputRequest>();
        this.dumb = dumb;
        this.inputThread = new Thread(() -> {
            try {
                while (!this.closing) {
                    InputRequest request = this.inputRequests.poll(10L, TimeUnit.MILLISECONDS);
                    if (request == null) {
                        if (dumb) continue;
                        this.handleControlKeys();
                        continue;
                    }
                    if (request.prompt != null) {
                        this.handlePrompt(request.prompt);
                        continue;
                    }
                    if (request.projectId != null) {
                        this.handleProjectInput(request.projectId, request.bytesToRead);
                        continue;
                    }
                    if (dumb || !request.isControlKey) continue;
                    this.handleControlKeys();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
        this.inputThread.setDaemon(true);
        this.inputThread.start();
    }

    private void handleProjectInput(String projectId, int bytesToRead) throws IOException {
        if (this.daemonReceive == null) {
            return;
        }
        char[] buf = bytesToRead > 0 ? new char[bytesToRead] : new char[8192];
        int idx = 0;
        int timeout = 10;
        while ((bytesToRead < 0 || idx < bytesToRead) && idx < buf.length) {
            int c = this.terminal.reader().read((long)timeout);
            if (c < 0) {
                this.daemonReceive.accept(Message.inputEof());
                break;
            }
            buf[idx++] = (char)c;
            timeout = idx > 0 ? 1 : 10;
        }
        if (idx > 0) {
            String data = String.valueOf(buf, 0, idx);
            this.daemonReceive.accept(Message.inputResponse(data));
        }
    }

    private void handleControlKeys() throws IOException {
        if (this.daemonReceive == null) {
            return;
        }
        int c = this.terminal.reader().read(10L);
        if (c != -1 && this.isControlKey(c)) {
            this.daemonReceive.accept(Message.keyboardInput((char)c));
        }
    }

    private void handlePrompt(Message.Prompt prompt) throws IOException {
        int c;
        if (this.daemonDispatch == null) {
            return;
        }
        if (prompt.getMessage() != null) {
            String msg = this.formatPromptMessage(prompt);
            this.terminal.writer().print(msg);
        }
        this.terminal.flush();
        StringBuilder sb = new StringBuilder();
        while ((c = this.terminal.reader().read()) >= 0) {
            if (c == 10 || c == 13) {
                this.terminal.writer().println();
                this.daemonDispatch.accept(prompt.response(sb.toString()));
                break;
            }
            if (c == 127) {
                if (sb.length() <= 0) continue;
                sb.setLength(sb.length() - 1);
                this.terminal.writer().write("\b \b");
                this.terminal.writer().flush();
                continue;
            }
            this.terminal.writer().print((char)c);
            this.terminal.writer().flush();
            sb.append((char)c);
        }
        if (!this.dumb) {
            this.inputRequests.offer(InputRequest.forControlKeys());
        }
    }

    private boolean isControlKey(int c) {
        return c == 43 || c == 45 || c == 12 || c == 13 || c == 2;
    }

    private String formatPromptMessage(Message.Prompt prompt) {
        return this.maxThreads > 1 ? String.format("[%s] %s", prompt.getProjectId(), prompt.getMessage()) : prompt.getMessage();
    }

    public void setDaemonDispatch(Consumer<Message> daemonDispatch) {
        this.daemonDispatch = daemonDispatch;
    }

    public void setDaemonReceive(Consumer<Message> daemonReceive) {
        this.daemonReceive = daemonReceive;
    }

    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
    }

    public void requestProjectInput(String projectId, int bytesToRead) {
        this.inputRequests.clear();
        this.inputRequests.offer(InputRequest.forProject(projectId, bytesToRead));
    }

    public void requestPrompt(Message.Prompt prompt) {
        this.inputRequests.clear();
        this.inputRequests.offer(InputRequest.forPrompt(prompt));
    }

    @Override
    public void close() {
        this.closing = true;
        if (this.inputThread != null) {
            this.inputThread.interrupt();
        }
    }

    private static class InputRequest {
        final String projectId;
        final Message.Prompt prompt;
        final boolean isControlKey;
        final int bytesToRead;

        private InputRequest(String projectId, Message.Prompt prompt, boolean isControlKey, int bytesToRead) {
            this.projectId = projectId;
            this.prompt = prompt;
            this.isControlKey = isControlKey;
            this.bytesToRead = bytesToRead;
        }

        static InputRequest forProject(String projectId, int bytesToRead) {
            return new InputRequest(projectId, null, false, bytesToRead);
        }

        static InputRequest forPrompt(Message.Prompt prompt) {
            return new InputRequest(prompt.getProjectId(), prompt, false, 0);
        }

        static InputRequest forControlKeys() {
            return new InputRequest(null, null, true, 0);
        }
    }
}

