/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.named.providers;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.named.NamedLock;
import org.eclipse.aether.named.NamedLockKey;
import org.eclipse.aether.named.support.FileLockNamedLock;
import org.eclipse.aether.named.support.NamedLockFactorySupport;
import org.eclipse.aether.named.support.NamedLockSupport;
import org.eclipse.aether.named.support.Retry;

@Singleton
@Named(value="file-lock")
public class FileLockNamedLockFactory
extends NamedLockFactorySupport {
    public static final String NAME = "file-lock";
    private static final boolean IS_WINDOWS = System.getProperty("os.name", "unknown").startsWith("Windows");
    public static final String SYSTEM_PROP_DELETE_LOCK_FILES = "aether.named.file-lock.deleteLockFiles";
    private static final boolean DELETE_LOCK_FILES = Boolean.parseBoolean(System.getProperty("aether.named.file-lock.deleteLockFiles", Boolean.toString(!IS_WINDOWS)));
    public static final String SYSTEM_PROP_ATTEMPTS = "aether.named.file-lock.attempts";
    private static final int ATTEMPTS = Integer.parseInt(System.getProperty("aether.named.file-lock.attempts", "5"));
    public static final String SYSTEM_PROP_SLEEP_MILLIS = "aether.named.file-lock.sleepMillis";
    private static final long SLEEP_MILLIS = Long.parseLong(System.getProperty("aether.named.file-lock.sleepMillis", "50"));
    private final ConcurrentMap<NamedLockKey, FileChannel> fileChannels = new ConcurrentHashMap<NamedLockKey, FileChannel>();

    @Override
    protected NamedLockSupport createLock(NamedLockKey key) {
        Path path = Paths.get(URI.create(key.name()));
        FileChannel fileChannel = this.fileChannels.computeIfAbsent(key, k -> {
            try {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                FileChannel channel = Retry.retry(ATTEMPTS, SLEEP_MILLIS, () -> {
                    if (DELETE_LOCK_FILES) {
                        return FileChannel.open(path, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.DELETE_ON_CLOSE);
                    }
                    return FileChannel.open(path, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
                }, null, null);
                if (channel == null) {
                    throw new IllegalStateException("Could not open file channel for '" + key + "' after " + ATTEMPTS + " attempts; giving up");
                }
                return channel;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Interrupted while opening file channel for '" + key + "'", e);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to open file channel for '" + key + "'", e);
            }
        });
        return new FileLockNamedLock(key, fileChannel, this);
    }

    @Override
    protected void destroyLock(NamedLock namedLock) {
        if (namedLock instanceof FileLockNamedLock) {
            NamedLockKey key = namedLock.key();
            FileChannel fileChannel = (FileChannel)this.fileChannels.remove(key);
            if (fileChannel == null) {
                throw new IllegalStateException("File channel expected, but does not exist: " + key);
            }
            try {
                fileChannel.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to close file channel for '" + key + "'", e);
            }
        }
    }
}

