/*
 * This file is subject to the terms and conditions defined in
 * file 'LICENSE.txt', which is part of this source code package.
 */

"use strict";(self.webpackChunk=self.webpackChunk||[]).push([["831"],{7146:function(e){e.exports="---\ntitle: PostgreSQL\nredirect_from:\n  - /docs/latest/administration-guide/databases/postgresql\n---\n\n# PostgreSQL\n\n> This page covers connecting to PostgreSQL as a _data warehouse_. For using PostgreSQL as Metabase's _application database_, see [Configuring the Metabase application database](../../installation-and-operation/configuring-application-database.md).\n\nTo add a database connection, click on the **gear** icon in the top right, and navigate to **Admin settings** > **Databases** > **Add a database**.\n\nFill out the fields for that database, and click **Save changes** at the bottom.\n\n## Supported versions\n\nMetabase supports the oldest supported version of PostgreSQL through the latest stable version. See [PostgreSQL versions](https://www.postgresql.org/support/versioning/).\n\n## Connect to Supabase\n\nTo connect to a Supabase database, select PostgreSQL. For more details, check out the [Supabase docs](https://supabase.com/docs/guides/database/metabase).\n\n## Connection and sync\n\nAfter connecting to a database, you'll see the \"Connection and sync\" section that displays the current connection status and options to manage your database connection.\n\nHere you can [sync the database schema and rescan field values](../sync-scan.md), and edit connection details.\n\n## Edit connection details\n\nYou can edit these settings at any time. Just remember to save your changes.\n\n### Connection string\n\nPaste a connection string here to pre-fill the remaining fields below.\n\n### Display name\n\nThe display name for the database in the Metabase interface.\n\n### Host\n\nYour database's IP address, or its domain name (e.g., esc.mydatabase.com).\n\n### Port\n\nThe database port. E.g., 5432.\n\n### Database name\n\nThe name of the database you're connecting to.\n\n### Username\n\nThe database username for the account that you want to use to connect to your database. You can set up multiple connections to the same database using different user accounts to connect to the same database, each with different sets of [privileges](../users-roles-privileges.md).\n\n### Password\n\nThe password for the username that you use to connect to the database.\n\n### Use an authentication provider\n\n{% include plans-blockquote.html feature=\"Authenticating with a provider\" %}\n\nInstead of a password, you can authenticate with a supported provider.\n\nOnly for self-hosted Pro and Enterprise plans.\n\n#### Azure Managed Identity\n\nTo use Azure Managed Identity, you'll need to input your [client ID](https://learn.microsoft.com/en-us/previous-versions/azure/postgresql/single-server/how-to-connect-with-managed-identity#retrieving-the-access-token-from-azure-instance-metadata-service).\n\n#### Oauth\n\nTo use Oauth as a provider, you'll need to input your:\n\n- Auth token URL\n- Auth token request headers (a JSON map)\n\n### Schemas\n\nYou can specify which schemas you want to sync and scan. Options are:\n\n- All\n- Only these...\n- All except...\n\nFor the **Only these** and **All except** options, you can input a comma-separated list of values to tell Metabase which schemas you want to include (or exclude). For example:\n\n```\nfoo,bar,baz\n```\n\nYou can use the `*` wildcard to match multiple schemas.\n\nLet's say you have three schemas: foo, bar, and baz.\n\n- If you have **Only these...** set, and enter the string `b*`, you'll sync with bar and baz.\n- If you have **All except...** set, and enter the string `b*`, you'll just sync foo.\n\nNote that only the `*` wildcard is supported; you can't use other special characters or regexes.\n\n### Use a secure connection (SSL)\n\nMetabase automatically tries to connect to databases with SSL first, then without if that doesn't work. If it's possible to connect to your database with an SSL connection, Metabase will make that the default setting for your database. If you prefer to connect without this layer of security, you can always change this setting later, but we recommend keeping SSL turned on to keep your data secure.\n\n#### SSL Mode\n\nPostgreSQL databases support different levels of security with their connections, with different levels of overhead.\n\nSSL Mode options include:\n\n- allow\n- prefer\n- require\n- verify-ca\n- verify-full\n\nSee the PostgreSQL docs for a table about the different [SSL Modes](https://jdbc.postgresql.org/documentation/ssl/#configuring-the-client), and select the option that works for you.\n\n#### SSL root certificate (PEM)\n\nIf you set the SSL Mode to either \"verify-ca\" or \"verify-full\", you'll need to specify a root certificate (PEM). You have the option of using a **Local file path** or an **Uploaded file path**. If you're on Metabase Cloud, you'll need to select **Uploaded file path** and upload your certificate.\n\n#### Authenticate client certificate\n\nToggle on to bring up client certificate options.\n\n#### SSL Client Certificate (PEM)\n\nYou have the option of using a **Local file path** or an **Uploaded file path**. If you're on Metabase Cloud, you'll need to select **Uploaded file path** and upload your certificate.\n\n#### SSL Client Key (PKCS-8/DER)\n\nAgain, you have the option of using a **Local file path** or an **Uploaded file path**. If you're on Metabase Cloud, you'll need to select **Uploaded file path** and upload your certificate. You'll also need to input your **SSL Client Key Password**.\n\nThe private key must be PKCS8 and stored in DER format.\n\nIf you instead have a PEM SSL client key, you can convert that key to the PKCS-8/DER format using [openssl](https://www.openssl.org/). The command would look something like:\n\n```\nopenssl pkcs8 -topk8 -inform PEM -outform DER -in client-key.pem -out client-key.der -nocrypt\n```\n\nNote: if you're using GCP and you managed to issue client certificates, everything will be given in PEM format, you only need to transform the client-key.pem into a client-key.der for the \"SSL Client Key\"\n\n### Use an SSH tunnel\n\nSee our [guide to SSH tunneling](../ssh-tunnel.md).\n\n### Unfold JSON Columns\n\nFor PostgreSQL databases, Metabase can unfold JSON columns into component fields to yield a table where each JSON key becomes a column. JSON unfolding is on by default, but you can turn off JSON unfolding if performance is slow.\n\nIf you turn on JSON unfolding, you can also toggle the unfolding for individual columns in [table metadata](../../data-modeling/metadata-editing.md#unfold-json).\n\n### Additional JDBC connection string options\n\nYou can append options to the connection string that Metabase uses to connect to your database. Use the format:\n\n```\noptions=-c%20key=value\n```\n\nPostgreSQL connection URIs expect [percent-encoding](https://developer.mozilla.org/en-US/docs/Glossary/Percent-encoding) for whitespaces and symbols.\n\n### Re-run queries for simple explorations\n\nTurn this option **OFF** if people want to click **Run** (the play button) before applying any [Summarize](../../questions/query-builder/summarizing-and-grouping.md) or filter selections.\n\nBy default, Metabase will execute a query as soon as you choose an grouping option from the **Summarize** menu or a filter condition from the [drill-through menu](https://www.metabase.com/learn/metabase-basics/querying-and-dashboards/questions/drill-through). If your database is slow, you may want to disable re-running to avoid loading data on each click.\n\n### Choose when syncs and scans happen\n\nSee [syncs and scans](../sync-scan.md#choose-when-syncs-and-scans-happen).\n\n### Periodically refingerprint tables\n\n> Periodic refingerprinting will increase the load on your database.\n\nTurn this option **ON** to scan a sample of values every time Metabase runs a [sync](../sync-scan.md#how-database-syncs-work).\n\nA fingerprinting query examines the first 10,000 rows from each column and uses that data to guesstimate how many unique values each column has, what the minimum and maximum values are for numeric and timestamp columns, and so on. If you leave this option **OFF**, Metabase will only fingerprint your columns once during setup.\n\n## Model features\n\nChoose whether to enable features related to [Metabase models](../../data-modeling/models.md). These features will often require that the database user account, the one you use to connect to your database, has both read and write privileges.\n\n### Model actions\n\nTurn this setting on to allow [actions](../../actions/introduction.md) from models created from this data to be run. Actions can read, write, and delete data. Your database user will need write permissions.\n\n### Model persistence\n\nWe'll create tables with model data and refresh them on a schedule you define. To enable [model persistence](../../data-modeling/model-persistence.md), you need to grant this connection's credentials read and write permissions on a schema Metabase provides.\n\n## Editable table data\n\nTurn this setting **ON** to enable editing of table data directly within Metabase. When enabled, Admins can create, update, and delete records in your tables through Metabase's interface.\n\nYour database connection will need Write permissions to enable this feature. Meaning: the database user account that you use to connect Metabase to your database must have appropriate privileges to modify data in the tables you want to make editable.\n\nSee [privileges](../users-roles-privileges.md).\n\n## Database routing\n\nWith database routing, an admin can build a question once using one database, and the question will run its query against a different database with the same schema depending on who is viewing the question.\n\nSee [Database routing](../../permissions/database-routing.md).\n\n## Danger zone\n\nSee [Danger zone](../danger-zone.md).\n\n## Further reading\n\n- [Managing databases](../../databases/connecting.md)\n- [Metadata editing](../../data-modeling/metadata-editing.md)\n- [Models](../../data-modeling/models.md)\n- [Setting data access permissions](../../permissions/data.md)\n"}}]);