/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cling.invoker.mvnup.goals;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.maven.api.cli.mvnup.UpgradeOptions;
import org.apache.maven.api.di.Named;
import org.apache.maven.api.di.Priority;
import org.apache.maven.api.di.Singleton;
import org.apache.maven.cling.invoker.mvnup.UpgradeContext;
import org.apache.maven.cling.invoker.mvnup.goals.AbstractUpgradeStrategy;
import org.apache.maven.cling.invoker.mvnup.goals.GAV;
import org.apache.maven.cling.invoker.mvnup.goals.GAVUtils;
import org.apache.maven.cling.invoker.mvnup.goals.ModelVersionUtils;
import org.apache.maven.cling.invoker.mvnup.goals.UpgradeResult;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.Text;

@Named
@Singleton
@Priority(value=30)
public class InferenceStrategy
extends AbstractUpgradeStrategy {
    @Override
    public boolean isApplicable(UpgradeContext context) {
        UpgradeOptions options = this.getOptions(context);
        boolean useAll = options.all().orElse(false);
        if (useAll) {
            return true;
        }
        if (options.infer().isPresent()) {
            return (Boolean)options.infer().get();
        }
        return options.infer().isEmpty() && options.model().isEmpty() && options.plugins().isEmpty() && options.modelVersion().isEmpty();
    }

    @Override
    public String getDescription() {
        return "Applying Maven inference optimizations";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpgradeResult doApply(UpgradeContext context, Map<Path, Document> pomMap) {
        HashSet<Path> processedPoms = new HashSet<Path>();
        HashSet<Path> modifiedPoms = new HashSet<Path>();
        HashSet<Path> errorPoms = new HashSet<Path>();
        Set<GAV> allGAVs = GAVUtils.computeAllGAVs(context, pomMap);
        for (Map.Entry<Path, Document> entry : pomMap.entrySet()) {
            Path pomPath = entry.getKey();
            Document pomDocument = entry.getValue();
            processedPoms.add(pomPath);
            String currentVersion = ModelVersionUtils.detectModelVersion(pomDocument);
            context.info(String.valueOf(pomPath) + " (current: " + currentVersion + ")");
            context.indent();
            try {
                if (!ModelVersionUtils.isEligibleForInference(currentVersion)) {
                    context.warning("Model version " + currentVersion + " not eligible for inference (requires >= 4.0.0)");
                    continue;
                }
                boolean hasInferences = false;
                hasInferences |= this.applyLimitedParentInference(context, pomDocument);
                if ("4.1.0".equals(currentVersion) || ModelVersionUtils.isNewerThan410(currentVersion)) {
                    hasInferences |= this.applyFullParentInference(context, pomMap, pomDocument);
                    hasInferences |= this.applyDependencyInference(context, allGAVs, pomDocument);
                    hasInferences |= this.applyDependencyInferenceRedundancy(context, pomMap, pomDocument);
                    hasInferences |= this.applySubprojectsInference(context, pomDocument, pomPath);
                    hasInferences |= this.applyModelVersionInference(context, pomDocument);
                }
                if (hasInferences) {
                    modifiedPoms.add(pomPath);
                    if ("4.1.0".equals(currentVersion) || ModelVersionUtils.isNewerThan410(currentVersion)) {
                        context.success("Full inference optimizations applied");
                        continue;
                    }
                    context.success("Limited inference optimizations applied (parent-related only)");
                    continue;
                }
                context.success("No inference optimizations needed");
            }
            catch (Exception e) {
                context.failure("Failed to apply inference optimizations: " + e.getMessage());
                errorPoms.add(pomPath);
            }
            finally {
                context.unindent();
            }
        }
        return new UpgradeResult(processedPoms, modifiedPoms, errorPoms);
    }

    private boolean applyLimitedParentInference(UpgradeContext context, Document pomDocument) {
        Namespace namespace;
        Element root = pomDocument.getRootElement();
        Element parentElement = root.getChild("parent", namespace = root.getNamespace());
        if (parentElement == null) {
            return false;
        }
        return this.trimParentElementLimited(context, root, parentElement, namespace);
    }

    private boolean applyFullParentInference(UpgradeContext context, Map<Path, Document> pomMap, Document pomDocument) {
        Namespace namespace;
        Element root = pomDocument.getRootElement();
        Element parentElement = root.getChild("parent", namespace = root.getNamespace());
        if (parentElement == null) {
            return false;
        }
        return this.trimParentElementFull(context, root, parentElement, namespace, pomMap);
    }

    private boolean applyDependencyInference(UpgradeContext context, Set<GAV> allGAVs, Document pomDocument) {
        Element profilesElement;
        Element dependencies;
        Namespace namespace;
        boolean hasChanges = false;
        Element root = pomDocument.getRootElement();
        Element dependencyManagement = root.getChild("dependencyManagement", namespace = root.getNamespace());
        if (dependencyManagement != null && (dependencies = dependencyManagement.getChild("dependencies", namespace)) != null) {
            hasChanges |= this.removeManagedDependenciesFromSection(context, dependencies, namespace, allGAVs, "dependencyManagement");
        }
        if ((profilesElement = root.getChild("profiles", namespace)) != null) {
            List profileElements = profilesElement.getChildren("profile", namespace);
            for (Element profileElement : profileElements) {
                Element profileDependencies;
                Element profileDependencyManagement = profileElement.getChild("dependencyManagement", namespace);
                if (profileDependencyManagement == null || (profileDependencies = profileDependencyManagement.getChild("dependencies", namespace)) == null) continue;
                hasChanges |= this.removeManagedDependenciesFromSection(context, profileDependencies, namespace, allGAVs, "profile dependencyManagement");
            }
        }
        return hasChanges;
    }

    private boolean applyDependencyInferenceRedundancy(UpgradeContext context, Map<Path, Document> pomMap, Document pomDocument) {
        Element pluginsElement;
        Element buildElement;
        Element profilesElement;
        Element root = pomDocument.getRootElement();
        Namespace namespace = root.getNamespace();
        boolean hasChanges = false;
        Element dependenciesElement = root.getChild("dependencies", namespace);
        if (dependenciesElement != null) {
            hasChanges |= this.removeDependencyInferenceFromSection(context, dependenciesElement, namespace, pomMap, "dependencies");
        }
        if ((profilesElement = root.getChild("profiles", namespace)) != null) {
            List profileElements = profilesElement.getChildren("profile", namespace);
            for (Element profileElement : profileElements) {
                Element profileDependencies = profileElement.getChild("dependencies", namespace);
                if (profileDependencies == null) continue;
                hasChanges |= this.removeDependencyInferenceFromSection(context, profileDependencies, namespace, pomMap, "profile dependencies");
            }
        }
        if ((buildElement = root.getChild("build", namespace)) != null && (pluginsElement = buildElement.getChild("plugins", namespace)) != null) {
            List pluginElements = pluginsElement.getChildren("plugin", namespace);
            for (Element pluginElement : pluginElements) {
                Element pluginDependencies = pluginElement.getChild("dependencies", namespace);
                if (pluginDependencies == null) continue;
                hasChanges |= this.removeDependencyInferenceFromSection(context, pluginDependencies, namespace, pomMap, "plugin dependencies");
            }
        }
        return hasChanges;
    }

    private boolean applySubprojectsInference(UpgradeContext context, Document pomDocument, Path pomPath) {
        Element profilesElement;
        Namespace namespace;
        boolean hasChanges = false;
        Element root = pomDocument.getRootElement();
        Element subprojectsElement = root.getChild("subprojects", namespace = root.getNamespace());
        if (subprojectsElement != null && this.isSubprojectsListRedundant(subprojectsElement, namespace, pomPath)) {
            this.removeElementWithFormatting(subprojectsElement);
            context.detail("Removed: redundant subprojects list (matches direct children)");
            hasChanges = true;
        }
        if ((profilesElement = root.getChild("profiles", namespace)) != null) {
            List profileElements = profilesElement.getChildren("profile", namespace);
            for (Element profileElement : profileElements) {
                Element profileSubprojects = profileElement.getChild("subprojects", namespace);
                if (profileSubprojects == null || !this.isSubprojectsListRedundant(profileSubprojects, namespace, pomPath)) continue;
                this.removeElementWithFormatting(profileSubprojects);
                context.detail("Removed: redundant subprojects list from profile (matches direct children)");
                hasChanges = true;
            }
        }
        return hasChanges;
    }

    private boolean applyModelVersionInference(UpgradeContext context, Document pomDocument) {
        String currentVersion = ModelVersionUtils.detectModelVersion(pomDocument);
        if (("4.1.0".equals(currentVersion) || ModelVersionUtils.isNewerThan410(currentVersion)) && ModelVersionUtils.removeModelVersion(pomDocument)) {
            context.detail("Removed: modelVersion element (can be inferred from namespace)");
            return true;
        }
        return false;
    }

    private boolean trimParentElementLimited(UpgradeContext context, Element root, Element parentElement, Namespace namespace) {
        Element childVersionElement;
        Element childGroupIdElement;
        boolean hasChanges = false;
        String parentGroupId = this.getChildText(parentElement, "groupId", namespace);
        String parentVersion = this.getChildText(parentElement, "version", namespace);
        String childGroupId = this.getChildText(root, "groupId", namespace);
        String childVersion = this.getChildText(root, "version", namespace);
        if (childGroupId != null && Objects.equals(childGroupId, parentGroupId) && (childGroupIdElement = root.getChild("groupId", namespace)) != null) {
            this.removeElementWithFormatting(childGroupIdElement);
            context.detail("Removed: child groupId (matches parent)");
            hasChanges = true;
        }
        if (childVersion != null && Objects.equals(childVersion, parentVersion) && (childVersionElement = root.getChild("version", namespace)) != null) {
            this.removeElementWithFormatting(childVersionElement);
            context.detail("Removed: child version (matches parent)");
            hasChanges = true;
        }
        return hasChanges;
    }

    private boolean trimParentElementFull(UpgradeContext context, Element root, Element parentElement, Namespace namespace, Map<Path, Document> pomMap) {
        Element parentArtifactIdElement;
        Element parentVersionElement;
        Element parentGroupIdElement;
        boolean hasChanges = false;
        hasChanges |= this.trimParentElementLimited(context, root, parentElement, namespace);
        String childGroupId = this.getChildText(root, "groupId", namespace);
        String childVersion = this.getChildText(root, "version", namespace);
        if (childGroupId == null && (parentGroupIdElement = parentElement.getChild("groupId", namespace)) != null) {
            this.removeElementWithFormatting(parentGroupIdElement);
            context.detail("Removed: parent groupId (child has no explicit groupId)");
            hasChanges = true;
        }
        if (childVersion == null && (parentVersionElement = parentElement.getChild("version", namespace)) != null) {
            this.removeElementWithFormatting(parentVersionElement);
            context.detail("Removed: parent version (child has no explicit version)");
            hasChanges = true;
        }
        if (this.canInferParentArtifactId(parentElement, namespace, pomMap) && (parentArtifactIdElement = parentElement.getChild("artifactId", namespace)) != null) {
            this.removeElementWithFormatting(parentArtifactIdElement);
            context.detail("Removed: parent artifactId (can be inferred from relativePath)");
            hasChanges = true;
        }
        return hasChanges;
    }

    private boolean canInferParentArtifactId(Element parentElement, Namespace namespace, Map<Path, Document> pomMap) {
        String relativePath = this.getChildText(parentElement, "relativePath", namespace);
        if (relativePath == null || relativePath.trim().isEmpty()) {
            relativePath = "../pom.xml";
        }
        return "../pom.xml".equals(relativePath) && !pomMap.isEmpty();
    }

    private boolean isSubprojectsListRedundant(Element subprojectsElement, Namespace namespace, Path pomPath) {
        HashSet actualSubprojects;
        HashSet<String> declaredSubprojects;
        block11: {
            List subprojectElements = subprojectsElement.getChildren("subproject", namespace);
            if (subprojectElements.isEmpty()) {
                return true;
            }
            Path parentDir = pomPath.getParent();
            if (parentDir == null) {
                return false;
            }
            declaredSubprojects = new HashSet<String>();
            for (Element subprojectElement : subprojectElements) {
                String subprojectName = subprojectElement.getTextTrim();
                if (subprojectName == null || subprojectName.isEmpty()) continue;
                declaredSubprojects.add(subprojectName);
            }
            actualSubprojects = new HashSet();
            try {
                if (!Files.exists(parentDir, new LinkOption[0]) || !Files.isDirectory(parentDir, new LinkOption[0])) break block11;
                try (Stream<Path> children = Files.list(parentDir);){
                    children.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(dir -> Files.exists(dir.resolve("pom.xml"), new LinkOption[0])).forEach(dir -> actualSubprojects.add(dir.getFileName().toString()));
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return declaredSubprojects.equals(actualSubprojects);
    }

    private boolean removeManagedDependenciesFromSection(UpgradeContext context, Element dependencies, Namespace namespace, Set<GAV> allGAVs, String sectionName) {
        List dependencyElements = dependencies.getChildren("dependency", namespace);
        ArrayList<Element> toRemove = new ArrayList<Element>();
        for (Element dependency : dependencyElements) {
            boolean isProjectArtifact;
            String groupId = this.getChildText(dependency, "groupId", namespace);
            String artifactId = this.getChildText(dependency, "artifactId", namespace);
            if (groupId == null || artifactId == null || !(isProjectArtifact = allGAVs.stream().anyMatch(gav -> Objects.equals(gav.groupId(), groupId) && Objects.equals(gav.artifactId(), artifactId)))) continue;
            toRemove.add(dependency);
            context.detail("Removed: managed dependency " + groupId + ":" + artifactId + " from " + sectionName + " (project artifact)");
        }
        for (Element dependency : toRemove) {
            this.removeElementWithFormatting(dependency);
        }
        return !toRemove.isEmpty();
    }

    private boolean removeDependencyInferenceFromSection(UpgradeContext context, Element dependencies, Namespace namespace, Map<Path, Document> pomMap, String sectionName) {
        List dependencyElements = dependencies.getChildren("dependency", namespace);
        boolean hasChanges = false;
        for (Element dependency : dependencyElements) {
            Element versionElement;
            Element groupIdElement;
            Document dependencyPom;
            String groupId = this.getChildText(dependency, "groupId", namespace);
            String artifactId = this.getChildText(dependency, "artifactId", namespace);
            String version = this.getChildText(dependency, "version", namespace);
            if (artifactId == null || (dependencyPom = this.findDependencyPom(context, pomMap, groupId, artifactId)) == null) continue;
            if (groupId != null && this.canInferDependencyGroupId(context, dependencyPom, groupId) && (groupIdElement = dependency.getChild("groupId", namespace)) != null) {
                this.removeElementWithFormatting(groupIdElement);
                context.detail("Removed: dependency groupId " + groupId + " from " + sectionName + " (can be inferred from project)");
                hasChanges = true;
            }
            if (version == null || !this.canInferDependencyVersion(context, dependencyPom, version) || (versionElement = dependency.getChild("version", namespace)) == null) continue;
            this.removeElementWithFormatting(versionElement);
            context.detail("Removed: dependency version " + version + " from " + sectionName + " (can be inferred from project)");
            hasChanges = true;
        }
        return hasChanges;
    }

    private Document findDependencyPom(UpgradeContext context, Map<Path, Document> pomMap, String groupId, String artifactId) {
        for (Document pomDocument : pomMap.values()) {
            GAV gav = GAVUtils.extractGAVWithParentResolution(context, pomDocument);
            if (gav == null || !Objects.equals(gav.groupId(), groupId) || !Objects.equals(gav.artifactId(), artifactId)) continue;
            return pomDocument;
        }
        return null;
    }

    private boolean canInferDependencyVersion(UpgradeContext context, Document dependencyPom, String declaredVersion) {
        GAV projectGav = GAVUtils.extractGAVWithParentResolution(context, dependencyPom);
        if (projectGav == null || projectGav.version() == null) {
            return false;
        }
        return Objects.equals(declaredVersion, projectGav.version());
    }

    private boolean canInferDependencyGroupId(UpgradeContext context, Document dependencyPom, String declaredGroupId) {
        GAV projectGav = GAVUtils.extractGAVWithParentResolution(context, dependencyPom);
        if (projectGav == null || projectGav.groupId() == null) {
            return false;
        }
        return Objects.equals(declaredGroupId, projectGav.groupId());
    }

    private String getChildText(Element parent, String childName, Namespace namespace) {
        Element child = parent.getChild(childName, namespace);
        return child != null ? child.getTextTrim() : null;
    }

    private void removeElementWithFormatting(Element element) {
        Element parent = element.getParentElement();
        if (parent != null) {
            Text text;
            Content prevContent;
            int index = parent.indexOf((Content)element);
            parent.removeContent((Content)element);
            if (index > 0 && (prevContent = parent.getContent(index - 1)) instanceof Text && (text = (Text)prevContent).getTextTrim().isEmpty()) {
                parent.removeContent(prevContent);
            }
        }
    }
}

